/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.TextRangeUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.ConstantConditionIfUtils;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix.ConstantConditionIfFix;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/ConstantConditionIfInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nConstantConditionIfInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantConditionIfInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/ConstantConditionIfInspection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,27:1\n37#2,2:28\n*S KotlinDebug\n*F\n+ 1 ConstantConditionIfInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/ConstantConditionIfInspection\n*L\n22#1:28,2\n*E\n"})
public final class ConstantConditionIfInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.ifExpressionVisitor(arg_0 -> ConstantConditionIfInspection.buildVisitor$lambda$0(holder2, arg_0));
    }

    private static final Unit buildVisitor$lambda$0(ProblemsHolder $holder, KtIfExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Boolean bl = ConstantConditionIfUtils.INSTANCE.getConditionConstantValueIfAny(expression);
        if (bl == null) {
            return Unit.INSTANCE;
        }
        boolean constantValue = bl;
        List<ConstantConditionIfFix> fixes = ConstantConditionIfFix.Companion.collectFixes(expression, constantValue);
        KtExpression ktExpression = expression.getCondition();
        Object[] objectArray = new Object[]{constantValue};
        String string = KotlinBundle.message((String)"condition.is.always.0", (Object[])objectArray);
        Collection $this$toTypedArray$iv = fixes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new ConstantConditionIfFix[0]);
        $holder.registerProblem((PsiElement)expression, ktExpression != null ? TextRangeUtilsKt.textRangeIn((PsiElement)ktExpression, (PsiElement)expression) : null, string, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        return Unit.INSTANCE;
    }
}

