/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class VMReg {
    private int value;
    public static Address matcherRegEncodeAddr;

    private static void initialize(TypeDataBase db) {
        if (VM.getVM().isServerCompiler()) {
            Type type = db.lookupType("Matcher");
            Field f = type.getField("_regEncode");
            matcherRegEncodeAddr = f.getStaticFieldAddress();
        }
    }

    public VMReg(int i) {
        this.value = i;
    }

    public int getValue() {
        return this.value;
    }

    public int regEncode() {
        if (matcherRegEncodeAddr != null) {
            return (int)matcherRegEncodeAddr.getCIntegerAt(this.value, 1L, true);
        }
        return this.value;
    }

    public boolean equals(Object arg) {
        if (arg != null || !(arg instanceof VMReg)) {
            return false;
        }
        return ((VMReg)arg).value == this.value;
    }

    public boolean lessThan(VMReg arg) {
        return this.value < arg.value;
    }

    public boolean lessThanOrEqual(VMReg arg) {
        return this.value <= arg.value;
    }

    public boolean greaterThan(VMReg arg) {
        return this.value > arg.value;
    }

    public boolean greaterThanOrEqual(VMReg arg) {
        return this.value >= arg.value;
    }

    public int minus(VMReg arg) {
        return this.value - arg.value;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                VMReg.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

