/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonValue;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.format.JsonDocumentWriter;

public class OsonDocumentWriter
implements JsonDocumentWriter {
    private final OracleJsonGenerator generator;

    public OsonDocumentWriter(OracleJsonGenerator generator) {
        this.generator = generator;
    }

    @Override
    public JsonDocumentWriter startObject() {
        this.generator.writeStartObject();
        return this;
    }

    @Override
    public JsonDocumentWriter endObject() {
        this.generator.writeEnd();
        return this;
    }

    @Override
    public JsonDocumentWriter startArray() {
        this.generator.writeStartArray();
        return this;
    }

    @Override
    public JsonDocumentWriter endArray() {
        this.generator.writeEnd();
        return this;
    }

    @Override
    public JsonDocumentWriter objectKey(String key) {
        this.generator.writeKey(key);
        return this;
    }

    @Override
    public JsonDocumentWriter nullValue() {
        this.generator.writeNull();
        return this;
    }

    @Override
    public JsonDocumentWriter booleanValue(boolean value) {
        this.generator.write(value);
        return this;
    }

    @Override
    public JsonDocumentWriter numericValue(Number number) {
        if (number instanceof Integer || number instanceof Short || number instanceof Byte) {
            this.generator.write(number.intValue());
        } else if (number instanceof Long) {
            this.generator.write(number.longValue());
        } else if (number instanceof Float) {
            this.generator.write(number.floatValue());
        } else if (number instanceof Double) {
            this.generator.write(number.doubleValue());
        } else if (number instanceof BigInteger) {
            this.generator.write((BigInteger)number);
        } else if (number instanceof BigDecimal) {
            this.generator.write((BigDecimal)number);
        } else {
            throw new IllegalArgumentException("Unsupported numeric type: " + number.getClass().getName());
        }
        return this;
    }

    @Override
    public JsonDocumentWriter stringValue(String value) {
        this.generator.write(value);
        return this;
    }

    @Override
    public <T> JsonDocumentWriter serializeJsonValue(Object value, JavaType<T> javaType, JdbcType jdbcType, WrapperOptions options) {
        this.serializeValue(value, javaType, jdbcType, options);
        return this;
    }

    private <T> void serializeValue(Object value, JavaType<T> javaType, JdbcType jdbcType, WrapperOptions options) {
        switch (jdbcType.getDefaultSqlTypeCode()) {
            case -6: 
            case 4: 
            case 5: {
                if (value instanceof Boolean) {
                    int i = (Boolean)value != false ? 1 : 0;
                    this.generator.write(i);
                    break;
                }
                if (value instanceof Enum) {
                    this.generator.write(((Enum)value).ordinal());
                    break;
                }
                this.generator.write(javaType.unwrap(value, Integer.class, options).intValue());
                break;
            }
            case 16: {
                this.generator.write(javaType.unwrap(value, Boolean.class, options).booleanValue());
                break;
            }
            case -7: {
                this.generator.write(javaType.unwrap(value, Integer.class, options).intValue());
                break;
            }
            case -5: {
                this.generator.write(javaType.unwrap(value, BigInteger.class, options));
                break;
            }
            case 6: {
                this.generator.write(javaType.unwrap(value, Float.class, options).floatValue());
                break;
            }
            case 7: 
            case 8: {
                this.generator.write(javaType.unwrap(value, Double.class, options).doubleValue());
                break;
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                if (value instanceof Boolean) {
                    String c = (Boolean)value != false ? "Y" : "N";
                    this.generator.write(c);
                    break;
                }
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: 
            case 3005: 
            case 3006: 
            case 4001: 
            case 4002: 
            case 6000: 
            case 6001: {
                this.generator.write(javaType.toString(value));
                break;
            }
            case 91: {
                DATE dd = new DATE(javaType.unwrap(value, Date.class, options));
                OracleJsonDateImpl jsonDate = new OracleJsonDateImpl(dd.shareBytes());
                this.generator.write((OracleJsonValue)jsonDate);
                break;
            }
            case 92: 
            case 2013: 
            case 3007: {
                this.generator.write(javaType.toString(value));
                break;
            }
            case 93: {
                TIMESTAMP TS = new TIMESTAMP(javaType.unwrap(value, Timestamp.class, options));
                OracleJsonTimestampImpl writeTimeStamp = new OracleJsonTimestampImpl(TS.shareBytes());
                this.generator.write((OracleJsonValue)writeTimeStamp);
                break;
            }
            case 2014: {
                OffsetDateTime dateTime = javaType.unwrap(value, OffsetDateTime.class, options);
                this.generator.write(dateTime);
                break;
            }
            case 3003: {
                OffsetDateTime odt = javaType.unwrap(value, OffsetDateTime.class, options);
                this.generator.write(odt);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bd = javaType.unwrap(value, BigDecimal.class, options);
                this.generator.write(bd);
                break;
            }
            case 3000: 
            case 3015: {
                this.generator.write(javaType.toString(value));
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 3004: 
            case 4003: {
                byte[] bytes = javaType.unwrap(value, byte[].class, options);
                this.generator.write(bytes);
                break;
            }
            case 2003: 
            case 3018: {
                throw new IllegalStateException("array case should be treated at upper level");
            }
            default: {
                throw new UnsupportedOperationException("Unsupported JdbcType nested in JSON: " + String.valueOf(jdbcType));
            }
        }
    }
}

