/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.fips.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.fips.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.Signer;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Ed25519Signer
implements Signer {
    private final Buffer buffer = new Buffer();
    private boolean forSigning;
    private Ed25519PrivateKeyParameters privateKey;
    private Ed25519PublicKeyParameters publicKey;

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        if (bl) {
            this.privateKey = (Ed25519PrivateKeyParameters)cipherParameters;
            this.publicKey = null;
        } else {
            this.privateKey = null;
            this.publicKey = (Ed25519PublicKeyParameters)cipherParameters;
        }
        this.reset();
    }

    @Override
    public void update(byte by) {
        this.buffer.write(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.buffer.write(byArray, n, n2);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.forSigning || null == this.privateKey) {
            throw new IllegalStateException("Ed25519Signer not initialised for signature generation.");
        }
        return this.buffer.generateSignature(this.privateKey);
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        if (this.forSigning || null == this.publicKey) {
            throw new IllegalStateException("Ed25519Signer not initialised for verification");
        }
        return this.buffer.verifySignature(this.publicKey, byArray);
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Buffer
    extends ByteArrayOutputStream {
        private final Ed25519 ed25519 = new Ed25519(){

            @Override
            protected Digest createDigest() {
                return FipsSHS.createDigest(FipsSHS.Algorithm.SHA512);
            }
        };

        private Buffer() {
        }

        synchronized byte[] generateSignature(Ed25519PrivateKeyParameters ed25519PrivateKeyParameters) {
            byte[] byArray = new byte[64];
            ed25519PrivateKeyParameters.sign(0, null, this.buf, 0, this.count, byArray, 0);
            this.reset();
            return byArray;
        }

        synchronized boolean verifySignature(Ed25519PublicKeyParameters ed25519PublicKeyParameters, byte[] byArray) {
            if (64 != byArray.length) {
                this.reset();
                return false;
            }
            byte[] byArray2 = ed25519PublicKeyParameters.getEncoded();
            boolean bl = this.ed25519.verify(byArray, 0, byArray2, 0, this.buf, 0, this.count);
            this.reset();
            return bl;
        }

        @Override
        public synchronized void reset() {
            Arrays.fill(this.buf, 0, this.count, (byte)0);
            this.count = 0;
        }
    }
}

