/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AnalysisAclRule;
import software.amazon.awssdk.services.ec2.model.AnalysisComponent;
import software.amazon.awssdk.services.ec2.model.AnalysisComponentListCopier;
import software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerListener;
import software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerTarget;
import software.amazon.awssdk.services.ec2.model.AnalysisRouteTableRoute;
import software.amazon.awssdk.services.ec2.model.AnalysisSecurityGroupRule;
import software.amazon.awssdk.services.ec2.model.FirewallStatefulRule;
import software.amazon.awssdk.services.ec2.model.FirewallStatelessRule;
import software.amazon.awssdk.services.ec2.model.IpAddressListCopier;
import software.amazon.awssdk.services.ec2.model.PortRange;
import software.amazon.awssdk.services.ec2.model.PortRangeListCopier;
import software.amazon.awssdk.services.ec2.model.StringListCopier;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableRoute;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Explanation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Explanation> {
    private static final SdkField<AnalysisComponent> ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Acl").getter(Explanation.getter(Explanation::acl)).setter(Explanation.setter(Builder::acl)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Acl").unmarshallLocationName("acl").build()}).build();
    private static final SdkField<AnalysisAclRule> ACL_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AclRule").getter(Explanation.getter(Explanation::aclRule)).setter(Explanation.setter(Builder::aclRule)).constructor(AnalysisAclRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AclRule").unmarshallLocationName("aclRule").build()}).build();
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Address").getter(Explanation.getter(Explanation::address)).setter(Explanation.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").unmarshallLocationName("address").build()}).build();
    private static final SdkField<List<String>> ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Addresses").getter(Explanation.getter(Explanation::addresses)).setter(Explanation.setter(Builder::addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressSet").unmarshallLocationName("addressSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<AnalysisComponent> ATTACHED_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttachedTo").getter(Explanation.getter(Explanation::attachedTo)).setter(Explanation.setter(Builder::attachedTo)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedTo").unmarshallLocationName("attachedTo").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(Explanation.getter(Explanation::availabilityZones)).setter(Explanation.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneSet").unmarshallLocationName("availabilityZoneSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZoneIds").getter(Explanation.getter(Explanation::availabilityZoneIds)).setter(Explanation.setter(Builder::availabilityZoneIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneIdSet").unmarshallLocationName("availabilityZoneIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Cidrs").getter(Explanation.getter(Explanation::cidrs)).setter(Explanation.setter(Builder::cidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrSet").unmarshallLocationName("cidrSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<AnalysisComponent> COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Component").getter(Explanation.getter(Explanation::component)).setter(Explanation.setter(Builder::component)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Component").unmarshallLocationName("component").build()}).build();
    private static final SdkField<AnalysisComponent> CUSTOMER_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomerGateway").getter(Explanation.getter(Explanation::customerGateway)).setter(Explanation.setter(Builder::customerGateway)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGateway").unmarshallLocationName("customerGateway").build()}).build();
    private static final SdkField<AnalysisComponent> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(Explanation.getter(Explanation::destination)).setter(Explanation.setter(Builder::destination)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").unmarshallLocationName("destination").build()}).build();
    private static final SdkField<AnalysisComponent> DESTINATION_VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationVpc").getter(Explanation.getter(Explanation::destinationVpc)).setter(Explanation.setter(Builder::destinationVpc)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationVpc").unmarshallLocationName("destinationVpc").build()}).build();
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Direction").getter(Explanation.getter(Explanation::direction)).setter(Explanation.setter(Builder::direction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").unmarshallLocationName("direction").build()}).build();
    private static final SdkField<String> EXPLANATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExplanationCode").getter(Explanation.getter(Explanation::explanationCode)).setter(Explanation.setter(Builder::explanationCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplanationCode").unmarshallLocationName("explanationCode").build()}).build();
    private static final SdkField<AnalysisComponent> INGRESS_ROUTE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngressRouteTable").getter(Explanation.getter(Explanation::ingressRouteTable)).setter(Explanation.setter(Builder::ingressRouteTable)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressRouteTable").unmarshallLocationName("ingressRouteTable").build()}).build();
    private static final SdkField<AnalysisComponent> INTERNET_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InternetGateway").getter(Explanation.getter(Explanation::internetGateway)).setter(Explanation.setter(Builder::internetGateway)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGateway").unmarshallLocationName("internetGateway").build()}).build();
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerArn").getter(Explanation.getter(Explanation::loadBalancerArn)).setter(Explanation.setter(Builder::loadBalancerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").unmarshallLocationName("loadBalancerArn").build()}).build();
    private static final SdkField<AnalysisLoadBalancerListener> CLASSIC_LOAD_BALANCER_LISTENER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClassicLoadBalancerListener").getter(Explanation.getter(Explanation::classicLoadBalancerListener)).setter(Explanation.setter(Builder::classicLoadBalancerListener)).constructor(AnalysisLoadBalancerListener::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLoadBalancerListener").unmarshallLocationName("classicLoadBalancerListener").build()}).build();
    private static final SdkField<Integer> LOAD_BALANCER_LISTENER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LoadBalancerListenerPort").getter(Explanation.getter(Explanation::loadBalancerListenerPort)).setter(Explanation.setter(Builder::loadBalancerListenerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerListenerPort").unmarshallLocationName("loadBalancerListenerPort").build()}).build();
    private static final SdkField<AnalysisLoadBalancerTarget> LOAD_BALANCER_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoadBalancerTarget").getter(Explanation.getter(Explanation::loadBalancerTarget)).setter(Explanation.setter(Builder::loadBalancerTarget)).constructor(AnalysisLoadBalancerTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerTarget").unmarshallLocationName("loadBalancerTarget").build()}).build();
    private static final SdkField<AnalysisComponent> LOAD_BALANCER_TARGET_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoadBalancerTargetGroup").getter(Explanation.getter(Explanation::loadBalancerTargetGroup)).setter(Explanation.setter(Builder::loadBalancerTargetGroup)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerTargetGroup").unmarshallLocationName("loadBalancerTargetGroup").build()}).build();
    private static final SdkField<List<AnalysisComponent>> LOAD_BALANCER_TARGET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadBalancerTargetGroups").getter(Explanation.getter(Explanation::loadBalancerTargetGroups)).setter(Explanation.setter(Builder::loadBalancerTargetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerTargetGroupSet").unmarshallLocationName("loadBalancerTargetGroupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> LOAD_BALANCER_TARGET_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LoadBalancerTargetPort").getter(Explanation.getter(Explanation::loadBalancerTargetPort)).setter(Explanation.setter(Builder::loadBalancerTargetPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerTargetPort").unmarshallLocationName("loadBalancerTargetPort").build()}).build();
    private static final SdkField<AnalysisComponent> ELASTIC_LOAD_BALANCER_LISTENER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ElasticLoadBalancerListener").getter(Explanation.getter(Explanation::elasticLoadBalancerListener)).setter(Explanation.setter(Builder::elasticLoadBalancerListener)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticLoadBalancerListener").unmarshallLocationName("elasticLoadBalancerListener").build()}).build();
    private static final SdkField<String> MISSING_COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MissingComponent").getter(Explanation.getter(Explanation::missingComponent)).setter(Explanation.setter(Builder::missingComponent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingComponent").unmarshallLocationName("missingComponent").build()}).build();
    private static final SdkField<AnalysisComponent> NAT_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NatGateway").getter(Explanation.getter(Explanation::natGateway)).setter(Explanation.setter(Builder::natGateway)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGateway").unmarshallLocationName("natGateway").build()}).build();
    private static final SdkField<AnalysisComponent> NETWORK_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkInterface").getter(Explanation.getter(Explanation::networkInterface)).setter(Explanation.setter(Builder::networkInterface)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterface").unmarshallLocationName("networkInterface").build()}).build();
    private static final SdkField<String> PACKET_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PacketField").getter(Explanation.getter(Explanation::packetField)).setter(Explanation.setter(Builder::packetField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketField").unmarshallLocationName("packetField").build()}).build();
    private static final SdkField<AnalysisComponent> VPC_PEERING_CONNECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcPeeringConnection").getter(Explanation.getter(Explanation::vpcPeeringConnection)).setter(Explanation.setter(Builder::vpcPeeringConnection)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnection").unmarshallLocationName("vpcPeeringConnection").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(Explanation.getter(Explanation::port)).setter(Explanation.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").unmarshallLocationName("port").build()}).build();
    private static final SdkField<List<PortRange>> PORT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PortRanges").getter(Explanation.getter(Explanation::portRanges)).setter(Explanation.setter(Builder::portRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRangeSet").unmarshallLocationName("portRangeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<AnalysisComponent> PREFIX_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrefixList").getter(Explanation.getter(Explanation::prefixList)).setter(Explanation.setter(Builder::prefixList)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixList").unmarshallLocationName("prefixList").build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(Explanation.getter(Explanation::protocols)).setter(Explanation.setter(Builder::protocols)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolSet").unmarshallLocationName("protocolSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<AnalysisRouteTableRoute> ROUTE_TABLE_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RouteTableRoute").getter(Explanation.getter(Explanation::routeTableRoute)).setter(Explanation.setter(Builder::routeTableRoute)).constructor(AnalysisRouteTableRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableRoute").unmarshallLocationName("routeTableRoute").build()}).build();
    private static final SdkField<AnalysisComponent> ROUTE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RouteTable").getter(Explanation.getter(Explanation::routeTable)).setter(Explanation.setter(Builder::routeTable)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTable").unmarshallLocationName("routeTable").build()}).build();
    private static final SdkField<AnalysisComponent> SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityGroup").getter(Explanation.getter(Explanation::securityGroup)).setter(Explanation.setter(Builder::securityGroup)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup").unmarshallLocationName("securityGroup").build()}).build();
    private static final SdkField<AnalysisSecurityGroupRule> SECURITY_GROUP_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityGroupRule").getter(Explanation.getter(Explanation::securityGroupRule)).setter(Explanation.setter(Builder::securityGroupRule)).constructor(AnalysisSecurityGroupRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRule").unmarshallLocationName("securityGroupRule").build()}).build();
    private static final SdkField<List<AnalysisComponent>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(Explanation.getter(Explanation::securityGroups)).setter(Explanation.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupSet").unmarshallLocationName("securityGroupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<AnalysisComponent> SOURCE_VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceVpc").getter(Explanation.getter(Explanation::sourceVpc)).setter(Explanation.setter(Builder::sourceVpc)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVpc").unmarshallLocationName("sourceVpc").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Explanation.getter(Explanation::state)).setter(Explanation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<AnalysisComponent> SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Subnet").getter(Explanation.getter(Explanation::subnet)).setter(Explanation.setter(Builder::subnet)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet").unmarshallLocationName("subnet").build()}).build();
    private static final SdkField<AnalysisComponent> SUBNET_ROUTE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SubnetRouteTable").getter(Explanation.getter(Explanation::subnetRouteTable)).setter(Explanation.setter(Builder::subnetRouteTable)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetRouteTable").unmarshallLocationName("subnetRouteTable").build()}).build();
    private static final SdkField<AnalysisComponent> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vpc").getter(Explanation.getter(Explanation::vpc)).setter(Explanation.setter(Builder::vpc)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").unmarshallLocationName("vpc").build()}).build();
    private static final SdkField<AnalysisComponent> VPC_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcEndpoint").getter(Explanation.getter(Explanation::vpcEndpoint)).setter(Explanation.setter(Builder::vpcEndpoint)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpoint").unmarshallLocationName("vpcEndpoint").build()}).build();
    private static final SdkField<AnalysisComponent> VPN_CONNECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpnConnection").getter(Explanation.getter(Explanation::vpnConnection)).setter(Explanation.setter(Builder::vpnConnection)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnection").unmarshallLocationName("vpnConnection").build()}).build();
    private static final SdkField<AnalysisComponent> VPN_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpnGateway").getter(Explanation.getter(Explanation::vpnGateway)).setter(Explanation.setter(Builder::vpnGateway)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGateway").unmarshallLocationName("vpnGateway").build()}).build();
    private static final SdkField<AnalysisComponent> TRANSIT_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransitGateway").getter(Explanation.getter(Explanation::transitGateway)).setter(Explanation.setter(Builder::transitGateway)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGateway").unmarshallLocationName("transitGateway").build()}).build();
    private static final SdkField<AnalysisComponent> TRANSIT_GATEWAY_ROUTE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransitGatewayRouteTable").getter(Explanation.getter(Explanation::transitGatewayRouteTable)).setter(Explanation.setter(Builder::transitGatewayRouteTable)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTable").unmarshallLocationName("transitGatewayRouteTable").build()}).build();
    private static final SdkField<TransitGatewayRouteTableRoute> TRANSIT_GATEWAY_ROUTE_TABLE_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransitGatewayRouteTableRoute").getter(Explanation.getter(Explanation::transitGatewayRouteTableRoute)).setter(Explanation.setter(Builder::transitGatewayRouteTableRoute)).constructor(TransitGatewayRouteTableRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableRoute").unmarshallLocationName("transitGatewayRouteTableRoute").build()}).build();
    private static final SdkField<AnalysisComponent> TRANSIT_GATEWAY_ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransitGatewayAttachment").getter(Explanation.getter(Explanation::transitGatewayAttachment)).setter(Explanation.setter(Builder::transitGatewayAttachment)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachment").unmarshallLocationName("transitGatewayAttachment").build()}).build();
    private static final SdkField<String> COMPONENT_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentAccount").getter(Explanation.getter(Explanation::componentAccount)).setter(Explanation.setter(Builder::componentAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentAccount").unmarshallLocationName("componentAccount").build()}).build();
    private static final SdkField<String> COMPONENT_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentRegion").getter(Explanation.getter(Explanation::componentRegion)).setter(Explanation.setter(Builder::componentRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentRegion").unmarshallLocationName("componentRegion").build()}).build();
    private static final SdkField<FirewallStatelessRule> FIREWALL_STATELESS_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirewallStatelessRule").getter(Explanation.getter(Explanation::firewallStatelessRule)).setter(Explanation.setter(Builder::firewallStatelessRule)).constructor(FirewallStatelessRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallStatelessRule").unmarshallLocationName("firewallStatelessRule").build()}).build();
    private static final SdkField<FirewallStatefulRule> FIREWALL_STATEFUL_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirewallStatefulRule").getter(Explanation.getter(Explanation::firewallStatefulRule)).setter(Explanation.setter(Builder::firewallStatefulRule)).constructor(FirewallStatefulRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallStatefulRule").unmarshallLocationName("firewallStatefulRule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACL_FIELD, ACL_RULE_FIELD, ADDRESS_FIELD, ADDRESSES_FIELD, ATTACHED_TO_FIELD, AVAILABILITY_ZONES_FIELD, AVAILABILITY_ZONE_IDS_FIELD, CIDRS_FIELD, COMPONENT_FIELD, CUSTOMER_GATEWAY_FIELD, DESTINATION_FIELD, DESTINATION_VPC_FIELD, DIRECTION_FIELD, EXPLANATION_CODE_FIELD, INGRESS_ROUTE_TABLE_FIELD, INTERNET_GATEWAY_FIELD, LOAD_BALANCER_ARN_FIELD, CLASSIC_LOAD_BALANCER_LISTENER_FIELD, LOAD_BALANCER_LISTENER_PORT_FIELD, LOAD_BALANCER_TARGET_FIELD, LOAD_BALANCER_TARGET_GROUP_FIELD, LOAD_BALANCER_TARGET_GROUPS_FIELD, LOAD_BALANCER_TARGET_PORT_FIELD, ELASTIC_LOAD_BALANCER_LISTENER_FIELD, MISSING_COMPONENT_FIELD, NAT_GATEWAY_FIELD, NETWORK_INTERFACE_FIELD, PACKET_FIELD_FIELD, VPC_PEERING_CONNECTION_FIELD, PORT_FIELD, PORT_RANGES_FIELD, PREFIX_LIST_FIELD, PROTOCOLS_FIELD, ROUTE_TABLE_ROUTE_FIELD, ROUTE_TABLE_FIELD, SECURITY_GROUP_FIELD, SECURITY_GROUP_RULE_FIELD, SECURITY_GROUPS_FIELD, SOURCE_VPC_FIELD, STATE_FIELD, SUBNET_FIELD, SUBNET_ROUTE_TABLE_FIELD, VPC_FIELD, VPC_ENDPOINT_FIELD, VPN_CONNECTION_FIELD, VPN_GATEWAY_FIELD, TRANSIT_GATEWAY_FIELD, TRANSIT_GATEWAY_ROUTE_TABLE_FIELD, TRANSIT_GATEWAY_ROUTE_TABLE_ROUTE_FIELD, TRANSIT_GATEWAY_ATTACHMENT_FIELD, COMPONENT_ACCOUNT_FIELD, COMPONENT_REGION_FIELD, FIREWALL_STATELESS_RULE_FIELD, FIREWALL_STATEFUL_RULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Explanation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AnalysisComponent acl;
    private final AnalysisAclRule aclRule;
    private final String address;
    private final List<String> addresses;
    private final AnalysisComponent attachedTo;
    private final List<String> availabilityZones;
    private final List<String> availabilityZoneIds;
    private final List<String> cidrs;
    private final AnalysisComponent component;
    private final AnalysisComponent customerGateway;
    private final AnalysisComponent destination;
    private final AnalysisComponent destinationVpc;
    private final String direction;
    private final String explanationCode;
    private final AnalysisComponent ingressRouteTable;
    private final AnalysisComponent internetGateway;
    private final String loadBalancerArn;
    private final AnalysisLoadBalancerListener classicLoadBalancerListener;
    private final Integer loadBalancerListenerPort;
    private final AnalysisLoadBalancerTarget loadBalancerTarget;
    private final AnalysisComponent loadBalancerTargetGroup;
    private final List<AnalysisComponent> loadBalancerTargetGroups;
    private final Integer loadBalancerTargetPort;
    private final AnalysisComponent elasticLoadBalancerListener;
    private final String missingComponent;
    private final AnalysisComponent natGateway;
    private final AnalysisComponent networkInterface;
    private final String packetField;
    private final AnalysisComponent vpcPeeringConnection;
    private final Integer port;
    private final List<PortRange> portRanges;
    private final AnalysisComponent prefixList;
    private final List<String> protocols;
    private final AnalysisRouteTableRoute routeTableRoute;
    private final AnalysisComponent routeTable;
    private final AnalysisComponent securityGroup;
    private final AnalysisSecurityGroupRule securityGroupRule;
    private final List<AnalysisComponent> securityGroups;
    private final AnalysisComponent sourceVpc;
    private final String state;
    private final AnalysisComponent subnet;
    private final AnalysisComponent subnetRouteTable;
    private final AnalysisComponent vpc;
    private final AnalysisComponent vpcEndpoint;
    private final AnalysisComponent vpnConnection;
    private final AnalysisComponent vpnGateway;
    private final AnalysisComponent transitGateway;
    private final AnalysisComponent transitGatewayRouteTable;
    private final TransitGatewayRouteTableRoute transitGatewayRouteTableRoute;
    private final AnalysisComponent transitGatewayAttachment;
    private final String componentAccount;
    private final String componentRegion;
    private final FirewallStatelessRule firewallStatelessRule;
    private final FirewallStatefulRule firewallStatefulRule;

    private Explanation(BuilderImpl builder) {
        this.acl = builder.acl;
        this.aclRule = builder.aclRule;
        this.address = builder.address;
        this.addresses = builder.addresses;
        this.attachedTo = builder.attachedTo;
        this.availabilityZones = builder.availabilityZones;
        this.availabilityZoneIds = builder.availabilityZoneIds;
        this.cidrs = builder.cidrs;
        this.component = builder.component;
        this.customerGateway = builder.customerGateway;
        this.destination = builder.destination;
        this.destinationVpc = builder.destinationVpc;
        this.direction = builder.direction;
        this.explanationCode = builder.explanationCode;
        this.ingressRouteTable = builder.ingressRouteTable;
        this.internetGateway = builder.internetGateway;
        this.loadBalancerArn = builder.loadBalancerArn;
        this.classicLoadBalancerListener = builder.classicLoadBalancerListener;
        this.loadBalancerListenerPort = builder.loadBalancerListenerPort;
        this.loadBalancerTarget = builder.loadBalancerTarget;
        this.loadBalancerTargetGroup = builder.loadBalancerTargetGroup;
        this.loadBalancerTargetGroups = builder.loadBalancerTargetGroups;
        this.loadBalancerTargetPort = builder.loadBalancerTargetPort;
        this.elasticLoadBalancerListener = builder.elasticLoadBalancerListener;
        this.missingComponent = builder.missingComponent;
        this.natGateway = builder.natGateway;
        this.networkInterface = builder.networkInterface;
        this.packetField = builder.packetField;
        this.vpcPeeringConnection = builder.vpcPeeringConnection;
        this.port = builder.port;
        this.portRanges = builder.portRanges;
        this.prefixList = builder.prefixList;
        this.protocols = builder.protocols;
        this.routeTableRoute = builder.routeTableRoute;
        this.routeTable = builder.routeTable;
        this.securityGroup = builder.securityGroup;
        this.securityGroupRule = builder.securityGroupRule;
        this.securityGroups = builder.securityGroups;
        this.sourceVpc = builder.sourceVpc;
        this.state = builder.state;
        this.subnet = builder.subnet;
        this.subnetRouteTable = builder.subnetRouteTable;
        this.vpc = builder.vpc;
        this.vpcEndpoint = builder.vpcEndpoint;
        this.vpnConnection = builder.vpnConnection;
        this.vpnGateway = builder.vpnGateway;
        this.transitGateway = builder.transitGateway;
        this.transitGatewayRouteTable = builder.transitGatewayRouteTable;
        this.transitGatewayRouteTableRoute = builder.transitGatewayRouteTableRoute;
        this.transitGatewayAttachment = builder.transitGatewayAttachment;
        this.componentAccount = builder.componentAccount;
        this.componentRegion = builder.componentRegion;
        this.firewallStatelessRule = builder.firewallStatelessRule;
        this.firewallStatefulRule = builder.firewallStatefulRule;
    }

    public final AnalysisComponent acl() {
        return this.acl;
    }

    public final AnalysisAclRule aclRule() {
        return this.aclRule;
    }

    public final String address() {
        return this.address;
    }

    public final boolean hasAddresses() {
        return this.addresses != null && !(this.addresses instanceof SdkAutoConstructList);
    }

    public final List<String> addresses() {
        return this.addresses;
    }

    public final AnalysisComponent attachedTo() {
        return this.attachedTo;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final boolean hasAvailabilityZoneIds() {
        return this.availabilityZoneIds != null && !(this.availabilityZoneIds instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZoneIds() {
        return this.availabilityZoneIds;
    }

    public final boolean hasCidrs() {
        return this.cidrs != null && !(this.cidrs instanceof SdkAutoConstructList);
    }

    public final List<String> cidrs() {
        return this.cidrs;
    }

    public final AnalysisComponent component() {
        return this.component;
    }

    public final AnalysisComponent customerGateway() {
        return this.customerGateway;
    }

    public final AnalysisComponent destination() {
        return this.destination;
    }

    public final AnalysisComponent destinationVpc() {
        return this.destinationVpc;
    }

    public final String direction() {
        return this.direction;
    }

    public final String explanationCode() {
        return this.explanationCode;
    }

    public final AnalysisComponent ingressRouteTable() {
        return this.ingressRouteTable;
    }

    public final AnalysisComponent internetGateway() {
        return this.internetGateway;
    }

    public final String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public final AnalysisLoadBalancerListener classicLoadBalancerListener() {
        return this.classicLoadBalancerListener;
    }

    public final Integer loadBalancerListenerPort() {
        return this.loadBalancerListenerPort;
    }

    public final AnalysisLoadBalancerTarget loadBalancerTarget() {
        return this.loadBalancerTarget;
    }

    public final AnalysisComponent loadBalancerTargetGroup() {
        return this.loadBalancerTargetGroup;
    }

    public final boolean hasLoadBalancerTargetGroups() {
        return this.loadBalancerTargetGroups != null && !(this.loadBalancerTargetGroups instanceof SdkAutoConstructList);
    }

    public final List<AnalysisComponent> loadBalancerTargetGroups() {
        return this.loadBalancerTargetGroups;
    }

    public final Integer loadBalancerTargetPort() {
        return this.loadBalancerTargetPort;
    }

    public final AnalysisComponent elasticLoadBalancerListener() {
        return this.elasticLoadBalancerListener;
    }

    public final String missingComponent() {
        return this.missingComponent;
    }

    public final AnalysisComponent natGateway() {
        return this.natGateway;
    }

    public final AnalysisComponent networkInterface() {
        return this.networkInterface;
    }

    public final String packetField() {
        return this.packetField;
    }

    public final AnalysisComponent vpcPeeringConnection() {
        return this.vpcPeeringConnection;
    }

    public final Integer port() {
        return this.port;
    }

    public final boolean hasPortRanges() {
        return this.portRanges != null && !(this.portRanges instanceof SdkAutoConstructList);
    }

    public final List<PortRange> portRanges() {
        return this.portRanges;
    }

    public final AnalysisComponent prefixList() {
        return this.prefixList;
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocols() {
        return this.protocols;
    }

    public final AnalysisRouteTableRoute routeTableRoute() {
        return this.routeTableRoute;
    }

    public final AnalysisComponent routeTable() {
        return this.routeTable;
    }

    public final AnalysisComponent securityGroup() {
        return this.securityGroup;
    }

    public final AnalysisSecurityGroupRule securityGroupRule() {
        return this.securityGroupRule;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<AnalysisComponent> securityGroups() {
        return this.securityGroups;
    }

    public final AnalysisComponent sourceVpc() {
        return this.sourceVpc;
    }

    public final String state() {
        return this.state;
    }

    public final AnalysisComponent subnet() {
        return this.subnet;
    }

    public final AnalysisComponent subnetRouteTable() {
        return this.subnetRouteTable;
    }

    public final AnalysisComponent vpc() {
        return this.vpc;
    }

    public final AnalysisComponent vpcEndpoint() {
        return this.vpcEndpoint;
    }

    public final AnalysisComponent vpnConnection() {
        return this.vpnConnection;
    }

    public final AnalysisComponent vpnGateway() {
        return this.vpnGateway;
    }

    public final AnalysisComponent transitGateway() {
        return this.transitGateway;
    }

    public final AnalysisComponent transitGatewayRouteTable() {
        return this.transitGatewayRouteTable;
    }

    public final TransitGatewayRouteTableRoute transitGatewayRouteTableRoute() {
        return this.transitGatewayRouteTableRoute;
    }

    public final AnalysisComponent transitGatewayAttachment() {
        return this.transitGatewayAttachment;
    }

    public final String componentAccount() {
        return this.componentAccount;
    }

    public final String componentRegion() {
        return this.componentRegion;
    }

    public final FirewallStatelessRule firewallStatelessRule() {
        return this.firewallStatelessRule;
    }

    public final FirewallStatefulRule firewallStatefulRule() {
        return this.firewallStatefulRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acl());
        hashCode = 31 * hashCode + Objects.hashCode(this.aclRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddresses() ? this.addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZoneIds() ? this.availabilityZoneIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrs() ? this.cidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.component());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGateway());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationVpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.direction());
        hashCode = 31 * hashCode + Objects.hashCode(this.explanationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.internetGateway());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.classicLoadBalancerListener());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerListenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerTargetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancerTargetGroups() ? this.loadBalancerTargetGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerTargetPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticLoadBalancerListener());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingComponent());
        hashCode = 31 * hashCode + Objects.hashCode(this.natGateway());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetField());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnection());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortRanges() ? this.portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixList());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocols() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnet());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnConnection());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnGateway());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGateway());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTableRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallStatelessRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallStatefulRule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Explanation)) {
            return false;
        }
        Explanation other = (Explanation)obj;
        return Objects.equals(this.acl(), other.acl()) && Objects.equals(this.aclRule(), other.aclRule()) && Objects.equals(this.address(), other.address()) && this.hasAddresses() == other.hasAddresses() && Objects.equals(this.addresses(), other.addresses()) && Objects.equals(this.attachedTo(), other.attachedTo()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && this.hasAvailabilityZoneIds() == other.hasAvailabilityZoneIds() && Objects.equals(this.availabilityZoneIds(), other.availabilityZoneIds()) && this.hasCidrs() == other.hasCidrs() && Objects.equals(this.cidrs(), other.cidrs()) && Objects.equals(this.component(), other.component()) && Objects.equals(this.customerGateway(), other.customerGateway()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationVpc(), other.destinationVpc()) && Objects.equals(this.direction(), other.direction()) && Objects.equals(this.explanationCode(), other.explanationCode()) && Objects.equals(this.ingressRouteTable(), other.ingressRouteTable()) && Objects.equals(this.internetGateway(), other.internetGateway()) && Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.classicLoadBalancerListener(), other.classicLoadBalancerListener()) && Objects.equals(this.loadBalancerListenerPort(), other.loadBalancerListenerPort()) && Objects.equals(this.loadBalancerTarget(), other.loadBalancerTarget()) && Objects.equals(this.loadBalancerTargetGroup(), other.loadBalancerTargetGroup()) && this.hasLoadBalancerTargetGroups() == other.hasLoadBalancerTargetGroups() && Objects.equals(this.loadBalancerTargetGroups(), other.loadBalancerTargetGroups()) && Objects.equals(this.loadBalancerTargetPort(), other.loadBalancerTargetPort()) && Objects.equals(this.elasticLoadBalancerListener(), other.elasticLoadBalancerListener()) && Objects.equals(this.missingComponent(), other.missingComponent()) && Objects.equals(this.natGateway(), other.natGateway()) && Objects.equals(this.networkInterface(), other.networkInterface()) && Objects.equals(this.packetField(), other.packetField()) && Objects.equals(this.vpcPeeringConnection(), other.vpcPeeringConnection()) && Objects.equals(this.port(), other.port()) && this.hasPortRanges() == other.hasPortRanges() && Objects.equals(this.portRanges(), other.portRanges()) && Objects.equals(this.prefixList(), other.prefixList()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocols(), other.protocols()) && Objects.equals(this.routeTableRoute(), other.routeTableRoute()) && Objects.equals(this.routeTable(), other.routeTable()) && Objects.equals(this.securityGroup(), other.securityGroup()) && Objects.equals(this.securityGroupRule(), other.securityGroupRule()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.sourceVpc(), other.sourceVpc()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.subnet(), other.subnet()) && Objects.equals(this.subnetRouteTable(), other.subnetRouteTable()) && Objects.equals(this.vpc(), other.vpc()) && Objects.equals(this.vpcEndpoint(), other.vpcEndpoint()) && Objects.equals(this.vpnConnection(), other.vpnConnection()) && Objects.equals(this.vpnGateway(), other.vpnGateway()) && Objects.equals(this.transitGateway(), other.transitGateway()) && Objects.equals(this.transitGatewayRouteTable(), other.transitGatewayRouteTable()) && Objects.equals(this.transitGatewayRouteTableRoute(), other.transitGatewayRouteTableRoute()) && Objects.equals(this.transitGatewayAttachment(), other.transitGatewayAttachment()) && Objects.equals(this.componentAccount(), other.componentAccount()) && Objects.equals(this.componentRegion(), other.componentRegion()) && Objects.equals(this.firewallStatelessRule(), other.firewallStatelessRule()) && Objects.equals(this.firewallStatefulRule(), other.firewallStatefulRule());
    }

    public final String toString() {
        return ToString.builder((String)"Explanation").add("Acl", (Object)this.acl()).add("AclRule", (Object)this.aclRule()).add("Address", (Object)this.address()).add("Addresses", this.hasAddresses() ? this.addresses() : null).add("AttachedTo", (Object)this.attachedTo()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("AvailabilityZoneIds", this.hasAvailabilityZoneIds() ? this.availabilityZoneIds() : null).add("Cidrs", this.hasCidrs() ? this.cidrs() : null).add("Component", (Object)this.component()).add("CustomerGateway", (Object)this.customerGateway()).add("Destination", (Object)this.destination()).add("DestinationVpc", (Object)this.destinationVpc()).add("Direction", (Object)this.direction()).add("ExplanationCode", (Object)this.explanationCode()).add("IngressRouteTable", (Object)this.ingressRouteTable()).add("InternetGateway", (Object)this.internetGateway()).add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("ClassicLoadBalancerListener", (Object)this.classicLoadBalancerListener()).add("LoadBalancerListenerPort", (Object)this.loadBalancerListenerPort()).add("LoadBalancerTarget", (Object)this.loadBalancerTarget()).add("LoadBalancerTargetGroup", (Object)this.loadBalancerTargetGroup()).add("LoadBalancerTargetGroups", this.hasLoadBalancerTargetGroups() ? this.loadBalancerTargetGroups() : null).add("LoadBalancerTargetPort", (Object)this.loadBalancerTargetPort()).add("ElasticLoadBalancerListener", (Object)this.elasticLoadBalancerListener()).add("MissingComponent", (Object)this.missingComponent()).add("NatGateway", (Object)this.natGateway()).add("NetworkInterface", (Object)this.networkInterface()).add("PacketField", (Object)this.packetField()).add("VpcPeeringConnection", (Object)this.vpcPeeringConnection()).add("Port", (Object)this.port()).add("PortRanges", this.hasPortRanges() ? this.portRanges() : null).add("PrefixList", (Object)this.prefixList()).add("Protocols", this.hasProtocols() ? this.protocols() : null).add("RouteTableRoute", (Object)this.routeTableRoute()).add("RouteTable", (Object)this.routeTable()).add("SecurityGroup", (Object)this.securityGroup()).add("SecurityGroupRule", (Object)this.securityGroupRule()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("SourceVpc", (Object)this.sourceVpc()).add("State", (Object)this.state()).add("Subnet", (Object)this.subnet()).add("SubnetRouteTable", (Object)this.subnetRouteTable()).add("Vpc", (Object)this.vpc()).add("VpcEndpoint", (Object)this.vpcEndpoint()).add("VpnConnection", (Object)this.vpnConnection()).add("VpnGateway", (Object)this.vpnGateway()).add("TransitGateway", (Object)this.transitGateway()).add("TransitGatewayRouteTable", (Object)this.transitGatewayRouteTable()).add("TransitGatewayRouteTableRoute", (Object)this.transitGatewayRouteTableRoute()).add("TransitGatewayAttachment", (Object)this.transitGatewayAttachment()).add("ComponentAccount", (Object)this.componentAccount()).add("ComponentRegion", (Object)this.componentRegion()).add("FirewallStatelessRule", (Object)this.firewallStatelessRule()).add("FirewallStatefulRule", (Object)this.firewallStatefulRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Acl": {
                return Optional.ofNullable(clazz.cast(this.acl()));
            }
            case "AclRule": {
                return Optional.ofNullable(clazz.cast(this.aclRule()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "Addresses": {
                return Optional.ofNullable(clazz.cast(this.addresses()));
            }
            case "AttachedTo": {
                return Optional.ofNullable(clazz.cast(this.attachedTo()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "AvailabilityZoneIds": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneIds()));
            }
            case "Cidrs": {
                return Optional.ofNullable(clazz.cast(this.cidrs()));
            }
            case "Component": {
                return Optional.ofNullable(clazz.cast(this.component()));
            }
            case "CustomerGateway": {
                return Optional.ofNullable(clazz.cast(this.customerGateway()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DestinationVpc": {
                return Optional.ofNullable(clazz.cast(this.destinationVpc()));
            }
            case "Direction": {
                return Optional.ofNullable(clazz.cast(this.direction()));
            }
            case "ExplanationCode": {
                return Optional.ofNullable(clazz.cast(this.explanationCode()));
            }
            case "IngressRouteTable": {
                return Optional.ofNullable(clazz.cast(this.ingressRouteTable()));
            }
            case "InternetGateway": {
                return Optional.ofNullable(clazz.cast(this.internetGateway()));
            }
            case "LoadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArn()));
            }
            case "ClassicLoadBalancerListener": {
                return Optional.ofNullable(clazz.cast(this.classicLoadBalancerListener()));
            }
            case "LoadBalancerListenerPort": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerListenerPort()));
            }
            case "LoadBalancerTarget": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerTarget()));
            }
            case "LoadBalancerTargetGroup": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerTargetGroup()));
            }
            case "LoadBalancerTargetGroups": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerTargetGroups()));
            }
            case "LoadBalancerTargetPort": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerTargetPort()));
            }
            case "ElasticLoadBalancerListener": {
                return Optional.ofNullable(clazz.cast(this.elasticLoadBalancerListener()));
            }
            case "MissingComponent": {
                return Optional.ofNullable(clazz.cast(this.missingComponent()));
            }
            case "NatGateway": {
                return Optional.ofNullable(clazz.cast(this.natGateway()));
            }
            case "NetworkInterface": {
                return Optional.ofNullable(clazz.cast(this.networkInterface()));
            }
            case "PacketField": {
                return Optional.ofNullable(clazz.cast(this.packetField()));
            }
            case "VpcPeeringConnection": {
                return Optional.ofNullable(clazz.cast(this.vpcPeeringConnection()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "PortRanges": {
                return Optional.ofNullable(clazz.cast(this.portRanges()));
            }
            case "PrefixList": {
                return Optional.ofNullable(clazz.cast(this.prefixList()));
            }
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocols()));
            }
            case "RouteTableRoute": {
                return Optional.ofNullable(clazz.cast(this.routeTableRoute()));
            }
            case "RouteTable": {
                return Optional.ofNullable(clazz.cast(this.routeTable()));
            }
            case "SecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.securityGroup()));
            }
            case "SecurityGroupRule": {
                return Optional.ofNullable(clazz.cast(this.securityGroupRule()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SourceVpc": {
                return Optional.ofNullable(clazz.cast(this.sourceVpc()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "Subnet": {
                return Optional.ofNullable(clazz.cast(this.subnet()));
            }
            case "SubnetRouteTable": {
                return Optional.ofNullable(clazz.cast(this.subnetRouteTable()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
            case "VpcEndpoint": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpoint()));
            }
            case "VpnConnection": {
                return Optional.ofNullable(clazz.cast(this.vpnConnection()));
            }
            case "VpnGateway": {
                return Optional.ofNullable(clazz.cast(this.vpnGateway()));
            }
            case "TransitGateway": {
                return Optional.ofNullable(clazz.cast(this.transitGateway()));
            }
            case "TransitGatewayRouteTable": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTable()));
            }
            case "TransitGatewayRouteTableRoute": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableRoute()));
            }
            case "TransitGatewayAttachment": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachment()));
            }
            case "ComponentAccount": {
                return Optional.ofNullable(clazz.cast(this.componentAccount()));
            }
            case "ComponentRegion": {
                return Optional.ofNullable(clazz.cast(this.componentRegion()));
            }
            case "FirewallStatelessRule": {
                return Optional.ofNullable(clazz.cast(this.firewallStatelessRule()));
            }
            case "FirewallStatefulRule": {
                return Optional.ofNullable(clazz.cast(this.firewallStatefulRule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Acl", ACL_FIELD);
        map.put("AclRule", ACL_RULE_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("AddressSet", ADDRESSES_FIELD);
        map.put("AttachedTo", ATTACHED_TO_FIELD);
        map.put("AvailabilityZoneSet", AVAILABILITY_ZONES_FIELD);
        map.put("AvailabilityZoneIdSet", AVAILABILITY_ZONE_IDS_FIELD);
        map.put("CidrSet", CIDRS_FIELD);
        map.put("Component", COMPONENT_FIELD);
        map.put("CustomerGateway", CUSTOMER_GATEWAY_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("DestinationVpc", DESTINATION_VPC_FIELD);
        map.put("Direction", DIRECTION_FIELD);
        map.put("ExplanationCode", EXPLANATION_CODE_FIELD);
        map.put("IngressRouteTable", INGRESS_ROUTE_TABLE_FIELD);
        map.put("InternetGateway", INTERNET_GATEWAY_FIELD);
        map.put("LoadBalancerArn", LOAD_BALANCER_ARN_FIELD);
        map.put("ClassicLoadBalancerListener", CLASSIC_LOAD_BALANCER_LISTENER_FIELD);
        map.put("LoadBalancerListenerPort", LOAD_BALANCER_LISTENER_PORT_FIELD);
        map.put("LoadBalancerTarget", LOAD_BALANCER_TARGET_FIELD);
        map.put("LoadBalancerTargetGroup", LOAD_BALANCER_TARGET_GROUP_FIELD);
        map.put("LoadBalancerTargetGroupSet", LOAD_BALANCER_TARGET_GROUPS_FIELD);
        map.put("LoadBalancerTargetPort", LOAD_BALANCER_TARGET_PORT_FIELD);
        map.put("ElasticLoadBalancerListener", ELASTIC_LOAD_BALANCER_LISTENER_FIELD);
        map.put("MissingComponent", MISSING_COMPONENT_FIELD);
        map.put("NatGateway", NAT_GATEWAY_FIELD);
        map.put("NetworkInterface", NETWORK_INTERFACE_FIELD);
        map.put("PacketField", PACKET_FIELD_FIELD);
        map.put("VpcPeeringConnection", VPC_PEERING_CONNECTION_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("PortRangeSet", PORT_RANGES_FIELD);
        map.put("PrefixList", PREFIX_LIST_FIELD);
        map.put("ProtocolSet", PROTOCOLS_FIELD);
        map.put("RouteTableRoute", ROUTE_TABLE_ROUTE_FIELD);
        map.put("RouteTable", ROUTE_TABLE_FIELD);
        map.put("SecurityGroup", SECURITY_GROUP_FIELD);
        map.put("SecurityGroupRule", SECURITY_GROUP_RULE_FIELD);
        map.put("SecurityGroupSet", SECURITY_GROUPS_FIELD);
        map.put("SourceVpc", SOURCE_VPC_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Subnet", SUBNET_FIELD);
        map.put("SubnetRouteTable", SUBNET_ROUTE_TABLE_FIELD);
        map.put("Vpc", VPC_FIELD);
        map.put("VpcEndpoint", VPC_ENDPOINT_FIELD);
        map.put("VpnConnection", VPN_CONNECTION_FIELD);
        map.put("VpnGateway", VPN_GATEWAY_FIELD);
        map.put("TransitGateway", TRANSIT_GATEWAY_FIELD);
        map.put("TransitGatewayRouteTable", TRANSIT_GATEWAY_ROUTE_TABLE_FIELD);
        map.put("TransitGatewayRouteTableRoute", TRANSIT_GATEWAY_ROUTE_TABLE_ROUTE_FIELD);
        map.put("TransitGatewayAttachment", TRANSIT_GATEWAY_ATTACHMENT_FIELD);
        map.put("ComponentAccount", COMPONENT_ACCOUNT_FIELD);
        map.put("ComponentRegion", COMPONENT_REGION_FIELD);
        map.put("FirewallStatelessRule", FIREWALL_STATELESS_RULE_FIELD);
        map.put("FirewallStatefulRule", FIREWALL_STATEFUL_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Explanation, T> g) {
        return obj -> g.apply((Explanation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AnalysisComponent acl;
        private AnalysisAclRule aclRule;
        private String address;
        private List<String> addresses = DefaultSdkAutoConstructList.getInstance();
        private AnalysisComponent attachedTo;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> availabilityZoneIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> cidrs = DefaultSdkAutoConstructList.getInstance();
        private AnalysisComponent component;
        private AnalysisComponent customerGateway;
        private AnalysisComponent destination;
        private AnalysisComponent destinationVpc;
        private String direction;
        private String explanationCode;
        private AnalysisComponent ingressRouteTable;
        private AnalysisComponent internetGateway;
        private String loadBalancerArn;
        private AnalysisLoadBalancerListener classicLoadBalancerListener;
        private Integer loadBalancerListenerPort;
        private AnalysisLoadBalancerTarget loadBalancerTarget;
        private AnalysisComponent loadBalancerTargetGroup;
        private List<AnalysisComponent> loadBalancerTargetGroups = DefaultSdkAutoConstructList.getInstance();
        private Integer loadBalancerTargetPort;
        private AnalysisComponent elasticLoadBalancerListener;
        private String missingComponent;
        private AnalysisComponent natGateway;
        private AnalysisComponent networkInterface;
        private String packetField;
        private AnalysisComponent vpcPeeringConnection;
        private Integer port;
        private List<PortRange> portRanges = DefaultSdkAutoConstructList.getInstance();
        private AnalysisComponent prefixList;
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();
        private AnalysisRouteTableRoute routeTableRoute;
        private AnalysisComponent routeTable;
        private AnalysisComponent securityGroup;
        private AnalysisSecurityGroupRule securityGroupRule;
        private List<AnalysisComponent> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private AnalysisComponent sourceVpc;
        private String state;
        private AnalysisComponent subnet;
        private AnalysisComponent subnetRouteTable;
        private AnalysisComponent vpc;
        private AnalysisComponent vpcEndpoint;
        private AnalysisComponent vpnConnection;
        private AnalysisComponent vpnGateway;
        private AnalysisComponent transitGateway;
        private AnalysisComponent transitGatewayRouteTable;
        private TransitGatewayRouteTableRoute transitGatewayRouteTableRoute;
        private AnalysisComponent transitGatewayAttachment;
        private String componentAccount;
        private String componentRegion;
        private FirewallStatelessRule firewallStatelessRule;
        private FirewallStatefulRule firewallStatefulRule;

        private BuilderImpl() {
        }

        private BuilderImpl(Explanation model) {
            this.acl(model.acl);
            this.aclRule(model.aclRule);
            this.address(model.address);
            this.addresses(model.addresses);
            this.attachedTo(model.attachedTo);
            this.availabilityZones(model.availabilityZones);
            this.availabilityZoneIds(model.availabilityZoneIds);
            this.cidrs(model.cidrs);
            this.component(model.component);
            this.customerGateway(model.customerGateway);
            this.destination(model.destination);
            this.destinationVpc(model.destinationVpc);
            this.direction(model.direction);
            this.explanationCode(model.explanationCode);
            this.ingressRouteTable(model.ingressRouteTable);
            this.internetGateway(model.internetGateway);
            this.loadBalancerArn(model.loadBalancerArn);
            this.classicLoadBalancerListener(model.classicLoadBalancerListener);
            this.loadBalancerListenerPort(model.loadBalancerListenerPort);
            this.loadBalancerTarget(model.loadBalancerTarget);
            this.loadBalancerTargetGroup(model.loadBalancerTargetGroup);
            this.loadBalancerTargetGroups(model.loadBalancerTargetGroups);
            this.loadBalancerTargetPort(model.loadBalancerTargetPort);
            this.elasticLoadBalancerListener(model.elasticLoadBalancerListener);
            this.missingComponent(model.missingComponent);
            this.natGateway(model.natGateway);
            this.networkInterface(model.networkInterface);
            this.packetField(model.packetField);
            this.vpcPeeringConnection(model.vpcPeeringConnection);
            this.port(model.port);
            this.portRanges(model.portRanges);
            this.prefixList(model.prefixList);
            this.protocols(model.protocols);
            this.routeTableRoute(model.routeTableRoute);
            this.routeTable(model.routeTable);
            this.securityGroup(model.securityGroup);
            this.securityGroupRule(model.securityGroupRule);
            this.securityGroups(model.securityGroups);
            this.sourceVpc(model.sourceVpc);
            this.state(model.state);
            this.subnet(model.subnet);
            this.subnetRouteTable(model.subnetRouteTable);
            this.vpc(model.vpc);
            this.vpcEndpoint(model.vpcEndpoint);
            this.vpnConnection(model.vpnConnection);
            this.vpnGateway(model.vpnGateway);
            this.transitGateway(model.transitGateway);
            this.transitGatewayRouteTable(model.transitGatewayRouteTable);
            this.transitGatewayRouteTableRoute(model.transitGatewayRouteTableRoute);
            this.transitGatewayAttachment(model.transitGatewayAttachment);
            this.componentAccount(model.componentAccount);
            this.componentRegion(model.componentRegion);
            this.firewallStatelessRule(model.firewallStatelessRule);
            this.firewallStatefulRule(model.firewallStatefulRule);
        }

        public final AnalysisComponent.Builder getAcl() {
            return this.acl != null ? this.acl.toBuilder() : null;
        }

        public final void setAcl(AnalysisComponent.BuilderImpl acl) {
            this.acl = acl != null ? acl.build() : null;
        }

        @Override
        public final Builder acl(AnalysisComponent acl) {
            this.acl = acl;
            return this;
        }

        public final AnalysisAclRule.Builder getAclRule() {
            return this.aclRule != null ? this.aclRule.toBuilder() : null;
        }

        public final void setAclRule(AnalysisAclRule.BuilderImpl aclRule) {
            this.aclRule = aclRule != null ? aclRule.build() : null;
        }

        @Override
        public final Builder aclRule(AnalysisAclRule aclRule) {
            this.aclRule = aclRule;
            return this;
        }

        public final String getAddress() {
            return this.address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final Collection<String> getAddresses() {
            if (this.addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addresses;
        }

        public final void setAddresses(Collection<String> addresses) {
            this.addresses = IpAddressListCopier.copy(addresses);
        }

        @Override
        public final Builder addresses(Collection<String> addresses) {
            this.addresses = IpAddressListCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(String ... addresses) {
            this.addresses(Arrays.asList(addresses));
            return this;
        }

        public final AnalysisComponent.Builder getAttachedTo() {
            return this.attachedTo != null ? this.attachedTo.toBuilder() : null;
        }

        public final void setAttachedTo(AnalysisComponent.BuilderImpl attachedTo) {
            this.attachedTo = attachedTo != null ? attachedTo.build() : null;
        }

        @Override
        public final Builder attachedTo(AnalysisComponent attachedTo) {
            this.attachedTo = attachedTo;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getAvailabilityZoneIds() {
            if (this.availabilityZoneIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZoneIds;
        }

        public final void setAvailabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = ValueStringListCopier.copy(availabilityZoneIds);
        }

        @Override
        public final Builder availabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = ValueStringListCopier.copy(availabilityZoneIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneIds(String ... availabilityZoneIds) {
            this.availabilityZoneIds(Arrays.asList(availabilityZoneIds));
            return this;
        }

        public final Collection<String> getCidrs() {
            if (this.cidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrs;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = ValueStringListCopier.copy(cidrs);
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = ValueStringListCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String ... cidrs) {
            this.cidrs(Arrays.asList(cidrs));
            return this;
        }

        public final AnalysisComponent.Builder getComponent() {
            return this.component != null ? this.component.toBuilder() : null;
        }

        public final void setComponent(AnalysisComponent.BuilderImpl component) {
            this.component = component != null ? component.build() : null;
        }

        @Override
        public final Builder component(AnalysisComponent component) {
            this.component = component;
            return this;
        }

        public final AnalysisComponent.Builder getCustomerGateway() {
            return this.customerGateway != null ? this.customerGateway.toBuilder() : null;
        }

        public final void setCustomerGateway(AnalysisComponent.BuilderImpl customerGateway) {
            this.customerGateway = customerGateway != null ? customerGateway.build() : null;
        }

        @Override
        public final Builder customerGateway(AnalysisComponent customerGateway) {
            this.customerGateway = customerGateway;
            return this;
        }

        public final AnalysisComponent.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(AnalysisComponent.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(AnalysisComponent destination) {
            this.destination = destination;
            return this;
        }

        public final AnalysisComponent.Builder getDestinationVpc() {
            return this.destinationVpc != null ? this.destinationVpc.toBuilder() : null;
        }

        public final void setDestinationVpc(AnalysisComponent.BuilderImpl destinationVpc) {
            this.destinationVpc = destinationVpc != null ? destinationVpc.build() : null;
        }

        @Override
        public final Builder destinationVpc(AnalysisComponent destinationVpc) {
            this.destinationVpc = destinationVpc;
            return this;
        }

        public final String getDirection() {
            return this.direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        public final String getExplanationCode() {
            return this.explanationCode;
        }

        public final void setExplanationCode(String explanationCode) {
            this.explanationCode = explanationCode;
        }

        @Override
        public final Builder explanationCode(String explanationCode) {
            this.explanationCode = explanationCode;
            return this;
        }

        public final AnalysisComponent.Builder getIngressRouteTable() {
            return this.ingressRouteTable != null ? this.ingressRouteTable.toBuilder() : null;
        }

        public final void setIngressRouteTable(AnalysisComponent.BuilderImpl ingressRouteTable) {
            this.ingressRouteTable = ingressRouteTable != null ? ingressRouteTable.build() : null;
        }

        @Override
        public final Builder ingressRouteTable(AnalysisComponent ingressRouteTable) {
            this.ingressRouteTable = ingressRouteTable;
            return this;
        }

        public final AnalysisComponent.Builder getInternetGateway() {
            return this.internetGateway != null ? this.internetGateway.toBuilder() : null;
        }

        public final void setInternetGateway(AnalysisComponent.BuilderImpl internetGateway) {
            this.internetGateway = internetGateway != null ? internetGateway.build() : null;
        }

        @Override
        public final Builder internetGateway(AnalysisComponent internetGateway) {
            this.internetGateway = internetGateway;
            return this;
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final AnalysisLoadBalancerListener.Builder getClassicLoadBalancerListener() {
            return this.classicLoadBalancerListener != null ? this.classicLoadBalancerListener.toBuilder() : null;
        }

        public final void setClassicLoadBalancerListener(AnalysisLoadBalancerListener.BuilderImpl classicLoadBalancerListener) {
            this.classicLoadBalancerListener = classicLoadBalancerListener != null ? classicLoadBalancerListener.build() : null;
        }

        @Override
        public final Builder classicLoadBalancerListener(AnalysisLoadBalancerListener classicLoadBalancerListener) {
            this.classicLoadBalancerListener = classicLoadBalancerListener;
            return this;
        }

        public final Integer getLoadBalancerListenerPort() {
            return this.loadBalancerListenerPort;
        }

        public final void setLoadBalancerListenerPort(Integer loadBalancerListenerPort) {
            this.loadBalancerListenerPort = loadBalancerListenerPort;
        }

        @Override
        public final Builder loadBalancerListenerPort(Integer loadBalancerListenerPort) {
            this.loadBalancerListenerPort = loadBalancerListenerPort;
            return this;
        }

        public final AnalysisLoadBalancerTarget.Builder getLoadBalancerTarget() {
            return this.loadBalancerTarget != null ? this.loadBalancerTarget.toBuilder() : null;
        }

        public final void setLoadBalancerTarget(AnalysisLoadBalancerTarget.BuilderImpl loadBalancerTarget) {
            this.loadBalancerTarget = loadBalancerTarget != null ? loadBalancerTarget.build() : null;
        }

        @Override
        public final Builder loadBalancerTarget(AnalysisLoadBalancerTarget loadBalancerTarget) {
            this.loadBalancerTarget = loadBalancerTarget;
            return this;
        }

        public final AnalysisComponent.Builder getLoadBalancerTargetGroup() {
            return this.loadBalancerTargetGroup != null ? this.loadBalancerTargetGroup.toBuilder() : null;
        }

        public final void setLoadBalancerTargetGroup(AnalysisComponent.BuilderImpl loadBalancerTargetGroup) {
            this.loadBalancerTargetGroup = loadBalancerTargetGroup != null ? loadBalancerTargetGroup.build() : null;
        }

        @Override
        public final Builder loadBalancerTargetGroup(AnalysisComponent loadBalancerTargetGroup) {
            this.loadBalancerTargetGroup = loadBalancerTargetGroup;
            return this;
        }

        public final List<AnalysisComponent.Builder> getLoadBalancerTargetGroups() {
            List<AnalysisComponent.Builder> result = AnalysisComponentListCopier.copyToBuilder(this.loadBalancerTargetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancerTargetGroups(Collection<AnalysisComponent.BuilderImpl> loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups = AnalysisComponentListCopier.copyFromBuilder(loadBalancerTargetGroups);
        }

        @Override
        public final Builder loadBalancerTargetGroups(Collection<AnalysisComponent> loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups = AnalysisComponentListCopier.copy(loadBalancerTargetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerTargetGroups(AnalysisComponent ... loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups(Arrays.asList(loadBalancerTargetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerTargetGroups(Consumer<AnalysisComponent.Builder> ... loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups(Stream.of(loadBalancerTargetGroups).map(c -> (AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getLoadBalancerTargetPort() {
            return this.loadBalancerTargetPort;
        }

        public final void setLoadBalancerTargetPort(Integer loadBalancerTargetPort) {
            this.loadBalancerTargetPort = loadBalancerTargetPort;
        }

        @Override
        public final Builder loadBalancerTargetPort(Integer loadBalancerTargetPort) {
            this.loadBalancerTargetPort = loadBalancerTargetPort;
            return this;
        }

        public final AnalysisComponent.Builder getElasticLoadBalancerListener() {
            return this.elasticLoadBalancerListener != null ? this.elasticLoadBalancerListener.toBuilder() : null;
        }

        public final void setElasticLoadBalancerListener(AnalysisComponent.BuilderImpl elasticLoadBalancerListener) {
            this.elasticLoadBalancerListener = elasticLoadBalancerListener != null ? elasticLoadBalancerListener.build() : null;
        }

        @Override
        public final Builder elasticLoadBalancerListener(AnalysisComponent elasticLoadBalancerListener) {
            this.elasticLoadBalancerListener = elasticLoadBalancerListener;
            return this;
        }

        public final String getMissingComponent() {
            return this.missingComponent;
        }

        public final void setMissingComponent(String missingComponent) {
            this.missingComponent = missingComponent;
        }

        @Override
        public final Builder missingComponent(String missingComponent) {
            this.missingComponent = missingComponent;
            return this;
        }

        public final AnalysisComponent.Builder getNatGateway() {
            return this.natGateway != null ? this.natGateway.toBuilder() : null;
        }

        public final void setNatGateway(AnalysisComponent.BuilderImpl natGateway) {
            this.natGateway = natGateway != null ? natGateway.build() : null;
        }

        @Override
        public final Builder natGateway(AnalysisComponent natGateway) {
            this.natGateway = natGateway;
            return this;
        }

        public final AnalysisComponent.Builder getNetworkInterface() {
            return this.networkInterface != null ? this.networkInterface.toBuilder() : null;
        }

        public final void setNetworkInterface(AnalysisComponent.BuilderImpl networkInterface) {
            this.networkInterface = networkInterface != null ? networkInterface.build() : null;
        }

        @Override
        public final Builder networkInterface(AnalysisComponent networkInterface) {
            this.networkInterface = networkInterface;
            return this;
        }

        public final String getPacketField() {
            return this.packetField;
        }

        public final void setPacketField(String packetField) {
            this.packetField = packetField;
        }

        @Override
        public final Builder packetField(String packetField) {
            this.packetField = packetField;
            return this;
        }

        public final AnalysisComponent.Builder getVpcPeeringConnection() {
            return this.vpcPeeringConnection != null ? this.vpcPeeringConnection.toBuilder() : null;
        }

        public final void setVpcPeeringConnection(AnalysisComponent.BuilderImpl vpcPeeringConnection) {
            this.vpcPeeringConnection = vpcPeeringConnection != null ? vpcPeeringConnection.build() : null;
        }

        @Override
        public final Builder vpcPeeringConnection(AnalysisComponent vpcPeeringConnection) {
            this.vpcPeeringConnection = vpcPeeringConnection;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final List<PortRange.Builder> getPortRanges() {
            List<PortRange.Builder> result = PortRangeListCopier.copyToBuilder(this.portRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortRanges(Collection<PortRange.BuilderImpl> portRanges) {
            this.portRanges = PortRangeListCopier.copyFromBuilder(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<PortRange> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(PortRange ... portRanges) {
            this.portRanges(Arrays.asList(portRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(Consumer<PortRange.Builder> ... portRanges) {
            this.portRanges(Stream.of(portRanges).map(c -> (PortRange)((PortRange.Builder)PortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AnalysisComponent.Builder getPrefixList() {
            return this.prefixList != null ? this.prefixList.toBuilder() : null;
        }

        public final void setPrefixList(AnalysisComponent.BuilderImpl prefixList) {
            this.prefixList = prefixList != null ? prefixList.build() : null;
        }

        @Override
        public final Builder prefixList(AnalysisComponent prefixList) {
            this.prefixList = prefixList;
            return this;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = StringListCopier.copy(protocols);
        }

        @Override
        public final Builder protocols(Collection<String> protocols) {
            this.protocols = StringListCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(String ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public final AnalysisRouteTableRoute.Builder getRouteTableRoute() {
            return this.routeTableRoute != null ? this.routeTableRoute.toBuilder() : null;
        }

        public final void setRouteTableRoute(AnalysisRouteTableRoute.BuilderImpl routeTableRoute) {
            this.routeTableRoute = routeTableRoute != null ? routeTableRoute.build() : null;
        }

        @Override
        public final Builder routeTableRoute(AnalysisRouteTableRoute routeTableRoute) {
            this.routeTableRoute = routeTableRoute;
            return this;
        }

        public final AnalysisComponent.Builder getRouteTable() {
            return this.routeTable != null ? this.routeTable.toBuilder() : null;
        }

        public final void setRouteTable(AnalysisComponent.BuilderImpl routeTable) {
            this.routeTable = routeTable != null ? routeTable.build() : null;
        }

        @Override
        public final Builder routeTable(AnalysisComponent routeTable) {
            this.routeTable = routeTable;
            return this;
        }

        public final AnalysisComponent.Builder getSecurityGroup() {
            return this.securityGroup != null ? this.securityGroup.toBuilder() : null;
        }

        public final void setSecurityGroup(AnalysisComponent.BuilderImpl securityGroup) {
            this.securityGroup = securityGroup != null ? securityGroup.build() : null;
        }

        @Override
        public final Builder securityGroup(AnalysisComponent securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public final AnalysisSecurityGroupRule.Builder getSecurityGroupRule() {
            return this.securityGroupRule != null ? this.securityGroupRule.toBuilder() : null;
        }

        public final void setSecurityGroupRule(AnalysisSecurityGroupRule.BuilderImpl securityGroupRule) {
            this.securityGroupRule = securityGroupRule != null ? securityGroupRule.build() : null;
        }

        @Override
        public final Builder securityGroupRule(AnalysisSecurityGroupRule securityGroupRule) {
            this.securityGroupRule = securityGroupRule;
            return this;
        }

        public final List<AnalysisComponent.Builder> getSecurityGroups() {
            List<AnalysisComponent.Builder> result = AnalysisComponentListCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<AnalysisComponent.BuilderImpl> securityGroups) {
            this.securityGroups = AnalysisComponentListCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<AnalysisComponent> securityGroups) {
            this.securityGroups = AnalysisComponentListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(AnalysisComponent ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<AnalysisComponent.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AnalysisComponent.Builder getSourceVpc() {
            return this.sourceVpc != null ? this.sourceVpc.toBuilder() : null;
        }

        public final void setSourceVpc(AnalysisComponent.BuilderImpl sourceVpc) {
            this.sourceVpc = sourceVpc != null ? sourceVpc.build() : null;
        }

        @Override
        public final Builder sourceVpc(AnalysisComponent sourceVpc) {
            this.sourceVpc = sourceVpc;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final AnalysisComponent.Builder getSubnet() {
            return this.subnet != null ? this.subnet.toBuilder() : null;
        }

        public final void setSubnet(AnalysisComponent.BuilderImpl subnet) {
            this.subnet = subnet != null ? subnet.build() : null;
        }

        @Override
        public final Builder subnet(AnalysisComponent subnet) {
            this.subnet = subnet;
            return this;
        }

        public final AnalysisComponent.Builder getSubnetRouteTable() {
            return this.subnetRouteTable != null ? this.subnetRouteTable.toBuilder() : null;
        }

        public final void setSubnetRouteTable(AnalysisComponent.BuilderImpl subnetRouteTable) {
            this.subnetRouteTable = subnetRouteTable != null ? subnetRouteTable.build() : null;
        }

        @Override
        public final Builder subnetRouteTable(AnalysisComponent subnetRouteTable) {
            this.subnetRouteTable = subnetRouteTable;
            return this;
        }

        public final AnalysisComponent.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        public final void setVpc(AnalysisComponent.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(AnalysisComponent vpc) {
            this.vpc = vpc;
            return this;
        }

        public final AnalysisComponent.Builder getVpcEndpoint() {
            return this.vpcEndpoint != null ? this.vpcEndpoint.toBuilder() : null;
        }

        public final void setVpcEndpoint(AnalysisComponent.BuilderImpl vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint != null ? vpcEndpoint.build() : null;
        }

        @Override
        public final Builder vpcEndpoint(AnalysisComponent vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
            return this;
        }

        public final AnalysisComponent.Builder getVpnConnection() {
            return this.vpnConnection != null ? this.vpnConnection.toBuilder() : null;
        }

        public final void setVpnConnection(AnalysisComponent.BuilderImpl vpnConnection) {
            this.vpnConnection = vpnConnection != null ? vpnConnection.build() : null;
        }

        @Override
        public final Builder vpnConnection(AnalysisComponent vpnConnection) {
            this.vpnConnection = vpnConnection;
            return this;
        }

        public final AnalysisComponent.Builder getVpnGateway() {
            return this.vpnGateway != null ? this.vpnGateway.toBuilder() : null;
        }

        public final void setVpnGateway(AnalysisComponent.BuilderImpl vpnGateway) {
            this.vpnGateway = vpnGateway != null ? vpnGateway.build() : null;
        }

        @Override
        public final Builder vpnGateway(AnalysisComponent vpnGateway) {
            this.vpnGateway = vpnGateway;
            return this;
        }

        public final AnalysisComponent.Builder getTransitGateway() {
            return this.transitGateway != null ? this.transitGateway.toBuilder() : null;
        }

        public final void setTransitGateway(AnalysisComponent.BuilderImpl transitGateway) {
            this.transitGateway = transitGateway != null ? transitGateway.build() : null;
        }

        @Override
        public final Builder transitGateway(AnalysisComponent transitGateway) {
            this.transitGateway = transitGateway;
            return this;
        }

        public final AnalysisComponent.Builder getTransitGatewayRouteTable() {
            return this.transitGatewayRouteTable != null ? this.transitGatewayRouteTable.toBuilder() : null;
        }

        public final void setTransitGatewayRouteTable(AnalysisComponent.BuilderImpl transitGatewayRouteTable) {
            this.transitGatewayRouteTable = transitGatewayRouteTable != null ? transitGatewayRouteTable.build() : null;
        }

        @Override
        public final Builder transitGatewayRouteTable(AnalysisComponent transitGatewayRouteTable) {
            this.transitGatewayRouteTable = transitGatewayRouteTable;
            return this;
        }

        public final TransitGatewayRouteTableRoute.Builder getTransitGatewayRouteTableRoute() {
            return this.transitGatewayRouteTableRoute != null ? this.transitGatewayRouteTableRoute.toBuilder() : null;
        }

        public final void setTransitGatewayRouteTableRoute(TransitGatewayRouteTableRoute.BuilderImpl transitGatewayRouteTableRoute) {
            this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute != null ? transitGatewayRouteTableRoute.build() : null;
        }

        @Override
        public final Builder transitGatewayRouteTableRoute(TransitGatewayRouteTableRoute transitGatewayRouteTableRoute) {
            this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute;
            return this;
        }

        public final AnalysisComponent.Builder getTransitGatewayAttachment() {
            return this.transitGatewayAttachment != null ? this.transitGatewayAttachment.toBuilder() : null;
        }

        public final void setTransitGatewayAttachment(AnalysisComponent.BuilderImpl transitGatewayAttachment) {
            this.transitGatewayAttachment = transitGatewayAttachment != null ? transitGatewayAttachment.build() : null;
        }

        @Override
        public final Builder transitGatewayAttachment(AnalysisComponent transitGatewayAttachment) {
            this.transitGatewayAttachment = transitGatewayAttachment;
            return this;
        }

        public final String getComponentAccount() {
            return this.componentAccount;
        }

        public final void setComponentAccount(String componentAccount) {
            this.componentAccount = componentAccount;
        }

        @Override
        public final Builder componentAccount(String componentAccount) {
            this.componentAccount = componentAccount;
            return this;
        }

        public final String getComponentRegion() {
            return this.componentRegion;
        }

        public final void setComponentRegion(String componentRegion) {
            this.componentRegion = componentRegion;
        }

        @Override
        public final Builder componentRegion(String componentRegion) {
            this.componentRegion = componentRegion;
            return this;
        }

        public final FirewallStatelessRule.Builder getFirewallStatelessRule() {
            return this.firewallStatelessRule != null ? this.firewallStatelessRule.toBuilder() : null;
        }

        public final void setFirewallStatelessRule(FirewallStatelessRule.BuilderImpl firewallStatelessRule) {
            this.firewallStatelessRule = firewallStatelessRule != null ? firewallStatelessRule.build() : null;
        }

        @Override
        public final Builder firewallStatelessRule(FirewallStatelessRule firewallStatelessRule) {
            this.firewallStatelessRule = firewallStatelessRule;
            return this;
        }

        public final FirewallStatefulRule.Builder getFirewallStatefulRule() {
            return this.firewallStatefulRule != null ? this.firewallStatefulRule.toBuilder() : null;
        }

        public final void setFirewallStatefulRule(FirewallStatefulRule.BuilderImpl firewallStatefulRule) {
            this.firewallStatefulRule = firewallStatefulRule != null ? firewallStatefulRule.build() : null;
        }

        @Override
        public final Builder firewallStatefulRule(FirewallStatefulRule firewallStatefulRule) {
            this.firewallStatefulRule = firewallStatefulRule;
            return this;
        }

        public Explanation build() {
            return new Explanation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Explanation> {
        public Builder acl(AnalysisComponent var1);

        default public Builder acl(Consumer<AnalysisComponent.Builder> acl) {
            return this.acl((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(acl)).build());
        }

        public Builder aclRule(AnalysisAclRule var1);

        default public Builder aclRule(Consumer<AnalysisAclRule.Builder> aclRule) {
            return this.aclRule((AnalysisAclRule)((AnalysisAclRule.Builder)AnalysisAclRule.builder().applyMutation(aclRule)).build());
        }

        public Builder address(String var1);

        public Builder addresses(Collection<String> var1);

        public Builder addresses(String ... var1);

        public Builder attachedTo(AnalysisComponent var1);

        default public Builder attachedTo(Consumer<AnalysisComponent.Builder> attachedTo) {
            return this.attachedTo((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(attachedTo)).build());
        }

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder availabilityZoneIds(Collection<String> var1);

        public Builder availabilityZoneIds(String ... var1);

        public Builder cidrs(Collection<String> var1);

        public Builder cidrs(String ... var1);

        public Builder component(AnalysisComponent var1);

        default public Builder component(Consumer<AnalysisComponent.Builder> component) {
            return this.component((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(component)).build());
        }

        public Builder customerGateway(AnalysisComponent var1);

        default public Builder customerGateway(Consumer<AnalysisComponent.Builder> customerGateway) {
            return this.customerGateway((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(customerGateway)).build());
        }

        public Builder destination(AnalysisComponent var1);

        default public Builder destination(Consumer<AnalysisComponent.Builder> destination) {
            return this.destination((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(destination)).build());
        }

        public Builder destinationVpc(AnalysisComponent var1);

        default public Builder destinationVpc(Consumer<AnalysisComponent.Builder> destinationVpc) {
            return this.destinationVpc((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(destinationVpc)).build());
        }

        public Builder direction(String var1);

        public Builder explanationCode(String var1);

        public Builder ingressRouteTable(AnalysisComponent var1);

        default public Builder ingressRouteTable(Consumer<AnalysisComponent.Builder> ingressRouteTable) {
            return this.ingressRouteTable((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(ingressRouteTable)).build());
        }

        public Builder internetGateway(AnalysisComponent var1);

        default public Builder internetGateway(Consumer<AnalysisComponent.Builder> internetGateway) {
            return this.internetGateway((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(internetGateway)).build());
        }

        public Builder loadBalancerArn(String var1);

        public Builder classicLoadBalancerListener(AnalysisLoadBalancerListener var1);

        default public Builder classicLoadBalancerListener(Consumer<AnalysisLoadBalancerListener.Builder> classicLoadBalancerListener) {
            return this.classicLoadBalancerListener((AnalysisLoadBalancerListener)((AnalysisLoadBalancerListener.Builder)AnalysisLoadBalancerListener.builder().applyMutation(classicLoadBalancerListener)).build());
        }

        public Builder loadBalancerListenerPort(Integer var1);

        public Builder loadBalancerTarget(AnalysisLoadBalancerTarget var1);

        default public Builder loadBalancerTarget(Consumer<AnalysisLoadBalancerTarget.Builder> loadBalancerTarget) {
            return this.loadBalancerTarget((AnalysisLoadBalancerTarget)((AnalysisLoadBalancerTarget.Builder)AnalysisLoadBalancerTarget.builder().applyMutation(loadBalancerTarget)).build());
        }

        public Builder loadBalancerTargetGroup(AnalysisComponent var1);

        default public Builder loadBalancerTargetGroup(Consumer<AnalysisComponent.Builder> loadBalancerTargetGroup) {
            return this.loadBalancerTargetGroup((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(loadBalancerTargetGroup)).build());
        }

        public Builder loadBalancerTargetGroups(Collection<AnalysisComponent> var1);

        public Builder loadBalancerTargetGroups(AnalysisComponent ... var1);

        public Builder loadBalancerTargetGroups(Consumer<AnalysisComponent.Builder> ... var1);

        public Builder loadBalancerTargetPort(Integer var1);

        public Builder elasticLoadBalancerListener(AnalysisComponent var1);

        default public Builder elasticLoadBalancerListener(Consumer<AnalysisComponent.Builder> elasticLoadBalancerListener) {
            return this.elasticLoadBalancerListener((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(elasticLoadBalancerListener)).build());
        }

        public Builder missingComponent(String var1);

        public Builder natGateway(AnalysisComponent var1);

        default public Builder natGateway(Consumer<AnalysisComponent.Builder> natGateway) {
            return this.natGateway((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(natGateway)).build());
        }

        public Builder networkInterface(AnalysisComponent var1);

        default public Builder networkInterface(Consumer<AnalysisComponent.Builder> networkInterface) {
            return this.networkInterface((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(networkInterface)).build());
        }

        public Builder packetField(String var1);

        public Builder vpcPeeringConnection(AnalysisComponent var1);

        default public Builder vpcPeeringConnection(Consumer<AnalysisComponent.Builder> vpcPeeringConnection) {
            return this.vpcPeeringConnection((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(vpcPeeringConnection)).build());
        }

        public Builder port(Integer var1);

        public Builder portRanges(Collection<PortRange> var1);

        public Builder portRanges(PortRange ... var1);

        public Builder portRanges(Consumer<PortRange.Builder> ... var1);

        public Builder prefixList(AnalysisComponent var1);

        default public Builder prefixList(Consumer<AnalysisComponent.Builder> prefixList) {
            return this.prefixList((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(prefixList)).build());
        }

        public Builder protocols(Collection<String> var1);

        public Builder protocols(String ... var1);

        public Builder routeTableRoute(AnalysisRouteTableRoute var1);

        default public Builder routeTableRoute(Consumer<AnalysisRouteTableRoute.Builder> routeTableRoute) {
            return this.routeTableRoute((AnalysisRouteTableRoute)((AnalysisRouteTableRoute.Builder)AnalysisRouteTableRoute.builder().applyMutation(routeTableRoute)).build());
        }

        public Builder routeTable(AnalysisComponent var1);

        default public Builder routeTable(Consumer<AnalysisComponent.Builder> routeTable) {
            return this.routeTable((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(routeTable)).build());
        }

        public Builder securityGroup(AnalysisComponent var1);

        default public Builder securityGroup(Consumer<AnalysisComponent.Builder> securityGroup) {
            return this.securityGroup((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(securityGroup)).build());
        }

        public Builder securityGroupRule(AnalysisSecurityGroupRule var1);

        default public Builder securityGroupRule(Consumer<AnalysisSecurityGroupRule.Builder> securityGroupRule) {
            return this.securityGroupRule((AnalysisSecurityGroupRule)((AnalysisSecurityGroupRule.Builder)AnalysisSecurityGroupRule.builder().applyMutation(securityGroupRule)).build());
        }

        public Builder securityGroups(Collection<AnalysisComponent> var1);

        public Builder securityGroups(AnalysisComponent ... var1);

        public Builder securityGroups(Consumer<AnalysisComponent.Builder> ... var1);

        public Builder sourceVpc(AnalysisComponent var1);

        default public Builder sourceVpc(Consumer<AnalysisComponent.Builder> sourceVpc) {
            return this.sourceVpc((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(sourceVpc)).build());
        }

        public Builder state(String var1);

        public Builder subnet(AnalysisComponent var1);

        default public Builder subnet(Consumer<AnalysisComponent.Builder> subnet) {
            return this.subnet((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(subnet)).build());
        }

        public Builder subnetRouteTable(AnalysisComponent var1);

        default public Builder subnetRouteTable(Consumer<AnalysisComponent.Builder> subnetRouteTable) {
            return this.subnetRouteTable((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(subnetRouteTable)).build());
        }

        public Builder vpc(AnalysisComponent var1);

        default public Builder vpc(Consumer<AnalysisComponent.Builder> vpc) {
            return this.vpc((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(vpc)).build());
        }

        public Builder vpcEndpoint(AnalysisComponent var1);

        default public Builder vpcEndpoint(Consumer<AnalysisComponent.Builder> vpcEndpoint) {
            return this.vpcEndpoint((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(vpcEndpoint)).build());
        }

        public Builder vpnConnection(AnalysisComponent var1);

        default public Builder vpnConnection(Consumer<AnalysisComponent.Builder> vpnConnection) {
            return this.vpnConnection((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(vpnConnection)).build());
        }

        public Builder vpnGateway(AnalysisComponent var1);

        default public Builder vpnGateway(Consumer<AnalysisComponent.Builder> vpnGateway) {
            return this.vpnGateway((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(vpnGateway)).build());
        }

        public Builder transitGateway(AnalysisComponent var1);

        default public Builder transitGateway(Consumer<AnalysisComponent.Builder> transitGateway) {
            return this.transitGateway((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(transitGateway)).build());
        }

        public Builder transitGatewayRouteTable(AnalysisComponent var1);

        default public Builder transitGatewayRouteTable(Consumer<AnalysisComponent.Builder> transitGatewayRouteTable) {
            return this.transitGatewayRouteTable((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(transitGatewayRouteTable)).build());
        }

        public Builder transitGatewayRouteTableRoute(TransitGatewayRouteTableRoute var1);

        default public Builder transitGatewayRouteTableRoute(Consumer<TransitGatewayRouteTableRoute.Builder> transitGatewayRouteTableRoute) {
            return this.transitGatewayRouteTableRoute((TransitGatewayRouteTableRoute)((TransitGatewayRouteTableRoute.Builder)TransitGatewayRouteTableRoute.builder().applyMutation(transitGatewayRouteTableRoute)).build());
        }

        public Builder transitGatewayAttachment(AnalysisComponent var1);

        default public Builder transitGatewayAttachment(Consumer<AnalysisComponent.Builder> transitGatewayAttachment) {
            return this.transitGatewayAttachment((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(transitGatewayAttachment)).build());
        }

        public Builder componentAccount(String var1);

        public Builder componentRegion(String var1);

        public Builder firewallStatelessRule(FirewallStatelessRule var1);

        default public Builder firewallStatelessRule(Consumer<FirewallStatelessRule.Builder> firewallStatelessRule) {
            return this.firewallStatelessRule((FirewallStatelessRule)((FirewallStatelessRule.Builder)FirewallStatelessRule.builder().applyMutation(firewallStatelessRule)).build());
        }

        public Builder firewallStatefulRule(FirewallStatefulRule var1);

        default public Builder firewallStatefulRule(Consumer<FirewallStatefulRule.Builder> firewallStatefulRule) {
            return this.firewallStatefulRule((FirewallStatefulRule)((FirewallStatefulRule.Builder)FirewallStatefulRule.builder().applyMutation(firewallStatefulRule)).build());
        }
    }
}

