/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.utils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.WithModelTool;
import org.opensearch.search.builder.SearchSourceBuilder;

public class AgentModelsSearcher {
    private final Set<String> relatedModelIdSet = new HashSet<String>();

    public AgentModelsSearcher(Map<String, Tool.Factory> toolFactories) {
        for (Map.Entry<String, Tool.Factory> entry : toolFactories.entrySet()) {
            Tool.Factory toolFactory = entry.getValue();
            if (!(toolFactory instanceof WithModelTool.Factory)) continue;
            WithModelTool.Factory withModelTool = (WithModelTool.Factory)toolFactory;
            this.relatedModelIdSet.addAll(withModelTool.getAllModelKeys());
        }
    }

    public SearchRequest constructQueryRequestToSearchModelIdInsideAgent(String candidateModelId) {
        SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-agent"});
        BoolQueryBuilder searchAgentQuery = QueryBuilders.boolQuery();
        BoolQueryBuilder hiddenFieldQuery = QueryBuilders.boolQuery();
        hiddenFieldQuery.should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"is_hidden")));
        BoolQueryBuilder existHiddenFieldQuery = QueryBuilders.boolQuery();
        existHiddenFieldQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"is_hidden", (Object[])new Object[]{false}));
        existHiddenFieldQuery.must((QueryBuilder)QueryBuilders.existsQuery((String)"is_hidden"));
        hiddenFieldQuery.should((QueryBuilder)existHiddenFieldQuery);
        BoolQueryBuilder modelIdQuery = QueryBuilders.boolQuery();
        for (String keyField : this.relatedModelIdSet) {
            modelIdQuery.should((QueryBuilder)QueryBuilders.termsQuery((String)("tools.parameters." + keyField), (String[])new String[]{candidateModelId}));
        }
        searchAgentQuery.must((QueryBuilder)hiddenFieldQuery);
        searchAgentQuery.must((QueryBuilder)modelIdQuery);
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)searchAgentQuery));
        return searchRequest;
    }
}

