/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.anomaly.evaluation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tribuo.Prediction;
import org.tribuo.anomaly.Event;
import org.tribuo.anomaly.evaluation.AnomalyEvaluation;
import org.tribuo.anomaly.evaluation.AnomalyMetric;
import org.tribuo.anomaly.evaluation.AnomalyMetrics;
import org.tribuo.evaluation.metrics.MetricID;
import org.tribuo.provenance.EvaluationProvenance;

final class AnomalyEvaluationImpl
implements AnomalyEvaluation {
    private final Map<MetricID<Event>, Double> results;
    private final AnomalyMetric.Context context;
    private final EvaluationProvenance provenance;

    AnomalyEvaluationImpl(Map<MetricID<Event>, Double> results, AnomalyMetric.Context ctx, EvaluationProvenance provenance) {
        this.results = results;
        this.context = ctx;
        this.provenance = provenance;
    }

    public List<Prediction<Event>> getPredictions() {
        return this.context.getPredictions();
    }

    @Override
    public long getFalsePositives() {
        return (long)this.get(AnomalyMetrics.FP);
    }

    @Override
    public long getTruePositives() {
        return (long)this.get(AnomalyMetrics.TP);
    }

    @Override
    public long getTrueNegatives() {
        return (long)this.get(AnomalyMetrics.TN);
    }

    @Override
    public long getFalseNegatives() {
        return (long)this.get(AnomalyMetrics.FN);
    }

    @Override
    public double getPrecision() {
        return this.get(AnomalyMetrics.PRECISION);
    }

    @Override
    public double getRecall() {
        return this.get(AnomalyMetrics.RECALL);
    }

    @Override
    public double getF1() {
        return this.get(AnomalyMetrics.F1);
    }

    public Map<MetricID<Event>, Double> asMap() {
        return Collections.unmodifiableMap(this.results);
    }

    public EvaluationProvenance getProvenance() {
        return this.provenance;
    }

    public String toString() {
        return String.format("AnomalyEvaluation(tp=%d fp=%d tn=%d fn=%d precision=%f recall=%f f1=%f)", this.getTruePositives(), this.getFalsePositives(), this.getTrueNegatives(), this.getFalseNegatives(), this.getPrecision(), this.getRecall(), this.getF1());
    }

    @Override
    public String confusionString() {
        int maxLen = Integer.MIN_VALUE;
        maxLen = Math.max(Event.EventType.EXPECTED.name().length(), maxLen);
        maxLen = Math.max(Event.EventType.ANOMALOUS.name().length(), maxLen);
        maxLen = Math.max(String.format(" %,d", this.getTrueNegatives()).length(), maxLen);
        maxLen = Math.max(String.format(" %,d", this.getTruePositives()).length(), maxLen);
        maxLen = Math.max(String.format(" %,d", this.getFalseNegatives()).length(), maxLen);
        maxLen = Math.max(String.format(" %,d", this.getFalsePositives()).length(), maxLen);
        StringBuilder sb = new StringBuilder();
        String trueLabelFormat = String.format("%%-%ds", maxLen + 2);
        String predictedLabelFormat = String.format("%%%ds", maxLen + 2);
        String countFormat = String.format("%%,%dd", maxLen + 2);
        sb.append(String.format(trueLabelFormat, ""));
        sb.append(String.format(predictedLabelFormat, Event.EventType.EXPECTED.name()));
        sb.append(String.format(predictedLabelFormat, Event.EventType.ANOMALOUS.name()));
        sb.append('\n');
        sb.append(String.format(trueLabelFormat, Event.EventType.EXPECTED.name()));
        sb.append(String.format(countFormat, this.getTrueNegatives()));
        sb.append(String.format(countFormat, this.getFalsePositives()));
        sb.append('\n');
        sb.append(String.format(trueLabelFormat, Event.EventType.ANOMALOUS.name()));
        sb.append(String.format(countFormat, this.getFalseNegatives()));
        sb.append(String.format(countFormat, this.getTruePositives()));
        sb.append('\n');
        return sb.toString();
    }

    private double get(AnomalyMetrics metric) {
        double value = this.get(metric.asMetric().getID());
        return value;
    }
}

