/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.contextmanagement.MLDeleteContextManagementTemplateAction;
import org.opensearch.ml.common.transport.contextmanagement.MLDeleteContextManagementTemplateRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLDeleteContextManagementTemplateAction
extends BaseRestHandler {
    private static final String ML_DELETE_CONTEXT_MANAGEMENT_TEMPLATE_ACTION = "ml_delete_context_management_template_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLDeleteContextManagementTemplateAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_DELETE_CONTEXT_MANAGEMENT_TEMPLATE_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/context_management/{%s}", "/_plugins/_ml", "template_name")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLDeleteContextManagementTemplateRequest deleteRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLDeleteContextManagementTemplateAction.INSTANCE, (ActionRequest)deleteRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLDeleteContextManagementTemplateRequest getRequest(RestRequest request) throws IOException {
        if (!this.mlFeatureEnabledSetting.isAgentFrameworkEnabled()) {
            throw new IllegalStateException("Agent framework is disabled");
        }
        String templateName = request.param("template_name");
        if (templateName == null || templateName.trim().isEmpty()) {
            throw new IllegalArgumentException("Template name is required");
        }
        return new MLDeleteContextManagementTemplateRequest(templateName);
    }
}

