/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.encoding.impl;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.SerializeSupport;
import org.apache.velocity.VelocityContext;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.SAMLMessageSecuritySupport;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPPostEncoder;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.slf4j.Logger;

public class HTTPPostSimpleSignEncoder
extends HTTPPostEncoder {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_TEMPLATE_ID = "/templates/saml2-post-simplesign-binding.vm";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPPostSimpleSignEncoder.class);

    public HTTPPostSimpleSignEncoder() {
        this.setVelocityTemplateId(DEFAULT_TEMPLATE_ID);
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign";
    }

    @Override
    protected void populateVelocityContext(@Nonnull VelocityContext velocityContext, @Nonnull MessageContext messageContext, @Nonnull @NotEmpty String endpointURL) throws MessageEncodingException {
        String kiBase64;
        Credential signingCredential;
        super.populateVelocityContext(velocityContext, messageContext, endpointURL);
        SignatureSigningParameters signingParameters = SAMLMessageSecuritySupport.getContextSigningParameters(messageContext);
        Credential credential = signingCredential = signingParameters != null ? signingParameters.getSigningCredential() : null;
        if (signingParameters == null || signingCredential == null) {
            this.log.debug("No signing credential was supplied, skipping HTTP-Post simple signing");
            return;
        }
        String sigAlgURI = this.getSignatureAlgorithmURI(signingParameters);
        velocityContext.put("SigAlg", (Object)sigAlgURI);
        String formControlData = this.buildFormDataToSign(velocityContext, messageContext, sigAlgURI);
        velocityContext.put("Signature", (Object)this.generateSignature(signingCredential, sigAlgURI, formControlData));
        KeyInfoGenerator kiGenerator = signingParameters.getKeyInfoGenerator();
        if (kiGenerator != null && !Strings.isNullOrEmpty((String)(kiBase64 = this.buildKeyInfo(signingCredential, kiGenerator)))) {
            velocityContext.put("KeyInfo", (Object)kiBase64);
        }
    }

    @Nullable
    protected String buildKeyInfo(@Nonnull Credential signingCredential, @Nonnull KeyInfoGenerator kiGenerator) throws MessageEncodingException {
        try {
            KeyInfo keyInfo = kiGenerator.generate(signingCredential);
            if (keyInfo != null) {
                Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(keyInfo);
                if (marshaller == null) {
                    this.log.error("No KeyInfo marshaller available from configuration");
                    throw new MessageEncodingException("No KeyInfo marshaller was configured");
                }
                String kiXML = SerializeSupport.nodeToString(marshaller.marshall(keyInfo));
                String kiBase64 = Base64Support.encode(kiXML.getBytes(), false);
                return kiBase64;
            }
            return null;
        }
        catch (SecurityException e) {
            this.log.error("Error generating KeyInfo from signing credential: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Error generating KeyInfo from signing credential", e);
        }
        catch (MarshallingException e) {
            this.log.error("Error marshalling KeyInfo based on signing credential: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Error marshalling KeyInfo based on signing credential", e);
        }
        catch (EncodingException e) {
            this.log.error("Error base64 encoding KeyInfo from signing credential: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Error base64 encoding KeyInfo from signing credential", e);
        }
    }

    @Nonnull
    protected String buildFormDataToSign(@Nonnull VelocityContext velocityContext, @Nonnull MessageContext messageContext, @Nonnull String sigAlgURI) throws MessageEncodingException {
        StringBuilder builder = new StringBuilder();
        boolean isRequest = false;
        if (velocityContext.get("SAMLRequest") != null) {
            isRequest = true;
        }
        String msgB64 = isRequest ? (String)velocityContext.get("SAMLRequest") : (String)velocityContext.get("SAMLResponse");
        assert (msgB64 != null);
        String msg = null;
        try {
            msg = new String(Base64Support.decode(msgB64), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageEncodingException("Unable to decode message as string, UTF-8 encoding is not supported", e);
        }
        catch (DecodingException e) {
            throw new MessageEncodingException("Error base64-decoding the " + (isRequest ? "SAMLRequest" : "SAMLResponse"), e);
        }
        if (isRequest) {
            builder.append("SAMLRequest=" + msg);
        } else {
            builder.append("SAMLResponse=" + msg);
        }
        String relayState = SAMLBindingSupport.getRelayState(messageContext);
        if (relayState != null) {
            builder.append("&RelayState=" + relayState);
        }
        builder.append("&SigAlg=" + sigAlgURI);
        return builder.toString();
    }

    @Nonnull
    protected String getSignatureAlgorithmURI(@Nonnull SignatureSigningParameters signingParameters) throws MessageEncodingException {
        String alg = signingParameters.getSignatureAlgorithm();
        if (alg != null) {
            return alg;
        }
        throw new MessageEncodingException("The signing algorithm URI could not be determined");
    }

    @Nonnull
    protected String generateSignature(@Nonnull Credential signingCredential, @Nonnull String algorithmURI, String formData) throws MessageEncodingException {
        this.log.debug("Generating signature with algorithm URI '{}' over form control string '{}'", (Object)algorithmURI, (Object)formData);
        String b64Signature = null;
        try {
            byte[] rawSignature = XMLSigningUtil.signWithURI(signingCredential, algorithmURI, formData.getBytes("UTF-8"));
            b64Signature = Base64Support.encode(rawSignature, false);
            this.log.debug("Generated digital signature value (base64-encoded) {}", (Object)b64Signature);
        }
        catch (SecurityException e) {
            this.log.error("Error during URL signing process: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Unable to sign form control string", e);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("UTF-8 encoding is not supported, this VM is not Java compliant");
            throw new MessageEncodingException("Unable to encode message, UTF-8 encoding is not supported");
        }
        catch (EncodingException e) {
            this.log.error("Error base64 encoding signature of form control data: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Unable to base64 encode signature of form control data", e);
        }
        return b64Signature;
    }
}

