/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

public enum OptionKey {
    LANGUAGE,
    USE_DESCRIPTIVE_NAMES,
    HANDWRITTEN("true"),
    DEBUG("true"),
    SVG_DESC,
    SVG_TITLE;

    private final String defaultValue;

    private OptionKey() {
        this(null);
    }

    private OptionKey(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public final String getDefaultValue() {
        return this.defaultValue;
    }

    public static String simplify(String s) {
        StringBuilder result = new StringBuilder();
        for (char c : s.toCharArray()) {
            if ((c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) continue;
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    public static OptionKey lazyFrom(String s) {
        for (OptionKey key : OptionKey.values()) {
            if (!OptionKey.simplify(s).equals(OptionKey.simplify(key.name()))) continue;
            return key;
        }
        return null;
    }
}

