/* boc-provider.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from boc-provider.vala, do not modify */

#include "calculator.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BC_CURRENCY_PROVIDER_0_PROPERTY,
	BC_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY,
	BC_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY,
	BC_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY,
	BC_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY,
	BC_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY,
	BC_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* bc_currency_provider_properties[BC_CURRENCY_PROVIDER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))

struct _BCCurrencyProviderPrivate {
	gchar* _currency;
	gchar* _currency_filename;
};

static gint BCCurrencyProvider_private_offset;
static gpointer bc_currency_provider_parent_class = NULL;

static GDateTime* bc_currency_provider_real_parse_date (AbstractCurrencyProvider* base,
                                                 const gchar* date);
static gboolean bc_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base);
static void bc_currency_provider_set_rate (BCCurrencyProvider* self,
                                    const gchar* name,
                                    const gchar* value,
                                    Number* cad_rate,
                                    const gchar* date);
static const gchar* bc_currency_provider_get_currency (BCCurrencyProvider* self);
static void bc_currency_provider_set_currency (BCCurrencyProvider* self,
                                        const gchar* value);
static void bc_currency_provider_set_currency_filename (BCCurrencyProvider* self,
                                                 const gchar* value);
static const gchar* bc_currency_provider_get_currency_filename (BCCurrencyProvider* self);
static void bc_currency_provider_finalize (GObject * obj);
static GType bc_currency_provider_get_type_once (void);
static void _vala_bc_currency_provider_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_bc_currency_provider_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
bc_currency_provider_get_instance_private (BCCurrencyProvider* self)
{
	return G_STRUCT_MEMBER_P (self, BCCurrencyProvider_private_offset);
}

static GDateTime*
bc_currency_provider_real_parse_date (AbstractCurrencyProvider* base,
                                      const gchar* date)
{
	BCCurrencyProvider * self;
	gchar** array = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint array_length1;
	gint _array_size_;
	gint year = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gint month = 0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gint day = 0;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	GTimeZone* _tmp8_;
	GTimeZone* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* result;
	self = (BCCurrencyProvider*) base;
	if (date == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = _tmp0_ = g_strsplit (date, "-", 0);
	array = _tmp1_;
	array_length1 = _vala_array_length (_tmp0_);
	_array_size_ = array_length1;
	_tmp2_ = array;
	_tmp2__length1 = array_length1;
	_tmp3_ = _tmp2_[0];
	year = atoi (_tmp3_);
	_tmp4_ = array;
	_tmp4__length1 = array_length1;
	_tmp5_ = _tmp4_[1];
	month = atoi (_tmp5_);
	_tmp6_ = array;
	_tmp6__length1 = array_length1;
	_tmp7_ = _tmp6_[2];
	day = atoi (_tmp7_);
	_tmp8_ = g_time_zone_new_local ();
	_tmp9_ = _tmp8_;
	_tmp10_ = g_date_time_new (_tmp9_, year, month, day, 0, 0, (gdouble) 0);
	_tmp11_ = _tmp10_;
	_g_time_zone_unref0 (_tmp9_);
	result = _tmp11_;
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gboolean
bc_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base)
{
	BCCurrencyProvider * self;
	Currency* cad_rate = NULL;
	Currency* _tmp0_;
	Currency* _tmp1_;
	xmlDoc* document = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	xmlDoc* _tmp5_;
	xmlDoc* _tmp6_;
	xmlDoc* _tmp7_;
	xmlXPathContext* xpath_ctx = NULL;
	xmlDoc* _tmp11_;
	xmlXPathContext* _tmp12_;
	xmlXPathContext* _tmp13_;
	xmlXPathObject* xpath_obj = NULL;
	xmlXPathContext* _tmp14_;
	xmlXPathObject* _tmp15_;
	xmlXPathObject* _tmp16_;
	xmlXPathObject* xpath_date = NULL;
	xmlXPathContext* _tmp17_;
	xmlXPathObject* _tmp18_;
	gchar* _tmp19_ = NULL;
	xmlXPathObject* _tmp20_;
	xmlNodeSet* _tmp21_;
	gchar* date = NULL;
	gchar* _tmp26_;
	xmlNode* node = NULL;
	xmlXPathObject* _tmp27_;
	xmlNodeSet* _tmp28_;
	xmlNode* _tmp29_;
	gchar* rate = NULL;
	xmlNode* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	Currency* _tmp34_;
	Number* _tmp35_;
	Number* _tmp36_;
	const gchar* _tmp37_;
	gboolean result;
	self = (BCCurrencyProvider*) base;
	_tmp0_ = abstract_currency_provider_get_base_currency ((AbstractCurrencyProvider*) self);
	cad_rate = _tmp0_;
	_tmp1_ = cad_rate;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (cad_rate);
		return result;
	}
	xmlInitParser ();
	_tmp2_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = xmlReadFile (_tmp4_, NULL, 0);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	document = _tmp6_;
	_tmp7_ = document;
	if (_tmp7_ == NULL) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		g_warning ("boc-provider.vala:40: Couldn't parse rate file %s", _tmp10_);
		_g_free0 (_tmp10_);
		result = FALSE;
		_g_object_unref0 (cad_rate);
		return result;
	}
	_tmp11_ = document;
	_tmp12_ = xmlXPathNewContext (_tmp11_);
	xpath_ctx = _tmp12_;
	_tmp13_ = xpath_ctx;
	if (_tmp13_ == NULL) {
		g_warning ("boc-provider.vala:47: Couldn't create XPath context");
		result = FALSE;
		_xmlXPathFreeContext0 (xpath_ctx);
		_g_object_unref0 (cad_rate);
		return result;
	}
	_tmp14_ = xpath_ctx;
	_tmp15_ = xmlXPathEvalExpression ((xmlChar*) "//observations/o[last()]/v", _tmp14_);
	xpath_obj = _tmp15_;
	_tmp16_ = xpath_obj;
	if (_tmp16_ == NULL) {
		g_warning ("boc-provider.vala:54: Couldn't create XPath object");
		result = FALSE;
		_xmlXPathFreeContext0 (xpath_ctx);
		_g_object_unref0 (cad_rate);
		return result;
	}
	_tmp17_ = xpath_ctx;
	_tmp18_ = xmlXPathEvalExpression ((xmlChar*) "//observations/o[last()]/@d", _tmp17_);
	xpath_date = _tmp18_;
	_tmp20_ = xpath_date;
	_tmp21_ = _tmp20_->nodesetval;
	if (_tmp21_ != NULL) {
		xmlXPathObject* _tmp22_;
		xmlNodeSet* _tmp23_;
		xmlNode* _tmp24_;
		gchar* _tmp25_;
		_tmp22_ = xpath_date;
		_tmp23_ = _tmp22_->nodesetval;
		_tmp24_ = xmlXPathNodeSetItem (_tmp23_, 0);
		_tmp25_ = (gchar*) xmlNodeGetContent (_tmp24_);
		_g_free0 (_tmp19_);
		_tmp19_ = _tmp25_;
	} else {
		_g_free0 (_tmp19_);
		_tmp19_ = NULL;
	}
	_tmp26_ = g_strdup (_tmp19_);
	date = _tmp26_;
	_tmp27_ = xpath_obj;
	_tmp28_ = _tmp27_->nodesetval;
	_tmp29_ = xmlXPathNodeSetItem (_tmp28_, 0);
	node = _tmp29_;
	_tmp30_ = node;
	_tmp31_ = (gchar*) xmlNodeGetContent (_tmp30_);
	rate = _tmp31_;
	_tmp32_ = self->priv->_currency;
	_tmp33_ = rate;
	_tmp34_ = cad_rate;
	_tmp35_ = currency_get_value (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = date;
	bc_currency_provider_set_rate (self, _tmp32_, _tmp33_, _tmp36_, _tmp37_);
	_g_object_unref0 (_tmp36_);
	result = ABSTRACT_CURRENCY_PROVIDER_CLASS (bc_currency_provider_parent_class)->do_load_rates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider));
	_g_free0 (rate);
	_g_free0 (date);
	_g_free0 (_tmp19_);
	_xmlXPathFreeContext0 (xpath_ctx);
	_g_object_unref0 (cad_rate);
	return result;
}

static void
bc_currency_provider_set_rate (BCCurrencyProvider* self,
                               const gchar* name,
                               const gchar* value,
                               Number* cad_rate,
                               const gchar* date)
{
	Number* r = NULL;
	Number* _tmp0_;
	Currency* c = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Currency* _tmp6_;
	Currency* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	g_return_if_fail (cad_rate != NULL);
	g_debug ("boc-provider.vala:69: Using BC rate of %s for %s", value, name);
	_tmp0_ = mp_set_from_string (value, 10, TRUE);
	r = _tmp0_;
	_tmp1_ = abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = number_divide (cad_rate, r);
	_tmp5_ = _tmp4_;
	_tmp6_ = abstract_currency_provider_register_currency ((AbstractCurrencyProvider*) self, name, _tmp3_, _tmp5_, date);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	c = _tmp7_;
	_g_object_unref0 (c);
	_g_object_unref0 (r);
}

BCCurrencyProvider*
bc_currency_provider_construct (GType object_type,
                                CurrencyManager* _currency_manager,
                                const gchar* currency,
                                const gchar* currency_filename)
{
	BCCurrencyProvider * self = NULL;
	g_return_val_if_fail (_currency_manager != NULL, NULL);
	g_return_val_if_fail (currency != NULL, NULL);
	g_return_val_if_fail (currency_filename != NULL, NULL);
	self = (BCCurrencyProvider*) g_object_new (object_type, "currency-manager", _currency_manager, "base-currency-symbol", "CAD", NULL);
	bc_currency_provider_set_currency (self, currency);
	bc_currency_provider_set_currency_filename (self, currency_filename);
	currency_manager_add_provider (_currency_manager, (CurrencyProvider*) self);
	return self;
}

BCCurrencyProvider*
bc_currency_provider_new (CurrencyManager* _currency_manager,
                          const gchar* currency,
                          const gchar* currency_filename)
{
	return bc_currency_provider_construct (TYPE_BC_CURRENCY_PROVIDER, _currency_manager, currency, currency_filename);
}

static const gchar*
bc_currency_provider_get_currency (BCCurrencyProvider* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_currency;
	result = _tmp0_;
	return result;
}

static void
bc_currency_provider_set_currency (BCCurrencyProvider* self,
                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_currency);
	self->priv->_currency = _tmp0_;
}

static const gchar*
bc_currency_provider_get_currency_filename (BCCurrencyProvider* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_currency_filename;
	result = _tmp0_;
	return result;
}

static void
bc_currency_provider_set_currency_filename (BCCurrencyProvider* self,
                                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_currency_filename);
	self->priv->_currency_filename = _tmp0_;
}

static gchar*
bc_currency_provider_real_get_rate_filepath (AbstractCurrencyProvider* base)
{
	gchar* result;
	BCCurrencyProvider* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = (BCCurrencyProvider*) base;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = self->priv->_currency_filename;
	_tmp2_ = g_strdup_printf ("%s.xml", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_filename (_tmp0_, "gnome-calculator", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static gchar*
bc_currency_provider_real_get_rate_source_url (AbstractCurrencyProvider* base)
{
	gchar* result;
	BCCurrencyProvider* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (BCCurrencyProvider*) base;
	_tmp0_ = self->priv->_currency_filename;
	_tmp1_ = g_strdup_printf ("https://exchange-api.gnome.org/boc/%s.xml", _tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
bc_currency_provider_real_get_attribution_link (AbstractCurrencyProvider* base)
{
	gchar* result;
	BCCurrencyProvider* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (BCCurrencyProvider*) base;
	_tmp0_ = self->priv->_currency_filename;
	_tmp1_ = g_strdup_printf ("https://www.bankofcanada.ca/valet/observations/%s/xml?recent=1", _tmp0_);
	result = _tmp1_;
	return result;
}

static const gchar*
bc_currency_provider_real_get_provider_name (AbstractCurrencyProvider* base)
{
	const gchar* result;
	BCCurrencyProvider* self;
	self = (BCCurrencyProvider*) base;
	result = _ ("Bank of Canada");
	return result;
}

static gchar*
bc_currency_provider_real_get_source_name (AbstractCurrencyProvider* base)
{
	gchar* result;
	BCCurrencyProvider* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (BCCurrencyProvider*) base;
	_tmp0_ = self->priv->_currency;
	_tmp1_ = g_strdup_printf ("BC-%s", _tmp0_);
	result = _tmp1_;
	return result;
}

static void
bc_currency_provider_class_init (BCCurrencyProviderClass * klass,
                                 gpointer klass_data)
{
	bc_currency_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BCCurrencyProvider_private_offset);
	((AbstractCurrencyProviderClass *) klass)->parse_date = (GDateTime* (*) (AbstractCurrencyProvider*, const gchar*)) bc_currency_provider_real_parse_date;
	((AbstractCurrencyProviderClass *) klass)->do_load_rates = (gboolean (*) (AbstractCurrencyProvider*)) bc_currency_provider_real_do_load_rates;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_filepath = (gchar* (*) (AbstractCurrencyProvider*)) bc_currency_provider_real_get_rate_filepath;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_source_url = (gchar* (*) (AbstractCurrencyProvider*)) bc_currency_provider_real_get_rate_source_url;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_attribution_link = (gchar* (*) (AbstractCurrencyProvider*)) bc_currency_provider_real_get_attribution_link;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_provider_name = (const gchar* (*) (AbstractCurrencyProvider*)) bc_currency_provider_real_get_provider_name;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_source_name = (gchar* (*) (AbstractCurrencyProvider*)) bc_currency_provider_real_get_source_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_bc_currency_provider_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bc_currency_provider_set_property;
	G_OBJECT_CLASS (klass)->finalize = bc_currency_provider_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BC_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY, bc_currency_provider_properties[BC_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY] = g_param_spec_string ("rate-filepath", "rate-filepath", "rate-filepath", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BC_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY, bc_currency_provider_properties[BC_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY] = g_param_spec_string ("rate-source-url", "rate-source-url", "rate-source-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BC_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY, bc_currency_provider_properties[BC_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY] = g_param_spec_string ("attribution-link", "attribution-link", "attribution-link", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BC_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY, bc_currency_provider_properties[BC_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY] = g_param_spec_string ("provider-name", "provider-name", "provider-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BC_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY, bc_currency_provider_properties[BC_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
bc_currency_provider_instance_init (BCCurrencyProvider * self,
                                    gpointer klass)
{
	self->priv = bc_currency_provider_get_instance_private (self);
}

static void
bc_currency_provider_finalize (GObject * obj)
{
	BCCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BC_CURRENCY_PROVIDER, BCCurrencyProvider);
	_g_free0 (self->priv->_currency);
	_g_free0 (self->priv->_currency_filename);
	G_OBJECT_CLASS (bc_currency_provider_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
bc_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BCCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bc_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BCCurrencyProvider), 0, (GInstanceInitFunc) bc_currency_provider_instance_init, NULL };
	GType bc_currency_provider_type_id;
	bc_currency_provider_type_id = g_type_register_static (TYPE_ABSTRACT_CURRENCY_PROVIDER, "BCCurrencyProvider", &g_define_type_info, 0);
	BCCurrencyProvider_private_offset = g_type_add_instance_private (bc_currency_provider_type_id, sizeof (BCCurrencyProviderPrivate));
	return bc_currency_provider_type_id;
}

GType
bc_currency_provider_get_type (void)
{
	static gsize bc_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&bc_currency_provider_type_id__once)) {
		GType bc_currency_provider_type_id;
		bc_currency_provider_type_id = bc_currency_provider_get_type_once ();
		g_once_init_leave (&bc_currency_provider_type_id__once, bc_currency_provider_type_id);
	}
	return bc_currency_provider_type_id__once;
}

static void
_vala_bc_currency_provider_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	BCCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BC_CURRENCY_PROVIDER, BCCurrencyProvider);
	switch (property_id) {
		case BC_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self));
		break;
		case BC_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_source_url ((AbstractCurrencyProvider*) self));
		break;
		case BC_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_attribution_link ((AbstractCurrencyProvider*) self));
		break;
		case BC_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY:
		g_value_set_string (value, abstract_currency_provider_get_provider_name ((AbstractCurrencyProvider*) self));
		break;
		case BC_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bc_currency_provider_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	BCCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BC_CURRENCY_PROVIDER, BCCurrencyProvider);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

