#ifndef SBK_KDATEVALIDATORWRAPPER_H
#define SBK_KDATEVALIDATORWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kdatevalidator.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KDateValidatorWrapper : public KDateValidator
{
public:
    KDateValidatorWrapper(::QObject * parent = nullptr);
    KDateValidatorWrapper(const KDateValidatorWrapper &) = delete;
    KDateValidatorWrapper& operator=(const KDateValidatorWrapper &) = delete;
    KDateValidatorWrapper(KDateValidatorWrapper &&) = delete;
    KDateValidatorWrapper& operator=(KDateValidatorWrapper &&) = delete;
    ~KDateValidatorWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void fixup(::QString & input) const override;
    static void sbk_o_fixup(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QString & input);
    void timerEvent(::QTimerEvent * event) override;
    ::QValidator::State validate(::QString & text, int & e) const override;
    static ::QValidator::State sbk_o_validate(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QString & text, int & e);

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 9> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KDATEVALIDATORWRAPPER_H
