// This file was generated by qtwaylandscanner
// source file is keystate.xml

#ifndef QT_WAYLAND_SERVER_KEYSTATE
#define QT_WAYLAND_SERVER_KEYSTATE

#include "wayland-server-core.h"
#include "wayland-keystate-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  org_kde_kwin_keystate
    {
    public:
        org_kde_kwin_keystate(struct ::wl_client *client, int id, int version);
        org_kde_kwin_keystate(struct ::wl_display *display, int version);
        org_kde_kwin_keystate(struct ::wl_resource *resource);
        org_kde_kwin_keystate();

        virtual ~org_kde_kwin_keystate();

        class Resource
        {
        public:
            Resource() : org_kde_kwin_keystate_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            org_kde_kwin_keystate *org_kde_kwin_keystate_object;
            org_kde_kwin_keystate *object() { return org_kde_kwin_keystate_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum key {
            key_capslock = 0,
            key_numlock = 1,
            key_scrolllock = 2,
            key_alt = 3,
            key_control = 4,
            key_shift = 5,
            key_meta = 6,
            key_altgr = 7,
        };

        enum state {
            state_unlocked = 0,
            state_latched = 1,
            state_locked = 2,
            state_pressed = 3,
        };

        void send_stateChanged(uint32_t key, uint32_t state);
        void send_stateChanged(struct ::wl_resource *resource, uint32_t key, uint32_t state);

    protected:
        virtual Resource *org_kde_kwin_keystate_allocate();

        virtual void org_kde_kwin_keystate_destroy_global();

        virtual void org_kde_kwin_keystate_bind_resource(Resource *resource);
        virtual void org_kde_kwin_keystate_destroy_resource(Resource *resource);

        virtual void org_kde_kwin_keystate_fetchStates(Resource *resource);
        virtual void org_kde_kwin_keystate_destroy(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::org_kde_kwin_keystate_interface m_org_kde_kwin_keystate_interface;

        static void handle_fetchStates(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            org_kde_kwin_keystate *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
