#include "nv_push_clc7b0.h"

#include <stdio.h>





const char *P_PARSE_NVC5B0_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC5B0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVC7B0_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NVC5B0_MTHD(idx);

        case NVC7B0_PM_TRIGGER:
        return "NVC7B0_PM_TRIGGER";
    case NVC7B0_SET_APPLICATION_ID:
        return "NVC7B0_SET_APPLICATION_ID";
                            case NVC7B0_SET_SEMAPHORE_PAYLOAD_LOWER:
        return "NVC7B0_SET_SEMAPHORE_PAYLOAD_LOWER";
    case NVC7B0_SET_SEMAPHORE_PAYLOAD_UPPER:
        return "NVC7B0_SET_SEMAPHORE_PAYLOAD_UPPER";
    case NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A:
        return "NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A";
    case NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B:
        return "NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B";
    case NVC7B0_EXECUTE:
        return "NVC7B0_EXECUTE";
    case NVC7B0_SEMAPHORE_D:
        return "NVC7B0_SEMAPHORE_D";
    case NVC7B0_SET_PREDICATION_OFFSET_UPPER:
        return "NVC7B0_SET_PREDICATION_OFFSET_UPPER";
    case NVC7B0_SET_PREDICATION_OFFSET_LOWER:
        return "NVC7B0_SET_PREDICATION_OFFSET_LOWER";
    case NVC7B0_SET_AUXILIARY_DATA_BUFFER:
        return "NVC7B0_SET_AUXILIARY_DATA_BUFFER";
    case NVC7B0_SET_CONTROL_PARAMS:
        return "NVC7B0_SET_CONTROL_PARAMS";
                                                                                                                                                                                                case NVC7B0_SET_SUB_SAMPLE_MAP_OFFSET:
        return "NVC7B0_SET_SUB_SAMPLE_MAP_OFFSET";
    case NVC7B0_SET_SUB_SAMPLE_MAP_IV_OFFSET:
        return "NVC7B0_SET_SUB_SAMPLE_MAP_IV_OFFSET";
    case NVC7B0_SET_INTRA_TOP_BUF_OFFSET:
        return "NVC7B0_SET_INTRA_TOP_BUF_OFFSET";
    case NVC7B0_SET_TILE_SIZE_BUF_OFFSET:
        return "NVC7B0_SET_TILE_SIZE_BUF_OFFSET";
    case NVC7B0_SET_FILTER_BUFFER_OFFSET:
        return "NVC7B0_SET_FILTER_BUFFER_OFFSET";
    case NVC7B0_SET_CRC_STRUCT_OFFSET:
        return "NVC7B0_SET_CRC_STRUCT_OFFSET";
    case NVC7B0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET:
        return "NVC7B0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET";
                                                                        case NVC7B0_VP9_PARSER_SET_PIC_SETUP_OFFSET:
        return "NVC7B0_VP9_PARSER_SET_PIC_SETUP_OFFSET";
    case NVC7B0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET:
        return "NVC7B0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET";
    case NVC7B0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET:
        return "NVC7B0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET";
    case NVC7B0_PASS1_SET_CLEAR_HEADER_OFFSET:
        return "NVC7B0_PASS1_SET_CLEAR_HEADER_OFFSET";
    case NVC7B0_PASS1_SET_RE_ENCRYPT_OFFSET:
        return "NVC7B0_PASS1_SET_RE_ENCRYPT_OFFSET";
    case NVC7B0_PASS1_SET_VP8_TOKEN_OFFSET:
        return "NVC7B0_PASS1_SET_VP8_TOKEN_OFFSET";
    case NVC7B0_PASS1_SET_INPUT_DATA_OFFSET:
        return "NVC7B0_PASS1_SET_INPUT_DATA_OFFSET";
    case NVC7B0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET:
        return "NVC7B0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET";
    case NVC7B0_AV1_SET_PROB_TAB_READ_BUF_OFFSET:
        return "NVC7B0_AV1_SET_PROB_TAB_READ_BUF_OFFSET";
    case NVC7B0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET:
        return "NVC7B0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET";
    case NVC7B0_AV1_SET_SEGMENT_READ_BUF_OFFSET:
        return "NVC7B0_AV1_SET_SEGMENT_READ_BUF_OFFSET";
    case NVC7B0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET:
        return "NVC7B0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET";
    case NVC7B0_AV1_SET_COL_MV0_READ_BUF_OFFSET:
        return "NVC7B0_AV1_SET_COL_MV0_READ_BUF_OFFSET";
    case NVC7B0_AV1_SET_COL_MV1_READ_BUF_OFFSET:
        return "NVC7B0_AV1_SET_COL_MV1_READ_BUF_OFFSET";
    case NVC7B0_AV1_SET_COL_MV2_READ_BUF_OFFSET:
        return "NVC7B0_AV1_SET_COL_MV2_READ_BUF_OFFSET";
    case NVC7B0_AV1_SET_COL_MVWRITE_BUF_OFFSET:
        return "NVC7B0_AV1_SET_COL_MVWRITE_BUF_OFFSET";
    case NVC7B0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET:
        return "NVC7B0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET";
    case NVC7B0_AV1_SET_FILM_GRAIN_BUF_OFFSET:
        return "NVC7B0_AV1_SET_FILM_GRAIN_BUF_OFFSET";
    case NVC7B0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET:
        return "NVC7B0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET";
    case NVC7B0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET:
        return "NVC7B0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET";
    case NVC7B0_H264_SET_SCALING_LIST_OFFSET:
        return "NVC7B0_H264_SET_SCALING_LIST_OFFSET";
    case NVC7B0_H264_SET_VLDHIST_BUF_OFFSET:
        return "NVC7B0_H264_SET_VLDHIST_BUF_OFFSET";
    case NVC7B0_H264_SET_EDOBOFFSET0:
        return "NVC7B0_H264_SET_EDOBOFFSET0";
    case NVC7B0_H264_SET_EDOBOFFSET1:
        return "NVC7B0_H264_SET_EDOBOFFSET1";
    case NVC7B0_H264_SET_EDOBOFFSET2:
        return "NVC7B0_H264_SET_EDOBOFFSET2";
    case NVC7B0_H264_SET_EDOBOFFSET3:
        return "NVC7B0_H264_SET_EDOBOFFSET3";
    case NVC7B0_SET_CTL_COUNT:
        return "NVC7B0_SET_CTL_COUNT";
    case NVC7B0_SET_UPPER_SRC:
        return "NVC7B0_SET_UPPER_SRC";
    case NVC7B0_SET_LOWER_SRC:
        return "NVC7B0_SET_LOWER_SRC";
    case NVC7B0_SET_UPPER_DST:
        return "NVC7B0_SET_UPPER_DST";
    case NVC7B0_SET_LOWER_DST:
        return "NVC7B0_SET_LOWER_DST";
    case NVC7B0_SET_BLOCK_COUNT:
        return "NVC7B0_SET_BLOCK_COUNT";
    case NVC7B0_PR_SET_REQUEST_BUF_OFFSET:
        return "NVC7B0_PR_SET_REQUEST_BUF_OFFSET";
    case NVC7B0_PR_SET_REQUEST_BUF_SIZE:
        return "NVC7B0_PR_SET_REQUEST_BUF_SIZE";
    case NVC7B0_PR_SET_RESPONSE_BUF_OFFSET:
        return "NVC7B0_PR_SET_RESPONSE_BUF_OFFSET";
    case NVC7B0_PR_SET_RESPONSE_BUF_SIZE:
        return "NVC7B0_PR_SET_RESPONSE_BUF_SIZE";
    case NVC7B0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET:
        return "NVC7B0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET";
    case NVC7B0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET:
        return "NVC7B0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET";
    case NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET:
        return "NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET";
    case NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_SIZE:
        return "NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_SIZE";
    case NVC7B0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET:
        return "NVC7B0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET";
    case NVC7B0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET:
        return "NVC7B0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET";
    case NVC7B0_DH_KE_SET_CHALLENGE_BUF_OFFSET:
        return "NVC7B0_DH_KE_SET_CHALLENGE_BUF_OFFSET";
    case NVC7B0_DH_KE_SET_RESPONSE_BUF_OFFSET:
        return "NVC7B0_DH_KE_SET_RESPONSE_BUF_OFFSET";
    case NVC7B0_PM_TRIGGER_END:
        return "NVC7B0_PM_TRIGGER_END";

    }
}

void
P_DUMP_NVC7B0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NVC5B0_MTHD_DATA(fp, idx, data, prefix);
    break;

      
    case NVC7B0_PM_TRIGGER:

    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_APPLICATION_ID:

    
        parsed = data;
        fprintf(fp, "%s.ID = ", prefix);
        switch (parsed) {
        case NVC7B0_SET_APPLICATION_ID_ID_MPEG12:
            fprintf(fp, "MPEG12\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_VC1:
            fprintf(fp, "VC1\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_H264:
            fprintf(fp, "H264\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_MPEG4:
            fprintf(fp, "MPEG4\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_VP8:
            fprintf(fp, "VP8\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_CTR64:
            fprintf(fp, "CTR64\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_HEVC:
            fprintf(fp, "HEVC\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_NEW_H264:
            fprintf(fp, "NEW_H264\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_VP9:
            fprintf(fp, "VP9\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_PASS1:
            fprintf(fp, "PASS1\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_HEVC_PARSER:
            fprintf(fp, "HEVC_PARSER\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_UCODE_TEST:
            fprintf(fp, "UCODE_TEST\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_HWDRM_PR_DECRYPTAUDIO:
            fprintf(fp, "HWDRM_PR_DECRYPTAUDIO\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_HWDRM_PR_DECRYPTAUDIOMULTIPLE:
            fprintf(fp, "HWDRM_PR_DECRYPTAUDIOMULTIPLE\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_HWDRM_PR_PREPROCESSENCRYPTEDDATA:
            fprintf(fp, "HWDRM_PR_PREPROCESSENCRYPTEDDATA\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_VP9_WITH_PARSER:
            fprintf(fp, "VP9_WITH_PARSER\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_AVD:
            fprintf(fp, "AVD\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_HW_DRM_PR4_DECRYPTCONTENTMULTIPLE:
            fprintf(fp, "HW_DRM_PR4_DECRYPTCONTENTMULTIPLE\n");
            break;
        case NVC7B0_SET_APPLICATION_ID_ID_DHKE:
            fprintf(fp, "DHKE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                          
    case NVC7B0_SET_SEMAPHORE_PAYLOAD_LOWER:

    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_SEMAPHORE_PAYLOAD_UPPER:

    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A:

    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B:

    
        parsed = data;
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_EXECUTE:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.NOTIFY = ", prefix);
        switch (parsed) {
        case NVC7B0_EXECUTE_NOTIFY_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVC7B0_EXECUTE_NOTIFY_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.NOTIFY_ON = ", prefix);
        switch (parsed) {
        case NVC7B0_EXECUTE_NOTIFY_ON_END:
            fprintf(fp, "END\n");
            break;
        case NVC7B0_EXECUTE_NOTIFY_ON_BEGIN:
            fprintf(fp, "BEGIN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.PREDICATION = ", prefix);
        switch (parsed) {
        case NVC7B0_EXECUTE_PREDICATION_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVC7B0_EXECUTE_PREDICATION_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.PREDICATION_OP = ", prefix);
        switch (parsed) {
        case NVC7B0_EXECUTE_PREDICATION_OP_EQUAL_ZERO:
            fprintf(fp, "EQUAL_ZERO\n");
            break;
        case NVC7B0_EXECUTE_PREDICATION_OP_NOT_EQUAL_ZERO:
            fprintf(fp, "NOT_EQUAL_ZERO\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.AWAKEN = ", prefix);
        switch (parsed) {
        case NVC7B0_EXECUTE_AWAKEN_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVC7B0_EXECUTE_AWAKEN_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVC7B0_SEMAPHORE_D:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.STRUCTURE_SIZE = ", prefix);
        switch (parsed) {
        case NVC7B0_SEMAPHORE_D_STRUCTURE_SIZE_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NVC7B0_SEMAPHORE_D_STRUCTURE_SIZE_FOUR:
            fprintf(fp, "FOUR\n");
            break;
        case NVC7B0_SEMAPHORE_D_STRUCTURE_SIZE_TWO:
            fprintf(fp, "TWO\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.AWAKEN_ENABLE = ", prefix);
        switch (parsed) {
        case NVC7B0_SEMAPHORE_D_AWAKEN_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7B0_SEMAPHORE_D_AWAKEN_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 2) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC7B0_SEMAPHORE_D_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVC7B0_SEMAPHORE_D_OPERATION_RESERVED_0:
            fprintf(fp, "RESERVED_0\n");
            break;
        case NVC7B0_SEMAPHORE_D_OPERATION_RESERVED_1:
            fprintf(fp, "RESERVED_1\n");
            break;
        case NVC7B0_SEMAPHORE_D_OPERATION_TRAP:
            fprintf(fp, "TRAP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 21) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DISABLE = ", prefix);
        switch (parsed) {
        case NVC7B0_SEMAPHORE_D_FLUSH_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7B0_SEMAPHORE_D_FLUSH_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 22) & ((1u << 2) - 1);
        fprintf(fp, "%s.TRAP_TYPE = ", prefix);
        switch (parsed) {
        case NVC7B0_SEMAPHORE_D_TRAP_TYPE_UNCONDITIONAL:
            fprintf(fp, "UNCONDITIONAL\n");
            break;
        case NVC7B0_SEMAPHORE_D_TRAP_TYPE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NVC7B0_SEMAPHORE_D_TRAP_TYPE_CONDITIONAL_EXT:
            fprintf(fp, "CONDITIONAL_EXT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.PAYLOAD_SIZE = ", prefix);
        switch (parsed) {
        case NVC7B0_SEMAPHORE_D_PAYLOAD_SIZE_32BIT:
            fprintf(fp, "32BIT\n");
            break;
        case NVC7B0_SEMAPHORE_D_PAYLOAD_SIZE_64BIT:
            fprintf(fp, "64BIT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVC7B0_SET_PREDICATION_OFFSET_UPPER:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_PREDICATION_OFFSET_LOWER:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_AUXILIARY_DATA_BUFFER:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_CONTROL_PARAMS:

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.CODEC_TYPE = ", prefix);
        switch (parsed) {
        case NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG1:
            fprintf(fp, "MPEG1\n");
            break;
        case NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG2:
            fprintf(fp, "MPEG2\n");
            break;
        case NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_VC1:
            fprintf(fp, "VC1\n");
            break;
        case NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_H264:
            fprintf(fp, "H264\n");
            break;
        case NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG4:
            fprintf(fp, "MPEG4\n");
            break;
        case NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP8:
            fprintf(fp, "VP8\n");
            break;
        case NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_HEVC:
            fprintf(fp, "HEVC\n");
            break;
        case NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP9:
            fprintf(fp, "VP9\n");
            break;
        case NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_AV1:
            fprintf(fp, "AV1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.GPTIMER_ON = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.RET_ERROR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.ERR_CONCEAL_ON = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 7) & ((1u << 6) - 1);
        fprintf(fp, "%s.ERROR_FRM_IDX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 13) & ((1u << 1) - 1);
        fprintf(fp, "%s.MBTIMER_ON = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 14) & ((1u << 1) - 1);
        fprintf(fp, "%s.EC_INTRA_FRAME_USING_PSLC = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 15) & ((1u << 1) - 1);
        fprintf(fp, "%s.IGNORE_SOME_FIELDS_CRC_CHECK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.EVENT_TRACE_LOGGING_ON = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 17) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALL_INTRA_FRAME = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 18) & ((1u << 2) - 1);
        fprintf(fp, "%s.TESTRUN_ENV = ", prefix);
        switch (parsed) {
        case NVC7B0_SET_CONTROL_PARAMS_TESTRUN_ENV_TRACE3D_RUN:
            fprintf(fp, "TRACE3D_RUN\n");
            break;
        case NVC7B0_SET_CONTROL_PARAMS_TESTRUN_ENV_PROD_RUN:
            fprintf(fp, "PROD_RUN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 7) - 1);
        fprintf(fp, "%s.RESERVED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE_ENCRYPT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.ENCRYPTMODE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                                                              
    case NVC7B0_SET_SUB_SAMPLE_MAP_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_SUB_SAMPLE_MAP_IV_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_INTRA_TOP_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_TILE_SIZE_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_FILTER_BUFFER_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_CRC_STRUCT_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                      
    case NVC7B0_VP9_PARSER_SET_PIC_SETUP_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PASS1_SET_CLEAR_HEADER_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PASS1_SET_RE_ENCRYPT_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PASS1_SET_VP8_TOKEN_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PASS1_SET_INPUT_DATA_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_AV1_SET_PROB_TAB_READ_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_AV1_SET_SEGMENT_READ_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_AV1_SET_COL_MV0_READ_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_AV1_SET_COL_MV1_READ_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_AV1_SET_COL_MV2_READ_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_AV1_SET_COL_MVWRITE_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_AV1_SET_FILM_GRAIN_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_H264_SET_SCALING_LIST_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_H264_SET_VLDHIST_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_H264_SET_EDOBOFFSET0:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_H264_SET_EDOBOFFSET1:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_H264_SET_EDOBOFFSET2:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_H264_SET_EDOBOFFSET3:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_CTL_COUNT:

    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_UPPER_SRC:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_LOWER_SRC:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_UPPER_DST:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_LOWER_DST:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_SET_BLOCK_COUNT:

    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PR_SET_REQUEST_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PR_SET_REQUEST_BUF_SIZE:

    
        parsed = data;
        fprintf(fp, "%s.SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PR_SET_RESPONSE_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PR_SET_RESPONSE_BUF_SIZE:

    
        parsed = data;
        fprintf(fp, "%s.SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_SIZE:

    
        parsed = data;
        fprintf(fp, "%s.SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_DH_KE_SET_CHALLENGE_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_DH_KE_SET_RESPONSE_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC7B0_PM_TRIGGER_END:

    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    }
}
