const char *mesh_vs =
  "#version 400\n"
  "precision highp float;     \n"
  "\n"
  "in vec4 vertex;\n"
  "in vec4 color;\n"
  "in vec3 normal;\n"
  "\n"
  "uniform mat4 modelView;\n"
  "uniform mat4 projection;\n"
  "uniform mat3 normalMatrix;\n"
  "\n"
  "out vec3 fnormal;\n"
  "out vec4 outColor;\n"
  "\n"
  "void main()\n"
  "{\n"
  "  outColor = color;\n"
  "  gl_Position = projection * modelView * vertex;\n"
  "  fnormal = normalize(normalMatrix * normal);\n"
  "}\n"
  "\n";
