/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */


#define SWIG_VERSION 0x040400
#define SWIGJAVA
#define SWIG_DIRECTORS

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif

#if defined(__cplusplus) && __cplusplus >=201103L
# define SWIG_NOEXCEPT noexcept
#else
# define SWIG_NOEXCEPT throw()
#endif 

/* -----------------------------------------------------------------------------
 * swigcompat.swg
 *
 * Macros to provide support compatibility with older C and C++ standards.
 *
 * Note that SWIG expects __cplusplus to be defined to the appropriate C++ standard.
 * MSVC users are urged to check and examine the /Zc:__cplusplus compiler option.
 * See https://learn.microsoft.com/en-us/cpp/build/reference/zc-cplusplus.
 * ----------------------------------------------------------------------------- */

/* C99 and C++11 should provide snprintf, but define SWIG_NO_SNPRINTF
 * if you're missing it.
 */
#if ((defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L) || \
     (defined __cplusplus && __cplusplus >= 201103L) || \
     defined SWIG_HAVE_SNPRINTF) && \
    !defined SWIG_NO_SNPRINTF
# define SWIG_snprintf(O,S,F,A) snprintf(O,S,F,A)
# define SWIG_snprintf2(O,S,F,A,B) snprintf(O,S,F,A,B)
#else
/* Fallback versions ignore the buffer size, but most of our uses either have a
 * fixed maximum possible size or dynamically allocate a buffer that's large
 * enough.
 */
# define SWIG_snprintf(O,S,F,A) sprintf(O,F,A)
# define SWIG_snprintf2(O,S,F,A,B) sprintf(O,F,A,B)
#endif


#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1,
  SWIG_JavaIOException,
  SWIG_JavaRuntimeException,
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError,
  SWIG_JavaIllegalStateException,
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { SWIG_JavaIllegalStateException, "java/lang/IllegalStateException" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) do { if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } } while (0)

/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION) || defined(DEBUG_DIRECTOR_THREAD_NAME)
#include <iostream>
#endif

#include <exception>

#if defined(SWIG_JAVA_USE_THREAD_NAME)

#if !defined(SWIG_JAVA_GET_THREAD_NAME)
namespace Swig {
  SWIGINTERN int GetThreadName(char *name, size_t len);
}

#if defined(__linux__)

#include <sys/prctl.h>
SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  (void)len;
#if defined(PR_GET_NAME)
  return prctl(PR_GET_NAME, (unsigned long)name, 0, 0, 0);
#else
  (void)name;
  return 1;
#endif
}

#elif defined(__unix__) || defined(__APPLE__)

#include <pthread.h>
SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  return pthread_getname_np(pthread_self(), name, len);
}

#else

SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  (void)len;
  (void)name;
  return 1;
}
#endif

#endif

#endif

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
#include <pthread.h>
#endif

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global || !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
	/* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
    static void detach(void *jvm) {
      static_cast<JavaVM *>(jvm)->DetachCurrentThread();
    }

    static void make_detach_key() {
      pthread_key_create(&detach_key_, detach);
    }

    /* thread-local key to register a destructor */
    static pthread_key_t detach_key_;
#endif

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
  pthread_key_t JObjectWrapper::detach_key_;
#endif

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(NULL), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
        JavaVMAttachArgs args;
        args.version = JNI_VERSION_1_2;
        args.group = NULL;
        args.name = NULL;
#if defined(SWIG_JAVA_USE_THREAD_NAME)
        char thread_name[64];  // MAX_TASK_COMM_LEN=16 is hard-coded in the Linux kernel and MacOS has MAXTHREADNAMESIZE=64.
        if (Swig::GetThreadName(thread_name, sizeof(thread_name)) == 0) {
          args.name = thread_name;
#if defined(DEBUG_DIRECTOR_THREAD_NAME)
          std::cout << "JNIEnvWrapper: thread name: " << thread_name << std::endl;
        } else {
          std::cout << "JNIEnvWrapper: Couldn't set Java thread name" << std::endl;
#endif
        }
#endif
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, &args);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, &args);
#endif

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
        // At least on Android 6, detaching after every call causes a memory leak.
        // Instead, register a thread desructor and detach only when the thread ends.
        // See https://developer.android.com/training/articles/perf-jni#threads
        static pthread_once_t once = PTHREAD_ONCE_INIT;

        pthread_once(&once, JObjectWrapper::make_detach_key);
        pthread_setspecific(JObjectWrapper::detach_key_, director->swig_jvm_);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_DETACH_ON_THREAD_END) && !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    struct SwigDirectorMethod {
      const char *name;
      const char *desc;
      jmethodID methid;
      SwigDirectorMethod(JNIEnv *jenv, jclass baseclass, const char *name, const char *desc) : name(name), desc(desc) {
        methid = jenv->GetMethodID(baseclass, name, desc);
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

    jclass swig_new_global_ref(JNIEnv *jenv, const char *classname) {
      jclass clz = jenv->FindClass(classname);
      return clz ? (jclass)jenv->NewGlobalRef(clz) : NULL;
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(NULL) {
      if (jenv_ && jstr_)
	cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, NULL);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
	jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    // Return a C string of the exception message in the jthrowable passed in the constructor
    // If no message is available, null_string is return instead
    const char *message(const char *null_string = "Could not get exception message in JavaExceptionMessage") const {
      return message_.c_str(null_string);
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = NULL;
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  // All Throwable classes have a getMessage() method, so call it to extract the exception message
	  jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
	  if (getMessageMethodID)
	    jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
	}
	if (jmsg == NULL && jenv->ExceptionCheck())
	  jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : jenv_(jenv), throwable_(throwable), classname_(NULL), msg_(NULL) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  jclass clzclz = jenv->GetObjectClass(throwclz);
	  if (clzclz) {
	    jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
	    if (getNameMethodID) {
	      jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(NULL);
                if (classname)
                  classname_ = copypath(classname);
              }
	    }
	  }
	}
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message(NULL));
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : jenv_(NULL), throwable_(NULL), classname_(NULL), msg_(msg ? copystr(msg) : NULL) {
    }

    ~DirectorException() SWIG_NOEXCEPT {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const SWIG_NOEXCEPT {
      return msg_ ? msg_ : "Unspecified DirectorException message";
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void throwException(JNIEnv *jenv) const {
      if (jenv) {
        if (jenv == jenv_ && throwable_) {
          // Throw original exception if not already pending
          jthrowable throwable = jenv->ExceptionOccurred();
          if (throwable && jenv->IsSameObject(throwable, throwable_) == JNI_FALSE) {
            jenv->ExceptionClear();
            throwable = NULL;
          }
          if (!throwable)
            jenv->Throw(throwable_);
        } else {
          // Try and reconstruct original exception, but original stacktrace is not reconstructed
          jenv->ExceptionClear();

          jmethodID ctorMethodID = NULL;
          jclass throwableclass = NULL;
          if (classname_) {
            throwableclass = jenv->FindClass(classname_);
            if (throwableclass)
              ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
          }

          if (ctorMethodID) {
            jenv->ThrowNew(throwableclass, what());
          } else {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
          }
        }
      }
    }

    // Deprecated - use throwException
    void raiseJavaException(JNIEnv *jenv) const {
      throwException(jenv);
    }

    // Create and throw the DirectorException
    static void raise(JNIEnv *jenv, jthrowable throwable) {
      throw DirectorException(jenv, throwable);
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = NULL;
      if (srcmsg) {
	size_t msglen = strlen(srcmsg) + 1;
	target = new char[msglen];
	strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    JNIEnv *jenv_;
    jthrowable throwable_;
    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  // Note side effect of clearing any pending exceptions
  SWIGINTERN bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
	jclass classclz = jenv->GetObjectClass(clz);
	jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
	if (isInstanceMethodID) {
	  matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
	}
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}

namespace Swig {
  namespace {
    jclass jclass_csnd6JNI = NULL;
    jmethodID director_method_ids[6];
  }
}

#ifdef __cplusplus
#include <utility>
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigSmartPointer {
    T *ptr;
    SwigSmartPointer(T *p) : ptr(p) { }
    ~SwigSmartPointer() { delete ptr; }
    SwigSmartPointer& operator=(SwigSmartPointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
    void reset(T *p) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = p; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigSmartPointer tmp(new T(t)); pointer = tmp; return *this; }
#if __cplusplus >=201103L
  SwigValueWrapper& operator=(T&& t) { SwigSmartPointer tmp(new T(std::move(t))); pointer = tmp; return *this; }
  operator T&&() const { return std::move(*pointer.ptr); }
#else
  operator T&() const { return *pointer.ptr; }
#endif
  T *operator&() const { return pointer.ptr; }
  static void reset(SwigValueWrapper& t, T *p) { t.pointer.reset(p); }
};

/*
 * SwigValueInit() is a generic initialisation solution as the following approach:
 * 
 *       T c_result = T();
 * 
 * doesn't compile for all types for example:
 * 
 *       unsigned int c_result = unsigned int();
 */
template <typename T> T SwigValueInit() {
  return T();
}

#if __cplusplus >=201103L
# define SWIG_STD_MOVE(OBJ) std::move(OBJ)
#else
# define SWIG_STD_MOVE(OBJ) OBJ
#endif

#endif


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, long long **carr, jlongArray input);
static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, long long *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, long long *result, jsize sz);


static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long long[] support */
static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, long long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, long long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, long long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#include <string>


#include <typeinfo>
#include <stdexcept>


#include <vector>
#include <stdexcept>


    #include "csound.h"
    #include "cfgvar.h"
    #include "csound.hpp"
    #include "cs_glue.hpp"
    #include "csPerfThread.hpp"
    #include "CsoundFile.hpp"
    #include "CppSound.hpp"
    #include "Soundfile.hpp"


#  include "sysdep.h"
#  include "text.h"
#  include <stdarg.h>
#  include <stdio.h>
      

#include <string.h>


#include "csound.h"


#include <map>
#include <stdexcept>

SWIGINTERN std::map< int,std::string,std::less< int > >::iterator std_map_Sl_int_Sc_std_string_Sg__iterator_getNextUnchecked(std::map< int,std::string >::iterator *self){
          std::map< int, std::string, std::less< int > >::iterator copy = (*self);
          return ++copy;
        }
SWIGINTERN bool std_map_Sl_int_Sc_std_string_Sg__iterator_isNot(std::map< int,std::string >::iterator const *self,std::map< int,std::string >::iterator other){
          return (*self != other);
        }
SWIGINTERN int std_map_Sl_int_Sc_std_string_Sg__iterator_getKey(std::map< int,std::string >::iterator const *self){
          return (*self)->first;
        }
SWIGINTERN std::string std_map_Sl_int_Sc_std_string_Sg__iterator_getValue(std::map< int,std::string >::iterator const *self){
          return (*self)->second;
        }
SWIGINTERN void std_map_Sl_int_Sc_std_string_Sg__iterator_setValue(std::map< int,std::string >::iterator *self,std::string const &newValue){
          (*self)->second = newValue;
        }

/* Check for overflow converting to Java int (always signed 32-bit) from (unsigned variable-bit) size_t */
SWIGINTERN jint SWIG_JavaIntFromSize_t(size_t size) {
  static const jint JINT_MAX = 0x7FFFFFFF;
  return (size > (size_t)JINT_MAX) ? -1 : (jint)size;
}


  SWIGINTERN jint SWIG_MapSize(size_t size) {
    jint sz = SWIG_JavaIntFromSize_t(size);
    if (sz == -1) {
      throw std::out_of_range("map size is too large to fit into a Java int");
    }

    return sz;
  }

SWIGINTERN jint std_map_Sl_int_Sc_std_string_Sg__sizeImpl(std::map< int,std::string > const *self){
        return SWIG_MapSize(self->size());
      }
SWIGINTERN bool std_map_Sl_int_Sc_std_string_Sg__containsImpl(std::map< int,std::string > *self,int const &key){
        return (self->count(key) > 0);
      }
SWIGINTERN void std_map_Sl_int_Sc_std_string_Sg__putUnchecked(std::map< int,std::string > *self,int const &key,std::string const &value){
#ifdef __cpp_lib_map_try_emplace
        (*self).insert_or_assign(key, value);
#else
        (*self)[key] = value;
#endif
      }
SWIGINTERN void std_map_Sl_int_Sc_std_string_Sg__removeUnchecked(std::map< int,std::string > *self,std::map< int,std::string,std::less< int > >::iterator const itr){
        self->erase(itr);
      }

#include <string>
#include <vector>


#include "csound.hpp"
#include "CsoundFile.hpp"
#include <string>
#include <vector>
  

SWIGINTERN jint SWIG_VectorSize(size_t size) {
  jint sz = SWIG_JavaIntFromSize_t(size);
  if (sz == -1)
    throw std::out_of_range("vector size is too large to fit into a Java int");
  return sz;
}

SWIGINTERN std::vector< double > *new_std_vector_Sl_double_Sg___SWIG_2(jint count,double const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< double >(static_cast<std::vector< double >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_double_Sg__doCapacity(std::vector< double > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_double_Sg__doReserve(std::vector< double > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_double_Sg__doSize(std::vector< double > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_double_Sg__doAdd__SWIG_0(std::vector< double > *self,std::vector< double >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_double_Sg__doAdd__SWIG_1(std::vector< double > *self,jint index,std::vector< double >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< double >::value_type std_vector_Sl_double_Sg__doRemove(std::vector< double > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          double const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< double >::value_type const &std_vector_Sl_double_Sg__doGet(std::vector< double > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< double >::value_type std_vector_Sl_double_Sg__doSet(std::vector< double > *self,jint index,std::vector< double >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          double const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_double_Sg__doRemoveRange(std::vector< double > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

#include <sndfile.h>
#include <iostream>
#include <string>
#include <vector>
#include <cstring>
  


/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "java_interfaceJAVA_wrap.h"

SwigDirector_CsoundCallbackWrapper::SwigDirector_CsoundCallbackWrapper(JNIEnv *jenv,Csound *csound) : CsoundCallbackWrapper(csound), Swig::Director(jenv) {
}

SwigDirector_CsoundCallbackWrapper::SwigDirector_CsoundCallbackWrapper(JNIEnv *jenv,CSOUND *csound) : CsoundCallbackWrapper(csound), Swig::Director(jenv) {
}

void SwigDirector_CsoundCallbackWrapper::MessageCallback(int attr,char *msg) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jattr  ;
  jstring jmsg = 0 ;
  
  if (!swig_override[0]) {
    CsoundCallbackWrapper::MessageCallback(attr,msg);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jattr = (jint) attr;
    jmsg = 0;
    if (msg) {
      jmsg = jenv->NewStringUTF((const char *)msg);
      if (!jmsg) return ;
    }
    Swig::LocalRefGuard msg_refguard(jenv, jmsg);
    jenv->CallStaticVoidMethod(Swig::jclass_csnd6JNI, Swig::director_method_ids[0], swigjobj, jattr, jmsg);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in CsoundCallbackWrapper::MessageCallback ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

double SwigDirector_CsoundCallbackWrapper::InputValueCallback(char const *chnName) {
  double c_result = SwigValueInit< double >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jchnName = 0 ;
  
  if (!swig_override[1]) {
    return CsoundCallbackWrapper::InputValueCallback(chnName);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jchnName = 0;
    if (chnName) {
      jchnName = jenv->NewStringUTF((const char *)chnName);
      if (!jchnName) return c_result;
    }
    Swig::LocalRefGuard chnName_refguard(jenv, jchnName);
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_csnd6JNI, Swig::director_method_ids[1], swigjobj, jchnName);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (double)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in CsoundCallbackWrapper::InputValueCallback ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_CsoundCallbackWrapper::OutputValueCallback(char const *chnName,double value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jchnName = 0 ;
  jdouble jvalue  ;
  
  if (!swig_override[2]) {
    CsoundCallbackWrapper::OutputValueCallback(chnName,value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jchnName = 0;
    if (chnName) {
      jchnName = jenv->NewStringUTF((const char *)chnName);
      if (!jchnName) return ;
    }
    Swig::LocalRefGuard chnName_refguard(jenv, jchnName);
    jvalue = (jdouble) value;
    jenv->CallStaticVoidMethod(Swig::jclass_csnd6JNI, Swig::director_method_ids[2], swigjobj, jchnName, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in CsoundCallbackWrapper::OutputValueCallback ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

int SwigDirector_CsoundCallbackWrapper::YieldCallback() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return CsoundCallbackWrapper::YieldCallback();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_csnd6JNI, Swig::director_method_ids[3], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in CsoundCallbackWrapper::YieldCallback ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_CsoundCallbackWrapper::MidiInputCallback(CsoundMidiInputBuffer *p) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jp = 0 ;
  
  if (!swig_override[4]) {
    CsoundCallbackWrapper::MidiInputCallback(p);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((CsoundMidiInputBuffer **)&jp) = (CsoundMidiInputBuffer *) p; 
    jenv->CallStaticVoidMethod(Swig::jclass_csnd6JNI, Swig::director_method_ids[4], swigjobj, jp);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in CsoundCallbackWrapper::MidiInputCallback ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_CsoundCallbackWrapper::MidiOutputCallback(CsoundMidiOutputBuffer *p) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jp = 0 ;
  
  if (!swig_override[5]) {
    CsoundCallbackWrapper::MidiOutputCallback(p);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((CsoundMidiOutputBuffer **)&jp) = (CsoundMidiOutputBuffer *) p; 
    jenv->CallStaticVoidMethod(Swig::jclass_csnd6JNI, Swig::director_method_ids[5], swigjobj, jp);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in CsoundCallbackWrapper::MidiOutputCallback ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

SwigDirector_CsoundCallbackWrapper::~SwigDirector_CsoundCallbackWrapper() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_CsoundCallbackWrapper::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "csnd6/CsoundCallbackWrapper");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "MessageCallback", "(ILjava/lang/String;)V"),
    SwigDirectorMethod(jenv, baseclass, "InputValueCallback", "(Ljava/lang/String;)D"),
    SwigDirectorMethod(jenv, baseclass, "OutputValueCallback", "(Ljava/lang/String;D)V"),
    SwigDirectorMethod(jenv, baseclass, "YieldCallback", "()I"),
    SwigDirectorMethod(jenv, baseclass, "MidiInputCallback", "(Lcsnd6/CsoundMidiInputBuffer;)V"),
    SwigDirectorMethod(jenv, baseclass, "MidiOutputCallback", "(Lcsnd6/CsoundMidiOutputBuffer;)V")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 6; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1SUCCESS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  CSOUND_STATUS result;
  
  (void)jenv;
  (void)jcls;
  result = (CSOUND_STATUS)CSOUND_SUCCESS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1ERROR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  CSOUND_STATUS result;
  
  (void)jenv;
  (void)jcls;
  result = (CSOUND_STATUS)CSOUND_ERROR;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1INITIALIZATION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  CSOUND_STATUS result;
  
  (void)jenv;
  (void)jcls;
  result = (CSOUND_STATUS)CSOUND_INITIALIZATION;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PERFORMANCE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  CSOUND_STATUS result;
  
  (void)jenv;
  (void)jcls;
  result = (CSOUND_STATUS)CSOUND_PERFORMANCE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1MEMORY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  CSOUND_STATUS result;
  
  (void)jenv;
  (void)jcls;
  result = (CSOUND_STATUS)CSOUND_MEMORY;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1SIGNAL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  CSOUND_STATUS result;
  
  (void)jenv;
  (void)jcls;
  result = (CSOUND_STATUS)CSOUND_SIGNAL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1EXITJMP_1SUCCESS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((256));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDINIT_1NO_1SIGNAL_1HANDLER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDINIT_1NO_1ATEXIT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CSOUND_1CALLBACK_1KBD_1EVENT_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((0x00000001U));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CSOUND_1CALLBACK_1KBD_1TEXT_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((0x00000002U));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSFTYPE_1UNIFIED_1CSD_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  CSOUND_FILETYPES result;
  
  (void)jenv;
  (void)jcls;
  result = (CSOUND_FILETYPES)CSFTYPE_UNIFIED_CSD;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSFTYPE_1UNKNOWN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  CSOUND_FILETYPES result;
  
  (void)jenv;
  (void)jcls;
  result = (CSOUND_FILETYPES)CSFTYPE_UNKNOWN;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1debug_1mode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->debug_mode = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1debug_1mode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->debug_mode);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1buffer_1frames_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->buffer_frames = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1buffer_1frames_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->buffer_frames);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1hardware_1buffer_1frames_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->hardware_buffer_frames = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1hardware_1buffer_1frames_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->hardware_buffer_frames);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1displays_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->displays = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1displays_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->displays);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1ascii_1graphs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->ascii_graphs = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1ascii_1graphs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->ascii_graphs);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1postscript_1graphs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->postscript_graphs = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1postscript_1graphs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->postscript_graphs);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1message_1level_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->message_level = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1message_1level_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->message_level);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1tempo_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->tempo = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1tempo_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->tempo);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1ring_1bell_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->ring_bell = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1ring_1bell_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->ring_bell);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1use_1cscore_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->use_cscore = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1use_1cscore_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->use_cscore);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1terminate_1on_1midi_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->terminate_on_midi = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1terminate_1on_1midi_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->terminate_on_midi);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1heartbeat_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->heartbeat = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1heartbeat_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->heartbeat);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1defer_1gen01_1load_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->defer_gen01_load = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1defer_1gen01_1load_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->defer_gen01_load);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1midi_1key_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->midi_key = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1midi_1key_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->midi_key);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1midi_1key_1cps_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->midi_key_cps = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1midi_1key_1cps_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->midi_key_cps);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1midi_1key_1oct_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->midi_key_oct = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1midi_1key_1oct_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->midi_key_oct);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1midi_1key_1pch_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->midi_key_pch = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1midi_1key_1pch_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->midi_key_pch);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1midi_1velocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->midi_velocity = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1midi_1velocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->midi_velocity);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1midi_1velocity_1amp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->midi_velocity_amp = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1midi_1velocity_1amp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->midi_velocity_amp);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1no_1default_1paths_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->no_default_paths = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1no_1default_1paths_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->no_default_paths);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1number_1of_1threads_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->number_of_threads = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1number_1of_1threads_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->number_of_threads);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1syntax_1check_1only_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->syntax_check_only = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1syntax_1check_1only_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->syntax_check_only);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1csd_1line_1counts_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->csd_line_counts = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1csd_1line_1counts_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->csd_line_counts);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1compute_1weights_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->compute_weights = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1compute_1weights_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->compute_weights);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1realtime_1mode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->realtime_mode = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1realtime_1mode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->realtime_mode);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1sample_1accurate_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->sample_accurate = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1sample_1accurate_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->sample_accurate);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1sample_1rate_1override_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->sample_rate_override = arg2;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1sample_1rate_1override_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (double) ((arg1)->sample_rate_override);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1control_1rate_1override_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->control_rate_override = arg2;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1control_1rate_1override_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (double) ((arg1)->control_rate_override);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1nchnls_1override_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->nchnls_override = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1nchnls_1override_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->nchnls_override);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1nchnls_1i_1override_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->nchnls_i_override = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1nchnls_1i_1override_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->nchnls_i_override);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1e0dbfs_1override_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->e0dbfs_override = arg2;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1e0dbfs_1override_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (double) ((arg1)->e0dbfs_override);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1daemon_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->daemon = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1daemon_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->daemon);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1ksmps_1override_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->ksmps_override = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1ksmps_1override_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->ksmps_override);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1FFT_1library_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSOUND_PARAMS *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->FFT_library = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PARAMS_1FFT_1library_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSOUND_PARAMS *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  result = (int) ((arg1)->FFT_library);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CSOUND_1PARAMS(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CSOUND_PARAMS *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CSOUND_PARAMS *)new CSOUND_PARAMS();
  *(CSOUND_PARAMS **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CSOUND_1PARAMS(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CSOUND_PARAMS *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND_PARAMS **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CS_1AUDIODEVICE_1device_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CS_AUDIODEVICE *arg1 = 0 ;
  char *arg2 = (char *)0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_AUDIODEVICE **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->device_name, (const char *)arg2, 128-1);
      arg1->device_name[128-1] = 0;
    } else {
      arg1->device_name[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CS_1AUDIODEVICE_1device_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CS_AUDIODEVICE *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_AUDIODEVICE **)&jarg1; 
  result = (char *)(char *) ((arg1)->device_name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CS_1AUDIODEVICE_1device_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CS_AUDIODEVICE *arg1 = 0 ;
  char *arg2 = (char *)0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_AUDIODEVICE **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->device_id, (const char *)arg2, 128-1);
      arg1->device_id[128-1] = 0;
    } else {
      arg1->device_id[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CS_1AUDIODEVICE_1device_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CS_AUDIODEVICE *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_AUDIODEVICE **)&jarg1; 
  result = (char *)(char *) ((arg1)->device_id);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CS_1AUDIODEVICE_1rt_1module_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CS_AUDIODEVICE *arg1 = 0 ;
  char *arg2 = (char *)0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_AUDIODEVICE **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->rt_module, (const char *)arg2, 128-1);
      arg1->rt_module[128-1] = 0;
    } else {
      arg1->rt_module[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CS_1AUDIODEVICE_1rt_1module_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CS_AUDIODEVICE *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_AUDIODEVICE **)&jarg1; 
  result = (char *)(char *) ((arg1)->rt_module);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CS_1AUDIODEVICE_1max_1nchnls_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CS_AUDIODEVICE *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_AUDIODEVICE **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->max_nchnls = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CS_1AUDIODEVICE_1max_1nchnls_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CS_AUDIODEVICE *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_AUDIODEVICE **)&jarg1; 
  result = (int) ((arg1)->max_nchnls);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CS_1AUDIODEVICE_1isOutput_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CS_AUDIODEVICE *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_AUDIODEVICE **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->isOutput = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CS_1AUDIODEVICE_1isOutput_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CS_AUDIODEVICE *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_AUDIODEVICE **)&jarg1; 
  result = (int) ((arg1)->isOutput);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CS_1AUDIODEVICE(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CS_AUDIODEVICE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CS_AUDIODEVICE *)new CS_AUDIODEVICE();
  *(CS_AUDIODEVICE **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CS_1AUDIODEVICE(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CS_AUDIODEVICE *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CS_AUDIODEVICE **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CS_1MIDIDEVICE_1device_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CS_MIDIDEVICE *arg1 = 0 ;
  char *arg2 = (char *)0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_MIDIDEVICE **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->device_name, (const char *)arg2, 128-1);
      arg1->device_name[128-1] = 0;
    } else {
      arg1->device_name[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CS_1MIDIDEVICE_1device_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CS_MIDIDEVICE *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_MIDIDEVICE **)&jarg1; 
  result = (char *)(char *) ((arg1)->device_name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CS_1MIDIDEVICE_1interface_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CS_MIDIDEVICE *arg1 = 0 ;
  char *arg2 = (char *)0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_MIDIDEVICE **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->interface_name, (const char *)arg2, 128-1);
      arg1->interface_name[128-1] = 0;
    } else {
      arg1->interface_name[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CS_1MIDIDEVICE_1interface_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CS_MIDIDEVICE *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_MIDIDEVICE **)&jarg1; 
  result = (char *)(char *) ((arg1)->interface_name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CS_1MIDIDEVICE_1device_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CS_MIDIDEVICE *arg1 = 0 ;
  char *arg2 = (char *)0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_MIDIDEVICE **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->device_id, (const char *)arg2, 128-1);
      arg1->device_id[128-1] = 0;
    } else {
      arg1->device_id[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CS_1MIDIDEVICE_1device_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CS_MIDIDEVICE *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_MIDIDEVICE **)&jarg1; 
  result = (char *)(char *) ((arg1)->device_id);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CS_1MIDIDEVICE_1midi_1module_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CS_MIDIDEVICE *arg1 = 0 ;
  char *arg2 = (char *)0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_MIDIDEVICE **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->midi_module, (const char *)arg2, 128-1);
      arg1->midi_module[128-1] = 0;
    } else {
      arg1->midi_module[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CS_1MIDIDEVICE_1midi_1module_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CS_MIDIDEVICE *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_MIDIDEVICE **)&jarg1; 
  result = (char *)(char *) ((arg1)->midi_module);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CS_1MIDIDEVICE_1isOutput_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CS_MIDIDEVICE *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_MIDIDEVICE **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->isOutput = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CS_1MIDIDEVICE_1isOutput_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CS_MIDIDEVICE *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CS_MIDIDEVICE **)&jarg1; 
  result = (int) ((arg1)->isOutput);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CS_1MIDIDEVICE(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CS_MIDIDEVICE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CS_MIDIDEVICE *)new CS_MIDIDEVICE();
  *(CS_MIDIDEVICE **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CS_1MIDIDEVICE(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CS_MIDIDEVICE *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CS_MIDIDEVICE **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csRtAudioParams_1devName_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  csRtAudioParams *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csRtAudioParams **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->devName;
    if (arg2) {
      arg1->devName = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->devName, (const char *)arg2);
    } else {
      arg1->devName = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_csRtAudioParams_1devName_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  csRtAudioParams *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csRtAudioParams **)&jarg1; 
  result = (char *) ((arg1)->devName);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csRtAudioParams_1devNum_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csRtAudioParams *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csRtAudioParams **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->devNum = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csRtAudioParams_1devNum_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csRtAudioParams *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csRtAudioParams **)&jarg1; 
  result = (int) ((arg1)->devNum);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csRtAudioParams_1bufSamp_1SW_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csRtAudioParams *arg1 = 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csRtAudioParams **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->bufSamp_SW = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csRtAudioParams_1bufSamp_1SW_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csRtAudioParams *arg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csRtAudioParams **)&jarg1; 
  result = (unsigned int) ((arg1)->bufSamp_SW);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csRtAudioParams_1bufSamp_1HW_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csRtAudioParams *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csRtAudioParams **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->bufSamp_HW = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csRtAudioParams_1bufSamp_1HW_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csRtAudioParams *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csRtAudioParams **)&jarg1; 
  result = (int) ((arg1)->bufSamp_HW);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csRtAudioParams_1nChannels_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csRtAudioParams *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csRtAudioParams **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->nChannels = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csRtAudioParams_1nChannels_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csRtAudioParams *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csRtAudioParams **)&jarg1; 
  result = (int) ((arg1)->nChannels);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csRtAudioParams_1sampleFormat_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csRtAudioParams *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csRtAudioParams **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->sampleFormat = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csRtAudioParams_1sampleFormat_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csRtAudioParams *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csRtAudioParams **)&jarg1; 
  result = (int) ((arg1)->sampleFormat);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csRtAudioParams_1sampleRate_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  csRtAudioParams *arg1 = 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csRtAudioParams **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->sampleRate = arg2;
}


SWIGEXPORT jfloat JNICALL Java_csnd6_csnd6JNI_csRtAudioParams_1sampleRate_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  csRtAudioParams *arg1 = 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csRtAudioParams **)&jarg1; 
  result = (float) ((arg1)->sampleRate);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1csRtAudioParams(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  csRtAudioParams *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (csRtAudioParams *)new csRtAudioParams();
  *(csRtAudioParams **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1csRtAudioParams(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  csRtAudioParams *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(csRtAudioParams **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_RTCLOCK_1starttime_1real_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  RTCLOCK_S *arg1 = 0 ;
  int_least64_t arg2 ;
  int_least64_t *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RTCLOCK_S **)&jarg1; 
  argp2 = *(int_least64_t **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null int_least64_t");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->starttime_real = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_RTCLOCK_1starttime_1real_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  RTCLOCK_S *arg1 = 0 ;
  int_least64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RTCLOCK_S **)&jarg1; 
  result =  ((arg1)->starttime_real);
  *(int_least64_t **)&jresult = new int_least64_t(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_RTCLOCK_1starttime_1CPU_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  RTCLOCK_S *arg1 = 0 ;
  int_least64_t arg2 ;
  int_least64_t *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RTCLOCK_S **)&jarg1; 
  argp2 = *(int_least64_t **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null int_least64_t");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->starttime_CPU = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_RTCLOCK_1starttime_1CPU_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  RTCLOCK_S *arg1 = 0 ;
  int_least64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RTCLOCK_S **)&jarg1; 
  result =  ((arg1)->starttime_CPU);
  *(int_least64_t **)&jresult = new int_least64_t(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1RTCLOCK(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  RTCLOCK_S *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (RTCLOCK_S *)new RTCLOCK_S();
  *(RTCLOCK_S **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1RTCLOCK(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RTCLOCK_S *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RTCLOCK_S **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_opcodeListEntry_1opname_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  opcodeListEntry *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opcodeListEntry **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->opname;
    if (arg2) {
      arg1->opname = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->opname, (const char *)arg2);
    } else {
      arg1->opname = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_opcodeListEntry_1opname_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  opcodeListEntry *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opcodeListEntry **)&jarg1; 
  result = (char *) ((arg1)->opname);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_opcodeListEntry_1outypes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  opcodeListEntry *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opcodeListEntry **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->outypes;
    if (arg2) {
      arg1->outypes = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->outypes, (const char *)arg2);
    } else {
      arg1->outypes = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_opcodeListEntry_1outypes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  opcodeListEntry *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opcodeListEntry **)&jarg1; 
  result = (char *) ((arg1)->outypes);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_opcodeListEntry_1intypes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  opcodeListEntry *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opcodeListEntry **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->intypes;
    if (arg2) {
      arg1->intypes = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->intypes, (const char *)arg2);
    } else {
      arg1->intypes = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_opcodeListEntry_1intypes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  opcodeListEntry *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opcodeListEntry **)&jarg1; 
  result = (char *) ((arg1)->intypes);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_opcodeListEntry_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  opcodeListEntry *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opcodeListEntry **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_opcodeListEntry_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  opcodeListEntry *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opcodeListEntry **)&jarg1; 
  result = (int) ((arg1)->flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1opcodeListEntry(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  opcodeListEntry *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (opcodeListEntry *)new opcodeListEntry();
  *(opcodeListEntry **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1opcodeListEntry(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  opcodeListEntry *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(opcodeListEntry **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundRandMTState_1mti_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CsoundRandMTState_ *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundRandMTState_ **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->mti = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundRandMTState_1mti_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundRandMTState_ *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundRandMTState_ **)&jarg1; 
  result = (int) ((arg1)->mti);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundRandMTState_1mt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2) {
  CsoundRandMTState_ *arg1 = 0 ;
  uint32_t *arg2 = (uint32_t *)0 ;
  jlong *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundRandMTState_ **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 624) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUint(jenv, &jarr2, (unsigned int **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    uint32_t *b = (uint32_t *) arg1->mt;
    for (ii = 0; ii < (size_t)624; ii++) b[ii] = *((uint32_t *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUint(jenv, jarr2, (unsigned int *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jlongArray JNICALL Java_csnd6_csnd6JNI_CsoundRandMTState_1mt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlongArray jresult = 0 ;
  CsoundRandMTState_ *arg1 = 0 ;
  uint32_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundRandMTState_ **)&jarg1; 
  result = (uint32_t *)(uint32_t *) ((arg1)->mt);
  jresult = SWIG_JavaArrayOutUint(jenv, (unsigned int *)result, 624); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundRandMTState(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CsoundRandMTState_ *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CsoundRandMTState_ *)new CsoundRandMTState_();
  *(CsoundRandMTState_ **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundRandMTState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundRandMTState_ *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundRandMTState_ **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1N_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  pvsdat_ext *arg1 = 0 ;
  int32 arg2 ;
  int32 *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  argp2 = *(int32 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null int32");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->N = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1N_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  pvsdat_ext *arg1 = 0 ;
  int32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  result =  ((arg1)->N);
  *(int32 **)&jresult = new int32(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1sliding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  pvsdat_ext *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->sliding = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1sliding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  pvsdat_ext *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  result = (int) ((arg1)->sliding);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1NB_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  pvsdat_ext *arg1 = 0 ;
  int32 arg2 ;
  int32 *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  argp2 = *(int32 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null int32");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->NB = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1NB_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  pvsdat_ext *arg1 = 0 ;
  int32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  result =  ((arg1)->NB);
  *(int32 **)&jresult = new int32(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1overlap_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  pvsdat_ext *arg1 = 0 ;
  int32 arg2 ;
  int32 *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  argp2 = *(int32 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null int32");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->overlap = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1overlap_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  pvsdat_ext *arg1 = 0 ;
  int32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  result =  ((arg1)->overlap);
  *(int32 **)&jresult = new int32(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1winsize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  pvsdat_ext *arg1 = 0 ;
  int32 arg2 ;
  int32 *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  argp2 = *(int32 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null int32");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->winsize = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1winsize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  pvsdat_ext *arg1 = 0 ;
  int32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  result =  ((arg1)->winsize);
  *(int32 **)&jresult = new int32(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1wintype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  pvsdat_ext *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->wintype = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1wintype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  pvsdat_ext *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  result = (int) ((arg1)->wintype);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1format_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  pvsdat_ext *arg1 = 0 ;
  int32 arg2 ;
  int32 *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  argp2 = *(int32 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null int32");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->format = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1format_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  pvsdat_ext *arg1 = 0 ;
  int32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  result =  ((arg1)->format);
  *(int32 **)&jresult = new int32(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1framecount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  pvsdat_ext *arg1 = 0 ;
  uint32 arg2 ;
  uint32 *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  argp2 = *(uint32 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint32");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->framecount = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1framecount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  pvsdat_ext *arg1 = 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  result =  ((arg1)->framecount);
  *(uint32 **)&jresult = new uint32(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1frame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  pvsdat_ext *arg1 = 0 ;
  float *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  arg2 = *(float **)&jarg2; 
  if (arg1) (arg1)->frame = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_PVSDATEXT_1frame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  pvsdat_ext *arg1 = 0 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(pvsdat_ext **)&jarg1; 
  result = (float *) ((arg1)->frame);
  *(float **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1PVSDATEXT(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  pvsdat_ext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (pvsdat_ext *)new pvsdat_ext();
  *(pvsdat_ext **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1PVSDATEXT(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  pvsdat_ext *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(pvsdat_ext **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_ORCTOKEN_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  ORCTOKEN *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ORCTOKEN **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_ORCTOKEN_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ORCTOKEN *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ORCTOKEN **)&jarg1; 
  result = (int) ((arg1)->type);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_ORCTOKEN_1lexeme_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  ORCTOKEN *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ORCTOKEN **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->lexeme;
    if (arg2) {
      arg1->lexeme = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->lexeme, (const char *)arg2);
    } else {
      arg1->lexeme = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_ORCTOKEN_1lexeme_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  ORCTOKEN *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ORCTOKEN **)&jarg1; 
  result = (char *) ((arg1)->lexeme);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_ORCTOKEN_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  ORCTOKEN *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ORCTOKEN **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->value = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_ORCTOKEN_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ORCTOKEN *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ORCTOKEN **)&jarg1; 
  result = (int) ((arg1)->value);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_ORCTOKEN_1fvalue_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  ORCTOKEN *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ORCTOKEN **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->fvalue = arg2;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_ORCTOKEN_1fvalue_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  ORCTOKEN *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ORCTOKEN **)&jarg1; 
  result = (double) ((arg1)->fvalue);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_ORCTOKEN_1optype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  ORCTOKEN *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ORCTOKEN **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->optype;
    if (arg2) {
      arg1->optype = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->optype, (const char *)arg2);
    } else {
      arg1->optype = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_ORCTOKEN_1optype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  ORCTOKEN *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ORCTOKEN **)&jarg1; 
  result = (char *) ((arg1)->optype);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_ORCTOKEN_1next_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  ORCTOKEN *arg1 = 0 ;
  ORCTOKEN *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(ORCTOKEN **)&jarg1; 
  arg2 = *(ORCTOKEN **)&jarg2; 
  if (arg1) (arg1)->next = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_ORCTOKEN_1next_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ORCTOKEN *arg1 = 0 ;
  ORCTOKEN *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ORCTOKEN **)&jarg1; 
  result = (ORCTOKEN *) ((arg1)->next);
  *(ORCTOKEN **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1ORCTOKEN(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ORCTOKEN *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ORCTOKEN *)new ORCTOKEN();
  *(ORCTOKEN **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1ORCTOKEN(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ORCTOKEN *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ORCTOKEN **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_TREE_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  TREE *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_TREE_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  TREE *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  result = (int) ((arg1)->type);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_TREE_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  TREE *arg1 = 0 ;
  ORCTOKEN *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(TREE **)&jarg1; 
  arg2 = *(ORCTOKEN **)&jarg2; 
  if (arg1) (arg1)->value = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_TREE_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TREE *arg1 = 0 ;
  ORCTOKEN *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  result = (ORCTOKEN *) ((arg1)->value);
  *(ORCTOKEN **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_TREE_1rate_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  TREE *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->rate = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_TREE_1rate_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  TREE *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  result = (int) ((arg1)->rate);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_TREE_1len_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  TREE *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->len = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_TREE_1len_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  TREE *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  result = (int) ((arg1)->len);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_TREE_1line_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  TREE *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->line = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_TREE_1line_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  TREE *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  result = (int) ((arg1)->line);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_TREE_1locn_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  TREE *arg1 = 0 ;
  uint64_t arg2 ;
  uint64_t *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  argp2 = *(uint64_t **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint64_t");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->locn = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_TREE_1locn_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TREE *arg1 = 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  result =  ((arg1)->locn);
  *(uint64_t **)&jresult = new uint64_t(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_TREE_1left_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  TREE *arg1 = 0 ;
  TREE *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(TREE **)&jarg1; 
  arg2 = *(TREE **)&jarg2; 
  if (arg1) (arg1)->left = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_TREE_1left_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TREE *arg1 = 0 ;
  TREE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  result = (TREE *) ((arg1)->left);
  *(TREE **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_TREE_1right_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  TREE *arg1 = 0 ;
  TREE *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(TREE **)&jarg1; 
  arg2 = *(TREE **)&jarg2; 
  if (arg1) (arg1)->right = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_TREE_1right_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TREE *arg1 = 0 ;
  TREE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  result = (TREE *) ((arg1)->right);
  *(TREE **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_TREE_1next_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  TREE *arg1 = 0 ;
  TREE *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(TREE **)&jarg1; 
  arg2 = *(TREE **)&jarg2; 
  if (arg1) (arg1)->next = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_TREE_1next_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TREE *arg1 = 0 ;
  TREE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  result = (TREE *) ((arg1)->next);
  *(TREE **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_TREE_1markup_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  TREE *arg1 = 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->markup = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_TREE_1markup_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TREE *arg1 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TREE **)&jarg1; 
  result = (void *) ((arg1)->markup);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1TREE(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TREE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (TREE *)new TREE();
  *(TREE **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1TREE(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  TREE *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TREE **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1CONTROL_1CHANNEL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  controlChannelType result;
  
  (void)jenv;
  (void)jcls;
  result = (controlChannelType)CSOUND_CONTROL_CHANNEL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1AUDIO_1CHANNEL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  controlChannelType result;
  
  (void)jenv;
  (void)jcls;
  result = (controlChannelType)CSOUND_AUDIO_CHANNEL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1STRING_1CHANNEL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  controlChannelType result;
  
  (void)jenv;
  (void)jcls;
  result = (controlChannelType)CSOUND_STRING_CHANNEL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1PVS_1CHANNEL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  controlChannelType result;
  
  (void)jenv;
  (void)jcls;
  result = (controlChannelType)CSOUND_PVS_CHANNEL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1VAR_1CHANNEL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  controlChannelType result;
  
  (void)jenv;
  (void)jcls;
  result = (controlChannelType)CSOUND_VAR_CHANNEL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1CHANNEL_1TYPE_1MASK_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  controlChannelType result;
  
  (void)jenv;
  (void)jcls;
  result = (controlChannelType)CSOUND_CHANNEL_TYPE_MASK;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1INPUT_1CHANNEL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  controlChannelType result;
  
  (void)jenv;
  (void)jcls;
  result = (controlChannelType)CSOUND_INPUT_CHANNEL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1OUTPUT_1CHANNEL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  controlChannelType result;
  
  (void)jenv;
  (void)jcls;
  result = (controlChannelType)CSOUND_OUTPUT_CHANNEL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1CONTROL_1CHANNEL_1NO_1HINTS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  controlChannelBehavior result;
  
  (void)jenv;
  (void)jcls;
  result = (controlChannelBehavior)CSOUND_CONTROL_CHANNEL_NO_HINTS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1CONTROL_1CHANNEL_1INT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  controlChannelBehavior result;
  
  (void)jenv;
  (void)jcls;
  result = (controlChannelBehavior)CSOUND_CONTROL_CHANNEL_INT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1CONTROL_1CHANNEL_1LIN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  controlChannelBehavior result;
  
  (void)jenv;
  (void)jcls;
  result = (controlChannelBehavior)CSOUND_CONTROL_CHANNEL_LIN;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUND_1CONTROL_1CHANNEL_1EXP_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  controlChannelBehavior result;
  
  (void)jenv;
  (void)jcls;
  result = (controlChannelBehavior)CSOUND_CONTROL_CHANNEL_EXP;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1behav_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  controlChannelHints_s *arg1 = 0 ;
  controlChannelBehavior arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  arg2 = (controlChannelBehavior)jarg2; 
  if (arg1) (arg1)->behav = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1behav_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  controlChannelHints_s *arg1 = 0 ;
  controlChannelBehavior result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  result = (controlChannelBehavior) ((arg1)->behav);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1dflt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  controlChannelHints_s *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->dflt = arg2;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1dflt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  controlChannelHints_s *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  result = (double) ((arg1)->dflt);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1min_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  controlChannelHints_s *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->min = arg2;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1min_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  controlChannelHints_s *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  result = (double) ((arg1)->min);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1max_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  controlChannelHints_s *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->max = arg2;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1max_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  controlChannelHints_s *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  result = (double) ((arg1)->max);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1x_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  controlChannelHints_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->x = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1x_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  controlChannelHints_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  result = (int) ((arg1)->x);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1y_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  controlChannelHints_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->y = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1y_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  controlChannelHints_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  result = (int) ((arg1)->y);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1width_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  controlChannelHints_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->width = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1width_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  controlChannelHints_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  result = (int) ((arg1)->width);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1height_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  controlChannelHints_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->height = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1height_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  controlChannelHints_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  result = (int) ((arg1)->height);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1attributes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  controlChannelHints_s *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->attributes;
    if (arg2) {
      arg1->attributes = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->attributes, (const char *)arg2);
    } else {
      arg1->attributes = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_controlChannelHints_1t_1attributes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  controlChannelHints_s *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  result = (char *) ((arg1)->attributes);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1controlChannelHints_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  controlChannelHints_s *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (controlChannelHints_s *)new controlChannelHints_s();
  *(controlChannelHints_s **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1controlChannelHints_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  controlChannelHints_s *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(controlChannelHints_s **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_controlChannelInfo_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  controlChannelInfo_s *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelInfo_s **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->name;
    if (arg2) {
      arg1->name = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->name, (const char *)arg2);
    } else {
      arg1->name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_controlChannelInfo_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  controlChannelInfo_s *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelInfo_s **)&jarg1; 
  result = (char *) ((arg1)->name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_controlChannelInfo_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  controlChannelInfo_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelInfo_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_controlChannelInfo_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  controlChannelInfo_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelInfo_s **)&jarg1; 
  result = (int) ((arg1)->type);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_controlChannelInfo_1t_1hints_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  controlChannelInfo_s *arg1 = 0 ;
  controlChannelHints_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(controlChannelInfo_s **)&jarg1; 
  arg2 = *(controlChannelHints_t **)&jarg2; 
  if (arg1) (arg1)->hints = *arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_controlChannelInfo_1t_1hints_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  controlChannelInfo_s *arg1 = 0 ;
  controlChannelHints_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(controlChannelInfo_s **)&jarg1; 
  result = (controlChannelHints_t *)& ((arg1)->hints);
  *(controlChannelHints_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1controlChannelInfo_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  controlChannelInfo_s *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (controlChannelInfo_s *)new controlChannelInfo_s();
  *(controlChannelInfo_s **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1controlChannelInfo_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  controlChannelInfo_s *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(controlChannelInfo_s **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundInitialize(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  int arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (int)csoundInitialize(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetOpcodedir(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  csoundSetOpcodedir((char const *)arg1);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundCreate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  void *arg1 = 0 ;
  CSOUND *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  result = (CSOUND *)csoundCreate(arg1);
  *(CSOUND **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundLoadPlugins(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)csoundLoadPlugins(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundDestroy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CSOUND *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  csoundDestroy(arg1);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetVersion(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)csoundGetVersion();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetAPIVersion(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)csoundGetAPIVersion();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundParseOrc(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  TREE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (TREE *)csoundParseOrc(arg1,(char const *)arg2);
  *(TREE **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundCompileTree(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  TREE *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(TREE **)&jarg2; 
  result = (int)csoundCompileTree(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundCompileTreeAsync(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  TREE *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(TREE **)&jarg2; 
  result = (int)csoundCompileTreeAsync(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundDeleteTree(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  CSOUND *arg1 = 0 ;
  TREE *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(TREE **)&jarg2; 
  csoundDeleteTree(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundCompileOrc(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)csoundCompileOrc(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundCompileOrcAsync(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)csoundCompileOrcAsync(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csoundEvalCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jdouble jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (double)csoundEvalCode(arg1,(char const *)arg2);
  jresult = (jdouble)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundInitializeCscore(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  FILE *arg2 = 0 ;
  FILE *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(FILE **)&jarg2; 
  arg3 = *(FILE **)&jarg3; 
  result = (int)csoundInitializeCscore(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundCompileArgs(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jobjectArray jarg3) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int arg2 ;
  char **arg3 = 0 ;
  jint size3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    int i = 0;
    if (jarg3) {
      size3 = jenv->GetArrayLength(jarg3);
      
      arg3 = new char*[size3+1];
      
      
      
      for (i = 0; i<size3; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg3, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg3[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg3[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg3[i] = 0;
    } else {
      arg3 = 0;
      size3 = 0;
    }
  }
  result = (int)csoundCompileArgs(arg1,arg2,(char const **)arg3);
  jresult = (jint)result; 
  {
    int i;
    for (i=0; i<size3; i++)
    
    delete[] arg3[i];
    delete[] arg3;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundStart(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (int)csoundStart(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundCompile(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jobjectArray jarg3) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int arg2 ;
  char **arg3 = 0 ;
  jint size3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    int i = 0;
    if (jarg3) {
      size3 = jenv->GetArrayLength(jarg3);
      
      arg3 = new char*[size3+1];
      
      
      
      for (i = 0; i<size3; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg3, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg3[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg3[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg3[i] = 0;
    } else {
      arg3 = 0;
      size3 = 0;
    }
  }
  result = (int)csoundCompile(arg1,arg2,(char const **)arg3);
  jresult = (jint)result; 
  {
    int i;
    for (i=0; i<size3; i++)
    
    delete[] arg3[i];
    delete[] arg3;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundCompileCsd(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)csoundCompileCsd(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundCompileCsdText(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)csoundCompileCsdText(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundPerform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (int)csoundPerform(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundPerformKsmps(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (int)csoundPerformKsmps(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundPerformBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (int)csoundPerformBuffer(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundStop(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CSOUND *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  csoundStop(arg1);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundCleanup(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (int)csoundCleanup(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundReset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CSOUND *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  csoundReset(arg1);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundUDPServerStart(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  unsigned int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (int)csoundUDPServerStart(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundUDPServerStatus(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (int)csoundUDPServerStatus(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundUDPServerClose(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (int)csoundUDPServerClose(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundUDPConsole(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)csoundUDPConsole(arg1,(char const *)arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundStopUDPConsole(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CSOUND *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  csoundStopUDPConsole(arg1);
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csoundGetSr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (double)csoundGetSr(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csoundGetKr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (double)csoundGetKr(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetKsmps(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (uint32_t)csoundGetKsmps(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetNchnls(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (uint32_t)csoundGetNchnls(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetNchnlsInput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (uint32_t)csoundGetNchnlsInput(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csoundGet0dBFS(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (double)csoundGet0dBFS(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csoundGetA4(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (double)csoundGetA4(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetCurrentTimeSamples(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = csoundGetCurrentTimeSamples(arg1);
  *(int64_t **)&jresult = new int64_t(result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetSizeOfMYFLT(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)csoundGetSizeOfMYFLT();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetHostData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (void *)csoundGetHostData(arg1);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetHostData(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  CSOUND *arg1 = 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  csoundSetHostData(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundSetOption(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)csoundSetOption(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetParams(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  CSOUND *arg1 = 0 ;
  CSOUND_PARAMS *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(CSOUND_PARAMS **)&jarg2; 
  csoundSetParams(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundGetParams(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  CSOUND *arg1 = 0 ;
  CSOUND_PARAMS *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(CSOUND_PARAMS **)&jarg2; 
  csoundGetParams(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetDebug(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (int)csoundGetDebug(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetDebug(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  csoundSetDebug(arg1,arg2);
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csoundSystemSr(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  jdouble jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (double)jarg2; 
  result = (double)csoundSystemSr(arg1,arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_csoundGetOutputName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (char *)csoundGetOutputName(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_csoundGetInputName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (char *)csoundGetInputName(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetOutput(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  char *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return ;
  }
  csoundSetOutput(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundGetOutputFormat(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  csoundGetOutputFormat(arg1,arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetInput(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  csoundSetInput(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetMIDIInput(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  csoundSetMIDIInput(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetMIDIFileInput(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  csoundSetMIDIFileInput(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetMIDIOutput(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  csoundSetMIDIOutput(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetMIDIFileOutput(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  csoundSetMIDIFileOutput(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetRTAudioModule(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  csoundSetRTAudioModule(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetModule(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int arg2 ;
  char **arg3 = 0 ;
  char **arg4 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(char ***)&jarg3; 
  arg4 = *(char ***)&jarg4; 
  result = (int)csoundGetModule(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetInputBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (long)csoundGetInputBufferSize(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetOutputBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (long)csoundGetOutputBufferSize(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetInputBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (double *)csoundGetInputBuffer(arg1);
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetOutputBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (double *)csoundGetOutputBuffer(arg1);
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetSpin(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (double *)csoundGetSpin(arg1);
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundClearSpin(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CSOUND *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  csoundClearSpin(arg1);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundAddSpinSample(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jdouble jarg4) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  csoundAddSpinSample(arg1,arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetSpinSample(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jdouble jarg4) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  csoundSetSpinSample(arg1,arg2,arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetSpout(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (double *)csoundGetSpout(arg1);
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csoundGetSpoutSample(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jdouble jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (double)csoundGetSpoutSample(arg1,arg2,arg3);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetRtRecordUserData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  void **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (void **)csoundGetRtRecordUserData(arg1);
  *(void ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetRtPlayUserData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  void **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (void **)csoundGetRtPlayUserData(arg1);
  *(void ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetHostImplementedAudioIO(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  csoundSetHostImplementedAudioIO(arg1,arg2,arg3);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetAudioDevList(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_, jint jarg3) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  CS_AUDIODEVICE *arg2 = 0 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(CS_AUDIODEVICE **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (int)csoundGetAudioDevList(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetAudioDeviceListCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  CSOUND *arg1 = 0 ;
  int (*arg2)(CSOUND *,CS_AUDIODEVICE *,int) = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(int (**)(CSOUND *,CS_AUDIODEVICE *,int))&jarg2; 
  csoundSetAudioDeviceListCallback(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetMIDIModule(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  csoundSetMIDIModule(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetHostImplementedMIDIIO(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  csoundSetHostImplementedMIDIIO(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetMIDIDevList(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_, jint jarg3) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  CS_MIDIDEVICE *arg2 = 0 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(CS_MIDIDEVICE **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (int)csoundGetMIDIDevList(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetMIDIDeviceListCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  CSOUND *arg1 = 0 ;
  int (*arg2)(CSOUND *,CS_MIDIDEVICE *,int) = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(int (**)(CSOUND *,CS_MIDIDEVICE *,int))&jarg2; 
  csoundSetMIDIDeviceListCallback(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundReadScore(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)csoundReadScore(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundReadScoreAsync(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  csoundReadScoreAsync(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csoundGetScoreTime(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (double)csoundGetScoreTime(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundIsScorePending(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (int)csoundIsScorePending(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetScorePending(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  csoundSetScorePending(arg1,arg2);
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csoundGetScoreOffsetSeconds(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (double)csoundGetScoreOffsetSeconds(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetScoreOffsetSeconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  CSOUND *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (double)jarg2; 
  csoundSetScoreOffsetSeconds(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundRewindScore(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CSOUND *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  csoundRewindScore(arg1);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundScoreSort(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  FILE *arg2 = 0 ;
  FILE *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(FILE **)&jarg2; 
  arg3 = *(FILE **)&jarg3; 
  result = (int)csoundScoreSort(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundScoreExtract(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  FILE *arg2 = 0 ;
  FILE *arg3 = 0 ;
  FILE *arg4 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(FILE **)&jarg2; 
  arg3 = *(FILE **)&jarg3; 
  arg4 = *(FILE **)&jarg4; 
  result = (int)csoundScoreExtract(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  void *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  csoundMessage(arg1,(char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundMessageS(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  char *arg3 = 0 ;
  void *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  csoundMessageS(arg1,arg2,(char const *)arg3,arg4);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetDefaultMessageCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  void (*arg1)(CSOUND *,int,char const *,va_list) = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void (**)(CSOUND *,int,char const *,va_list))&jarg1; 
  csoundSetDefaultMessageCallback(arg1);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetMessageStringCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  CSOUND *arg1 = 0 ;
  void (*arg2)(CSOUND *,int,char const *) = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(void (**)(CSOUND *,int,char const *))&jarg2; 
  csoundSetMessageStringCallback(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetMessageLevel(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (int)csoundGetMessageLevel(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetMessageLevel(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  csoundSetMessageLevel(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundCreateMessageBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  csoundCreateMessageBuffer(arg1,arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_csoundGetFirstMessage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (char *)csoundGetFirstMessage(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetFirstMessageAttr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (int)csoundGetFirstMessageAttr(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundPopFirstMessage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CSOUND *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  csoundPopFirstMessage(arg1);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetMessageCnt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (int)csoundGetMessageCnt(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundDestroyMessageBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CSOUND *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  csoundDestroyMessageBuffer(arg1);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetChannelPtr(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jint jarg4) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double **arg2 = 0 ;
  char *arg3 = 0 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(double ***)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  result = (int)csoundGetChannelPtr(arg1,arg2,(char const *)arg3,arg4);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundListChannels(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  controlChannelInfo_t **arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(controlChannelInfo_t ***)&jarg2; 
  result = (int)csoundListChannels(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundDeleteChannelList(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  CSOUND *arg1 = 0 ;
  controlChannelInfo_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(controlChannelInfo_t **)&jarg2; 
  csoundDeleteChannelList(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundSetControlChannelHints(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  controlChannelHints_t arg3 ;
  controlChannelHints_t *argp3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  argp3 = *(controlChannelHints_t **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null controlChannelHints_t");
    return 0;
  }
  arg3 = *argp3; 
  result = (int)csoundSetControlChannelHints(arg1,(char const *)arg2,SWIG_STD_MOVE(arg3));
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetControlChannelHints(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  controlChannelHints_t *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(controlChannelHints_t **)&jarg3; 
  result = (int)csoundGetControlChannelHints(arg1,(char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetChannelLock(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int *)csoundGetChannelLock(arg1,(char const *)arg2);
  *(int **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csoundGetControlChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int *arg3 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(int **)&jarg3; 
  result = (double)csoundGetControlChannel(arg1,(char const *)arg2,arg3);
  jresult = (jdouble)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetControlChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jdouble jarg3) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (double)jarg3; 
  csoundSetControlChannel(arg1,(char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundGetAudioChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  double *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = *(double **)&jarg3; 
  csoundGetAudioChannel(arg1,(char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetAudioChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  double *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = *(double **)&jarg3; 
  csoundSetAudioChannel(arg1,(char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundGetStringChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  csoundGetStringChannel(arg1,(char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetStringChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  csoundSetStringChannel(arg1,(char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetChannelDatasize(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)csoundGetChannelDatasize(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetInputChannelCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  CSOUND *arg1 = 0 ;
  channelCallback_t arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(channelCallback_t *)&jarg2; 
  csoundSetInputChannelCallback(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetOutputChannelCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  CSOUND *arg1 = 0 ;
  channelCallback_t arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(channelCallback_t *)&jarg2; 
  csoundSetOutputChannelCallback(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundSetPvsChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  PVSDATEXT *arg2 = 0 ;
  char *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(PVSDATEXT **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)csoundSetPvsChannel(arg1,(pvsdat_ext const *)arg2,(char const *)arg3);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetPvsChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  PVSDATEXT *arg2 = 0 ;
  char *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(PVSDATEXT **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)csoundGetPvsChannel(arg1,arg2,(char const *)arg3);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundScoreEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jchar jarg2, jlong jarg3, jint jarg4) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char arg2 ;
  double *arg3 = 0 ;
  long arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (char)jarg2; 
  arg3 = *(double **)&jarg3; 
  arg4 = (long)jarg4; 
  result = (int)csoundScoreEvent(arg1,arg2,(double const *)arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundScoreEventAsync(JNIEnv *jenv, jclass jcls, jlong jarg1, jchar jarg2, jlong jarg3, jint jarg4) {
  CSOUND *arg1 = 0 ;
  char arg2 ;
  double *arg3 = 0 ;
  long arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (char)jarg2; 
  arg3 = *(double **)&jarg3; 
  arg4 = (long)jarg4; 
  csoundScoreEventAsync(arg1,arg2,(double const *)arg3,arg4);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundScoreEventAbsolute(JNIEnv *jenv, jclass jcls, jlong jarg1, jchar jarg2, jlong jarg3, jint jarg4, jdouble jarg5) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char arg2 ;
  double *arg3 = 0 ;
  long arg4 ;
  double arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (char)jarg2; 
  arg3 = *(double **)&jarg3; 
  arg4 = (long)jarg4; 
  arg5 = (double)jarg5; 
  result = (int)csoundScoreEventAbsolute(arg1,arg2,(double const *)arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundScoreEventAbsoluteAsync(JNIEnv *jenv, jclass jcls, jlong jarg1, jchar jarg2, jlong jarg3, jint jarg4, jdouble jarg5) {
  CSOUND *arg1 = 0 ;
  char arg2 ;
  double *arg3 = 0 ;
  long arg4 ;
  double arg5 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (char)jarg2; 
  arg3 = *(double **)&jarg3; 
  arg4 = (long)jarg4; 
  arg5 = (double)jarg5; 
  csoundScoreEventAbsoluteAsync(arg1,arg2,(double const *)arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundInputMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  csoundInputMessage(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundInputMessageAsync(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  csoundInputMessageAsync(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundKillInstance(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jstring jarg3, jint jarg4, jint jarg5) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double arg2 ;
  char *arg3 = 0 ;
  int arg4 ;
  int arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  result = (int)csoundKillInstance(arg1,arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundKeyPress(JNIEnv *jenv, jclass jcls, jlong jarg1, jchar jarg2) {
  CSOUND *arg1 = 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (char)jarg2; 
  csoundKeyPress(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundRegisterKeyboardCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int (*arg2)(void *,void *,unsigned int) = 0 ;
  void *arg3 = 0 ;
  unsigned int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(int (**)(void *,void *,unsigned int))&jarg2; 
  arg3 = *(void **)&jarg3; 
  arg4 = (unsigned int)jarg4; 
  result = (int)csoundRegisterKeyboardCallback(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundRemoveKeyboardCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  CSOUND *arg1 = 0 ;
  int (*arg2)(void *,void *,unsigned int) = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(int (**)(void *,void *,unsigned int))&jarg2; 
  csoundRemoveKeyboardCallback(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundTableLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)csoundTableLength(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csoundTableGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jdouble jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (double)csoundTableGet(arg1,arg2,arg3);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundTableSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jdouble jarg4) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  csoundTableSet(arg1,arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundTableCopyOut(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  double *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(double **)&jarg3; 
  csoundTableCopyOut(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundTableCopyOutAsync(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  double *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(double **)&jarg3; 
  csoundTableCopyOutAsync(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundTableCopyIn(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  double *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(double **)&jarg3; 
  csoundTableCopyIn(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundTableCopyInAsync(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  double *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(double **)&jarg3; 
  csoundTableCopyInAsync(arg1,arg2,arg3);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetTable(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double **arg2 = 0 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(double ***)&jarg2; 
  arg3 = (int)jarg3; 
  result = (int)csoundGetTable(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundGetTableArgs(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  double **arg2 = 0 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(double ***)&jarg2; 
  arg3 = (int)jarg3; 
  result = (int)csoundGetTableArgs(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundIsNamedGEN(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)csoundIsNamedGEN(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundGetNamedGEN(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jint jarg4) {
  CSOUND *arg1 = 0 ;
  int arg2 ;
  char *arg3 = 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = (int)jarg4; 
  csoundGetNamedGEN(arg1,arg2,arg3,arg4);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetNamedGens(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (void *)csoundGetNamedGens(arg1);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundNewOpcodeList(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  opcodeListEntry **arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(opcodeListEntry ***)&jarg2; 
  result = (int)csoundNewOpcodeList(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundDisposeOpcodeList(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  CSOUND *arg1 = 0 ;
  opcodeListEntry *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(opcodeListEntry **)&jarg2; 
  csoundDisposeOpcodeList(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundAppendOpcode(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4, jint jarg5, jstring jarg6, jstring jarg7, jlong jarg8, jlong jarg9, jlong jarg10) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  char *arg6 = 0 ;
  char *arg7 = 0 ;
  int (*arg8)(CSOUND *,void *) = 0 ;
  int (*arg9)(CSOUND *,void *) = 0 ;
  int (*arg10)(CSOUND *,void *) = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)jenv->GetStringUTFChars(jarg6, 0);
    if (!arg6) return 0;
  }
  arg7 = 0;
  if (jarg7) {
    arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
    if (!arg7) return 0;
  }
  arg8 = *(int (**)(CSOUND *,void *))&jarg8; 
  arg9 = *(int (**)(CSOUND *,void *))&jarg9; 
  arg10 = *(int (**)(CSOUND *,void *))&jarg10; 
  result = (int)csoundAppendOpcode(arg1,(char const *)arg2,arg3,arg4,arg5,(char const *)arg6,(char const *)arg7,arg8,arg9,arg10);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg6) jenv->ReleaseStringUTFChars(jarg6, (const char *)arg6);
  if (arg7) jenv->ReleaseStringUTFChars(jarg7, (const char *)arg7);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundCreateThread(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  uintptr_t (*arg1)(void *) = 0 ;
  void *arg2 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uintptr_t (**)(void *))&jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (void *)csoundCreateThread(arg1,arg2);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundCreateThread2(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  uintptr_t (*arg1)(void *) = 0 ;
  unsigned int arg2 ;
  void *arg3 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uintptr_t (**)(void *))&jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = *(void **)&jarg3; 
  result = (void *)csoundCreateThread2(arg1,arg2,arg3);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetCurrentThreadId(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (void *)csoundGetCurrentThreadId();
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundJoinThread(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  void *arg1 = 0 ;
  uintptr_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  result = csoundJoinThread(arg1);
  *(uintptr_t **)&jresult = new uintptr_t(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundCreateThreadLock(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (void *)csoundCreateThreadLock();
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundWaitThreadLock(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  void *arg1 = 0 ;
  size_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (int)csoundWaitThreadLock(arg1,SWIG_STD_MOVE(arg2));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundWaitThreadLockNoTimeout(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  void *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  csoundWaitThreadLockNoTimeout(arg1);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundNotifyThreadLock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  void *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  csoundNotifyThreadLock(arg1);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundDestroyThreadLock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  void *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  csoundDestroyThreadLock(arg1);
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundCreateMutex(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (void *)csoundCreateMutex(arg1);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundLockMutex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  void *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  csoundLockMutex(arg1);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundLockMutexNoWait(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  void *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  result = (int)csoundLockMutexNoWait(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundUnlockMutex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  void *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  csoundUnlockMutex(arg1);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundDestroyMutex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  void *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  csoundDestroyMutex(arg1);
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundCreateBarrier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  result = (void *)csoundCreateBarrier(arg1);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundDestroyBarrier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  void *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  result = (int)csoundDestroyBarrier(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundWaitBarrier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  void *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  result = (int)csoundWaitBarrier(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundCreateCondVar(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (void *)csoundCreateCondVar();
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundCondWait(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  void *arg1 = 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  csoundCondWait(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundCondSignal(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  void *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  csoundCondSignal(arg1);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundDestroyCondVar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  void *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  csoundDestroyCondVar(arg1);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSleep(JNIEnv *jenv, jclass jcls, jint jarg1) {
  size_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (size_t)jarg1; 
  csoundSleep(SWIG_STD_MOVE(arg1));
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundSpinLockInit(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  spin_lock_t *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spin_lock_t **)&jarg1; 
  result = (int)csoundSpinLockInit(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSpinLock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spin_lock_t *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spin_lock_t **)&jarg1; 
  csoundSpinLock(arg1);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundSpinTryLock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  spin_lock_t *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spin_lock_t **)&jarg1; 
  result = (int)csoundSpinTryLock(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSpinUnLock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spin_lock_t *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spin_lock_t **)&jarg1; 
  csoundSpinUnLock(arg1);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundRunCommand(JNIEnv *jenv, jclass jcls, jobjectArray jarg1, jint jarg2) {
  jint jresult = 0 ;
  char **arg1 = 0 ;
  int arg2 ;
  jint size1 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  {
    int i = 0;
    if (jarg1) {
      size1 = jenv->GetArrayLength(jarg1);
      
      arg1 = new char*[size1+1];
      
      
      
      for (i = 0; i<size1; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg1, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg1[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg1[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg1[i] = 0;
    } else {
      arg1 = 0;
      size1 = 0;
    }
  }
  arg2 = (int)jarg2; 
  result = (long)csoundRunCommand((char const *const *)arg1,arg2);
  jresult = (jint)result; 
  {
    int i;
    for (i=0; i<size1; i++)
    
    delete[] arg1[i];
    delete[] arg1;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundInitTimerStruct(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  RTCLOCK *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RTCLOCK **)&jarg1; 
  csoundInitTimerStruct(arg1);
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csoundGetRealTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  RTCLOCK *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RTCLOCK **)&jarg1; 
  result = (double)csoundGetRealTime(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csoundGetCPUTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  RTCLOCK *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RTCLOCK **)&jarg1; 
  result = (double)csoundGetCPUTime(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetRandomSeedFromTime(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)csoundGetRandomSeedFromTime();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSetLanguage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  cslanguage_t arg1 ;
  cslanguage_t *argp1 ;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(cslanguage_t **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null cslanguage_t");
    return ;
  }
  arg1 = *argp1; 
  csoundSetLanguage(SWIG_STD_MOVE(arg1));
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_csoundGetEnv(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)csoundGetEnv(arg1,(char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundSetGlobalEnv(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jint jresult = 0 ;
  char *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)csoundSetGlobalEnv((char const *)arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundCreateGlobalVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  size_t arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (int)csoundCreateGlobalVariable(arg1,(char const *)arg2,SWIG_STD_MOVE(arg3));
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundQueryGlobalVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (void *)csoundQueryGlobalVariable(arg1,(char const *)arg2);
  *(void **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundQueryGlobalVariableNoCheck(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (void *)csoundQueryGlobalVariableNoCheck(arg1,(char const *)arg2);
  *(void **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundDestroyGlobalVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)csoundDestroyGlobalVariable(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundRunUtility(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jobjectArray jarg4) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int arg3 ;
  char **arg4 = 0 ;
  jint size4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  {
    int i = 0;
    if (jarg4) {
      size4 = jenv->GetArrayLength(jarg4);
      
      arg4 = new char*[size4+1];
      
      
      
      for (i = 0; i<size4; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg4, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg4[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg4[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg4[i] = 0;
    } else {
      arg4 = 0;
      size4 = 0;
    }
  }
  result = (int)csoundRunUtility(arg1,(char const *)arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  {
    int i;
    for (i=0; i<size4; i++)
    
    delete[] arg4[i];
    delete[] arg4;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundListUtilities(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (char **)csoundListUtilities(arg1);
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundDeleteUtilityList(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  CSOUND *arg1 = 0 ;
  char **arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(char ***)&jarg2; 
  csoundDeleteUtilityList(arg1,arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_csoundGetUtilityDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)csoundGetUtilityDescription(arg1,(char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundRand31(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  int *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  result = (int)csoundRand31(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundSeedRandMT(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  CsoundRandMTState *arg1 = 0 ;
  uint32_t *arg2 = 0 ;
  uint32_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundRandMTState **)&jarg1; 
  arg2 = *(uint32_t **)&jarg2; 
  arg3 = (uint32_t)jarg3; 
  csoundSeedRandMT(arg1,(unsigned int const *)arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundRandMT(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CsoundRandMTState *arg1 = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundRandMTState **)&jarg1; 
  result = (uint32_t)csoundRandMT(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableHead_1t_1nxt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  csCfgVariableHead_s *arg1 = 0 ;
  csCfgVariable_u *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  arg2 = *(csCfgVariable_u **)&jarg2; 
  if (arg1) (arg1)->nxt = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableHead_1t_1nxt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableHead_s *arg1 = 0 ;
  csCfgVariable_u *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  result = (csCfgVariable_u *) ((arg1)->nxt);
  *(csCfgVariable_u **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableHead_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableHead_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->name = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableHead_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableHead_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->name);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableHead_1t_1p_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableHead_s *arg1 = 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->p = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableHead_1t_1p_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableHead_s *arg1 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  result = (void *) ((arg1)->p);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableHead_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableHead_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableHead_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableHead_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  result = (int) ((arg1)->type);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableHead_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableHead_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableHead_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableHead_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  result = (int) ((arg1)->flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableHead_1t_1shortDesc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableHead_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->shortDesc = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableHead_1t_1shortDesc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableHead_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->shortDesc);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableHead_1t_1longDesc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableHead_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->longDesc = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableHead_1t_1longDesc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableHead_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->longDesc);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1csCfgVariableHead_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  csCfgVariableHead_s *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (csCfgVariableHead_s *)new csCfgVariableHead_s();
  *(csCfgVariableHead_s **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1csCfgVariableHead_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  csCfgVariableHead_s *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(csCfgVariableHead_s **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1nxt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  csCfgVariableInt_s *arg1 = 0 ;
  csCfgVariable_u *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  arg2 = *(csCfgVariable_u **)&jarg2; 
  if (arg1) (arg1)->nxt = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1nxt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableInt_s *arg1 = 0 ;
  csCfgVariable_u *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  result = (csCfgVariable_u *) ((arg1)->nxt);
  *(csCfgVariable_u **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableInt_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->name = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableInt_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->name);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1p_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableInt_s *arg1 = 0 ;
  int *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  arg2 = *(int **)&jarg2; 
  if (arg1) (arg1)->p = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1p_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableInt_s *arg1 = 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  result = (int *) ((arg1)->p);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableInt_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableInt_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  result = (int) ((arg1)->type);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableInt_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableInt_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  result = (int) ((arg1)->flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1shortDesc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableInt_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->shortDesc = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1shortDesc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableInt_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->shortDesc);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1longDesc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableInt_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->longDesc = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1longDesc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableInt_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->longDesc);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1min_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableInt_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->min = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1min_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableInt_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  result = (int) ((arg1)->min);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1max_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableInt_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->max = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableInt_1t_1max_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableInt_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  result = (int) ((arg1)->max);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1csCfgVariableInt_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  csCfgVariableInt_s *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (csCfgVariableInt_s *)new csCfgVariableInt_s();
  *(csCfgVariableInt_s **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1csCfgVariableInt_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  csCfgVariableInt_s *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(csCfgVariableInt_s **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableBoolean_1t_1nxt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  csCfgVariableBoolean_s *arg1 = 0 ;
  csCfgVariable_u *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  arg2 = *(csCfgVariable_u **)&jarg2; 
  if (arg1) (arg1)->nxt = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableBoolean_1t_1nxt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableBoolean_s *arg1 = 0 ;
  csCfgVariable_u *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  result = (csCfgVariable_u *) ((arg1)->nxt);
  *(csCfgVariable_u **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableBoolean_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableBoolean_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->name = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableBoolean_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableBoolean_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->name);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableBoolean_1t_1p_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableBoolean_s *arg1 = 0 ;
  int *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  arg2 = *(int **)&jarg2; 
  if (arg1) (arg1)->p = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableBoolean_1t_1p_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableBoolean_s *arg1 = 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  result = (int *) ((arg1)->p);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableBoolean_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableBoolean_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableBoolean_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableBoolean_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  result = (int) ((arg1)->type);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableBoolean_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableBoolean_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableBoolean_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableBoolean_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  result = (int) ((arg1)->flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableBoolean_1t_1shortDesc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableBoolean_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->shortDesc = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableBoolean_1t_1shortDesc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableBoolean_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->shortDesc);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableBoolean_1t_1longDesc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableBoolean_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->longDesc = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableBoolean_1t_1longDesc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableBoolean_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->longDesc);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1csCfgVariableBoolean_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  csCfgVariableBoolean_s *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (csCfgVariableBoolean_s *)new csCfgVariableBoolean_s();
  *(csCfgVariableBoolean_s **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1csCfgVariableBoolean_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  csCfgVariableBoolean_s *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(csCfgVariableBoolean_s **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1nxt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  csCfgVariableFloat_s *arg1 = 0 ;
  csCfgVariable_u *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  arg2 = *(csCfgVariable_u **)&jarg2; 
  if (arg1) (arg1)->nxt = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1nxt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableFloat_s *arg1 = 0 ;
  csCfgVariable_u *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  result = (csCfgVariable_u *) ((arg1)->nxt);
  *(csCfgVariable_u **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableFloat_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->name = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableFloat_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->name);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1p_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableFloat_s *arg1 = 0 ;
  float *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  arg2 = *(float **)&jarg2; 
  if (arg1) (arg1)->p = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1p_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableFloat_s *arg1 = 0 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  result = (float *) ((arg1)->p);
  *(float **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableFloat_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableFloat_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  result = (int) ((arg1)->type);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableFloat_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableFloat_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  result = (int) ((arg1)->flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1shortDesc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableFloat_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->shortDesc = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1shortDesc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableFloat_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->shortDesc);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1longDesc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableFloat_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->longDesc = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1longDesc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableFloat_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->longDesc);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1min_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  csCfgVariableFloat_s *arg1 = 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->min = arg2;
}


SWIGEXPORT jfloat JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1min_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  csCfgVariableFloat_s *arg1 = 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  result = (float) ((arg1)->min);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1max_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  csCfgVariableFloat_s *arg1 = 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->max = arg2;
}


SWIGEXPORT jfloat JNICALL Java_csnd6_csnd6JNI_csCfgVariableFloat_1t_1max_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  csCfgVariableFloat_s *arg1 = 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  result = (float) ((arg1)->max);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1csCfgVariableFloat_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  csCfgVariableFloat_s *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (csCfgVariableFloat_s *)new csCfgVariableFloat_s();
  *(csCfgVariableFloat_s **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1csCfgVariableFloat_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  csCfgVariableFloat_s *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(csCfgVariableFloat_s **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1nxt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  csCfgVariableDouble_s *arg1 = 0 ;
  csCfgVariable_u *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  arg2 = *(csCfgVariable_u **)&jarg2; 
  if (arg1) (arg1)->nxt = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1nxt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableDouble_s *arg1 = 0 ;
  csCfgVariable_u *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  result = (csCfgVariable_u *) ((arg1)->nxt);
  *(csCfgVariable_u **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableDouble_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->name = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableDouble_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->name);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1p_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableDouble_s *arg1 = 0 ;
  double *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  arg2 = *(double **)&jarg2; 
  if (arg1) (arg1)->p = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1p_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableDouble_s *arg1 = 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  result = (double *) ((arg1)->p);
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableDouble_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableDouble_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  result = (int) ((arg1)->type);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableDouble_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableDouble_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  result = (int) ((arg1)->flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1shortDesc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableDouble_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->shortDesc = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1shortDesc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableDouble_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->shortDesc);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1longDesc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableDouble_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->longDesc = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1longDesc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableDouble_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->longDesc);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1min_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  csCfgVariableDouble_s *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->min = arg2;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1min_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  csCfgVariableDouble_s *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  result = (double) ((arg1)->min);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1max_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  csCfgVariableDouble_s *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->max = arg2;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csCfgVariableDouble_1t_1max_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  csCfgVariableDouble_s *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  result = (double) ((arg1)->max);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1csCfgVariableDouble_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  csCfgVariableDouble_s *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (csCfgVariableDouble_s *)new csCfgVariableDouble_s();
  *(csCfgVariableDouble_s **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1csCfgVariableDouble_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  csCfgVariableDouble_s *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(csCfgVariableDouble_s **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1nxt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  csCfgVariableMYFLT_s *arg1 = 0 ;
  csCfgVariable_u *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  arg2 = *(csCfgVariable_u **)&jarg2; 
  if (arg1) (arg1)->nxt = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1nxt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableMYFLT_s *arg1 = 0 ;
  csCfgVariable_u *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  result = (csCfgVariable_u *) ((arg1)->nxt);
  *(csCfgVariable_u **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableMYFLT_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->name = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableMYFLT_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->name);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1p_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableMYFLT_s *arg1 = 0 ;
  double *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  arg2 = *(double **)&jarg2; 
  if (arg1) (arg1)->p = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1p_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableMYFLT_s *arg1 = 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  result = (double *) ((arg1)->p);
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableMYFLT_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableMYFLT_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  result = (int) ((arg1)->type);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableMYFLT_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableMYFLT_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  result = (int) ((arg1)->flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1shortDesc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableMYFLT_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->shortDesc = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1shortDesc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableMYFLT_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->shortDesc);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1longDesc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableMYFLT_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->longDesc = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1longDesc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableMYFLT_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->longDesc);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1min_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  csCfgVariableMYFLT_s *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->min = arg2;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1min_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  csCfgVariableMYFLT_s *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  result = (double) ((arg1)->min);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1max_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  csCfgVariableMYFLT_s *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->max = arg2;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_csCfgVariableMYFLT_1t_1max_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  csCfgVariableMYFLT_s *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  result = (double) ((arg1)->max);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1csCfgVariableMYFLT_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  csCfgVariableMYFLT_s *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (csCfgVariableMYFLT_s *)new csCfgVariableMYFLT_s();
  *(csCfgVariableMYFLT_s **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1csCfgVariableMYFLT_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  csCfgVariableMYFLT_s *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(csCfgVariableMYFLT_s **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1nxt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  csCfgVariableString_s *arg1 = 0 ;
  csCfgVariable_u *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  arg2 = *(csCfgVariable_u **)&jarg2; 
  if (arg1) (arg1)->nxt = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1nxt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableString_s *arg1 = 0 ;
  csCfgVariable_u *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  result = (csCfgVariable_u *) ((arg1)->nxt);
  *(csCfgVariable_u **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableString_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->name = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableString_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->name);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1p_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  csCfgVariableString_s *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->p;
    if (arg2) {
      arg1->p = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->p, (const char *)arg2);
    } else {
      arg1->p = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1p_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  csCfgVariableString_s *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  result = (char *) ((arg1)->p);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableString_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableString_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  result = (int) ((arg1)->type);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableString_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableString_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  result = (int) ((arg1)->flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1shortDesc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableString_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->shortDesc = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1shortDesc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableString_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->shortDesc);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1longDesc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  csCfgVariableString_s *arg1 = 0 ;
  unsigned char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  if (arg1) (arg1)->longDesc = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1longDesc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariableString_s *arg1 = 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  result = (unsigned char *) ((arg1)->longDesc);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1maxlen_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csCfgVariableString_s *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->maxlen = arg2;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csCfgVariableString_1t_1maxlen_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csCfgVariableString_s *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  result = (int) ((arg1)->maxlen);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1csCfgVariableString_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  csCfgVariableString_s *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (csCfgVariableString_s *)new csCfgVariableString_s();
  *(csCfgVariableString_s **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1csCfgVariableString_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  csCfgVariableString_s *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(csCfgVariableString_s **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariable_1t_1h_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  csCfgVariable_u *arg1 = 0 ;
  csCfgVariableHead_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  arg2 = *(csCfgVariableHead_t **)&jarg2; 
  if (arg1) (arg1)->h = *arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariable_1t_1h_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariable_u *arg1 = 0 ;
  csCfgVariableHead_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  result = (csCfgVariableHead_t *)& ((arg1)->h);
  *(csCfgVariableHead_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariable_1t_1i_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  csCfgVariable_u *arg1 = 0 ;
  csCfgVariableInt_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  arg2 = *(csCfgVariableInt_t **)&jarg2; 
  if (arg1) (arg1)->i = *arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariable_1t_1i_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariable_u *arg1 = 0 ;
  csCfgVariableInt_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  result = (csCfgVariableInt_t *)& ((arg1)->i);
  *(csCfgVariableInt_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariable_1t_1b_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  csCfgVariable_u *arg1 = 0 ;
  csCfgVariableBoolean_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  arg2 = *(csCfgVariableBoolean_t **)&jarg2; 
  if (arg1) (arg1)->b = *arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariable_1t_1b_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariable_u *arg1 = 0 ;
  csCfgVariableBoolean_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  result = (csCfgVariableBoolean_t *)& ((arg1)->b);
  *(csCfgVariableBoolean_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariable_1t_1f_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  csCfgVariable_u *arg1 = 0 ;
  csCfgVariableFloat_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  arg2 = *(csCfgVariableFloat_t **)&jarg2; 
  if (arg1) (arg1)->f = *arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariable_1t_1f_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariable_u *arg1 = 0 ;
  csCfgVariableFloat_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  result = (csCfgVariableFloat_t *)& ((arg1)->f);
  *(csCfgVariableFloat_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariable_1t_1d_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  csCfgVariable_u *arg1 = 0 ;
  csCfgVariableDouble_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  arg2 = *(csCfgVariableDouble_t **)&jarg2; 
  if (arg1) (arg1)->d = *arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariable_1t_1d_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariable_u *arg1 = 0 ;
  csCfgVariableDouble_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  result = (csCfgVariableDouble_t *)& ((arg1)->d);
  *(csCfgVariableDouble_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariable_1t_1m_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  csCfgVariable_u *arg1 = 0 ;
  csCfgVariableMYFLT_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  arg2 = *(csCfgVariableMYFLT_t **)&jarg2; 
  if (arg1) (arg1)->m = *arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariable_1t_1m_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariable_u *arg1 = 0 ;
  csCfgVariableMYFLT_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  result = (csCfgVariableMYFLT_t *)& ((arg1)->m);
  *(csCfgVariableMYFLT_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csCfgVariable_1t_1s_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  csCfgVariable_u *arg1 = 0 ;
  csCfgVariableString_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  arg2 = *(csCfgVariableString_t **)&jarg2; 
  if (arg1) (arg1)->s = *arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csCfgVariable_1t_1s_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  csCfgVariable_u *arg1 = 0 ;
  csCfgVariableString_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  result = (csCfgVariableString_t *)& ((arg1)->s);
  *(csCfgVariableString_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1csCfgVariable_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  csCfgVariable_u *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (csCfgVariable_u *)new csCfgVariable_u();
  *(csCfgVariable_u **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1csCfgVariable_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  csCfgVariable_u *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(csCfgVariable_u **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1INTEGER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1BOOLEAN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1FLOAT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1DOUBLE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1MYFLT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1STRING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(6);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1POWOFTWO_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0x00000001);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1SUCCESS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1INVALID_1NAME_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(-1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1INVALID_1TYPE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(-2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1INVALID_1FLAG_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(-3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1NULL_1POINTER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(-4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1TOO_1HIGH_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(-5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1TOO_1LOW_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(-6);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1NOT_1POWOFTWO_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(-7);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1INVALID_1BOOLEAN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(-8);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1MEMORY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(-9);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1STRING_1LENGTH_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(-10);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDCFG_1LASTERROR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(-10);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundCreateConfigurationVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jint jarg4, jint jarg5, jlong jarg6, jlong jarg7, jstring jarg8, jstring jarg9) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  void *arg3 = 0 ;
  int arg4 ;
  int arg5 ;
  void *arg6 = 0 ;
  void *arg7 = 0 ;
  char *arg8 = 0 ;
  char *arg9 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(void **)&jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = *(void **)&jarg6; 
  arg7 = *(void **)&jarg7; 
  arg8 = 0;
  if (jarg8) {
    arg8 = (char *)jenv->GetStringUTFChars(jarg8, 0);
    if (!arg8) return 0;
  }
  arg9 = 0;
  if (jarg9) {
    arg9 = (char *)jenv->GetStringUTFChars(jarg9, 0);
    if (!arg9) return 0;
  }
  result = (int)csoundCreateConfigurationVariable(arg1,(char const *)arg2,arg3,arg4,arg5,arg6,arg7,(char const *)arg8,(char const *)arg9);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg8) jenv->ReleaseStringUTFChars(jarg8, (const char *)arg8);
  if (arg9) jenv->ReleaseStringUTFChars(jarg9, (const char *)arg9);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundSetConfigurationVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  void *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(void **)&jarg3; 
  result = (int)csoundSetConfigurationVariable(arg1,(char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundParseConfigurationVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)csoundParseConfigurationVariable(arg1,(char const *)arg2,(char const *)arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundQueryConfigurationVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  csCfgVariable_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (csCfgVariable_t *)csoundQueryConfigurationVariable(arg1,(char const *)arg2);
  *(csCfgVariable_t **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundListConfigurationVariables(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  csCfgVariable_t **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (csCfgVariable_t **)csoundListConfigurationVariables(arg1);
  *(csCfgVariable_t ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundDeleteCfgVarList(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  CSOUND *arg1 = 0 ;
  csCfgVariable_t **arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(csCfgVariable_t ***)&jarg2; 
  csoundDeleteCfgVarList(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundDeleteConfigurationVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)csoundDeleteConfigurationVariable(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_csoundCfgErrorCodeToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  int arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (char *)csoundCfgErrorCodeToString(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1DEFAULT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0000));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1ERROR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x1000));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1ORCH_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x2000));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1REALTIME_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x3000));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1WARNING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x4000));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1STDOUT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x5000));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1FG_1BLACK_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0100));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1FG_1RED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0101));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1FG_1GREEN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0102));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1FG_1YELLOW_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0103));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1FG_1BLUE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0104));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1FG_1MAGENTA_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0105));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1FG_1CYAN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0106));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1FG_1WHITE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0107));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1FG_1BOLD_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0008));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1FG_1UNDERLINE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0080));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1BG_1BLACK_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0200));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1BG_1RED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0210));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1BG_1GREEN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0220));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1BG_1ORANGE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0230));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1BG_1BLUE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0240));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1BG_1MAGENTA_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0250));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1BG_1CYAN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0260));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1BG_1GREY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0270));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1TYPE_1MASK_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x7000));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1FG_1COLOR_1MASK_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0107));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1FG_1ATTR_1MASK_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0088));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CSOUNDMSG_1BG_1COLOR_1MASK_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0x0270));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_VERSION_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)("6.18");
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CS_1PACKAGE_1NAME_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)("Csound");
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CS_1PACKAGE_1STRING_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)("Csound 6.18");
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CS_1PACKAGE_1TARNAME_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)("csound");
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CS_1PACKAGE_1VERSION_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)("6.18");
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CS_1VERSION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((6));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CS_1SUBVER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((18));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CS_1PATCHLEVEL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((1));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CS_1APIVERSION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CS_1APISUBVER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundCreateCircularBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (void *)csoundCreateCircularBuffer(arg1,arg2,arg3);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundReadCircularBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  void *arg2 = 0 ;
  void *arg3 = 0 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = *(void **)&jarg3; 
  arg4 = (int)jarg4; 
  result = (int)csoundReadCircularBuffer(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundPeekCircularBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  void *arg2 = 0 ;
  void *arg3 = 0 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = *(void **)&jarg3; 
  arg4 = (int)jarg4; 
  result = (int)csoundPeekCircularBuffer(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundWriteCircularBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
  jint jresult = 0 ;
  CSOUND *arg1 = 0 ;
  void *arg2 = 0 ;
  void *arg3 = 0 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = *(void **)&jarg3; 
  arg4 = (int)jarg4; 
  result = (int)csoundWriteCircularBuffer(arg1,arg2,(void const *)arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundFlushCircularBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  CSOUND *arg1 = 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  csoundFlushCircularBuffer(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_csoundDestroyCircularBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  CSOUND *arg1 = 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  csoundDestroyCircularBuffer(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundOpenLibrary(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  void **arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void ***)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)csoundOpenLibrary(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_csoundCloseLibrary(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  void *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  result = (int)csoundCloseLibrary(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_csoundGetLibrarySymbol(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  void *arg1 = 0 ;
  char *arg2 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (void *)csoundGetLibrarySymbol(arg1,(char const *)arg2);
  *(void **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1pydata_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Csound *arg1 = 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->pydata = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_Csound_1pydata_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (void *) ((arg1)->pydata);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_Csound_1GetCsound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  CSOUND *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (CSOUND *)(arg1)->GetCsound();
  *(CSOUND **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetCsound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Csound *arg1 = 0 ;
  CSOUND *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(CSOUND **)&jarg2; 
  (arg1)->SetCsound(arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1InitializeCscore(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  FILE *arg2 = 0 ;
  FILE *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(FILE **)&jarg2; 
  arg3 = *(FILE **)&jarg3; 
  result = (int)(arg1)->InitializeCscore(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1LoadPlugins(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->LoadPlugins((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->GetVersion();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetAPIVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->GetAPIVersion();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_Csound_1GetEnv(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)(arg1)->GetEnv((char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1SetGlobalEnv(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)(arg1)->SetGlobalEnv((char const *)arg2,(char const *)arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1SetOption(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->SetOption((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetParams(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Csound *arg1 = 0 ;
  CSOUND_PARAMS *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(CSOUND_PARAMS **)&jarg2; 
  (arg1)->SetParams(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1GetParams(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Csound *arg1 = 0 ;
  CSOUND_PARAMS *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(CSOUND_PARAMS **)&jarg2; 
  (arg1)->GetParams(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetOutput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  char *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return ;
  }
  (arg1)->SetOutput((char const *)arg2,(char const *)arg3,(char const *)arg4);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetInput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetInput((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetMIDIInput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetMIDIInput((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetMIDIFileInput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetMIDIFileInput((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetMIDIOutput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetMIDIOutput((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetMIDIFileOutput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetMIDIFileOutput((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_Csound_1ParseOrc(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  TREE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (TREE *)(arg1)->ParseOrc((char const *)arg2);
  *(TREE **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1CompileTree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  TREE *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(TREE **)&jarg2; 
  result = (int)(arg1)->CompileTree(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1DeleteTree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Csound *arg1 = 0 ;
  TREE *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(TREE **)&jarg2; 
  (arg1)->DeleteTree(arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1CompileOrc(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->CompileOrc((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Csound_1EvalCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jdouble jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (double)(arg1)->EvalCode((char const *)arg2);
  jresult = (jdouble)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1ReadScore(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->ReadScore((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1CompileArgs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobjectArray jarg3) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int arg2 ;
  char **arg3 = 0 ;
  jint size3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    int i = 0;
    if (jarg3) {
      size3 = jenv->GetArrayLength(jarg3);
      
      arg3 = new char*[size3+1];
      
      
      
      for (i = 0; i<size3; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg3, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg3[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg3[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg3[i] = 0;
    } else {
      arg3 = 0;
      size3 = 0;
    }
  }
  result = (int)(arg1)->CompileArgs(arg2,(char const **)arg3);
  jresult = (jint)result; 
  {
    int i;
    for (i=0; i<size3; i++)
    
    delete[] arg3[i];
    delete[] arg3;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Compile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobjectArray jarg3) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int arg2 ;
  char **arg3 = 0 ;
  jint size3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    int i = 0;
    if (jarg3) {
      size3 = jenv->GetArrayLength(jarg3);
      
      arg3 = new char*[size3+1];
      
      
      
      for (i = 0; i<size3; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg3, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg3[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg3[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg3[i] = 0;
    } else {
      arg3 = 0;
      size3 = 0;
    }
  }
  result = (int)(arg1)->Compile(arg2,(char const **)arg3);
  jresult = (jint)result; 
  {
    int i;
    for (i=0; i<size3; i++)
    
    delete[] arg3[i];
    delete[] arg3;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Compile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->Compile((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Compile_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)(arg1)->Compile((char const *)arg2,(char const *)arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Compile_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  char *arg4 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (int)(arg1)->Compile((char const *)arg2,(char const *)arg3,(char const *)arg4);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Compile_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  char *arg4 = 0 ;
  char *arg5 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  result = (int)(arg1)->Compile((char const *)arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Compile_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  char *arg4 = 0 ;
  char *arg5 = 0 ;
  char *arg6 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)jenv->GetStringUTFChars(jarg6, 0);
    if (!arg6) return 0;
  }
  result = (int)(arg1)->Compile((char const *)arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5,(char const *)arg6);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  if (arg6) jenv->ReleaseStringUTFChars(jarg6, (const char *)arg6);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1CompileCsd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->CompileCsd((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1CompileCsdText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->CompileCsdText((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Start(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->Start();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Perform_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->Perform();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Perform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobjectArray jarg3) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int arg2 ;
  char **arg3 = 0 ;
  jint size3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    int i = 0;
    if (jarg3) {
      size3 = jenv->GetArrayLength(jarg3);
      
      arg3 = new char*[size3+1];
      
      
      
      for (i = 0; i<size3; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg3, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg3[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg3[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg3[i] = 0;
    } else {
      arg3 = 0;
      size3 = 0;
    }
  }
  result = (int)(arg1)->Perform(arg2,(char const **)arg3);
  jresult = (jint)result; 
  {
    int i;
    for (i=0; i<size3; i++)
    
    delete[] arg3[i];
    delete[] arg3;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Perform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->Perform((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Perform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)(arg1)->Perform((char const *)arg2,(char const *)arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Perform_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  char *arg4 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (int)(arg1)->Perform((char const *)arg2,(char const *)arg3,(char const *)arg4);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Perform_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  char *arg4 = 0 ;
  char *arg5 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  result = (int)(arg1)->Perform((char const *)arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Perform_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  char *arg4 = 0 ;
  char *arg5 = 0 ;
  char *arg6 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)jenv->GetStringUTFChars(jarg6, 0);
    if (!arg6) return 0;
  }
  result = (int)(arg1)->Perform((char const *)arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5,(char const *)arg6);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  if (arg6) jenv->ReleaseStringUTFChars(jarg6, (const char *)arg6);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1PerformKsmps(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->PerformKsmps();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1PerformBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->PerformBuffer();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1Stop(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Csound *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  (arg1)->Stop();
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1Cleanup(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->Cleanup();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1Reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Csound *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  (arg1)->Reset();
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Csound_1GetSr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Csound *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (double)(arg1)->GetSr();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Csound_1GetKr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Csound *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (double)(arg1)->GetKr();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetKsmps(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->GetKsmps();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetNchnls(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->GetNchnls();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetNchnlsInput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->GetNchnlsInput();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Csound_1Get0dBFS(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Csound *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (double)(arg1)->Get0dBFS();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetInputBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (long)(arg1)->GetInputBufferSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetOutputBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (long)(arg1)->GetOutputBufferSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_Csound_1GetInputBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (double *)(arg1)->GetInputBuffer();
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_Csound_1GetOutputBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (double *)(arg1)->GetOutputBuffer();
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_Csound_1GetSpin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (double *)(arg1)->GetSpin();
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_Csound_1GetSpout(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (double *)(arg1)->GetSpout();
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_Csound_1GetOutputName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Csound *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (char *)(arg1)->GetOutputName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetCurrentTimeSamples(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (long)(arg1)->GetCurrentTimeSamples();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetHostImplementedAudioIO(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  Csound *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->SetHostImplementedAudioIO(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetHostImplementedMIDIIO(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Csound *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->SetHostImplementedMIDIIO(arg2);
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Csound_1GetScoreTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Csound *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (double)(arg1)->GetScoreTime();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1IsScorePending(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->IsScorePending();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetScorePending(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Csound *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->SetScorePending(arg2);
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Csound_1GetScoreOffsetSeconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Csound *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (double)(arg1)->GetScoreOffsetSeconds();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetScoreOffsetSeconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Csound *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (double)jarg2; 
  (arg1)->SetScoreOffsetSeconds(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1RewindScore(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Csound *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  (arg1)->RewindScore();
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1ScoreSort(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  FILE *arg2 = 0 ;
  FILE *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(FILE **)&jarg2; 
  arg3 = *(FILE **)&jarg3; 
  result = (int)(arg1)->ScoreSort(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1ScoreExtract(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  FILE *arg2 = 0 ;
  FILE *arg3 = 0 ;
  FILE *arg4 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(FILE **)&jarg2; 
  arg3 = *(FILE **)&jarg3; 
  arg4 = *(FILE **)&jarg4; 
  result = (int)(arg1)->ScoreExtract(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1Message(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  void *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->Message((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1MessageS(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  Csound *arg1 = 0 ;
  int arg2 ;
  char *arg3 = 0 ;
  void *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  (arg1)->MessageS(arg2,(char const *)arg3,arg4);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetMessageCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Csound *arg1 = 0 ;
  void (*arg2)(CSOUND *,int,char const *,va_list) = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(void (**)(CSOUND *,int,char const *,va_list))&jarg2; 
  (arg1)->SetMessageCallback(arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetMessageLevel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->GetMessageLevel();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetMessageLevel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Csound *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->SetMessageLevel(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1InputMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->InputMessage((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1KeyPressed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  Csound *arg1 = 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (char)jarg2; 
  (arg1)->KeyPressed(arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1ScoreEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2, jlong jarg3, jint jarg4) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char arg2 ;
  double *arg3 = 0 ;
  long arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (char)jarg2; 
  arg3 = *(double **)&jarg3; 
  arg4 = (long)jarg4; 
  result = (int)(arg1)->ScoreEvent(arg2,(double const *)arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1ScoreEventAbsolute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2, jlong jarg3, jint jarg4, jdouble jarg5) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char arg2 ;
  double *arg3 = 0 ;
  long arg4 ;
  double arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (char)jarg2; 
  arg3 = *(double **)&jarg3; 
  arg4 = (long)jarg4; 
  arg5 = (double)jarg5; 
  result = (int)(arg1)->ScoreEventAbsolute(arg2,(double const *)arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetExternalMidiInOpenCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Csound *arg1 = 0 ;
  int (*arg2)(CSOUND *,void **,char const *) = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(int (**)(CSOUND *,void **,char const *))&jarg2; 
  (arg1)->SetExternalMidiInOpenCallback(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetExternalMidiReadCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Csound *arg1 = 0 ;
  int (*arg2)(CSOUND *,void *,unsigned char *,int) = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(int (**)(CSOUND *,void *,unsigned char *,int))&jarg2; 
  (arg1)->SetExternalMidiReadCallback(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetExternalMidiInCloseCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Csound *arg1 = 0 ;
  int (*arg2)(CSOUND *,void *) = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(int (**)(CSOUND *,void *))&jarg2; 
  (arg1)->SetExternalMidiInCloseCallback(arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1NewOpcodeList(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  opcodeListEntry **arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(opcodeListEntry ***)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "opcodeListEntry *& is null");
    return 0;
  } 
  result = (int)(arg1)->NewOpcodeList(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1DisposeOpcodeList(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Csound *arg1 = 0 ;
  opcodeListEntry *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(opcodeListEntry **)&jarg2; 
  (arg1)->DisposeOpcodeList(arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1AppendOpcode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jint jarg4, jint jarg5, jstring jarg6, jstring jarg7, jlong jarg8, jlong jarg9, jlong jarg10) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  char *arg6 = 0 ;
  char *arg7 = 0 ;
  int (*arg8)(CSOUND *,void *) = 0 ;
  int (*arg9)(CSOUND *,void *) = 0 ;
  int (*arg10)(CSOUND *,void *) = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)jenv->GetStringUTFChars(jarg6, 0);
    if (!arg6) return 0;
  }
  arg7 = 0;
  if (jarg7) {
    arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
    if (!arg7) return 0;
  }
  arg8 = *(int (**)(CSOUND *,void *))&jarg8; 
  arg9 = *(int (**)(CSOUND *,void *))&jarg9; 
  arg10 = *(int (**)(CSOUND *,void *))&jarg10; 
  result = (int)(arg1)->AppendOpcode((char const *)arg2,arg3,arg4,arg5,(char const *)arg6,(char const *)arg7,arg8,arg9,arg10);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg6) jenv->ReleaseStringUTFChars(jarg6, (const char *)arg6);
  if (arg7) jenv->ReleaseStringUTFChars(jarg7, (const char *)arg7);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetDebug(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->GetDebug();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetDebug(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Csound *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->SetDebug(arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1TableLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)(arg1)->TableLength(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Csound_1TableGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jdouble jresult = 0 ;
  Csound *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (double)(arg1)->TableGet(arg2,arg3);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1TableSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jdouble jarg4) {
  Csound *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  (arg1)->TableSet(arg2,arg3,arg4);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetTable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  double **arg2 = 0 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(double ***)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "double *& is null");
    return 0;
  } 
  arg3 = (int)jarg3; 
  result = (int)(arg1)->GetTable(*arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1TableCopyOut(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdoubleArray jarg3) {
  Csound *arg1 = 0 ;
  int arg2 ;
  double *arg3 = 0 ;
  double temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return ;
    }
    if (jenv->GetArrayLength(jarg3) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return ;
    }
    temp3 = (double)0;
    arg3 = &temp3; 
  }
  (arg1)->TableCopyOut(arg2,arg3);
  {
    jdouble jvalue = (jdouble)temp3;
    jenv->SetDoubleArrayRegion(jarg3, 0, 1, &jvalue);
  }
  
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1TableCopyIn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  Csound *arg1 = 0 ;
  int arg2 ;
  double *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double *)&jarg3; 
  (arg1)->TableCopyIn(arg2,arg3);
  
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1CreateGlobalVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  size_t arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (int)(arg1)->CreateGlobalVariable((char const *)arg2,SWIG_STD_MOVE(arg3));
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_Csound_1QueryGlobalVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (void *)(arg1)->QueryGlobalVariable((char const *)arg2);
  *(void **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_Csound_1QueryGlobalVariableNoCheck(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (void *)(arg1)->QueryGlobalVariableNoCheck((char const *)arg2);
  *(void **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1DestroyGlobalVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->DestroyGlobalVariable((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_Csound_1GetRtRecordUserData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  void **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (void **)(arg1)->GetRtRecordUserData();
  *(void ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_Csound_1GetRtPlayUserData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  void **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (void **)(arg1)->GetRtPlayUserData();
  *(void ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1RunUtility(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jobjectArray jarg4) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  int arg3 ;
  char **arg4 = 0 ;
  jint size4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  {
    int i = 0;
    if (jarg4) {
      size4 = jenv->GetArrayLength(jarg4);
      
      arg4 = new char*[size4+1];
      
      
      
      for (i = 0; i<size4; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg4, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg4[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg4[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg4[i] = 0;
    } else {
      arg4 = 0;
      size4 = 0;
    }
  }
  result = (int)(arg1)->RunUtility((char const *)arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  {
    int i;
    for (i=0; i<size4; i++)
    
    delete[] arg4[i];
    delete[] arg4;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_Csound_1ListUtilities(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (char **)(arg1)->ListUtilities();
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1DeleteUtilityList(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Csound *arg1 = 0 ;
  char **arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(char ***)&jarg2; 
  (arg1)->DeleteUtilityList(arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_Csound_1GetUtilityDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)(arg1)->GetUtilityDescription((char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetChannelPtr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jstring jarg3, jint jarg4) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  double **arg2 = 0 ;
  char *arg3 = 0 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(double ***)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "double *& is null");
    return 0;
  } 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  result = (int)(arg1)->GetChannelPtr(*arg2,(char const *)arg3,arg4);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1ListChannels(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  controlChannelInfo_t **arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(controlChannelInfo_t ***)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "controlChannelInfo_t *& is null");
    return 0;
  } 
  result = (int)(arg1)->ListChannels(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1DeleteChannelList(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Csound *arg1 = 0 ;
  controlChannelInfo_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(controlChannelInfo_t **)&jarg2; 
  (arg1)->DeleteChannelList(arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1SetControlChannelHints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  controlChannelHints_t arg3 ;
  controlChannelHints_t *argp3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  argp3 = *(controlChannelHints_t **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null controlChannelHints_t");
    return 0;
  }
  arg3 = *argp3; 
  result = (int)(arg1)->SetControlChannelHints((char const *)arg2,SWIG_STD_MOVE(arg3));
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetControlChannelHints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  controlChannelHints_t *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(controlChannelHints_t **)&jarg3; 
  result = (int)(arg1)->GetControlChannelHints((char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetChannel_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jdouble jarg3) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (double)jarg3; 
  (arg1)->SetChannel((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetControlChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jdouble jarg3) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (double)jarg3; 
  (arg1)->SetControlChannel((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetChannel_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  (arg1)->SetChannel((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetStringChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  (arg1)->SetStringChannel((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetChannel_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  double *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = *(double **)&jarg3; 
  (arg1)->SetChannel((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Csound_1GetChannel_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  int *arg3 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(int **)&jarg3; 
  result = (double)(arg1)->GetChannel((char const *)arg2,arg3);
  jresult = (jdouble)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Csound_1GetChannel_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jdouble jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (double)(arg1)->GetChannel((char const *)arg2);
  jresult = (jdouble)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Csound_1GetControlChannel_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  int *arg3 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(int **)&jarg3; 
  result = (double)(arg1)->GetControlChannel((char const *)arg2,arg3);
  jresult = (jdouble)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Csound_1GetControlChannel_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jdouble jresult = 0 ;
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (double)(arg1)->GetControlChannel((char const *)arg2);
  jresult = (jdouble)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1GetStringChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  char *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  (arg1)->GetStringChannel((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1GetAudioChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  double *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = *(double **)&jarg3; 
  (arg1)->GetAudioChannel((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1PvsinSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  PVSDATEXT *arg2 = 0 ;
  char *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(PVSDATEXT **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)(arg1)->PvsinSet((PVSDATEXT const *)arg2,(char const *)arg3);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1PvsoutGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  PVSDATEXT *arg2 = 0 ;
  char *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(PVSDATEXT **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)(arg1)->PvsoutGet(arg2,(char const *)arg3);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetInputChannelCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Csound *arg1 = 0 ;
  channelCallback_t arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(channelCallback_t *)&jarg2; 
  (arg1)->SetInputChannelCallback(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetOutputChannelCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Csound *arg1 = 0 ;
  channelCallback_t arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = *(channelCallback_t *)&jarg2; 
  (arg1)->SetOutputChannelCallback(arg2);
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1Csound_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Csound *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (Csound *)new Csound();
  *(Csound **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1Csound_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  Csound *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (Csound *)new Csound(arg1);
  *(Csound **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1Csound_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  void *arg1 = 0 ;
  Csound *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  result = (Csound *)new Csound(arg1);
  *(Csound **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1Csound(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Csound *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Csound **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1CreateMessageBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Csound *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->CreateMessageBuffer(arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_Csound_1GetFirstMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Csound *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (char *)(arg1)->GetFirstMessage();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetFirstMessageAttr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->GetFirstMessageAttr();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1PopFirstMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Csound *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  (arg1)->PopFirstMessage();
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Csound_1GetMessageCnt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Csound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (int)(arg1)->GetMessageCnt();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1DestroyMessageBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Csound *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  (arg1)->DestroyMessageBuffer();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1AddSpinSample(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jdouble jarg4) {
  Csound *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  (arg1)->AddSpinSample(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetSpinSample(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jdouble jarg4) {
  Csound *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  (arg1)->SetSpinSample(arg2,arg3,arg4);
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Csound_1GetSpoutSample(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jdouble jresult = 0 ;
  Csound *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (double)((Csound const *)arg1)->GetSpoutSample(arg2,arg3);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_Csound_1GetInputName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Csound *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (char *)(arg1)->GetInputName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Csound_1SetAudioChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Csound *arg1 = 0 ;
  char *arg2 = 0 ;
  double *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = *(double **)&jarg3; 
  (arg1)->SetAudioChannel((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Csound_1SystemSr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  Csound *arg1 = 0 ;
  double arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  arg2 = (double)jarg2; 
  result = (double)(arg1)->SystemSr(arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundThreadLock_1Lock_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  CsoundThreadLock *arg1 = 0 ;
  size_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundThreadLock **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (int)(arg1)->Lock(SWIG_STD_MOVE(arg2));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundThreadLock_1Lock_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundThreadLock *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundThreadLock **)&jarg1; 
  (arg1)->Lock();
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundThreadLock_1TryLock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundThreadLock *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundThreadLock **)&jarg1; 
  result = (int)(arg1)->TryLock();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundThreadLock_1Unlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundThreadLock *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundThreadLock **)&jarg1; 
  (arg1)->Unlock();
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundThreadLock_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CsoundThreadLock *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CsoundThreadLock *)new CsoundThreadLock();
  *(CsoundThreadLock **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundThreadLock_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  CsoundThreadLock *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (CsoundThreadLock *)new CsoundThreadLock(arg1);
  *(CsoundThreadLock **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundThreadLock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundThreadLock *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundThreadLock **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMutex_1Lock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundMutex *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMutex **)&jarg1; 
  (arg1)->Lock();
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundMutex_1TryLock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundMutex *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMutex **)&jarg1; 
  result = (int)(arg1)->TryLock();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMutex_1Unlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundMutex *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMutex **)&jarg1; 
  (arg1)->Unlock();
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundMutex_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CsoundMutex *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CsoundMutex *)new CsoundMutex();
  *(CsoundMutex **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundMutex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  CsoundMutex *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (CsoundMutex *)new CsoundMutex(arg1);
  *(CsoundMutex **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundMutex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundMutex *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundMutex **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CsoundRandMT_1Random(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CsoundRandMT *arg1 = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundRandMT **)&jarg1; 
  result = (uint32_t)(arg1)->Random();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundRandMT_1Seed_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  CsoundRandMT *arg1 = 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundRandMT **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->Seed(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundRandMT_1Seed_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  CsoundRandMT *arg1 = 0 ;
  uint32_t *arg2 = 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundRandMT **)&jarg1; 
  arg2 = *(uint32_t **)&jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->Seed((uint32_t const *)arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundRandMT_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CsoundRandMT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CsoundRandMT *)new CsoundRandMT();
  *(CsoundRandMT **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundRandMT_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  CsoundRandMT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  result = (CsoundRandMT *)new CsoundRandMT(arg1);
  *(CsoundRandMT **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundRandMT_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  uint32_t *arg1 = 0 ;
  int arg2 ;
  CsoundRandMT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uint32_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (CsoundRandMT *)new CsoundRandMT((uint32_t const *)arg1,arg2);
  *(CsoundRandMT **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundRandMT(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundRandMT *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundRandMT **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_CsoundTimer_1GetRealTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  CsoundTimer *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundTimer **)&jarg1; 
  result = (double)(arg1)->GetRealTime();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_CsoundTimer_1GetCPUTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  CsoundTimer *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundTimer **)&jarg1; 
  result = (double)(arg1)->GetCPUTime();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundTimer_1Reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundTimer *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundTimer **)&jarg1; 
  (arg1)->Reset();
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundTimer(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CsoundTimer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CsoundTimer *)new CsoundTimer();
  *(CsoundTimer **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundTimer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundTimer *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundTimer **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundOpcodeList_1Count(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundOpcodeList *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundOpcodeList **)&jarg1; 
  result = (int)(arg1)->Count();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundOpcodeList_1Name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  CsoundOpcodeList *arg1 = 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundOpcodeList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)(arg1)->Name(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundOpcodeList_1OutTypes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  CsoundOpcodeList *arg1 = 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundOpcodeList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)(arg1)->OutTypes(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundOpcodeList_1InTypes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  CsoundOpcodeList *arg1 = 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundOpcodeList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)(arg1)->InTypes(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundOpcodeList_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundOpcodeList *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundOpcodeList **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundOpcodeList_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  CsoundOpcodeList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (CsoundOpcodeList *)new CsoundOpcodeList(arg1);
  *(CsoundOpcodeList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundOpcodeList_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  CsoundOpcodeList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (CsoundOpcodeList *)new CsoundOpcodeList(arg1);
  *(CsoundOpcodeList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundOpcodeList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundOpcodeList *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundOpcodeList **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundChannelList_1Count(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundChannelList *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundChannelList **)&jarg1; 
  result = (int)(arg1)->Count();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundChannelList_1Name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  CsoundChannelList *arg1 = 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundChannelList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)(arg1)->Name(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundChannelList_1Type(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  CsoundChannelList *arg1 = 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundChannelList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)(arg1)->Type(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundChannelList_1IsControlChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  CsoundChannelList *arg1 = 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundChannelList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)(arg1)->IsControlChannel(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundChannelList_1IsAudioChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  CsoundChannelList *arg1 = 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundChannelList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)(arg1)->IsAudioChannel(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundChannelList_1IsStringChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  CsoundChannelList *arg1 = 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundChannelList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)(arg1)->IsStringChannel(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundChannelList_1IsInputChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  CsoundChannelList *arg1 = 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundChannelList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)(arg1)->IsInputChannel(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundChannelList_1IsOutputChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  CsoundChannelList *arg1 = 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundChannelList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)(arg1)->IsOutputChannel(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundChannelList_1SubType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  CsoundChannelList *arg1 = 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundChannelList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)(arg1)->SubType(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_CsoundChannelList_1DefaultValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  CsoundChannelList *arg1 = 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundChannelList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (double)(arg1)->DefaultValue(arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_CsoundChannelList_1MinValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  CsoundChannelList *arg1 = 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundChannelList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (double)(arg1)->MinValue(arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_CsoundChannelList_1MaxValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  CsoundChannelList *arg1 = 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundChannelList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (double)(arg1)->MaxValue(arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundChannelList_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundChannelList *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundChannelList **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundChannelList_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  CsoundChannelList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (CsoundChannelList *)new CsoundChannelList(arg1);
  *(CsoundChannelList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundChannelList_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  CsoundChannelList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (CsoundChannelList *)new CsoundChannelList(arg1);
  *(CsoundChannelList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundChannelList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundChannelList *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundChannelList **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundUtilityList_1Count(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundUtilityList *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundUtilityList **)&jarg1; 
  result = (int)(arg1)->Count();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundUtilityList_1Name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  CsoundUtilityList *arg1 = 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundUtilityList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)(arg1)->Name(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundUtilityList_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundUtilityList *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundUtilityList **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundUtilityList_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  CsoundUtilityList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (CsoundUtilityList *)new CsoundUtilityList(arg1);
  *(CsoundUtilityList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundUtilityList_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  CsoundUtilityList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (CsoundUtilityList *)new CsoundUtilityList(arg1);
  *(CsoundUtilityList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundUtilityList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundUtilityList *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundUtilityList **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1GetPtr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CsoundMYFLTArray *arg1 = 0 ;
  double **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  result = (double **)(arg1)->GetPtr();
  *(double ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1GetPtr_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  CsoundMYFLTArray *arg1 = 0 ;
  int arg2 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (double *)(arg1)->GetPtr(arg2);
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1SetPtr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  CsoundMYFLTArray *arg1 = 0 ;
  double *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = *(double **)&jarg2; 
  (arg1)->SetPtr(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1SetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  CsoundMYFLTArray *arg1 = 0 ;
  int arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  (arg1)->SetValue(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1SetValues_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3, jdouble jarg4) {
  CsoundMYFLTArray *arg1 = 0 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  (arg1)->SetValues(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1SetValues_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
  CsoundMYFLTArray *arg1 = 0 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  (arg1)->SetValues(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1SetValues_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6) {
  CsoundMYFLTArray *arg1 = 0 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  (arg1)->SetValues(arg2,arg3,arg4,arg5,arg6);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1SetValues_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7) {
  CsoundMYFLTArray *arg1 = 0 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  double arg7 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  (arg1)->SetValues(arg2,arg3,arg4,arg5,arg6,arg7);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1SetValues_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8) {
  CsoundMYFLTArray *arg1 = 0 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  double arg7 ;
  double arg8 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  arg8 = (double)jarg8; 
  (arg1)->SetValues(arg2,arg3,arg4,arg5,arg6,arg7,arg8);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1SetValues_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8, jdouble jarg9) {
  CsoundMYFLTArray *arg1 = 0 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  double arg7 ;
  double arg8 ;
  double arg9 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  arg8 = (double)jarg8; 
  arg9 = (double)jarg9; 
  (arg1)->SetValues(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1SetValues_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8, jdouble jarg9, jdouble jarg10) {
  CsoundMYFLTArray *arg1 = 0 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  double arg7 ;
  double arg8 ;
  double arg9 ;
  double arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  arg8 = (double)jarg8; 
  arg9 = (double)jarg9; 
  arg10 = (double)jarg10; 
  (arg1)->SetValues(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1SetValues_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8, jdouble jarg9, jdouble jarg10, jdouble jarg11) {
  CsoundMYFLTArray *arg1 = 0 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  double arg7 ;
  double arg8 ;
  double arg9 ;
  double arg10 ;
  double arg11 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  arg8 = (double)jarg8; 
  arg9 = (double)jarg9; 
  arg10 = (double)jarg10; 
  arg11 = (double)jarg11; 
  (arg1)->SetValues(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1SetValues_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8, jdouble jarg9, jdouble jarg10, jdouble jarg11, jdouble jarg12) {
  CsoundMYFLTArray *arg1 = 0 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  double arg7 ;
  double arg8 ;
  double arg9 ;
  double arg10 ;
  double arg11 ;
  double arg12 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  arg8 = (double)jarg8; 
  arg9 = (double)jarg9; 
  arg10 = (double)jarg10; 
  arg11 = (double)jarg11; 
  arg12 = (double)jarg12; 
  (arg1)->SetValues(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1GetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  CsoundMYFLTArray *arg1 = 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (double)(arg1)->GetValue(arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1SetValues_1_1SWIG_19(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jdouble jarg4) {
  CsoundMYFLTArray *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double *)&jarg4; 
  (arg1)->SetValues(arg2,arg3,(double const *)arg4);
  
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1GetValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4) {
  CsoundMYFLTArray *arg1 = 0 ;
  double *arg2 = 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = *(double **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->GetValues(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1SetStringValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  CsoundMYFLTArray *arg1 = 0 ;
  char *arg2 = 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (int)jarg3; 
  (arg1)->SetStringValue((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1GetStringValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CsoundMYFLTArray *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  result = (char *)(arg1)->GetStringValue();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMYFLTArray_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundMYFLTArray *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundMYFLTArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CsoundMYFLTArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CsoundMYFLTArray *)new CsoundMYFLTArray();
  *(CsoundMYFLTArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundMYFLTArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  CsoundMYFLTArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (CsoundMYFLTArray *)new CsoundMYFLTArray(arg1);
  *(CsoundMYFLTArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundMYFLTArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundMYFLTArray *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundMYFLTArray **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundArgVList_1argc(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundArgVList *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundArgVList **)&jarg1; 
  result = (int)(arg1)->argc();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobjectArray JNICALL Java_csnd6_csnd6JNI_CsoundArgVList_1argv_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobjectArray jresult = 0 ;
  CsoundArgVList *arg1 = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundArgVList **)&jarg1; 
  result = (char **)(arg1)->argv();
  {
    if (result) {
      int i;
      jsize len=0;
      jstring temp_string;
      const jclass clazz = jenv->FindClass("java/lang/String");
      
      while (result[len]) len++;
      jresult = jenv->NewObjectArray(len, clazz, NULL);
      /* exception checking omitted */
      
      for (i=0; i<len; i++) {
        temp_string = jenv->NewStringUTF(*result++);
        jenv->SetObjectArrayElement(jresult, i, temp_string);
        jenv->DeleteLocalRef(temp_string);
      }
    }
  }
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundArgVList_1argv_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  CsoundArgVList *arg1 = 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundArgVList **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)(arg1)->argv(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundArgVList_1Insert(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  CsoundArgVList *arg1 = 0 ;
  int arg2 ;
  char *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundArgVList **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  (arg1)->Insert(arg2,(char const *)arg3);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundArgVList_1Append(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CsoundArgVList *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundArgVList **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->Append((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundArgVList_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundArgVList *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundArgVList **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundArgVList(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CsoundArgVList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CsoundArgVList *)new CsoundArgVList();
  *(CsoundArgVList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundArgVList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundArgVList *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundArgVList **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1MessageCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  CsoundCallbackWrapper *arg1 = 0 ;
  int arg2 ;
  char *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  (arg1)->MessageCallback(arg2,arg3);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1MessageCallbackSwigExplicitCsoundCallbackWrapper(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  CsoundCallbackWrapper *arg1 = 0 ;
  int arg2 ;
  char *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  (arg1)->CsoundCallbackWrapper::MessageCallback(arg2,arg3);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1InputValueCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jdouble jresult = 0 ;
  CsoundCallbackWrapper *arg1 = 0 ;
  char *arg2 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (double)(arg1)->InputValueCallback((char const *)arg2);
  jresult = (jdouble)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1InputValueCallbackSwigExplicitCsoundCallbackWrapper(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jdouble jresult = 0 ;
  CsoundCallbackWrapper *arg1 = 0 ;
  char *arg2 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (double)(arg1)->CsoundCallbackWrapper::InputValueCallback((char const *)arg2);
  jresult = (jdouble)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1OutputValueCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jdouble jarg3) {
  CsoundCallbackWrapper *arg1 = 0 ;
  char *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (double)jarg3; 
  (arg1)->OutputValueCallback((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1OutputValueCallbackSwigExplicitCsoundCallbackWrapper(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jdouble jarg3) {
  CsoundCallbackWrapper *arg1 = 0 ;
  char *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (double)jarg3; 
  (arg1)->CsoundCallbackWrapper::OutputValueCallback((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1YieldCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundCallbackWrapper *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  result = (int)(arg1)->YieldCallback();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1YieldCallbackSwigExplicitCsoundCallbackWrapper(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundCallbackWrapper *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  result = (int)(arg1)->CsoundCallbackWrapper::YieldCallback();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1MidiInputCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  CsoundCallbackWrapper *arg1 = 0 ;
  CsoundMidiInputBuffer *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  arg2 = *(CsoundMidiInputBuffer **)&jarg2; 
  (arg1)->MidiInputCallback(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1MidiInputCallbackSwigExplicitCsoundCallbackWrapper(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  CsoundCallbackWrapper *arg1 = 0 ;
  CsoundMidiInputBuffer *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  arg2 = *(CsoundMidiInputBuffer **)&jarg2; 
  (arg1)->CsoundCallbackWrapper::MidiInputCallback(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1MidiOutputCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  CsoundCallbackWrapper *arg1 = 0 ;
  CsoundMidiOutputBuffer *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  arg2 = *(CsoundMidiOutputBuffer **)&jarg2; 
  (arg1)->MidiOutputCallback(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1MidiOutputCallbackSwigExplicitCsoundCallbackWrapper(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  CsoundCallbackWrapper *arg1 = 0 ;
  CsoundMidiOutputBuffer *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  arg2 = *(CsoundMidiOutputBuffer **)&jarg2; 
  (arg1)->CsoundCallbackWrapper::MidiOutputCallback(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1SetMessageCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundCallbackWrapper *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  (arg1)->SetMessageCallback();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1SetYieldCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundCallbackWrapper *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  (arg1)->SetYieldCallback();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1SetMidiInputCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  CsoundCallbackWrapper *arg1 = 0 ;
  CsoundArgVList *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  arg2 = *(CsoundArgVList **)&jarg2; 
  (arg1)->SetMidiInputCallback(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1SetMidiOutputCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  CsoundCallbackWrapper *arg1 = 0 ;
  CsoundArgVList *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  arg2 = *(CsoundArgVList **)&jarg2; 
  (arg1)->SetMidiOutputCallback(arg2);
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1GetCsound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CsoundCallbackWrapper *arg1 = 0 ;
  CSOUND *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  result = (CSOUND *)(arg1)->GetCsound();
  *(CSOUND **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1CharPtrToString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  char *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (char *)CsoundCallbackWrapper::CharPtrToString((char const *)arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundCallbackWrapper_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  CsoundCallbackWrapper *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (CsoundCallbackWrapper *)new SwigDirector_CsoundCallbackWrapper(jenv,arg1);
  *(CsoundCallbackWrapper **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundCallbackWrapper_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  CsoundCallbackWrapper *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (CsoundCallbackWrapper *)new SwigDirector_CsoundCallbackWrapper(jenv,arg1);
  *(CsoundCallbackWrapper **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundCallbackWrapper(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundCallbackWrapper *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundCallbackWrapper **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  CsoundCallbackWrapper *obj = *((CsoundCallbackWrapper **)&objarg);
  (void)jcls;
  SwigDirector_CsoundCallbackWrapper *director = static_cast<SwigDirector_CsoundCallbackWrapper *>(obj);
  director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundCallbackWrapper_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  CsoundCallbackWrapper *obj = *((CsoundCallbackWrapper **)&objarg);
  SwigDirector_CsoundCallbackWrapper *director = dynamic_cast<SwigDirector_CsoundCallbackWrapper *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundMidiInputBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  unsigned char *arg1 = 0 ;
  int arg2 ;
  CsoundMidiInputBuffer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(unsigned char **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (CsoundMidiInputBuffer *)new CsoundMidiInputBuffer(arg1,arg2);
  *(CsoundMidiInputBuffer **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundMidiInputBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundMidiInputBuffer *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundMidiInputBuffer **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMidiInputBuffer_1SendMidiMessage_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CsoundMidiInputBuffer *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiInputBuffer **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->SendMidiMessage(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMidiInputBuffer_1SendMidiMessage_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4, jint jarg5) {
  CsoundMidiInputBuffer *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiInputBuffer **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  (arg1)->SendMidiMessage(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMidiInputBuffer_1SendNoteOn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  CsoundMidiInputBuffer *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiInputBuffer **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->SendNoteOn(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMidiInputBuffer_1SendNoteOff_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  CsoundMidiInputBuffer *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiInputBuffer **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->SendNoteOff(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMidiInputBuffer_1SendNoteOff_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  CsoundMidiInputBuffer *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiInputBuffer **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->SendNoteOff(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMidiInputBuffer_1SendPolyphonicPressure(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  CsoundMidiInputBuffer *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiInputBuffer **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->SendPolyphonicPressure(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMidiInputBuffer_1SendControlChange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  CsoundMidiInputBuffer *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiInputBuffer **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->SendControlChange(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMidiInputBuffer_1SendProgramChange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  CsoundMidiInputBuffer *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiInputBuffer **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->SendProgramChange(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMidiInputBuffer_1SendChannelPressure(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  CsoundMidiInputBuffer *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiInputBuffer **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->SendChannelPressure(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMidiInputBuffer_1SendPitchBend(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  CsoundMidiInputBuffer *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiInputBuffer **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->SendPitchBend(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundMidiInputStream_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  CsoundMidiInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (CsoundMidiInputStream *)new CsoundMidiInputStream(arg1);
  *(CsoundMidiInputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundMidiInputStream_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  CsoundMidiInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (CsoundMidiInputStream *)new CsoundMidiInputStream(arg1);
  *(CsoundMidiInputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMidiInputStream_1EnableMidiInput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  CsoundMidiInputStream *arg1 = 0 ;
  CsoundArgVList *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CsoundMidiInputStream **)&jarg1; 
  arg2 = *(CsoundArgVList **)&jarg2; 
  (arg1)->EnableMidiInput(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundMidiInputStream(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundMidiInputStream *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundMidiInputStream **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundMidiOutputBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  unsigned char *arg1 = 0 ;
  int arg2 ;
  CsoundMidiOutputBuffer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(unsigned char **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (CsoundMidiOutputBuffer *)new CsoundMidiOutputBuffer(arg1,arg2);
  *(CsoundMidiOutputBuffer **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundMidiOutputBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundMidiOutputBuffer *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundMidiOutputBuffer **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundMidiOutputBuffer_1PopMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundMidiOutputBuffer *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiOutputBuffer **)&jarg1; 
  result = (int)(arg1)->PopMessage();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundMidiOutputBuffer_1GetStatus(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundMidiOutputBuffer *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiOutputBuffer **)&jarg1; 
  result = (int)(arg1)->GetStatus();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundMidiOutputBuffer_1GetChannel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundMidiOutputBuffer *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiOutputBuffer **)&jarg1; 
  result = (int)(arg1)->GetChannel();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundMidiOutputBuffer_1GetData1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundMidiOutputBuffer *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiOutputBuffer **)&jarg1; 
  result = (int)(arg1)->GetData1();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundMidiOutputBuffer_1GetData2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundMidiOutputBuffer *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundMidiOutputBuffer **)&jarg1; 
  result = (int)(arg1)->GetData2();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundMidiOutputStream_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  CsoundMidiOutputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (CsoundMidiOutputStream *)new CsoundMidiOutputStream(arg1);
  *(CsoundMidiOutputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundMidiOutputStream_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  CsoundMidiOutputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (CsoundMidiOutputStream *)new CsoundMidiOutputStream(arg1);
  *(CsoundMidiOutputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundMidiOutputStream_1EnableMidiOutput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  CsoundMidiOutputStream *arg1 = 0 ;
  CsoundArgVList *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(CsoundMidiOutputStream **)&jarg1; 
  arg2 = *(CsoundArgVList **)&jarg2; 
  (arg1)->EnableMidiOutput(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundMidiOutputStream(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundMidiOutputStream *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundMidiOutputStream **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI__1MM_1DENORMALS_1ZERO_1MASK_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI__1MM_1DENORMALS_1ZERO_1ON_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI__1MM_1DENORMALS_1ZERO_1OFF_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_recordData_1t_1cbuf_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  recordData_t *arg1 = 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(recordData_t **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->cbuf = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_recordData_1t_1cbuf_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  recordData_t *arg1 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(recordData_t **)&jarg1; 
  result = (void *) ((arg1)->cbuf);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_recordData_1t_1sfile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  recordData_t *arg1 = 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(recordData_t **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->sfile = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_recordData_1t_1sfile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  recordData_t *arg1 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(recordData_t **)&jarg1; 
  result = (void *) ((arg1)->sfile);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_recordData_1t_1thread_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  recordData_t *arg1 = 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(recordData_t **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->thread = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_recordData_1t_1thread_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  recordData_t *arg1 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(recordData_t **)&jarg1; 
  result = (void *) ((arg1)->thread);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_recordData_1t_1running_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  recordData_t *arg1 = 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(recordData_t **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->running = arg2;
}


SWIGEXPORT jboolean JNICALL Java_csnd6_csnd6JNI_recordData_1t_1running_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  recordData_t *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(recordData_t **)&jarg1; 
  result = (bool) ((arg1)->running);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_recordData_1t_1condvar_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  recordData_t *arg1 = 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(recordData_t **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->condvar = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_recordData_1t_1condvar_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  recordData_t *arg1 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(recordData_t **)&jarg1; 
  result = (void *) ((arg1)->condvar);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_recordData_1t_1mutex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  recordData_t *arg1 = 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(recordData_t **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->mutex = arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_recordData_1t_1mutex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  recordData_t *arg1 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(recordData_t **)&jarg1; 
  result = (void *) ((arg1)->mutex);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1recordData_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  recordData_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (recordData_t *)new recordData_t();
  *(recordData_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1recordData_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  recordData_t *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(recordData_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1isRunning(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundPerformanceThread *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  result = (int)(arg1)->isRunning();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1GetProcessCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CsoundPerformanceThread *arg1 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  result = (void *)(arg1)->GetProcessCallback();
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1GetCsound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CsoundPerformanceThread *arg1 = 0 ;
  CSOUND *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  result = (CSOUND *)(arg1)->GetCsound();
  *(CSOUND **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1GetStatus(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundPerformanceThread *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  result = (int)(arg1)->GetStatus();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1Play(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundPerformanceThread *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  (arg1)->Play();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1Pause(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundPerformanceThread *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  (arg1)->Pause();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1TogglePause(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundPerformanceThread *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  (arg1)->TogglePause();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1Stop(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundPerformanceThread *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  (arg1)->Stop();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1Record_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jint jarg4) {
  CsoundPerformanceThread *arg1 = 0 ;
  std::string arg2 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->Record(SWIG_STD_MOVE(arg2),arg3,arg4);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1Record_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  CsoundPerformanceThread *arg1 = 0 ;
  std::string arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (int)jarg3; 
  (arg1)->Record(SWIG_STD_MOVE(arg2),arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1Record_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CsoundPerformanceThread *arg1 = 0 ;
  std::string arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->Record(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1StopRecord(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundPerformanceThread *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  (arg1)->StopRecord();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1ScoreEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jchar jarg3, jint jarg4, jlong jarg5) {
  CsoundPerformanceThread *arg1 = 0 ;
  int arg2 ;
  char arg3 ;
  int arg4 ;
  double *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (char)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(double **)&jarg5; 
  (arg1)->ScoreEvent(arg2,arg3,arg4,(double const *)arg5);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1InputMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CsoundPerformanceThread *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->InputMessage((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1SetScoreOffsetSeconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  CsoundPerformanceThread *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  arg2 = (double)jarg2; 
  (arg1)->SetScoreOffsetSeconds(arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1Join(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundPerformanceThread *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  result = (int)(arg1)->Join();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundPerformanceThread_1FlushMessageQueue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundPerformanceThread *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  (arg1)->FlushMessageQueue();
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundPerformanceThread_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Csound *arg1 = 0 ;
  CsoundPerformanceThread *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Csound **)&jarg1; 
  result = (CsoundPerformanceThread *)new CsoundPerformanceThread(arg1);
  *(CsoundPerformanceThread **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundPerformanceThread_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  CSOUND *arg1 = 0 ;
  CsoundPerformanceThread *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSOUND **)&jarg1; 
  result = (CsoundPerformanceThread *)new CsoundPerformanceThread(arg1);
  *(CsoundPerformanceThread **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundPerformanceThread(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundPerformanceThread *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundPerformanceThread **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1IntToStringMap_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::map< int,std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::map< int,std::string > *)new std::map< int,std::string >();
  *(std::map< int,std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1IntToStringMap_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::map< int,std::string > *arg1 = 0 ;
  std::map< int,std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< int,std::string > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::map< int,std::string > const & is null");
    return 0;
  } 
  result = (std::map< int,std::string > *)new std::map< int,std::string >((std::map< int,std::string > const &)*arg1);
  *(std::map< int,std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_IntToStringMap_1Iterator_1getNextUnchecked(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::map< int,std::string >::iterator *arg1 = 0 ;
  std::map< int,std::string,std::less< int > >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< int,std::string >::iterator **)&jarg1; 
  result = std_map_Sl_int_Sc_std_string_Sg__iterator_getNextUnchecked(arg1);
  *(std::map< int,std::string,std::less< int > >::iterator **)&jresult = new std::map< int,std::string,std::less< int > >::iterator(result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_csnd6_csnd6JNI_IntToStringMap_1Iterator_1isNot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  std::map< int,std::string >::iterator *arg1 = 0 ;
  std::map< int,std::string >::iterator arg2 ;
  std::map< int,std::string >::iterator *argp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::map< int,std::string >::iterator **)&jarg1; 
  argp2 = *(std::map< int,std::string >::iterator **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::map< int,std::string >::iterator");
    return 0;
  }
  arg2 = *argp2; 
  result = (bool)std_map_Sl_int_Sc_std_string_Sg__iterator_isNot((std::map< int,std::string >::iterator const *)arg1,SWIG_STD_MOVE(arg2));
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_IntToStringMap_1Iterator_1getKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::map< int,std::string >::iterator *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< int,std::string >::iterator **)&jarg1; 
  result = (int)std_map_Sl_int_Sc_std_string_Sg__iterator_getKey((std::map< int,std::string >::iterator const *)arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_IntToStringMap_1Iterator_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  std::map< int,std::string >::iterator *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< int,std::string >::iterator **)&jarg1; 
  result = std_map_Sl_int_Sc_std_string_Sg__iterator_getValue((std::map< int,std::string >::iterator const *)arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_IntToStringMap_1Iterator_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  std::map< int,std::string >::iterator *arg1 = 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< int,std::string >::iterator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  std_map_Sl_int_Sc_std_string_Sg__iterator_setValue(arg1,(std::string const &)*arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1IntToStringMap_1Iterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::map< int,std::string >::iterator *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::map< int,std::string >::iterator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_csnd6_csnd6JNI_IntToStringMap_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::map< int,std::string > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< int,std::string > **)&jarg1; 
  result = (bool)((std::map< int,std::string > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_IntToStringMap_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::map< int,std::string > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< int,std::string > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_IntToStringMap_1find(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::map< int,std::string > *arg1 = 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  std::map< int,std::string >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< int,std::string > **)&jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  result = (arg1)->find((int const &)*arg2);
  *(std::map< int,std::string >::iterator **)&jresult = new std::map< int,std::string >::iterator(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_IntToStringMap_1begin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::map< int,std::string > *arg1 = 0 ;
  std::map< int,std::string >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< int,std::string > **)&jarg1; 
  result = (arg1)->begin();
  *(std::map< int,std::string >::iterator **)&jresult = new std::map< int,std::string >::iterator(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_IntToStringMap_1end(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::map< int,std::string > *arg1 = 0 ;
  std::map< int,std::string >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< int,std::string > **)&jarg1; 
  result = (arg1)->end();
  *(std::map< int,std::string >::iterator **)&jresult = new std::map< int,std::string >::iterator(result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_IntToStringMap_1sizeImpl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::map< int,std::string > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< int,std::string > **)&jarg1; 
  try {
    result = std_map_Sl_int_Sc_std_string_Sg__sizeImpl((std::map< int,std::string > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_csnd6_csnd6JNI_IntToStringMap_1containsImpl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  std::map< int,std::string > *arg1 = 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< int,std::string > **)&jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  result = (bool)std_map_Sl_int_Sc_std_string_Sg__containsImpl(arg1,(int const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_IntToStringMap_1putUnchecked(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  std::map< int,std::string > *arg1 = 0 ;
  int *arg2 = 0 ;
  std::string *arg3 = 0 ;
  int temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< int,std::string > **)&jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  std_map_Sl_int_Sc_std_string_Sg__putUnchecked(arg1,(int const &)*arg2,(std::string const &)*arg3);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_IntToStringMap_1removeUnchecked(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::map< int,std::string > *arg1 = 0 ;
  std::map< int,std::string,std::less< int > >::iterator arg2 ;
  std::map< int,std::string,std::less< int > >::iterator const *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::map< int,std::string > **)&jarg1; 
  argp2 = *(std::map< int,std::string,std::less< int > >::iterator **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::map< int,std::string,std::less< int > >::iterator const");
    return ;
  }
  arg2 = *argp2; 
  std_map_Sl_int_Sc_std_string_Sg__removeUnchecked(arg1,SWIG_STD_MOVE(arg2));
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1IntToStringMap(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::map< int,std::string > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::map< int,std::string > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_gatherArgs(JNIEnv *jenv, jclass jcls, jint jarg1, jobjectArray jarg2, jlong jarg3) {
  int arg1 ;
  char **arg2 = 0 ;
  std::string *arg3 = 0 ;
  jint size2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  {
    int i = 0;
    if (jarg2) {
      size2 = jenv->GetArrayLength(jarg2);
      
      arg2 = new char*[size2+1];
      
      
      
      for (i = 0; i<size2; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg2, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg2[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg2[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg2[i] = 0;
    } else {
      arg2 = 0;
      size2 = 0;
    }
  }
  arg3 = *(std::string **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & is null");
    return ;
  } 
  gatherArgs(arg1,(char const **)arg2,*arg3);
  {
    int i;
    for (i=0; i<size2; i++)
    
    delete[] arg2[i];
    delete[] arg2;
    
    
    
    
  }
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_scatterArgs(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3) {
  std::string arg1 ;
  std::vector< std::string > *arg2 = 0 ;
  std::vector< char * > *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg1_pstr = jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return ;
  (&arg1)->assign(arg1_pstr);
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = *(std::vector< std::string > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::string > & is null");
    return ;
  } 
  arg3 = *(std::vector< char * > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< char * > & is null");
    return ;
  } 
  scatterArgs(SWIG_STD_MOVE(arg1),*arg2,*arg3);
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_trim(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::string **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & is null");
    return 0;
  } 
  result = (std::string *) &trim(*arg1);
  *(std::string **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_trimQuotes(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::string **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & is null");
    return 0;
  } 
  result = (std::string *) &trimQuotes(*arg1);
  *(std::string **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_csnd6_csnd6JNI_parseInstrument(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jboolean jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & is null");
    return 0;
  } 
  arg3 = *(std::string **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & is null");
    return 0;
  } 
  arg4 = *(std::string **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & is null");
    return 0;
  } 
  arg5 = *(std::string **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & is null");
    return 0;
  } 
  result = (bool)parseInstrument((std::string const &)*arg1,*arg2,*arg3,*arg4,*arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1libraryFilename_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CsoundFile *arg1 = 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if (arg1) (arg1)->libraryFilename = *arg2;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1libraryFilename_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = (std::string *) & ((arg1)->libraryFilename);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1arrangement_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  CsoundFile *arg1 = 0 ;
  std::vector< std::string > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::vector< std::string > **)&jarg2; 
  if (arg1) (arg1)->arrangement = *arg2;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CsoundFile_1arrangement_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = (std::vector< std::string > *)& ((arg1)->arrangement);
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CsoundFile(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CsoundFile *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CsoundFile *)new CsoundFile();
  *(CsoundFile **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CsoundFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CsoundFile *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CsoundFile **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1generateFilename(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = (arg1)->generateFilename();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getFilename(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = ((CsoundFile const *)arg1)->getFilename();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1setFilename(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->setFilename(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1load_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = (int)(arg1)->load(SWIG_STD_MOVE(arg2));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1load_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::istream *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::istream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::istream & is null");
    return 0;
  } 
  result = (int)(arg1)->load(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1save_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = (int)((CsoundFile const *)arg1)->save(SWIG_STD_MOVE(arg2));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1save_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::ostream *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::ostream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::ostream & is null");
    return 0;
  } 
  result = (int)((CsoundFile const *)arg1)->save(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1importFile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = (int)(arg1)->importFile(SWIG_STD_MOVE(arg2));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1importFile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::istream *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::istream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::istream & is null");
    return 0;
  } 
  result = (int)(arg1)->importFile(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1importCommand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::istream *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::istream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::istream & is null");
    return 0;
  } 
  result = (int)(arg1)->importCommand(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1exportCommand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::ostream *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::ostream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::ostream & is null");
    return 0;
  } 
  result = (int)((CsoundFile const *)arg1)->exportCommand(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1importOrchestra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::istream *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::istream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::istream & is null");
    return 0;
  } 
  result = (int)(arg1)->importOrchestra(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1exportOrchestra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::ostream *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::ostream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::ostream & is null");
    return 0;
  } 
  result = (int)((CsoundFile const *)arg1)->exportOrchestra(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1importScore(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::istream *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::istream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::istream & is null");
    return 0;
  } 
  result = (int)(arg1)->importScore(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1exportScore(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::ostream *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::ostream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::ostream & is null");
    return 0;
  } 
  result = (int)((CsoundFile const *)arg1)->exportScore(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1importArrangement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::istream *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::istream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::istream & is null");
    return 0;
  } 
  result = (int)(arg1)->importArrangement(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1exportArrangement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::ostream *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::ostream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::ostream & is null");
    return 0;
  } 
  result = (int)((CsoundFile const *)arg1)->exportArrangement(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1exportArrangementForPerformance_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = (int)((CsoundFile const *)arg1)->exportArrangementForPerformance(SWIG_STD_MOVE(arg2));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1exportArrangementForPerformance_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::ostream *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::ostream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::ostream & is null");
    return 0;
  } 
  result = (int)((CsoundFile const *)arg1)->exportArrangementForPerformance(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1importMidifile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::istream *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::istream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::istream & is null");
    return 0;
  } 
  result = (int)(arg1)->importMidifile(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1exportMidifile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::ostream *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = *(std::ostream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::ostream & is null");
    return 0;
  } 
  result = (int)((CsoundFile const *)arg1)->exportMidifile(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getCommand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = ((CsoundFile const *)arg1)->getCommand();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1setCommand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->setCommand(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getOrcFilename(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = ((CsoundFile const *)arg1)->getOrcFilename();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getScoFilename(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = ((CsoundFile const *)arg1)->getScoFilename();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getMidiFilename(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = ((CsoundFile const *)arg1)->getMidiFilename();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getOutputSoundfileName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = ((CsoundFile const *)arg1)->getOutputSoundfileName();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getOrchestra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = ((CsoundFile const *)arg1)->getOrchestra();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1setOrchestra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->setOrchestra(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getInstrumentCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = (int)((CsoundFile const *)arg1)->getInstrumentCount();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getOrchestraHeader(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = ((CsoundFile const *)arg1)->getOrchestraHeader();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getInstrument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  int arg2 ;
  std::string *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::string **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & is null");
    return 0;
  } 
  result = (bool)((CsoundFile const *)arg1)->getInstrument(arg2,*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getInstrument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  std::string *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(std::string **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & is null");
    return 0;
  } 
  result = (bool)((CsoundFile const *)arg1)->getInstrument(SWIG_STD_MOVE(arg2),*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getInstrument_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = ((CsoundFile const *)arg1)->getInstrument(SWIG_STD_MOVE(arg2));
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getInstrument_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  int arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (int)jarg2; 
  result = ((CsoundFile const *)arg1)->getInstrument(arg2);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getInstrumentBody_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = ((CsoundFile const *)arg1)->getInstrumentBody(SWIG_STD_MOVE(arg2));
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getInstrumentBody_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  int arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (int)jarg2; 
  result = ((CsoundFile const *)arg1)->getInstrumentBody(arg2);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getInstrumentNames(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::map< int,std::string,std::less< int > > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = ((CsoundFile const *)arg1)->getInstrumentNames();
  *(std::map< int,std::string,std::less< int > > **)&jresult = new std::map< int,std::string,std::less< int > >(result); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getInstrumentNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jdouble jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = (double)((CsoundFile const *)arg1)->getInstrumentNumber(SWIG_STD_MOVE(arg2));
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getScore(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = ((CsoundFile const *)arg1)->getScore();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1setScore(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->setScore(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getArrangementCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = (int)((CsoundFile const *)arg1)->getArrangementCount();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getArrangement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  int arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (int)jarg2; 
  result = ((CsoundFile const *)arg1)->getArrangement(arg2);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1addArrangement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->addArrangement(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1setArrangement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  CsoundFile *arg1 = 0 ;
  int arg2 ;
  std::string arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (int)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg3_pstr = jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  (&arg3)->assign(arg3_pstr);
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  (arg1)->setArrangement(arg2,SWIG_STD_MOVE(arg3));
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1insertArrangement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  CsoundFile *arg1 = 0 ;
  int arg2 ;
  std::string arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (int)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg3_pstr = jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  (&arg3)->assign(arg3_pstr);
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  (arg1)->insertArrangement(arg2,SWIG_STD_MOVE(arg3));
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1removeArrangement_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CsoundFile *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->removeArrangement(arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1setCSD(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->setCSD(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CsoundFile_1getCSD(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = ((CsoundFile const *)arg1)->getCSD();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1addScoreLine(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CsoundFile *arg1 = 0 ;
  std::string arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->addScoreLine(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1addNote_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8, jdouble jarg9, jdouble jarg10, jdouble jarg11, jdouble jarg12) {
  CsoundFile *arg1 = 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  double arg7 ;
  double arg8 ;
  double arg9 ;
  double arg10 ;
  double arg11 ;
  double arg12 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  arg8 = (double)jarg8; 
  arg9 = (double)jarg9; 
  arg10 = (double)jarg10; 
  arg11 = (double)jarg11; 
  arg12 = (double)jarg12; 
  (arg1)->addNote(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1addNote_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8, jdouble jarg9, jdouble jarg10, jdouble jarg11) {
  CsoundFile *arg1 = 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  double arg7 ;
  double arg8 ;
  double arg9 ;
  double arg10 ;
  double arg11 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  arg8 = (double)jarg8; 
  arg9 = (double)jarg9; 
  arg10 = (double)jarg10; 
  arg11 = (double)jarg11; 
  (arg1)->addNote(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1addNote_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8, jdouble jarg9, jdouble jarg10) {
  CsoundFile *arg1 = 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  double arg7 ;
  double arg8 ;
  double arg9 ;
  double arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  arg8 = (double)jarg8; 
  arg9 = (double)jarg9; 
  arg10 = (double)jarg10; 
  (arg1)->addNote(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1addNote_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8, jdouble jarg9) {
  CsoundFile *arg1 = 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  double arg7 ;
  double arg8 ;
  double arg9 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  arg8 = (double)jarg8; 
  arg9 = (double)jarg9; 
  (arg1)->addNote(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1addNote_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8) {
  CsoundFile *arg1 = 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  double arg7 ;
  double arg8 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  arg8 = (double)jarg8; 
  (arg1)->addNote(arg2,arg3,arg4,arg5,arg6,arg7,arg8);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1addNote_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7) {
  CsoundFile *arg1 = 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  double arg7 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  (arg1)->addNote(arg2,arg3,arg4,arg5,arg6,arg7);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1addNote_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6) {
  CsoundFile *arg1 = 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  (arg1)->addNote(arg2,arg3,arg4,arg5,arg6);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1addNote_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
  CsoundFile *arg1 = 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  (arg1)->addNote(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1addNote_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
  CsoundFile *arg1 = 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  (arg1)->addNote(arg2,arg3,arg4);
}


SWIGEXPORT jboolean JNICALL Java_csnd6_csnd6JNI_CsoundFile_1exportForPerformance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = (bool)((CsoundFile const *)arg1)->exportForPerformance();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1removeAll(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundFile *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  (arg1)->removeAll();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1removeCommand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundFile *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  (arg1)->removeCommand();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1removeOrchestra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundFile *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  (arg1)->removeOrchestra();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1removeScore(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundFile *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  (arg1)->removeScore();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1removeArrangement_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundFile *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  (arg1)->removeArrangement();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CsoundFile_1removeMidifile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CsoundFile *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  (arg1)->removeMidifile();
}


SWIGEXPORT jboolean JNICALL Java_csnd6_csnd6JNI_CsoundFile_1loadOrcLibrary_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  char *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->loadOrcLibrary((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_csnd6_csnd6JNI_CsoundFile_1loadOrcLibrary_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  CsoundFile *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CsoundFile **)&jarg1; 
  result = (bool)(arg1)->loadOrcLibrary();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1MyfltVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< double > *)new std::vector< double >();
  *(std::vector< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1MyfltVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  result = (std::vector< double > *)new std::vector< double >((std::vector< double > const &)*arg1);
  *(std::vector< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_csnd6_csnd6JNI_MyfltVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  result = (bool)((std::vector< double > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_MyfltVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< double > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1MyfltVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jdouble jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  double *arg2 = 0 ;
  double temp2 ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  try {
    result = (std::vector< double > *)new_std_vector_Sl_double_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(double const &)*arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  *(std::vector< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_MyfltVector_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  try {
    result = std_vector_Sl_double_Sg__doCapacity(arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_MyfltVector_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< double > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  try {
    std_vector_Sl_double_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
  } catch(std::length_error &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_MyfltVector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  try {
    result = std_vector_Sl_double_Sg__doSize((std::vector< double > const *)arg1);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_MyfltVector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  std::vector< double > *arg1 = 0 ;
  std::vector< double >::value_type *arg2 = 0 ;
  std::vector< double >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  temp2 = (std::vector< double >::value_type)jarg2; 
  arg2 = &temp2; 
  std_vector_Sl_double_Sg__doAdd__SWIG_0(arg1,(double const &)*arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_MyfltVector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  std::vector< double > *arg1 = 0 ;
  jint arg2 ;
  std::vector< double >::value_type *arg3 = 0 ;
  std::vector< double >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< double >::value_type)jarg3; 
  arg3 = &temp3; 
  try {
    std_vector_Sl_double_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(double const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_MyfltVector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  jint arg2 ;
  std::vector< double >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< double >::value_type)std_vector_Sl_double_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_MyfltVector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  jint arg2 ;
  std::vector< double >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  try {
    result = (std::vector< double >::value_type *) &std_vector_Sl_double_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = (jdouble)*result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_MyfltVector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  jint arg2 ;
  std::vector< double >::value_type *arg3 = 0 ;
  std::vector< double >::value_type temp3 ;
  std::vector< double >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< double >::value_type)jarg3; 
  arg3 = &temp3; 
  try {
    result = (std::vector< double >::value_type)std_vector_Sl_double_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(double const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_MyfltVector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< double > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  try {
    std_vector_Sl_double_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1MyfltVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< double > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< double > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1CppSound(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CppSound *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CppSound *)new CppSound();
  *(CppSound **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1CppSound(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CppSound *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CppSound **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CppSound_1getCsound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CppSound *arg1 = 0 ;
  CSOUND *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  result = (CSOUND *)(arg1)->getCsound();
  *(CSOUND **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CppSound_1getThis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CppSound *arg1 = 0 ;
  intptr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  result = (arg1)->getThis();
  *(intptr_t **)&jresult = new intptr_t(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CppSound_1getCsoundFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CppSound *arg1 = 0 ;
  CsoundFile *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  result = (CsoundFile *)(arg1)->getCsoundFile();
  *(CsoundFile **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CppSound_1compile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobjectArray jarg3) {
  jint jresult = 0 ;
  CppSound *arg1 = 0 ;
  int arg2 ;
  char **arg3 = 0 ;
  jint size3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    int i = 0;
    if (jarg3) {
      size3 = jenv->GetArrayLength(jarg3);
      
      arg3 = new char*[size3+1];
      
      
      
      for (i = 0; i<size3; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg3, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg3[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg3[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg3[i] = 0;
    } else {
      arg3 = 0;
      size3 = 0;
    }
  }
  result = (int)(arg1)->compile(arg2,(char const **)arg3);
  jresult = (jint)result; 
  {
    int i;
    for (i=0; i<size3; i++)
    
    delete[] arg3[i];
    delete[] arg3;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CppSound_1compile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CppSound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  result = (int)(arg1)->compile();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CppSound_1getSpoutSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CppSound *arg1 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  result = ((CppSound const *)arg1)->getSpoutSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_csnd6_csnd6JNI_CppSound_1getOutputSoundfileName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  CppSound *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  result = ((CppSound const *)arg1)->getOutputSoundfileName();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CppSound_1perform_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobjectArray jarg3) {
  jint jresult = 0 ;
  CppSound *arg1 = 0 ;
  int arg2 ;
  char **arg3 = 0 ;
  jint size3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    int i = 0;
    if (jarg3) {
      size3 = jenv->GetArrayLength(jarg3);
      
      arg3 = new char*[size3+1];
      
      
      
      for (i = 0; i<size3; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg3, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg3[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg3[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg3[i] = 0;
    } else {
      arg3 = 0;
      size3 = 0;
    }
  }
  result = (int)(arg1)->perform(arg2,(char const **)arg3);
  jresult = (jint)result; 
  {
    int i;
    for (i=0; i<size3; i++)
    
    delete[] arg3[i];
    delete[] arg3;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CppSound_1perform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CppSound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  result = (int)(arg1)->perform();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_CppSound_1performKsmps(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CppSound *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  result = (int)(arg1)->performKsmps();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CppSound_1cleanup(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CppSound *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  (arg1)->cleanup();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CppSound_1inputMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CppSound *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->inputMessage((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CppSound_1write(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  CppSound *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->write((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jboolean JNICALL Java_csnd6_csnd6JNI_CppSound_1getIsCompiled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  CppSound *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  result = (bool)((CppSound const *)arg1)->getIsCompiled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CppSound_1setIsPerforming(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  CppSound *arg1 = 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setIsPerforming(arg2);
}


SWIGEXPORT jboolean JNICALL Java_csnd6_csnd6JNI_CppSound_1getIsPerforming(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  CppSound *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  result = (bool)((CppSound const *)arg1)->getIsPerforming();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_csnd6_csnd6JNI_CppSound_1getIsGo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  CppSound *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  result = (bool)(arg1)->getIsGo();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_CppSound_1stop(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CppSound *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CppSound **)&jarg1; 
  (arg1)->stop();
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_new_1Soundfile(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  csound::Soundfile *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (csound::Soundfile *)new csound::Soundfile();
  *(csound::Soundfile **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_delete_1Soundfile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  csound::Soundfile *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(csound::Soundfile **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1getFramesPerSecond(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  result = (int)((csound::Soundfile const *)arg1)->getFramesPerSecond();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Soundfile_1setFramesPerSecond(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csound::Soundfile *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setFramesPerSecond(arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1getChannelsPerFrame(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  result = (int)((csound::Soundfile const *)arg1)->getChannelsPerFrame();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Soundfile_1setChannelsPerFrame(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csound::Soundfile *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setChannelsPerFrame(arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1getFormat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  result = (int)((csound::Soundfile const *)arg1)->getFormat();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Soundfile_1setFormat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  csound::Soundfile *arg1 = 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setFormat(arg2);
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1getFrames(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  result = (int)((csound::Soundfile const *)arg1)->getFrames();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1open(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  std::string arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = (int)(arg1)->open(SWIG_STD_MOVE(arg2));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1create_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jint jarg4, jint jarg5) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  std::string arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  result = (int)(arg1)->create(SWIG_STD_MOVE(arg2),arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1create_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  std::string arg2 ;
  int arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)(arg1)->create(SWIG_STD_MOVE(arg2),arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1create_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  std::string arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (int)jarg3; 
  result = (int)(arg1)->create(SWIG_STD_MOVE(arg2),arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1create_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  std::string arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = (int)(arg1)->create(SWIG_STD_MOVE(arg2));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1seek_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)(arg1)->seek(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1seek_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)(arg1)->seek(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Soundfile_1seekSeconds_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jint jarg3) {
  jdouble jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  double arg2 ;
  int arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (int)jarg3; 
  result = (double)(arg1)->seekSeconds(arg2,arg3);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_csnd6_csnd6JNI_Soundfile_1seekSeconds_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  double arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  arg2 = (double)jarg2; 
  result = (double)(arg1)->seekSeconds(arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1readFrame(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  double *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  arg2 = *(double **)&jarg2; 
  result = (int)(arg1)->readFrame(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1writeFrame(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  double *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  arg2 = *(double **)&jarg2; 
  result = (int)(arg1)->writeFrame(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1readFrames(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  double *arg2 = 0 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  arg2 = *(double **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (int)(arg1)->readFrames(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1writeFrames(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  double *arg2 = 0 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  arg2 = *(double **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (int)(arg1)->writeFrames(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1mixFrames(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jlong jarg4) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  double *arg2 = 0 ;
  int arg3 ;
  double *arg4 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  arg2 = *(double **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(double **)&jarg4; 
  result = (int)(arg1)->mixFrames(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Soundfile_1updateHeader(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  csound::Soundfile *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  (arg1)->updateHeader();
}


SWIGEXPORT jint JNICALL Java_csnd6_csnd6JNI_Soundfile_1close(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  csound::Soundfile *arg1 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  result = (int)(arg1)->close();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Soundfile_1error(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  csound::Soundfile *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  ((csound::Soundfile const *)arg1)->error();
}


SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_Soundfile_1blank(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  csound::Soundfile *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(csound::Soundfile **)&jarg1; 
  arg2 = (double)jarg2; 
  (arg1)->blank(arg2);
}


SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CsoundMidiInputStream_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(CsoundMidiInputBuffer **)&baseptr = *(CsoundMidiInputStream **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CsoundMidiOutputStream_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(CsoundMidiOutputBuffer **)&baseptr = *(CsoundMidiOutputStream **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_csnd6_csnd6JNI_CppSound_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Csound **)&baseptr = *(CppSound **)&jarg1;
    return baseptr;
}

SWIGEXPORT void JNICALL Java_csnd6_csnd6JNI_swig_1module_1init(JNIEnv *jenv, jclass jcls) {
  int i;
  
  static struct {
    const char *method;
    const char *signature;
  } methods[6] = {
    {
      "SwigDirector_CsoundCallbackWrapper_MessageCallback", "(Lcsnd6/CsoundCallbackWrapper;ILjava/lang/String;)V" 
    },
    {
      "SwigDirector_CsoundCallbackWrapper_InputValueCallback", "(Lcsnd6/CsoundCallbackWrapper;Ljava/lang/String;)D" 
    },
    {
      "SwigDirector_CsoundCallbackWrapper_OutputValueCallback", "(Lcsnd6/CsoundCallbackWrapper;Ljava/lang/String;D)V" 
    },
    {
      "SwigDirector_CsoundCallbackWrapper_YieldCallback", "(Lcsnd6/CsoundCallbackWrapper;)I" 
    },
    {
      "SwigDirector_CsoundCallbackWrapper_MidiInputCallback", "(Lcsnd6/CsoundCallbackWrapper;J)V" 
    },
    {
      "SwigDirector_CsoundCallbackWrapper_MidiOutputCallback", "(Lcsnd6/CsoundCallbackWrapper;J)V" 
    }
  };
  Swig::jclass_csnd6JNI = (jclass) jenv->NewGlobalRef(jcls);
  if (!Swig::jclass_csnd6JNI) return;
  for (i = 0; i < (int) (sizeof(methods)/sizeof(methods[0])); ++i) {
    Swig::director_method_ids[i] = jenv->GetStaticMethodID(jcls, methods[i].method, methods[i].signature);
    if (!Swig::director_method_ids[i]) return;
  }
}


#ifdef __cplusplus
}
#endif

