/* helper.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from helper.vala, do not modify */

#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libdino.h"
#include "xmpp-vala.h"
#include "dino_i18n.h"
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <math.h>
#include <float.h>
#include <langinfo.h>
#include <unicode/uchar.h>

#define DINO_UI_UTIL_force_background_css "%s { background-color: %s; }"
#define DINO_UI_UTIL_force_color_css "%s { color: %s; }"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _xmpp_jid_unref0(var) ((var == NULL) ? NULL : (var = (xmpp_jid_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _xmpp_xep_fallback_indication_fallback_location_unref0(var) ((var == NULL) ? NULL : (var = (xmpp_xep_fallback_indication_fallback_location_unref (var), NULL)))
#define _xmpp_xep_fallback_indication_fallback_unref0(var) ((var == NULL) ? NULL : (var = (xmpp_xep_fallback_indication_fallback_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

VALA_EXTERN GRegex* dino_ui_util_URL_REGEX;
GRegex* dino_ui_util_URL_REGEX = NULL;
VALA_EXTERN GRegex* dino_ui_util_CODE_BLOCK_REGEX;
GRegex* dino_ui_util_CODE_BLOCK_REGEX = NULL;
VALA_EXTERN GeeMap* dino_ui_util_MATCHING_CHARS;
GeeMap* dino_ui_util_MATCHING_CHARS = NULL;
VALA_EXTERN gint8 dino_ui_util_is24h;
gint8 dino_ui_util_is24h = (gint8) 0;

VALA_EXTERN gchar* dino_ui_util_get_consistent_hex_color (DinoStreamInteractor* stream_interactor,
                                              DinoEntitiesAccount* account,
                                              XmppJid* jid,
                                              gboolean dark_theme);
VALA_EXTERN gchar* dino_ui_util_get_avatar_hex_color (DinoStreamInteractor* stream_interactor,
                                          DinoEntitiesAccount* account,
                                          XmppJid* jid,
                                          DinoEntitiesConversation* conversation);
VALA_EXTERN XmppJid* dino_ui_util_get_relevant_jid (DinoStreamInteractor* stream_interactor,
                                        DinoEntitiesAccount* account,
                                        XmppJid* jid,
                                        DinoEntitiesConversation* conversation);
VALA_EXTERN gchar* dino_ui_util_get_name_hex_color (DinoStreamInteractor* stream_interactor,
                                        DinoEntitiesAccount* account,
                                        XmppJid* jid,
                                        gboolean dark_theme,
                                        DinoEntitiesConversation* conversation);
VALA_EXTERN gchar* dino_ui_util_color_for_show (const gchar* show);
VALA_EXTERN gchar* dino_ui_util_get_conversation_display_name (DinoStreamInteractor* stream_interactor,
                                                   DinoEntitiesConversation* conversation);
VALA_EXTERN gchar* dino_ui_util_get_participant_display_name (DinoStreamInteractor* stream_interactor,
                                                  DinoEntitiesConversation* conversation,
                                                  XmppJid* participant,
                                                  gboolean me_is_me);
VALA_EXTERN gchar* dino_ui_util_get_real_display_name (DinoStreamInteractor* stream_interactor,
                                           DinoEntitiesAccount* account,
                                           XmppJid* jid,
                                           gboolean me_is_me);
VALA_EXTERN gchar* dino_ui_util_get_groupchat_display_name (DinoStreamInteractor* stream_interactor,
                                                DinoEntitiesAccount* account,
                                                XmppJid* jid);
VALA_EXTERN gchar* dino_ui_util_get_occupant_display_name (DinoStreamInteractor* stream_interactor,
                                               DinoEntitiesConversation* conversation,
                                               XmppJid* jid,
                                               gboolean me_is_me,
                                               gboolean muc_real_name);
VALA_EXTERN void dino_ui_util_get_label_pango_color (GtkLabel* label,
                                         const gchar* css_color,
                                         GdkRGBA* result);
VALA_EXTERN GtkCssProvider* dino_ui_util_force_color (GtkWidget* widget,
                                          const gchar* color,
                                          const gchar* selector);
VALA_EXTERN gchar* dino_ui_util_rgba_to_hex (GdkRGBA* rgba);
VALA_EXTERN GtkCssProvider* dino_ui_util_force_css (GtkWidget* widget,
                                        const gchar* css);
VALA_EXTERN void dino_ui_util_force_background (GtkWidget* widget,
                                    const gchar* color,
                                    const gchar* selector);
VALA_EXTERN void dino_ui_util_force_error_color (GtkWidget* widget,
                                     const gchar* selector);
VALA_EXTERN gboolean dino_ui_util_is_dark_theme (GtkWidget* widget);
VALA_EXTERN gboolean dino_ui_util_is_24h_format (void);
VALA_EXTERN gchar* dino_ui_util_format_time (GDateTime* datetime,
                                 const gchar* format_24h,
                                 const gchar* format_12h);
VALA_EXTERN GRegex* dino_ui_util_get_url_regex (void);
VALA_EXTERN GeeMap* dino_ui_util_get_matching_chars (void);
VALA_EXTERN gchar* dino_ui_util_unbreak_space_around_non_spacing_mark (gchar* s);
VALA_EXTERN gchar* dino_ui_util_parse_add_markup (const gchar* s_,
                                      const gchar* highlight_word,
                                      gboolean parse_links,
                                      gboolean parse_text_markup);
VALA_EXTERN gchar* dino_ui_util_parse_add_markup_theme (const gchar* s_,
                                            const gchar* highlight_word,
                                            gboolean parse_links,
                                            gboolean parse_text_markup,
                                            gboolean parse_quotes,
                                            gboolean dark_theme,
                                            gboolean* theme_dependent,
                                            gboolean already_escaped_);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
static gboolean _vala_unichar_array_contains (gunichar * stack,
                                       gssize stack_length,
                                       const gunichar needle);
VALA_EXTERN gchar* dino_ui_util_remove_fallbacks_adjust_markups (const gchar* text,
                                                     gboolean contains_quote,
                                                     GeeList* fallbacks,
                                                     GeeList* markups);
VALA_EXTERN gint dino_ui_util_get_only_emoji_count (const gchar* markup_text);
VALA_EXTERN gchar* dino_ui_util_summarize_whitespaces_to_space (const gchar* s);
VALA_EXTERN void dino_ui_util_present_window (GtkWindow* window);
VALA_EXTERN GtkWidget* dino_ui_util_widget_if_tooltips_active (GtkWidget* w);
VALA_EXTERN gboolean dino_ui_util_use_tooltips (void);
VALA_EXTERN gchar* dino_ui_util_string_if_tooltips_active (const gchar* s);
VALA_EXTERN void dino_ui_util_menu_button_set_icon_with_size (GtkMenuButton* menu_button,
                                                  const gchar* icon_name,
                                                  gint pixel_size);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const gunichar DINO_UI_UTIL_NON_TRAILING_CHARS[17] = {(gunichar) '\'', (gunichar) '"', (gunichar) ',', (gunichar) '.', (gunichar) ';', (gunichar) '!', (gunichar) '?', 187U, 8221U, 8217U, (gunichar) '`', (gunichar) '~', 8253U, (gunichar) ':', (gunichar) '>', (gunichar) '*', (gunichar) '_'};
const gchar* DINO_UI_UTIL_ALLOWED_SCHEMAS[23] = {"http", "https", "ftp", "ftps", "irc", "ircs", "xmpp", "mailto", "sms", "smsto", "mms", "tel", "geo", "openpgp4fpr", "im", "news", "nntp", "sip", "ssh", "bitcoin", "sftp", "magnet", "vnc"};
const gchar* DINO_UI_UTIL_tango_colors_light[7] = {"FCE94F", "FCAF3E", "E9B96E", "8AE234", "729FCF", "AD7FA8", "EF2929"};
const gchar* DINO_UI_UTIL_tango_colors_medium[7] = {"EDD400", "F57900", "C17D11", "73D216", "3465A4", "75507B", "CC0000"};
const gchar* DINO_UI_UTIL_material_colors_800[16] = {"D32F2F", "C2185B", "7B1FA2", "512DA8", "303F9F", "1976D2", "0288D1", "0097A7", "00796B", "388E3C", "689F38", "AFB42B", "FFA000", "F57C00", "E64A19", "5D4037"};
const gchar* DINO_UI_UTIL_material_colors_500[16] = {"F44336", "E91E63", "9C27B0", "673AB7", "3f51B5", "2196F3", "03A9f4", "00BCD4", "009688", "4CAF50", "8BC34a", "CDDC39", "FFC107", "FF9800", "FF5722", "795548"};
const gchar* DINO_UI_UTIL_material_colors_300[16] = {"E57373", "F06292", "BA68C8", "9575CD", "7986CB", "64B5F6", "4FC3F7", "4DD0E1", "4DB6AC", "81C784", "AED581", "DCE775", "FFD54F", "FFB74D", "FF8A65", "A1887F"};
const gchar* DINO_UI_UTIL_material_colors_200[16] = {"EF9A9A", "F48FB1", "CE93D8", "B39DDB", "9FA8DA", "90CAF9", "81D4FA", "80DEEA", "80CBC4", "A5D6A7", "C5E1A5", "E6EE9C", "FFE082", "FFCC80", "FFAB91", "BCAAA4"};
static GRegex* _tmp_regex_0 = NULL;
static GRegex* _tmp_regex_1 = NULL;
static GRegex* _tmp_regex_2 = NULL;
static GRegex* _tmp_regex_3 = NULL;

gchar*
dino_ui_util_get_consistent_hex_color (DinoStreamInteractor* stream_interactor,
                                       DinoEntitiesAccount* account,
                                       XmppJid* jid,
                                       gboolean dark_theme)
{
	guint8* rgb = NULL;
	gint rgb_length1 = 0;
	gint _rgb_size_ = 0;
	gboolean _tmp0_ = FALSE;
	DinoModuleIdentity* _tmp1_;
	gpointer _tmp2_;
	DinoMucManager* _tmp3_;
	XmppJid* _tmp4_;
	XmppJid* _tmp5_;
	XmppJid* _tmp6_;
	gboolean _tmp7_;
	guint8* _tmp19_;
	gint _tmp19__length1;
	guint8 _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	guint8 _tmp22_;
	guint8* _tmp23_;
	gint _tmp23__length1;
	guint8 _tmp24_;
	gchar* _tmp25_;
	gchar* result;
	g_return_val_if_fail (stream_interactor != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (jid != NULL, NULL);
	_tmp1_ = dino_muc_manager_IDENTITY;
	_tmp2_ = dino_stream_interactor_get_module (stream_interactor, DINO_TYPE_MUC_MANAGER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp1_);
	_tmp3_ = (DinoMucManager*) _tmp2_;
	_tmp4_ = xmpp_jid_get_bare_jid (jid);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = dino_muc_manager_is_groupchat (_tmp3_, _tmp6_, account);
	_xmpp_jid_unref0 (_tmp6_);
	_g_object_unref0 (_tmp3_);
	if (_tmp7_) {
		const gchar* _tmp8_;
		_tmp8_ = jid->resourcepart;
		_tmp0_ = _tmp8_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp9_;
		gint _tmp10_ = 0;
		guint8* _tmp11_;
		_tmp9_ = jid->resourcepart;
		_tmp11_ = xmpp_xep_consistent_color_string_to_rgb (_tmp9_, &_tmp10_);
		rgb = (g_free (rgb), NULL);
		rgb = _tmp11_;
		rgb_length1 = _tmp10_;
		_rgb_size_ = rgb_length1;
	} else {
		XmppJid* _tmp12_;
		XmppJid* _tmp13_;
		XmppJid* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gint _tmp17_ = 0;
		guint8* _tmp18_;
		_tmp12_ = xmpp_jid_get_bare_jid (jid);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp15_ = xmpp_jid_to_string (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp18_ = xmpp_xep_consistent_color_string_to_rgb (_tmp16_, &_tmp17_);
		rgb = (g_free (rgb), NULL);
		rgb = _tmp18_;
		rgb_length1 = _tmp17_;
		_rgb_size_ = rgb_length1;
		_g_free0 (_tmp16_);
		_xmpp_jid_unref0 (_tmp14_);
	}
	_tmp19_ = rgb;
	_tmp19__length1 = rgb_length1;
	_tmp20_ = _tmp19_[0];
	_tmp21_ = rgb;
	_tmp21__length1 = rgb_length1;
	_tmp22_ = _tmp21_[1];
	_tmp23_ = rgb;
	_tmp23__length1 = rgb_length1;
	_tmp24_ = _tmp23_[2];
	_tmp25_ = g_strdup_printf ("%.2x%.2x%.2x", (guint) _tmp20_, (guint) _tmp22_, (guint) _tmp24_);
	result = _tmp25_;
	rgb = (g_free (rgb), NULL);
	return result;
}

gchar*
dino_ui_util_get_avatar_hex_color (DinoStreamInteractor* stream_interactor,
                                   DinoEntitiesAccount* account,
                                   XmppJid* jid,
                                   DinoEntitiesConversation* conversation)
{
	XmppJid* _tmp0_;
	XmppJid* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (stream_interactor != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (jid != NULL, NULL);
	_tmp0_ = dino_ui_util_get_relevant_jid (stream_interactor, account, jid, conversation);
	_tmp1_ = _tmp0_;
	_tmp2_ = dino_ui_util_get_consistent_hex_color (stream_interactor, account, _tmp1_, FALSE);
	_tmp3_ = _tmp2_;
	_xmpp_jid_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
dino_ui_util_get_name_hex_color (DinoStreamInteractor* stream_interactor,
                                 DinoEntitiesAccount* account,
                                 XmppJid* jid,
                                 gboolean dark_theme,
                                 DinoEntitiesConversation* conversation)
{
	XmppJid* _tmp0_;
	XmppJid* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (stream_interactor != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (jid != NULL, NULL);
	_tmp0_ = dino_ui_util_get_relevant_jid (stream_interactor, account, jid, conversation);
	_tmp1_ = _tmp0_;
	_tmp2_ = dino_ui_util_get_consistent_hex_color (stream_interactor, account, _tmp1_, dark_theme);
	_tmp3_ = _tmp2_;
	_xmpp_jid_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_xmpp_jid_ref0 (gpointer self)
{
	return self ? xmpp_jid_ref (self) : NULL;
}

XmppJid*
dino_ui_util_get_relevant_jid (DinoStreamInteractor* stream_interactor,
                               DinoEntitiesAccount* account,
                               XmppJid* jid,
                               DinoEntitiesConversation* conversation)
{
	DinoEntitiesConversation* _tmp0_ = NULL;
	DinoEntitiesConversation* _tmp1_;
	DinoEntitiesConversation* conversation_ = NULL;
	DinoEntitiesConversation* _tmp9_;
	gboolean _tmp10_ = FALSE;
	DinoEntitiesConversation* _tmp11_;
	XmppJid* _tmp26_;
	XmppJid* result;
	g_return_val_if_fail (stream_interactor != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (jid != NULL, NULL);
	_tmp1_ = _g_object_ref0 (conversation);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		DinoModuleIdentity* _tmp2_;
		gpointer _tmp3_;
		DinoConversationManager* _tmp4_;
		XmppJid* _tmp5_;
		XmppJid* _tmp6_;
		XmppJid* _tmp7_;
		DinoEntitiesConversation* _tmp8_;
		_tmp2_ = dino_conversation_manager_IDENTITY;
		_tmp3_ = dino_stream_interactor_get_module (stream_interactor, DINO_TYPE_CONVERSATION_MANAGER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp2_);
		_tmp4_ = (DinoConversationManager*) _tmp3_;
		_tmp5_ = xmpp_jid_get_bare_jid (jid);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = dino_conversation_manager_get_conversation (_tmp4_, _tmp7_, account, NULL);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp8_;
		_xmpp_jid_unref0 (_tmp7_);
		_g_object_unref0 (_tmp4_);
	}
	_tmp9_ = _tmp0_;
	_tmp0_ = NULL;
	conversation_ = _tmp9_;
	_tmp11_ = conversation_;
	if (_tmp11_ != NULL) {
		DinoEntitiesConversation* _tmp12_;
		DinoEntitiesConversationType _tmp13_;
		DinoEntitiesConversationType _tmp14_;
		_tmp12_ = conversation_;
		_tmp13_ = dino_entities_conversation_get_type_ (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp10_ = _tmp14_ == DINO_ENTITIES_CONVERSATION_TYPE_GROUPCHAT;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		XmppJid* real_jid = NULL;
		DinoModuleIdentity* _tmp15_;
		gpointer _tmp16_;
		DinoMucManager* _tmp17_;
		XmppJid* _tmp18_;
		XmppJid* _tmp19_;
		XmppJid* _tmp20_;
		_tmp15_ = dino_muc_manager_IDENTITY;
		_tmp16_ = dino_stream_interactor_get_module (stream_interactor, DINO_TYPE_MUC_MANAGER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp15_);
		_tmp17_ = (DinoMucManager*) _tmp16_;
		_tmp18_ = dino_muc_manager_get_real_jid (_tmp17_, jid, account);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		real_jid = _tmp19_;
		_tmp20_ = real_jid;
		if (_tmp20_ != NULL) {
			XmppJid* _tmp21_;
			XmppJid* _tmp22_;
			XmppJid* _tmp23_;
			_tmp21_ = real_jid;
			_tmp22_ = xmpp_jid_get_bare_jid (_tmp21_);
			_tmp23_ = _tmp22_;
			result = _tmp23_;
			_xmpp_jid_unref0 (real_jid);
			_g_object_unref0 (conversation_);
			_g_object_unref0 (_tmp0_);
			return result;
		}
		_xmpp_jid_unref0 (real_jid);
	} else {
		XmppJid* _tmp24_;
		XmppJid* _tmp25_;
		_tmp24_ = xmpp_jid_get_bare_jid (jid);
		_tmp25_ = _tmp24_;
		result = _tmp25_;
		_g_object_unref0 (conversation_);
		_g_object_unref0 (_tmp0_);
		return result;
	}
	_tmp26_ = _xmpp_jid_ref0 (jid);
	result = _tmp26_;
	_g_object_unref0 (conversation_);
	_g_object_unref0 (_tmp0_);
	return result;
}

gchar*
dino_ui_util_color_for_show (const gchar* show)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	gchar* result;
	g_return_val_if_fail (show != NULL, NULL);
	_tmp0_ = show;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("online")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("#9CCC65");
				result = _tmp3_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("away")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("#FFCA28");
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("chat")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("#66BB6A");
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("xa")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("#EF5350");
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("dnd")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("#EF5350");
				result = _tmp7_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("#BDBDBD");
				result = _tmp8_;
				return result;
			}
		}
	}
}

gchar*
dino_ui_util_get_conversation_display_name (DinoStreamInteractor* stream_interactor,
                                            DinoEntitiesConversation* conversation)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (stream_interactor != NULL, NULL);
	g_return_val_if_fail (conversation != NULL, NULL);
	_tmp0_ = dino_gettext ("%s from %s");
	_tmp1_ = dino_get_conversation_display_name (stream_interactor, conversation, _tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
dino_ui_util_get_participant_display_name (DinoStreamInteractor* stream_interactor,
                                           DinoEntitiesConversation* conversation,
                                           XmppJid* participant,
                                           gboolean me_is_me)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (stream_interactor != NULL, NULL);
	g_return_val_if_fail (conversation != NULL, NULL);
	g_return_val_if_fail (participant != NULL, NULL);
	if (me_is_me) {
		const gchar* _tmp1_;
		_tmp1_ = dino_gettext ("Me");
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp2_ = dino_get_participant_display_name (stream_interactor, conversation, participant, _tmp0_);
	result = _tmp2_;
	return result;
}

gchar*
dino_ui_util_get_real_display_name (DinoStreamInteractor* stream_interactor,
                                    DinoEntitiesAccount* account,
                                    XmppJid* jid,
                                    gboolean me_is_me)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (stream_interactor != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (jid != NULL, NULL);
	if (me_is_me) {
		const gchar* _tmp1_;
		_tmp1_ = dino_gettext ("Me");
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp2_ = dino_get_real_display_name (stream_interactor, account, jid, _tmp0_);
	result = _tmp2_;
	return result;
}

gchar*
dino_ui_util_get_groupchat_display_name (DinoStreamInteractor* stream_interactor,
                                         DinoEntitiesAccount* account,
                                         XmppJid* jid)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (stream_interactor != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (jid != NULL, NULL);
	_tmp0_ = dino_get_groupchat_display_name (stream_interactor, account, jid);
	result = _tmp0_;
	return result;
}

gchar*
dino_ui_util_get_occupant_display_name (DinoStreamInteractor* stream_interactor,
                                        DinoEntitiesConversation* conversation,
                                        XmppJid* jid,
                                        gboolean me_is_me,
                                        gboolean muc_real_name)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (stream_interactor != NULL, NULL);
	g_return_val_if_fail (conversation != NULL, NULL);
	g_return_val_if_fail (jid != NULL, NULL);
	if (me_is_me) {
		const gchar* _tmp1_;
		_tmp1_ = dino_gettext ("Me");
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp2_ = dino_get_occupant_display_name (stream_interactor, conversation, jid, _tmp0_, FALSE);
	result = _tmp2_;
	return result;
}

void
dino_ui_util_get_label_pango_color (GtkLabel* label,
                                    const gchar* css_color,
                                    GdkRGBA* result)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GdkRGBA color_rgba = {0};
	GtkStyleContext* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	GtkStyleContext* _tmp3_;
	g_return_if_fail (label != NULL);
	g_return_if_fail (css_color != NULL);
	_tmp0_ = dino_ui_util_force_color ((GtkWidget*) label, css_color, "*");
	provider = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) label);
	gtk_style_context_get_color (_tmp1_, &_tmp2_);
	color_rgba = _tmp2_;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) label);
	gtk_style_context_remove_provider (_tmp3_, (GtkStyleProvider*) provider);
	*result = color_rgba;
	_g_object_unref0 (provider);
	return;
}

gchar*
dino_ui_util_rgba_to_hex (GdkRGBA* rgba)
{
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (rgba != NULL, NULL);
	_tmp0_ = *rgba;
	_tmp1_ = *rgba;
	_tmp2_ = *rgba;
	_tmp3_ = *rgba;
	_tmp4_ = g_strdup_printf ("#%02x%02x%02x%02x", (guint) ((guint8) round ((gdouble) (CLAMP (_tmp0_.red, (gfloat) 0, (gfloat) 1) * 255))), (guint) ((guint8) round ((gdouble) (CLAMP (_tmp1_.green, (gfloat) 0, (gfloat) 1) * 255))), (guint) ((guint8) round ((gdouble) (CLAMP (_tmp2_.blue, (gfloat) 0, (gfloat) 1) * 255))), (guint) ((guint8) round ((gdouble) (CLAMP (_tmp3_.alpha, (gfloat) 0, (gfloat) 1) * 255))));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_utf8_strup (_tmp5_, (gssize) -1);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	result = _tmp7_;
	return result;
}

GtkCssProvider*
dino_ui_util_force_css (GtkWidget* widget,
                        const gchar* css)
{
	GtkCssProvider* p = NULL;
	GtkCssProvider* _tmp0_;
	GError* _inner_error0_ = NULL;
	GtkCssProvider* result;
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (css != NULL, NULL);
	_tmp0_ = gtk_css_provider_new ();
	p = _tmp0_;
	{
		GtkStyleContext* _tmp1_;
		gtk_css_provider_load_from_string (p, css);
		_tmp1_ = gtk_widget_get_style_context (widget);
		gtk_style_context_add_provider (_tmp1_, (GtkStyleProvider*) p, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (p);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = p;
	return result;
}

void
dino_ui_util_force_background (GtkWidget* widget,
                               const gchar* color,
                               const gchar* selector)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkCssProvider* _tmp2_;
	GtkCssProvider* _tmp3_;
	g_return_if_fail (widget != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (selector != NULL);
	_tmp0_ = g_strdup_printf (DINO_UI_UTIL_force_background_css, selector, color);
	_tmp1_ = _tmp0_;
	_tmp2_ = dino_ui_util_force_css (widget, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_g_free0 (_tmp1_);
}

GtkCssProvider*
dino_ui_util_force_color (GtkWidget* widget,
                          const gchar* color,
                          const gchar* selector)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkCssProvider* _tmp2_;
	GtkCssProvider* _tmp3_;
	GtkCssProvider* result;
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	g_return_val_if_fail (selector != NULL, NULL);
	_tmp0_ = g_strdup_printf (DINO_UI_UTIL_force_color_css, selector, color);
	_tmp1_ = _tmp0_;
	_tmp2_ = dino_ui_util_force_css (widget, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

void
dino_ui_util_force_error_color (GtkWidget* widget,
                                const gchar* selector)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	g_return_if_fail (widget != NULL);
	g_return_if_fail (selector != NULL);
	_tmp0_ = dino_ui_util_force_color (widget, "@error_color", selector);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}

gboolean
dino_ui_util_is_dark_theme (GtkWidget* widget)
{
	GdkRGBA bg = {0};
	GtkStyleContext* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GdkRGBA _tmp4_;
	gboolean result;
	g_return_val_if_fail (widget != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context (widget);
	gtk_style_context_get_color (_tmp0_, &_tmp1_);
	bg = _tmp1_;
	_tmp4_ = bg;
	if (((gdouble) _tmp4_.red) > 0.5) {
		GdkRGBA _tmp5_;
		_tmp5_ = bg;
		_tmp3_ = ((gdouble) _tmp5_.green) > 0.5;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GdkRGBA _tmp6_;
		_tmp6_ = bg;
		_tmp2_ = ((gdouble) _tmp6_.blue) > 0.5;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	return result;
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gboolean
dino_ui_util_is_24h_format (void)
{
	gboolean result;
	if (((gint) dino_ui_util_is24h) == 0) {
		GRegex* has_ampm = NULL;
		GRegex* _tmp0_;
		GRegex* has_t_fmt_ampm = NULL;
		GRegex* _tmp1_;
		const gchar* t_fmt = NULL;
		const gchar* _tmp2_;
		const gchar* t_fmt_ampm = NULL;
		const gchar* _tmp3_;
		gboolean has_am_str = FALSE;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		gboolean has_pm_str = FALSE;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		gint _tmp12_ = 0;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		GRegex* _tmp15_;
		const gchar* _tmp16_;
		_tmp0_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "(^|[^%])%[pP]", 0));
		has_ampm = _tmp0_;
		_tmp1_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_1, "(^|[^%])%r", 0));
		has_t_fmt_ampm = _tmp1_;
		_tmp2_ = nl_langinfo (T_FMT);
		t_fmt = _tmp2_;
		_tmp3_ = nl_langinfo (T_FMT_AMPM);
		t_fmt_ampm = _tmp3_;
		_tmp4_ = nl_langinfo (AM_STR);
		_tmp5_ = string_strip (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "") != 0;
		_g_free0 (_tmp6_);
		has_am_str = _tmp7_;
		_tmp8_ = nl_langinfo (PM_STR);
		_tmp9_ = string_strip (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strcmp0 (_tmp10_, "") != 0;
		_g_free0 (_tmp10_);
		has_pm_str = _tmp11_;
		_tmp15_ = has_ampm;
		_tmp16_ = t_fmt;
		if (g_regex_match (_tmp15_, _tmp16_, 0, NULL)) {
			_tmp14_ = TRUE;
		} else {
			gboolean _tmp17_ = FALSE;
			GRegex* _tmp18_;
			const gchar* _tmp19_;
			_tmp18_ = has_t_fmt_ampm;
			_tmp19_ = t_fmt;
			if (g_regex_match (_tmp18_, _tmp19_, 0, NULL)) {
				GRegex* _tmp20_;
				const gchar* _tmp21_;
				_tmp20_ = has_ampm;
				_tmp21_ = t_fmt_ampm;
				_tmp17_ = g_regex_match (_tmp20_, _tmp21_, 0, NULL);
			} else {
				_tmp17_ = FALSE;
			}
			_tmp14_ = _tmp17_;
		}
		if (_tmp14_) {
			gboolean _tmp22_ = FALSE;
			if (has_am_str) {
				_tmp22_ = TRUE;
			} else {
				_tmp22_ = has_pm_str;
			}
			_tmp13_ = _tmp22_;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			_tmp12_ = -1;
		} else {
			_tmp12_ = 1;
		}
		dino_ui_util_is24h = (gint8) _tmp12_;
		_g_regex_unref0 (has_t_fmt_ampm);
		_g_regex_unref0 (has_ampm);
	}
	result = ((gint) dino_ui_util_is24h) == 1;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
dino_ui_util_format_time (GDateTime* datetime,
                          const gchar* format_24h,
                          const gchar* format_12h)
{
	const gchar* _tmp0_ = NULL;
	gchar* format = NULL;
	gchar* _tmp1_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (datetime != NULL, NULL);
	g_return_val_if_fail (format_24h != NULL, NULL);
	g_return_val_if_fail (format_12h != NULL, NULL);
	if (dino_ui_util_is_24h_format ()) {
		_tmp0_ = format_24h;
	} else {
		_tmp0_ = format_12h;
	}
	_tmp1_ = g_strdup (_tmp0_);
	format = _tmp1_;
	if (!g_get_charset (NULL)) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = format;
		_tmp3_ = string_replace (_tmp2_, "∶", ":");
		_g_free0 (format);
		format = _tmp3_;
	}
	_tmp4_ = format;
	_tmp5_ = g_date_time_format (datetime, _tmp4_);
	result = _tmp5_;
	_g_free0 (format);
	return result;
}

GRegex*
dino_ui_util_get_url_regex (void)
{
	GRegex* _tmp0_;
	GRegex* _tmp2_;
	GRegex* _tmp3_;
	GRegex* result;
	_tmp0_ = dino_ui_util_URL_REGEX;
	if (_tmp0_ == NULL) {
		GRegex* _tmp1_;
		_tmp1_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_2, "\\b(((http|ftp)s?:\\/\\/|(ircs?|xmpp|mailto|sms|smsto|mms|tel|geo|openpgp4fpr|im|news|nntp|sip|ssh|bitcoin|sftp|magnet|vnc|urn):)\\S+)", 0));
		_g_regex_unref0 (dino_ui_util_URL_REGEX);
		dino_ui_util_URL_REGEX = _tmp1_;
	}
	_tmp2_ = dino_ui_util_URL_REGEX;
	_tmp3_ = _g_regex_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

GeeMap*
dino_ui_util_get_matching_chars (void)
{
	GeeMap* _tmp0_;
	GeeMap* _tmp5_;
	GeeMap* _tmp6_;
	GeeMap* result;
	_tmp0_ = dino_ui_util_MATCHING_CHARS;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		GeeMap* _tmp2_;
		GeeMap* _tmp3_;
		GeeMap* _tmp4_;
		_tmp1_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (dino_ui_util_MATCHING_CHARS);
		dino_ui_util_MATCHING_CHARS = (GeeMap*) _tmp1_;
		_tmp2_ = dino_ui_util_MATCHING_CHARS;
		gee_map_set (_tmp2_, (gpointer) ((gintptr) string_get_char (")", (glong) 0)), (gpointer) ((gintptr) string_get_char ("(", (glong) 0)));
		_tmp3_ = dino_ui_util_MATCHING_CHARS;
		gee_map_set (_tmp3_, (gpointer) ((gintptr) string_get_char ("]", (glong) 0)), (gpointer) ((gintptr) string_get_char ("[", (glong) 0)));
		_tmp4_ = dino_ui_util_MATCHING_CHARS;
		gee_map_set (_tmp4_, (gpointer) ((gintptr) string_get_char ("}", (glong) 0)), (gpointer) ((gintptr) string_get_char ("{", (glong) 0)));
	}
	_tmp5_ = dino_ui_util_MATCHING_CHARS;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	result = _tmp6_;
	return result;
}

/**
 * This replaces spaces with non-breaking spaces when they are adjacent to a non-spacing mark.
 *
 * We do this to work-around a bug in Pango. See https://gitlab.gnome.org/GNOME/pango/-/issues/798 and
 * https://gitlab.gnome.org/GNOME/pango/-/issues/832
 *
 * This is zero-copy iff no space is adjacent to a non-spacing mark, otherwise the provided string will be destroyed
 * and the returned string should be used instead.
 */
static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
dino_ui_util_unbreak_space_around_non_spacing_mark (gchar* s)
{
	gint current_index = 0;
	gunichar current_char = 0U;
	gint prev_index = 0;
	gunichar prev_char = 0U;
	gboolean is_non_spacing_mark = FALSE;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (s != NULL, NULL);
	current_index = 0;
	current_char = (gunichar) 0;
	prev_index = 0;
	prev_char = (gunichar) 0;
	is_non_spacing_mark = FALSE;
	while (TRUE) {
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		gint replace_index = 0;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = string_get_next_char (s, &current_index, &_tmp0_);
		current_char = _tmp0_;
		if (!_tmp1_) {
			break;
		}
		replace_index = -1;
		if (is_non_spacing_mark) {
			_tmp2_ = current_char == ((gunichar) ' ');
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			replace_index = prev_index;
			current_char = 160U;
		}
		is_non_spacing_mark = u_getIntPropertyValue (current_char, UCHAR_BIDI_CLASS) == ((gint32) U_DIR_NON_SPACING_MARK);
		if (prev_char == ((gunichar) ' ')) {
			_tmp3_ = is_non_spacing_mark;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			replace_index = prev_index - 1;
		}
		if (replace_index != -1) {
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp4_ = string_slice (s, (glong) 0, (glong) replace_index);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strconcat (_tmp5_, " ", NULL);
			_tmp7_ = _tmp6_;
			_tmp8_ = strlen (s);
			_tmp9_ = _tmp8_;
			_tmp10_ = string_slice (s, (glong) (replace_index + 1), (glong) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strconcat (_tmp7_, _tmp11_, NULL);
			_g_free0 (s);
			s = _tmp12_;
			_g_free0 (_tmp11_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
			current_index += 1;
		}
		prev_index = current_index;
		prev_char = current_char;
	}
	_tmp13_ = s;
	s = NULL;
	result = _tmp13_;
	_g_free0 (s);
	return result;
}

gchar*
dino_ui_util_parse_add_markup (const gchar* s_,
                               const gchar* highlight_word,
                               gboolean parse_links,
                               gboolean parse_text_markup)
{
	gboolean ignore_out_var = FALSE;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (s_ != NULL, NULL);
	ignore_out_var = FALSE;
	_tmp0_ = dino_ui_util_parse_add_markup_theme (s_, highlight_word, parse_links, parse_text_markup, parse_text_markup, FALSE, &ignore_out_var, FALSE);
	result = _tmp0_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 < (*index)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static gboolean
_vala_unichar_array_contains (gunichar * stack,
                              gssize stack_length,
                              const gunichar needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

gchar*
dino_ui_util_parse_add_markup_theme (const gchar* s_,
                                     const gchar* highlight_word,
                                     gboolean parse_links,
                                     gboolean parse_text_markup,
                                     gboolean parse_quotes,
                                     gboolean dark_theme,
                                     gboolean* theme_dependent,
                                     gboolean already_escaped_)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	gboolean already_escaped = FALSE;
	gboolean _tmp61_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (s_ != NULL, NULL);
	_tmp0_ = g_strdup (s_);
	s = _tmp0_;
	already_escaped = already_escaped_;
	if (parse_quotes) {
		const gchar* _tmp1_ = NULL;
		gchar* gt = NULL;
		gchar* _tmp2_;
		GRegex* quote_regex = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GRegex* _tmp13_;
		GRegex* _tmp14_;
		GMatchInfo* quote_match_info = NULL;
		GRegex* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GMatchInfo* _tmp19_ = NULL;
		GMatchInfo* _tmp20_;
		if (already_escaped) {
			_tmp1_ = "&gt;";
		} else {
			_tmp1_ = ">";
		}
		_tmp2_ = g_strdup (_tmp1_);
		gt = _tmp2_;
		_tmp3_ = gt;
		_tmp4_ = g_strconcat ("((?<=\n)", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, ".*(\n|$))|(^", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = gt;
		_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, ".*(\n|$))", NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_regex_new (_tmp12_, 0, 0, &_inner_error0_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		quote_regex = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (gt);
			_g_free0 (s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp15_ = quote_regex;
		_tmp16_ = s;
		_tmp17_ = g_utf8_strdown (_tmp16_, (gssize) -1);
		_tmp18_ = _tmp17_;
		g_regex_match (_tmp15_, _tmp18_, 0, &_tmp19_);
		_g_match_info_unref0 (quote_match_info);
		quote_match_info = _tmp19_;
		_g_free0 (_tmp18_);
		_tmp20_ = quote_match_info;
		if (g_match_info_matches (_tmp20_)) {
			gint start = 0;
			gint end = 0;
			const gchar* _tmp21_ = NULL;
			gchar* dim_color = NULL;
			gchar* _tmp22_;
			GMatchInfo* _tmp23_;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			if (dark_theme) {
				_tmp21_ = "#BDBDBD";
			} else {
				_tmp21_ = "#707070";
			}
			_tmp22_ = g_strdup (_tmp21_);
			dim_color = _tmp22_;
			*theme_dependent = TRUE;
			_tmp23_ = quote_match_info;
			g_match_info_fetch_pos (_tmp23_, 0, &_tmp24_, &_tmp25_);
			start = _tmp24_;
			end = _tmp25_;
			_tmp26_ = s;
			_tmp27_ = string_slice (_tmp26_, (glong) 0, (glong) start);
			_tmp28_ = _tmp27_;
			_tmp29_ = dino_ui_util_parse_add_markup_theme (_tmp28_, highlight_word, parse_links, parse_text_markup, parse_quotes, dark_theme, theme_dependent, already_escaped);
			_tmp30_ = _tmp29_;
			_tmp31_ = dim_color;
			_tmp32_ = string_to_string (_tmp31_);
			_tmp33_ = gt;
			_tmp34_ = string_to_string (_tmp33_);
			_tmp35_ = g_strconcat ("<span color='", _tmp32_, "'>", _tmp34_, NULL);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_strconcat (_tmp30_, _tmp36_, NULL);
			_tmp38_ = _tmp37_;
			_tmp39_ = s;
			_tmp40_ = gt;
			_tmp41_ = strlen (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = string_slice (_tmp39_, (glong) (start + _tmp42_), (glong) end);
			_tmp44_ = _tmp43_;
			_tmp45_ = dino_ui_util_parse_add_markup_theme (_tmp44_, highlight_word, parse_links, parse_text_markup, FALSE, dark_theme, theme_dependent, already_escaped);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strconcat (_tmp38_, _tmp46_, NULL);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_strconcat (_tmp48_, "</span>", NULL);
			_tmp50_ = _tmp49_;
			_tmp51_ = s;
			_tmp52_ = s;
			_tmp53_ = strlen (_tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = string_slice (_tmp51_, (glong) end, (glong) _tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = dino_ui_util_parse_add_markup_theme (_tmp56_, highlight_word, parse_links, parse_text_markup, parse_quotes, dark_theme, theme_dependent, already_escaped);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strconcat (_tmp50_, _tmp58_, NULL);
			_tmp60_ = _tmp59_;
			_g_free0 (_tmp58_);
			_g_free0 (_tmp56_);
			_g_free0 (_tmp50_);
			_g_free0 (_tmp48_);
			_g_free0 (_tmp46_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp38_);
			_g_free0 (_tmp36_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
			result = _tmp60_;
			_g_free0 (dim_color);
			_g_match_info_unref0 (quote_match_info);
			_g_regex_unref0 (quote_regex);
			_g_free0 (gt);
			_g_free0 (s);
			return result;
		}
		_g_match_info_unref0 (quote_match_info);
		_g_regex_unref0 (quote_regex);
		_g_free0 (gt);
	}
	if (parse_links) {
		_tmp61_ = !already_escaped;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		GMatchInfo* match_info = NULL;
		GRegex* _tmp62_;
		GRegex* _tmp63_;
		const gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		GMatchInfo* _tmp67_ = NULL;
		_tmp62_ = dino_ui_util_get_url_regex ();
		_tmp63_ = _tmp62_;
		_tmp64_ = s;
		_tmp65_ = g_utf8_strdown (_tmp64_, (gssize) -1);
		_tmp66_ = _tmp65_;
		g_regex_match (_tmp63_, _tmp66_, 0, &_tmp67_);
		_g_match_info_unref0 (match_info);
		match_info = _tmp67_;
		_g_free0 (_tmp66_);
		_g_regex_unref0 (_tmp63_);
		while (TRUE) {
			GMatchInfo* _tmp68_;
			gint start = 0;
			gint end = 0;
			GMatchInfo* _tmp69_;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			gchar* link = NULL;
			const gchar* _tmp72_;
			gchar* _tmp73_;
			const gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gboolean _tmp77_;
			GMatchInfo* _tmp136_;
			_tmp68_ = match_info;
			if (!g_match_info_matches (_tmp68_)) {
				break;
			}
			_tmp69_ = match_info;
			g_match_info_fetch_pos (_tmp69_, 0, &_tmp70_, &_tmp71_);
			start = _tmp70_;
			end = _tmp71_;
			_tmp72_ = s;
			_tmp73_ = string_slice (_tmp72_, (glong) start, (glong) end);
			link = _tmp73_;
			_tmp74_ = link;
			_tmp75_ = g_uri_parse_scheme (_tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = _vala_string_array_contains (DINO_UI_UTIL_ALLOWED_SCHEMAS, G_N_ELEMENTS (DINO_UI_UTIL_ALLOWED_SCHEMAS), _tmp76_);
			_g_free0 (_tmp76_);
			if (_tmp77_) {
				GeeMap* matching_chars = NULL;
				GeeMap* _tmp78_;
				gunichar close_char = 0U;
				gint last_char_index = 0;
				const gchar* _tmp79_;
				gint _tmp80_;
				gint _tmp81_;
				const gchar* _tmp105_;
				gchar* _tmp106_;
				gchar* _tmp107_;
				gchar* _tmp108_;
				gchar* _tmp109_;
				gchar* _tmp110_;
				gchar* _tmp111_;
				const gchar* _tmp112_;
				gchar* _tmp113_;
				gchar* _tmp114_;
				gchar* _tmp115_;
				gchar* _tmp116_;
				gchar* _tmp117_;
				gchar* _tmp118_;
				const gchar* _tmp119_;
				gchar* _tmp120_;
				gchar* _tmp121_;
				gchar* _tmp122_;
				gchar* _tmp123_;
				gchar* _tmp124_;
				gchar* _tmp125_;
				const gchar* _tmp126_;
				const gchar* _tmp127_;
				gint _tmp128_;
				gint _tmp129_;
				gchar* _tmp130_;
				gchar* _tmp131_;
				gchar* _tmp132_;
				gchar* _tmp133_;
				gchar* _tmp134_;
				gchar* _tmp135_;
				_tmp78_ = dino_ui_util_get_matching_chars ();
				matching_chars = _tmp78_;
				_tmp79_ = link;
				_tmp80_ = strlen (_tmp79_);
				_tmp81_ = _tmp80_;
				last_char_index = _tmp81_;
				while (TRUE) {
					const gchar* _tmp82_;
					gunichar _tmp83_ = 0U;
					gboolean _tmp84_;
					GeeMap* _tmp85_;
					_tmp82_ = link;
					_tmp84_ = string_get_prev_char (_tmp82_, &last_char_index, &_tmp83_);
					close_char = _tmp83_;
					if (!_tmp84_) {
						break;
					}
					_tmp85_ = matching_chars;
					if (gee_map_has_key (_tmp85_, (gpointer) ((gintptr) close_char))) {
						gunichar open_char = 0U;
						GeeMap* _tmp86_;
						gpointer _tmp87_;
						gunichar _char_ = 0U;
						gint index = 0;
						gint open = 0;
						gint close = 0;
						_tmp86_ = matching_chars;
						_tmp87_ = gee_map_get (_tmp86_, (gpointer) ((gintptr) close_char));
						open_char = (gunichar) ((gintptr) _tmp87_);
						index = 0;
						open = 0;
						close = 0;
						while (TRUE) {
							const gchar* _tmp88_;
							gunichar _tmp89_ = 0U;
							gboolean _tmp90_;
							_tmp88_ = link;
							_tmp90_ = string_get_next_char (_tmp88_, &index, &_tmp89_);
							_char_ = _tmp89_;
							if (!_tmp90_) {
								break;
							}
							if (_char_ == open_char) {
								gint _tmp91_;
								_tmp91_ = open;
								open = _tmp91_ + 1;
							} else {
								if (_char_ == close_char) {
									gint _tmp92_;
									_tmp92_ = close;
									close = _tmp92_ + 1;
								}
							}
						}
						if (close > open) {
							gchar* _tmp93_;
							gchar* _tmp94_;
							gint _tmp95_;
							gint _tmp96_;
							const gchar* _tmp97_;
							gchar* _tmp98_;
							_tmp93_ = g_unichar_to_string (close_char);
							_tmp94_ = _tmp93_;
							_tmp95_ = strlen (_tmp94_);
							_tmp96_ = _tmp95_;
							end -= _tmp96_;
							_g_free0 (_tmp94_);
							_tmp97_ = s;
							_tmp98_ = string_slice (_tmp97_, (glong) start, (glong) end);
							_g_free0 (link);
							link = _tmp98_;
						} else {
							break;
						}
					} else {
						if (_vala_unichar_array_contains (DINO_UI_UTIL_NON_TRAILING_CHARS, G_N_ELEMENTS (DINO_UI_UTIL_NON_TRAILING_CHARS), close_char)) {
							gchar* _tmp99_;
							gchar* _tmp100_;
							gint _tmp101_;
							gint _tmp102_;
							const gchar* _tmp103_;
							gchar* _tmp104_;
							_tmp99_ = g_unichar_to_string (close_char);
							_tmp100_ = _tmp99_;
							_tmp101_ = strlen (_tmp100_);
							_tmp102_ = _tmp101_;
							end -= _tmp102_;
							_g_free0 (_tmp100_);
							_tmp103_ = s;
							_tmp104_ = string_slice (_tmp103_, (glong) start, (glong) end);
							_g_free0 (link);
							link = _tmp104_;
						} else {
							break;
						}
					}
				}
				_tmp105_ = s;
				_tmp106_ = string_slice (_tmp105_, (glong) 0, (glong) start);
				_tmp107_ = _tmp106_;
				_tmp108_ = dino_ui_util_parse_add_markup_theme (_tmp107_, highlight_word, parse_links, parse_text_markup, FALSE, dark_theme, theme_dependent, already_escaped);
				_tmp109_ = _tmp108_;
				_tmp110_ = g_strconcat (_tmp109_, "<a href=\"", NULL);
				_tmp111_ = _tmp110_;
				_tmp112_ = link;
				_tmp113_ = g_markup_escape_text (_tmp112_, (gssize) -1);
				_tmp114_ = _tmp113_;
				_tmp115_ = g_strconcat (_tmp111_, _tmp114_, NULL);
				_tmp116_ = _tmp115_;
				_tmp117_ = g_strconcat (_tmp116_, "\">", NULL);
				_tmp118_ = _tmp117_;
				_tmp119_ = link;
				_tmp120_ = dino_ui_util_parse_add_markup_theme (_tmp119_, highlight_word, FALSE, FALSE, FALSE, dark_theme, theme_dependent, already_escaped);
				_tmp121_ = _tmp120_;
				_tmp122_ = g_strconcat (_tmp118_, _tmp121_, NULL);
				_tmp123_ = _tmp122_;
				_tmp124_ = g_strconcat (_tmp123_, "</a>", NULL);
				_tmp125_ = _tmp124_;
				_tmp126_ = s;
				_tmp127_ = s;
				_tmp128_ = strlen (_tmp127_);
				_tmp129_ = _tmp128_;
				_tmp130_ = string_slice (_tmp126_, (glong) end, (glong) _tmp129_);
				_tmp131_ = _tmp130_;
				_tmp132_ = dino_ui_util_parse_add_markup_theme (_tmp131_, highlight_word, parse_links, parse_text_markup, FALSE, dark_theme, theme_dependent, already_escaped);
				_tmp133_ = _tmp132_;
				_tmp134_ = g_strconcat (_tmp125_, _tmp133_, NULL);
				_tmp135_ = _tmp134_;
				_g_free0 (_tmp133_);
				_g_free0 (_tmp131_);
				_g_free0 (_tmp125_);
				_g_free0 (_tmp123_);
				_g_free0 (_tmp121_);
				_g_free0 (_tmp118_);
				_g_free0 (_tmp116_);
				_g_free0 (_tmp114_);
				_g_free0 (_tmp111_);
				_g_free0 (_tmp109_);
				_g_free0 (_tmp107_);
				result = _tmp135_;
				_g_object_unref0 (matching_chars);
				_g_free0 (link);
				_g_match_info_unref0 (match_info);
				_g_free0 (s);
				return result;
			}
			_tmp136_ = match_info;
			g_match_info_next (_tmp136_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (link);
				_g_match_info_unref0 (match_info);
				_g_free0 (s);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_free0 (link);
		}
		_g_match_info_unref0 (match_info);
	}
	if (!already_escaped) {
		const gchar* _tmp137_;
		gchar* _tmp138_;
		_tmp137_ = s;
		_tmp138_ = g_markup_escape_text (_tmp137_, (gssize) -1);
		_g_free0 (s);
		s = _tmp138_;
		already_escaped = TRUE;
	}
	if (highlight_word != NULL) {
		{
			GRegex* highlight_regex = NULL;
			gchar* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			GRegex* _tmp147_;
			GRegex* _tmp148_;
			GMatchInfo* match_info = NULL;
			GRegex* _tmp149_;
			const gchar* _tmp150_;
			gchar* _tmp151_;
			gchar* _tmp152_;
			GMatchInfo* _tmp153_ = NULL;
			GMatchInfo* _tmp154_;
			_tmp139_ = g_utf8_strdown (highlight_word, (gssize) -1);
			_tmp140_ = _tmp139_;
			_tmp141_ = g_regex_escape_string (_tmp140_, -1);
			_tmp142_ = _tmp141_;
			_tmp143_ = g_strconcat ("\\b", _tmp142_, NULL);
			_tmp144_ = _tmp143_;
			_tmp145_ = g_strconcat (_tmp144_, "\\b", NULL);
			_tmp146_ = _tmp145_;
			_tmp147_ = g_regex_new (_tmp146_, 0, 0, &_inner_error0_);
			_tmp148_ = _tmp147_;
			_g_free0 (_tmp146_);
			_g_free0 (_tmp144_);
			_g_free0 (_tmp142_);
			_g_free0 (_tmp140_);
			highlight_regex = _tmp148_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				_g_free0 (s);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp149_ = highlight_regex;
			_tmp150_ = s;
			_tmp151_ = g_utf8_strdown (_tmp150_, (gssize) -1);
			_tmp152_ = _tmp151_;
			g_regex_match (_tmp149_, _tmp152_, 0, &_tmp153_);
			_g_match_info_unref0 (match_info);
			match_info = _tmp153_;
			_g_free0 (_tmp152_);
			_tmp154_ = match_info;
			if (g_match_info_matches (_tmp154_)) {
				gint start = 0;
				gint end = 0;
				GMatchInfo* _tmp155_;
				gint _tmp156_ = 0;
				gint _tmp157_ = 0;
				const gchar* _tmp158_;
				gchar* _tmp159_;
				gchar* _tmp160_;
				gchar* _tmp161_;
				gchar* _tmp162_;
				gchar* _tmp163_;
				gchar* _tmp164_;
				const gchar* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				gchar* _tmp170_;
				gchar* _tmp171_;
				const gchar* _tmp172_;
				const gchar* _tmp173_;
				gint _tmp174_;
				gint _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				gchar* _tmp181_;
				_tmp155_ = match_info;
				g_match_info_fetch_pos (_tmp155_, 0, &_tmp156_, &_tmp157_);
				start = _tmp156_;
				end = _tmp157_;
				_tmp158_ = s;
				_tmp159_ = string_slice (_tmp158_, (glong) 0, (glong) start);
				_tmp160_ = _tmp159_;
				_tmp161_ = dino_ui_util_parse_add_markup_theme (_tmp160_, highlight_word, parse_links, parse_text_markup, FALSE, dark_theme, theme_dependent, already_escaped);
				_tmp162_ = _tmp161_;
				_tmp163_ = g_strconcat (_tmp162_, "<b>", NULL);
				_tmp164_ = _tmp163_;
				_tmp165_ = s;
				_tmp166_ = string_slice (_tmp165_, (glong) start, (glong) end);
				_tmp167_ = _tmp166_;
				_tmp168_ = g_strconcat (_tmp164_, _tmp167_, NULL);
				_tmp169_ = _tmp168_;
				_tmp170_ = g_strconcat (_tmp169_, "</b>", NULL);
				_tmp171_ = _tmp170_;
				_tmp172_ = s;
				_tmp173_ = s;
				_tmp174_ = strlen (_tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = string_slice (_tmp172_, (glong) end, (glong) _tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = dino_ui_util_parse_add_markup_theme (_tmp177_, highlight_word, parse_links, parse_text_markup, FALSE, dark_theme, theme_dependent, already_escaped);
				_tmp179_ = _tmp178_;
				_tmp180_ = g_strconcat (_tmp171_, _tmp179_, NULL);
				_tmp181_ = _tmp180_;
				_g_free0 (_tmp179_);
				_g_free0 (_tmp177_);
				_g_free0 (_tmp171_);
				_g_free0 (_tmp169_);
				_g_free0 (_tmp167_);
				_g_free0 (_tmp164_);
				_g_free0 (_tmp162_);
				_g_free0 (_tmp160_);
				result = _tmp181_;
				_g_match_info_unref0 (match_info);
				_g_regex_unref0 (highlight_regex);
				_g_free0 (s);
				return result;
			}
			_g_match_info_unref0 (match_info);
			_g_regex_unref0 (highlight_regex);
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			g_clear_error (&_inner_error0_);
			g_assert_not_reached ();
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (parse_text_markup) {
		gchar** markup_string = NULL;
		gchar* _tmp182_;
		gchar* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		gchar** _tmp186_;
		gint markup_string_length1;
		gint _markup_string_size_;
		gchar** convenience_tag = NULL;
		gchar* _tmp187_;
		gchar* _tmp188_;
		gchar* _tmp189_;
		gchar* _tmp190_;
		gchar** _tmp191_;
		gint convenience_tag_length1;
		gint _convenience_tag_size_;
		_tmp182_ = g_strdup ("`");
		_tmp183_ = g_strdup ("_");
		_tmp184_ = g_strdup ("*");
		_tmp185_ = g_strdup ("~");
		_tmp186_ = g_new0 (gchar*, 4 + 1);
		_tmp186_[0] = _tmp182_;
		_tmp186_[1] = _tmp183_;
		_tmp186_[2] = _tmp184_;
		_tmp186_[3] = _tmp185_;
		markup_string = _tmp186_;
		markup_string_length1 = 4;
		_markup_string_size_ = markup_string_length1;
		_tmp187_ = g_strdup ("tt");
		_tmp188_ = g_strdup ("i");
		_tmp189_ = g_strdup ("b");
		_tmp190_ = g_strdup ("s");
		_tmp191_ = g_new0 (gchar*, 4 + 1);
		_tmp191_[0] = _tmp187_;
		_tmp191_[1] = _tmp188_;
		_tmp191_[2] = _tmp189_;
		_tmp191_[3] = _tmp190_;
		convenience_tag = _tmp191_;
		convenience_tag_length1 = 4;
		_convenience_tag_size_ = convenience_tag_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp192_ = FALSE;
				_tmp192_ = TRUE;
				while (TRUE) {
					gchar** _tmp194_;
					gint _tmp194__length1;
					gchar* markup_esc = NULL;
					gchar** _tmp195_;
					gint _tmp195__length1;
					const gchar* _tmp196_;
					gchar* _tmp197_;
					if (!_tmp192_) {
						gint _tmp193_;
						_tmp193_ = i;
						i = _tmp193_ + 1;
					}
					_tmp192_ = FALSE;
					_tmp194_ = markup_string;
					_tmp194__length1 = markup_string_length1;
					if (!(i < _tmp194__length1)) {
						break;
					}
					_tmp195_ = markup_string;
					_tmp195__length1 = markup_string_length1;
					_tmp196_ = _tmp195_[i];
					_tmp197_ = g_regex_escape_string (_tmp196_, -1);
					markup_esc = _tmp197_;
					{
						GRegex* regex = NULL;
						const gchar* _tmp198_;
						gchar* _tmp199_;
						gchar* _tmp200_;
						gchar* _tmp201_;
						gchar* _tmp202_;
						const gchar* _tmp203_;
						gchar* _tmp204_;
						gchar* _tmp205_;
						GRegex* _tmp206_;
						GRegex* _tmp207_;
						GMatchInfo* match_info = NULL;
						GRegex* _tmp208_;
						const gchar* _tmp209_;
						gchar* _tmp210_;
						gchar* _tmp211_;
						GMatchInfo* _tmp212_ = NULL;
						GMatchInfo* _tmp213_;
						_tmp198_ = markup_esc;
						_tmp199_ = g_strconcat ("(^|\\s)", _tmp198_, NULL);
						_tmp200_ = _tmp199_;
						_tmp201_ = g_strconcat (_tmp200_, "(\\S|\\S.*?\\S)", NULL);
						_tmp202_ = _tmp201_;
						_tmp203_ = markup_esc;
						_tmp204_ = g_strconcat (_tmp202_, _tmp203_, NULL);
						_tmp205_ = _tmp204_;
						_tmp206_ = g_regex_new (_tmp205_, 0, 0, &_inner_error0_);
						_tmp207_ = _tmp206_;
						_g_free0 (_tmp205_);
						_g_free0 (_tmp202_);
						_g_free0 (_tmp200_);
						regex = _tmp207_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == G_REGEX_ERROR) {
								goto __catch1_g_regex_error;
							}
							_g_free0 (markup_esc);
							convenience_tag = (_vala_array_free (convenience_tag, convenience_tag_length1, (GDestroyNotify) g_free), NULL);
							markup_string = (_vala_array_free (markup_string, markup_string_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (s);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
						_tmp208_ = regex;
						_tmp209_ = s;
						_tmp210_ = g_utf8_strdown (_tmp209_, (gssize) -1);
						_tmp211_ = _tmp210_;
						g_regex_match (_tmp208_, _tmp211_, 0, &_tmp212_);
						_g_match_info_unref0 (match_info);
						match_info = _tmp212_;
						_g_free0 (_tmp211_);
						_tmp213_ = match_info;
						if (g_match_info_matches (_tmp213_)) {
							gint start = 0;
							gint end = 0;
							GMatchInfo* _tmp214_;
							gint _tmp215_ = 0;
							gint _tmp216_ = 0;
							const gchar* _tmp217_;
							gchar* _tmp218_;
							gchar* _tmp219_;
							gchar* _tmp220_;
							gchar* _tmp221_;
							gchar* _tmp222_;
							gchar* _tmp223_;
							const gchar* _tmp224_;
							gchar* _tmp225_;
							gchar* _tmp226_;
							gchar* _tmp227_;
							gchar* _tmp228_;
							gchar* _tmp229_;
							gchar* _tmp230_;
							gchar** _tmp231_;
							gint _tmp231__length1;
							const gchar* _tmp232_;
							const gchar* _tmp233_;
							gchar* _tmp234_;
							gchar* _tmp235_;
							gchar* _tmp236_;
							gchar* _tmp237_;
							const gchar* _tmp238_;
							gchar* _tmp239_;
							gchar* _tmp240_;
							gchar* _tmp241_;
							gchar* _tmp242_;
							gchar** _tmp243_;
							gint _tmp243__length1;
							const gchar* _tmp244_;
							const gchar* _tmp245_;
							gchar* _tmp246_;
							gchar* _tmp247_;
							gchar* _tmp248_;
							gchar* _tmp249_;
							gchar* _tmp250_;
							gchar* _tmp251_;
							const gchar* _tmp252_;
							gchar* _tmp253_;
							gchar* _tmp254_;
							gchar* _tmp255_;
							gchar* _tmp256_;
							gchar* _tmp257_;
							gchar* _tmp258_;
							const gchar* _tmp259_;
							const gchar* _tmp260_;
							gint _tmp261_;
							gint _tmp262_;
							gchar* _tmp263_;
							gchar* _tmp264_;
							gchar* _tmp265_;
							gchar* _tmp266_;
							gchar* _tmp267_;
							gchar* _tmp268_;
							_tmp214_ = match_info;
							g_match_info_fetch_pos (_tmp214_, 2, &_tmp215_, &_tmp216_);
							start = _tmp215_;
							end = _tmp216_;
							_tmp217_ = s;
							_tmp218_ = string_slice (_tmp217_, (glong) 0, (glong) (start - 1));
							_tmp219_ = _tmp218_;
							_tmp220_ = dino_ui_util_parse_add_markup_theme (_tmp219_, highlight_word, parse_links, parse_text_markup, FALSE, dark_theme, theme_dependent, already_escaped);
							_tmp221_ = _tmp220_;
							_tmp222_ = g_strconcat (_tmp221_, "<span color='#9E9E9E'>", NULL);
							_tmp223_ = _tmp222_;
							_tmp224_ = s;
							_tmp225_ = string_slice (_tmp224_, (glong) (start - 1), (glong) start);
							_tmp226_ = _tmp225_;
							_tmp227_ = g_strconcat (_tmp223_, _tmp226_, NULL);
							_tmp228_ = _tmp227_;
							_tmp229_ = g_strconcat (_tmp228_, "</span>", NULL);
							_tmp230_ = _tmp229_;
							_tmp231_ = convenience_tag;
							_tmp231__length1 = convenience_tag_length1;
							_tmp232_ = _tmp231_[i];
							_tmp233_ = string_to_string (_tmp232_);
							_tmp234_ = g_strconcat ("<", _tmp233_, ">", NULL);
							_tmp235_ = _tmp234_;
							_tmp236_ = g_strconcat (_tmp230_, _tmp235_, NULL);
							_tmp237_ = _tmp236_;
							_tmp238_ = s;
							_tmp239_ = string_slice (_tmp238_, (glong) start, (glong) end);
							_tmp240_ = _tmp239_;
							_tmp241_ = g_strconcat (_tmp237_, _tmp240_, NULL);
							_tmp242_ = _tmp241_;
							_tmp243_ = convenience_tag;
							_tmp243__length1 = convenience_tag_length1;
							_tmp244_ = _tmp243_[i];
							_tmp245_ = string_to_string (_tmp244_);
							_tmp246_ = g_strconcat ("</", _tmp245_, ">", NULL);
							_tmp247_ = _tmp246_;
							_tmp248_ = g_strconcat (_tmp242_, _tmp247_, NULL);
							_tmp249_ = _tmp248_;
							_tmp250_ = g_strconcat (_tmp249_, "<span color='#9E9E9E'>", NULL);
							_tmp251_ = _tmp250_;
							_tmp252_ = s;
							_tmp253_ = string_slice (_tmp252_, (glong) end, (glong) (end + 1));
							_tmp254_ = _tmp253_;
							_tmp255_ = g_strconcat (_tmp251_, _tmp254_, NULL);
							_tmp256_ = _tmp255_;
							_tmp257_ = g_strconcat (_tmp256_, "</span>", NULL);
							_tmp258_ = _tmp257_;
							_tmp259_ = s;
							_tmp260_ = s;
							_tmp261_ = strlen (_tmp260_);
							_tmp262_ = _tmp261_;
							_tmp263_ = string_slice (_tmp259_, (glong) (end + 1), (glong) _tmp262_);
							_tmp264_ = _tmp263_;
							_tmp265_ = dino_ui_util_parse_add_markup_theme (_tmp264_, highlight_word, parse_links, parse_text_markup, FALSE, dark_theme, theme_dependent, already_escaped);
							_tmp266_ = _tmp265_;
							_tmp267_ = g_strconcat (_tmp258_, _tmp266_, NULL);
							_tmp268_ = _tmp267_;
							_g_free0 (_tmp266_);
							_g_free0 (_tmp264_);
							_g_free0 (_tmp258_);
							_g_free0 (_tmp256_);
							_g_free0 (_tmp254_);
							_g_free0 (_tmp251_);
							_g_free0 (_tmp249_);
							_g_free0 (_tmp247_);
							_g_free0 (_tmp242_);
							_g_free0 (_tmp240_);
							_g_free0 (_tmp237_);
							_g_free0 (_tmp235_);
							_g_free0 (_tmp230_);
							_g_free0 (_tmp228_);
							_g_free0 (_tmp226_);
							_g_free0 (_tmp223_);
							_g_free0 (_tmp221_);
							_g_free0 (_tmp219_);
							result = _tmp268_;
							_g_match_info_unref0 (match_info);
							_g_regex_unref0 (regex);
							_g_free0 (markup_esc);
							convenience_tag = (_vala_array_free (convenience_tag, convenience_tag_length1, (GDestroyNotify) g_free), NULL);
							markup_string = (_vala_array_free (markup_string, markup_string_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (s);
							return result;
						}
						_g_match_info_unref0 (match_info);
						_g_regex_unref0 (regex);
					}
					goto __finally1;
					__catch1_g_regex_error:
					{
						g_clear_error (&_inner_error0_);
						g_assert_not_reached ();
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (markup_esc);
						convenience_tag = (_vala_array_free (convenience_tag, convenience_tag_length1, (GDestroyNotify) g_free), NULL);
						markup_string = (_vala_array_free (markup_string, markup_string_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (s);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_g_free0 (markup_esc);
				}
			}
		}
		convenience_tag = (_vala_array_free (convenience_tag, convenience_tag_length1, (GDestroyNotify) g_free), NULL);
		markup_string = (_vala_array_free (markup_string, markup_string_length1, (GDestroyNotify) g_free), NULL);
	}
	result = s;
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

gchar*
dino_ui_util_remove_fallbacks_adjust_markups (const gchar* text,
                                              gboolean contains_quote,
                                              GeeList* fallbacks,
                                              GeeList* markups)
{
	gchar* processed_text = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (fallbacks != NULL, NULL);
	g_return_val_if_fail (markups != NULL, NULL);
	_tmp0_ = g_strdup (text);
	processed_text = _tmp0_;
	{
		GeeList* _fallback_list = NULL;
		gint _fallback_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _fallback_index = 0;
		_fallback_list = fallbacks;
		_tmp1_ = _fallback_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_fallback_size = _tmp3_;
		_fallback_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			XmppXepFallbackIndicationFallback* fallback = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			XmppXepFallbackIndicationFallback* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_fallback_index = _fallback_index + 1;
			_tmp4_ = _fallback_index;
			_tmp5_ = _fallback_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _fallback_list;
			_tmp7_ = gee_list_get (_tmp6_, _fallback_index);
			fallback = (XmppXepFallbackIndicationFallback*) _tmp7_;
			_tmp9_ = fallback;
			_tmp10_ = xmpp_xep_fallback_indication_fallback_get_ns_uri (_tmp9_);
			_tmp11_ = _tmp10_;
			if (g_strcmp0 (_tmp11_, XMPP_XEP_REPLIES_NS_URI) == 0) {
				_tmp8_ = contains_quote;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				{
					GeeList* _fallback_location_list = NULL;
					XmppXepFallbackIndicationFallback* _tmp12_;
					GeeList* _tmp13_;
					gint _fallback_location_size = 0;
					GeeList* _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gint _fallback_location_index = 0;
					_tmp12_ = fallback;
					_tmp13_ = _tmp12_->locations;
					_fallback_location_list = _tmp13_;
					_tmp14_ = _fallback_location_list;
					_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
					_tmp16_ = _tmp15_;
					_fallback_location_size = _tmp16_;
					_fallback_location_index = -1;
					while (TRUE) {
						gint _tmp17_;
						gint _tmp18_;
						XmppXepFallbackIndicationFallbackLocation* fallback_location = NULL;
						GeeList* _tmp19_;
						gpointer _tmp20_;
						const gchar* _tmp21_;
						const gchar* _tmp22_;
						XmppXepFallbackIndicationFallbackLocation* _tmp23_;
						gint _tmp24_;
						gint _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						const gchar* _tmp28_;
						const gchar* _tmp29_;
						XmppXepFallbackIndicationFallbackLocation* _tmp30_;
						gint _tmp31_;
						gint _tmp32_;
						const gchar* _tmp33_;
						gint _tmp34_;
						gint _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						gint length = 0;
						XmppXepFallbackIndicationFallbackLocation* _tmp39_;
						gint _tmp40_;
						gint _tmp41_;
						XmppXepFallbackIndicationFallbackLocation* _tmp42_;
						gint _tmp43_;
						gint _tmp44_;
						_fallback_location_index = _fallback_location_index + 1;
						_tmp17_ = _fallback_location_index;
						_tmp18_ = _fallback_location_size;
						if (!(_tmp17_ < _tmp18_)) {
							break;
						}
						_tmp19_ = _fallback_location_list;
						_tmp20_ = gee_list_get (_tmp19_, _fallback_location_index);
						fallback_location = (XmppXepFallbackIndicationFallbackLocation*) _tmp20_;
						_tmp21_ = processed_text;
						_tmp22_ = processed_text;
						_tmp23_ = fallback_location;
						_tmp24_ = xmpp_xep_fallback_indication_fallback_location_get_from_char (_tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = string_slice (_tmp21_, (glong) 0, (glong) string_index_of_nth_char (_tmp22_, (glong) _tmp25_));
						_tmp27_ = _tmp26_;
						_tmp28_ = processed_text;
						_tmp29_ = processed_text;
						_tmp30_ = fallback_location;
						_tmp31_ = xmpp_xep_fallback_indication_fallback_location_get_to_char (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = processed_text;
						_tmp34_ = strlen (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = string_slice (_tmp28_, (glong) string_index_of_nth_char (_tmp29_, (glong) _tmp32_), (glong) _tmp35_);
						_tmp37_ = _tmp36_;
						_tmp38_ = g_strconcat (_tmp27_, _tmp37_, NULL);
						_g_free0 (processed_text);
						processed_text = _tmp38_;
						_g_free0 (_tmp37_);
						_g_free0 (_tmp27_);
						_tmp39_ = fallback_location;
						_tmp40_ = xmpp_xep_fallback_indication_fallback_location_get_to_char (_tmp39_);
						_tmp41_ = _tmp40_;
						_tmp42_ = fallback_location;
						_tmp43_ = xmpp_xep_fallback_indication_fallback_location_get_from_char (_tmp42_);
						_tmp44_ = _tmp43_;
						length = _tmp41_ - _tmp44_;
						{
							GeeList* _span_list = NULL;
							gint _span_size = 0;
							GeeList* _tmp45_;
							gint _tmp46_;
							gint _tmp47_;
							gint _span_index = 0;
							_span_list = markups;
							_tmp45_ = _span_list;
							_tmp46_ = gee_collection_get_size ((GeeCollection*) _tmp45_);
							_tmp47_ = _tmp46_;
							_span_size = _tmp47_;
							_span_index = -1;
							while (TRUE) {
								gint _tmp48_;
								gint _tmp49_;
								XmppXepMessageMarkupSpan* span = NULL;
								GeeList* _tmp50_;
								gpointer _tmp51_;
								XmppXepMessageMarkupSpan* _tmp52_;
								gint _tmp53_;
								gint _tmp54_;
								XmppXepFallbackIndicationFallbackLocation* _tmp55_;
								gint _tmp56_;
								gint _tmp57_;
								XmppXepMessageMarkupSpan* _tmp62_;
								gint _tmp63_;
								gint _tmp64_;
								XmppXepFallbackIndicationFallbackLocation* _tmp65_;
								gint _tmp66_;
								gint _tmp67_;
								_span_index = _span_index + 1;
								_tmp48_ = _span_index;
								_tmp49_ = _span_size;
								if (!(_tmp48_ < _tmp49_)) {
									break;
								}
								_tmp50_ = _span_list;
								_tmp51_ = gee_list_get (_tmp50_, _span_index);
								span = (XmppXepMessageMarkupSpan*) _tmp51_;
								_tmp52_ = span;
								_tmp53_ = xmpp_xep_message_markup_span_get_start_char (_tmp52_);
								_tmp54_ = _tmp53_;
								_tmp55_ = fallback_location;
								_tmp56_ = xmpp_xep_fallback_indication_fallback_location_get_to_char (_tmp55_);
								_tmp57_ = _tmp56_;
								if (_tmp54_ > _tmp57_) {
									XmppXepMessageMarkupSpan* _tmp58_;
									XmppXepMessageMarkupSpan* _tmp59_;
									gint _tmp60_;
									gint _tmp61_;
									_tmp58_ = span;
									_tmp59_ = span;
									_tmp60_ = xmpp_xep_message_markup_span_get_start_char (_tmp59_);
									_tmp61_ = _tmp60_;
									xmpp_xep_message_markup_span_set_start_char (_tmp59_, _tmp61_ - length);
								}
								_tmp62_ = span;
								_tmp63_ = xmpp_xep_message_markup_span_get_end_char (_tmp62_);
								_tmp64_ = _tmp63_;
								_tmp65_ = fallback_location;
								_tmp66_ = xmpp_xep_fallback_indication_fallback_location_get_to_char (_tmp65_);
								_tmp67_ = _tmp66_;
								if (_tmp64_ > _tmp67_) {
									XmppXepMessageMarkupSpan* _tmp68_;
									XmppXepMessageMarkupSpan* _tmp69_;
									gint _tmp70_;
									gint _tmp71_;
									_tmp68_ = span;
									_tmp69_ = span;
									_tmp70_ = xmpp_xep_message_markup_span_get_end_char (_tmp69_);
									_tmp71_ = _tmp70_;
									xmpp_xep_message_markup_span_set_end_char (_tmp69_, _tmp71_ - length);
								}
								_g_object_unref0 (span);
							}
						}
						_xmpp_xep_fallback_indication_fallback_location_unref0 (fallback_location);
					}
				}
			}
			_xmpp_xep_fallback_indication_fallback_unref0 (fallback);
		}
	}
	result = processed_text;
	return result;
}

/**
 * This is a heuristic to count emojis in a string {@link http://example.com/}
 *
 * @param markup_text string to search in
 * @return number of emojis, or -1 if text includes non-emojis.
 */
gint
dino_ui_util_get_only_emoji_count (const gchar* markup_text)
{
	gint emoji_no = 0;
	gint index_ref = 0;
	gunichar curchar = 0U;
	gunichar altchar = 0U;
	gboolean last_was_emoji = FALSE;
	gboolean last_was_modifier_base = FALSE;
	gboolean last_was_keycap = FALSE;
	gint result;
	g_return_val_if_fail (markup_text != NULL, 0);
	emoji_no = 0;
	index_ref = 0;
	curchar = (gunichar) 0;
	altchar = (gunichar) 0;
	last_was_emoji = FALSE;
	last_was_modifier_base = FALSE;
	last_was_keycap = FALSE;
	while (TRUE) {
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp1_ = string_get_next_char (markup_text, &index_ref, &_tmp0_);
		curchar = _tmp0_;
		if (!_tmp1_) {
			break;
		}
		if (last_was_emoji) {
			_tmp3_ = last_was_keycap;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = curchar == ((gunichar) 0x20E3);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			continue;
		}
		last_was_keycap = FALSE;
		if (last_was_emoji) {
			_tmp5_ = curchar == ((gunichar) 0x200D);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gunichar _tmp6_ = 0U;
			gboolean _tmp7_;
			_tmp7_ = string_get_next_char (markup_text, &index_ref, &_tmp6_);
			curchar = _tmp6_;
			_tmp4_ = _tmp7_;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gint _tmp8_;
			last_was_emoji = FALSE;
			_tmp8_ = emoji_no;
			emoji_no = _tmp8_ - 1;
		}
		if (last_was_emoji) {
			_tmp9_ = curchar == ((gunichar) 0xFE0F);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
		} else {
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			if (last_was_emoji) {
				_tmp11_ = last_was_modifier_base;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				_tmp10_ = u_hasBinaryProperty (curchar, UCHAR_EMOJI_MODIFIER);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				last_was_modifier_base = FALSE;
			} else {
				if (u_hasBinaryProperty (curchar, UCHAR_EMOJI_PRESENTATION)) {
					gint _tmp12_;
					if (u_hasBinaryProperty (curchar, UCHAR_EMOJI_MODIFIER_BASE)) {
						last_was_modifier_base = TRUE;
					}
					_tmp12_ = emoji_no;
					emoji_no = _tmp12_ + 1;
					last_was_emoji = TRUE;
				} else {
					if (curchar == ((gunichar) ' ')) {
						last_was_emoji = FALSE;
					} else {
						gboolean _tmp13_ = FALSE;
						gunichar _tmp14_ = 0U;
						gboolean _tmp15_;
						_tmp15_ = string_get_next_char (markup_text, &index_ref, &_tmp14_);
						altchar = _tmp14_;
						if (_tmp15_) {
							_tmp13_ = altchar == ((gunichar) 0xFE0F);
						} else {
							_tmp13_ = FALSE;
						}
						if (_tmp13_) {
							gint _tmp16_;
							gboolean _tmp17_ = FALSE;
							gboolean _tmp18_ = FALSE;
							gboolean _tmp19_ = FALSE;
							_tmp16_ = emoji_no;
							emoji_no = _tmp16_ + 1;
							last_was_emoji = TRUE;
							if (curchar >= ((gunichar) 0x30)) {
								_tmp19_ = curchar <= ((gunichar) 0x39);
							} else {
								_tmp19_ = FALSE;
							}
							if (_tmp19_) {
								_tmp18_ = TRUE;
							} else {
								_tmp18_ = curchar == ((gunichar) 0x23);
							}
							if (_tmp18_) {
								_tmp17_ = TRUE;
							} else {
								_tmp17_ = curchar == ((gunichar) 0x2A);
							}
							last_was_keycap = _tmp17_;
						} else {
							result = -1;
							return result;
						}
					}
				}
			}
		}
	}
	result = emoji_no;
	return result;
}

gchar*
dino_ui_util_summarize_whitespaces_to_space (const gchar* s)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (s != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_regex_replace_literal (_thread_safe_regex_init (&_tmp_regex_3, "\\s+", 0), s, (gssize) -1, 0, " ", 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("helper.vala:418: RegexError when summarizing whitespaces in '%s': %s", s, _tmp4_);
		_tmp5_ = g_strdup (s);
		result = _tmp5_;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
dino_ui_util_present_window (GtkWindow* window)
{
	g_return_if_fail (window != NULL);
	gtk_window_present (window);
}

GtkWidget*
dino_ui_util_widget_if_tooltips_active (GtkWidget* w)
{
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* result;
	g_return_val_if_fail (w != NULL, NULL);
	if (dino_ui_util_use_tooltips ()) {
		_tmp0_ = w;
	} else {
		_tmp0_ = NULL;
	}
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
dino_ui_util_string_if_tooltips_active (const gchar* s)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* result;
	if (dino_ui_util_use_tooltips ()) {
		_tmp0_ = s;
	} else {
		_tmp0_ = NULL;
	}
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
dino_ui_util_use_tooltips (void)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (GTK_MINOR_VERSION != 6) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		if (GTK_MICRO_VERSION < 4) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = GTK_MICRO_VERSION > 6;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}

void
dino_ui_util_menu_button_set_icon_with_size (GtkMenuButton* menu_button,
                                             const gchar* icon_name,
                                             gint pixel_size)
{
	GtkImage* _tmp0_ = NULL;
	GtkImage* _tmp1_;
	g_return_if_fail (menu_button != NULL);
	g_return_if_fail (icon_name != NULL);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name (icon_name);
	gtk_image_set_pixel_size (_tmp0_, pixel_size);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	gtk_menu_button_set_child (menu_button, (GtkWidget*) _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

