// Copyright 2019 Drone IO, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// +build oss

package rpc

import (
	"context"
	"errors"
	"io"
	"net/http"

	"github.com/drone/drone/core"
	"github.com/drone/drone/operator/manager"
)

// Server is a no-op rpc server.
type Server struct {
	manager manager.BuildManager
	secret  string
}

// NewServer returns a no-op rpc server.
func NewServer(manager.BuildManager, string) *Server {
	return &Server{}
}

// Request requests the next available build stage for execution.
func (Server) Request(ctx context.Context, args *manager.Request) (*core.Stage, error) {
	return nil, errors.New("not implemented")
}

// Accept accepts the build stage for execution.
func (Server) Accept(ctx context.Context, stage int64, machine string) error {
	return errors.New("not implemented")
}

// Netrc returns a valid netrc for execution.
func (Server) Netrc(ctx context.Context, repo int64) (*core.Netrc, error) {
	return nil, errors.New("not implemented")
}

// Details fetches build details
func (Server) Details(ctx context.Context, stage int64) (*manager.Context, error) {
	return nil, errors.New("not implemented")
}

// Before signals the build step is about to start.
func (Server) Before(ctx context.Context, step *core.Step) error {
	return errors.New("not implemented")
}

// After signals the build step is complete.
func (Server) After(ctx context.Context, step *core.Step) error {
	return errors.New("not implemented")
}

// Before signals the build stage is about to start.
func (Server) BeforeAll(ctx context.Context, stage *core.Stage) error {
	return errors.New("not implemented")
}

// After signals the build stage is complete.
func (Server) AfterAll(ctx context.Context, stage *core.Stage) error {
	return errors.New("not implemented")
}

// Watch watches for build cancellation requests.
func (Server) Watch(ctx context.Context, stage int64) (bool, error) {
	return false, errors.New("not implemented")
}

// Write writes a line to the build logs
func (Server) Write(ctx context.Context, step int64, line *core.Line) error {
	return errors.New("not implemented")
}

// Upload uploads the full logs
func (Server) Upload(ctx context.Context, step int64, r io.Reader) error {
	return errors.New("not implemented")
}

// UploadBytes uploads the full logs
func (Server) UploadBytes(ctx context.Context, step int64, b []byte) error {
	return errors.New("not implemented")
}

// ServeHTTP is an empty handler.
func (Server) ServeHTTP(w http.ResponseWriter, r *http.Request) {}
