
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "bookmarkstools_wrapper.h"

// Argument includes
#include <QString>
#include <bookmarkitem.h>
#include <bookmarks.h>
#include <browserwindow.h>
#include <enhancedmenu.h>
#include <qobject.h>
#include <qurl.h>
#include <qwidget.h>
#include <tabwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_BookmarksTools_Type = nullptr;
static PyTypeObject *Sbk_BookmarksTools_TypeF(void)
{
    return _Sbk_BookmarksTools_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_BookmarksTools_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::BookmarksTools >()))
        return -1;

    ::BookmarksTools *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // BookmarksTools()
        cptr = new ::BookmarksTools();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::BookmarksTools >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_BookmarksToolsFunc_addActionToMenu(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addActionToMenu", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::addActionToMenu(QObject*,Menu*,BookmarkItem*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Menu_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[2])))) {
        overloadId = 0; // addActionToMenu(QObject*,Menu*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addActionToMenu", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::Menu *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::BookmarkItem *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addActionToMenu(QObject*,Menu*,BookmarkItem*)
            ::BookmarksTools::addActionToMenu(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksToolsFunc_addBookmarkDialog(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addBookmarkDialog", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:addBookmarkDialog", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::addBookmarkDialog(QWidget*,QUrl,QString,BookmarkItem*=)->bool
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // addBookmarkDialog(QWidget*,QUrl,QString,BookmarkItem*)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[3])))) {
            overloadId = 0; // addBookmarkDialog(QWidget*,QUrl,QString,BookmarkItem*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addBookmarkDialog", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"folder", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addBookmarkDialog", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QUrl cppArg1_local;
        ::QUrl *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::BookmarkItem *cppArg3 = nullptr;
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addBookmarkDialog(QWidget*,QUrl,QString,BookmarkItem*)
            bool cppResult = ::BookmarksTools::addBookmarkDialog(cppArg0, *cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksToolsFunc_addFolderContentsToMenu(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addFolderContentsToMenu", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::addFolderContentsToMenu(QObject*,Menu*,BookmarkItem*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Menu_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[2])))) {
        overloadId = 0; // addFolderContentsToMenu(QObject*,Menu*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addFolderContentsToMenu", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::Menu *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::BookmarkItem *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addFolderContentsToMenu(QObject*,Menu*,BookmarkItem*)
            ::BookmarksTools::addFolderContentsToMenu(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksToolsFunc_addFolderToMenu(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addFolderToMenu", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::addFolderToMenu(QObject*,Menu*,BookmarkItem*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Menu_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[2])))) {
        overloadId = 0; // addFolderToMenu(QObject*,Menu*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addFolderToMenu", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::Menu *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::BookmarkItem *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addFolderToMenu(QObject*,Menu*,BookmarkItem*)
            ::BookmarksTools::addFolderToMenu(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksToolsFunc_addSeparatorToMenu(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addSeparatorToMenu", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::addSeparatorToMenu(Menu*,BookmarkItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Menu_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[1])))) {
        overloadId = 0; // addSeparatorToMenu(Menu*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addSeparatorToMenu", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::Menu *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::BookmarkItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addSeparatorToMenu(Menu*,BookmarkItem*)
            ::BookmarksTools::addSeparatorToMenu(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksToolsFunc_addUrlToMenu(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addUrlToMenu", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::addUrlToMenu(QObject*,Menu*,BookmarkItem*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Menu_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[2])))) {
        overloadId = 0; // addUrlToMenu(QObject*,Menu*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addUrlToMenu", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::Menu *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::BookmarkItem *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addUrlToMenu(QObject*,Menu*,BookmarkItem*)
            ::BookmarksTools::addUrlToMenu(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksToolsFunc_bookmarkAllTabsDialog(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "bookmarkAllTabsDialog", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:bookmarkAllTabsDialog", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::bookmarkAllTabsDialog(QWidget*,TabWidget*,BookmarkItem*=)->bool
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // bookmarkAllTabsDialog(QWidget*,TabWidget*,BookmarkItem*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[2])))) {
            overloadId = 0; // bookmarkAllTabsDialog(QWidget*,TabWidget*,BookmarkItem*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "bookmarkAllTabsDialog", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"folder", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "bookmarkAllTabsDialog", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::TabWidget *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::BookmarkItem *cppArg2 = nullptr;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // bookmarkAllTabsDialog(QWidget*,TabWidget*,BookmarkItem*)
            bool cppResult = ::BookmarksTools::bookmarkAllTabsDialog(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksToolsFunc_editBookmarkDialog(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "editBookmarkDialog", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::editBookmarkDialog(QWidget*,BookmarkItem*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[1])))) {
        overloadId = 0; // editBookmarkDialog(QWidget*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "editBookmarkDialog", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::BookmarkItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // editBookmarkDialog(QWidget*,BookmarkItem*)
            bool cppResult = ::BookmarksTools::editBookmarkDialog(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksToolsFunc_migrateBookmarksIfNecessary(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static BookmarksTools::migrateBookmarksIfNecessary(Bookmarks*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), (pyArg)))) {
        overloadId = 0; // migrateBookmarksIfNecessary(Bookmarks*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "migrateBookmarksIfNecessary", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Bookmarks *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // migrateBookmarksIfNecessary(Bookmarks*)
            bool cppResult = ::BookmarksTools::migrateBookmarksIfNecessary(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksToolsFunc_openBookmark(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "openBookmark", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::openBookmark(BrowserWindow*,BookmarkItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[1])))) {
        overloadId = 0; // openBookmark(BrowserWindow*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "openBookmark", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::BrowserWindow *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::BookmarkItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // openBookmark(BrowserWindow*,BookmarkItem*)
            ::BookmarksTools::openBookmark(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksToolsFunc_openBookmarkInNewPrivateWindow(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static BookmarksTools::openBookmarkInNewPrivateWindow(BookmarkItem*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArg)))) {
        overloadId = 0; // openBookmarkInNewPrivateWindow(BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "openBookmarkInNewPrivateWindow", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // openBookmarkInNewPrivateWindow(BookmarkItem*)
            ::BookmarksTools::openBookmarkInNewPrivateWindow(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksToolsFunc_openBookmarkInNewTab(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "openBookmarkInNewTab", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::openBookmarkInNewTab(BrowserWindow*,BookmarkItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[1])))) {
        overloadId = 0; // openBookmarkInNewTab(BrowserWindow*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "openBookmarkInNewTab", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::BrowserWindow *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::BookmarkItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // openBookmarkInNewTab(BrowserWindow*,BookmarkItem*)
            ::BookmarksTools::openBookmarkInNewTab(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksToolsFunc_openBookmarkInNewWindow(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static BookmarksTools::openBookmarkInNewWindow(BookmarkItem*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArg)))) {
        overloadId = 0; // openBookmarkInNewWindow(BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "openBookmarkInNewWindow", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // openBookmarkInNewWindow(BookmarkItem*)
            ::BookmarksTools::openBookmarkInNewWindow(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksToolsFunc_openFolderInTabs(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "openFolderInTabs", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::openFolderInTabs(BrowserWindow*,BookmarkItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[1])))) {
        overloadId = 0; // openFolderInTabs(BrowserWindow*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "openFolderInTabs", errInfo, SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::BrowserWindow *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::BookmarkItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // openFolderInTabs(BrowserWindow*,BookmarkItem*)
            ::BookmarksTools::openFolderInTabs(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_BookmarksTools_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_BookmarksTools_methods[] = {
    {"addActionToMenu", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_addActionToMenu), METH_VARARGS|METH_STATIC, nullptr},
    {"addBookmarkDialog", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_addBookmarkDialog), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"addFolderContentsToMenu", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_addFolderContentsToMenu), METH_VARARGS|METH_STATIC, nullptr},
    {"addFolderToMenu", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_addFolderToMenu), METH_VARARGS|METH_STATIC, nullptr},
    {"addSeparatorToMenu", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_addSeparatorToMenu), METH_VARARGS|METH_STATIC, nullptr},
    {"addUrlToMenu", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_addUrlToMenu), METH_VARARGS|METH_STATIC, nullptr},
    {"bookmarkAllTabsDialog", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_bookmarkAllTabsDialog), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"editBookmarkDialog", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_editBookmarkDialog), METH_VARARGS|METH_STATIC, nullptr},
    {"migrateBookmarksIfNecessary", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_migrateBookmarksIfNecessary), METH_O|METH_STATIC, nullptr},
    {"openBookmark", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_openBookmark), METH_VARARGS|METH_STATIC, nullptr},
    {"openBookmarkInNewPrivateWindow", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_openBookmarkInNewPrivateWindow), METH_O|METH_STATIC, nullptr},
    {"openBookmarkInNewTab", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_openBookmarkInNewTab), METH_VARARGS|METH_STATIC, nullptr},
    {"openBookmarkInNewWindow", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_openBookmarkInNewWindow), METH_O|METH_STATIC, nullptr},
    {"openFolderInTabs", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_openFolderInTabs), METH_VARARGS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_BookmarksTools_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_BookmarksTools_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_BookmarksTools_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_BookmarksTools_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_BookmarksTools_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_BookmarksTools_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_BookmarksTools_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_BookmarksTools_spec = {
    "1:PyFalkon.BookmarksTools",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_BookmarksTools_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void BookmarksTools_PythonToCpp_BookmarksTools_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_BookmarksTools_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_BookmarksTools_PythonToCpp_BookmarksTools_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_BookmarksTools_TypeF()))
        return BookmarksTools_PythonToCpp_BookmarksTools_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *BookmarksTools_PTR_CppToPython_BookmarksTools(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_BookmarksTools_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_BookmarksTools_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *BookmarksTools_SignatureStrings[] = {
    "PyFalkon.BookmarksTools(self)",
    "PyFalkon.BookmarksTools.addActionToMenu(receiver:PySide6.QtCore.QObject,menu:PyFalkon.Menu,item:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.addBookmarkDialog(parent:PySide6.QtWidgets.QWidget,url:typing.Union[PySide6.QtCore.QUrl, QString],title:QString,folder:PyFalkon.BookmarkItem=nullptr)->bool",
    "PyFalkon.BookmarksTools.addFolderContentsToMenu(receiver:PySide6.QtCore.QObject,menu:PyFalkon.Menu,folder:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.addFolderToMenu(receiver:PySide6.QtCore.QObject,menu:PyFalkon.Menu,folder:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.addSeparatorToMenu(menu:PyFalkon.Menu,separator:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.addUrlToMenu(receiver:PySide6.QtCore.QObject,menu:PyFalkon.Menu,bookmark:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.bookmarkAllTabsDialog(parent:PySide6.QtWidgets.QWidget,tabWidget:PyFalkon.TabWidget,folder:PyFalkon.BookmarkItem=nullptr)->bool",
    "PyFalkon.BookmarksTools.editBookmarkDialog(parent:PySide6.QtWidgets.QWidget,item:PyFalkon.BookmarkItem)->bool",
    "PyFalkon.BookmarksTools.migrateBookmarksIfNecessary(bookmarks:PyFalkon.Bookmarks)->bool",
    "PyFalkon.BookmarksTools.openBookmark(window:PyFalkon.BrowserWindow,item:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.openBookmarkInNewPrivateWindow(item:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.openBookmarkInNewTab(window:PyFalkon.BrowserWindow,item:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.openBookmarkInNewWindow(item:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.openFolderInTabs(window:PyFalkon.BrowserWindow,folder:PyFalkon.BookmarkItem)",
    nullptr}; // Sentinel
#else
static constexpr size_t BookmarksTools_SignatureByteSize = 353;
static constexpr uint8_t BookmarksTools_SignatureBytes[353] = {
    0x78, 0xda, 0xc5, 0x94, 0xc1, 0x6e, 0xc2, 0x30, 0x0c, 0x86, 0xef, 0x7b, 0x8a, 0x1d, 0x8b, 0xd4,
    0xf5, 0xb8, 0x43, 0xa5, 0x4d, 0x62, 0x4c, 0x48, 0x3d, 0x8c, 0xb5, 0xa2, 0x88, 0xc3, 0xb4, 0x43,
    0x4a, 0x4c, 0x95, 0x91, 0xc6, 0x55, 0x62, 0xa8, 0xfa, 0xf6, 0x0b, 0x94, 0x30, 0x34, 0x50, 0x3b,
    0x3a, 0xb4, 0xdd, 0x52, 0xd7, 0xf9, 0xfe, 0xdf, 0xb1, 0x93, 0xb8, 0x1e, 0x33, 0xb9, 0x42, 0x15,
    0x3c, 0x21, 0xae, 0x0a, 0xa6, 0x57, 0x26, 0x45, 0x94, 0xc6, 0x33, 0x20, 0x97, 0x83, 0x9b, 0xf8,
    0xfc, 0xdf, 0x80, 0x71, 0x3e, 0x5c, 0x90, 0x40, 0x95, 0xe2, 0x0b, 0xa8, 0xb5, 0xa7, 0x61, 0x01,
    0x62, 0x03, 0x3a, 0x8c, 0xeb, 0xa9, 0xe0, 0x70, 0x1f, 0x24, 0x34, 0x42, 0x0d, 0x41, 0xf2, 0x9a,
    0x7d, 0xc0, 0x82, 0xfc, 0xc2, 0x26, 0x85, 0x07, 0xd8, 0x76, 0x8b, 0x2f, 0x08, 0x8a, 0xf0, 0x84,
    0x1f, 0xd9, 0x68, 0xab, 0xac, 0x8b, 0x3c, 0x0b, 0x26, 0x31, 0xf7, 0x4a, 0xa6, 0x41, 0xd1, 0x91,
    0xec, 0x5c, 0xf0, 0x1c, 0xc8, 0x04, 0x49, 0xb3, 0xf0, 0xd7, 0x5a, 0x86, 0x54, 0x97, 0x42, 0xe5,
    0xc1, 0x4c, 0x59, 0xc3, 0x6f, 0xdf, 0x1d, 0xce, 0xb4, 0xf4, 0x6f, 0x93, 0x29, 0x69, 0x9b, 0xf2,
    0xee, 0x93, 0x20, 0x09, 0xe1, 0xfe, 0xd3, 0x5f, 0xa2, 0xe4, 0xbb, 0xa2, 0xce, 0xb8, 0x7c, 0x50,
    0x6b, 0x29, 0x4b, 0xd2, 0x83, 0xbb, 0xc7, 0xcc, 0x9a, 0x6b, 0xf3, 0x3c, 0xde, 0x61, 0x46, 0xa8,
    0xc8, 0x7a, 0x35, 0xfd, 0x8f, 0xac, 0xcd, 0xce, 0xa0, 0xdb, 0xc0, 0x3f, 0x08, 0x4f, 0xc1, 0x36,
    0x88, 0x11, 0x3a, 0xed, 0x33, 0x6c, 0xe3, 0x52, 0x7a, 0xe0, 0x6d, 0xef, 0xfa, 0x17, 0x95, 0xed,
    0x71, 0x97, 0xea, 0xba, 0x7d, 0x43, 0x29, 0x53, 0x96, 0x99, 0x9f, 0x0e, 0x22, 0xb1, 0xac, 0x59,
    0x7d, 0xe9, 0xa5, 0x2e, 0x74, 0x95, 0x41, 0x03, 0x2e, 0xe8, 0xd2, 0xdb, 0xd1, 0x72, 0x09, 0x3b,
    0xd4, 0x0a, 0x91, 0xdb, 0xae, 0xc1, 0x21, 0x1a, 0x2d, 0x27, 0xb6, 0x05, 0xc6, 0x30, 0x5d, 0x7b,
    0xee, 0x84, 0xcc, 0x29, 0xda, 0x74, 0x71, 0xb1, 0x04, 0xe5, 0x42, 0x5e, 0x25, 0x14, 0xc7, 0xea,
    0x88, 0xa2, 0xb1, 0x32, 0xa0, 0xe7, 0xbb, 0x70, 0xaf, 0x17, 0xe4, 0x18, 0x1f, 0xa9, 0x09, 0x54,
    0xb1, 0x16, 0x1b, 0x5b, 0x47, 0x83, 0xf4, 0xae, 0x82, 0xb4, 0x6d, 0xfd, 0x0b, 0xe7, 0xbf, 0xb4,
    0xdc, 0xbc, 0x09, 0x91, 0xda, 0xce, 0x70, 0x87, 0xdd, 0xf6, 0xeb, 0xff, 0x09, 0x57, 0x71, 0x59,
    0x45
};
#endif

PyTypeObject *init_BookmarksTools(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX].type;

    Shiboken::AutoDecRef Sbk_BookmarksTools_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_BookmarksTools_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "BookmarksTools",
        "BookmarksTools*",
        &Sbk_BookmarksTools_spec,
        &Shiboken::callCppDestructor< ::BookmarksTools >,
        Sbk_BookmarksTools_Type_bases.object(),
        0);
    auto *pyType = Sbk_BookmarksTools_TypeF(); // references _Sbk_BookmarksTools_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, BookmarksTools_SignatureStrings);
#else
    InitSignatureBytes(pyType, BookmarksTools_SignatureBytes, BookmarksTools_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_BookmarksTools_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_BookmarksTools_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        BookmarksTools_PythonToCpp_BookmarksTools_PTR,
        is_BookmarksTools_PythonToCpp_BookmarksTools_PTR_Convertible,
        BookmarksTools_PTR_CppToPython_BookmarksTools);

    Shiboken::Conversions::registerConverterName(converter, "BookmarksTools");
    Shiboken::Conversions::registerConverterName(converter, "BookmarksTools*");
    Shiboken::Conversions::registerConverterName(converter, "BookmarksTools&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::BookmarksTools).name());

    qRegisterMetaType< ::BookmarksTools *>();

    return pyType;
}
