/* kf-backend.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from kf-backend.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include "key-file.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "folks/folks.h"
#include <gio/gio.h>
#include "folks-internal.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_BACKENDS_KF_BACKEND_0_PROPERTY,
	FOLKS_BACKENDS_KF_BACKEND_IS_PREPARED_PROPERTY,
	FOLKS_BACKENDS_KF_BACKEND_IS_QUIESCENT_PROPERTY,
	FOLKS_BACKENDS_KF_BACKEND_NAME_PROPERTY,
	FOLKS_BACKENDS_KF_BACKEND_PERSONA_STORES_PROPERTY,
	FOLKS_BACKENDS_KF_BACKEND_NUM_PROPERTIES
};
static GParamSpec* folks_backends_kf_backend_properties[FOLKS_BACKENDS_KF_BACKEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _folks_internal_profile_block_free0(var) ((var == NULL) ? NULL : (var = (folks_internal_profile_block_free (var), NULL)))
typedef struct _FolksBackendsKfBackendPrepareData FolksBackendsKfBackendPrepareData;
typedef struct _FolksBackendsKfBackendUnprepareData FolksBackendsKfBackendUnprepareData;

struct _FolksBackendsKfBackendPrivate {
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	GeeHashMap* _persona_stores;
	GeeMap* _persona_stores_ro;
};

struct _FolksBackendsKfBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsKfBackend* self;
	FolksInternalProfileBlock* profiling;
	FolksInternalProfileBlock* _tmp0_;
	gboolean _tmp1_;
	GFile* file;
	const gchar* path;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GFile* _tmp9_;
	const gchar* _tmp10_;
	FolksBackendsKfPersonaStore* store;
	GFile* _tmp11_;
	FolksBackendsKfPersonaStore* _tmp12_;
	FolksBackendsKfPersonaStore* _tmp13_;
	FolksInternalProfileBlock* _tmp14_;
	GError* _inner_error0_;
};

struct _FolksBackendsKfBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsKfBackend* self;
	gboolean _tmp0_;
	GeeIterator* _persona_store_it;
	GeeHashMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	FolksBackendsKfPersonaStore* persona_store;
	GeeIterator* _tmp8_;
	gpointer _tmp9_;
	FolksBackendsKfPersonaStore* _tmp10_;
	GeeHashMap* _tmp11_;
	GError* _inner_error0_;
};

static gint FolksBackendsKfBackend_private_offset;
static gpointer folks_backends_kf_backend_parent_class = NULL;

static void folks_backends_kf_backend_real_enable_persona_store (FolksBackend* base,
                                                          FolksPersonaStore* store);
static void _folks_backends_kf_backend_add_store (FolksBackendsKfBackend* self,
                                           FolksBackendsKfPersonaStore* store,
                                           gboolean notify);
static void folks_backends_kf_backend_real_disable_persona_store (FolksBackend* base,
                                                           FolksPersonaStore* store);
static void _folks_backends_kf_backend_store_removed_cb (FolksBackendsKfBackend* self,
                                                  FolksPersonaStore* store);
static GFile* _folks_backends_kf_backend_get_default_file (FolksBackendsKfBackend* self,
                                                    const gchar* basename);
static void folks_backends_kf_backend_real_set_persona_stores (FolksBackend* base,
                                                        GeeSet* storeids);
static void _vala_array_add1 (FolksBackendsKfPersonaStore** * array,
                       gint* length,
                       gint* size,
                       FolksBackendsKfPersonaStore* value);
static void _folks_backends_kf_backend_remove_store (FolksBackendsKfBackend* self,
                                              FolksBackendsKfPersonaStore* store,
                                              gboolean notify);
static void folks_backends_kf_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_kf_backend_real_prepare (FolksBackend* base,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean folks_backends_kf_backend_real_prepare_co (FolksBackendsKfBackendPrepareData* _data_);
static void __folks_backends_kf_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender,
                                                                               gpointer self);
static void folks_backends_kf_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_kf_backend_real_unprepare (FolksBackend* base,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean folks_backends_kf_backend_real_unprepare_co (FolksBackendsKfBackendUnprepareData* _data_);
static GObject * folks_backends_kf_backend_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void folks_backends_kf_backend_finalize (GObject * obj);
static GType folks_backends_kf_backend_get_type_once (void);
static void _vala_folks_backends_kf_backend_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
folks_backends_kf_backend_get_instance_private (FolksBackendsKfBackend* self)
{
	return G_STRUCT_MEMBER_P (self, FolksBackendsKfBackend_private_offset);
}

/**
   * {@inheritDoc}
   */
static void
folks_backends_kf_backend_real_enable_persona_store (FolksBackend* base,
                                                     FolksPersonaStore* store)
{
	FolksBackendsKfBackend * self;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (FolksBackendsKfBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = folks_persona_store_get_id (store);
	_tmp2_ = _tmp1_;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_) == FALSE) {
		_folks_backends_kf_backend_add_store (self, G_TYPE_CHECK_INSTANCE_CAST (store, FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore), TRUE);
	}
}

/**
   * {@inheritDoc}
   */
static void
folks_backends_kf_backend_real_disable_persona_store (FolksBackend* base,
                                                      FolksPersonaStore* store)
{
	FolksBackendsKfBackend * self;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (FolksBackendsKfBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = folks_persona_store_get_id (store);
	_tmp2_ = _tmp1_;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_)) {
		_folks_backends_kf_backend_store_removed_cb (self, store);
	}
}

static GFile*
_folks_backends_kf_backend_get_default_file (FolksBackendsKfBackend* self,
                                             const gchar* basename)
{
	gchar* filename = NULL;
	gchar* _tmp0_;
	GFile* file = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (basename != NULL, NULL);
	_tmp0_ = g_strconcat (basename, ".ini", NULL);
	filename = _tmp0_;
	_tmp1_ = g_get_user_data_dir ();
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	_tmp4_ = g_file_get_child (_tmp3_, "folks");
	_g_object_unref0 (file);
	file = _tmp4_;
	_tmp5_ = file;
	_tmp6_ = g_file_get_child (_tmp5_, filename);
	_g_object_unref0 (file);
	file = _tmp6_;
	result = file;
	_g_free0 (filename);
	return result;
}

/**
   * {@inheritDoc}
   * In this implementation storeids are assumed to be base filenames for
   * ini files under user_data_dir()/folks/ like the default relationships
   * {@link PersonaStore}.
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add1 (FolksBackendsKfPersonaStore** * array,
                  gint* length,
                  gint* size,
                  FolksBackendsKfPersonaStore* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksBackendsKfPersonaStore*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
folks_backends_kf_backend_real_set_persona_stores (FolksBackend* base,
                                                   GeeSet* storeids)
{
	FolksBackendsKfBackend * self;
	gboolean added_stores = FALSE;
	FolksBackendsKfPersonaStore** removed_stores = NULL;
	FolksBackendsKfPersonaStore** _tmp0_;
	gint removed_stores_length1;
	gint _removed_stores_size_;
	gboolean _tmp31_ = FALSE;
	self = (FolksBackendsKfBackend*) base;
	added_stores = FALSE;
	_tmp0_ = g_new0 (FolksBackendsKfPersonaStore*, 0 + 1);
	removed_stores = _tmp0_;
	removed_stores_length1 = 0;
	_removed_stores_size_ = removed_stores_length1;
	{
		GeeIterator* _id_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) storeids);
		_id_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gchar* id = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeHashMap* _tmp5_;
			const gchar* _tmp6_;
			_tmp2_ = _id_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _id_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			id = (gchar*) _tmp4_;
			_tmp5_ = self->priv->_persona_stores;
			_tmp6_ = id;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp6_) == FALSE) {
				GFile* file = NULL;
				const gchar* _tmp7_;
				GFile* _tmp8_;
				FolksBackendsKfPersonaStore* store = NULL;
				GFile* _tmp9_;
				FolksBackendsKfPersonaStore* _tmp10_;
				FolksBackendsKfPersonaStore* _tmp11_;
				_tmp7_ = id;
				_tmp8_ = _folks_backends_kf_backend_get_default_file (self, _tmp7_);
				file = _tmp8_;
				_tmp9_ = file;
				_tmp10_ = folks_backends_kf_persona_store_new (_tmp9_);
				store = _tmp10_;
				_tmp11_ = store;
				_folks_backends_kf_backend_add_store (self, _tmp11_, FALSE);
				added_stores = TRUE;
				_g_object_unref0 (store);
				_g_object_unref0 (file);
			}
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	{
		GeeIterator* _store_it = NULL;
		GeeHashMap* _tmp12_;
		GeeCollection* _tmp13_;
		GeeCollection* _tmp14_;
		GeeCollection* _tmp15_;
		GeeIterator* _tmp16_;
		GeeIterator* _tmp17_;
		_tmp12_ = self->priv->_persona_stores;
		_tmp13_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp15_);
		_store_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			FolksBackendsKfPersonaStore* store = NULL;
			GeeIterator* _tmp19_;
			gpointer _tmp20_;
			FolksBackendsKfPersonaStore* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = _store_it;
			if (!gee_iterator_next (_tmp18_)) {
				break;
			}
			_tmp19_ = _store_it;
			_tmp20_ = gee_iterator_get (_tmp19_);
			store = (FolksBackendsKfPersonaStore*) _tmp20_;
			_tmp21_ = store;
			_tmp22_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp21_);
			_tmp23_ = _tmp22_;
			if (!gee_collection_contains ((GeeCollection*) storeids, _tmp23_)) {
				FolksBackendsKfPersonaStore* _tmp24_;
				FolksBackendsKfPersonaStore* _tmp25_;
				_tmp24_ = store;
				_tmp25_ = _g_object_ref0 (_tmp24_);
				_vala_array_add1 (&removed_stores, &removed_stores_length1, &_removed_stores_size_, _tmp25_);
			}
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				FolksBackendsKfPersonaStore** _tmp28_;
				gint _tmp28__length1;
				FolksBackendsKfPersonaStore** _tmp29_;
				gint _tmp29__length1;
				FolksBackendsKfPersonaStore* _tmp30_;
				if (!_tmp26_) {
					gint _tmp27_;
					i = i + 1;
					_tmp27_ = i;
				}
				_tmp26_ = FALSE;
				_tmp28_ = removed_stores;
				_tmp28__length1 = removed_stores_length1;
				if (!(i < _tmp28__length1)) {
					break;
				}
				_tmp29_ = removed_stores;
				_tmp29__length1 = removed_stores_length1;
				_tmp30_ = _tmp29_[i];
				_folks_backends_kf_backend_remove_store (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore), FALSE);
			}
		}
	}
	if (added_stores) {
		_tmp31_ = TRUE;
	} else {
		FolksBackendsKfPersonaStore** _tmp32_;
		gint _tmp32__length1;
		_tmp32_ = removed_stores;
		_tmp32__length1 = removed_stores_length1;
		_tmp31_ = _tmp32__length1 > 0;
	}
	if (_tmp31_) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
	removed_stores = (_vala_array_free (removed_stores, removed_stores_length1, (GDestroyNotify) g_object_unref), NULL);
}

/**
   * {@inheritDoc}
   */
FolksBackendsKfBackend*
folks_backends_kf_backend_construct (GType object_type)
{
	FolksBackendsKfBackend * self = NULL;
	self = (FolksBackendsKfBackend*) g_object_new (object_type, NULL);
	return self;
}

FolksBackendsKfBackend*
folks_backends_kf_backend_new (void)
{
	return folks_backends_kf_backend_construct (FOLKS_BACKENDS_KF_TYPE_BACKEND);
}

static void
folks_backends_kf_backend_real_prepare_data_free (gpointer _data)
{
	FolksBackendsKfBackendPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsKfBackendPrepareData, _data_);
}

static void
folks_backends_kf_backend_real_prepare (FolksBackend* base,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	FolksBackendsKfBackend * self;
	FolksBackendsKfBackendPrepareData* _data_;
	FolksBackendsKfBackend* _tmp0_;
	self = (FolksBackendsKfBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsKfBackendPrepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backends_kf_backend_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_kf_backend_real_prepare_co (_data_);
}

static void
folks_backends_kf_backend_prepare_finish (FolksBackend* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	FolksBackendsKfBackendPrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * {@inheritDoc}
   */
static gboolean
folks_backends_kf_backend_real_prepare_co (FolksBackendsKfBackendPrepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_internal_profiling_start ("preparing Kf.Backend", NULL);
	_data_->profiling = _data_->_tmp0_;
	if (_data_->self->priv->_is_prepared) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp1_ = _data_->self->priv->_prepare_pending;
	}
	if (_data_->_tmp1_) {
		_folks_internal_profile_block_free0 (_data_->profiling);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		g_object_freeze_notify ((GObject*) _data_->self);
		_data_->_tmp2_ = g_getenv ("FOLKS_BACKEND_KEY_FILE_PATH");
		_data_->path = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->path;
		if (_data_->_tmp3_ == NULL) {
			_data_->_tmp4_ = _folks_backends_kf_backend_get_default_file (_data_->self, "relationships");
			_g_object_unref0 (_data_->file);
			_data_->file = _data_->_tmp4_;
			_data_->_tmp5_ = _data_->file;
			_data_->_tmp6_ = g_file_get_path (_data_->_tmp5_);
			_data_->_tmp7_ = _data_->_tmp6_;
			g_debug ("Using built-in key file '%s' (override with " "environment variable FOLKS_BACKEND_KEY_FILE_PATH)", _data_->_tmp7_);
			_g_free0 (_data_->_tmp7_);
		} else {
			_data_->_tmp8_ = _data_->path;
			_data_->_tmp9_ = g_file_new_for_path (_data_->_tmp8_);
			_g_object_unref0 (_data_->file);
			_data_->file = _data_->_tmp9_;
			_data_->_tmp10_ = _data_->path;
			g_debug ("Using environment variable " "FOLKS_BACKEND_KEY_FILE_PATH = '%s' to load the key " "file.", _data_->_tmp10_);
		}
		_data_->_tmp11_ = _data_->file;
		_data_->_tmp12_ = folks_backends_kf_persona_store_new (_data_->_tmp11_);
		_data_->store = _data_->_tmp12_;
		_data_->_tmp13_ = _data_->store;
		_folks_backends_kf_backend_add_store (_data_->self, _data_->_tmp13_, TRUE);
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_g_object_unref0 (_data_->store);
		_g_object_unref0 (_data_->file);
	}
	__finally0:
	{
		g_object_thaw_notify ((GObject*) _data_->self);
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_folks_internal_profile_block_free0 (_data_->profiling);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->profiling;
	_data_->profiling = NULL;
	folks_internal_profiling_end (_data_->_tmp14_);
	_folks_internal_profile_block_free0 (_data_->profiling);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
   * Utility function to add a persona store.
   *
   * @param store the store to add.
   * @param notify whether or not to emit notification signals.
   */
static void
__folks_backends_kf_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender,
                                                                          gpointer self)
{
	_folks_backends_kf_backend_store_removed_cb ((FolksBackendsKfBackend*) self, _sender);
}

static void
_folks_backends_kf_backend_add_store (FolksBackendsKfBackend* self,
                                      FolksBackendsKfPersonaStore* store,
                                      gboolean notify)
{
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp2_ = _tmp1_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp2_, store);
	g_signal_connect_object ((FolksPersonaStore*) store, "removed", (GCallback) __folks_backends_kf_backend_store_removed_cb_folks_persona_store_removed, self, 0);
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", (FolksPersonaStore*) store);
	if (notify) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
}

/**
   * Utility function to remove a persona store.
   *
   * @param store the store to remove.
   * @param notify whether or not to emit notification signals.
   */
static void
_folks_backends_kf_backend_remove_store (FolksBackendsKfBackend* self,
                                         FolksBackendsKfPersonaStore* store,
                                         gboolean notify)
{
	guint _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((FolksPersonaStore*) store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) __folks_backends_kf_backend_store_removed_cb_folks_persona_store_removed, self);
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp3_ = _tmp2_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, _tmp3_, NULL);
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", (FolksPersonaStore*) store);
	if (notify) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
}

static void
folks_backends_kf_backend_real_unprepare_data_free (gpointer _data)
{
	FolksBackendsKfBackendUnprepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsKfBackendUnprepareData, _data_);
}

static void
folks_backends_kf_backend_real_unprepare (FolksBackend* base,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	FolksBackendsKfBackend * self;
	FolksBackendsKfBackendUnprepareData* _data_;
	FolksBackendsKfBackend* _tmp0_;
	self = (FolksBackendsKfBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsKfBackendUnprepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backends_kf_backend_real_unprepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_kf_backend_real_unprepare_co (_data_);
}

static void
folks_backends_kf_backend_unprepare_finish (FolksBackend* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	FolksBackendsKfBackendUnprepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * {@inheritDoc}
   */
static gboolean
folks_backends_kf_backend_real_unprepare_co (FolksBackendsKfBackendUnprepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!_data_->self->priv->_is_prepared) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp0_ = _data_->self->priv->_prepare_pending == TRUE;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		g_object_freeze_notify ((GObject*) _data_->self);
		{
			_data_->_tmp1_ = _data_->self->priv->_persona_stores;
			_data_->_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _data_->_tmp1_);
			_data_->_tmp3_ = _data_->_tmp2_;
			_data_->_tmp4_ = _data_->_tmp3_;
			_data_->_tmp5_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp4_);
			_data_->_tmp6_ = _data_->_tmp5_;
			_g_object_unref0 (_data_->_tmp4_);
			_data_->_persona_store_it = _data_->_tmp6_;
			while (TRUE) {
				_data_->_tmp7_ = _data_->_persona_store_it;
				if (!gee_iterator_next (_data_->_tmp7_)) {
					break;
				}
				_data_->_tmp8_ = _data_->_persona_store_it;
				_data_->_tmp9_ = gee_iterator_get (_data_->_tmp8_);
				_data_->persona_store = (FolksBackendsKfPersonaStore*) _data_->_tmp9_;
				_data_->_tmp10_ = _data_->persona_store;
				g_signal_emit_by_name ((FolksBackend*) _data_->self, "persona-store-removed", (FolksPersonaStore*) _data_->_tmp10_);
				_g_object_unref0 (_data_->persona_store);
			}
			_g_object_unref0 (_data_->_persona_store_it);
		}
		_data_->_tmp11_ = _data_->self->priv->_persona_stores;
		gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp11_);
		g_object_notify ((GObject*) _data_->self, "persona-stores");
		_data_->self->priv->_is_quiescent = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_data_->self->priv->_is_prepared = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
	}
	__finally0:
	{
		g_object_thaw_notify ((GObject*) _data_->self);
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_folks_backends_kf_backend_store_removed_cb (FolksBackendsKfBackend* self,
                                             FolksPersonaStore* store)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_folks_backends_kf_backend_remove_store (self, G_TYPE_CHECK_INSTANCE_CAST (store, FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore), TRUE);
}

static gboolean
folks_backends_kf_backend_real_get_is_prepared (FolksBackend* base)
{
	gboolean result;
	FolksBackendsKfBackend* self;
	self = (FolksBackendsKfBackend*) base;
	result = self->priv->_is_prepared;
	return result;
}

static gboolean
folks_backends_kf_backend_real_get_is_quiescent (FolksBackend* base)
{
	gboolean result;
	FolksBackendsKfBackend* self;
	self = (FolksBackendsKfBackend*) base;
	result = self->priv->_is_quiescent;
	return result;
}

static const gchar*
folks_backends_kf_backend_real_get_name (FolksBackend* base)
{
	const gchar* result;
	FolksBackendsKfBackend* self;
	self = (FolksBackendsKfBackend*) base;
	result = BACKEND_NAME;
	return result;
}

static GeeMap*
folks_backends_kf_backend_real_get_persona_stores (FolksBackend* base)
{
	GeeMap* result;
	FolksBackendsKfBackend* self;
	GeeMap* _tmp0_;
	self = (FolksBackendsKfBackend*) base;
	_tmp0_ = self->priv->_persona_stores_ro;
	result = _tmp0_;
	return result;
}

static GObject *
folks_backends_kf_backend_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsKfBackend * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	parent_class = G_OBJECT_CLASS (folks_backends_kf_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_KF_TYPE_BACKEND, FolksBackendsKfBackend);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_stores);
	self->priv->_persona_stores = _tmp0_;
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_persona_stores_ro);
	self->priv->_persona_stores_ro = _tmp3_;
	return obj;
}

static void
folks_backends_kf_backend_class_init (FolksBackendsKfBackendClass * klass,
                                      gpointer klass_data)
{
	folks_backends_kf_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksBackendsKfBackend_private_offset);
	((FolksBackendClass *) klass)->enable_persona_store = (void (*) (FolksBackend*, FolksPersonaStore*)) folks_backends_kf_backend_real_enable_persona_store;
	((FolksBackendClass *) klass)->disable_persona_store = (void (*) (FolksBackend*, FolksPersonaStore*)) folks_backends_kf_backend_real_disable_persona_store;
	((FolksBackendClass *) klass)->set_persona_stores = (void (*) (FolksBackend*, GeeSet*)) folks_backends_kf_backend_real_set_persona_stores;
	((FolksBackendClass *) klass)->prepare = (void (*) (FolksBackend*, GAsyncReadyCallback, gpointer)) folks_backends_kf_backend_real_prepare;
	((FolksBackendClass *) klass)->prepare_finish = (void (*) (FolksBackend*, GAsyncResult*, GError**)) folks_backends_kf_backend_prepare_finish;
	((FolksBackendClass *) klass)->unprepare = (void (*) (FolksBackend*, GAsyncReadyCallback, gpointer)) folks_backends_kf_backend_real_unprepare;
	((FolksBackendClass *) klass)->unprepare_finish = (void (*) (FolksBackend*, GAsyncResult*, GError**)) folks_backends_kf_backend_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = (gboolean (*) (FolksBackend*)) folks_backends_kf_backend_real_get_is_prepared;
	FOLKS_BACKEND_CLASS (klass)->get_is_quiescent = (gboolean (*) (FolksBackend*)) folks_backends_kf_backend_real_get_is_quiescent;
	FOLKS_BACKEND_CLASS (klass)->get_name = (const gchar* (*) (FolksBackend*)) folks_backends_kf_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = (GeeMap* (*) (FolksBackend*)) folks_backends_kf_backend_real_get_persona_stores;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_kf_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_kf_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_kf_backend_finalize;
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_BACKEND_IS_PREPARED_PROPERTY, folks_backends_kf_backend_properties[FOLKS_BACKENDS_KF_BACKEND_IS_PREPARED_PROPERTY] = g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this Backend has reached a quiescent state.
	   *
	   * See {@link Folks.Backend.is_quiescent}.
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_BACKEND_IS_QUIESCENT_PROPERTY, folks_backends_kf_backend_properties[FOLKS_BACKENDS_KF_BACKEND_IS_QUIESCENT_PROPERTY] = g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_BACKEND_NAME_PROPERTY, folks_backends_kf_backend_properties[FOLKS_BACKENDS_KF_BACKEND_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_BACKEND_PERSONA_STORES_PROPERTY, folks_backends_kf_backend_properties[FOLKS_BACKENDS_KF_BACKEND_PERSONA_STORES_PROPERTY] = g_param_spec_object ("persona-stores", "persona-stores", "persona-stores", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
folks_backends_kf_backend_instance_init (FolksBackendsKfBackend * self,
                                         gpointer klass)
{
	self->priv = folks_backends_kf_backend_get_instance_private (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
}

static void
folks_backends_kf_backend_finalize (GObject * obj)
{
	FolksBackendsKfBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_KF_TYPE_BACKEND, FolksBackendsKfBackend);
	_g_object_unref0 (self->priv->_persona_stores);
	_g_object_unref0 (self->priv->_persona_stores_ro);
	G_OBJECT_CLASS (folks_backends_kf_backend_parent_class)->finalize (obj);
}

/**
 * A backend which loads {@link Persona}s from a simple key file in
 * (XDG_DATA_HOME/folks/) and presents them through a single
 * {@link PersonaStore}.
 *
 * @since 0.1.13
 */
static GType
folks_backends_kf_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsKfBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_kf_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsKfBackend), 0, (GInstanceInitFunc) folks_backends_kf_backend_instance_init, NULL };
	GType folks_backends_kf_backend_type_id;
	folks_backends_kf_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsKfBackend", &g_define_type_info, 0);
	FolksBackendsKfBackend_private_offset = g_type_add_instance_private (folks_backends_kf_backend_type_id, sizeof (FolksBackendsKfBackendPrivate));
	return folks_backends_kf_backend_type_id;
}

GType
folks_backends_kf_backend_get_type (void)
{
	static volatile gsize folks_backends_kf_backend_type_id__once = 0;
	if (g_once_init_enter (&folks_backends_kf_backend_type_id__once)) {
		GType folks_backends_kf_backend_type_id;
		folks_backends_kf_backend_type_id = folks_backends_kf_backend_get_type_once ();
		g_once_init_leave (&folks_backends_kf_backend_type_id__once, folks_backends_kf_backend_type_id);
	}
	return folks_backends_kf_backend_type_id__once;
}

static void
_vala_folks_backends_kf_backend_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	FolksBackendsKfBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_KF_TYPE_BACKEND, FolksBackendsKfBackend);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_BACKEND_IS_PREPARED_PROPERTY:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_KF_BACKEND_IS_QUIESCENT_PROPERTY:
		g_value_set_boolean (value, folks_backend_get_is_quiescent ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_KF_BACKEND_NAME_PROPERTY:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_KF_BACKEND_PERSONA_STORES_PROPERTY:
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

