/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-pefile-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_pe_coff_machine_to_string(FuPeCoffMachine val)
{
    if (val == FU_PE_COFF_MACHINE_UNKNOWN)
        return "unknown";
    if (val == FU_PE_COFF_MACHINE_ALPHA)
        return "alpha";
    if (val == FU_PE_COFF_MACHINE_ALPHA64)
        return "alpha64";
    if (val == FU_PE_COFF_MACHINE_AM33)
        return "am33";
    if (val == FU_PE_COFF_MACHINE_AMD64)
        return "amd64";
    if (val == FU_PE_COFF_MACHINE_ARM)
        return "arm";
    if (val == FU_PE_COFF_MACHINE_ARM64)
        return "arm64";
    if (val == FU_PE_COFF_MACHINE_ARMNT)
        return "armnt";
    if (val == FU_PE_COFF_MACHINE_EBC)
        return "ebc";
    if (val == FU_PE_COFF_MACHINE_I386)
        return "i386";
    if (val == FU_PE_COFF_MACHINE_IA64)
        return "ia64";
    if (val == FU_PE_COFF_MACHINE_LOONGARCH32)
        return "loongarch32";
    if (val == FU_PE_COFF_MACHINE_LOONGARCH64)
        return "loongarch64";
    if (val == FU_PE_COFF_MACHINE_M32R)
        return "m32r";
    if (val == FU_PE_COFF_MACHINE_MIPS16)
        return "mips16";
    if (val == FU_PE_COFF_MACHINE_MIPSFPU)
        return "mipsfpu";
    if (val == FU_PE_COFF_MACHINE_MIPSFPU16)
        return "mipsfpu16";
    if (val == FU_PE_COFF_MACHINE_POWERPC)
        return "powerpc";
    if (val == FU_PE_COFF_MACHINE_POWERPCFP)
        return "powerpcfp";
    if (val == FU_PE_COFF_MACHINE_R4000)
        return "r4000";
    if (val == FU_PE_COFF_MACHINE_RISCV32)
        return "riscv32";
    if (val == FU_PE_COFF_MACHINE_RISCV64)
        return "riscv64";
    if (val == FU_PE_COFF_MACHINE_RISCV128)
        return "riscv128";
    if (val == FU_PE_COFF_MACHINE_SH3)
        return "sh3";
    if (val == FU_PE_COFF_MACHINE_SH3DSP)
        return "sh3dsp";
    if (val == FU_PE_COFF_MACHINE_SH4)
        return "sh4";
    if (val == FU_PE_COFF_MACHINE_SH5)
        return "sh5";
    if (val == FU_PE_COFF_MACHINE_THUMB)
        return "thumb";
    if (val == FU_PE_COFF_MACHINE_WCEMIPSV2)
        return "wcemipsv2";
    return NULL;
}

static const gchar *
fu_pe_coff_magic_to_string(FuPeCoffMagic val)
{
    if (val == FU_PE_COFF_MAGIC_PE32)
        return "pe32";
    if (val == FU_PE_COFF_MAGIC_PE32_PLUS)
        return "pe32-plus";
    return NULL;
}

const gchar *
fu_coff_subsystem_to_string(FuCoffSubsystem val)
{
    if (val == FU_COFF_SUBSYSTEM_UNKNOWN)
        return "unknown";
    if (val == FU_COFF_SUBSYSTEM_NATIVE)
        return "native";
    if (val == FU_COFF_SUBSYSTEM_WINDOWS_GUI)
        return "windows-gui";
    if (val == FU_COFF_SUBSYSTEM_WINDOWS_CUI)
        return "windows-cui";
    if (val == FU_COFF_SUBSYSTEM_OS2_CUI)
        return "os2-cui";
    if (val == FU_COFF_SUBSYSTEM_POSIX_CUI)
        return "posix-cui";
    if (val == FU_COFF_SUBSYSTEM_NATIVE_WINDOWS)
        return "native-windows";
    if (val == FU_COFF_SUBSYSTEM_WINDOWS_CE_GUI)
        return "windows-ce-gui";
    if (val == FU_COFF_SUBSYSTEM_EFI_APPLICATION)
        return "efi-application";
    if (val == FU_COFF_SUBSYSTEM_EFI_BOOT_SERVICE_DRIVER)
        return "efi-boot-service-driver";
    if (val == FU_COFF_SUBSYSTEM_EFI_RUNTIME_DRIVER)
        return "efi-runtime-driver";
    if (val == FU_COFF_SUBSYSTEM_EFI_ROM)
        return "efi-rom";
    if (val == FU_COFF_SUBSYSTEM_XBOX)
        return "xbox";
    if (val == FU_COFF_SUBSYSTEM_WINDOWS_BOOT_APPLICATION)
        return "windows-boot-application";
    return NULL;
}
/**
 * fu_struct_pe_dos_header_ref: (skip):
 **/
FuStructPeDosHeader *
fu_struct_pe_dos_header_ref(FuStructPeDosHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_pe_dos_header_unref: (skip):
 **/
void
fu_struct_pe_dos_header_unref(FuStructPeDosHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPeDosHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_pe_dos_header_new_internal: (skip):
 **/
static FuStructPeDosHeader *
fu_struct_pe_dos_header_new_internal(void)
{
    FuStructPeDosHeader *st = g_new0(FuStructPeDosHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_pe_dos_header_get_magic: (skip):
 **/
static guint16
fu_struct_pe_dos_header_get_magic(const FuStructPeDosHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_get_cblp: (skip):
 **/
guint16
fu_struct_pe_dos_header_get_cblp(const FuStructPeDosHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_get_cp: (skip):
 **/
guint16
fu_struct_pe_dos_header_get_cp(const FuStructPeDosHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_get_crlc: (skip):
 **/
guint16
fu_struct_pe_dos_header_get_crlc(const FuStructPeDosHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_get_cparhdr: (skip):
 **/
guint16
fu_struct_pe_dos_header_get_cparhdr(const FuStructPeDosHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_get_minalloc: (skip):
 **/
guint16
fu_struct_pe_dos_header_get_minalloc(const FuStructPeDosHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_get_maxalloc: (skip):
 **/
guint16
fu_struct_pe_dos_header_get_maxalloc(const FuStructPeDosHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_get_sp: (skip):
 **/
guint16
fu_struct_pe_dos_header_get_sp(const FuStructPeDosHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_get_lfarlc: (skip):
 **/
guint16
fu_struct_pe_dos_header_get_lfarlc(const FuStructPeDosHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_get_lfanew: (skip):
 **/
guint32
fu_struct_pe_dos_header_get_lfanew(const FuStructPeDosHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 60, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_pe_dos_header_set_magic: (skip):
 **/
static void
fu_struct_pe_dos_header_set_magic(FuStructPeDosHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_set_cblp: (skip):
 **/
void
fu_struct_pe_dos_header_set_cblp(FuStructPeDosHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_set_cp: (skip):
 **/
void
fu_struct_pe_dos_header_set_cp(FuStructPeDosHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_set_crlc: (skip):
 **/
void
fu_struct_pe_dos_header_set_crlc(FuStructPeDosHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_set_cparhdr: (skip):
 **/
void
fu_struct_pe_dos_header_set_cparhdr(FuStructPeDosHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_set_minalloc: (skip):
 **/
void
fu_struct_pe_dos_header_set_minalloc(FuStructPeDosHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 10, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_set_maxalloc: (skip):
 **/
void
fu_struct_pe_dos_header_set_maxalloc(FuStructPeDosHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_set_sp: (skip):
 **/
void
fu_struct_pe_dos_header_set_sp(FuStructPeDosHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_set_lfarlc: (skip):
 **/
void
fu_struct_pe_dos_header_set_lfarlc(FuStructPeDosHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_set_lfanew: (skip):
 **/
void
fu_struct_pe_dos_header_set_lfanew(FuStructPeDosHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 60, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_new: (skip):
 **/
FuStructPeDosHeader *
fu_struct_pe_dos_header_new(void)
{
    FuStructPeDosHeader *st = fu_struct_pe_dos_header_new_internal();
    st->buf = g_byte_array_sized_new(128);
    fu_byte_array_set_size(st->buf, 128, 0x0);
    fu_struct_pe_dos_header_set_magic(st, 0x5A4D);
    fu_struct_pe_dos_header_set_cblp(st, 0x90);
    fu_struct_pe_dos_header_set_cp(st, 0x3);
    fu_struct_pe_dos_header_set_cparhdr(st, 0x4);
    fu_struct_pe_dos_header_set_maxalloc(st, 0xFFFF);
    fu_struct_pe_dos_header_set_sp(st, 0xB8);
    fu_struct_pe_dos_header_set_lfarlc(st, 0x40);
    fu_struct_pe_dos_header_set_lfanew(st, 0x80);
    return st;
}
/**
 * fu_struct_pe_dos_header_to_string: (skip):
 **/
static gchar *
fu_struct_pe_dos_header_to_string(const FuStructPeDosHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructPeDosHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  cblp: 0x%x\n",
                           (guint) fu_struct_pe_dos_header_get_cblp(st));
    g_string_append_printf(str, "  cp: 0x%x\n",
                           (guint) fu_struct_pe_dos_header_get_cp(st));
    g_string_append_printf(str, "  crlc: 0x%x\n",
                           (guint) fu_struct_pe_dos_header_get_crlc(st));
    g_string_append_printf(str, "  cparhdr: 0x%x\n",
                           (guint) fu_struct_pe_dos_header_get_cparhdr(st));
    g_string_append_printf(str, "  minalloc: 0x%x\n",
                           (guint) fu_struct_pe_dos_header_get_minalloc(st));
    g_string_append_printf(str, "  maxalloc: 0x%x\n",
                           (guint) fu_struct_pe_dos_header_get_maxalloc(st));
    g_string_append_printf(str, "  sp: 0x%x\n",
                           (guint) fu_struct_pe_dos_header_get_sp(st));
    g_string_append_printf(str, "  lfarlc: 0x%x\n",
                           (guint) fu_struct_pe_dos_header_get_lfarlc(st));
    g_string_append_printf(str, "  lfanew: 0x%x\n",
                           (guint) fu_struct_pe_dos_header_get_lfanew(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_pe_dos_header_validate_internal(FuStructPeDosHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_pe_dos_header_get_magic(st) != 0x5A4D) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructPeDosHeader.magic was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x5A4D,
                    (guint) fu_struct_pe_dos_header_get_magic(st));
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_pe_dos_header_validate_stream: (skip):
 **/
gboolean
fu_struct_pe_dos_header_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructPeDosHeader) st = fu_struct_pe_dos_header_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 128, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructPeDosHeader failed read of 0x%x: ", (guint) 128);
        return FALSE;
    }
    if (st->buf->len != 128) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructPeDosHeader requested 0x%x and got 0x%x",
                    (guint) 128,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_pe_dos_header_validate_internal(st, error);
}
static gboolean
fu_struct_pe_dos_header_parse_internal(FuStructPeDosHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_pe_dos_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_pe_dos_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_pe_dos_header_parse_stream: (skip):
 **/
FuStructPeDosHeader *
fu_struct_pe_dos_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructPeDosHeader) st = fu_struct_pe_dos_header_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 128, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructPeDosHeader failed read of 0x%x: ", (guint) 128);
        return NULL;
    }
    if (st->buf->len != 128) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructPeDosHeader requested 0x%x and got 0x%x",
                    (guint) 128,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_pe_dos_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_pe_coff_file_header_ref: (skip):
 **/
FuStructPeCoffFileHeader *
fu_struct_pe_coff_file_header_ref(FuStructPeCoffFileHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_pe_coff_file_header_unref: (skip):
 **/
void
fu_struct_pe_coff_file_header_unref(FuStructPeCoffFileHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPeCoffFileHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_pe_coff_file_header_new_internal: (skip):
 **/
static FuStructPeCoffFileHeader *
fu_struct_pe_coff_file_header_new_internal(void)
{
    FuStructPeCoffFileHeader *st = g_new0(FuStructPeCoffFileHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_pe_coff_file_header_get_signature: (skip):
 **/
static guint32
fu_struct_pe_coff_file_header_get_signature(const FuStructPeCoffFileHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_get_machine: (skip):
 **/
FuPeCoffMachine
fu_struct_pe_coff_file_header_get_machine(const FuStructPeCoffFileHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_get_number_of_sections: (skip):
 **/
guint16
fu_struct_pe_coff_file_header_get_number_of_sections(const FuStructPeCoffFileHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_get_pointer_to_symbol_table: (skip):
 **/
guint32
fu_struct_pe_coff_file_header_get_pointer_to_symbol_table(const FuStructPeCoffFileHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_get_number_of_symbols: (skip):
 **/
guint32
fu_struct_pe_coff_file_header_get_number_of_symbols(const FuStructPeCoffFileHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_get_size_of_optional_header: (skip):
 **/
guint16
fu_struct_pe_coff_file_header_get_size_of_optional_header(const FuStructPeCoffFileHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_get_characteristics: (skip):
 **/
guint16
fu_struct_pe_coff_file_header_get_characteristics(const FuStructPeCoffFileHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 22, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_pe_coff_file_header_set_signature: (skip):
 **/
static void
fu_struct_pe_coff_file_header_set_signature(FuStructPeCoffFileHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_set_machine: (skip):
 **/
void
fu_struct_pe_coff_file_header_set_machine(FuStructPeCoffFileHeader *st, FuPeCoffMachine value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_set_number_of_sections: (skip):
 **/
void
fu_struct_pe_coff_file_header_set_number_of_sections(FuStructPeCoffFileHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_set_pointer_to_symbol_table: (skip):
 **/
void
fu_struct_pe_coff_file_header_set_pointer_to_symbol_table(FuStructPeCoffFileHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_set_number_of_symbols: (skip):
 **/
void
fu_struct_pe_coff_file_header_set_number_of_symbols(FuStructPeCoffFileHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_set_size_of_optional_header: (skip):
 **/
void
fu_struct_pe_coff_file_header_set_size_of_optional_header(FuStructPeCoffFileHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_set_characteristics: (skip):
 **/
void
fu_struct_pe_coff_file_header_set_characteristics(FuStructPeCoffFileHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 22, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_new: (skip):
 **/
FuStructPeCoffFileHeader *
fu_struct_pe_coff_file_header_new(void)
{
    FuStructPeCoffFileHeader *st = fu_struct_pe_coff_file_header_new_internal();
    st->buf = g_byte_array_sized_new(24);
    fu_byte_array_set_size(st->buf, 24, 0x0);
    fu_struct_pe_coff_file_header_set_signature(st, 0x4550);
    fu_struct_pe_coff_file_header_set_machine(st, FU_PE_COFF_MACHINE_AMD64);
    fu_struct_pe_coff_file_header_set_size_of_optional_header(st, 0xf0);
    fu_struct_pe_coff_file_header_set_characteristics(st, 0x2022);
    return st;
}
/**
 * fu_struct_pe_coff_file_header_to_string: (skip):
 **/
static gchar *
fu_struct_pe_coff_file_header_to_string(const FuStructPeCoffFileHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructPeCoffFileHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_pe_coff_machine_to_string(fu_struct_pe_coff_file_header_get_machine(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  machine: 0x%x [%s]\n", (guint) fu_struct_pe_coff_file_header_get_machine(st), tmp);
        } else {
            g_string_append_printf(str, "  machine: 0x%x\n", (guint) fu_struct_pe_coff_file_header_get_machine(st));
        }
    }
    g_string_append_printf(str, "  number_of_sections: 0x%x\n",
                           (guint) fu_struct_pe_coff_file_header_get_number_of_sections(st));
    g_string_append_printf(str, "  pointer_to_symbol_table: 0x%x\n",
                           (guint) fu_struct_pe_coff_file_header_get_pointer_to_symbol_table(st));
    g_string_append_printf(str, "  number_of_symbols: 0x%x\n",
                           (guint) fu_struct_pe_coff_file_header_get_number_of_symbols(st));
    g_string_append_printf(str, "  size_of_optional_header: 0x%x\n",
                           (guint) fu_struct_pe_coff_file_header_get_size_of_optional_header(st));
    g_string_append_printf(str, "  characteristics: 0x%x\n",
                           (guint) fu_struct_pe_coff_file_header_get_characteristics(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_pe_coff_file_header_validate_internal(FuStructPeCoffFileHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_pe_coff_file_header_get_signature(st) != 0x4550) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructPeCoffFileHeader.signature was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x4550,
                    (guint) fu_struct_pe_coff_file_header_get_signature(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_pe_coff_file_header_parse_internal(FuStructPeCoffFileHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_pe_coff_file_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_pe_coff_file_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_pe_coff_file_header_parse_stream: (skip):
 **/
FuStructPeCoffFileHeader *
fu_struct_pe_coff_file_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructPeCoffFileHeader) st = fu_struct_pe_coff_file_header_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 24, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructPeCoffFileHeader failed read of 0x%x: ", (guint) 24);
        return NULL;
    }
    if (st->buf->len != 24) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructPeCoffFileHeader requested 0x%x and got 0x%x",
                    (guint) 24,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_pe_coff_file_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_pe_coff_optional_header64_ref: (skip):
 **/
FuStructPeCoffOptionalHeader64 *
fu_struct_pe_coff_optional_header64_ref(FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_pe_coff_optional_header64_unref: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_unref(FuStructPeCoffOptionalHeader64 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPeCoffOptionalHeader64 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_pe_coff_optional_header64_new_internal: (skip):
 **/
static FuStructPeCoffOptionalHeader64 *
fu_struct_pe_coff_optional_header64_new_internal(void)
{
    FuStructPeCoffOptionalHeader64 *st = g_new0(FuStructPeCoffOptionalHeader64, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_pe_coff_optional_header64_get_magic: (skip):
 **/
FuPeCoffMagic
fu_struct_pe_coff_optional_header64_get_magic(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_major_linker_version: (skip):
 **/
guint8
fu_struct_pe_coff_optional_header64_get_major_linker_version(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_pe_coff_optional_header64_get_minor_linker_version: (skip):
 **/
guint8
fu_struct_pe_coff_optional_header64_get_minor_linker_version(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_pe_coff_optional_header64_get_size_of_code: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_size_of_code(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_size_of_initialized_data: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_size_of_initialized_data(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_size_of_uninitialized_data: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_size_of_uninitialized_data(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_addressofentrypoint: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_addressofentrypoint(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_base_of_code: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_base_of_code(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_image_base: (skip):
 **/
guint64
fu_struct_pe_coff_optional_header64_get_image_base(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_section_alignment: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_section_alignment(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_file_alignment: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_file_alignment(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 36, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_size_of_image: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_size_of_image(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 56, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_size_of_headers: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_size_of_headers(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 60, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_checksum: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_checksum(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 64, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_subsystem: (skip):
 **/
FuCoffSubsystem
fu_struct_pe_coff_optional_header64_get_subsystem(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 68, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_loader_flags: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_loader_flags(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 104, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_number_of_rva_and_sizes: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_number_of_rva_and_sizes(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 108, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_certificate_table: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_certificate_table(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 144, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_size_of_certificate_table: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_size_of_certificate_table(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 148, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_debug_table: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_debug_table(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 152, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_size_of_debug_table: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_size_of_debug_table(const FuStructPeCoffOptionalHeader64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 156, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_pe_coff_optional_header64_set_magic: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_magic(FuStructPeCoffOptionalHeader64 *st, FuPeCoffMagic value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_major_linker_version: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_major_linker_version(FuStructPeCoffOptionalHeader64 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_pe_coff_optional_header64_set_minor_linker_version: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_minor_linker_version(FuStructPeCoffOptionalHeader64 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_pe_coff_optional_header64_set_size_of_code: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_size_of_code(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_size_of_initialized_data: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_size_of_initialized_data(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_size_of_uninitialized_data: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_size_of_uninitialized_data(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_addressofentrypoint: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_addressofentrypoint(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_base_of_code: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_base_of_code(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_image_base: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_image_base(FuStructPeCoffOptionalHeader64 *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_section_alignment: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_section_alignment(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 32, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_file_alignment: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_file_alignment(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 36, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_size_of_image: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_size_of_image(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 56, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_size_of_headers: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_size_of_headers(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 60, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_checksum: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_checksum(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 64, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_subsystem: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_subsystem(FuStructPeCoffOptionalHeader64 *st, FuCoffSubsystem value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 68, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_loader_flags: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_loader_flags(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 104, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_number_of_rva_and_sizes: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_number_of_rva_and_sizes(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 108, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_certificate_table: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_certificate_table(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 144, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_size_of_certificate_table: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_size_of_certificate_table(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 148, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_debug_table: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_debug_table(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 152, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_set_size_of_debug_table: (skip):
 **/
void
fu_struct_pe_coff_optional_header64_set_size_of_debug_table(FuStructPeCoffOptionalHeader64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 156, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_new: (skip):
 **/
FuStructPeCoffOptionalHeader64 *
fu_struct_pe_coff_optional_header64_new(void)
{
    FuStructPeCoffOptionalHeader64 *st = fu_struct_pe_coff_optional_header64_new_internal();
    st->buf = g_byte_array_sized_new(176);
    fu_byte_array_set_size(st->buf, 176, 0x0);
    fu_struct_pe_coff_optional_header64_set_magic(st, FU_PE_COFF_MAGIC_PE32_PLUS);
    fu_struct_pe_coff_optional_header64_set_major_linker_version(st, 0x0e);
    fu_struct_pe_coff_optional_header64_set_minor_linker_version(st, 0x0e);
    fu_struct_pe_coff_optional_header64_set_section_alignment(st, 0x200);
    fu_struct_pe_coff_optional_header64_set_file_alignment(st, 0x200);
    fu_struct_pe_coff_optional_header64_set_subsystem(st, FU_COFF_SUBSYSTEM_EFI_APPLICATION);
    return st;
}
/**
 * fu_struct_pe_coff_optional_header64_to_string: (skip):
 **/
static gchar *
fu_struct_pe_coff_optional_header64_to_string(const FuStructPeCoffOptionalHeader64 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructPeCoffOptionalHeader64:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_pe_coff_magic_to_string(fu_struct_pe_coff_optional_header64_get_magic(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  magic: 0x%x [%s]\n", (guint) fu_struct_pe_coff_optional_header64_get_magic(st), tmp);
        } else {
            g_string_append_printf(str, "  magic: 0x%x\n", (guint) fu_struct_pe_coff_optional_header64_get_magic(st));
        }
    }
    g_string_append_printf(str, "  major_linker_version: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_major_linker_version(st));
    g_string_append_printf(str, "  minor_linker_version: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_minor_linker_version(st));
    g_string_append_printf(str, "  size_of_code: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_size_of_code(st));
    g_string_append_printf(str, "  size_of_initialized_data: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_size_of_initialized_data(st));
    g_string_append_printf(str, "  size_of_uninitialized_data: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_size_of_uninitialized_data(st));
    g_string_append_printf(str, "  addressofentrypoint: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_addressofentrypoint(st));
    g_string_append_printf(str, "  base_of_code: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_base_of_code(st));
    g_string_append_printf(str, "  image_base: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_image_base(st));
    g_string_append_printf(str, "  section_alignment: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_section_alignment(st));
    g_string_append_printf(str, "  file_alignment: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_file_alignment(st));
    g_string_append_printf(str, "  size_of_image: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_size_of_image(st));
    g_string_append_printf(str, "  size_of_headers: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_size_of_headers(st));
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_checksum(st));
    {
        const gchar *tmp = fu_coff_subsystem_to_string(fu_struct_pe_coff_optional_header64_get_subsystem(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  subsystem: 0x%x [%s]\n", (guint) fu_struct_pe_coff_optional_header64_get_subsystem(st), tmp);
        } else {
            g_string_append_printf(str, "  subsystem: 0x%x\n", (guint) fu_struct_pe_coff_optional_header64_get_subsystem(st));
        }
    }
    g_string_append_printf(str, "  loader_flags: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_loader_flags(st));
    g_string_append_printf(str, "  number_of_rva_and_sizes: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_number_of_rva_and_sizes(st));
    g_string_append_printf(str, "  certificate_table: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_certificate_table(st));
    g_string_append_printf(str, "  size_of_certificate_table: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_size_of_certificate_table(st));
    g_string_append_printf(str, "  debug_table: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_debug_table(st));
    g_string_append_printf(str, "  size_of_debug_table: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_size_of_debug_table(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_pe_coff_optional_header64_validate_internal(FuStructPeCoffOptionalHeader64 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_pe_coff_optional_header64_parse_internal(FuStructPeCoffOptionalHeader64 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_pe_coff_optional_header64_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_pe_coff_optional_header64_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_pe_coff_optional_header64_parse_stream: (skip):
 **/
FuStructPeCoffOptionalHeader64 *
fu_struct_pe_coff_optional_header64_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructPeCoffOptionalHeader64) st = fu_struct_pe_coff_optional_header64_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 176, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructPeCoffOptionalHeader64 failed read of 0x%x: ", (guint) 176);
        return NULL;
    }
    if (st->buf->len != 176) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructPeCoffOptionalHeader64 requested 0x%x and got 0x%x",
                    (guint) 176,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_pe_coff_optional_header64_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_pe_coff_symbol_ref: (skip):
 **/
FuStructPeCoffSymbol *
fu_struct_pe_coff_symbol_ref(FuStructPeCoffSymbol *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_pe_coff_symbol_unref: (skip):
 **/
void
fu_struct_pe_coff_symbol_unref(FuStructPeCoffSymbol *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPeCoffSymbol refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}

/* getters */

/* setters */
/**
 * fu_struct_pe_coff_section_ref: (skip):
 **/
FuStructPeCoffSection *
fu_struct_pe_coff_section_ref(FuStructPeCoffSection *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_pe_coff_section_unref: (skip):
 **/
void
fu_struct_pe_coff_section_unref(FuStructPeCoffSection *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPeCoffSection refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_pe_coff_section_new_internal: (skip):
 **/
static FuStructPeCoffSection *
fu_struct_pe_coff_section_new_internal(void)
{
    FuStructPeCoffSection *st = g_new0(FuStructPeCoffSection, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_pe_coff_section_get_name: (skip):
 **/
gchar *
fu_struct_pe_coff_section_get_name(const FuStructPeCoffSection *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 8, NULL);
}
/**
 * fu_struct_pe_coff_section_get_virtual_size: (skip):
 **/
guint32
fu_struct_pe_coff_section_get_virtual_size(const FuStructPeCoffSection *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_section_get_virtual_address: (skip):
 **/
guint32
fu_struct_pe_coff_section_get_virtual_address(const FuStructPeCoffSection *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_section_get_size_of_raw_data: (skip):
 **/
guint32
fu_struct_pe_coff_section_get_size_of_raw_data(const FuStructPeCoffSection *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_section_get_pointer_to_raw_data: (skip):
 **/
guint32
fu_struct_pe_coff_section_get_pointer_to_raw_data(const FuStructPeCoffSection *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_section_get_characteristics: (skip):
 **/
guint32
fu_struct_pe_coff_section_get_characteristics(const FuStructPeCoffSection *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 36, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_pe_coff_section_set_name: (skip):
 **/
gboolean
fu_struct_pe_coff_section_set_name(FuStructPeCoffSection *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 0, 0x0, 8);
        return TRUE;
    }
    len = strlen(value);
    if (len > 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructPeCoffSection.name (0x%x bytes)",
                    value, (guint) len, (guint) 8);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_pe_coff_section_set_virtual_size: (skip):
 **/
void
fu_struct_pe_coff_section_set_virtual_size(FuStructPeCoffSection *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_section_set_virtual_address: (skip):
 **/
void
fu_struct_pe_coff_section_set_virtual_address(FuStructPeCoffSection *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_section_set_size_of_raw_data: (skip):
 **/
void
fu_struct_pe_coff_section_set_size_of_raw_data(FuStructPeCoffSection *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_section_set_pointer_to_raw_data: (skip):
 **/
void
fu_struct_pe_coff_section_set_pointer_to_raw_data(FuStructPeCoffSection *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_section_set_characteristics: (skip):
 **/
void
fu_struct_pe_coff_section_set_characteristics(FuStructPeCoffSection *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 36, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_section_new: (skip):
 **/
FuStructPeCoffSection *
fu_struct_pe_coff_section_new(void)
{
    FuStructPeCoffSection *st = fu_struct_pe_coff_section_new_internal();
    st->buf = g_byte_array_sized_new(40);
    fu_byte_array_set_size(st->buf, 40, 0x0);
    return st;
}
/**
 * fu_struct_pe_coff_section_to_string: (skip):
 **/
static gchar *
fu_struct_pe_coff_section_to_string(const FuStructPeCoffSection *st)
{
    g_autoptr(GString) str = g_string_new("FuStructPeCoffSection:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_pe_coff_section_get_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  name: %s\n", tmp);
    }
    g_string_append_printf(str, "  virtual_size: 0x%x\n",
                           (guint) fu_struct_pe_coff_section_get_virtual_size(st));
    g_string_append_printf(str, "  virtual_address: 0x%x\n",
                           (guint) fu_struct_pe_coff_section_get_virtual_address(st));
    g_string_append_printf(str, "  size_of_raw_data: 0x%x\n",
                           (guint) fu_struct_pe_coff_section_get_size_of_raw_data(st));
    g_string_append_printf(str, "  pointer_to_raw_data: 0x%x\n",
                           (guint) fu_struct_pe_coff_section_get_pointer_to_raw_data(st));
    g_string_append_printf(str, "  characteristics: 0x%x\n",
                           (guint) fu_struct_pe_coff_section_get_characteristics(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_pe_coff_section_validate_internal(FuStructPeCoffSection *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_pe_coff_section_parse_internal(FuStructPeCoffSection *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_pe_coff_section_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_pe_coff_section_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_pe_coff_section_parse_stream: (skip):
 **/
FuStructPeCoffSection *
fu_struct_pe_coff_section_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructPeCoffSection) st = fu_struct_pe_coff_section_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 40, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructPeCoffSection failed read of 0x%x: ", (guint) 40);
        return NULL;
    }
    if (st->buf->len != 40) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructPeCoffSection requested 0x%x and got 0x%x",
                    (guint) 40,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_pe_coff_section_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
