/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_file_meta_source = R"doc(Reads stream from file with meta-data headers. Headers are parsed into tags.

The information in the metadata headers includes:



Any item inside of the extra header dictionary is ready out and made into a stream tag.

Constructor Specific Documentation:

Create a meta-data file source.

Args:
    filename : (string): Name of file to write data to.
    repeat : (bool): Repeats file when EOF is found.
    detached_header : (bool): Set to true if header info is stored in a separate file (usually named filename.hdr)
    hdr_filename : (string): Name of detached header file if used. Defaults to 'filename.hdr' if detached_header is true but this field is an empty string.)doc";


static const char* __doc_gr_blocks_file_meta_source_file_meta_source_0 = R"doc()doc";


static const char* __doc_gr_blocks_file_meta_source_file_meta_source_1 = R"doc()doc";


static const char* __doc_gr_blocks_file_meta_source_make = R"doc(Reads stream from file with meta-data headers. Headers are parsed into tags.

The information in the metadata headers includes:



Any item inside of the extra header dictionary is ready out and made into a stream tag.

Constructor Specific Documentation:

Create a meta-data file source.

Args:
    filename : (string): Name of file to write data to.
    repeat : (bool): Repeats file when EOF is found.
    detached_header : (bool): Set to true if header info is stored in a separate file (usually named filename.hdr)
    hdr_filename : (string): Name of detached header file if used. Defaults to 'filename.hdr' if detached_header is true but this field is an empty string.)doc";


static const char* __doc_gr_blocks_file_meta_source_open = R"doc()doc";


static const char* __doc_gr_blocks_file_meta_source_close = R"doc()doc";


static const char* __doc_gr_blocks_file_meta_source_do_update = R"doc()doc";
