/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_tag_debug = R"doc(Bit bucket that prints out any tag received.

This block collects all tags sent to it on all input ports and displays them to stdout in a formatted way. The  parameter is used to identify which debug sink generated the tag, so when connecting a block to this debug sink, an appropriate name is something that identifies the input block.


This block otherwise acts as a NULL sink in that items from the input stream are ignored. It is designed to be able to attach to any block and watch all tags streaming out of that block for debugging purposes.


Specifying a key will allow this block to filter out all other tags and only display tags that match the given key. This can help clean up the output and allow you to focus in on a particular tag of interest.


The tags from the last call to this work function are stored and can be retrieved using the function 'current_tags'.

Constructor Specific Documentation:

Build a tag debug block

Args:
    sizeof_stream_item : size of the items in the incoming stream.
    name : name to identify which debug sink generated the info.
    key_filter : Specify a tag's key value to use as a filter.)doc";


static const char* __doc_gr_blocks_tag_debug_tag_debug_0 = R"doc()doc";


static const char* __doc_gr_blocks_tag_debug_tag_debug_1 = R"doc()doc";


static const char* __doc_gr_blocks_tag_debug_make = R"doc(Bit bucket that prints out any tag received.

This block collects all tags sent to it on all input ports and displays them to stdout in a formatted way. The  parameter is used to identify which debug sink generated the tag, so when connecting a block to this debug sink, an appropriate name is something that identifies the input block.


This block otherwise acts as a NULL sink in that items from the input stream are ignored. It is designed to be able to attach to any block and watch all tags streaming out of that block for debugging purposes.


Specifying a key will allow this block to filter out all other tags and only display tags that match the given key. This can help clean up the output and allow you to focus in on a particular tag of interest.


The tags from the last call to this work function are stored and can be retrieved using the function 'current_tags'.

Constructor Specific Documentation:

Build a tag debug block

Args:
    sizeof_stream_item : size of the items in the incoming stream.
    name : name to identify which debug sink generated the info.
    key_filter : Specify a tag's key value to use as a filter.)doc";


static const char* __doc_gr_blocks_tag_debug_current_tags = R"doc(Returns a vector of tag_t items as of the last call to work.)doc";


static const char* __doc_gr_blocks_tag_debug_num_tags = R"doc(Return the total number of tags in the tag queue.)doc";


static const char* __doc_gr_blocks_tag_debug_set_display = R"doc(Set the display of tags to stdout on/off.)doc";


static const char* __doc_gr_blocks_tag_debug_set_save_all = R"doc(Set whether to store all tags ever received (s=True) or solely the tags from the last work (s=False).)doc";


static const char* __doc_gr_blocks_tag_debug_set_key_filter = R"doc(Set a new key to filter with.)doc";


static const char* __doc_gr_blocks_tag_debug_key_filter = R"doc(Get the current filter key.)doc";
