/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_ofdm_equalizer_static = R"doc(Very simple static equalizer for OFDM.

This is an extremely simple equalizer. It will only work for high-SNR, very, very slowly changing channels.


It simply divides the signal with the currently known channel state. Whenever a pilot symbol comes around, it updates the channel state on that particular carrier by dividing the received symbol with the known pilot symbol.

Constructor Specific Documentation:



Args:
    fft_len : 
    occupied_carriers : 
    pilot_carriers : 
    pilot_symbols : 
    symbols_skipped : 
    input_is_shifted : )doc";


static const char* __doc_gr_digital_ofdm_equalizer_static_ofdm_equalizer_static_0 =
    R"doc()doc";


static const char* __doc_gr_digital_ofdm_equalizer_static_ofdm_equalizer_static_1 =
    R"doc()doc";


static const char* __doc_gr_digital_ofdm_equalizer_static_equalize = R"doc(Divide the input signal with the current channel state.

Does the following (and nothing else):)doc";


static const char* __doc_gr_digital_ofdm_equalizer_static_make = R"doc(Very simple static equalizer for OFDM.

This is an extremely simple equalizer. It will only work for high-SNR, very, very slowly changing channels.


It simply divides the signal with the currently known channel state. Whenever a pilot symbol comes around, it updates the channel state on that particular carrier by dividing the received symbol with the known pilot symbol.

Constructor Specific Documentation:



Args:
    fft_len : 
    occupied_carriers : 
    pilot_carriers : 
    pilot_symbols : 
    symbols_skipped : 
    input_is_shifted : )doc";
