/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbt2_freqinterleaver_cc = R"doc(Frequency interleaves a T2 frame.

Input: T2 frame. 
Output: Frequency interleaved T2 frame.

Constructor Specific Documentation:

Create a DVB-T2 frequency interleaver.

Args:
    carriermode : number of carriers (normal or extended).
    fftsize : OFDM IFFT size.
    pilotpattern : DVB-T2 pilot pattern (PP1 - PP8).
    guardinterval : OFDM ISI guard interval.
    numdatasyms : number of OFDM symbols in a T2 frame.
    paprmode : PAPR reduction mode.
    version : DVB-T2 specification version.
    preamble : P1 symbol preamble format.)doc";


static const char* __doc_gr_dtv_dvbt2_freqinterleaver_cc_dvbt2_freqinterleaver_cc =
    R"doc()doc";


static const char* __doc_gr_dtv_dvbt2_freqinterleaver_cc_make = R"doc(Frequency interleaves a T2 frame.

Input: T2 frame. 
Output: Frequency interleaved T2 frame.

Constructor Specific Documentation:

Create a DVB-T2 frequency interleaver.

Args:
    carriermode : number of carriers (normal or extended).
    fftsize : OFDM IFFT size.
    pilotpattern : DVB-T2 pilot pattern (PP1 - PP8).
    guardinterval : OFDM ISI guard interval.
    numdatasyms : number of OFDM symbols in a T2 frame.
    paprmode : PAPR reduction mode.
    version : DVB-T2 specification version.
    preamble : P1 symbol preamble format.)doc";
