/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, qtgui, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_qtgui_histogram_sink_f = R"doc(A graphical sink to display a histogram.

This is a QT-based graphical sink the displays a histogram of the data.


This histogram allows you to set and change at runtime the number of points to plot at once and the number of bins in the histogram. Both x and y-axis have their own auto-scaling behavior. By default, auto-scaling the y-axis is turned on and continuously updates the y-axis max value based on the currently plotted histogram.


The x-axis auto-scaling function only updates once when clicked. This resets the x-axis to the current range of minimum and maximum values represented in the histogram. It resets any values currently displayed because the location and width of the bins may have changed.


The histogram also has an accumulate function that simply accumulates the data between calls to work. When accumulate is activated, the y-axis autoscaling is turned on by default as the values will quickly grow in the this direction.


The sink supports plotting streaming float data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Float Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of float 32 values (pmt::is_f32vector) or PDUs where the data is a uniform vector of float 32 values.

Constructor Specific Documentation:

Build floating point histogram sink.

Args:
    size : number of points to plot at once
    bins : number of bins to sort the data into
    xmin : minimum x-axis value
    xmax : maximum x-axis value
    name : title for the plot
    nconnections : number of signals connected to sink
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_histogram_sink_f_histogram_sink_f_0 = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_histogram_sink_f_1 = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_make = R"doc(A graphical sink to display a histogram.

This is a QT-based graphical sink the displays a histogram of the data.


This histogram allows you to set and change at runtime the number of points to plot at once and the number of bins in the histogram. Both x and y-axis have their own auto-scaling behavior. By default, auto-scaling the y-axis is turned on and continuously updates the y-axis max value based on the currently plotted histogram.


The x-axis auto-scaling function only updates once when clicked. This resets the x-axis to the current range of minimum and maximum values represented in the histogram. It resets any values currently displayed because the location and width of the bins may have changed.


The histogram also has an accumulate function that simply accumulates the data between calls to work. When accumulate is activated, the y-axis autoscaling is turned on by default as the values will quickly grow in the this direction.


The sink supports plotting streaming float data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Float Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of float 32 values (pmt::is_f32vector) or PDUs where the data is a uniform vector of float 32 values.

Constructor Specific Documentation:

Build floating point histogram sink.

Args:
    size : number of points to plot at once
    bins : number of bins to sort the data into
    xmin : minimum x-axis value
    xmax : maximum x-axis value
    name : title for the plot
    nconnections : number of signals connected to sink
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_histogram_sink_f_exec_ = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_qwidget = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_title = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_set_size = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_enable_menu = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_enable_grid = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_enable_autoscale = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_enable_semilogx = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_enable_semilogy = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_enable_accumulate = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_enable_axis_labels = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_autoscalex = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_nsamps = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_bins = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_reset = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_set_y_axis = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_set_x_axis = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_set_update_time = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_set_title = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_set_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_set_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_set_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_set_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_set_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_set_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_set_nsamps = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_set_bins = R"doc()doc";


static const char* __doc_gr_qtgui_histogram_sink_f_disable_legend = R"doc()doc";
