/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, analog, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_analog_pll_refout_cc = R"doc(Implements a PLL which locks to the input frequency and outputs a carrier.

Input stream 0: complex Output stream 0: complex


This PLL locks onto a [possibly noisy] reference carrier on the input and outputs a clean version which is phase and frequency aligned to it.


All settings max_freq and min_freq are in terms of radians per sample, NOT HERTZ. The loop bandwidth determines the lock range and should be set around pi/200  2pi/100.

Constructor Specific Documentation:



Args:
    loop_bw : 
    max_freq : 
    min_freq : )doc";


static const char* __doc_gr_analog_pll_refout_cc_pll_refout_cc = R"doc()doc";


static const char* __doc_gr_analog_pll_refout_cc_make = R"doc(Implements a PLL which locks to the input frequency and outputs a carrier.

Input stream 0: complex Output stream 0: complex


This PLL locks onto a [possibly noisy] reference carrier on the input and outputs a clean version which is phase and frequency aligned to it.


All settings max_freq and min_freq are in terms of radians per sample, NOT HERTZ. The loop bandwidth determines the lock range and should be set around pi/200  2pi/100.

Constructor Specific Documentation:



Args:
    loop_bw : 
    max_freq : 
    min_freq : )doc";
