/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_linear_equalizer = R"doc(Linear Equalizer block provides linear equalization using a specified adaptive algorithm.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of gr::digital::linear_equalizer.

The Linear Equalizer block equalizes the incoming signal using an FIR filter. If provided with a training sequence and a training start tag, data aided equalization will be performed starting with the tagged sample. If training-based equalization is active and the training sequence ends, then optionally decision directed equalization will be performed given the adapt_after_training If no training sequence or no tag is provided, decision directed equalization will be performed This equalizer decimates to the symbol rate according to the samples per symbol param

Args:
    num_taps : Number of taps for the FIR filter
    sps : int - Samples per Symbol
    alg : Adaptive algorithm object
    training_sequence : Sequence of samples that will be used to train the equalizer. Provide empty vector to default to DD equalizer
    adapt_after_training : bool - set true to continue DD training after training sequence has been used up
    training_start_tag : string - tag that indicates the start of the training sequence in the incoming data)doc";


static const char* __doc_gr_digital_linear_equalizer_linear_equalizer_0 = R"doc()doc";


static const char* __doc_gr_digital_linear_equalizer_linear_equalizer_1 = R"doc()doc";


static const char* __doc_gr_digital_linear_equalizer_make = R"doc(Linear Equalizer block provides linear equalization using a specified adaptive algorithm.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of gr::digital::linear_equalizer.

The Linear Equalizer block equalizes the incoming signal using an FIR filter. If provided with a training sequence and a training start tag, data aided equalization will be performed starting with the tagged sample. If training-based equalization is active and the training sequence ends, then optionally decision directed equalization will be performed given the adapt_after_training If no training sequence or no tag is provided, decision directed equalization will be performed This equalizer decimates to the symbol rate according to the samples per symbol param

Args:
    num_taps : Number of taps for the FIR filter
    sps : int - Samples per Symbol
    alg : Adaptive algorithm object
    training_sequence : Sequence of samples that will be used to train the equalizer. Provide empty vector to default to DD equalizer
    adapt_after_training : bool - set true to continue DD training after training sequence has been used up
    training_start_tag : string - tag that indicates the start of the training sequence in the incoming data)doc";


static const char* __doc_gr_digital_linear_equalizer_set_taps = R"doc()doc";


static const char* __doc_gr_digital_linear_equalizer_taps = R"doc()doc";


static const char* __doc_gr_digital_linear_equalizer_equalize = R"doc(Public \"work\" function - equalize a block of input samples.

Behaves similar to the block's work function, but made public to be able to be called outside the GNU Radio scheduler on bursty data)doc";
