/*
 * Copyright 2021 Marcus Müller
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, uhd, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_uhd_rfnoc_tx_streamer = R"doc(RFNoC Tx Streamer: Block to handle data flow from a GNU Radio flow graph into an RFNoC flow graph.


Use this block for egress from a GNU Radio flow graph. \"Tx\" is from the viewpoint of the GNU Radio flow graph. For example, if the GNU Radio flow graph is creating samples to be transmitted to a radio, use this block to transport the samples out of GNU Radio.


Note: The output ports of this block can only connect to other RFNoC blocks.

Constructor Specific Documentation:



Args:
    graph : Reference to the graph this block is connected to
    num_chans : Number of input- and output ports
    stream_args : These will be passed on to rfnoc_graph::create_tx_streamer, see that for details. The cpu_format and otw_format parts of these args will be used to determine the in- and output signatures of this block.
    vlen : Vector length)doc";


static const char* __doc_gr_uhd_rfnoc_tx_streamer_rfnoc_tx_streamer_0 = R"doc()doc";


static const char* __doc_gr_uhd_rfnoc_tx_streamer_rfnoc_tx_streamer_1 = R"doc()doc";


static const char* __doc_gr_uhd_rfnoc_tx_streamer_make = R"doc(RFNoC Tx Streamer: Block to handle data flow from a GNU Radio flow graph into an RFNoC flow graph.


Use this block for egress from a GNU Radio flow graph. \"Tx\" is from the viewpoint of the GNU Radio flow graph. For example, if the GNU Radio flow graph is creating samples to be transmitted to a radio, use this block to transport the samples out of GNU Radio.


Note: The output ports of this block can only connect to other RFNoC blocks.

Constructor Specific Documentation:



Args:
    graph : Reference to the graph this block is connected to
    num_chans : Number of input- and output ports
    stream_args : These will be passed on to rfnoc_graph::create_tx_streamer, see that for details. The cpu_format and otw_format parts of these args will be used to determine the in- and output signatures of this block.
    vlen : Vector length)doc";


static const char* __doc_gr_uhd_rfnoc_tx_streamer_get_unique_id = R"doc(Return the unique ID associated with the underlying RFNoC streamer.)doc";
