/* mechname.c --- Get name of SASL mechanism used in a session.
 * Copyright (C) 2008-2025 Simon Josefsson
 *
 * This file is part of GNU SASL Library.
 *
 * GNU SASL Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * GNU SASL Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNU SASL Library; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 */

#include <config.h>
#include "internal.h"

/**
 * gsasl_mechanism_name:
 * @sctx: libgsasl session handle.
 *
 * This function returns the name of the SASL mechanism used in the
 * session.  The pointer must not be deallocated by the caller.
 *
 * Return value: Returns a zero terminated character array with the
 *   name of the SASL mechanism, or NULL if not known.
 *
 * Since: 0.2.28
 **/
const char *
gsasl_mechanism_name (Gsasl_session *sctx)
{
  if (!sctx || !sctx->mech)
    return NULL;
  return sctx->mech->name;
}
