{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- GdkMonitor objects represent the individual outputs that are
-- associated with a t'GI.Gdk.Objects.Display.Display'. GdkDisplay has APIs to enumerate
-- monitors with 'GI.Gdk.Objects.Display.displayGetNMonitors' and 'GI.Gdk.Objects.Display.displayGetMonitor', and
-- to find particular monitors with 'GI.Gdk.Objects.Display.displayGetPrimaryMonitor' or
-- 'GI.Gdk.Objects.Display.displayGetMonitorAtWindow'.
-- 
-- GdkMonitor was introduced in GTK+ 3.22 and supersedes earlier
-- APIs in GdkScreen to obtain monitor-related information.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.Monitor
    ( 

-- * Exported types
    Monitor(..)                             ,
    IsMonitor                               ,
    toMonitor                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isPrimary]("GI.Gdk.Objects.Monitor#g:method:isPrimary"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gdk.Objects.Monitor#g:method:getDisplay"), [getGeometry]("GI.Gdk.Objects.Monitor#g:method:getGeometry"), [getHeightMm]("GI.Gdk.Objects.Monitor#g:method:getHeightMm"), [getManufacturer]("GI.Gdk.Objects.Monitor#g:method:getManufacturer"), [getModel]("GI.Gdk.Objects.Monitor#g:method:getModel"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRefreshRate]("GI.Gdk.Objects.Monitor#g:method:getRefreshRate"), [getScaleFactor]("GI.Gdk.Objects.Monitor#g:method:getScaleFactor"), [getSubpixelLayout]("GI.Gdk.Objects.Monitor#g:method:getSubpixelLayout"), [getWidthMm]("GI.Gdk.Objects.Monitor#g:method:getWidthMm"), [getWorkarea]("GI.Gdk.Objects.Monitor#g:method:getWorkarea").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveMonitorMethod                    ,
#endif

-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    MonitorGetDisplayMethodInfo             ,
#endif
    monitorGetDisplay                       ,


-- ** getGeometry #method:getGeometry#

#if defined(ENABLE_OVERLOADING)
    MonitorGetGeometryMethodInfo            ,
#endif
    monitorGetGeometry                      ,


-- ** getHeightMm #method:getHeightMm#

#if defined(ENABLE_OVERLOADING)
    MonitorGetHeightMmMethodInfo            ,
#endif
    monitorGetHeightMm                      ,


-- ** getManufacturer #method:getManufacturer#

#if defined(ENABLE_OVERLOADING)
    MonitorGetManufacturerMethodInfo        ,
#endif
    monitorGetManufacturer                  ,


-- ** getModel #method:getModel#

#if defined(ENABLE_OVERLOADING)
    MonitorGetModelMethodInfo               ,
#endif
    monitorGetModel                         ,


-- ** getRefreshRate #method:getRefreshRate#

#if defined(ENABLE_OVERLOADING)
    MonitorGetRefreshRateMethodInfo         ,
#endif
    monitorGetRefreshRate                   ,


-- ** getScaleFactor #method:getScaleFactor#

#if defined(ENABLE_OVERLOADING)
    MonitorGetScaleFactorMethodInfo         ,
#endif
    monitorGetScaleFactor                   ,


-- ** getSubpixelLayout #method:getSubpixelLayout#

#if defined(ENABLE_OVERLOADING)
    MonitorGetSubpixelLayoutMethodInfo      ,
#endif
    monitorGetSubpixelLayout                ,


-- ** getWidthMm #method:getWidthMm#

#if defined(ENABLE_OVERLOADING)
    MonitorGetWidthMmMethodInfo             ,
#endif
    monitorGetWidthMm                       ,


-- ** getWorkarea #method:getWorkarea#

#if defined(ENABLE_OVERLOADING)
    MonitorGetWorkareaMethodInfo            ,
#endif
    monitorGetWorkarea                      ,


-- ** isPrimary #method:isPrimary#

#if defined(ENABLE_OVERLOADING)
    MonitorIsPrimaryMethodInfo              ,
#endif
    monitorIsPrimary                        ,




 -- * Properties


-- ** display #attr:display#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    MonitorDisplayPropertyInfo              ,
#endif
    constructMonitorDisplay                 ,
    getMonitorDisplay                       ,
#if defined(ENABLE_OVERLOADING)
    monitorDisplay                          ,
#endif


-- ** geometry #attr:geometry#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    MonitorGeometryPropertyInfo             ,
#endif
    getMonitorGeometry                      ,
#if defined(ENABLE_OVERLOADING)
    monitorGeometry                         ,
#endif


-- ** heightMm #attr:heightMm#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    MonitorHeightMmPropertyInfo             ,
#endif
    getMonitorHeightMm                      ,
#if defined(ENABLE_OVERLOADING)
    monitorHeightMm                         ,
#endif


-- ** manufacturer #attr:manufacturer#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    MonitorManufacturerPropertyInfo         ,
#endif
    getMonitorManufacturer                  ,
#if defined(ENABLE_OVERLOADING)
    monitorManufacturer                     ,
#endif


-- ** model #attr:model#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    MonitorModelPropertyInfo                ,
#endif
    getMonitorModel                         ,
#if defined(ENABLE_OVERLOADING)
    monitorModel                            ,
#endif


-- ** refreshRate #attr:refreshRate#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    MonitorRefreshRatePropertyInfo          ,
#endif
    getMonitorRefreshRate                   ,
#if defined(ENABLE_OVERLOADING)
    monitorRefreshRate                      ,
#endif


-- ** scaleFactor #attr:scaleFactor#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    MonitorScaleFactorPropertyInfo          ,
#endif
    getMonitorScaleFactor                   ,
#if defined(ENABLE_OVERLOADING)
    monitorScaleFactor                      ,
#endif


-- ** subpixelLayout #attr:subpixelLayout#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    MonitorSubpixelLayoutPropertyInfo       ,
#endif
    getMonitorSubpixelLayout                ,
#if defined(ENABLE_OVERLOADING)
    monitorSubpixelLayout                   ,
#endif


-- ** widthMm #attr:widthMm#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    MonitorWidthMmPropertyInfo              ,
#endif
    getMonitorWidthMm                       ,
#if defined(ENABLE_OVERLOADING)
    monitorWidthMm                          ,
#endif


-- ** workarea #attr:workarea#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    MonitorWorkareaPropertyInfo             ,
#endif
    getMonitorWorkarea                      ,
#if defined(ENABLE_OVERLOADING)
    monitorWorkarea                         ,
#endif




 -- * Signals


-- ** invalidate #signal:invalidate#

    MonitorInvalidateCallback               ,
#if defined(ENABLE_OVERLOADING)
    MonitorInvalidateSignalInfo             ,
#endif
    afterMonitorInvalidate                  ,
    onMonitorInvalidate                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle

#endif

-- | Memory-managed wrapper type.
newtype Monitor = Monitor (SP.ManagedPtr Monitor)
    deriving (Eq)

instance SP.ManagedPtrNewtype Monitor where
    toManagedPtr (Monitor p) = p

foreign import ccall "gdk_monitor_get_type"
    c_gdk_monitor_get_type :: IO B.Types.GType

instance B.Types.TypedObject Monitor where
    glibType = c_gdk_monitor_get_type

instance B.Types.GObject Monitor

-- | Type class for types which can be safely cast to t'Monitor', for instance with `toMonitor`.
class (SP.GObject o, O.IsDescendantOf Monitor o) => IsMonitor o
instance (SP.GObject o, O.IsDescendantOf Monitor o) => IsMonitor o

instance O.HasParentTypes Monitor
type instance O.ParentTypes Monitor = '[GObject.Object.Object]

-- | Cast to t'Monitor', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toMonitor :: (MIO.MonadIO m, IsMonitor o) => o -> m Monitor
toMonitor = MIO.liftIO . B.ManagedPtr.unsafeCastTo Monitor

-- | Convert t'Monitor' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Monitor) where
    gvalueGType_ = c_gdk_monitor_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Monitor)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Monitor)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Monitor ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMonitorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMonitorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMonitorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMonitorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMonitorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMonitorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMonitorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMonitorMethod "isPrimary" o = MonitorIsPrimaryMethodInfo
    ResolveMonitorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMonitorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMonitorMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMonitorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMonitorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMonitorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMonitorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMonitorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMonitorMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMonitorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMonitorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMonitorMethod "getDisplay" o = MonitorGetDisplayMethodInfo
    ResolveMonitorMethod "getGeometry" o = MonitorGetGeometryMethodInfo
    ResolveMonitorMethod "getHeightMm" o = MonitorGetHeightMmMethodInfo
    ResolveMonitorMethod "getManufacturer" o = MonitorGetManufacturerMethodInfo
    ResolveMonitorMethod "getModel" o = MonitorGetModelMethodInfo
    ResolveMonitorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMonitorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMonitorMethod "getRefreshRate" o = MonitorGetRefreshRateMethodInfo
    ResolveMonitorMethod "getScaleFactor" o = MonitorGetScaleFactorMethodInfo
    ResolveMonitorMethod "getSubpixelLayout" o = MonitorGetSubpixelLayoutMethodInfo
    ResolveMonitorMethod "getWidthMm" o = MonitorGetWidthMmMethodInfo
    ResolveMonitorMethod "getWorkarea" o = MonitorGetWorkareaMethodInfo
    ResolveMonitorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMonitorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMonitorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMonitorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMonitorMethod t Monitor, O.OverloadedMethod info Monitor p) => OL.IsLabel t (Monitor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMonitorMethod t Monitor, O.OverloadedMethod info Monitor p, R.HasField t Monitor p) => R.HasField t Monitor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMonitorMethod t Monitor, O.OverloadedMethodInfo info Monitor) => OL.IsLabel t (O.MethodProxy info Monitor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Monitor::invalidate
-- | /No description available in the introspection data./
type MonitorInvalidateCallback =
    IO ()

type C_MonitorInvalidateCallback =
    Ptr Monitor ->                          -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_MonitorInvalidateCallback`.
foreign import ccall "wrapper"
    mk_MonitorInvalidateCallback :: C_MonitorInvalidateCallback -> IO (FunPtr C_MonitorInvalidateCallback)

wrap_MonitorInvalidateCallback :: 
    GObject a => (a -> MonitorInvalidateCallback) ->
    C_MonitorInvalidateCallback
wrap_MonitorInvalidateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [invalidate](#signal:invalidate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' monitor #invalidate callback
-- @
-- 
-- 
onMonitorInvalidate :: (IsMonitor a, MonadIO m) => a -> ((?self :: a) => MonitorInvalidateCallback) -> m SignalHandlerId
onMonitorInvalidate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MonitorInvalidateCallback wrapped
    wrapped'' <- mk_MonitorInvalidateCallback wrapped'
    connectSignalFunPtr obj "invalidate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [invalidate](#signal:invalidate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' monitor #invalidate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMonitorInvalidate :: (IsMonitor a, MonadIO m) => a -> ((?self :: a) => MonitorInvalidateCallback) -> m SignalHandlerId
afterMonitorInvalidate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MonitorInvalidateCallback wrapped
    wrapped'' <- mk_MonitorInvalidateCallback wrapped'
    connectSignalFunPtr obj "invalidate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data MonitorInvalidateSignalInfo
instance SignalInfo MonitorInvalidateSignalInfo where
    type HaskellCallbackType MonitorInvalidateSignalInfo = MonitorInvalidateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MonitorInvalidateCallback cb
        cb'' <- mk_MonitorInvalidateCallback cb'
        connectSignalFunPtr obj "invalidate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor::invalidate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#g:signal:invalidate"})

#endif

-- VVV Prop "display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #display
-- @
getMonitorDisplay :: (MonadIO m, IsMonitor o) => o -> m Gdk.Display.Display
getMonitorDisplay obj = MIO.liftIO $ checkUnexpectedNothing "getMonitorDisplay" $ B.Properties.getObjectPropertyObject obj "display" Gdk.Display.Display

-- | Construct a t'GValueConstruct' with valid value for the “@display@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMonitorDisplay :: (IsMonitor o, MIO.MonadIO m, Gdk.Display.IsDisplay a) => a -> m (GValueConstruct o)
constructMonitorDisplay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "display" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data MonitorDisplayPropertyInfo
instance AttrInfo MonitorDisplayPropertyInfo where
    type AttrAllowedOps MonitorDisplayPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MonitorDisplayPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferTypeConstraint MonitorDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferType MonitorDisplayPropertyInfo = Gdk.Display.Display
    type AttrGetType MonitorDisplayPropertyInfo = Gdk.Display.Display
    type AttrLabel MonitorDisplayPropertyInfo = "display"
    type AttrOrigin MonitorDisplayPropertyInfo = Monitor
    attrGet = getMonitorDisplay
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Display.Display v
    attrConstruct = constructMonitorDisplay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.display"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#g:attr:display"
        })
#endif

-- VVV Prop "geometry"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Rectangle"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@geometry@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #geometry
-- @
getMonitorGeometry :: (MonadIO m, IsMonitor o) => o -> m (Maybe Gdk.Rectangle.Rectangle)
getMonitorGeometry obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "geometry" Gdk.Rectangle.Rectangle

#if defined(ENABLE_OVERLOADING)
data MonitorGeometryPropertyInfo
instance AttrInfo MonitorGeometryPropertyInfo where
    type AttrAllowedOps MonitorGeometryPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MonitorGeometryPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorGeometryPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorGeometryPropertyInfo = (~) ()
    type AttrTransferType MonitorGeometryPropertyInfo = ()
    type AttrGetType MonitorGeometryPropertyInfo = (Maybe Gdk.Rectangle.Rectangle)
    type AttrLabel MonitorGeometryPropertyInfo = "geometry"
    type AttrOrigin MonitorGeometryPropertyInfo = Monitor
    attrGet = getMonitorGeometry
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.geometry"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#g:attr:geometry"
        })
#endif

-- VVV Prop "height-mm"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@height-mm@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #heightMm
-- @
getMonitorHeightMm :: (MonadIO m, IsMonitor o) => o -> m Int32
getMonitorHeightMm obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "height-mm"

#if defined(ENABLE_OVERLOADING)
data MonitorHeightMmPropertyInfo
instance AttrInfo MonitorHeightMmPropertyInfo where
    type AttrAllowedOps MonitorHeightMmPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MonitorHeightMmPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorHeightMmPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorHeightMmPropertyInfo = (~) ()
    type AttrTransferType MonitorHeightMmPropertyInfo = ()
    type AttrGetType MonitorHeightMmPropertyInfo = Int32
    type AttrLabel MonitorHeightMmPropertyInfo = "height-mm"
    type AttrOrigin MonitorHeightMmPropertyInfo = Monitor
    attrGet = getMonitorHeightMm
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.heightMm"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#g:attr:heightMm"
        })
#endif

-- VVV Prop "manufacturer"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@manufacturer@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #manufacturer
-- @
getMonitorManufacturer :: (MonadIO m, IsMonitor o) => o -> m (Maybe T.Text)
getMonitorManufacturer obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "manufacturer"

#if defined(ENABLE_OVERLOADING)
data MonitorManufacturerPropertyInfo
instance AttrInfo MonitorManufacturerPropertyInfo where
    type AttrAllowedOps MonitorManufacturerPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MonitorManufacturerPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorManufacturerPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorManufacturerPropertyInfo = (~) ()
    type AttrTransferType MonitorManufacturerPropertyInfo = ()
    type AttrGetType MonitorManufacturerPropertyInfo = (Maybe T.Text)
    type AttrLabel MonitorManufacturerPropertyInfo = "manufacturer"
    type AttrOrigin MonitorManufacturerPropertyInfo = Monitor
    attrGet = getMonitorManufacturer
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.manufacturer"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#g:attr:manufacturer"
        })
#endif

-- VVV Prop "model"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #model
-- @
getMonitorModel :: (MonadIO m, IsMonitor o) => o -> m (Maybe T.Text)
getMonitorModel obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "model"

#if defined(ENABLE_OVERLOADING)
data MonitorModelPropertyInfo
instance AttrInfo MonitorModelPropertyInfo where
    type AttrAllowedOps MonitorModelPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MonitorModelPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorModelPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorModelPropertyInfo = (~) ()
    type AttrTransferType MonitorModelPropertyInfo = ()
    type AttrGetType MonitorModelPropertyInfo = (Maybe T.Text)
    type AttrLabel MonitorModelPropertyInfo = "model"
    type AttrOrigin MonitorModelPropertyInfo = Monitor
    attrGet = getMonitorModel
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.model"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#g:attr:model"
        })
#endif

-- VVV Prop "refresh-rate"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@refresh-rate@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #refreshRate
-- @
getMonitorRefreshRate :: (MonadIO m, IsMonitor o) => o -> m Int32
getMonitorRefreshRate obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "refresh-rate"

#if defined(ENABLE_OVERLOADING)
data MonitorRefreshRatePropertyInfo
instance AttrInfo MonitorRefreshRatePropertyInfo where
    type AttrAllowedOps MonitorRefreshRatePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MonitorRefreshRatePropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorRefreshRatePropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorRefreshRatePropertyInfo = (~) ()
    type AttrTransferType MonitorRefreshRatePropertyInfo = ()
    type AttrGetType MonitorRefreshRatePropertyInfo = Int32
    type AttrLabel MonitorRefreshRatePropertyInfo = "refresh-rate"
    type AttrOrigin MonitorRefreshRatePropertyInfo = Monitor
    attrGet = getMonitorRefreshRate
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.refreshRate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#g:attr:refreshRate"
        })
#endif

-- VVV Prop "scale-factor"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@scale-factor@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #scaleFactor
-- @
getMonitorScaleFactor :: (MonadIO m, IsMonitor o) => o -> m Int32
getMonitorScaleFactor obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "scale-factor"

#if defined(ENABLE_OVERLOADING)
data MonitorScaleFactorPropertyInfo
instance AttrInfo MonitorScaleFactorPropertyInfo where
    type AttrAllowedOps MonitorScaleFactorPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MonitorScaleFactorPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorScaleFactorPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorScaleFactorPropertyInfo = (~) ()
    type AttrTransferType MonitorScaleFactorPropertyInfo = ()
    type AttrGetType MonitorScaleFactorPropertyInfo = Int32
    type AttrLabel MonitorScaleFactorPropertyInfo = "scale-factor"
    type AttrOrigin MonitorScaleFactorPropertyInfo = Monitor
    attrGet = getMonitorScaleFactor
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.scaleFactor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#g:attr:scaleFactor"
        })
#endif

-- VVV Prop "subpixel-layout"
   -- Type: TInterface (Name {namespace = "Gdk", name = "SubpixelLayout"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@subpixel-layout@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #subpixelLayout
-- @
getMonitorSubpixelLayout :: (MonadIO m, IsMonitor o) => o -> m Gdk.Enums.SubpixelLayout
getMonitorSubpixelLayout obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "subpixel-layout"

#if defined(ENABLE_OVERLOADING)
data MonitorSubpixelLayoutPropertyInfo
instance AttrInfo MonitorSubpixelLayoutPropertyInfo where
    type AttrAllowedOps MonitorSubpixelLayoutPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MonitorSubpixelLayoutPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorSubpixelLayoutPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorSubpixelLayoutPropertyInfo = (~) ()
    type AttrTransferType MonitorSubpixelLayoutPropertyInfo = ()
    type AttrGetType MonitorSubpixelLayoutPropertyInfo = Gdk.Enums.SubpixelLayout
    type AttrLabel MonitorSubpixelLayoutPropertyInfo = "subpixel-layout"
    type AttrOrigin MonitorSubpixelLayoutPropertyInfo = Monitor
    attrGet = getMonitorSubpixelLayout
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.subpixelLayout"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#g:attr:subpixelLayout"
        })
#endif

-- VVV Prop "width-mm"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@width-mm@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #widthMm
-- @
getMonitorWidthMm :: (MonadIO m, IsMonitor o) => o -> m Int32
getMonitorWidthMm obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "width-mm"

#if defined(ENABLE_OVERLOADING)
data MonitorWidthMmPropertyInfo
instance AttrInfo MonitorWidthMmPropertyInfo where
    type AttrAllowedOps MonitorWidthMmPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MonitorWidthMmPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorWidthMmPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorWidthMmPropertyInfo = (~) ()
    type AttrTransferType MonitorWidthMmPropertyInfo = ()
    type AttrGetType MonitorWidthMmPropertyInfo = Int32
    type AttrLabel MonitorWidthMmPropertyInfo = "width-mm"
    type AttrOrigin MonitorWidthMmPropertyInfo = Monitor
    attrGet = getMonitorWidthMm
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.widthMm"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#g:attr:widthMm"
        })
#endif

-- VVV Prop "workarea"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Rectangle"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@workarea@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #workarea
-- @
getMonitorWorkarea :: (MonadIO m, IsMonitor o) => o -> m (Maybe Gdk.Rectangle.Rectangle)
getMonitorWorkarea obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "workarea" Gdk.Rectangle.Rectangle

#if defined(ENABLE_OVERLOADING)
data MonitorWorkareaPropertyInfo
instance AttrInfo MonitorWorkareaPropertyInfo where
    type AttrAllowedOps MonitorWorkareaPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MonitorWorkareaPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorWorkareaPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorWorkareaPropertyInfo = (~) ()
    type AttrTransferType MonitorWorkareaPropertyInfo = ()
    type AttrGetType MonitorWorkareaPropertyInfo = (Maybe Gdk.Rectangle.Rectangle)
    type AttrLabel MonitorWorkareaPropertyInfo = "workarea"
    type AttrOrigin MonitorWorkareaPropertyInfo = Monitor
    attrGet = getMonitorWorkarea
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.workarea"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#g:attr:workarea"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Monitor
type instance O.AttributeList Monitor = MonitorAttributeList
type MonitorAttributeList = ('[ '("display", MonitorDisplayPropertyInfo), '("geometry", MonitorGeometryPropertyInfo), '("heightMm", MonitorHeightMmPropertyInfo), '("manufacturer", MonitorManufacturerPropertyInfo), '("model", MonitorModelPropertyInfo), '("refreshRate", MonitorRefreshRatePropertyInfo), '("scaleFactor", MonitorScaleFactorPropertyInfo), '("subpixelLayout", MonitorSubpixelLayoutPropertyInfo), '("widthMm", MonitorWidthMmPropertyInfo), '("workarea", MonitorWorkareaPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
monitorDisplay :: AttrLabelProxy "display"
monitorDisplay = AttrLabelProxy

monitorGeometry :: AttrLabelProxy "geometry"
monitorGeometry = AttrLabelProxy

monitorHeightMm :: AttrLabelProxy "heightMm"
monitorHeightMm = AttrLabelProxy

monitorManufacturer :: AttrLabelProxy "manufacturer"
monitorManufacturer = AttrLabelProxy

monitorModel :: AttrLabelProxy "model"
monitorModel = AttrLabelProxy

monitorRefreshRate :: AttrLabelProxy "refreshRate"
monitorRefreshRate = AttrLabelProxy

monitorScaleFactor :: AttrLabelProxy "scaleFactor"
monitorScaleFactor = AttrLabelProxy

monitorSubpixelLayout :: AttrLabelProxy "subpixelLayout"
monitorSubpixelLayout = AttrLabelProxy

monitorWidthMm :: AttrLabelProxy "widthMm"
monitorWidthMm = AttrLabelProxy

monitorWorkarea :: AttrLabelProxy "workarea"
monitorWorkarea = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Monitor = MonitorSignalList
type MonitorSignalList = ('[ '("invalidate", MonitorInvalidateSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Monitor::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkMonitor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_display" gdk_monitor_get_display :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO (Ptr Gdk.Display.Display)

-- | Gets the display that this monitor belongs to.
-- 
-- /Since: 3.22/
monitorGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gdk.Objects.Monitor.Monitor'
    -> m Gdk.Display.Display
    -- ^ __Returns:__ the display
monitorGetDisplay monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_display monitor'
    checkUnexpectedReturnNULL "monitorGetDisplay" result
    result' <- (newObject Gdk.Display.Display) result
    touchManagedPtr monitor
    return result'

#if defined(ENABLE_OVERLOADING)
data MonitorGetDisplayMethodInfo
instance (signature ~ (m Gdk.Display.Display), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetDisplayMethodInfo a signature where
    overloadedMethod = monitorGetDisplay

instance O.OverloadedMethodInfo MonitorGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetDisplay"
        })


#endif

-- method Monitor::get_geometry
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkMonitor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "geometry"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GdkRectangle to be filled with the monitor geometry"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_geometry" gdk_monitor_get_geometry :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    Ptr Gdk.Rectangle.Rectangle ->          -- geometry : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

-- | Retrieves the size and position of an individual monitor within the
-- display coordinate space. The returned geometry is in  ”application pixels”,
-- not in ”device pixels” (see 'GI.Gdk.Objects.Monitor.monitorGetScaleFactor').
-- 
-- /Since: 3.22/
monitorGetGeometry ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gdk.Objects.Monitor.Monitor'
    -> m (Gdk.Rectangle.Rectangle)
monitorGetGeometry monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    geometry <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle.Rectangle)
    gdk_monitor_get_geometry monitor' geometry
    geometry' <- (wrapBoxed Gdk.Rectangle.Rectangle) geometry
    touchManagedPtr monitor
    return geometry'

#if defined(ENABLE_OVERLOADING)
data MonitorGetGeometryMethodInfo
instance (signature ~ (m (Gdk.Rectangle.Rectangle)), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetGeometryMethodInfo a signature where
    overloadedMethod = monitorGetGeometry

instance O.OverloadedMethodInfo MonitorGetGeometryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetGeometry",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetGeometry"
        })


#endif

-- method Monitor::get_height_mm
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkMonitor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_height_mm" gdk_monitor_get_height_mm :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO Int32

-- | Gets the height in millimeters of the monitor.
-- 
-- /Since: 3.22/
monitorGetHeightMm ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gdk.Objects.Monitor.Monitor'
    -> m Int32
    -- ^ __Returns:__ the physical height of the monitor
monitorGetHeightMm monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_height_mm monitor'
    touchManagedPtr monitor
    return result

#if defined(ENABLE_OVERLOADING)
data MonitorGetHeightMmMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetHeightMmMethodInfo a signature where
    overloadedMethod = monitorGetHeightMm

instance O.OverloadedMethodInfo MonitorGetHeightMmMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetHeightMm",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetHeightMm"
        })


#endif

-- method Monitor::get_manufacturer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkMonitor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_manufacturer" gdk_monitor_get_manufacturer :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO CString

-- | Gets the name or PNP ID of the monitor\'s manufacturer, if available.
-- 
-- Note that this value might also vary depending on actual
-- display backend.
-- 
-- PNP ID registry is located at https:\/\/uefi.org\/pnp_id_list
monitorGetManufacturer ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gdk.Objects.Monitor.Monitor'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the name of the manufacturer, or 'P.Nothing'
monitorGetManufacturer monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_manufacturer monitor'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr monitor
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MonitorGetManufacturerMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetManufacturerMethodInfo a signature where
    overloadedMethod = monitorGetManufacturer

instance O.OverloadedMethodInfo MonitorGetManufacturerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetManufacturer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetManufacturer"
        })


#endif

-- method Monitor::get_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkMonitor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_model" gdk_monitor_get_model :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO CString

-- | Gets the a string identifying the monitor model, if available.
monitorGetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gdk.Objects.Monitor.Monitor'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the monitor model, or 'P.Nothing'
monitorGetModel monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_model monitor'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr monitor
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MonitorGetModelMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetModelMethodInfo a signature where
    overloadedMethod = monitorGetModel

instance O.OverloadedMethodInfo MonitorGetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetModel"
        })


#endif

-- method Monitor::get_refresh_rate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkMonitor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_refresh_rate" gdk_monitor_get_refresh_rate :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO Int32

-- | Gets the refresh rate of the monitor, if available.
-- 
-- The value is in milli-Hertz, so a refresh rate of 60Hz
-- is returned as 60000.
-- 
-- /Since: 3.22/
monitorGetRefreshRate ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gdk.Objects.Monitor.Monitor'
    -> m Int32
    -- ^ __Returns:__ the refresh rate in milli-Hertz, or 0
monitorGetRefreshRate monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_refresh_rate monitor'
    touchManagedPtr monitor
    return result

#if defined(ENABLE_OVERLOADING)
data MonitorGetRefreshRateMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetRefreshRateMethodInfo a signature where
    overloadedMethod = monitorGetRefreshRate

instance O.OverloadedMethodInfo MonitorGetRefreshRateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetRefreshRate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetRefreshRate"
        })


#endif

-- method Monitor::get_scale_factor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkMonitor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_scale_factor" gdk_monitor_get_scale_factor :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO Int32

-- | Gets the internal scale factor that maps from monitor coordinates
-- to the actual device pixels. On traditional systems this is 1, but
-- on very high density outputs this can be a higher value (often 2).
-- 
-- This can be used if you want to create pixel based data for a
-- particular monitor, but most of the time you’re drawing to a window
-- where it is better to use 'GI.Gdk.Objects.Window.windowGetScaleFactor' instead.
-- 
-- /Since: 3.22/
monitorGetScaleFactor ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gdk.Objects.Monitor.Monitor'
    -> m Int32
    -- ^ __Returns:__ the scale factor
monitorGetScaleFactor monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_scale_factor monitor'
    touchManagedPtr monitor
    return result

#if defined(ENABLE_OVERLOADING)
data MonitorGetScaleFactorMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetScaleFactorMethodInfo a signature where
    overloadedMethod = monitorGetScaleFactor

instance O.OverloadedMethodInfo MonitorGetScaleFactorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetScaleFactor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetScaleFactor"
        })


#endif

-- method Monitor::get_subpixel_layout
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkMonitor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "SubpixelLayout" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_subpixel_layout" gdk_monitor_get_subpixel_layout :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO CUInt

-- | Gets information about the layout of red, green and blue
-- primaries for each pixel in this monitor, if available.
-- 
-- /Since: 3.22/
monitorGetSubpixelLayout ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gdk.Objects.Monitor.Monitor'
    -> m Gdk.Enums.SubpixelLayout
    -- ^ __Returns:__ the subpixel layout
monitorGetSubpixelLayout monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_subpixel_layout monitor'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr monitor
    return result'

#if defined(ENABLE_OVERLOADING)
data MonitorGetSubpixelLayoutMethodInfo
instance (signature ~ (m Gdk.Enums.SubpixelLayout), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetSubpixelLayoutMethodInfo a signature where
    overloadedMethod = monitorGetSubpixelLayout

instance O.OverloadedMethodInfo MonitorGetSubpixelLayoutMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetSubpixelLayout",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetSubpixelLayout"
        })


#endif

-- method Monitor::get_width_mm
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkMonitor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_width_mm" gdk_monitor_get_width_mm :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO Int32

-- | Gets the width in millimeters of the monitor.
-- 
-- /Since: 3.22/
monitorGetWidthMm ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gdk.Objects.Monitor.Monitor'
    -> m Int32
    -- ^ __Returns:__ the physical width of the monitor
monitorGetWidthMm monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_width_mm monitor'
    touchManagedPtr monitor
    return result

#if defined(ENABLE_OVERLOADING)
data MonitorGetWidthMmMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetWidthMmMethodInfo a signature where
    overloadedMethod = monitorGetWidthMm

instance O.OverloadedMethodInfo MonitorGetWidthMmMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetWidthMm",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetWidthMm"
        })


#endif

-- method Monitor::get_workarea
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkMonitor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "workarea"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GdkRectangle to be filled with\n    the monitor workarea"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_workarea" gdk_monitor_get_workarea :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    Ptr Gdk.Rectangle.Rectangle ->          -- workarea : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

-- | Retrieves the size and position of the “work area” on a monitor
-- within the display coordinate space. The returned geometry is in
-- ”application pixels”, not in ”device pixels” (see
-- 'GI.Gdk.Objects.Monitor.monitorGetScaleFactor').
-- 
-- The work area should be considered when positioning menus and
-- similar popups, to avoid placing them below panels, docks or other
-- desktop components.
-- 
-- Note that not all backends may have a concept of workarea. This
-- function will return the monitor geometry if a workarea is not
-- available, or does not apply.
-- 
-- /Since: 3.22/
monitorGetWorkarea ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gdk.Objects.Monitor.Monitor'
    -> m (Gdk.Rectangle.Rectangle)
monitorGetWorkarea monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    workarea <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle.Rectangle)
    gdk_monitor_get_workarea monitor' workarea
    workarea' <- (wrapBoxed Gdk.Rectangle.Rectangle) workarea
    touchManagedPtr monitor
    return workarea'

#if defined(ENABLE_OVERLOADING)
data MonitorGetWorkareaMethodInfo
instance (signature ~ (m (Gdk.Rectangle.Rectangle)), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetWorkareaMethodInfo a signature where
    overloadedMethod = monitorGetWorkarea

instance O.OverloadedMethodInfo MonitorGetWorkareaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetWorkarea",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetWorkarea"
        })


#endif

-- method Monitor::is_primary
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkMonitor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_is_primary" gdk_monitor_is_primary :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO CInt

-- | Gets whether this monitor should be considered primary
-- (see 'GI.Gdk.Objects.Display.displayGetPrimaryMonitor').
-- 
-- /Since: 3.22/
monitorIsPrimary ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gdk.Objects.Monitor.Monitor'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@monitor@/ is primary
monitorIsPrimary monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_is_primary monitor'
    let result' = (/= 0) result
    touchManagedPtr monitor
    return result'

#if defined(ENABLE_OVERLOADING)
data MonitorIsPrimaryMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorIsPrimaryMethodInfo a signature where
    overloadedMethod = monitorIsPrimary

instance O.OverloadedMethodInfo MonitorIsPrimaryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorIsPrimary",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Monitor.html#v:monitorIsPrimary"
        })


#endif


