{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GAppInfoMonitor@ monitors application information for changes.
-- 
-- @GAppInfoMonitor@ is a very simple object used for monitoring the app
-- info database for changes (newly installed or removed applications).
-- 
-- Call 'GI.Gio.Objects.AppInfoMonitor.appInfoMonitorGet' to get a @GAppInfoMonitor@ and connect
-- to the [AppInfoMonitor::changed]("GI.Gio.Objects.AppInfoMonitor#g:signal:changed") signal. The signal will be emitted once when
-- the app info database changes, and will not be emitted again until after the
-- next call to 'GI.Gio.Interfaces.AppInfo.appInfoGetAll' or another @g_app_info_*()@ function.
-- This is because monitoring the app info database for changes is expensive.
-- 
-- The following functions will re-arm the [AppInfoMonitor::changed]("GI.Gio.Objects.AppInfoMonitor#g:signal:changed")
-- signal so it can be emitted again:
-- 
-- * 'GI.Gio.Interfaces.AppInfo.appInfoGetAll'
-- * 'GI.Gio.Interfaces.AppInfo.appInfoGetAllForType'
-- * 'GI.Gio.Interfaces.AppInfo.appInfoGetDefaultForType'
-- * 'GI.Gio.Interfaces.AppInfo.appInfoGetFallbackForType'
-- * 'GI.Gio.Interfaces.AppInfo.appInfoGetRecommendedForType'
-- * <http://developer.gnome.org/gio/stable/../gio-unix/type_func.DesktopAppInfo.get_implementation.html `g_desktop_app_info_get_implementations()`>
-- * <http://developer.gnome.org/gio/stable/../gio-unix/ctor.DesktopAppInfo.new.html `g_desktop_app_info_new()`>
-- * <http://developer.gnome.org/gio/stable/../gio-unix/ctor.DesktopAppInfo.new_from_filename.html `g_desktop_app_info_new_from_filename()`>
-- * <http://developer.gnome.org/gio/stable/../gio-unix/ctor.DesktopAppInfo.new_from_keyfile.html `g_desktop_app_info_new_from_keyfile()`>
-- * <http://developer.gnome.org/gio/stable/../gio-unix/type_func.DesktopAppInfo.search.html `g_desktop_app_info_search()`>
-- 
-- 
-- The latter functions are available if using
-- <http://developer.gnome.org/gio/stable/../gio-unix/class.DesktopAppInfo.html `GDesktopAppInfo`> from
-- @gio-unix-2.0.pc@ (GIR namespace @GioUnix-2.0@).
-- 
-- In the usual case, applications should try to make note of the change
-- (doing things like invalidating caches) but not act on it. In
-- particular, applications should avoid making calls to @GAppInfo@ APIs
-- in response to the change signal, deferring these until the time that
-- the updated data is actually required. The exception to this case is when
-- application information is actually being displayed on the screen
-- (for example, during a search or when the list of all applications is shown).
-- The reason for this is that changes to the list of installed applications
-- often come in groups (like during system updates) and rescanning the list
-- on every change is pointless and expensive.
-- 
-- /Since: 2.40/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.AppInfoMonitor
    ( 

-- * Exported types
    AppInfoMonitor(..)                      ,
    IsAppInfoMonitor                        ,
    toAppInfoMonitor                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveAppInfoMonitorMethod             ,
#endif

-- ** get #method:get#

    appInfoMonitorGet                       ,




 -- * Signals


-- ** changed #signal:changed#

    AppInfoMonitorChangedCallback           ,
#if defined(ENABLE_OVERLOADING)
    AppInfoMonitorChangedSignalInfo         ,
#endif
    afterAppInfoMonitorChanged              ,
    onAppInfoMonitorChanged                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype AppInfoMonitor = AppInfoMonitor (SP.ManagedPtr AppInfoMonitor)
    deriving (Eq)

instance SP.ManagedPtrNewtype AppInfoMonitor where
    toManagedPtr (AppInfoMonitor p) = p

foreign import ccall "g_app_info_monitor_get_type"
    c_g_app_info_monitor_get_type :: IO B.Types.GType

instance B.Types.TypedObject AppInfoMonitor where
    glibType = c_g_app_info_monitor_get_type

instance B.Types.GObject AppInfoMonitor

-- | Type class for types which can be safely cast to t'AppInfoMonitor', for instance with `toAppInfoMonitor`.
class (SP.GObject o, O.IsDescendantOf AppInfoMonitor o) => IsAppInfoMonitor o
instance (SP.GObject o, O.IsDescendantOf AppInfoMonitor o) => IsAppInfoMonitor o

instance O.HasParentTypes AppInfoMonitor
type instance O.ParentTypes AppInfoMonitor = '[GObject.Object.Object]

-- | Cast to t'AppInfoMonitor', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toAppInfoMonitor :: (MIO.MonadIO m, IsAppInfoMonitor o) => o -> m AppInfoMonitor
toAppInfoMonitor = MIO.liftIO . B.ManagedPtr.unsafeCastTo AppInfoMonitor

-- | Convert t'AppInfoMonitor' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe AppInfoMonitor) where
    gvalueGType_ = c_g_app_info_monitor_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr AppInfoMonitor)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr AppInfoMonitor)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject AppInfoMonitor ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveAppInfoMonitorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAppInfoMonitorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveAppInfoMonitorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveAppInfoMonitorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveAppInfoMonitorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveAppInfoMonitorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveAppInfoMonitorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveAppInfoMonitorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveAppInfoMonitorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveAppInfoMonitorMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveAppInfoMonitorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveAppInfoMonitorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveAppInfoMonitorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveAppInfoMonitorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveAppInfoMonitorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveAppInfoMonitorMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveAppInfoMonitorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveAppInfoMonitorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveAppInfoMonitorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveAppInfoMonitorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveAppInfoMonitorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveAppInfoMonitorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveAppInfoMonitorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveAppInfoMonitorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAppInfoMonitorMethod t AppInfoMonitor, O.OverloadedMethod info AppInfoMonitor p) => OL.IsLabel t (AppInfoMonitor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAppInfoMonitorMethod t AppInfoMonitor, O.OverloadedMethod info AppInfoMonitor p, R.HasField t AppInfoMonitor p) => R.HasField t AppInfoMonitor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAppInfoMonitorMethod t AppInfoMonitor, O.OverloadedMethodInfo info AppInfoMonitor) => OL.IsLabel t (O.MethodProxy info AppInfoMonitor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal AppInfoMonitor::changed
-- | Signal emitted when the app info database changes, when applications are
-- installed or removed.
-- 
-- /Since: 2.40/
type AppInfoMonitorChangedCallback =
    IO ()

type C_AppInfoMonitorChangedCallback =
    Ptr AppInfoMonitor ->                   -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_AppInfoMonitorChangedCallback`.
foreign import ccall "wrapper"
    mk_AppInfoMonitorChangedCallback :: C_AppInfoMonitorChangedCallback -> IO (FunPtr C_AppInfoMonitorChangedCallback)

wrap_AppInfoMonitorChangedCallback :: 
    GObject a => (a -> AppInfoMonitorChangedCallback) ->
    C_AppInfoMonitorChangedCallback
wrap_AppInfoMonitorChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' appInfoMonitor #changed callback
-- @
-- 
-- 
onAppInfoMonitorChanged :: (IsAppInfoMonitor a, MonadIO m) => a -> ((?self :: a) => AppInfoMonitorChangedCallback) -> m SignalHandlerId
onAppInfoMonitorChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AppInfoMonitorChangedCallback wrapped
    wrapped'' <- mk_AppInfoMonitorChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' appInfoMonitor #changed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterAppInfoMonitorChanged :: (IsAppInfoMonitor a, MonadIO m) => a -> ((?self :: a) => AppInfoMonitorChangedCallback) -> m SignalHandlerId
afterAppInfoMonitorChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AppInfoMonitorChangedCallback wrapped
    wrapped'' <- mk_AppInfoMonitorChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data AppInfoMonitorChangedSignalInfo
instance SignalInfo AppInfoMonitorChangedSignalInfo where
    type HaskellCallbackType AppInfoMonitorChangedSignalInfo = AppInfoMonitorChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_AppInfoMonitorChangedCallback cb
        cb'' <- mk_AppInfoMonitorChangedCallback cb'
        connectSignalFunPtr obj "changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.AppInfoMonitor::changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-AppInfoMonitor.html#g:signal:changed"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AppInfoMonitor
type instance O.AttributeList AppInfoMonitor = AppInfoMonitorAttributeList
type AppInfoMonitorAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList AppInfoMonitor = AppInfoMonitorSignalList
type AppInfoMonitorSignalList = ('[ '("changed", AppInfoMonitorChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method AppInfoMonitor::get
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "AppInfoMonitor" })
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_monitor_get" g_app_info_monitor_get :: 
    IO (Ptr AppInfoMonitor)

-- | Gets the t'GI.Gio.Objects.AppInfoMonitor.AppInfoMonitor' for the current thread-default main
-- context.
-- 
-- The t'GI.Gio.Objects.AppInfoMonitor.AppInfoMonitor' will emit a “changed” signal in the
-- thread-default main context whenever the list of installed
-- applications (as reported by 'GI.Gio.Functions.appInfoGetAll') may have changed.
-- 
-- The [AppInfoMonitor::changed]("GI.Gio.Objects.AppInfoMonitor#g:signal:changed") signal will only be emitted once until
-- 'GI.Gio.Functions.appInfoGetAll' (or another @g_app_info_*()@ function) is called. Doing
-- so will re-arm the signal ready to notify about the next change.
-- 
-- You must only call 'GI.GObject.Objects.Object.objectUnref' on the return value from under
-- the same main context as you created it.
-- 
-- /Since: 2.40/
appInfoMonitorGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m AppInfoMonitor
    -- ^ __Returns:__ a reference to a t'GI.Gio.Objects.AppInfoMonitor.AppInfoMonitor'
appInfoMonitorGet  = liftIO $ do
    result <- g_app_info_monitor_get
    checkUnexpectedReturnNULL "appInfoMonitorGet" result
    result' <- (wrapObject AppInfoMonitor) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


