{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Uses closures for size negotiation.
-- 
-- A @GtkCustomLayout@ uses closures matching to the old @GtkWidget@
-- virtual functions for size negotiation, as a convenience API to
-- ease the porting towards the corresponding @GtkLayoutManager@
-- virtual functions.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.CustomLayout
    ( 

-- * Exported types
    CustomLayout(..)                        ,
    IsCustomLayout                          ,
    toCustomLayout                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [allocate]("GI.Gtk.Objects.LayoutManager#g:method:allocate"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [layoutChanged]("GI.Gtk.Objects.LayoutManager#g:method:layoutChanged"), [measure]("GI.Gtk.Objects.LayoutManager#g:method:measure"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getLayoutChild]("GI.Gtk.Objects.LayoutManager#g:method:getLayoutChild"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRequestMode]("GI.Gtk.Objects.LayoutManager#g:method:getRequestMode"), [getWidget]("GI.Gtk.Objects.LayoutManager#g:method:getWidget").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveCustomLayoutMethod               ,
#endif

-- ** new #method:new#

    customLayoutNew                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager

#endif

-- | Memory-managed wrapper type.
newtype CustomLayout = CustomLayout (SP.ManagedPtr CustomLayout)
    deriving (Eq)

instance SP.ManagedPtrNewtype CustomLayout where
    toManagedPtr (CustomLayout p) = p

foreign import ccall "gtk_custom_layout_get_type"
    c_gtk_custom_layout_get_type :: IO B.Types.GType

instance B.Types.TypedObject CustomLayout where
    glibType = c_gtk_custom_layout_get_type

instance B.Types.GObject CustomLayout

-- | Type class for types which can be safely cast to t'CustomLayout', for instance with `toCustomLayout`.
class (SP.GObject o, O.IsDescendantOf CustomLayout o) => IsCustomLayout o
instance (SP.GObject o, O.IsDescendantOf CustomLayout o) => IsCustomLayout o

instance O.HasParentTypes CustomLayout
type instance O.ParentTypes CustomLayout = '[Gtk.LayoutManager.LayoutManager, GObject.Object.Object]

-- | Cast to t'CustomLayout', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCustomLayout :: (MIO.MonadIO m, IsCustomLayout o) => o -> m CustomLayout
toCustomLayout = MIO.liftIO . B.ManagedPtr.unsafeCastTo CustomLayout

-- | Convert t'CustomLayout' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe CustomLayout) where
    gvalueGType_ = c_gtk_custom_layout_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr CustomLayout)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr CustomLayout)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject CustomLayout ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCustomLayoutMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCustomLayoutMethod "allocate" o = Gtk.LayoutManager.LayoutManagerAllocateMethodInfo
    ResolveCustomLayoutMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCustomLayoutMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCustomLayoutMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCustomLayoutMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCustomLayoutMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCustomLayoutMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCustomLayoutMethod "layoutChanged" o = Gtk.LayoutManager.LayoutManagerLayoutChangedMethodInfo
    ResolveCustomLayoutMethod "measure" o = Gtk.LayoutManager.LayoutManagerMeasureMethodInfo
    ResolveCustomLayoutMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCustomLayoutMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCustomLayoutMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveCustomLayoutMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCustomLayoutMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCustomLayoutMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCustomLayoutMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCustomLayoutMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCustomLayoutMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveCustomLayoutMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCustomLayoutMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCustomLayoutMethod "getLayoutChild" o = Gtk.LayoutManager.LayoutManagerGetLayoutChildMethodInfo
    ResolveCustomLayoutMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCustomLayoutMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCustomLayoutMethod "getRequestMode" o = Gtk.LayoutManager.LayoutManagerGetRequestModeMethodInfo
    ResolveCustomLayoutMethod "getWidget" o = Gtk.LayoutManager.LayoutManagerGetWidgetMethodInfo
    ResolveCustomLayoutMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCustomLayoutMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCustomLayoutMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCustomLayoutMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCustomLayoutMethod t CustomLayout, O.OverloadedMethod info CustomLayout p) => OL.IsLabel t (CustomLayout -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCustomLayoutMethod t CustomLayout, O.OverloadedMethod info CustomLayout p, R.HasField t CustomLayout p) => R.HasField t CustomLayout p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCustomLayoutMethod t CustomLayout, O.OverloadedMethodInfo info CustomLayout) => OL.IsLabel t (O.MethodProxy info CustomLayout) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList CustomLayout
type instance O.AttributeList CustomLayout = CustomLayoutAttributeList
type CustomLayoutAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList CustomLayout = CustomLayoutSignalList
type CustomLayoutSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method CustomLayout::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "request_mode"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "CustomRequestModeFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a function to retrieve\n  the `GtkSizeRequestMode` of the widget using the layout; the\n  default request mode is %GTK_SIZE_REQUEST_CONSTANT_SIZE"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "measure"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CustomMeasureFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a function to measure the widget using the layout manager"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "allocate"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CustomAllocateFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a function to allocate the children of the widget using\n  the layout manager"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "CustomLayout" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_custom_layout_new" gtk_custom_layout_new :: 
    FunPtr Gtk.Callbacks.C_CustomRequestModeFunc -> -- request_mode : TInterface (Name {namespace = "Gtk", name = "CustomRequestModeFunc"})
    FunPtr Gtk.Callbacks.C_CustomMeasureFunc -> -- measure : TInterface (Name {namespace = "Gtk", name = "CustomMeasureFunc"})
    FunPtr Gtk.Callbacks.C_CustomAllocateFunc -> -- allocate : TInterface (Name {namespace = "Gtk", name = "CustomAllocateFunc"})
    IO (Ptr CustomLayout)

-- | Creates a new legacy layout manager.
-- 
-- Legacy layout managers map to the old @GtkWidget@ size negotiation
-- virtual functions, and are meant to be used during the transition
-- from layout containers to layout manager delegates.
customLayoutNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Gtk.Callbacks.CustomRequestModeFunc)
    -- ^ /@requestMode@/: a function to retrieve
    --   the @GtkSizeRequestMode@ of the widget using the layout; the
    --   default request mode is 'GI.Gtk.Enums.SizeRequestModeConstantSize'
    -> Gtk.Callbacks.CustomMeasureFunc
    -- ^ /@measure@/: a function to measure the widget using the layout manager
    -> Gtk.Callbacks.CustomAllocateFunc
    -- ^ /@allocate@/: a function to allocate the children of the widget using
    --   the layout manager
    -> m CustomLayout
    -- ^ __Returns:__ the newly created @GtkCustomLayout@
customLayoutNew requestMode measure allocate = liftIO $ do
    maybeRequestMode <- case requestMode of
        Nothing -> return FP.nullFunPtr
        Just jRequestMode -> do
            jRequestMode' <- Gtk.Callbacks.mk_CustomRequestModeFunc (Gtk.Callbacks.wrap_CustomRequestModeFunc Nothing jRequestMode)
            return jRequestMode'
    measure' <- Gtk.Callbacks.mk_CustomMeasureFunc (Gtk.Callbacks.wrap_CustomMeasureFunc Nothing measure)
    allocate' <- Gtk.Callbacks.mk_CustomAllocateFunc (Gtk.Callbacks.wrap_CustomAllocateFunc Nothing allocate)
    result <- gtk_custom_layout_new maybeRequestMode measure' allocate'
    checkUnexpectedReturnNULL "customLayoutNew" result
    result' <- (wrapObject CustomLayout) result
    safeFreeFunPtr $ castFunPtrToPtr maybeRequestMode
    safeFreeFunPtr $ castFunPtrToPtr measure'
    safeFreeFunPtr $ castFunPtrToPtr allocate'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


