{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Data type for holding a shaping plan.
-- 
-- Shape plans contain information about how HarfBuzz will shape a
-- particular text segment, based on the segment\'s properties and the
-- capabilities in the font face in use.
-- 
-- Shape plans can be queried about how shaping will perform, given a set
-- of specific input parameters (script, language, direction, features,
-- etc.).

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.ShapePlanT
    ( 

-- * Exported types
    ShapePlanT(..)                          ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveShapePlanTMethod                 ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype ShapePlanT = ShapePlanT (SP.ManagedPtr ShapePlanT)
    deriving (Eq)

instance SP.ManagedPtrNewtype ShapePlanT where
    toManagedPtr (ShapePlanT p) = p

foreign import ccall "hb_gobject_shape_plan_get_type" c_hb_gobject_shape_plan_get_type :: 
    IO GType

type instance O.ParentTypes ShapePlanT = '[]
instance O.HasParentTypes ShapePlanT

instance B.Types.TypedObject ShapePlanT where
    glibType = c_hb_gobject_shape_plan_get_type

instance B.Types.GBoxed ShapePlanT

-- | Convert t'ShapePlanT' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ShapePlanT) where
    gvalueGType_ = c_hb_gobject_shape_plan_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr ShapePlanT)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr ShapePlanT)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed ShapePlanT ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ShapePlanT
type instance O.AttributeList ShapePlanT = ShapePlanTAttributeList
type ShapePlanTAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveShapePlanTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveShapePlanTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveShapePlanTMethod t ShapePlanT, O.OverloadedMethod info ShapePlanT p) => OL.IsLabel t (ShapePlanT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveShapePlanTMethod t ShapePlanT, O.OverloadedMethod info ShapePlanT p, R.HasField t ShapePlanT p) => R.HasField t ShapePlanT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveShapePlanTMethod t ShapePlanT, O.OverloadedMethodInfo info ShapePlanT) => OL.IsLabel t (O.MethodProxy info ShapePlanT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


