
#include <sbkpep.h>
#include <shiboken.h>
#include <sbkbindingutils.h>
#include <algorithm>
#include <signature.h>
#include <sbkcontainer.h>
#include <sbkstaticstrings.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysidecleanup.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <pysidestaticstrings.h>
#include "kjobwidgets_python.h"

#include <QList>
#include <QMap>
#include <QString>
#include <utility>


// Current module's type array.
Shiboken::Module::TypeInitStruct *SbkKJobWidgetsTypeStructs = nullptr;
// Backwards compatible structure with identical indexing.
PyTypeObject **SbkKJobWidgetsTypes = nullptr;
// Current module's converter array.
SbkConverter **SbkKJobWidgetsTypeConverters = nullptr;

void cleanTypesAttributes() {
    static PyObject *attrName = Shiboken::PyName::qtStaticMetaObject();
    const int imax = SBK_KJobWidgets_IDX_COUNT;
    for (int i = 0; i < imax && SbkKJobWidgetsTypeStructs[i].fullName != nullptr; ++i) {
        auto *pyType = reinterpret_cast<PyObject *>(SbkKJobWidgetsTypeStructs[i].type);
        if (pyType != nullptr && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}

// Global functions ------------------------------------------------------------

static PyMethodDef KJobWidgetsMethods[] = {
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
PyTypeObject *init_KNotificationJobUiDelegate(PyObject *enclosing);
PyTypeObject *init_KDialogJobUiDelegate(PyObject *enclosing);
PyTypeObject *init_KUiServerV2JobTracker(PyObject *enclosing);
PyTypeObject *init_KUiServerJobTracker(PyObject *enclosing);
PyTypeObject *init_KAbstractWidgetJobTracker(PyObject *enclosing);
PyTypeObject *init_KWidgetJobTracker(PyObject *enclosing);
PyTypeObject *init_KStatusBarJobTracker(PyObject *enclosing);

// Required modules' type and converter arrays.
Shiboken::Module::TypeInitStruct *SbkPySide6_QtCoreTypeStructs;
SbkConverter **SbkPySide6_QtCoreTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtWidgetsTypeStructs;
SbkConverter **SbkPySide6_QtWidgetsTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtGuiTypeStructs;
SbkConverter **SbkPySide6_QtGuiTypeConverters;
Shiboken::Module::TypeInitStruct *SbkKCoreAddonsTypeStructs;
SbkConverter **SbkKCoreAddonsTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for container type 'QList<int>'.
static PyObject *_QList_int__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<int> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<int>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_int_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<int> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_int__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return PySequence_PythonToCpp__QList_int_;
    return {};
}


// Binding for QList<int>

template <>
struct ShibokenContainerValueConverter<int>
{
    static bool checkValue(PyObject *pyArg)
    {
        return PyLong_Check(pyArg);
    }

    static PyObject *convertValueToPython(int cppArg)
    {
        return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppArg);
    }

    static std::optional<int> convertValueToCpp(PyObject *pyArg)
    {
        Shiboken::Conversions::PythonToCppConversion pythonToCpp;
        if (!(PyLong_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg))))) {
            Shiboken::Errors::setWrongContainerType();
            return {};
        }
        int cppArg;
        pythonToCpp(pyArg, &cppArg);
        return cppArg;
    }
};

static PyMethodDef QIntList_methods[] = {
    {"push_back", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_back), METH_O, "push_back"},
    {"append", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_back), METH_O, "append"},
    {"clear", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::clear), METH_NOARGS, "clear"},
    {"pop_back", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_back), METH_NOARGS, "pop_back"},
    {"removeLast", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_back), METH_NOARGS, "removeLast"},
    {"push_front", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_front), METH_O, "push_front"},
    {"prepend", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_front), METH_O, "prepend"},
    {"pop_front", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_front), METH_NOARGS, "pop_front"},
    {"removeFirst", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_front), METH_O, "removeFirst"},
    {"reserve", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::reserve), METH_O, "reserve"},
    {"capacity", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::capacity), METH_NOARGS, "capacity"},
    {"data", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::data), METH_NOARGS, "data"},
    {"constData", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::constData), METH_NOARGS, "constData"},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyType_Slot QIntList_slots[] = {
    {Py_tp_init, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpInit)},
    {Py_tp_new, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpNew)},
    {Py_tp_free, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpFree)},
    {Py_tp_dealloc, reinterpret_cast<void *>(Sbk_object_dealloc)},
    {Py_tp_methods, reinterpret_cast<void *>(QIntList_methods)},
    {Py_sq_ass_item, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqSetItem)},
    {Py_sq_length, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqLen)},
    {Py_sq_item, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqGetItem)},
    {0, nullptr}
};

static PyType_Spec QIntList_spec = {
    "1:KJobWidgets.QIntList",
    sizeof(ShibokenContainer),
    0,
    Py_TPFLAGS_DEFAULT,
    QIntList_slots
};

static inline PyTypeObject *createQIntListType()
{
    auto *result = SbkType_FromSpec(&QIntList_spec);
    Py_INCREF(Py_True);
    Shiboken::AutoDecRef tpDict(PepType_GetDict(result));
    PyDict_SetItem(tpDict.object(), Shiboken::PyMagicName::opaque_container(), Py_True);
    return result;
}

static PyTypeObject *QIntList_TypeF()
{
    static PyTypeObject *type = createQIntListType();
    return type;
}

extern "C" PyObject *createQIntList(QList<int>* ct)
{
    auto *container = PyObject_New(ShibokenContainer, QIntList_TypeF());
    auto *d = new ShibokenSequenceContainerPrivate<QList<int>>();
    d->m_list = ct;
    container->d = d;
    return reinterpret_cast<PyObject *>(container);
}

extern "C" PyObject *createConstQIntList(const QList<int>* ct)
{
    auto *container = PyObject_New(ShibokenContainer, QIntList_TypeF());
    auto *d = new ShibokenSequenceContainerPrivate<QList<int>>();
    d->m_list = const_cast<QList<int> *>(ct);
    d->m_const = true;
    container->d = d;
    return reinterpret_cast<PyObject *>(container);
}

extern "C" int QIntList_Check(PyObject *pyArg)
{
    return pyArg != nullptr && pyArg != Py_None && pyArg->ob_type == QIntList_TypeF();
}

extern "C" void PythonToCppQIntList(PyObject *pyArg, void *cppOut)
{
    auto *d = ShibokenSequenceContainerPrivate<QList<int>>::get(pyArg);
    *reinterpret_cast<QList<int>**>(cppOut) = d->m_list;
}

extern "C" PythonToCppFunc isQIntListPythonToCppConvertible(PyObject *pyArg)
{
    if (QIntList_Check(pyArg))
        return PythonToCppQIntList;
    return {};
}

extern "C" void PythonToQVariantQIntList(PyObject *pyArg, void *cppOut)
{
    auto *d = ShibokenSequenceContainerPrivate<QList<int>>::get(pyArg);
    *reinterpret_cast<QVariant *>(cppOut) = QVariant::fromValue(*d->m_list);
}

extern "C" PythonToCppFunc isQIntListPythonToQVariantConvertible(PyObject *pyArg)
{
    if (QIntList_Check(pyArg))
        return PythonToQVariantQIntList;
    return {};
}

// C++ to Python conversion for container type 'std::pair<QString,QString>'.
static PyObject *std_pair_QString_QString__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const std::pair<QString,QString> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cpppair_to_pytuple - START
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SetItem(pyOut, 0, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppInRef.first));
    PyTuple_SetItem(pyOut, 1, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppInRef.second));
    return pyOut;
    // TEMPLATE - shiboken_conversion_cpppair_to_pytuple - END

}
static void PySequence_PythonToCpp_std_pair_QString_QString_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<std::pair<QString,QString> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pysequence_to_cpppair - START
    Shiboken::AutoDecRef objfirst(PySequence_GetItem(pyIn, 0));
    Shiboken::AutoDecRef objsecond(PySequence_GetItem(pyIn, 1));
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], objfirst, &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], objsecond, &(cppOutRef.second));
    // TEMPLATE - shiboken_conversion_pysequence_to_cpppair - END

}
static PythonToCppFunc is_PySequence_PythonToCpp_std_pair_QString_QString__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertiblePairTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, pyIn))
        return PySequence_PythonToCpp_std_pair_QString_QString_;
    return {};
}

// C++ to Python conversion for container type 'QList<QVariant>'.
static PyObject *_QList_QVariant__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::QVariant>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], pyIn))
        return PySequence_PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for container type 'QList<QString>'.
static PyObject *_QList_QString__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QString> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        ShibokenContainerStdVectorValueType<::QString>::Type cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QString> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QString__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyIn))
        return PySequence_PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for container type 'QMap<QString,QVariant>'.
static PyObject *_QMap_QString_QVariant__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QMap<QString,QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::QVariant cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], false, pyIn))
        return PyDict_PythonToCpp__QMap_QString_QVariant_;
    return {};
}


// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KJobWidgets_SignatureStrings[] = {
    nullptr}; // Sentinel
#else
static constexpr size_t KJobWidgets_SignatureByteSize = 0;
static constexpr uint8_t KJobWidgets_SignatureBytes[1] = {
    0x00
};
#endif

static void initInheritance()
{
    auto &bm = Shiboken::BindingManager::instance();
    SBK_UNUSED(bm)
    bm.addClassInheritance(&SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX],
                           &SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX]);
    bm.addClassInheritance(&SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX],
                           &SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]);
    bm.addClassInheritance(&SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX],
                           &SbkKJobWidgetsTypeStructs[SBK_KUiServerV2JobTracker_IDX]);
    bm.addClassInheritance(&SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX],
                           &SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);
    bm.addClassInheritance(&SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX],
                           &SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);
    bm.addClassInheritance(&SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX],
                           &SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);
    bm.addClassInheritance(&SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX],
                           &SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);
}

static void initConverters_KJobWidgets()
{
    // Register primitive types converters.
    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blksize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "__caddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__clock_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__clockid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__compar_d_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__compar_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__daddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__dev_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsblkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsblkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsfilcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsfilcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__fsword_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__gid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__id_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__ino64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__ino_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<short>(), "__int16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__int32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__int64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "__int8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<short>(), "__int_least16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__int_least32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__int_least64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "__int_least8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__intmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__intptr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__key_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__loff_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__mode_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__nlink_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__off64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__off_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__pid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__poll_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__rlim64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__rlim_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__sig_atomic_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__socklen_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__ssize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__suseconds64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__suseconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__syscall_slong_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__syscall_ulong_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__time_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__u_char");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__u_int");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__u_long");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__u_quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__u_short");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__uint16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uint32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uint64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__uint8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__uint_least16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uint_least32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uint_least64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__uint_least8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uintmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__useconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blksize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "caddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "comparison_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "daddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "dev_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsblkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsblkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsfilcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsfilcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "gid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "id_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "ino64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "ino_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "int_fast8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "intmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "key_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "loff_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "mode_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "nlink_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "off64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "off_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "pid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "qInternalCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "register_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "ssize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "suseconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "u_char");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "u_int");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "u_int16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "u_int32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_int64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "u_int8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_long");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "u_short");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "uid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "uint_fast8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uintmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "useconds_t");

}

static void initContainerConverters_KJobWidgets()
{
    // Register converter for type 'QList<int>'.
    SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QList_int_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_int__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QList_int_IDX], "QList<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QList_int_IDX],
        PySequence_PythonToCpp__QList_int_,
        is_PySequence_PythonToCpp__QList_int__Convertible);
    Shiboken::Conversions::setPythonToCppPointerFunctions(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QList_int_IDX],
        PythonToCppQIntList,
        isQIntListPythonToCppConvertible);

    // Register converter for type 'std::pair<QString,QString>'.
    SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, std_pair_QString_QString__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX], "std::pair<QString,QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX],
        PySequence_PythonToCpp_std_pair_QString_QString_,
        is_PySequence_PythonToCpp_std_pair_QString_QString__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QList_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QList_QVariant_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QList_QVariant_IDX],
        PySequence_PythonToCpp__QList_QVariant_,
        is_PySequence_PythonToCpp__QList_QVariant__Convertible);
    // Register converters for type aliases of QList<QVariant>'.
    Shiboken::Conversions::registerConverterName(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QList_QVariant_IDX], "QVariantList");

    // Register converter for type 'QList<QString>'.
    SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QList_QString_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QList_QString_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QList_QString_IDX],
        PySequence_PythonToCpp__QList_QString_,
        is_PySequence_PythonToCpp__QList_QString__Convertible);
    // Register converters for type aliases of QList<QString>'.

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QMap_QString_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QMap_QString_QVariant_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QMap_QString_QVariant_IDX],
        PyDict_PythonToCpp__QMap_QString_QVariant_,
        is_PyDict_PythonToCpp__QMap_QString_QVariant__Convertible);
    // Register converters for type aliases of QMap<QString,QVariant>'.
    Shiboken::Conversions::registerConverterName(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_QMap_QString_QVariant_IDX], "QVariantMap");

}

static void registerOpaqueContainers_KJobWidgets(PyObject *module)
{
    PyTypeObject *pyType{};
    auto *qVariantConverter = Shiboken::Conversions::getConverter("QVariant");
    Q_ASSERT(qVariantConverter != nullptr);
    pyType = QIntList_TypeF();
    Py_XINCREF(reinterpret_cast<PyObject *>(pyType));
    PepModule_AddType(module, pyType);
    if constexpr (QMetaTypeId2<int>::Defined) {
        Shiboken::Conversions::prependPythonToCppValueConversion(qVariantConverter,
            PythonToQVariantQIntList, isQIntListPythonToQVariantConvertible);
    }
}

extern "C" {
static int exec_KJobWidgets(PyObject *module)
{
    Shiboken::Module::exec(module);

    // Initialize classes in the type system
    Shiboken::Module::AddTypeCreationFunction(module, "KNotificationJobUiDelegate", init_KNotificationJobUiDelegate);
    Shiboken::Module::AddTypeCreationFunction(module, "KDialogJobUiDelegate", init_KDialogJobUiDelegate);
    Shiboken::Module::AddTypeCreationFunction(module, "KUiServerV2JobTracker", init_KUiServerV2JobTracker);
    Shiboken::Module::AddTypeCreationFunction(module, "KUiServerJobTracker", init_KUiServerJobTracker);
    Shiboken::Module::AddTypeCreationFunction(module, "KAbstractWidgetJobTracker", init_KAbstractWidgetJobTracker);
    Shiboken::Module::AddTypeCreationFunction(module, "KWidgetJobTracker", init_KWidgetJobTracker);
    Shiboken::Module::AddTypeCreationFunction(module, "KStatusBarJobTracker", init_KStatusBarJobTracker);

    registerOpaqueContainers_KJobWidgets(module);

    Shiboken::Module::registerTypes(module, SbkKJobWidgetsTypeStructs);
    Shiboken::Module::registerTypeConverters(module, SbkKJobWidgetsTypeConverters);

    initInheritance();

    if (Shiboken::Errors::occurred() != nullptr) {
        PyErr_Print();
        Py_FatalError("shiboken: can't initialize module KJobWidgets");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

#if PYSIDE6_COMOPT_COMPRESS == 0
    FinishSignatureInitialization(module, KJobWidgets_SignatureStrings);
#else
    if (FinishSignatureInitBytes(module, KJobWidgets_SignatureBytes, KJobWidgets_SignatureByteSize) < 0)
        return -1;
#endif

    return 0;
}
} // extern "C"

static PyModuleDef_Slot KJobWidgetsModuleSlots[] = {
    {Py_mod_exec, reinterpret_cast<void *>(exec_KJobWidgets)},
#if !defined(PYPY_VERSION) && ((!defined(Py_LIMITED_API) && PY_VERSION_HEX >= 0x030C0000) || (defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030C0000))
    {Py_mod_multiple_interpreters, Py_MOD_MULTIPLE_INTERPRETERS_NOT_SUPPORTED},
#endif
#ifdef Py_GIL_DISABLED
    {Py_mod_gil, Py_MOD_GIL_USED},
#endif
    {0, nullptr}
};

static struct PyModuleDef KJobWidgetsModuleDef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "KJobWidgets",
    /* m_doc      */ nullptr,
    /* m_size     */ 0,
    /* m_methods  */ KJobWidgetsMethods,
    /* m_slots    */ KJobWidgetsModuleSlots,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

extern "C" LIBSHIBOKEN_EXPORT PyObject *PyInit_KJobWidgets()
{
    Shiboken::init();

    // Create an array of wrapper types/names for the current module.
    static Shiboken::Module::TypeInitStruct cppApi[] = {
        {nullptr, "KJobWidgets.KAbstractWidgetJobTracker"},
        {nullptr, "KJobWidgets.KDialogJobUiDelegate"},
        {nullptr, "KJobWidgets.KNotificationJobUiDelegate"},
        {nullptr, "KJobWidgets.KStatusBarJobTracker"},
        {nullptr, "KJobWidgets.KStatusBarJobTracker.StatusBarMode"},
        {nullptr, "KJobWidgets.KUiServerJobTracker"},
        {nullptr, "KJobWidgets.KUiServerV2JobTracker"},
        {nullptr, "KJobWidgets.KWidgetJobTracker"},
        {nullptr, "KJobWidgets.KStatusBarJobTracker.yes"},
        {nullptr, nullptr}
    };
    // The new global structure consisting of (type, name) pairs.
    SbkKJobWidgetsTypeStructs = cppApi;
    QT_WARNING_PUSH
    QT_WARNING_DISABLE_DEPRECATED
    // The backward compatible alias with upper case indexes.
    SbkKJobWidgetsTypes = reinterpret_cast<PyTypeObject **>(cppApi);
    QT_WARNING_POP

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_KJobWidgets_CONVERTERS_IDX_COUNT];
    SbkKJobWidgetsTypeConverters = sbkConverters;

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtCore"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtCoreTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtWidgets"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtWidgetsTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtWidgetsTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtGui"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtGuiTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("KCoreAddons"));
        if (requiredModule.isNull())
            return nullptr;
        SbkKCoreAddonsTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkKCoreAddonsTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    initConverters_KJobWidgets();
    initContainerConverters_KJobWidgets();

    PyObject *module = nullptr;
    if (Shiboken::isCompiled()) {
        KJobWidgetsModuleDef.m_size = -1;
        KJobWidgetsModuleDef.m_slots = nullptr;
        module = Shiboken::Module::createOnly("KJobWidgets", &KJobWidgetsModuleDef);
        if (module == nullptr)
            return nullptr;
#ifdef Py_GIL_DISABLED
        PyUnstable_Module_SetGIL(module, Py_MOD_GIL_NOT_USED);
#endif
        if (exec_KJobWidgets(module) != 0)
            return nullptr;
    } else {
        module = PyModuleDef_Init(&KJobWidgetsModuleDef);
    }
    return module;
}

