/*
    SPDX-FileCopyrightText: 2022 Andrius Štikonas <andrius@stikonas.eu>
    SPDX-License-Identifier: GPL-3.0-or-later
*/
#include <unordered_set>
#include <QDir>
#include <QStandardPaths>

const std::unordered_set<QString> trustedPrefixes {
    QStringLiteral("/"),
    QStringLiteral("/usr"),
    QStringLiteral("/usr/local")
};

[[maybe_unused]] static const QString findTrustedCommand(QString name) {
    for (const QString& prefix : trustedPrefixes) {
        QDir prefixDir = QDir(prefix);
        QString cmd = QStandardPaths::findExecutable(name, { prefixDir.absoluteFilePath(QStringLiteral("bin/")), prefixDir.absoluteFilePath(QStringLiteral("sbin/")) });
        if (!cmd.isEmpty()) {
            return cmd;
        }
    }
    return QString();
}
