#include "nv_push_clb06f.h"

#include <stdio.h>





const char *P_PARSE_NVA26F_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVA26F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVB06F_MTHD(uint16_t idx)
{
    switch (idx) {

  
        
    case NVB06F_SET_OBJECT:

        
    case NVB06F_ILLEGAL:

        
    case NVB06F_NOP:

        
    case NVB06F_SEMAPHOREA:

        
    case NVB06F_SEMAPHOREB:

        
    case NVB06F_SEMAPHOREC:

        
    case NVB06F_NON_STALL_INTERRUPT:

        
    case NVB06F_FB_FLUSH:

        
    case NVB06F_SET_REFERENCE:

        
    case NVB06F_CRC_CHECK:


    return P_PARSE_NVA26F_MTHD(idx);

                            case NVB06F_SEMAPHORED:
        return "NVB06F_SEMAPHORED";
            case NVB06F_MEM_OP_C:
        return "NVB06F_MEM_OP_C";
    case NVB06F_MEM_OP_D:
        return "NVB06F_MEM_OP_D";
        case NVB06F_WFI:
        return "NVB06F_WFI";
        case NVB06F_YIELD:
        return "NVB06F_YIELD";

    default:
        return "unknown method";
    }
}

void
P_DUMP_NVB06F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
        
    case NVB06F_SET_OBJECT:

        
    case NVB06F_ILLEGAL:

        
    case NVB06F_NOP:

        
    case NVB06F_SEMAPHOREA:

        
    case NVB06F_SEMAPHOREB:

        
    case NVB06F_SEMAPHOREC:

        
    case NVB06F_NON_STALL_INTERRUPT:

        
    case NVB06F_FB_FLUSH:

        
    case NVB06F_SET_REFERENCE:

        
    case NVB06F_CRC_CHECK:


    P_DUMP_NVA26F_MTHD_DATA(fp, idx, data, prefix);
    break;

                          
    case NVB06F_SEMAPHORED:

    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVB06F_SEMAPHORED_OPERATION_ACQUIRE:
            fprintf(fp, "ACQUIRE\n");
            break;
        case NVB06F_SEMAPHORED_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVB06F_SEMAPHORED_OPERATION_ACQ_GEQ:
            fprintf(fp, "ACQ_GEQ\n");
            break;
        case NVB06F_SEMAPHORED_OPERATION_ACQ_AND:
            fprintf(fp, "ACQ_AND\n");
            break;
        case NVB06F_SEMAPHORED_OPERATION_REDUCTION:
            fprintf(fp, "REDUCTION\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.ACQUIRE_SWITCH = ", prefix);
        switch (parsed) {
        case NVB06F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED:
            fprintf(fp, "DISABLED\n");
            break;
        case NVB06F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED:
            fprintf(fp, "ENABLED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_WFI = ", prefix);
        switch (parsed) {
        case NVB06F_SEMAPHORED_RELEASE_WFI_EN:
            fprintf(fp, "EN\n");
            break;
        case NVB06F_SEMAPHORED_RELEASE_WFI_DIS:
            fprintf(fp, "DIS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_SIZE = ", prefix);
        switch (parsed) {
        case NVB06F_SEMAPHORED_RELEASE_SIZE_16BYTE:
            fprintf(fp, "16BYTE\n");
            break;
        case NVB06F_SEMAPHORED_RELEASE_SIZE_4BYTE:
            fprintf(fp, "4BYTE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 27) & ((1u << 4) - 1);
        fprintf(fp, "%s.REDUCTION = ", prefix);
        switch (parsed) {
        case NVB06F_SEMAPHORED_REDUCTION_MIN:
            fprintf(fp, "MIN\n");
            break;
        case NVB06F_SEMAPHORED_REDUCTION_MAX:
            fprintf(fp, "MAX\n");
            break;
        case NVB06F_SEMAPHORED_REDUCTION_XOR:
            fprintf(fp, "XOR\n");
            break;
        case NVB06F_SEMAPHORED_REDUCTION_AND:
            fprintf(fp, "AND\n");
            break;
        case NVB06F_SEMAPHORED_REDUCTION_OR:
            fprintf(fp, "OR\n");
            break;
        case NVB06F_SEMAPHORED_REDUCTION_ADD:
            fprintf(fp, "ADD\n");
            break;
        case NVB06F_SEMAPHORED_REDUCTION_INC:
            fprintf(fp, "INC\n");
            break;
        case NVB06F_SEMAPHORED_REDUCTION_DEC:
            fprintf(fp, "DEC\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.FORMAT = ", prefix);
        switch (parsed) {
        case NVB06F_SEMAPHORED_FORMAT_SIGNED:
            fprintf(fp, "SIGNED\n");
            break;
        case NVB06F_SEMAPHORED_FORMAT_UNSIGNED:
            fprintf(fp, "UNSIGNED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
          
    case NVB06F_MEM_OP_C:

    
        parsed = (data >> 2) & ((1u << 30) - 1);
        fprintf(fp, "%s.OPERAND_LOW = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB = ", prefix);
        switch (parsed) {
        case NVB06F_MEM_OP_C_TLB_INVALIDATE_PDB_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NVB06F_MEM_OP_C_TLB_INVALIDATE_PDB_ALL:
            fprintf(fp, "ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_GPC = ", prefix);
        switch (parsed) {
        case NVB06F_MEM_OP_C_TLB_INVALIDATE_GPC_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        case NVB06F_MEM_OP_C_TLB_INVALIDATE_GPC_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 2) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_TARGET = ", prefix);
        switch (parsed) {
        case NVB06F_MEM_OP_C_TLB_INVALIDATE_TARGET_VID_MEM:
            fprintf(fp, "VID_MEM\n");
            break;
        case NVB06F_MEM_OP_C_TLB_INVALIDATE_TARGET_SYS_MEM_COHERENT:
            fprintf(fp, "SYS_MEM_COHERENT\n");
            break;
        case NVB06F_MEM_OP_C_TLB_INVALIDATE_TARGET_SYS_MEM_NONCOHERENT:
            fprintf(fp, "SYS_MEM_NONCOHERENT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 20) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_ADDR_LO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVB06F_MEM_OP_D:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OPERAND_HIGH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 5) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVB06F_MEM_OP_D_OPERATION_MEMBAR:
            fprintf(fp, "MEMBAR\n");
            break;
        case NVB06F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE:
            fprintf(fp, "MMU_TLB_INVALIDATE\n");
            break;
        case NVB06F_MEM_OP_D_OPERATION_L2_PEERMEM_INVALIDATE:
            fprintf(fp, "L2_PEERMEM_INVALIDATE\n");
            break;
        case NVB06F_MEM_OP_D_OPERATION_L2_SYSMEM_INVALIDATE:
            fprintf(fp, "L2_SYSMEM_INVALIDATE\n");
            break;
        case NVB06F_MEM_OP_D_OPERATION_L2_CLEAN_COMPTAGS:
            fprintf(fp, "L2_CLEAN_COMPTAGS\n");
            break;
        case NVB06F_MEM_OP_D_OPERATION_L2_FLUSH_DIRTY:
            fprintf(fp, "L2_FLUSH_DIRTY\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_ADDR_HI = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
      
    case NVB06F_WFI:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.SCOPE = ", prefix);
        switch (parsed) {
        case NVB06F_WFI_SCOPE_ALL:
            fprintf(fp, "ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
      
    case NVB06F_YIELD:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OP = ", prefix);
        switch (parsed) {
        case NVB06F_YIELD_OP_NOP:
            fprintf(fp, "NOP\n");
            break;
        case NVB06F_YIELD_OP_PBDMA_TIMESLICE:
            fprintf(fp, "PBDMA_TIMESLICE\n");
            break;
        case NVB06F_YIELD_OP_RUNLIST_TIMESLICE:
            fprintf(fp, "RUNLIST_TIMESLICE\n");
            break;
        case NVB06F_YIELD_OP_TSG:
            fprintf(fp, "TSG\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
