#include "nv_push_clc5b0.h"

#include <stdio.h>






const char*
P_PARSE_NVC5B0_MTHD(uint16_t idx)
{
    switch (idx) {


    case NVC5B0_NOP:
        return "NVC5B0_NOP";
    case NVC5B0_SET_APPLICATION_ID:
        return "NVC5B0_SET_APPLICATION_ID";
    case NVC5B0_SET_WATCHDOG_TIMER:
        return "NVC5B0_SET_WATCHDOG_TIMER";
    case NVC5B0_SEMAPHORE_A:
        return "NVC5B0_SEMAPHORE_A";
    case NVC5B0_SEMAPHORE_B:
        return "NVC5B0_SEMAPHORE_B";
    case NVC5B0_SEMAPHORE_C:
        return "NVC5B0_SEMAPHORE_C";
    case NVC5B0_CTX_SAVE_AREA:
        return "NVC5B0_CTX_SAVE_AREA";
    case NVC5B0_CTX_SWITCH:
        return "NVC5B0_CTX_SWITCH";
    case NVC5B0_EXECUTE:
        return "NVC5B0_EXECUTE";
    case NVC5B0_SEMAPHORE_D:
        return "NVC5B0_SEMAPHORE_D";
    case NVC5B0_SET_CONTROL_PARAMS:
        return "NVC5B0_SET_CONTROL_PARAMS";
    case NVC5B0_SET_DRV_PIC_SETUP_OFFSET:
        return "NVC5B0_SET_DRV_PIC_SETUP_OFFSET";
    case NVC5B0_SET_IN_BUF_BASE_OFFSET:
        return "NVC5B0_SET_IN_BUF_BASE_OFFSET";
    case NVC5B0_SET_PICTURE_INDEX:
        return "NVC5B0_SET_PICTURE_INDEX";
    case NVC5B0_SET_SLICE_OFFSETS_BUF_OFFSET:
        return "NVC5B0_SET_SLICE_OFFSETS_BUF_OFFSET";
    case NVC5B0_SET_COLOC_DATA_OFFSET:
        return "NVC5B0_SET_COLOC_DATA_OFFSET";
    case NVC5B0_SET_HISTORY_OFFSET:
        return "NVC5B0_SET_HISTORY_OFFSET";
    case NVC5B0_SET_DISPLAY_BUF_SIZE:
        return "NVC5B0_SET_DISPLAY_BUF_SIZE";
    case NVC5B0_SET_HISTOGRAM_OFFSET:
        return "NVC5B0_SET_HISTOGRAM_OFFSET";
    case NVC5B0_SET_NVDEC_STATUS_OFFSET:
        return "NVC5B0_SET_NVDEC_STATUS_OFFSET";
    case NVC5B0_SET_DISPLAY_BUF_LUMA_OFFSET:
        return "NVC5B0_SET_DISPLAY_BUF_LUMA_OFFSET";
    case NVC5B0_SET_DISPLAY_BUF_CHROMA_OFFSET:
        return "NVC5B0_SET_DISPLAY_BUF_CHROMA_OFFSET";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET0:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET0";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET1:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET1";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET2:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET2";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET3:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET3";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET4:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET4";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET5:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET5";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET6:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET6";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET7:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET7";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET8:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET8";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET9:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET9";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET10:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET10";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET11:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET11";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET12:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET12";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET13:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET13";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET14:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET14";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET15:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET15";
    case NVC5B0_SET_PICTURE_LUMA_OFFSET16:
        return "NVC5B0_SET_PICTURE_LUMA_OFFSET16";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET0:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET0";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET1:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET1";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET2:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET2";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET3:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET3";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET4:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET4";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET5:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET5";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET6:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET6";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET7:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET7";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET8:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET8";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET9:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET9";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET10:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET10";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET11:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET11";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET12:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET12";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET13:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET13";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET14:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET14";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET15:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET15";
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET16:
        return "NVC5B0_SET_PICTURE_CHROMA_OFFSET16";
    case NVC5B0_SET_PIC_SCRATCH_BUF_OFFSET:
        return "NVC5B0_SET_PIC_SCRATCH_BUF_OFFSET";
    case NVC5B0_SET_EXTERNAL_MVBUFFER_OFFSET:
        return "NVC5B0_SET_EXTERNAL_MVBUFFER_OFFSET";
    case NVC5B0_H264_SET_MBHIST_BUF_OFFSET:
        return "NVC5B0_H264_SET_MBHIST_BUF_OFFSET";
    case NVC5B0_VP8_SET_PROB_DATA_OFFSET:
        return "NVC5B0_VP8_SET_PROB_DATA_OFFSET";
    case NVC5B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET:
        return "NVC5B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET";
    case NVC5B0_HEVC_SET_SCALING_LIST_OFFSET:
        return "NVC5B0_HEVC_SET_SCALING_LIST_OFFSET";
    case NVC5B0_HEVC_SET_TILE_SIZES_OFFSET:
        return "NVC5B0_HEVC_SET_TILE_SIZES_OFFSET";
    case NVC5B0_HEVC_SET_FILTER_BUFFER_OFFSET:
        return "NVC5B0_HEVC_SET_FILTER_BUFFER_OFFSET";
    case NVC5B0_HEVC_SET_SAO_BUFFER_OFFSET:
        return "NVC5B0_HEVC_SET_SAO_BUFFER_OFFSET";
    case NVC5B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET:
        return "NVC5B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET";
    case NVC5B0_HEVC_SET_SLICE_GROUP_INDEX:
        return "NVC5B0_HEVC_SET_SLICE_GROUP_INDEX";
    case NVC5B0_VP9_SET_PROB_TAB_BUF_OFFSET:
        return "NVC5B0_VP9_SET_PROB_TAB_BUF_OFFSET";
    case NVC5B0_VP9_SET_CTX_COUNTER_BUF_OFFSET:
        return "NVC5B0_VP9_SET_CTX_COUNTER_BUF_OFFSET";
    case NVC5B0_VP9_SET_SEGMENT_READ_BUF_OFFSET:
        return "NVC5B0_VP9_SET_SEGMENT_READ_BUF_OFFSET";
    case NVC5B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET:
        return "NVC5B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET";
    case NVC5B0_VP9_SET_TILE_SIZE_BUF_OFFSET:
        return "NVC5B0_VP9_SET_TILE_SIZE_BUF_OFFSET";
    case NVC5B0_VP9_SET_COL_MVWRITE_BUF_OFFSET:
        return "NVC5B0_VP9_SET_COL_MVWRITE_BUF_OFFSET";
    case NVC5B0_VP9_SET_COL_MVREAD_BUF_OFFSET:
        return "NVC5B0_VP9_SET_COL_MVREAD_BUF_OFFSET";
    case NVC5B0_VP9_SET_FILTER_BUFFER_OFFSET:
        return "NVC5B0_VP9_SET_FILTER_BUFFER_OFFSET";

    default:
        return "unknown method";
    }
}

void
P_DUMP_NVC5B0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {


  
    case NVC5B0_NOP:

    
        parsed = data;
        fprintf(fp, "%s.PARAMETER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_APPLICATION_ID:

    
        parsed = data;
        fprintf(fp, "%s.ID = ", prefix);
        switch (parsed) {
        case NVC5B0_SET_APPLICATION_ID_ID_MPEG12:
            fprintf(fp, "MPEG12\n");
            break;
        case NVC5B0_SET_APPLICATION_ID_ID_VC1:
            fprintf(fp, "VC1\n");
            break;
        case NVC5B0_SET_APPLICATION_ID_ID_H264:
            fprintf(fp, "H264\n");
            break;
        case NVC5B0_SET_APPLICATION_ID_ID_MPEG4:
            fprintf(fp, "MPEG4\n");
            break;
        case NVC5B0_SET_APPLICATION_ID_ID_VP8:
            fprintf(fp, "VP8\n");
            break;
        case NVC5B0_SET_APPLICATION_ID_ID_HEVC:
            fprintf(fp, "HEVC\n");
            break;
        case NVC5B0_SET_APPLICATION_ID_ID_VP9:
            fprintf(fp, "VP9\n");
            break;
        case NVC5B0_SET_APPLICATION_ID_ID_HEVC_PARSER:
            fprintf(fp, "HEVC_PARSER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVC5B0_SET_WATCHDOG_TIMER:

    
        parsed = data;
        fprintf(fp, "%s.TIMER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SEMAPHORE_A:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SEMAPHORE_B:

    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SEMAPHORE_C:

    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_CTX_SAVE_AREA:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_CTX_SWITCH:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OP = ", prefix);
        switch (parsed) {
        case NVC5B0_CTX_SWITCH_OP_CTX_UPDATE:
            fprintf(fp, "CTX_UPDATE\n");
            break;
        case NVC5B0_CTX_SWITCH_OP_CTX_SAVE:
            fprintf(fp, "CTX_SAVE\n");
            break;
        case NVC5B0_CTX_SWITCH_OP_CTX_RESTORE:
            fprintf(fp, "CTX_RESTORE\n");
            break;
        case NVC5B0_CTX_SWITCH_OP_CTX_FORCERESTORE:
            fprintf(fp, "CTX_FORCERESTORE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.CTXID_VALID = ", prefix);
        switch (parsed) {
        case NVC5B0_CTX_SWITCH_CTXID_VALID_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC5B0_CTX_SWITCH_CTXID_VALID_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 5) - 1);
        fprintf(fp, "%s.RESERVED0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 16) - 1);
        fprintf(fp, "%s.CTX_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 8) - 1);
        fprintf(fp, "%s.RESERVED1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_EXECUTE:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.NOTIFY = ", prefix);
        switch (parsed) {
        case NVC5B0_EXECUTE_NOTIFY_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVC5B0_EXECUTE_NOTIFY_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.NOTIFY_ON = ", prefix);
        switch (parsed) {
        case NVC5B0_EXECUTE_NOTIFY_ON_END:
            fprintf(fp, "END\n");
            break;
        case NVC5B0_EXECUTE_NOTIFY_ON_BEGIN:
            fprintf(fp, "BEGIN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.AWAKEN = ", prefix);
        switch (parsed) {
        case NVC5B0_EXECUTE_AWAKEN_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVC5B0_EXECUTE_AWAKEN_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVC5B0_SEMAPHORE_D:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.STRUCTURE_SIZE = ", prefix);
        switch (parsed) {
        case NVC5B0_SEMAPHORE_D_STRUCTURE_SIZE_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NVC5B0_SEMAPHORE_D_STRUCTURE_SIZE_FOUR:
            fprintf(fp, "FOUR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.AWAKEN_ENABLE = ", prefix);
        switch (parsed) {
        case NVC5B0_SEMAPHORE_D_AWAKEN_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC5B0_SEMAPHORE_D_AWAKEN_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 2) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC5B0_SEMAPHORE_D_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVC5B0_SEMAPHORE_D_OPERATION_RESERVED0:
            fprintf(fp, "RESERVED0\n");
            break;
        case NVC5B0_SEMAPHORE_D_OPERATION_RESERVED1:
            fprintf(fp, "RESERVED1\n");
            break;
        case NVC5B0_SEMAPHORE_D_OPERATION_TRAP:
            fprintf(fp, "TRAP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 21) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DISABLE = ", prefix);
        switch (parsed) {
        case NVC5B0_SEMAPHORE_D_FLUSH_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC5B0_SEMAPHORE_D_FLUSH_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVC5B0_SET_CONTROL_PARAMS:

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.CODEC_TYPE = ", prefix);
        switch (parsed) {
        case NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG1:
            fprintf(fp, "MPEG1\n");
            break;
        case NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG2:
            fprintf(fp, "MPEG2\n");
            break;
        case NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_VC1:
            fprintf(fp, "VC1\n");
            break;
        case NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_H264:
            fprintf(fp, "H264\n");
            break;
        case NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG4:
            fprintf(fp, "MPEG4\n");
            break;
        case NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP8:
            fprintf(fp, "VP8\n");
            break;
        case NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_HEVC:
            fprintf(fp, "HEVC\n");
            break;
        case NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP9:
            fprintf(fp, "VP9\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.GPTIMER_ON = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.RET_ERROR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.ERR_CONCEAL_ON = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 7) & ((1u << 6) - 1);
        fprintf(fp, "%s.ERROR_FRM_IDX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 13) & ((1u << 1) - 1);
        fprintf(fp, "%s.MBTIMER_ON = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 14) & ((1u << 1) - 1);
        fprintf(fp, "%s.EC_INTRA_FRAME_USING_PSLC = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 17) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALL_INTRA_FRAME = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 18) & ((1u << 14) - 1);
        fprintf(fp, "%s.RESERVED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_DRV_PIC_SETUP_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_IN_BUF_BASE_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_INDEX:

    
        parsed = data;
        fprintf(fp, "%s.INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_SLICE_OFFSETS_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_COLOC_DATA_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_HISTORY_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_DISPLAY_BUF_SIZE:

    
        parsed = data;
        fprintf(fp, "%s.SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_HISTOGRAM_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_NVDEC_STATUS_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_DISPLAY_BUF_LUMA_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_DISPLAY_BUF_CHROMA_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET0:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET1:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET2:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET3:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET4:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET5:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET6:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET7:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET8:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET9:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET10:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET11:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET12:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET13:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET14:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET15:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_LUMA_OFFSET16:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET0:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET1:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET2:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET3:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET4:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET5:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET6:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET7:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET8:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET9:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET10:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET11:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET12:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET13:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET14:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET15:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PICTURE_CHROMA_OFFSET16:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_PIC_SCRATCH_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_SET_EXTERNAL_MVBUFFER_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_H264_SET_MBHIST_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_VP8_SET_PROB_DATA_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_HEVC_SET_SCALING_LIST_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_HEVC_SET_TILE_SIZES_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_HEVC_SET_FILTER_BUFFER_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_HEVC_SET_SAO_BUFFER_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_HEVC_SET_SLICE_GROUP_INDEX:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_VP9_SET_PROB_TAB_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_VP9_SET_CTX_COUNTER_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_VP9_SET_SEGMENT_READ_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_VP9_SET_TILE_SIZE_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_VP9_SET_COL_MVWRITE_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_VP9_SET_COL_MVREAD_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC5B0_VP9_SET_FILTER_BUFFER_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
