/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-array.h"
#include "libical-glib-private.h"

G_DEFINE_TYPE (ICalArray, i_cal_array, I_CAL_TYPE_OBJECT)

static void i_cal_array_class_init (G_GNUC_UNUSED ICalArrayClass *klass)
{
}

static void i_cal_array_init (G_GNUC_UNUSED ICalArray *self)
{
}

/**
 * i_cal_array_new_full: (skip)
 * @native: The native libical object.
 * @owner: The parent.
 * @is_global_memory: Whether it is allocated in the global memory.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 *
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalArray *
i_cal_array_new_full (icalarray *native, 
                      GObject *owner, 
                      gboolean is_global_memory)
{
    ICalArray *object;
    if (native == NULL)
        return NULL;
    
    
    object = i_cal_object_construct (I_CAL_TYPE_ARRAY,
                            (gpointer) native,
                            (GDestroyNotify) icalarray_free,
                            is_global_memory,
                            owner);

    return object;
}


/**
 * i_cal_array_size:
 * @array: The #ICalArray
 *
 * Gets the size of the array.
 *
 * Returns: The size of current array.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_array_size (ICalArray *array)
{
	icalarray *native;
	gint ret;
	g_return_val_if_fail (array != NULL && I_CAL_IS_ARRAY (array), -1);
	native = i_cal_object_get_native ((ICalObject *)array);
	ret = native->num_elements;
	native = NULL;
	return ret;
}

/**
 * i_cal_array_copy:
 * @array: (in): The #ICalArray to be cloned
 *
 * Creates a deep copy of #ICalArray with the same properties as the @array.
 *
 * Returns: (transfer full): The newly cloned #ICalArray with the same value as the @array
 *
 * Since: 1.0
 *
 **/
ICalArray *
i_cal_array_copy (ICalArray *array)
{
	g_return_val_if_fail (I_CAL_IS_ARRAY (array), NULL);

	return i_cal_array_new_full (icalarray_copy ((icalarray *)i_cal_object_get_native (I_CAL_OBJECT (array))), NULL, FALSE);
}

/**
 * i_cal_array_free: (skip)
 * @array: The #ICalArray to be freed
 *
 * Frees the #ICalArray.
 *
 * Since: 1.0
 *
 **/
void
i_cal_array_free (ICalArray *array)
{
	g_return_if_fail (I_CAL_IS_ARRAY (array));

	icalarray_free ((icalarray *)i_cal_object_get_native (I_CAL_OBJECT (array)));
}

/**
 * i_cal_array_remove_element_at:
 * @array: The #ICalArray to be modified
 * @position: The position in which the element will be removed from the array
 *
 * Removes the element at the @position from the array.
 *
 * Since: 1.0
 *
 **/
void
i_cal_array_remove_element_at (ICalArray *array, 
                               gint position)
{
	g_return_if_fail (I_CAL_IS_ARRAY (array));

	icalarray_remove_element_at ((icalarray *)i_cal_object_get_native (I_CAL_OBJECT (array)), position);
}

/**
 * i_cal_array_element_at: (skip)
 * @array: The #ICalArray to be queried
 * @position: The position the target element is located
 *
 * Gets the element located in the @position in the @array. NULL if position if out of bound.
 *
 * Returns: (transfer none) (nullable): The element located at the @position in the @array
 *
 * Since: 1.0
 *
 **/
GObject *
i_cal_array_element_at (ICalArray *array, 
                        gint position)
{
	g_return_val_if_fail (I_CAL_IS_ARRAY (array), NULL);

	return icalarray_element_at ((icalarray *)i_cal_object_get_native (I_CAL_OBJECT (array)), position);
}

/**
 * i_cal_array_sort: (skip)
 * @array: The #ICalArray to be sorted
 *  @compare: (scope call): The compare function
 *
 * Does not work right now. Sorts the @array using the sort function @compare.
 *
 * Since: 1.0
 *
 **/
void
i_cal_array_sort (ICalArray *array, 
                  gint (*compare) (const void *, const void *))
{
	g_return_if_fail (I_CAL_IS_ARRAY (array));
	g_return_if_fail (array != NULL);
	g_return_if_fail (compare != NULL);

	icalarray_sort ((icalarray *)i_cal_object_get_native ((ICalObject *)array), compare);
}
