/* parsed class NVC7B0 */

#include "nvtypes.h"
#include "clc7b0.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nvc7b0_NOP {
    uint32_t parameter;
};

static inline void
__NVC7B0_NOP(uint32_t *val_out, struct nv_nvc7b0_NOP st)
{
    uint32_t val = 0;
    
    val |= st.parameter;
    *val_out = val;
}

#define V_NVC7B0_NOP(val, args...) { \
    struct nv_nvc7b0_NOP __data = { .parameter = (args) }; \
    __NVC7B0_NOP(&val, __data); \
}

#define VA_NVC7B0_NOP V_NVC7B0_NOP

#define P_NVC7B0_NOP(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_NOP(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_NOP, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PM_TRIGGER {
    uint32_t v;
};

static inline void
__NVC7B0_PM_TRIGGER(uint32_t *val_out, struct nv_nvc7b0_PM_TRIGGER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC7B0_PM_TRIGGER(val, args...) { \
    struct nv_nvc7b0_PM_TRIGGER __data = { .v = (args) }; \
    __NVC7B0_PM_TRIGGER(&val, __data); \
}

#define VA_NVC7B0_PM_TRIGGER V_NVC7B0_PM_TRIGGER

#define P_NVC7B0_PM_TRIGGER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PM_TRIGGER(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PM_TRIGGER, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_APPLICATION_ID {
    uint32_t id;
};

static inline void
__NVC7B0_SET_APPLICATION_ID(uint32_t *val_out, struct nv_nvc7b0_SET_APPLICATION_ID st)
{
    uint32_t val = 0;
    
    val |= st.id;
    *val_out = val;
}

#define V_NVC7B0_SET_APPLICATION_ID(val, args...) { \
    UNUSED uint32_t ID_MPEG12 = NVC7B0_SET_APPLICATION_ID_ID_MPEG12; \
    UNUSED uint32_t ID_VC1 = NVC7B0_SET_APPLICATION_ID_ID_VC1; \
    UNUSED uint32_t ID_H264 = NVC7B0_SET_APPLICATION_ID_ID_H264; \
    UNUSED uint32_t ID_MPEG4 = NVC7B0_SET_APPLICATION_ID_ID_MPEG4; \
    UNUSED uint32_t ID_VP8 = NVC7B0_SET_APPLICATION_ID_ID_VP8; \
    UNUSED uint32_t ID_CTR64 = NVC7B0_SET_APPLICATION_ID_ID_CTR64; \
    UNUSED uint32_t ID_HEVC = NVC7B0_SET_APPLICATION_ID_ID_HEVC; \
    UNUSED uint32_t ID_NEW_H264 = NVC7B0_SET_APPLICATION_ID_ID_NEW_H264; \
    UNUSED uint32_t ID_VP9 = NVC7B0_SET_APPLICATION_ID_ID_VP9; \
    UNUSED uint32_t ID_PASS1 = NVC7B0_SET_APPLICATION_ID_ID_PASS1; \
    UNUSED uint32_t ID_HEVC_PARSER = NVC7B0_SET_APPLICATION_ID_ID_HEVC_PARSER; \
    UNUSED uint32_t ID_UCODE_TEST = NVC7B0_SET_APPLICATION_ID_ID_UCODE_TEST; \
    UNUSED uint32_t ID_HWDRM_PR_DECRYPTAUDIO = NVC7B0_SET_APPLICATION_ID_ID_HWDRM_PR_DECRYPTAUDIO; \
    UNUSED uint32_t ID_HWDRM_PR_DECRYPTAUDIOMULTIPLE = NVC7B0_SET_APPLICATION_ID_ID_HWDRM_PR_DECRYPTAUDIOMULTIPLE; \
    UNUSED uint32_t ID_HWDRM_PR_PREPROCESSENCRYPTEDDATA = NVC7B0_SET_APPLICATION_ID_ID_HWDRM_PR_PREPROCESSENCRYPTEDDATA; \
    UNUSED uint32_t ID_VP9_WITH_PARSER = NVC7B0_SET_APPLICATION_ID_ID_VP9_WITH_PARSER; \
    UNUSED uint32_t ID_AVD = NVC7B0_SET_APPLICATION_ID_ID_AVD; \
    UNUSED uint32_t ID_HW_DRM_PR4_DECRYPTCONTENTMULTIPLE = NVC7B0_SET_APPLICATION_ID_ID_HW_DRM_PR4_DECRYPTCONTENTMULTIPLE; \
    UNUSED uint32_t ID_DHKE = NVC7B0_SET_APPLICATION_ID_ID_DHKE; \
    struct nv_nvc7b0_SET_APPLICATION_ID __data = { .id = (args) }; \
    __NVC7B0_SET_APPLICATION_ID(&val, __data); \
}

#define VA_NVC7B0_SET_APPLICATION_ID V_NVC7B0_SET_APPLICATION_ID

#define P_NVC7B0_SET_APPLICATION_ID(push, args...) do { \
    UNUSED uint32_t ID_MPEG12 = NVC7B0_SET_APPLICATION_ID_ID_MPEG12; \
    UNUSED uint32_t ID_VC1 = NVC7B0_SET_APPLICATION_ID_ID_VC1; \
    UNUSED uint32_t ID_H264 = NVC7B0_SET_APPLICATION_ID_ID_H264; \
    UNUSED uint32_t ID_MPEG4 = NVC7B0_SET_APPLICATION_ID_ID_MPEG4; \
    UNUSED uint32_t ID_VP8 = NVC7B0_SET_APPLICATION_ID_ID_VP8; \
    UNUSED uint32_t ID_CTR64 = NVC7B0_SET_APPLICATION_ID_ID_CTR64; \
    UNUSED uint32_t ID_HEVC = NVC7B0_SET_APPLICATION_ID_ID_HEVC; \
    UNUSED uint32_t ID_NEW_H264 = NVC7B0_SET_APPLICATION_ID_ID_NEW_H264; \
    UNUSED uint32_t ID_VP9 = NVC7B0_SET_APPLICATION_ID_ID_VP9; \
    UNUSED uint32_t ID_PASS1 = NVC7B0_SET_APPLICATION_ID_ID_PASS1; \
    UNUSED uint32_t ID_HEVC_PARSER = NVC7B0_SET_APPLICATION_ID_ID_HEVC_PARSER; \
    UNUSED uint32_t ID_UCODE_TEST = NVC7B0_SET_APPLICATION_ID_ID_UCODE_TEST; \
    UNUSED uint32_t ID_HWDRM_PR_DECRYPTAUDIO = NVC7B0_SET_APPLICATION_ID_ID_HWDRM_PR_DECRYPTAUDIO; \
    UNUSED uint32_t ID_HWDRM_PR_DECRYPTAUDIOMULTIPLE = NVC7B0_SET_APPLICATION_ID_ID_HWDRM_PR_DECRYPTAUDIOMULTIPLE; \
    UNUSED uint32_t ID_HWDRM_PR_PREPROCESSENCRYPTEDDATA = NVC7B0_SET_APPLICATION_ID_ID_HWDRM_PR_PREPROCESSENCRYPTEDDATA; \
    UNUSED uint32_t ID_VP9_WITH_PARSER = NVC7B0_SET_APPLICATION_ID_ID_VP9_WITH_PARSER; \
    UNUSED uint32_t ID_AVD = NVC7B0_SET_APPLICATION_ID_ID_AVD; \
    UNUSED uint32_t ID_HW_DRM_PR4_DECRYPTCONTENTMULTIPLE = NVC7B0_SET_APPLICATION_ID_ID_HW_DRM_PR4_DECRYPTCONTENTMULTIPLE; \
    UNUSED uint32_t ID_DHKE = NVC7B0_SET_APPLICATION_ID_ID_DHKE; \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_APPLICATION_ID(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_APPLICATION_ID, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_WATCHDOG_TIMER {
    uint32_t timer;
};

static inline void
__NVC7B0_SET_WATCHDOG_TIMER(uint32_t *val_out, struct nv_nvc7b0_SET_WATCHDOG_TIMER st)
{
    uint32_t val = 0;
    
    val |= st.timer;
    *val_out = val;
}

#define V_NVC7B0_SET_WATCHDOG_TIMER(val, args...) { \
    struct nv_nvc7b0_SET_WATCHDOG_TIMER __data = { .timer = (args) }; \
    __NVC7B0_SET_WATCHDOG_TIMER(&val, __data); \
}

#define VA_NVC7B0_SET_WATCHDOG_TIMER V_NVC7B0_SET_WATCHDOG_TIMER

#define P_NVC7B0_SET_WATCHDOG_TIMER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_WATCHDOG_TIMER(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_WATCHDOG_TIMER, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SEMAPHORE_A {
    uint32_t upper;
};

static inline void
__NVC7B0_SEMAPHORE_A(uint32_t *val_out, struct nv_nvc7b0_SEMAPHORE_A st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 8));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVC7B0_SEMAPHORE_A(val, args...) { \
    struct nv_nvc7b0_SEMAPHORE_A __data = { .upper = (args) }; \
    __NVC7B0_SEMAPHORE_A(&val, __data); \
}

#define VA_NVC7B0_SEMAPHORE_A V_NVC7B0_SEMAPHORE_A

#define P_NVC7B0_SEMAPHORE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SEMAPHORE_A(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SEMAPHORE_A, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SEMAPHORE_B {
    uint32_t lower;
};

static inline void
__NVC7B0_SEMAPHORE_B(uint32_t *val_out, struct nv_nvc7b0_SEMAPHORE_B st)
{
    uint32_t val = 0;
    
    val |= st.lower;
    *val_out = val;
}

#define V_NVC7B0_SEMAPHORE_B(val, args...) { \
    struct nv_nvc7b0_SEMAPHORE_B __data = { .lower = (args) }; \
    __NVC7B0_SEMAPHORE_B(&val, __data); \
}

#define VA_NVC7B0_SEMAPHORE_B V_NVC7B0_SEMAPHORE_B

#define P_NVC7B0_SEMAPHORE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SEMAPHORE_B(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SEMAPHORE_B, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SEMAPHORE_C {
    uint32_t payload;
};

static inline void
__NVC7B0_SEMAPHORE_C(uint32_t *val_out, struct nv_nvc7b0_SEMAPHORE_C st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVC7B0_SEMAPHORE_C(val, args...) { \
    struct nv_nvc7b0_SEMAPHORE_C __data = { .payload = (args) }; \
    __NVC7B0_SEMAPHORE_C(&val, __data); \
}

#define VA_NVC7B0_SEMAPHORE_C V_NVC7B0_SEMAPHORE_C

#define P_NVC7B0_SEMAPHORE_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SEMAPHORE_C(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SEMAPHORE_C, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_CTX_SAVE_AREA {
    uint32_t offset;
};

static inline void
__NVC7B0_CTX_SAVE_AREA(uint32_t *val_out, struct nv_nvc7b0_CTX_SAVE_AREA st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_CTX_SAVE_AREA(val, args...) { \
    struct nv_nvc7b0_CTX_SAVE_AREA __data = { .offset = (args) }; \
    __NVC7B0_CTX_SAVE_AREA(&val, __data); \
}

#define VA_NVC7B0_CTX_SAVE_AREA V_NVC7B0_CTX_SAVE_AREA

#define P_NVC7B0_CTX_SAVE_AREA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_CTX_SAVE_AREA(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_CTX_SAVE_AREA, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_CTX_SWITCH {
    uint32_t op;
    uint32_t ctxid_valid;
    uint32_t reserved0;
    uint32_t ctx_id;
    uint32_t reserved1;
};

static inline void
__NVC7B0_CTX_SWITCH(uint32_t *val_out, struct nv_nvc7b0_CTX_SWITCH st)
{
    uint32_t val = 0;
    
    assert(st.op < (1ULL << 2));
    val |= st.op << 0;
    
    assert(st.ctxid_valid < (1ULL << 1));
    val |= st.ctxid_valid << 2;
    
    assert(st.reserved0 < (1ULL << 5));
    val |= st.reserved0 << 3;
    
    assert(st.ctx_id < (1ULL << 16));
    val |= st.ctx_id << 8;
    
    assert(st.reserved1 < (1ULL << 8));
    val |= st.reserved1 << 24;
    *val_out = val;
}

#define V_NVC7B0_CTX_SWITCH(val, args...) { \
    UNUSED uint32_t OP_CTX_UPDATE = NVC7B0_CTX_SWITCH_OP_CTX_UPDATE; \
    UNUSED uint32_t OP_CTX_SAVE = NVC7B0_CTX_SWITCH_OP_CTX_SAVE; \
    UNUSED uint32_t OP_CTX_RESTORE = NVC7B0_CTX_SWITCH_OP_CTX_RESTORE; \
    UNUSED uint32_t OP_CTX_FORCERESTORE = NVC7B0_CTX_SWITCH_OP_CTX_FORCERESTORE; \
    UNUSED uint32_t CTXID_VALID_FALSE = NVC7B0_CTX_SWITCH_CTXID_VALID_FALSE; \
    UNUSED uint32_t CTXID_VALID_TRUE = NVC7B0_CTX_SWITCH_CTXID_VALID_TRUE; \
    struct nv_nvc7b0_CTX_SWITCH __data = args; \
    __NVC7B0_CTX_SWITCH(&val, __data); \
}

#define VA_NVC7B0_CTX_SWITCH V_NVC7B0_CTX_SWITCH

#define P_NVC7B0_CTX_SWITCH(push, args...) do { \
    UNUSED uint32_t OP_CTX_UPDATE = NVC7B0_CTX_SWITCH_OP_CTX_UPDATE; \
    UNUSED uint32_t OP_CTX_SAVE = NVC7B0_CTX_SWITCH_OP_CTX_SAVE; \
    UNUSED uint32_t OP_CTX_RESTORE = NVC7B0_CTX_SWITCH_OP_CTX_RESTORE; \
    UNUSED uint32_t OP_CTX_FORCERESTORE = NVC7B0_CTX_SWITCH_OP_CTX_FORCERESTORE; \
    UNUSED uint32_t CTXID_VALID_FALSE = NVC7B0_CTX_SWITCH_CTXID_VALID_FALSE; \
    UNUSED uint32_t CTXID_VALID_TRUE = NVC7B0_CTX_SWITCH_CTXID_VALID_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC7B0_CTX_SWITCH(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_CTX_SWITCH, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_SEMAPHORE_PAYLOAD_LOWER {
    uint32_t payload_lower;
};

static inline void
__NVC7B0_SET_SEMAPHORE_PAYLOAD_LOWER(uint32_t *val_out, struct nv_nvc7b0_SET_SEMAPHORE_PAYLOAD_LOWER st)
{
    uint32_t val = 0;
    
    val |= st.payload_lower;
    *val_out = val;
}

#define V_NVC7B0_SET_SEMAPHORE_PAYLOAD_LOWER(val, args...) { \
    struct nv_nvc7b0_SET_SEMAPHORE_PAYLOAD_LOWER __data = { .payload_lower = (args) }; \
    __NVC7B0_SET_SEMAPHORE_PAYLOAD_LOWER(&val, __data); \
}

#define VA_NVC7B0_SET_SEMAPHORE_PAYLOAD_LOWER V_NVC7B0_SET_SEMAPHORE_PAYLOAD_LOWER

#define P_NVC7B0_SET_SEMAPHORE_PAYLOAD_LOWER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_SEMAPHORE_PAYLOAD_LOWER(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_SEMAPHORE_PAYLOAD_LOWER, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_SEMAPHORE_PAYLOAD_UPPER {
    uint32_t payload_upper;
};

static inline void
__NVC7B0_SET_SEMAPHORE_PAYLOAD_UPPER(uint32_t *val_out, struct nv_nvc7b0_SET_SEMAPHORE_PAYLOAD_UPPER st)
{
    uint32_t val = 0;
    
    val |= st.payload_upper;
    *val_out = val;
}

#define V_NVC7B0_SET_SEMAPHORE_PAYLOAD_UPPER(val, args...) { \
    struct nv_nvc7b0_SET_SEMAPHORE_PAYLOAD_UPPER __data = { .payload_upper = (args) }; \
    __NVC7B0_SET_SEMAPHORE_PAYLOAD_UPPER(&val, __data); \
}

#define VA_NVC7B0_SET_SEMAPHORE_PAYLOAD_UPPER V_NVC7B0_SET_SEMAPHORE_PAYLOAD_UPPER

#define P_NVC7B0_SET_SEMAPHORE_PAYLOAD_UPPER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_SEMAPHORE_PAYLOAD_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_SEMAPHORE_PAYLOAD_UPPER, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A {
    uint32_t lower;
};

static inline void
__NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A(uint32_t *val_out, struct nv_nvc7b0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A st)
{
    uint32_t val = 0;
    
    val |= st.lower;
    *val_out = val;
}

#define V_NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A(val, args...) { \
    struct nv_nvc7b0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A __data = { .lower = (args) }; \
    __NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A(&val, __data); \
}

#define VA_NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A V_NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A

#define P_NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B {
    uint32_t upper;
};

static inline void
__NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B(uint32_t *val_out, struct nv_nvc7b0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B st)
{
    uint32_t val = 0;
    
    val |= st.upper;
    *val_out = val;
}

#define V_NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B(val, args...) { \
    struct nv_nvc7b0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B __data = { .upper = (args) }; \
    __NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B(&val, __data); \
}

#define VA_NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B V_NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B

#define P_NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_EXECUTE {
    uint32_t notify;
    uint32_t notify_on;
    uint32_t predication;
    uint32_t predication_op;
    uint32_t awaken;
};

static inline void
__NVC7B0_EXECUTE(uint32_t *val_out, struct nv_nvc7b0_EXECUTE st)
{
    uint32_t val = 0;
    
    assert(st.notify < (1ULL << 1));
    val |= st.notify << 0;
    
    assert(st.notify_on < (1ULL << 1));
    val |= st.notify_on << 1;
    
    assert(st.predication < (1ULL << 1));
    val |= st.predication << 2;
    
    assert(st.predication_op < (1ULL << 1));
    val |= st.predication_op << 3;
    
    assert(st.awaken < (1ULL << 1));
    val |= st.awaken << 8;
    *val_out = val;
}

#define V_NVC7B0_EXECUTE(val, args...) { \
    UNUSED uint32_t NOTIFY_DISABLE = NVC7B0_EXECUTE_NOTIFY_DISABLE; \
    UNUSED uint32_t NOTIFY_ENABLE = NVC7B0_EXECUTE_NOTIFY_ENABLE; \
    UNUSED uint32_t NOTIFY_ON_END = NVC7B0_EXECUTE_NOTIFY_ON_END; \
    UNUSED uint32_t NOTIFY_ON_BEGIN = NVC7B0_EXECUTE_NOTIFY_ON_BEGIN; \
    UNUSED uint32_t PREDICATION_DISABLE = NVC7B0_EXECUTE_PREDICATION_DISABLE; \
    UNUSED uint32_t PREDICATION_ENABLE = NVC7B0_EXECUTE_PREDICATION_ENABLE; \
    UNUSED uint32_t PREDICATION_OP_EQUAL_ZERO = NVC7B0_EXECUTE_PREDICATION_OP_EQUAL_ZERO; \
    UNUSED uint32_t PREDICATION_OP_NOT_EQUAL_ZERO = NVC7B0_EXECUTE_PREDICATION_OP_NOT_EQUAL_ZERO; \
    UNUSED uint32_t AWAKEN_DISABLE = NVC7B0_EXECUTE_AWAKEN_DISABLE; \
    UNUSED uint32_t AWAKEN_ENABLE = NVC7B0_EXECUTE_AWAKEN_ENABLE; \
    struct nv_nvc7b0_EXECUTE __data = args; \
    __NVC7B0_EXECUTE(&val, __data); \
}

#define VA_NVC7B0_EXECUTE V_NVC7B0_EXECUTE

#define P_NVC7B0_EXECUTE(push, args...) do { \
    UNUSED uint32_t NOTIFY_DISABLE = NVC7B0_EXECUTE_NOTIFY_DISABLE; \
    UNUSED uint32_t NOTIFY_ENABLE = NVC7B0_EXECUTE_NOTIFY_ENABLE; \
    UNUSED uint32_t NOTIFY_ON_END = NVC7B0_EXECUTE_NOTIFY_ON_END; \
    UNUSED uint32_t NOTIFY_ON_BEGIN = NVC7B0_EXECUTE_NOTIFY_ON_BEGIN; \
    UNUSED uint32_t PREDICATION_DISABLE = NVC7B0_EXECUTE_PREDICATION_DISABLE; \
    UNUSED uint32_t PREDICATION_ENABLE = NVC7B0_EXECUTE_PREDICATION_ENABLE; \
    UNUSED uint32_t PREDICATION_OP_EQUAL_ZERO = NVC7B0_EXECUTE_PREDICATION_OP_EQUAL_ZERO; \
    UNUSED uint32_t PREDICATION_OP_NOT_EQUAL_ZERO = NVC7B0_EXECUTE_PREDICATION_OP_NOT_EQUAL_ZERO; \
    UNUSED uint32_t AWAKEN_DISABLE = NVC7B0_EXECUTE_AWAKEN_DISABLE; \
    UNUSED uint32_t AWAKEN_ENABLE = NVC7B0_EXECUTE_AWAKEN_ENABLE; \
    uint32_t nvk_p_ret; \
    V_NVC7B0_EXECUTE(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_EXECUTE, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SEMAPHORE_D {
    uint32_t structure_size;
    uint32_t awaken_enable;
    uint32_t operation;
    uint32_t flush_disable;
    uint32_t trap_type;
    uint32_t payload_size;
};

static inline void
__NVC7B0_SEMAPHORE_D(uint32_t *val_out, struct nv_nvc7b0_SEMAPHORE_D st)
{
    uint32_t val = 0;
    
    assert(st.structure_size < (1ULL << 2));
    val |= st.structure_size << 0;
    
    assert(st.awaken_enable < (1ULL << 1));
    val |= st.awaken_enable << 8;
    
    assert(st.operation < (1ULL << 2));
    val |= st.operation << 16;
    
    assert(st.flush_disable < (1ULL << 1));
    val |= st.flush_disable << 21;
    
    assert(st.trap_type < (1ULL << 2));
    val |= st.trap_type << 22;
    
    assert(st.payload_size < (1ULL << 1));
    val |= st.payload_size << 24;
    *val_out = val;
}

#define V_NVC7B0_SEMAPHORE_D(val, args...) { \
    UNUSED uint32_t STRUCTURE_SIZE_ONE = NVC7B0_SEMAPHORE_D_STRUCTURE_SIZE_ONE; \
    UNUSED uint32_t STRUCTURE_SIZE_FOUR = NVC7B0_SEMAPHORE_D_STRUCTURE_SIZE_FOUR; \
    UNUSED uint32_t STRUCTURE_SIZE_TWO = NVC7B0_SEMAPHORE_D_STRUCTURE_SIZE_TWO; \
    UNUSED uint32_t AWAKEN_ENABLE_FALSE = NVC7B0_SEMAPHORE_D_AWAKEN_ENABLE_FALSE; \
    UNUSED uint32_t AWAKEN_ENABLE_TRUE = NVC7B0_SEMAPHORE_D_AWAKEN_ENABLE_TRUE; \
    UNUSED uint32_t OPERATION_RELEASE = NVC7B0_SEMAPHORE_D_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_RESERVED_0 = NVC7B0_SEMAPHORE_D_OPERATION_RESERVED_0; \
    UNUSED uint32_t OPERATION_RESERVED_1 = NVC7B0_SEMAPHORE_D_OPERATION_RESERVED_1; \
    UNUSED uint32_t OPERATION_TRAP = NVC7B0_SEMAPHORE_D_OPERATION_TRAP; \
    UNUSED uint32_t FLUSH_DISABLE_FALSE = NVC7B0_SEMAPHORE_D_FLUSH_DISABLE_FALSE; \
    UNUSED uint32_t FLUSH_DISABLE_TRUE = NVC7B0_SEMAPHORE_D_FLUSH_DISABLE_TRUE; \
    UNUSED uint32_t TRAP_TYPE_UNCONDITIONAL = NVC7B0_SEMAPHORE_D_TRAP_TYPE_UNCONDITIONAL; \
    UNUSED uint32_t TRAP_TYPE_CONDITIONAL = NVC7B0_SEMAPHORE_D_TRAP_TYPE_CONDITIONAL; \
    UNUSED uint32_t TRAP_TYPE_CONDITIONAL_EXT = NVC7B0_SEMAPHORE_D_TRAP_TYPE_CONDITIONAL_EXT; \
    UNUSED uint32_t PAYLOAD_SIZE_32BIT = NVC7B0_SEMAPHORE_D_PAYLOAD_SIZE_32BIT; \
    UNUSED uint32_t PAYLOAD_SIZE_64BIT = NVC7B0_SEMAPHORE_D_PAYLOAD_SIZE_64BIT; \
    struct nv_nvc7b0_SEMAPHORE_D __data = args; \
    __NVC7B0_SEMAPHORE_D(&val, __data); \
}

#define VA_NVC7B0_SEMAPHORE_D V_NVC7B0_SEMAPHORE_D

#define P_NVC7B0_SEMAPHORE_D(push, args...) do { \
    UNUSED uint32_t STRUCTURE_SIZE_ONE = NVC7B0_SEMAPHORE_D_STRUCTURE_SIZE_ONE; \
    UNUSED uint32_t STRUCTURE_SIZE_FOUR = NVC7B0_SEMAPHORE_D_STRUCTURE_SIZE_FOUR; \
    UNUSED uint32_t STRUCTURE_SIZE_TWO = NVC7B0_SEMAPHORE_D_STRUCTURE_SIZE_TWO; \
    UNUSED uint32_t AWAKEN_ENABLE_FALSE = NVC7B0_SEMAPHORE_D_AWAKEN_ENABLE_FALSE; \
    UNUSED uint32_t AWAKEN_ENABLE_TRUE = NVC7B0_SEMAPHORE_D_AWAKEN_ENABLE_TRUE; \
    UNUSED uint32_t OPERATION_RELEASE = NVC7B0_SEMAPHORE_D_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_RESERVED_0 = NVC7B0_SEMAPHORE_D_OPERATION_RESERVED_0; \
    UNUSED uint32_t OPERATION_RESERVED_1 = NVC7B0_SEMAPHORE_D_OPERATION_RESERVED_1; \
    UNUSED uint32_t OPERATION_TRAP = NVC7B0_SEMAPHORE_D_OPERATION_TRAP; \
    UNUSED uint32_t FLUSH_DISABLE_FALSE = NVC7B0_SEMAPHORE_D_FLUSH_DISABLE_FALSE; \
    UNUSED uint32_t FLUSH_DISABLE_TRUE = NVC7B0_SEMAPHORE_D_FLUSH_DISABLE_TRUE; \
    UNUSED uint32_t TRAP_TYPE_UNCONDITIONAL = NVC7B0_SEMAPHORE_D_TRAP_TYPE_UNCONDITIONAL; \
    UNUSED uint32_t TRAP_TYPE_CONDITIONAL = NVC7B0_SEMAPHORE_D_TRAP_TYPE_CONDITIONAL; \
    UNUSED uint32_t TRAP_TYPE_CONDITIONAL_EXT = NVC7B0_SEMAPHORE_D_TRAP_TYPE_CONDITIONAL_EXT; \
    UNUSED uint32_t PAYLOAD_SIZE_32BIT = NVC7B0_SEMAPHORE_D_PAYLOAD_SIZE_32BIT; \
    UNUSED uint32_t PAYLOAD_SIZE_64BIT = NVC7B0_SEMAPHORE_D_PAYLOAD_SIZE_64BIT; \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SEMAPHORE_D(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SEMAPHORE_D, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PREDICATION_OFFSET_UPPER {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PREDICATION_OFFSET_UPPER(uint32_t *val_out, struct nv_nvc7b0_SET_PREDICATION_OFFSET_UPPER st)
{
    uint32_t val = 0;
    
    assert(st.offset < (1ULL << 8));
    val |= st.offset << 0;
    *val_out = val;
}

#define V_NVC7B0_SET_PREDICATION_OFFSET_UPPER(val, args...) { \
    struct nv_nvc7b0_SET_PREDICATION_OFFSET_UPPER __data = { .offset = (args) }; \
    __NVC7B0_SET_PREDICATION_OFFSET_UPPER(&val, __data); \
}

#define VA_NVC7B0_SET_PREDICATION_OFFSET_UPPER V_NVC7B0_SET_PREDICATION_OFFSET_UPPER

#define P_NVC7B0_SET_PREDICATION_OFFSET_UPPER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PREDICATION_OFFSET_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PREDICATION_OFFSET_UPPER, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PREDICATION_OFFSET_LOWER {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PREDICATION_OFFSET_LOWER(uint32_t *val_out, struct nv_nvc7b0_SET_PREDICATION_OFFSET_LOWER st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PREDICATION_OFFSET_LOWER(val, args...) { \
    struct nv_nvc7b0_SET_PREDICATION_OFFSET_LOWER __data = { .offset = (args) }; \
    __NVC7B0_SET_PREDICATION_OFFSET_LOWER(&val, __data); \
}

#define VA_NVC7B0_SET_PREDICATION_OFFSET_LOWER V_NVC7B0_SET_PREDICATION_OFFSET_LOWER

#define P_NVC7B0_SET_PREDICATION_OFFSET_LOWER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PREDICATION_OFFSET_LOWER(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PREDICATION_OFFSET_LOWER, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_AUXILIARY_DATA_BUFFER {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_AUXILIARY_DATA_BUFFER(uint32_t *val_out, struct nv_nvc7b0_SET_AUXILIARY_DATA_BUFFER st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_AUXILIARY_DATA_BUFFER(val, args...) { \
    struct nv_nvc7b0_SET_AUXILIARY_DATA_BUFFER __data = { .offset = (args) }; \
    __NVC7B0_SET_AUXILIARY_DATA_BUFFER(&val, __data); \
}

#define VA_NVC7B0_SET_AUXILIARY_DATA_BUFFER V_NVC7B0_SET_AUXILIARY_DATA_BUFFER

#define P_NVC7B0_SET_AUXILIARY_DATA_BUFFER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_AUXILIARY_DATA_BUFFER(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_AUXILIARY_DATA_BUFFER, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_CONTROL_PARAMS {
    uint32_t codec_type;
    uint32_t gptimer_on;
    uint32_t ret_error;
    uint32_t err_conceal_on;
    uint32_t error_frm_idx;
    uint32_t mbtimer_on;
    uint32_t ec_intra_frame_using_pslc;
    uint32_t ignore_some_fields_crc_check;
    uint32_t event_trace_logging_on;
    uint32_t all_intra_frame;
    uint32_t testrun_env;
    uint32_t reserved;
    uint32_t enable_encrypt;
    uint32_t encryptmode;
};

static inline void
__NVC7B0_SET_CONTROL_PARAMS(uint32_t *val_out, struct nv_nvc7b0_SET_CONTROL_PARAMS st)
{
    uint32_t val = 0;
    
    assert(st.codec_type < (1ULL << 4));
    val |= st.codec_type << 0;
    
    assert(st.gptimer_on < (1ULL << 1));
    val |= st.gptimer_on << 4;
    
    assert(st.ret_error < (1ULL << 1));
    val |= st.ret_error << 5;
    
    assert(st.err_conceal_on < (1ULL << 1));
    val |= st.err_conceal_on << 6;
    
    assert(st.error_frm_idx < (1ULL << 6));
    val |= st.error_frm_idx << 7;
    
    assert(st.mbtimer_on < (1ULL << 1));
    val |= st.mbtimer_on << 13;
    
    assert(st.ec_intra_frame_using_pslc < (1ULL << 1));
    val |= st.ec_intra_frame_using_pslc << 14;
    
    assert(st.ignore_some_fields_crc_check < (1ULL << 1));
    val |= st.ignore_some_fields_crc_check << 15;
    
    assert(st.event_trace_logging_on < (1ULL << 1));
    val |= st.event_trace_logging_on << 16;
    
    assert(st.all_intra_frame < (1ULL << 1));
    val |= st.all_intra_frame << 17;
    
    assert(st.testrun_env < (1ULL << 2));
    val |= st.testrun_env << 18;
    
    assert(st.reserved < (1ULL << 7));
    val |= st.reserved << 20;
    
    assert(st.enable_encrypt < (1ULL << 1));
    val |= st.enable_encrypt << 27;
    
    assert(st.encryptmode < (1ULL << 4));
    val |= st.encryptmode << 28;
    *val_out = val;
}

#define V_NVC7B0_SET_CONTROL_PARAMS(val, args...) { \
    UNUSED uint32_t CODEC_TYPE_MPEG1 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG1; \
    UNUSED uint32_t CODEC_TYPE_MPEG2 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG2; \
    UNUSED uint32_t CODEC_TYPE_VC1 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_VC1; \
    UNUSED uint32_t CODEC_TYPE_H264 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_H264; \
    UNUSED uint32_t CODEC_TYPE_MPEG4 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG4; \
    UNUSED uint32_t CODEC_TYPE_DIVX3 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_DIVX3; \
    UNUSED uint32_t CODEC_TYPE_VP8 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP8; \
    UNUSED uint32_t CODEC_TYPE_HEVC = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_HEVC; \
    UNUSED uint32_t CODEC_TYPE_VP9 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP9; \
    UNUSED uint32_t CODEC_TYPE_AV1 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_AV1; \
    UNUSED uint32_t TESTRUN_ENV_TRACE3D_RUN = NVC7B0_SET_CONTROL_PARAMS_TESTRUN_ENV_TRACE3D_RUN; \
    UNUSED uint32_t TESTRUN_ENV_PROD_RUN = NVC7B0_SET_CONTROL_PARAMS_TESTRUN_ENV_PROD_RUN; \
    struct nv_nvc7b0_SET_CONTROL_PARAMS __data = args; \
    __NVC7B0_SET_CONTROL_PARAMS(&val, __data); \
}

#define VA_NVC7B0_SET_CONTROL_PARAMS V_NVC7B0_SET_CONTROL_PARAMS

#define P_NVC7B0_SET_CONTROL_PARAMS(push, args...) do { \
    UNUSED uint32_t CODEC_TYPE_MPEG1 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG1; \
    UNUSED uint32_t CODEC_TYPE_MPEG2 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG2; \
    UNUSED uint32_t CODEC_TYPE_VC1 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_VC1; \
    UNUSED uint32_t CODEC_TYPE_H264 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_H264; \
    UNUSED uint32_t CODEC_TYPE_MPEG4 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG4; \
    UNUSED uint32_t CODEC_TYPE_DIVX3 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_DIVX3; \
    UNUSED uint32_t CODEC_TYPE_VP8 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP8; \
    UNUSED uint32_t CODEC_TYPE_HEVC = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_HEVC; \
    UNUSED uint32_t CODEC_TYPE_VP9 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP9; \
    UNUSED uint32_t CODEC_TYPE_AV1 = NVC7B0_SET_CONTROL_PARAMS_CODEC_TYPE_AV1; \
    UNUSED uint32_t TESTRUN_ENV_TRACE3D_RUN = NVC7B0_SET_CONTROL_PARAMS_TESTRUN_ENV_TRACE3D_RUN; \
    UNUSED uint32_t TESTRUN_ENV_PROD_RUN = NVC7B0_SET_CONTROL_PARAMS_TESTRUN_ENV_PROD_RUN; \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_CONTROL_PARAMS(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_CONTROL_PARAMS, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_DRV_PIC_SETUP_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_DRV_PIC_SETUP_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_DRV_PIC_SETUP_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_DRV_PIC_SETUP_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_DRV_PIC_SETUP_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_DRV_PIC_SETUP_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_DRV_PIC_SETUP_OFFSET V_NVC7B0_SET_DRV_PIC_SETUP_OFFSET

#define P_NVC7B0_SET_DRV_PIC_SETUP_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_DRV_PIC_SETUP_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_DRV_PIC_SETUP_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_IN_BUF_BASE_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_IN_BUF_BASE_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_IN_BUF_BASE_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_IN_BUF_BASE_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_IN_BUF_BASE_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_IN_BUF_BASE_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_IN_BUF_BASE_OFFSET V_NVC7B0_SET_IN_BUF_BASE_OFFSET

#define P_NVC7B0_SET_IN_BUF_BASE_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_IN_BUF_BASE_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_IN_BUF_BASE_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_INDEX {
    uint32_t index;
};

static inline void
__NVC7B0_SET_PICTURE_INDEX(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_INDEX st)
{
    uint32_t val = 0;
    
    val |= st.index;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_INDEX(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_INDEX __data = { .index = (args) }; \
    __NVC7B0_SET_PICTURE_INDEX(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_INDEX V_NVC7B0_SET_PICTURE_INDEX

#define P_NVC7B0_SET_PICTURE_INDEX(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_INDEX(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_INDEX, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_SLICE_OFFSETS_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_SLICE_OFFSETS_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_SLICE_OFFSETS_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_SLICE_OFFSETS_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_SLICE_OFFSETS_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_SLICE_OFFSETS_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_SLICE_OFFSETS_BUF_OFFSET V_NVC7B0_SET_SLICE_OFFSETS_BUF_OFFSET

#define P_NVC7B0_SET_SLICE_OFFSETS_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_SLICE_OFFSETS_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_SLICE_OFFSETS_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_COLOC_DATA_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_COLOC_DATA_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_COLOC_DATA_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_COLOC_DATA_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_COLOC_DATA_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_COLOC_DATA_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_COLOC_DATA_OFFSET V_NVC7B0_SET_COLOC_DATA_OFFSET

#define P_NVC7B0_SET_COLOC_DATA_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_COLOC_DATA_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_COLOC_DATA_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_HISTORY_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_HISTORY_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_HISTORY_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_HISTORY_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_HISTORY_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_HISTORY_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_HISTORY_OFFSET V_NVC7B0_SET_HISTORY_OFFSET

#define P_NVC7B0_SET_HISTORY_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_HISTORY_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_HISTORY_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_DISPLAY_BUF_SIZE {
    uint32_t size;
};

static inline void
__NVC7B0_SET_DISPLAY_BUF_SIZE(uint32_t *val_out, struct nv_nvc7b0_SET_DISPLAY_BUF_SIZE st)
{
    uint32_t val = 0;
    
    val |= st.size;
    *val_out = val;
}

#define V_NVC7B0_SET_DISPLAY_BUF_SIZE(val, args...) { \
    struct nv_nvc7b0_SET_DISPLAY_BUF_SIZE __data = { .size = (args) }; \
    __NVC7B0_SET_DISPLAY_BUF_SIZE(&val, __data); \
}

#define VA_NVC7B0_SET_DISPLAY_BUF_SIZE V_NVC7B0_SET_DISPLAY_BUF_SIZE

#define P_NVC7B0_SET_DISPLAY_BUF_SIZE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_DISPLAY_BUF_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_DISPLAY_BUF_SIZE, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_HISTOGRAM_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_HISTOGRAM_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_HISTOGRAM_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_HISTOGRAM_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_HISTOGRAM_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_HISTOGRAM_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_HISTOGRAM_OFFSET V_NVC7B0_SET_HISTOGRAM_OFFSET

#define P_NVC7B0_SET_HISTOGRAM_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_HISTOGRAM_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_HISTOGRAM_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_NVDEC_STATUS_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_NVDEC_STATUS_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_NVDEC_STATUS_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_NVDEC_STATUS_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_NVDEC_STATUS_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_NVDEC_STATUS_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_NVDEC_STATUS_OFFSET V_NVC7B0_SET_NVDEC_STATUS_OFFSET

#define P_NVC7B0_SET_NVDEC_STATUS_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_NVDEC_STATUS_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_NVDEC_STATUS_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_DISPLAY_BUF_LUMA_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_DISPLAY_BUF_LUMA_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_DISPLAY_BUF_LUMA_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_DISPLAY_BUF_LUMA_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_DISPLAY_BUF_LUMA_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_DISPLAY_BUF_LUMA_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_DISPLAY_BUF_LUMA_OFFSET V_NVC7B0_SET_DISPLAY_BUF_LUMA_OFFSET

#define P_NVC7B0_SET_DISPLAY_BUF_LUMA_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_DISPLAY_BUF_LUMA_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_DISPLAY_BUF_LUMA_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_DISPLAY_BUF_CHROMA_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_DISPLAY_BUF_CHROMA_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_DISPLAY_BUF_CHROMA_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_DISPLAY_BUF_CHROMA_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_DISPLAY_BUF_CHROMA_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_DISPLAY_BUF_CHROMA_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_DISPLAY_BUF_CHROMA_OFFSET V_NVC7B0_SET_DISPLAY_BUF_CHROMA_OFFSET

#define P_NVC7B0_SET_DISPLAY_BUF_CHROMA_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_DISPLAY_BUF_CHROMA_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_DISPLAY_BUF_CHROMA_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET0 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET0(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET0 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET0(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET0 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET0(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET0 V_NVC7B0_SET_PICTURE_LUMA_OFFSET0

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET0(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET0, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET1 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET1(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET1 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET1(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET1 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET1(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET1 V_NVC7B0_SET_PICTURE_LUMA_OFFSET1

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET1(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET1(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET1, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET2 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET2(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET2 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET2(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET2 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET2(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET2 V_NVC7B0_SET_PICTURE_LUMA_OFFSET2

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET2(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET2(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET2, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET3 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET3(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET3 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET3(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET3 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET3(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET3 V_NVC7B0_SET_PICTURE_LUMA_OFFSET3

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET3(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET3(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET3, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET4 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET4(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET4 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET4(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET4 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET4(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET4 V_NVC7B0_SET_PICTURE_LUMA_OFFSET4

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET4(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET4(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET4, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET5 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET5(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET5 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET5(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET5 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET5(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET5 V_NVC7B0_SET_PICTURE_LUMA_OFFSET5

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET5(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET5(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET5, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET6 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET6(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET6 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET6(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET6 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET6(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET6 V_NVC7B0_SET_PICTURE_LUMA_OFFSET6

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET6(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET6(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET6, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET7 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET7(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET7 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET7(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET7 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET7(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET7 V_NVC7B0_SET_PICTURE_LUMA_OFFSET7

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET7(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET7(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET7, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET8 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET8(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET8 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET8(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET8 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET8(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET8 V_NVC7B0_SET_PICTURE_LUMA_OFFSET8

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET8(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET8(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET8, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET9 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET9(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET9 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET9(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET9 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET9(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET9 V_NVC7B0_SET_PICTURE_LUMA_OFFSET9

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET9(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET9(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET9, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET10 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET10(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET10 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET10(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET10 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET10(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET10 V_NVC7B0_SET_PICTURE_LUMA_OFFSET10

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET10(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET10, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET11 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET11(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET11 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET11(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET11 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET11(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET11 V_NVC7B0_SET_PICTURE_LUMA_OFFSET11

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET11(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET11, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET12 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET12(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET12 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET12(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET12 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET12(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET12 V_NVC7B0_SET_PICTURE_LUMA_OFFSET12

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET12(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET12(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET12, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET13 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET13(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET13 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET13(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET13 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET13(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET13 V_NVC7B0_SET_PICTURE_LUMA_OFFSET13

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET13(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET13(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET13, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET14 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET14(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET14 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET14(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET14 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET14(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET14 V_NVC7B0_SET_PICTURE_LUMA_OFFSET14

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET14(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET14(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET14, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET15 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET15(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET15 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET15(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET15 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET15(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET15 V_NVC7B0_SET_PICTURE_LUMA_OFFSET15

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET15(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET15(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET15, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET16 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_LUMA_OFFSET16(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET16 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_LUMA_OFFSET16(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_LUMA_OFFSET16 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_LUMA_OFFSET16(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_LUMA_OFFSET16 V_NVC7B0_SET_PICTURE_LUMA_OFFSET16

#define P_NVC7B0_SET_PICTURE_LUMA_OFFSET16(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_LUMA_OFFSET16(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_LUMA_OFFSET16, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET0 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET0(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET0 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET0(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET0 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET0(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET0 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET0

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET0(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET0, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET1 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET1(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET1 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET1(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET1 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET1(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET1 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET1

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET1(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET1(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET1, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET2 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET2(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET2 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET2(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET2 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET2(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET2 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET2

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET2(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET2(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET2, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET3 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET3(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET3 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET3(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET3 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET3(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET3 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET3

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET3(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET3(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET3, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET4 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET4(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET4 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET4(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET4 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET4(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET4 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET4

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET4(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET4(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET4, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET5 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET5(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET5 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET5(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET5 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET5(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET5 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET5

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET5(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET5(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET5, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET6 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET6(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET6 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET6(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET6 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET6(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET6 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET6

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET6(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET6(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET6, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET7 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET7(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET7 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET7(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET7 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET7(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET7 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET7

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET7(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET7(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET7, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET8 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET8(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET8 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET8(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET8 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET8(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET8 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET8

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET8(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET8(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET8, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET9 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET9(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET9 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET9(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET9 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET9(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET9 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET9

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET9(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET9(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET9, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET10 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET10(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET10 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET10(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET10 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET10(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET10 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET10

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET10(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET10, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET11 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET11(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET11 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET11(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET11 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET11(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET11 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET11

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET11(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET11, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET12 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET12(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET12 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET12(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET12 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET12(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET12 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET12

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET12(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET12(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET12, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET13 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET13(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET13 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET13(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET13 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET13(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET13 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET13

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET13(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET13(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET13, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET14 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET14(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET14 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET14(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET14 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET14(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET14 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET14

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET14(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET14(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET14, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET15 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET15(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET15 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET15(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET15 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET15(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET15 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET15

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET15(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET15(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET15, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET16 {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PICTURE_CHROMA_OFFSET16(uint32_t *val_out, struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET16 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PICTURE_CHROMA_OFFSET16(val, args...) { \
    struct nv_nvc7b0_SET_PICTURE_CHROMA_OFFSET16 __data = { .offset = (args) }; \
    __NVC7B0_SET_PICTURE_CHROMA_OFFSET16(&val, __data); \
}

#define VA_NVC7B0_SET_PICTURE_CHROMA_OFFSET16 V_NVC7B0_SET_PICTURE_CHROMA_OFFSET16

#define P_NVC7B0_SET_PICTURE_CHROMA_OFFSET16(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PICTURE_CHROMA_OFFSET16(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PICTURE_CHROMA_OFFSET16, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PIC_SCRATCH_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PIC_SCRATCH_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_PIC_SCRATCH_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PIC_SCRATCH_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_PIC_SCRATCH_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_PIC_SCRATCH_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_PIC_SCRATCH_BUF_OFFSET V_NVC7B0_SET_PIC_SCRATCH_BUF_OFFSET

#define P_NVC7B0_SET_PIC_SCRATCH_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PIC_SCRATCH_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PIC_SCRATCH_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_EXTERNAL_MVBUFFER_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_EXTERNAL_MVBUFFER_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_EXTERNAL_MVBUFFER_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_EXTERNAL_MVBUFFER_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_EXTERNAL_MVBUFFER_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_EXTERNAL_MVBUFFER_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_EXTERNAL_MVBUFFER_OFFSET V_NVC7B0_SET_EXTERNAL_MVBUFFER_OFFSET

#define P_NVC7B0_SET_EXTERNAL_MVBUFFER_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_EXTERNAL_MVBUFFER_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_EXTERNAL_MVBUFFER_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_SUB_SAMPLE_MAP_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_SUB_SAMPLE_MAP_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_SUB_SAMPLE_MAP_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_SUB_SAMPLE_MAP_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_SUB_SAMPLE_MAP_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_SUB_SAMPLE_MAP_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_SUB_SAMPLE_MAP_OFFSET V_NVC7B0_SET_SUB_SAMPLE_MAP_OFFSET

#define P_NVC7B0_SET_SUB_SAMPLE_MAP_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_SUB_SAMPLE_MAP_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_SUB_SAMPLE_MAP_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_SUB_SAMPLE_MAP_IV_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_SUB_SAMPLE_MAP_IV_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_SUB_SAMPLE_MAP_IV_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_SUB_SAMPLE_MAP_IV_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_SUB_SAMPLE_MAP_IV_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_SUB_SAMPLE_MAP_IV_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_SUB_SAMPLE_MAP_IV_OFFSET V_NVC7B0_SET_SUB_SAMPLE_MAP_IV_OFFSET

#define P_NVC7B0_SET_SUB_SAMPLE_MAP_IV_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_SUB_SAMPLE_MAP_IV_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_SUB_SAMPLE_MAP_IV_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_INTRA_TOP_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_INTRA_TOP_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_INTRA_TOP_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_INTRA_TOP_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_INTRA_TOP_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_INTRA_TOP_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_INTRA_TOP_BUF_OFFSET V_NVC7B0_SET_INTRA_TOP_BUF_OFFSET

#define P_NVC7B0_SET_INTRA_TOP_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_INTRA_TOP_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_INTRA_TOP_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_TILE_SIZE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_TILE_SIZE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_TILE_SIZE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_TILE_SIZE_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_TILE_SIZE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_TILE_SIZE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_TILE_SIZE_BUF_OFFSET V_NVC7B0_SET_TILE_SIZE_BUF_OFFSET

#define P_NVC7B0_SET_TILE_SIZE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_TILE_SIZE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_TILE_SIZE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_FILTER_BUFFER_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_FILTER_BUFFER_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_FILTER_BUFFER_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_FILTER_BUFFER_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_FILTER_BUFFER_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_FILTER_BUFFER_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_FILTER_BUFFER_OFFSET V_NVC7B0_SET_FILTER_BUFFER_OFFSET

#define P_NVC7B0_SET_FILTER_BUFFER_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_FILTER_BUFFER_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_FILTER_BUFFER_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_CRC_STRUCT_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_CRC_STRUCT_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_CRC_STRUCT_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_CRC_STRUCT_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_CRC_STRUCT_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_CRC_STRUCT_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_CRC_STRUCT_OFFSET V_NVC7B0_SET_CRC_STRUCT_OFFSET

#define P_NVC7B0_SET_CRC_STRUCT_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_CRC_STRUCT_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_CRC_STRUCT_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET V_NVC7B0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET

#define P_NVC7B0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_H264_SET_MBHIST_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_H264_SET_MBHIST_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_H264_SET_MBHIST_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_H264_SET_MBHIST_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_H264_SET_MBHIST_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_H264_SET_MBHIST_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_H264_SET_MBHIST_BUF_OFFSET V_NVC7B0_H264_SET_MBHIST_BUF_OFFSET

#define P_NVC7B0_H264_SET_MBHIST_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_H264_SET_MBHIST_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_H264_SET_MBHIST_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_VP8_SET_PROB_DATA_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_VP8_SET_PROB_DATA_OFFSET(uint32_t *val_out, struct nv_nvc7b0_VP8_SET_PROB_DATA_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_VP8_SET_PROB_DATA_OFFSET(val, args...) { \
    struct nv_nvc7b0_VP8_SET_PROB_DATA_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_VP8_SET_PROB_DATA_OFFSET(&val, __data); \
}

#define VA_NVC7B0_VP8_SET_PROB_DATA_OFFSET V_NVC7B0_VP8_SET_PROB_DATA_OFFSET

#define P_NVC7B0_VP8_SET_PROB_DATA_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_VP8_SET_PROB_DATA_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_VP8_SET_PROB_DATA_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET(uint32_t *val_out, struct nv_nvc7b0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET(val, args...) { \
    struct nv_nvc7b0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET(&val, __data); \
}

#define VA_NVC7B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET V_NVC7B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET

#define P_NVC7B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_HEVC_SET_SCALING_LIST_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_HEVC_SET_SCALING_LIST_OFFSET(uint32_t *val_out, struct nv_nvc7b0_HEVC_SET_SCALING_LIST_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_HEVC_SET_SCALING_LIST_OFFSET(val, args...) { \
    struct nv_nvc7b0_HEVC_SET_SCALING_LIST_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_HEVC_SET_SCALING_LIST_OFFSET(&val, __data); \
}

#define VA_NVC7B0_HEVC_SET_SCALING_LIST_OFFSET V_NVC7B0_HEVC_SET_SCALING_LIST_OFFSET

#define P_NVC7B0_HEVC_SET_SCALING_LIST_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_HEVC_SET_SCALING_LIST_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_HEVC_SET_SCALING_LIST_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_HEVC_SET_TILE_SIZES_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_HEVC_SET_TILE_SIZES_OFFSET(uint32_t *val_out, struct nv_nvc7b0_HEVC_SET_TILE_SIZES_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_HEVC_SET_TILE_SIZES_OFFSET(val, args...) { \
    struct nv_nvc7b0_HEVC_SET_TILE_SIZES_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_HEVC_SET_TILE_SIZES_OFFSET(&val, __data); \
}

#define VA_NVC7B0_HEVC_SET_TILE_SIZES_OFFSET V_NVC7B0_HEVC_SET_TILE_SIZES_OFFSET

#define P_NVC7B0_HEVC_SET_TILE_SIZES_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_HEVC_SET_TILE_SIZES_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_HEVC_SET_TILE_SIZES_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_HEVC_SET_FILTER_BUFFER_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_HEVC_SET_FILTER_BUFFER_OFFSET(uint32_t *val_out, struct nv_nvc7b0_HEVC_SET_FILTER_BUFFER_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_HEVC_SET_FILTER_BUFFER_OFFSET(val, args...) { \
    struct nv_nvc7b0_HEVC_SET_FILTER_BUFFER_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_HEVC_SET_FILTER_BUFFER_OFFSET(&val, __data); \
}

#define VA_NVC7B0_HEVC_SET_FILTER_BUFFER_OFFSET V_NVC7B0_HEVC_SET_FILTER_BUFFER_OFFSET

#define P_NVC7B0_HEVC_SET_FILTER_BUFFER_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_HEVC_SET_FILTER_BUFFER_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_HEVC_SET_FILTER_BUFFER_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_HEVC_SET_SAO_BUFFER_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_HEVC_SET_SAO_BUFFER_OFFSET(uint32_t *val_out, struct nv_nvc7b0_HEVC_SET_SAO_BUFFER_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_HEVC_SET_SAO_BUFFER_OFFSET(val, args...) { \
    struct nv_nvc7b0_HEVC_SET_SAO_BUFFER_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_HEVC_SET_SAO_BUFFER_OFFSET(&val, __data); \
}

#define VA_NVC7B0_HEVC_SET_SAO_BUFFER_OFFSET V_NVC7B0_HEVC_SET_SAO_BUFFER_OFFSET

#define P_NVC7B0_HEVC_SET_SAO_BUFFER_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_HEVC_SET_SAO_BUFFER_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_HEVC_SET_SAO_BUFFER_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET(uint32_t *val_out, struct nv_nvc7b0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET(val, args...) { \
    struct nv_nvc7b0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET(&val, __data); \
}

#define VA_NVC7B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET V_NVC7B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET

#define P_NVC7B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_HEVC_SET_SLICE_GROUP_INDEX {
    uint32_t offset;
};

static inline void
__NVC7B0_HEVC_SET_SLICE_GROUP_INDEX(uint32_t *val_out, struct nv_nvc7b0_HEVC_SET_SLICE_GROUP_INDEX st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_HEVC_SET_SLICE_GROUP_INDEX(val, args...) { \
    struct nv_nvc7b0_HEVC_SET_SLICE_GROUP_INDEX __data = { .offset = (args) }; \
    __NVC7B0_HEVC_SET_SLICE_GROUP_INDEX(&val, __data); \
}

#define VA_NVC7B0_HEVC_SET_SLICE_GROUP_INDEX V_NVC7B0_HEVC_SET_SLICE_GROUP_INDEX

#define P_NVC7B0_HEVC_SET_SLICE_GROUP_INDEX(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_HEVC_SET_SLICE_GROUP_INDEX(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_HEVC_SET_SLICE_GROUP_INDEX, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_VP9_SET_PROB_TAB_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_VP9_SET_PROB_TAB_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_VP9_SET_PROB_TAB_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_VP9_SET_PROB_TAB_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_VP9_SET_PROB_TAB_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_VP9_SET_PROB_TAB_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_VP9_SET_PROB_TAB_BUF_OFFSET V_NVC7B0_VP9_SET_PROB_TAB_BUF_OFFSET

#define P_NVC7B0_VP9_SET_PROB_TAB_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_VP9_SET_PROB_TAB_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_VP9_SET_PROB_TAB_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_VP9_SET_CTX_COUNTER_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_VP9_SET_CTX_COUNTER_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_VP9_SET_CTX_COUNTER_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_VP9_SET_CTX_COUNTER_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_VP9_SET_CTX_COUNTER_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_VP9_SET_CTX_COUNTER_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_VP9_SET_CTX_COUNTER_BUF_OFFSET V_NVC7B0_VP9_SET_CTX_COUNTER_BUF_OFFSET

#define P_NVC7B0_VP9_SET_CTX_COUNTER_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_VP9_SET_CTX_COUNTER_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_VP9_SET_CTX_COUNTER_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_VP9_SET_SEGMENT_READ_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_VP9_SET_SEGMENT_READ_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_VP9_SET_SEGMENT_READ_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_VP9_SET_SEGMENT_READ_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_VP9_SET_SEGMENT_READ_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_VP9_SET_SEGMENT_READ_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_VP9_SET_SEGMENT_READ_BUF_OFFSET V_NVC7B0_VP9_SET_SEGMENT_READ_BUF_OFFSET

#define P_NVC7B0_VP9_SET_SEGMENT_READ_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_VP9_SET_SEGMENT_READ_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_VP9_SET_SEGMENT_READ_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET V_NVC7B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET

#define P_NVC7B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_VP9_SET_TILE_SIZE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_VP9_SET_TILE_SIZE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_VP9_SET_TILE_SIZE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_VP9_SET_TILE_SIZE_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_VP9_SET_TILE_SIZE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_VP9_SET_TILE_SIZE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_VP9_SET_TILE_SIZE_BUF_OFFSET V_NVC7B0_VP9_SET_TILE_SIZE_BUF_OFFSET

#define P_NVC7B0_VP9_SET_TILE_SIZE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_VP9_SET_TILE_SIZE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_VP9_SET_TILE_SIZE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_VP9_SET_COL_MVWRITE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_VP9_SET_COL_MVWRITE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_VP9_SET_COL_MVWRITE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_VP9_SET_COL_MVWRITE_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_VP9_SET_COL_MVWRITE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_VP9_SET_COL_MVWRITE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_VP9_SET_COL_MVWRITE_BUF_OFFSET V_NVC7B0_VP9_SET_COL_MVWRITE_BUF_OFFSET

#define P_NVC7B0_VP9_SET_COL_MVWRITE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_VP9_SET_COL_MVWRITE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_VP9_SET_COL_MVWRITE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_VP9_SET_COL_MVREAD_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_VP9_SET_COL_MVREAD_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_VP9_SET_COL_MVREAD_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_VP9_SET_COL_MVREAD_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_VP9_SET_COL_MVREAD_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_VP9_SET_COL_MVREAD_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_VP9_SET_COL_MVREAD_BUF_OFFSET V_NVC7B0_VP9_SET_COL_MVREAD_BUF_OFFSET

#define P_NVC7B0_VP9_SET_COL_MVREAD_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_VP9_SET_COL_MVREAD_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_VP9_SET_COL_MVREAD_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_VP9_SET_FILTER_BUFFER_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_VP9_SET_FILTER_BUFFER_OFFSET(uint32_t *val_out, struct nv_nvc7b0_VP9_SET_FILTER_BUFFER_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_VP9_SET_FILTER_BUFFER_OFFSET(val, args...) { \
    struct nv_nvc7b0_VP9_SET_FILTER_BUFFER_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_VP9_SET_FILTER_BUFFER_OFFSET(&val, __data); \
}

#define VA_NVC7B0_VP9_SET_FILTER_BUFFER_OFFSET V_NVC7B0_VP9_SET_FILTER_BUFFER_OFFSET

#define P_NVC7B0_VP9_SET_FILTER_BUFFER_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_VP9_SET_FILTER_BUFFER_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_VP9_SET_FILTER_BUFFER_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_VP9_PARSER_SET_PIC_SETUP_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_VP9_PARSER_SET_PIC_SETUP_OFFSET(uint32_t *val_out, struct nv_nvc7b0_VP9_PARSER_SET_PIC_SETUP_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_VP9_PARSER_SET_PIC_SETUP_OFFSET(val, args...) { \
    struct nv_nvc7b0_VP9_PARSER_SET_PIC_SETUP_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_VP9_PARSER_SET_PIC_SETUP_OFFSET(&val, __data); \
}

#define VA_NVC7B0_VP9_PARSER_SET_PIC_SETUP_OFFSET V_NVC7B0_VP9_PARSER_SET_PIC_SETUP_OFFSET

#define P_NVC7B0_VP9_PARSER_SET_PIC_SETUP_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_VP9_PARSER_SET_PIC_SETUP_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_VP9_PARSER_SET_PIC_SETUP_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET(uint32_t *val_out, struct nv_nvc7b0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET(val, args...) { \
    struct nv_nvc7b0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET(&val, __data); \
}

#define VA_NVC7B0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET V_NVC7B0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET

#define P_NVC7B0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET V_NVC7B0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET

#define P_NVC7B0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PASS1_SET_CLEAR_HEADER_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_PASS1_SET_CLEAR_HEADER_OFFSET(uint32_t *val_out, struct nv_nvc7b0_PASS1_SET_CLEAR_HEADER_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_PASS1_SET_CLEAR_HEADER_OFFSET(val, args...) { \
    struct nv_nvc7b0_PASS1_SET_CLEAR_HEADER_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_PASS1_SET_CLEAR_HEADER_OFFSET(&val, __data); \
}

#define VA_NVC7B0_PASS1_SET_CLEAR_HEADER_OFFSET V_NVC7B0_PASS1_SET_CLEAR_HEADER_OFFSET

#define P_NVC7B0_PASS1_SET_CLEAR_HEADER_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PASS1_SET_CLEAR_HEADER_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PASS1_SET_CLEAR_HEADER_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PASS1_SET_RE_ENCRYPT_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_PASS1_SET_RE_ENCRYPT_OFFSET(uint32_t *val_out, struct nv_nvc7b0_PASS1_SET_RE_ENCRYPT_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_PASS1_SET_RE_ENCRYPT_OFFSET(val, args...) { \
    struct nv_nvc7b0_PASS1_SET_RE_ENCRYPT_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_PASS1_SET_RE_ENCRYPT_OFFSET(&val, __data); \
}

#define VA_NVC7B0_PASS1_SET_RE_ENCRYPT_OFFSET V_NVC7B0_PASS1_SET_RE_ENCRYPT_OFFSET

#define P_NVC7B0_PASS1_SET_RE_ENCRYPT_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PASS1_SET_RE_ENCRYPT_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PASS1_SET_RE_ENCRYPT_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PASS1_SET_VP8_TOKEN_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_PASS1_SET_VP8_TOKEN_OFFSET(uint32_t *val_out, struct nv_nvc7b0_PASS1_SET_VP8_TOKEN_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_PASS1_SET_VP8_TOKEN_OFFSET(val, args...) { \
    struct nv_nvc7b0_PASS1_SET_VP8_TOKEN_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_PASS1_SET_VP8_TOKEN_OFFSET(&val, __data); \
}

#define VA_NVC7B0_PASS1_SET_VP8_TOKEN_OFFSET V_NVC7B0_PASS1_SET_VP8_TOKEN_OFFSET

#define P_NVC7B0_PASS1_SET_VP8_TOKEN_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PASS1_SET_VP8_TOKEN_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PASS1_SET_VP8_TOKEN_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PASS1_SET_INPUT_DATA_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_PASS1_SET_INPUT_DATA_OFFSET(uint32_t *val_out, struct nv_nvc7b0_PASS1_SET_INPUT_DATA_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_PASS1_SET_INPUT_DATA_OFFSET(val, args...) { \
    struct nv_nvc7b0_PASS1_SET_INPUT_DATA_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_PASS1_SET_INPUT_DATA_OFFSET(&val, __data); \
}

#define VA_NVC7B0_PASS1_SET_INPUT_DATA_OFFSET V_NVC7B0_PASS1_SET_INPUT_DATA_OFFSET

#define P_NVC7B0_PASS1_SET_INPUT_DATA_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PASS1_SET_INPUT_DATA_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PASS1_SET_INPUT_DATA_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET(uint32_t *val_out, struct nv_nvc7b0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET(val, args...) { \
    struct nv_nvc7b0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET(&val, __data); \
}

#define VA_NVC7B0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET V_NVC7B0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET

#define P_NVC7B0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_AV1_SET_PROB_TAB_READ_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_AV1_SET_PROB_TAB_READ_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_AV1_SET_PROB_TAB_READ_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_AV1_SET_PROB_TAB_READ_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_AV1_SET_PROB_TAB_READ_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_AV1_SET_PROB_TAB_READ_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_AV1_SET_PROB_TAB_READ_BUF_OFFSET V_NVC7B0_AV1_SET_PROB_TAB_READ_BUF_OFFSET

#define P_NVC7B0_AV1_SET_PROB_TAB_READ_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_AV1_SET_PROB_TAB_READ_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_AV1_SET_PROB_TAB_READ_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET V_NVC7B0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET

#define P_NVC7B0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_AV1_SET_SEGMENT_READ_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_AV1_SET_SEGMENT_READ_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_AV1_SET_SEGMENT_READ_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_AV1_SET_SEGMENT_READ_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_AV1_SET_SEGMENT_READ_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_AV1_SET_SEGMENT_READ_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_AV1_SET_SEGMENT_READ_BUF_OFFSET V_NVC7B0_AV1_SET_SEGMENT_READ_BUF_OFFSET

#define P_NVC7B0_AV1_SET_SEGMENT_READ_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_AV1_SET_SEGMENT_READ_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_AV1_SET_SEGMENT_READ_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET V_NVC7B0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET

#define P_NVC7B0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_AV1_SET_COL_MV0_READ_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_AV1_SET_COL_MV0_READ_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_AV1_SET_COL_MV0_READ_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_AV1_SET_COL_MV0_READ_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_AV1_SET_COL_MV0_READ_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_AV1_SET_COL_MV0_READ_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_AV1_SET_COL_MV0_READ_BUF_OFFSET V_NVC7B0_AV1_SET_COL_MV0_READ_BUF_OFFSET

#define P_NVC7B0_AV1_SET_COL_MV0_READ_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_AV1_SET_COL_MV0_READ_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_AV1_SET_COL_MV0_READ_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_AV1_SET_COL_MV1_READ_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_AV1_SET_COL_MV1_READ_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_AV1_SET_COL_MV1_READ_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_AV1_SET_COL_MV1_READ_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_AV1_SET_COL_MV1_READ_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_AV1_SET_COL_MV1_READ_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_AV1_SET_COL_MV1_READ_BUF_OFFSET V_NVC7B0_AV1_SET_COL_MV1_READ_BUF_OFFSET

#define P_NVC7B0_AV1_SET_COL_MV1_READ_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_AV1_SET_COL_MV1_READ_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_AV1_SET_COL_MV1_READ_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_AV1_SET_COL_MV2_READ_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_AV1_SET_COL_MV2_READ_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_AV1_SET_COL_MV2_READ_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_AV1_SET_COL_MV2_READ_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_AV1_SET_COL_MV2_READ_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_AV1_SET_COL_MV2_READ_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_AV1_SET_COL_MV2_READ_BUF_OFFSET V_NVC7B0_AV1_SET_COL_MV2_READ_BUF_OFFSET

#define P_NVC7B0_AV1_SET_COL_MV2_READ_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_AV1_SET_COL_MV2_READ_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_AV1_SET_COL_MV2_READ_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_AV1_SET_COL_MVWRITE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_AV1_SET_COL_MVWRITE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_AV1_SET_COL_MVWRITE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_AV1_SET_COL_MVWRITE_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_AV1_SET_COL_MVWRITE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_AV1_SET_COL_MVWRITE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_AV1_SET_COL_MVWRITE_BUF_OFFSET V_NVC7B0_AV1_SET_COL_MVWRITE_BUF_OFFSET

#define P_NVC7B0_AV1_SET_COL_MVWRITE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_AV1_SET_COL_MVWRITE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_AV1_SET_COL_MVWRITE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET V_NVC7B0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET

#define P_NVC7B0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_AV1_SET_FILM_GRAIN_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_AV1_SET_FILM_GRAIN_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_AV1_SET_FILM_GRAIN_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_AV1_SET_FILM_GRAIN_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_AV1_SET_FILM_GRAIN_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_AV1_SET_FILM_GRAIN_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_AV1_SET_FILM_GRAIN_BUF_OFFSET V_NVC7B0_AV1_SET_FILM_GRAIN_BUF_OFFSET

#define P_NVC7B0_AV1_SET_FILM_GRAIN_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_AV1_SET_FILM_GRAIN_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_AV1_SET_FILM_GRAIN_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET V_NVC7B0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET

#define P_NVC7B0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET V_NVC7B0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET

#define P_NVC7B0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_H264_SET_SCALING_LIST_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_H264_SET_SCALING_LIST_OFFSET(uint32_t *val_out, struct nv_nvc7b0_H264_SET_SCALING_LIST_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_H264_SET_SCALING_LIST_OFFSET(val, args...) { \
    struct nv_nvc7b0_H264_SET_SCALING_LIST_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_H264_SET_SCALING_LIST_OFFSET(&val, __data); \
}

#define VA_NVC7B0_H264_SET_SCALING_LIST_OFFSET V_NVC7B0_H264_SET_SCALING_LIST_OFFSET

#define P_NVC7B0_H264_SET_SCALING_LIST_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_H264_SET_SCALING_LIST_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_H264_SET_SCALING_LIST_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_H264_SET_VLDHIST_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_H264_SET_VLDHIST_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_H264_SET_VLDHIST_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_H264_SET_VLDHIST_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_H264_SET_VLDHIST_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_H264_SET_VLDHIST_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_H264_SET_VLDHIST_BUF_OFFSET V_NVC7B0_H264_SET_VLDHIST_BUF_OFFSET

#define P_NVC7B0_H264_SET_VLDHIST_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_H264_SET_VLDHIST_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_H264_SET_VLDHIST_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_H264_SET_EDOBOFFSET0 {
    uint32_t offset;
};

static inline void
__NVC7B0_H264_SET_EDOBOFFSET0(uint32_t *val_out, struct nv_nvc7b0_H264_SET_EDOBOFFSET0 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_H264_SET_EDOBOFFSET0(val, args...) { \
    struct nv_nvc7b0_H264_SET_EDOBOFFSET0 __data = { .offset = (args) }; \
    __NVC7B0_H264_SET_EDOBOFFSET0(&val, __data); \
}

#define VA_NVC7B0_H264_SET_EDOBOFFSET0 V_NVC7B0_H264_SET_EDOBOFFSET0

#define P_NVC7B0_H264_SET_EDOBOFFSET0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_H264_SET_EDOBOFFSET0(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_H264_SET_EDOBOFFSET0, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_H264_SET_EDOBOFFSET1 {
    uint32_t offset;
};

static inline void
__NVC7B0_H264_SET_EDOBOFFSET1(uint32_t *val_out, struct nv_nvc7b0_H264_SET_EDOBOFFSET1 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_H264_SET_EDOBOFFSET1(val, args...) { \
    struct nv_nvc7b0_H264_SET_EDOBOFFSET1 __data = { .offset = (args) }; \
    __NVC7B0_H264_SET_EDOBOFFSET1(&val, __data); \
}

#define VA_NVC7B0_H264_SET_EDOBOFFSET1 V_NVC7B0_H264_SET_EDOBOFFSET1

#define P_NVC7B0_H264_SET_EDOBOFFSET1(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_H264_SET_EDOBOFFSET1(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_H264_SET_EDOBOFFSET1, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_H264_SET_EDOBOFFSET2 {
    uint32_t offset;
};

static inline void
__NVC7B0_H264_SET_EDOBOFFSET2(uint32_t *val_out, struct nv_nvc7b0_H264_SET_EDOBOFFSET2 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_H264_SET_EDOBOFFSET2(val, args...) { \
    struct nv_nvc7b0_H264_SET_EDOBOFFSET2 __data = { .offset = (args) }; \
    __NVC7B0_H264_SET_EDOBOFFSET2(&val, __data); \
}

#define VA_NVC7B0_H264_SET_EDOBOFFSET2 V_NVC7B0_H264_SET_EDOBOFFSET2

#define P_NVC7B0_H264_SET_EDOBOFFSET2(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_H264_SET_EDOBOFFSET2(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_H264_SET_EDOBOFFSET2, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_H264_SET_EDOBOFFSET3 {
    uint32_t offset;
};

static inline void
__NVC7B0_H264_SET_EDOBOFFSET3(uint32_t *val_out, struct nv_nvc7b0_H264_SET_EDOBOFFSET3 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_H264_SET_EDOBOFFSET3(val, args...) { \
    struct nv_nvc7b0_H264_SET_EDOBOFFSET3 __data = { .offset = (args) }; \
    __NVC7B0_H264_SET_EDOBOFFSET3(&val, __data); \
}

#define VA_NVC7B0_H264_SET_EDOBOFFSET3 V_NVC7B0_H264_SET_EDOBOFFSET3

#define P_NVC7B0_H264_SET_EDOBOFFSET3(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_H264_SET_EDOBOFFSET3(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_H264_SET_EDOBOFFSET3, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_CTL_COUNT {
    uint32_t value;
};

static inline void
__NVC7B0_SET_CTL_COUNT(uint32_t *val_out, struct nv_nvc7b0_SET_CTL_COUNT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC7B0_SET_CTL_COUNT(val, args...) { \
    struct nv_nvc7b0_SET_CTL_COUNT __data = { .value = (args) }; \
    __NVC7B0_SET_CTL_COUNT(&val, __data); \
}

#define VA_NVC7B0_SET_CTL_COUNT V_NVC7B0_SET_CTL_COUNT

#define P_NVC7B0_SET_CTL_COUNT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_CTL_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_CTL_COUNT, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_UPPER_SRC {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_UPPER_SRC(uint32_t *val_out, struct nv_nvc7b0_SET_UPPER_SRC st)
{
    uint32_t val = 0;
    
    assert(st.offset < (1ULL << 8));
    val |= st.offset << 0;
    *val_out = val;
}

#define V_NVC7B0_SET_UPPER_SRC(val, args...) { \
    struct nv_nvc7b0_SET_UPPER_SRC __data = { .offset = (args) }; \
    __NVC7B0_SET_UPPER_SRC(&val, __data); \
}

#define VA_NVC7B0_SET_UPPER_SRC V_NVC7B0_SET_UPPER_SRC

#define P_NVC7B0_SET_UPPER_SRC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_UPPER_SRC(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_UPPER_SRC, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_LOWER_SRC {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_LOWER_SRC(uint32_t *val_out, struct nv_nvc7b0_SET_LOWER_SRC st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_LOWER_SRC(val, args...) { \
    struct nv_nvc7b0_SET_LOWER_SRC __data = { .offset = (args) }; \
    __NVC7B0_SET_LOWER_SRC(&val, __data); \
}

#define VA_NVC7B0_SET_LOWER_SRC V_NVC7B0_SET_LOWER_SRC

#define P_NVC7B0_SET_LOWER_SRC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_LOWER_SRC(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_LOWER_SRC, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_UPPER_DST {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_UPPER_DST(uint32_t *val_out, struct nv_nvc7b0_SET_UPPER_DST st)
{
    uint32_t val = 0;
    
    assert(st.offset < (1ULL << 8));
    val |= st.offset << 0;
    *val_out = val;
}

#define V_NVC7B0_SET_UPPER_DST(val, args...) { \
    struct nv_nvc7b0_SET_UPPER_DST __data = { .offset = (args) }; \
    __NVC7B0_SET_UPPER_DST(&val, __data); \
}

#define VA_NVC7B0_SET_UPPER_DST V_NVC7B0_SET_UPPER_DST

#define P_NVC7B0_SET_UPPER_DST(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_UPPER_DST(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_UPPER_DST, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_LOWER_DST {
    uint32_t offset;
};

static inline void
__NVC7B0_SET_LOWER_DST(uint32_t *val_out, struct nv_nvc7b0_SET_LOWER_DST st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_SET_LOWER_DST(val, args...) { \
    struct nv_nvc7b0_SET_LOWER_DST __data = { .offset = (args) }; \
    __NVC7B0_SET_LOWER_DST(&val, __data); \
}

#define VA_NVC7B0_SET_LOWER_DST V_NVC7B0_SET_LOWER_DST

#define P_NVC7B0_SET_LOWER_DST(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_LOWER_DST(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_LOWER_DST, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_SET_BLOCK_COUNT {
    uint32_t value;
};

static inline void
__NVC7B0_SET_BLOCK_COUNT(uint32_t *val_out, struct nv_nvc7b0_SET_BLOCK_COUNT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC7B0_SET_BLOCK_COUNT(val, args...) { \
    struct nv_nvc7b0_SET_BLOCK_COUNT __data = { .value = (args) }; \
    __NVC7B0_SET_BLOCK_COUNT(&val, __data); \
}

#define VA_NVC7B0_SET_BLOCK_COUNT V_NVC7B0_SET_BLOCK_COUNT

#define P_NVC7B0_SET_BLOCK_COUNT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_SET_BLOCK_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_SET_BLOCK_COUNT, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PR_SET_REQUEST_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_PR_SET_REQUEST_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_PR_SET_REQUEST_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_PR_SET_REQUEST_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_PR_SET_REQUEST_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_PR_SET_REQUEST_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_PR_SET_REQUEST_BUF_OFFSET V_NVC7B0_PR_SET_REQUEST_BUF_OFFSET

#define P_NVC7B0_PR_SET_REQUEST_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PR_SET_REQUEST_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PR_SET_REQUEST_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PR_SET_REQUEST_BUF_SIZE {
    uint32_t size;
};

static inline void
__NVC7B0_PR_SET_REQUEST_BUF_SIZE(uint32_t *val_out, struct nv_nvc7b0_PR_SET_REQUEST_BUF_SIZE st)
{
    uint32_t val = 0;
    
    val |= st.size;
    *val_out = val;
}

#define V_NVC7B0_PR_SET_REQUEST_BUF_SIZE(val, args...) { \
    struct nv_nvc7b0_PR_SET_REQUEST_BUF_SIZE __data = { .size = (args) }; \
    __NVC7B0_PR_SET_REQUEST_BUF_SIZE(&val, __data); \
}

#define VA_NVC7B0_PR_SET_REQUEST_BUF_SIZE V_NVC7B0_PR_SET_REQUEST_BUF_SIZE

#define P_NVC7B0_PR_SET_REQUEST_BUF_SIZE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PR_SET_REQUEST_BUF_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PR_SET_REQUEST_BUF_SIZE, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PR_SET_RESPONSE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_PR_SET_RESPONSE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_PR_SET_RESPONSE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_PR_SET_RESPONSE_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_PR_SET_RESPONSE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_PR_SET_RESPONSE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_PR_SET_RESPONSE_BUF_OFFSET V_NVC7B0_PR_SET_RESPONSE_BUF_OFFSET

#define P_NVC7B0_PR_SET_RESPONSE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PR_SET_RESPONSE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PR_SET_RESPONSE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PR_SET_RESPONSE_BUF_SIZE {
    uint32_t size;
};

static inline void
__NVC7B0_PR_SET_RESPONSE_BUF_SIZE(uint32_t *val_out, struct nv_nvc7b0_PR_SET_RESPONSE_BUF_SIZE st)
{
    uint32_t val = 0;
    
    val |= st.size;
    *val_out = val;
}

#define V_NVC7B0_PR_SET_RESPONSE_BUF_SIZE(val, args...) { \
    struct nv_nvc7b0_PR_SET_RESPONSE_BUF_SIZE __data = { .size = (args) }; \
    __NVC7B0_PR_SET_RESPONSE_BUF_SIZE(&val, __data); \
}

#define VA_NVC7B0_PR_SET_RESPONSE_BUF_SIZE V_NVC7B0_PR_SET_RESPONSE_BUF_SIZE

#define P_NVC7B0_PR_SET_RESPONSE_BUF_SIZE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PR_SET_RESPONSE_BUF_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PR_SET_RESPONSE_BUF_SIZE, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET V_NVC7B0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET

#define P_NVC7B0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET V_NVC7B0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET

#define P_NVC7B0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET V_NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET

#define P_NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PR_SET_LOCAL_DECRYPT_BUF_SIZE {
    uint32_t size;
};

static inline void
__NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_SIZE(uint32_t *val_out, struct nv_nvc7b0_PR_SET_LOCAL_DECRYPT_BUF_SIZE st)
{
    uint32_t val = 0;
    
    val |= st.size;
    *val_out = val;
}

#define V_NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_SIZE(val, args...) { \
    struct nv_nvc7b0_PR_SET_LOCAL_DECRYPT_BUF_SIZE __data = { .size = (args) }; \
    __NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_SIZE(&val, __data); \
}

#define VA_NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_SIZE V_NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_SIZE

#define P_NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_SIZE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PR_SET_LOCAL_DECRYPT_BUF_SIZE, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET V_NVC7B0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET

#define P_NVC7B0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET V_NVC7B0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET

#define P_NVC7B0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_DH_KE_SET_CHALLENGE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_DH_KE_SET_CHALLENGE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_DH_KE_SET_CHALLENGE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_DH_KE_SET_CHALLENGE_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_DH_KE_SET_CHALLENGE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_DH_KE_SET_CHALLENGE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_DH_KE_SET_CHALLENGE_BUF_OFFSET V_NVC7B0_DH_KE_SET_CHALLENGE_BUF_OFFSET

#define P_NVC7B0_DH_KE_SET_CHALLENGE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_DH_KE_SET_CHALLENGE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_DH_KE_SET_CHALLENGE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_DH_KE_SET_RESPONSE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC7B0_DH_KE_SET_RESPONSE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc7b0_DH_KE_SET_RESPONSE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC7B0_DH_KE_SET_RESPONSE_BUF_OFFSET(val, args...) { \
    struct nv_nvc7b0_DH_KE_SET_RESPONSE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC7B0_DH_KE_SET_RESPONSE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC7B0_DH_KE_SET_RESPONSE_BUF_OFFSET V_NVC7B0_DH_KE_SET_RESPONSE_BUF_OFFSET

#define P_NVC7B0_DH_KE_SET_RESPONSE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_DH_KE_SET_RESPONSE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_DH_KE_SET_RESPONSE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc7b0_PM_TRIGGER_END {
    uint32_t v;
};

static inline void
__NVC7B0_PM_TRIGGER_END(uint32_t *val_out, struct nv_nvc7b0_PM_TRIGGER_END st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC7B0_PM_TRIGGER_END(val, args...) { \
    struct nv_nvc7b0_PM_TRIGGER_END __data = { .v = (args) }; \
    __NVC7B0_PM_TRIGGER_END(&val, __data); \
}

#define VA_NVC7B0_PM_TRIGGER_END V_NVC7B0_PM_TRIGGER_END

#define P_NVC7B0_PM_TRIGGER_END(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC7B0_PM_TRIGGER_END(nvk_p_ret, args); \
    nv_push_val(push, NVC7B0_PM_TRIGGER_END, nvk_p_ret); \
} while(0)


const char *P_PARSE_NVC7B0_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC7B0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix) ATTRIBUTE_COLD;
