/*
 * Copyright (C) 2020 Collabora, Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Autogenerated file, do not edit */


#ifndef _BI_OPCODES_H_
#define _BI_OPCODES_H_

#include "bifrost.h"
 
enum bi_adj {
    BI_ADJ_NONE = 0,
    BI_ADJ_SMALL = 1,
    BI_ADJ_LOW = 2,
};

enum bi_atom_opc {
    BI_ATOM_OPC_AADD = 1,
    BI_ATOM_OPC_ASMIN = 2,
    BI_ATOM_OPC_ASMAX = 3,
    BI_ATOM_OPC_AUMIN = 4,
    BI_ATOM_OPC_AUMAX = 5,
    BI_ATOM_OPC_AAND = 6,
    BI_ATOM_OPC_AOR = 7,
    BI_ATOM_OPC_AXOR = 8,
    BI_ATOM_OPC_AINC = 9,
    BI_ATOM_OPC_ADEC = 10,
    BI_ATOM_OPC_AUMAX1 = 11,
    BI_ATOM_OPC_ASMAX1 = 12,
    BI_ATOM_OPC_AOR1 = 13,
    BI_ATOM_OPC_AADDU = 14,
    BI_ATOM_OPC_AADDS = 15,
    BI_ATOM_OPC_AXCHG = 16,
    BI_ATOM_OPC_ACMPXCHG = 17,
};

enum bi_clamp {
    BI_CLAMP_NONE = 0,
    BI_CLAMP_CLAMP_0_INF = 1,
    BI_CLAMP_CLAMP_M1_1 = 2,
    BI_CLAMP_CLAMP_0_1 = 3,
};

enum bi_cmpf {
    BI_CMPF_EQ = 0,
    BI_CMPF_GT = 1,
    BI_CMPF_GE = 2,
    BI_CMPF_NE = 3,
    BI_CMPF_LT = 4,
    BI_CMPF_LE = 5,
    BI_CMPF_GTLT = 7,
    BI_CMPF_TOTAL = 8,
};

enum bi_dimension {
    BI_DIMENSION_1D = 0,
    BI_DIMENSION_2D = 1,
    BI_DIMENSION_3D = 2,
    BI_DIMENSION_CUBE = 3,
};

enum bi_extend {
    BI_EXTEND_NONE = 0,
    BI_EXTEND_SEXT = 1,
    BI_EXTEND_ZEXT = 2,
};

enum bi_fetch_component {
    BI_FETCH_COMPONENT_GATHER4_R = 0,
    BI_FETCH_COMPONENT_GATHER4_G = 1,
    BI_FETCH_COMPONENT_GATHER4_B = 2,
    BI_FETCH_COMPONENT_GATHER4_A = 3,
};

enum bi_func {
    BI_FUNC_POW = 0,
    BI_FUNC_POWR = 1,
    BI_FUNC_POWN = 2,
    BI_FUNC_ROOTN = 3,
};

enum bi_function {
    BI_FUNCTION_NONE = 1,
    BI_FUNCTION_AND = 2,
    BI_FUNCTION_OR = 3,
};

enum bi_inactive_result {
    BI_INACTIVE_RESULT_ZERO = 0,
    BI_INACTIVE_RESULT_UMAX = 1,
    BI_INACTIVE_RESULT_I1 = 2,
    BI_INACTIVE_RESULT_V2I1 = 3,
    BI_INACTIVE_RESULT_SMIN = 4,
    BI_INACTIVE_RESULT_SMAX = 5,
    BI_INACTIVE_RESULT_V2SMIN = 6,
    BI_INACTIVE_RESULT_V2SMAX = 7,
    BI_INACTIVE_RESULT_V4SMIN = 8,
    BI_INACTIVE_RESULT_V4SMAX = 9,
    BI_INACTIVE_RESULT_F1 = 10,
    BI_INACTIVE_RESULT_V2F1 = 11,
    BI_INACTIVE_RESULT_INFN = 12,
    BI_INACTIVE_RESULT_INF = 13,
    BI_INACTIVE_RESULT_V2INFN = 14,
    BI_INACTIVE_RESULT_V2INF = 15,
};

enum bi_lane {
    BI_LANE_B0 = 0,
    BI_LANE_B1 = 1,
    BI_LANE_B2 = 2,
    BI_LANE_B3 = 3,
    BI_LANE_H0 = 4,
    BI_LANE_H1 = 5,
    BI_LANE_NONE = 6,
};

enum bi_lane_dest {
    BI_LANE_DEST_H0 = 0,
    BI_LANE_DEST_H1 = 1,
    BI_LANE_DEST_W0 = 2,
    BI_LANE_DEST_D0 = 3,
    BI_LANE_DEST_NONE = 4,
    BI_LANE_DEST_B0 = 5,
    BI_LANE_DEST_B1 = 6,
    BI_LANE_DEST_B2 = 7,
    BI_LANE_DEST_B3 = 8,
};

enum bi_lane_op {
    BI_LANE_OP_NONE = 0,
    BI_LANE_OP_XOR = 1,
    BI_LANE_OP_ACCUMULATE = 2,
    BI_LANE_OP_SHIFT = 3,
};

enum bi_lanes {
    BI_LANES_B00 = 0,
    BI_LANES_B11 = 1,
    BI_LANES_B22 = 2,
    BI_LANES_B33 = 3,
    BI_LANES_B01 = 4,
    BI_LANES_B23 = 5,
    BI_LANES_B02 = 6,
    BI_LANES_B0123 = 8,
    BI_LANES_B0000 = 9,
    BI_LANES_B1111 = 10,
    BI_LANES_B2222 = 11,
    BI_LANES_B3333 = 12,
    BI_LANES_NONE = 13,
    BI_LANES_H0 = 14,
    BI_LANES_H1 = 15,
    BI_LANES_B0 = 16,
    BI_LANES_B1 = 17,
    BI_LANES_B2 = 18,
    BI_LANES_B3 = 19,
    BI_LANES_H01 = 20,
    BI_LANES_H10 = 21,
    BI_LANES_H00 = 22,
    BI_LANES_H11 = 23,
    BI_LANES_B0101 = 24,
    BI_LANES_B2323 = 25,
};

enum bi_mode {
    BI_MODE_RED = 0,
    BI_MODE_BASE2 = 1,
    BI_MODE_NATURAL = 2,
};

enum bi_mux {
    BI_MUX_NEG = 0,
    BI_MUX_INT_ZERO = 1,
    BI_MUX_FP_ZERO = 2,
    BI_MUX_BIT = 3,
};

enum bi_precision {
    BI_PRECISION_NONE = 0,
    BI_PRECISION_HIGH = 1,
    BI_PRECISION_LOW = 2,
};

enum bi_register_format {
    BI_REGISTER_FORMAT_F16 = 0,
    BI_REGISTER_FORMAT_F32 = 1,
    BI_REGISTER_FORMAT_S32 = 2,
    BI_REGISTER_FORMAT_U32 = 3,
    BI_REGISTER_FORMAT_S16 = 4,
    BI_REGISTER_FORMAT_U16 = 5,
    BI_REGISTER_FORMAT_F64 = 6,
    BI_REGISTER_FORMAT_I64 = 7,
    BI_REGISTER_FORMAT_AUTO = 8,
};

enum bi_replicate {
    BI_REPLICATE_B0123 = 0,
    BI_REPLICATE_B0000 = 2,
    BI_REPLICATE_B1111 = 3,
    BI_REPLICATE_B2222 = 4,
    BI_REPLICATE_B3333 = 5,
};

enum bi_result_type {
    BI_RESULT_TYPE_I1 = 0,
    BI_RESULT_TYPE_F1 = 1,
    BI_RESULT_TYPE_M1 = 2,
};

enum bi_round {
    BI_ROUND_NONE = 0,
    BI_ROUND_RTP = 1,
    BI_ROUND_RTN = 2,
    BI_ROUND_RTZ = 3,
    BI_ROUND_RTNA = 4,
    BI_ROUND_RTO = 6,
    BI_ROUND_INF = 7,
    BI_ROUND_INF0 = 8,
};

enum bi_sample {
    BI_SAMPLE_CENTER = 0,
    BI_SAMPLE_CENTROID = 1,
    BI_SAMPLE_SAMPLE = 2,
    BI_SAMPLE_EXPLICIT = 3,
    BI_SAMPLE_NONE = 4,
};

enum bi_seg {
    BI_SEG_NONE = 0,
    BI_SEG_WLS = 1,
    BI_SEG_STREAM = 3,
    BI_SEG_UBO = 4,
    BI_SEG_TL = 5,
    BI_SEG_POS = 6,
    BI_SEG_VARY = 7,
};

enum bi_sem {
    BI_SEM_NAN_SUPPRESS = 0,
    BI_SEM_NAN_PROPAGATE = 1,
    BI_SEM_C = 2,
    BI_SEM_INVERSE_C = 3,
};

enum bi_source {
    BI_SOURCE_SYSTEM_TIMESTAMP = 1,
    BI_SOURCE_CYCLE_COUNTER = 2,
};

enum bi_source_format {
    BI_SOURCE_FORMAT_FLAT32 = 0,
    BI_SOURCE_FORMAT_FLAT16 = 1,
    BI_SOURCE_FORMAT_F32 = 2,
    BI_SOURCE_FORMAT_F16 = 3,
};

enum bi_special {
    BI_SPECIAL_NONE = 0,
    BI_SPECIAL_N = 1,
    BI_SPECIAL_LEFT = 2,
    BI_SPECIAL_SCALE16 = 3,
};

enum bi_stack_mode {
    BI_STACK_MODE_RETURN = 0,
    BI_STACK_MODE_CALL = 1,
    BI_STACK_MODE_NONE = 2,
    BI_STACK_MODE_REPLACE = 3,
};

enum bi_subgroup {
    BI_SUBGROUP_SUBGROUP2 = 0,
    BI_SUBGROUP_SUBGROUP4 = 1,
    BI_SUBGROUP_SUBGROUP8 = 2,
    BI_SUBGROUP_SUBGROUP16 = 3,
};

enum bi_swz {
    BI_SWZ_H00 = 0,
    BI_SWZ_H10 = 1,
    BI_SWZ_H01 = 2,
    BI_SWZ_H11 = 3,
    BI_SWZ_B0000 = 5,
    BI_SWZ_B1111 = 6,
    BI_SWZ_B2222 = 7,
    BI_SWZ_B3333 = 8,
    BI_SWZ_B0011 = 9,
    BI_SWZ_B2233 = 10,
    BI_SWZ_B1032 = 11,
    BI_SWZ_B3210 = 12,
    BI_SWZ_B00 = 13,
    BI_SWZ_B10 = 14,
    BI_SWZ_B20 = 15,
    BI_SWZ_B30 = 16,
    BI_SWZ_B01 = 17,
    BI_SWZ_B11 = 18,
    BI_SWZ_B21 = 19,
    BI_SWZ_B31 = 20,
    BI_SWZ_B02 = 21,
    BI_SWZ_B12 = 22,
    BI_SWZ_B22 = 23,
    BI_SWZ_B32 = 24,
    BI_SWZ_B03 = 25,
    BI_SWZ_B13 = 26,
    BI_SWZ_B23 = 27,
    BI_SWZ_B33 = 28,
};

enum bi_table {
    BI_TABLE_NONE = 0,
    BI_TABLE_ATTRIBUTE_2 = 1,
    BI_TABLE_ATTRIBUTE_1 = 2,
    BI_TABLE_FLAT = 3,
};

enum bi_update {
    BI_UPDATE_STORE = 0,
    BI_UPDATE_RETRIEVE = 1,
    BI_UPDATE_CONDITIONAL = 2,
    BI_UPDATE_CLOBBER = 3,
};

enum bi_va_lod_mode {
    BI_VA_LOD_MODE_ZERO_LOD = 0,
    BI_VA_LOD_MODE_COMPUTED_LOD = 1,
    BI_VA_LOD_MODE_EXPLICIT = 2,
    BI_VA_LOD_MODE_COMPUTED_BIAS = 3,
    BI_VA_LOD_MODE_GRDESC = 4,
};

enum bi_varying_name {
    BI_VARYING_NAME_POINT = 0,
    BI_VARYING_NAME_FRAG_W = 2,
    BI_VARYING_NAME_FRAG_Z = 3,
};

enum bi_vecsize {
    BI_VECSIZE_NONE = 0,
    BI_VECSIZE_V2 = 1,
    BI_VECSIZE_V3 = 2,
    BI_VECSIZE_V4 = 3,
};

enum bi_widen {
    BI_WIDEN_NONE = 1,
    BI_WIDEN_H0 = 2,
    BI_WIDEN_H1 = 3,
    BI_WIDEN_B0 = 4,
    BI_WIDEN_B1 = 5,
    BI_WIDEN_B2 = 6,
    BI_WIDEN_B3 = 7,
};

enum bi_write_mask {
    BI_WRITE_MASK_NONE = 0,
    BI_WRITE_MASK_R = 1,
    BI_WRITE_MASK_G = 2,
    BI_WRITE_MASK_RG = 3,
    BI_WRITE_MASK_B = 4,
    BI_WRITE_MASK_RB = 5,
    BI_WRITE_MASK_GB = 6,
    BI_WRITE_MASK_RGB = 7,
    BI_WRITE_MASK_A = 8,
    BI_WRITE_MASK_RA = 9,
    BI_WRITE_MASK_GA = 10,
    BI_WRITE_MASK_RGA = 11,
    BI_WRITE_MASK_BA = 12,
    BI_WRITE_MASK_RBA = 13,
    BI_WRITE_MASK_GBA = 14,
    BI_WRITE_MASK_RGBA = 15,
};

enum bi_opcode {
    BI_OPCODE_ACMPSTORE_I32,
    BI_OPCODE_ACMPSTORE_I64,
    BI_OPCODE_ACMPXCHG_I32,
    BI_OPCODE_ACMPXCHG_I64,
    BI_OPCODE_ARSHIFT_I32,
    BI_OPCODE_ARSHIFT_V2I16,
    BI_OPCODE_ARSHIFT_V4I8,
    BI_OPCODE_ARSHIFT_DOUBLE_I32,
    BI_OPCODE_ATEST,
    BI_OPCODE_ATOM_I32,
    BI_OPCODE_ATOM_I64,
    BI_OPCODE_ATOM1_RETURN_I32,
    BI_OPCODE_ATOM1_RETURN_I64,
    BI_OPCODE_ATOM_C_I32,
    BI_OPCODE_ATOM_C_I64,
    BI_OPCODE_ATOM_C1_I32,
    BI_OPCODE_ATOM_C1_I64,
    BI_OPCODE_ATOM_C1_RETURN_I32,
    BI_OPCODE_ATOM_C1_RETURN_I64,
    BI_OPCODE_ATOM_CX,
    BI_OPCODE_ATOM_C_RETURN_I32,
    BI_OPCODE_ATOM_C_RETURN_I64,
    BI_OPCODE_ATOM_POST_I32,
    BI_OPCODE_ATOM_POST_I64,
    BI_OPCODE_ATOM_PRE_I64,
    BI_OPCODE_ATOM_RETURN_I32,
    BI_OPCODE_ATOM_RETURN_I64,
    BI_OPCODE_AXCHG_I32,
    BI_OPCODE_AXCHG_I64,
    BI_OPCODE_BARRIER,
    BI_OPCODE_BITREV_I32,
    BI_OPCODE_BLEND,
    BI_OPCODE_BRANCH_F16,
    BI_OPCODE_BRANCH_F32,
    BI_OPCODE_BRANCH_I16,
    BI_OPCODE_BRANCH_I32,
    BI_OPCODE_BRANCH_S16,
    BI_OPCODE_BRANCH_S32,
    BI_OPCODE_BRANCH_U16,
    BI_OPCODE_BRANCH_U32,
    BI_OPCODE_BRANCHC_I16,
    BI_OPCODE_BRANCHC_I32,
    BI_OPCODE_BRANCHZ_F16,
    BI_OPCODE_BRANCHZ_F32,
    BI_OPCODE_BRANCHZ_I16,
    BI_OPCODE_BRANCHZ_I32,
    BI_OPCODE_BRANCHZ_S16,
    BI_OPCODE_BRANCHZ_S32,
    BI_OPCODE_BRANCHZ_U16,
    BI_OPCODE_BRANCHZ_U32,
    BI_OPCODE_BRANCHZI,
    BI_OPCODE_BRANCH_DIVERG,
    BI_OPCODE_BRANCH_LOWBITS_F32,
    BI_OPCODE_BRANCH_NO_DIVERG,
    BI_OPCODE_CLPER_I32,
    BI_OPCODE_CLPER_OLD_I32,
    BI_OPCODE_CLZ_U32,
    BI_OPCODE_CLZ_V2U16,
    BI_OPCODE_CLZ_V4U8,
    BI_OPCODE_COLLECT_I32,
    BI_OPCODE_CSEL_F32,
    BI_OPCODE_CSEL_I32,
    BI_OPCODE_CSEL_S32,
    BI_OPCODE_CSEL_U32,
    BI_OPCODE_CSEL_V2F16,
    BI_OPCODE_CSEL_V2I16,
    BI_OPCODE_CSEL_V2S16,
    BI_OPCODE_CSEL_V2U16,
    BI_OPCODE_CUBEFACE,
    BI_OPCODE_CUBEFACE1,
    BI_OPCODE_CUBEFACE2,
    BI_OPCODE_CUBEFACE2_V9,
    BI_OPCODE_CUBE_SSEL,
    BI_OPCODE_CUBE_TSEL,
    BI_OPCODE_DISCARD_B32,
    BI_OPCODE_DISCARD_F32,
    BI_OPCODE_DTSEL_IMM,
    BI_OPCODE_F16_TO_F32,
    BI_OPCODE_F16_TO_S32,
    BI_OPCODE_F16_TO_U32,
    BI_OPCODE_F32_TO_S32,
    BI_OPCODE_F32_TO_U32,
    BI_OPCODE_FABSNEG_F32,
    BI_OPCODE_FABSNEG_V2F16,
    BI_OPCODE_FADD_F32,
    BI_OPCODE_FADD_V2F16,
    BI_OPCODE_FADD_IMM_F32,
    BI_OPCODE_FADD_IMM_V2F16,
    BI_OPCODE_FADD_LSCALE_F32,
    BI_OPCODE_FADD_RSCALE_F32,
    BI_OPCODE_FCLAMP_F32,
    BI_OPCODE_FCLAMP_V2F16,
    BI_OPCODE_FCMP_F32,
    BI_OPCODE_FCMP_V2F16,
    BI_OPCODE_FCMP_AND_F32,
    BI_OPCODE_FCMP_AND_V2F16,
    BI_OPCODE_FCMP_OR_F32,
    BI_OPCODE_FCMP_OR_V2F16,
    BI_OPCODE_FCOS_TABLE_U6,
    BI_OPCODE_FEXP_F32,
    BI_OPCODE_FEXP_TABLE_U4,
    BI_OPCODE_FLOGD_F32,
    BI_OPCODE_FLOG_TABLE_F32,
    BI_OPCODE_FLSHIFT_DOUBLE_I32,
    BI_OPCODE_FLUSH_F32,
    BI_OPCODE_FLUSH_V2F16,
    BI_OPCODE_FMA_F32,
    BI_OPCODE_FMA_V2F16,
    BI_OPCODE_FMAX_F32,
    BI_OPCODE_FMAX_V2F16,
    BI_OPCODE_FMA_RSCALE_F32,
    BI_OPCODE_FMA_RSCALE_V2F16,
    BI_OPCODE_FMIN_F32,
    BI_OPCODE_FMIN_V2F16,
    BI_OPCODE_FMUL_CSLICE,
    BI_OPCODE_FMUL_SLICE_F32,
    BI_OPCODE_FPCLASS_F16,
    BI_OPCODE_FPCLASS_F32,
    BI_OPCODE_FPOW_SC_APPLY,
    BI_OPCODE_FPOW_SC_DET_F16,
    BI_OPCODE_FPOW_SC_DET_F32,
    BI_OPCODE_FRCP_F16,
    BI_OPCODE_FRCP_F32,
    BI_OPCODE_FRCP_APPROX_F32,
    BI_OPCODE_FREXPE_F32,
    BI_OPCODE_FREXPE_V2F16,
    BI_OPCODE_FREXPM_F32,
    BI_OPCODE_FREXPM_V2F16,
    BI_OPCODE_FROUND_F32,
    BI_OPCODE_FROUND_V2F16,
    BI_OPCODE_FRSHIFT_DOUBLE_I32,
    BI_OPCODE_FRSQ_F16,
    BI_OPCODE_FRSQ_F32,
    BI_OPCODE_FRSQ_APPROX_F32,
    BI_OPCODE_FSINCOS_OFFSET_U6,
    BI_OPCODE_FSIN_TABLE_U6,
    BI_OPCODE_HADD_S32,
    BI_OPCODE_HADD_U32,
    BI_OPCODE_HADD_V2S16,
    BI_OPCODE_HADD_V2U16,
    BI_OPCODE_HADD_V4S8,
    BI_OPCODE_HADD_V4U8,
    BI_OPCODE_IABS_S32,
    BI_OPCODE_IABS_V2S16,
    BI_OPCODE_IABS_V4S8,
    BI_OPCODE_IADD_S32,
    BI_OPCODE_IADD_U32,
    BI_OPCODE_IADD_V2S16,
    BI_OPCODE_IADD_V2U16,
    BI_OPCODE_IADD_V4S8,
    BI_OPCODE_IADD_V4U8,
    BI_OPCODE_IADDC_I32,
    BI_OPCODE_IADD_IMM_I32,
    BI_OPCODE_IADD_IMM_V2I16,
    BI_OPCODE_IADD_IMM_V4I8,
    BI_OPCODE_ICMP_I32,
    BI_OPCODE_ICMP_S32,
    BI_OPCODE_ICMP_U32,
    BI_OPCODE_ICMP_V2I16,
    BI_OPCODE_ICMP_V2S16,
    BI_OPCODE_ICMP_V2U16,
    BI_OPCODE_ICMP_V4I8,
    BI_OPCODE_ICMP_V4S8,
    BI_OPCODE_ICMP_V4U8,
    BI_OPCODE_ICMPF_I32,
    BI_OPCODE_ICMPI_I32,
    BI_OPCODE_ICMPI_S32,
    BI_OPCODE_ICMPI_U32,
    BI_OPCODE_ICMPM_I32,
    BI_OPCODE_ICMP_AND_S32,
    BI_OPCODE_ICMP_AND_U32,
    BI_OPCODE_ICMP_AND_V2S16,
    BI_OPCODE_ICMP_AND_V2U16,
    BI_OPCODE_ICMP_AND_V4S8,
    BI_OPCODE_ICMP_AND_V4U8,
    BI_OPCODE_ICMP_MULTI_S32,
    BI_OPCODE_ICMP_MULTI_U32,
    BI_OPCODE_ICMP_OR_S32,
    BI_OPCODE_ICMP_OR_U32,
    BI_OPCODE_ICMP_OR_V2S16,
    BI_OPCODE_ICMP_OR_V2U16,
    BI_OPCODE_ICMP_OR_V4S8,
    BI_OPCODE_ICMP_OR_V4U8,
    BI_OPCODE_IDP_V4I8,
    BI_OPCODE_IDPADD_V4S8,
    BI_OPCODE_IDPADD_V4U8,
    BI_OPCODE_ILOGB_F32,
    BI_OPCODE_ILOGB_V2F16,
    BI_OPCODE_IMOV_FMA,
    BI_OPCODE_IMUL_I32,
    BI_OPCODE_IMUL_V2I16,
    BI_OPCODE_IMUL_V4I8,
    BI_OPCODE_IMULD,
    BI_OPCODE_ISUB_S32,
    BI_OPCODE_ISUB_U32,
    BI_OPCODE_ISUB_V2S16,
    BI_OPCODE_ISUB_V2U16,
    BI_OPCODE_ISUB_V4S8,
    BI_OPCODE_ISUB_V4U8,
    BI_OPCODE_ISUBB_I32,
    BI_OPCODE_JUMP,
    BI_OPCODE_JUMP_EX,
    BI_OPCODE_KABOOM,
    BI_OPCODE_LDEXP_F32,
    BI_OPCODE_LDEXP_V2F16,
    BI_OPCODE_LD_ATTR,
    BI_OPCODE_LD_ATTR_IMM,
    BI_OPCODE_LD_ATTR_TEX,
    BI_OPCODE_LD_BUFFER_I128,
    BI_OPCODE_LD_BUFFER_I16,
    BI_OPCODE_LD_BUFFER_I24,
    BI_OPCODE_LD_BUFFER_I32,
    BI_OPCODE_LD_BUFFER_I48,
    BI_OPCODE_LD_BUFFER_I64,
    BI_OPCODE_LD_BUFFER_I8,
    BI_OPCODE_LD_BUFFER_I96,
    BI_OPCODE_LD_CVT,
    BI_OPCODE_LD_GCLK_U64,
    BI_OPCODE_LD_TEX,
    BI_OPCODE_LD_TEX_IMM,
    BI_OPCODE_LD_TILE,
    BI_OPCODE_LD_VAR,
    BI_OPCODE_LD_VAR_BUF_F16,
    BI_OPCODE_LD_VAR_BUF_F32,
    BI_OPCODE_LD_VAR_BUF_IMM_F16,
    BI_OPCODE_LD_VAR_BUF_IMM_F32,
    BI_OPCODE_LD_VAR_FLAT,
    BI_OPCODE_LD_VAR_FLAT_IMM,
    BI_OPCODE_LD_VAR_IMM,
    BI_OPCODE_LD_VAR_SPECIAL,
    BI_OPCODE_LEA_ATTR,
    BI_OPCODE_LEA_ATTR_IMM,
    BI_OPCODE_LEA_ATTR_TEX,
    BI_OPCODE_LEA_BUFFER,
    BI_OPCODE_LEA_BUF_IMM,
    BI_OPCODE_LEA_TEX,
    BI_OPCODE_LEA_TEX_IMM,
    BI_OPCODE_LOAD_I128,
    BI_OPCODE_LOAD_I16,
    BI_OPCODE_LOAD_I24,
    BI_OPCODE_LOAD_I32,
    BI_OPCODE_LOAD_I48,
    BI_OPCODE_LOAD_I64,
    BI_OPCODE_LOAD_I8,
    BI_OPCODE_LOAD_I96,
    BI_OPCODE_LOGB_F32,
    BI_OPCODE_LOGB_V2F16,
    BI_OPCODE_LROT_DOUBLE_I32,
    BI_OPCODE_LSHIFT_AND_I32,
    BI_OPCODE_LSHIFT_AND_V2I16,
    BI_OPCODE_LSHIFT_AND_V4I8,
    BI_OPCODE_LSHIFT_DOUBLE_I32,
    BI_OPCODE_LSHIFT_OR_I32,
    BI_OPCODE_LSHIFT_OR_V2I16,
    BI_OPCODE_LSHIFT_OR_V4I8,
    BI_OPCODE_LSHIFT_XOR_I32,
    BI_OPCODE_LSHIFT_XOR_V2I16,
    BI_OPCODE_LSHIFT_XOR_V4I8,
    BI_OPCODE_MKVEC_V2I16,
    BI_OPCODE_MKVEC_V2I8,
    BI_OPCODE_MKVEC_V4I8,
    BI_OPCODE_MOV_I32,
    BI_OPCODE_MUX_I32,
    BI_OPCODE_MUX_V2I16,
    BI_OPCODE_MUX_V4I8,
    BI_OPCODE_NOP,
    BI_OPCODE_PHI,
    BI_OPCODE_POPCOUNT_I32,
    BI_OPCODE_QUIET_F32,
    BI_OPCODE_QUIET_V2F16,
    BI_OPCODE_RROT_DOUBLE_I32,
    BI_OPCODE_RSHIFT_AND_I32,
    BI_OPCODE_RSHIFT_AND_V2I16,
    BI_OPCODE_RSHIFT_AND_V4I8,
    BI_OPCODE_RSHIFT_DOUBLE_I32,
    BI_OPCODE_RSHIFT_OR_I32,
    BI_OPCODE_RSHIFT_OR_V2I16,
    BI_OPCODE_RSHIFT_OR_V4I8,
    BI_OPCODE_RSHIFT_XOR_I32,
    BI_OPCODE_RSHIFT_XOR_V2I16,
    BI_OPCODE_RSHIFT_XOR_V4I8,
    BI_OPCODE_S16_TO_F32,
    BI_OPCODE_S16_TO_S32,
    BI_OPCODE_S32_TO_F32,
    BI_OPCODE_S8_TO_F32,
    BI_OPCODE_S8_TO_S32,
    BI_OPCODE_SEG_ADD,
    BI_OPCODE_SEG_ADD_I64,
    BI_OPCODE_SHADDXH_I32,
    BI_OPCODE_SHADDXL_I64,
    BI_OPCODE_SHADDXL_S32,
    BI_OPCODE_SHADDXL_U32,
    BI_OPCODE_SHIFT_DOUBLE_I32,
    BI_OPCODE_SPLIT_I32,
    BI_OPCODE_STORE_I128,
    BI_OPCODE_STORE_I16,
    BI_OPCODE_STORE_I24,
    BI_OPCODE_STORE_I32,
    BI_OPCODE_STORE_I48,
    BI_OPCODE_STORE_I64,
    BI_OPCODE_STORE_I8,
    BI_OPCODE_STORE_I96,
    BI_OPCODE_ST_CVT,
    BI_OPCODE_ST_TILE,
    BI_OPCODE_SWZ_V2I16,
    BI_OPCODE_SWZ_V4I8,
    BI_OPCODE_TEXC,
    BI_OPCODE_TEXC_DUAL,
    BI_OPCODE_TEXS_2D_F16,
    BI_OPCODE_TEXS_2D_F32,
    BI_OPCODE_TEXS_CUBE_F16,
    BI_OPCODE_TEXS_CUBE_F32,
    BI_OPCODE_TEX_FETCH,
    BI_OPCODE_TEX_GATHER,
    BI_OPCODE_TEX_GRADIENT,
    BI_OPCODE_TEX_SINGLE,
    BI_OPCODE_U16_TO_F32,
    BI_OPCODE_U16_TO_U32,
    BI_OPCODE_U32_TO_F32,
    BI_OPCODE_U8_TO_F32,
    BI_OPCODE_U8_TO_U32,
    BI_OPCODE_V2F16_TO_V2S16,
    BI_OPCODE_V2F16_TO_V2U16,
    BI_OPCODE_V2F32_TO_V2F16,
    BI_OPCODE_V2S16_TO_V2F16,
    BI_OPCODE_V2S8_TO_V2F16,
    BI_OPCODE_V2S8_TO_V2S16,
    BI_OPCODE_V2U16_TO_V2F16,
    BI_OPCODE_V2U8_TO_V2F16,
    BI_OPCODE_V2U8_TO_V2U16,
    BI_OPCODE_VAR_TEX_F16,
    BI_OPCODE_VAR_TEX_F32,
    BI_OPCODE_VN_ASST1_F16,
    BI_OPCODE_VN_ASST1_F32,
    BI_OPCODE_VN_ASST2_F32,
    BI_OPCODE_VN_ASST2_V2F16,
    BI_OPCODE_WMASK,
    BI_OPCODE_ZS_EMIT,
    BI_NUM_OPCODES
};

/* Number of staging registers accessed, note this fits into 3-bits */

enum bi_sr_count {
    /* fixed counts */
    BI_SR_COUNT_0 = 0,
    BI_SR_COUNT_1 = 1,
    BI_SR_COUNT_2 = 2,
    BI_SR_COUNT_3 = 3,
    BI_SR_COUNT_4 = 4,

    /* derived from register_format and vecsize */
    BI_SR_COUNT_FORMAT = 5,

    /* equal to vecsize alone */
    BI_SR_COUNT_VECSIZE = 6,

    /* specified directly as the sr_count immediate */
    BI_SR_COUNT_SR_COUNT = 7
};

enum bi_size {
   BI_SIZE_8 = 0,
   BI_SIZE_16,
   BI_SIZE_24,
   BI_SIZE_32,
   BI_SIZE_48,
   BI_SIZE_64,
   BI_SIZE_96,
   BI_SIZE_128,
};

/* Description of an opcode in the IR */
struct bi_op_props {
        const char *name;

        enum bifrost_message_type message : 4;
        enum bi_size size : 3;
        enum bi_sr_count sr_count : 3;
        bool sr_read : 1;
        bool sr_write : 1;
        bool last : 1;
        bool branch : 1;
        bool table : 1;
        bool fma : 1;
        bool add : 1;
        bool is_float : 1;

        /* Supported propagable modifiers */
        bool clamp : 1;
        bool not_result : 1;
        unsigned abs : 3;
        unsigned neg : 3;
        bool not_mod : 1;
};

/* Generated in bi_opcodes.c.py */
extern struct bi_op_props bi_opcode_props[BI_NUM_OPCODES];

#endif

