// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func CopyOrigKeyValueAndUnitSlice(dest, src []*otlpprofiles.KeyValueAndUnit) []*otlpprofiles.KeyValueAndUnit {
	var newDest []*otlpprofiles.KeyValueAndUnit
	if cap(dest) < len(src) {
		newDest = make([]*otlpprofiles.KeyValueAndUnit, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigKeyValueAndUnit()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigKeyValueAndUnit(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigKeyValueAndUnit()
		}
	}
	for i := range src {
		CopyOrigKeyValueAndUnit(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestKeyValueAndUnitSlice() []*otlpprofiles.KeyValueAndUnit {
	orig := make([]*otlpprofiles.KeyValueAndUnit, 5)
	orig[0] = NewOrigKeyValueAndUnit()
	orig[1] = GenTestOrigKeyValueAndUnit()
	orig[2] = NewOrigKeyValueAndUnit()
	orig[3] = GenTestOrigKeyValueAndUnit()
	orig[4] = NewOrigKeyValueAndUnit()
	return orig
}
