/* AppWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AppWindow.vala, do not modify */

/*
* Copyright (c) 2018 elementary, Inc. (https://elementary.io)
*               2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* AppWindow is the parent window for most windows in Photos (FullscreenWindow is the exception).*/
/* There are multiple types of AppWindows (LibraryWindow, DirectWindow) for different tasks, but only*/
/* one AppWindow may exist per process.  Thus, if the user closes an AppWindow, the program exits.*/
/**/
/* AppWindow also offers support for going into fullscreen mode.  It handles the interface*/
/* notifications Page is expecting when switching back and forth.*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <libportal/portal.h>
#include <libportal-gtk3/portal-gtk3.h>
#include <gee.h>
#include <handy.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	APP_WINDOW_0_PROPERTY,
	APP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* app_window_properties[APP_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_XdpParent_free0(var) ((var == NULL) ? NULL : (var = (_vala_XdpParent_free (var), NULL)))
#define _command_manager_unref0(var) ((var == NULL) ? NULL : (var = (command_manager_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AppWindowPrivate {
	gint pos_x;
	gint pos_y;
};

static gint AppWindow_private_offset;
static gpointer app_window_parent_class = NULL;
AppWindow* app_window_instance = NULL;
static FullscreenWindow* app_window_fullscreen_window;
static FullscreenWindow* app_window_fullscreen_window = NULL;
static CommandManager* app_window_command_manager;
static CommandManager* app_window_command_manager = NULL;

static void _app_window_on_fullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void app_window_on_jump_to_file (AppWindow* self);
static void _app_window_on_jump_to_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void _app_window_on_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void app_window_on_redo (AppWindow* self);
static void _app_window_on_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void app_window_on_select_all (AppWindow* self);
static void _app_window_on_select_all_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void app_window_on_select_none (AppWindow* self);
static void _app_window_on_select_none_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void app_window_on_undo (AppWindow* self);
static void _app_window_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void app_window_action_set_wallpaper (AppWindow* self,
                                      GSimpleAction* action,
                                      GVariant* param);
static void _app_window_action_set_wallpaper_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void app_window_real_on_fullscreen (AppWindow* self);
static gchar* app_window_real_get_app_role (AppWindow* self);
static void app_window_real_on_quit (AppWindow* self);
static void app_window_show_file_uri (AppWindow* self,
                               GFile* file,
                               GError** error);
static void app_window_real_destroy (GtkWidget* base);
static void _vala_XdpParent_free (XdpParent* self);
static GtkActionGroup** app_window_real_create_common_action_groups (AppWindow* self,
                                                              gint* result_length1);
static GtkActionGroup** _vala_array_dup1 (GtkActionGroup** self,
                                   gssize length);
static void app_window_real_switched_pages (PageWindow* base,
                                     Page* old_page,
                                     Page* new_page);
static void app_window_on_update_common_actions (AppWindow* self);
static void _app_window_on_update_common_actions_data_collection_contents_altered (DataCollection* _sender,
                                                                            GeeIterable* added,
                                                                            GeeIterable* removed,
                                                                            gpointer self);
static void _app_window_on_update_common_actions_view_collection_selection_group_altered (ViewCollection* _sender,
                                                                                   gpointer self);
static void _app_window_on_update_common_actions_view_collection_items_state_changed (ViewCollection* _sender,
                                                                               GeeIterable* changed,
                                                                               gpointer self);
static void app_window_real_update_common_action_availability (AppWindow* self,
                                                        Page* old_page,
                                                        Page* new_page);
static void app_window_real_update_common_actions (AppWindow* self,
                                            Page* page,
                                            gint selected_count,
                                            gint count);
static void app_window_on_command_manager_altered (AppWindow* self);
static void app_window_decorate_command_manager_action (AppWindow* self,
                                                 const gchar* name,
                                                 GtkButton* button,
                                                 const gchar* default_explanation,
                                                 Command* command);
static gboolean app_window_real_configure_event (GtkWidget* base,
                                          GdkEventConfigure* event);
static GObject * app_window_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
static void _app_window_on_command_manager_altered_command_manager_altered (CommandManager* _sender,
                                                                     gboolean can_undo,
                                                                     gboolean can_redo,
                                                                     gpointer self);
static void app_window_finalize (GObject * obj);
static GType app_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry APP_WINDOW_ACTION_ENTRIES[8] = {{APP_WINDOW_ACTION_FULLSCREEN, _app_window_on_fullscreen_gsimple_action_activate_callback}, {APP_WINDOW_ACTION_JUMP_TO_FILE, _app_window_on_jump_to_file_gsimple_action_activate_callback}, {APP_WINDOW_ACTION_QUIT, _app_window_on_quit_gsimple_action_activate_callback}, {APP_WINDOW_ACTION_REDO, _app_window_on_redo_gsimple_action_activate_callback}, {APP_WINDOW_ACTION_SELECT_ALL, _app_window_on_select_all_gsimple_action_activate_callback}, {APP_WINDOW_ACTION_SELECT_NONE, _app_window_on_select_none_gsimple_action_activate_callback}, {APP_WINDOW_ACTION_UNDO, _app_window_on_undo_gsimple_action_activate_callback}, {APP_WINDOW_ACTION_SET_WALLPAPER, _app_window_action_set_wallpaper_gsimple_action_activate_callback, "s"}};

static inline gpointer
app_window_get_instance_private (AppWindow* self)
{
	return G_STRUCT_MEMBER_P (self, AppWindow_private_offset);
}

static void
_app_window_on_fullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	app_window_on_fullscreen ((AppWindow*) self);
}

static void
_app_window_on_jump_to_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	app_window_on_jump_to_file ((AppWindow*) self);
}

static void
_app_window_on_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	app_window_on_quit ((AppWindow*) self);
}

static void
_app_window_on_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	app_window_on_redo ((AppWindow*) self);
}

static void
_app_window_on_select_all_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	app_window_on_select_all ((AppWindow*) self);
}

static void
_app_window_on_select_none_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	app_window_on_select_none ((AppWindow*) self);
}

static void
_app_window_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	app_window_on_undo ((AppWindow*) self);
}

static void
_app_window_action_set_wallpaper_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	app_window_action_set_wallpaper ((AppWindow*) self, action, parameter);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

AppWindow*
app_window_construct (GType object_type)
{
	AppWindow * self = NULL;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	self = (AppWindow*) page_window_construct (object_type);
	_tmp0_ = app_window_instance;
	_vala_assert (_tmp0_ == NULL, "instance == null");
	_tmp1_ = _g_object_ref0 (self);
	_g_object_unref0 (app_window_instance);
	app_window_instance = _tmp1_;
	return self;
}

static void
app_window_real_on_fullscreen (AppWindow* self)
{
	g_critical ("Type `%s' does not implement abstract method `app_window_on_fullscreen'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
app_window_on_fullscreen (AppWindow* self)
{
	AppWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = APP_WINDOW_GET_CLASS (self);
	if (_klass_->on_fullscreen) {
		_klass_->on_fullscreen (self);
	}
}

AppWindow*
app_window_get_instance (void)
{
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	AppWindow* result;
	_tmp0_ = app_window_instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

FullscreenWindow*
app_window_get_fullscreen (void)
{
	FullscreenWindow* _tmp0_;
	FullscreenWindow* _tmp1_;
	FullscreenWindow* result;
	_tmp0_ = app_window_fullscreen_window;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
app_window_error_message (const gchar* title,
                          const gchar* message,
                          GtkWindow* parent)
{
	GraniteMessageDialog* dialog = NULL;
	GraniteMessageDialog* _tmp0_;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_;
	GraniteMessageDialog* _tmp4_;
	GraniteMessageDialog* _tmp5_;
	GraniteMessageDialog* _tmp6_;
	g_return_if_fail (title != NULL);
	_tmp0_ = granite_message_dialog_new_with_image_from_icon_name (title, message, "dialog-error", GTK_BUTTONS_CLOSE);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	_tmp2_ = _g_object_ref0 (parent);
	_tmp1_ = _tmp2_;
	if (_tmp1_ == NULL) {
		AppWindow* _tmp3_;
		_tmp3_ = app_window_get_instance ();
		_g_object_unref0 (_tmp1_);
		_tmp1_ = (GtkWindow*) _tmp3_;
	}
	_tmp4_ = dialog;
	gtk_window_set_transient_for ((GtkWindow*) _tmp4_, _tmp1_);
	_tmp5_ = dialog;
	gtk_dialog_run ((GtkDialog*) _tmp5_);
	_tmp6_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp6_);
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (dialog);
}

GtkResponseType
app_window_cancel_affirm_question (const gchar* message,
                                   const gchar* affirmative,
                                   const gchar* title)
{
	const gchar* _tmp0_ = NULL;
	GraniteMessageDialog* dialog = NULL;
	GraniteMessageDialog* _tmp1_;
	AppWindow* _tmp2_;
	AppWindow* _tmp3_;
	gint response = 0;
	GtkResponseType result;
	g_return_val_if_fail (message != NULL, 0);
	g_return_val_if_fail (affirmative != NULL, 0);
	_tmp0_ = title;
	if (_tmp0_ == NULL) {
		_tmp0_ = _ (RESOURCES_APP_TITLE);
	}
	_tmp1_ = granite_message_dialog_new_with_image_from_icon_name (_tmp0_, message, "dialog-question", GTK_BUTTONS_CANCEL);
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	_tmp2_ = app_window_get_instance ();
	_tmp3_ = _tmp2_;
	gtk_window_set_transient_for ((GtkWindow*) dialog, (GtkWindow*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	gtk_dialog_add_button ((GtkDialog*) dialog, affirmative, (gint) GTK_RESPONSE_YES);
	response = gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = (GtkResponseType) response;
	_g_object_unref0 (dialog);
	return result;
}

void
app_window_database_error (GError* err)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = err->message;
	_tmp1_ = g_strdup_printf (_ ("A fatal error occurred when accessing Photos' library. Photos cannot c" \
"ontinue.\n" \
"\n" \
"%s"), _tmp0_);
	_tmp2_ = _tmp1_;
	app_window_panic (_tmp2_);
	_g_free0 (_tmp2_);
}

void
app_window_panic (const gchar* msg)
{
	GApplication* _tmp0_;
	g_return_if_fail (msg != NULL);
	g_critical ("AppWindow.vala:169: %s", msg);
	app_window_error_message (msg, NULL, NULL);
	_tmp0_ = g_application_get_default ();
	photos_application_panic (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PHOTOS_TYPE_APPLICATION, PhotosApplication));
}

static gchar*
app_window_real_get_app_role (AppWindow* self)
{
	g_critical ("Type `%s' does not implement abstract method `app_window_get_app_role'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
app_window_get_app_role (AppWindow* self)
{
	AppWindowClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = APP_WINDOW_GET_CLASS (self);
	if (_klass_->get_app_role) {
		return _klass_->get_app_role (self);
	}
	return NULL;
}

static void
app_window_real_on_quit (AppWindow* self)
{
	GApplication* _tmp0_;
	_tmp0_ = g_application_get_default ();
	photos_application_exit (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PHOTOS_TYPE_APPLICATION, PhotosApplication));
}

void
app_window_on_quit (AppWindow* self)
{
	AppWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = APP_WINDOW_GET_CLASS (self);
	if (_klass_->on_quit) {
		_klass_->on_quit (self);
	}
}

static void
app_window_on_jump_to_file (AppWindow* self)
{
	Page* _tmp0_;
	Page* _tmp1_;
	ViewCollection* _tmp2_;
	ViewCollection* _tmp3_;
	gboolean _tmp4_;
	MediaSource* media = NULL;
	Page* _tmp5_;
	Page* _tmp6_;
	ViewCollection* _tmp7_;
	ViewCollection* _tmp8_;
	DataView* _tmp9_;
	DataView* _tmp10_;
	DataSource* _tmp11_;
	DataSource* _tmp12_;
	MediaSource* _tmp13_;
	MediaSource* _tmp14_;
	MediaSource* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = page_get_view (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = view_collection_get_selected_count (_tmp3_) != 1;
	_data_collection_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		return;
	}
	_tmp5_ = page_window_get_current_page ((PageWindow*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = page_get_view (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = view_collection_get_selected_at (_tmp8_, 0);
	_tmp10_ = _tmp9_;
	_tmp11_ = data_view_get_source (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (IS_MEDIA_SOURCE (_tmp12_) ? ((MediaSource*) _tmp12_) : NULL);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp10_);
	_data_collection_unref0 (_tmp8_);
	_g_object_unref0 (_tmp6_);
	media = _tmp14_;
	_tmp15_ = media;
	if (_tmp15_ == NULL) {
		_g_object_unref0 (media);
		return;
	}
	{
		AppWindow* _tmp16_;
		AppWindow* _tmp17_;
		MediaSource* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		_tmp16_ = app_window_get_instance ();
		_tmp17_ = _tmp16_;
		_tmp18_ = media;
		_tmp19_ = media_source_get_master_file (_tmp18_);
		_tmp20_ = _tmp19_;
		app_window_show_file_uri (_tmp17_, _tmp20_, &_inner_error0_);
		_g_object_unref0 (_tmp20_);
		_g_object_unref0 (_tmp17_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = err;
		_tmp22_ = resources_jump_to_file_failed (_tmp21_);
		_tmp23_ = _tmp22_;
		app_window_error_message (_tmp23_, NULL, NULL);
		_g_free0 (_tmp23_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (media);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (media);
}

static void
app_window_real_destroy (GtkWidget* base)
{
	AppWindow * self;
	self = (AppWindow*) base;
	app_window_on_quit (self);
}

static void
_vala_XdpParent_free (XdpParent* self)
{
	g_boxed_free (xdp_parent_get_type (), self);
}

static void
app_window_show_file_uri (AppWindow* self,
                          GFile* file,
                          GError** error)
{
	XdpParent* parent = NULL;
	XdpParent* _tmp0_;
	XdpPortal* portal = NULL;
	XdpPortal* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = xdp_parent_new_gtk ((GtkWindow*) self);
	parent = _tmp0_;
	_tmp1_ = xdp_portal_new ();
	portal = _tmp1_;
	_tmp2_ = g_file_get_uri (file);
	_tmp3_ = _tmp2_;
	xdp_portal_open_directory (portal, parent, _tmp3_, XDP_OPEN_URI_FLAG_NONE, NULL, NULL, NULL);
	_g_free0 (_tmp3_);
	_g_object_unref0 (portal);
	__vala_XdpParent_free0 (parent);
}

static GtkActionGroup**
app_window_real_create_common_action_groups (AppWindow* self,
                                             gint* result_length1)
{
	GtkActionGroup** groups = NULL;
	GtkActionGroup** _tmp0_;
	gint groups_length1;
	gint _groups_size_;
	GtkActionGroup** _tmp1_;
	gint _tmp1__length1;
	GtkActionGroup** result;
	_tmp0_ = g_new0 (GtkActionGroup*, 0 + 1);
	groups = _tmp0_;
	groups_length1 = 0;
	_groups_size_ = groups_length1;
	_tmp1_ = groups;
	_tmp1__length1 = groups_length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

GtkActionGroup**
app_window_create_common_action_groups (AppWindow* self,
                                        gint* result_length1)
{
	AppWindowClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = APP_WINDOW_GET_CLASS (self);
	if (_klass_->create_common_action_groups) {
		return _klass_->create_common_action_groups (self, result_length1);
	}
	return NULL;
}

static GtkActionGroup**
_vala_array_dup1 (GtkActionGroup** self,
                  gssize length)
{
	if (length >= 0) {
		GtkActionGroup** result;
		gssize i;
		result = g_new0 (GtkActionGroup*, length + 1);
		for (i = 0; i < length; i++) {
			GtkActionGroup* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

GtkActionGroup**
app_window_get_common_action_groups (AppWindow* self,
                                     gint* result_length1)
{
	GtkActionGroup** _tmp0_;
	gint _tmp0__length1;
	GtkActionGroup** _tmp1_;
	gint _tmp1__length1;
	GtkActionGroup** _tmp2_;
	gint _tmp2__length1;
	GtkActionGroup** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->common_action_groups;
	_tmp0__length1 = self->common_action_groups_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
app_window_go_fullscreen (AppWindow* self,
                          Page* page)
{
	FullscreenWindow* _tmp0_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	FullscreenWindow* fsw = NULL;
	FullscreenWindow* _tmp4_;
	Page* _tmp5_;
	Page* _tmp6_;
	gboolean _tmp7_;
	FullscreenWindow* _tmp11_;
	FullscreenWindow* _tmp12_;
	FullscreenWindow* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = app_window_fullscreen_window;
	if (_tmp0_ != NULL) {
		FullscreenWindow* _tmp1_;
		_tmp1_ = app_window_fullscreen_window;
		gtk_window_present ((GtkWindow*) _tmp1_);
		return;
	}
	gtk_window_get_position ((GtkWindow*) self, &_tmp2_, &_tmp3_);
	self->priv->pos_x = _tmp2_;
	self->priv->pos_y = _tmp3_;
	gtk_widget_hide ((GtkWidget*) self);
	_tmp4_ = fullscreen_window_new (page);
	g_object_ref_sink (_tmp4_);
	fsw = _tmp4_;
	_tmp5_ = page_window_get_current_page ((PageWindow*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_ != NULL;
	_g_object_unref0 (_tmp6_);
	if (_tmp7_) {
		Page* _tmp8_;
		Page* _tmp9_;
		FullscreenWindow* _tmp10_;
		_tmp8_ = page_window_get_current_page ((PageWindow*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = fsw;
		page_switching_to_fullscreen (_tmp9_, _tmp10_);
		_g_object_unref0 (_tmp9_);
	}
	_tmp11_ = fsw;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (app_window_fullscreen_window);
	app_window_fullscreen_window = _tmp12_;
	_tmp13_ = app_window_fullscreen_window;
	gtk_window_present ((GtkWindow*) _tmp13_);
	_g_object_unref0 (fsw);
}

void
app_window_end_fullscreen (AppWindow* self)
{
	FullscreenWindow* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	gboolean _tmp3_;
	FullscreenWindow* _tmp7_;
	FullscreenWindow* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_window_fullscreen_window;
	if (_tmp0_ == NULL) {
		return;
	}
	gtk_window_move ((GtkWindow*) self, self->priv->pos_x, self->priv->pos_y);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp1_ = page_window_get_current_page ((PageWindow*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		Page* _tmp4_;
		Page* _tmp5_;
		FullscreenWindow* _tmp6_;
		_tmp4_ = page_window_get_current_page ((PageWindow*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = app_window_fullscreen_window;
		page_returning_from_fullscreen (_tmp5_, _tmp6_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp7_ = app_window_fullscreen_window;
	gtk_widget_hide ((GtkWidget*) _tmp7_);
	_tmp8_ = app_window_fullscreen_window;
	gtk_widget_destroy ((GtkWidget*) _tmp8_);
	_g_object_unref0 (app_window_fullscreen_window);
	app_window_fullscreen_window = NULL;
	gtk_window_present ((GtkWindow*) self);
}

GtkAction*
app_window_get_common_action (AppWindow* self,
                              const gchar* name)
{
	GtkActionGroup** _tmp0_;
	gint _tmp0__length1;
	GtkAction* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->common_action_groups;
	_tmp0__length1 = self->common_action_groups_length1;
	{
		GtkActionGroup** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp0_;
		group_collection_length1 = _tmp0__length1;
		for (group_it = 0; group_it < group_collection_length1; group_it = group_it + 1) {
			GtkActionGroup* _tmp1_;
			GtkActionGroup* group = NULL;
			_tmp1_ = _g_object_ref0 (group_collection[group_it]);
			group = _tmp1_;
			{
				GtkAction* action = NULL;
				GtkActionGroup* _tmp2_;
				GtkAction* _tmp3_;
				GtkAction* _tmp4_;
				GtkAction* _tmp5_;
				_tmp2_ = group;
				_tmp3_ = gtk_action_group_get_action (_tmp2_, name);
				_tmp4_ = _g_object_ref0 (_tmp3_);
				action = _tmp4_;
				_tmp5_ = action;
				if (_tmp5_ != NULL) {
					result = action;
					_g_object_unref0 (group);
					return result;
				}
				_g_object_unref0 (action);
				_g_object_unref0 (group);
			}
		}
	}
	g_warning ("AppWindow.vala:261: No common action found: %s", name);
	result = NULL;
	return result;
}

void
app_window_set_common_action_sensitive (AppWindow* self,
                                        const gchar* name,
                                        gboolean sensitive)
{
	GtkAction* action = NULL;
	GtkAction* _tmp0_;
	GtkAction* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = app_window_get_common_action (self, name);
	action = _tmp0_;
	_tmp1_ = action;
	if (_tmp1_ != NULL) {
		GtkAction* _tmp2_;
		_tmp2_ = action;
		gtk_action_set_sensitive (_tmp2_, sensitive);
	}
	_g_object_unref0 (action);
}

void
app_window_set_common_action_visible (AppWindow* self,
                                      const gchar* name,
                                      gboolean visible)
{
	GtkAction* action = NULL;
	GtkAction* _tmp0_;
	GtkAction* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = app_window_get_common_action (self, name);
	action = _tmp0_;
	_tmp1_ = action;
	if (_tmp1_ != NULL) {
		GtkAction* _tmp2_;
		_tmp2_ = action;
		gtk_action_set_visible (_tmp2_, visible);
	}
	_g_object_unref0 (action);
}

static void
_app_window_on_update_common_actions_data_collection_contents_altered (DataCollection* _sender,
                                                                       GeeIterable* added,
                                                                       GeeIterable* removed,
                                                                       gpointer self)
{
	app_window_on_update_common_actions ((AppWindow*) self);
}

static void
_app_window_on_update_common_actions_view_collection_selection_group_altered (ViewCollection* _sender,
                                                                              gpointer self)
{
	app_window_on_update_common_actions ((AppWindow*) self);
}

static void
_app_window_on_update_common_actions_view_collection_items_state_changed (ViewCollection* _sender,
                                                                          GeeIterable* changed,
                                                                          gpointer self)
{
	app_window_on_update_common_actions ((AppWindow*) self);
}

static void
app_window_real_switched_pages (PageWindow* base,
                                Page* old_page,
                                Page* new_page)
{
	AppWindow * self;
	self = (AppWindow*) base;
	app_window_update_common_action_availability (self, old_page, new_page);
	if (old_page != NULL) {
		ViewCollection* _tmp0_;
		ViewCollection* _tmp1_;
		guint _tmp2_;
		ViewCollection* _tmp3_;
		ViewCollection* _tmp4_;
		guint _tmp5_;
		ViewCollection* _tmp6_;
		ViewCollection* _tmp7_;
		guint _tmp8_;
		_tmp0_ = page_get_view (old_page);
		_tmp1_ = _tmp0_;
		g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((DataCollection*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _app_window_on_update_common_actions_data_collection_contents_altered, self);
		_data_collection_unref0 (_tmp1_);
		_tmp3_ = page_get_view (old_page);
		_tmp4_ = _tmp3_;
		g_signal_parse_name ("selection-group-altered", TYPE_VIEW_COLLECTION, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _app_window_on_update_common_actions_view_collection_selection_group_altered, self);
		_data_collection_unref0 (_tmp4_);
		_tmp6_ = page_get_view (old_page);
		_tmp7_ = _tmp6_;
		g_signal_parse_name ("items-state-changed", TYPE_VIEW_COLLECTION, &_tmp8_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _app_window_on_update_common_actions_view_collection_items_state_changed, self);
		_data_collection_unref0 (_tmp7_);
	}
	if (new_page != NULL) {
		ViewCollection* _tmp9_;
		ViewCollection* _tmp10_;
		ViewCollection* _tmp11_;
		ViewCollection* _tmp12_;
		ViewCollection* _tmp13_;
		ViewCollection* _tmp14_;
		ViewCollection* _tmp15_;
		ViewCollection* _tmp16_;
		ViewCollection* _tmp17_;
		ViewCollection* _tmp18_;
		_tmp9_ = page_get_view (new_page);
		_tmp10_ = _tmp9_;
		g_signal_connect_object ((DataCollection*) _tmp10_, "contents-altered", (GCallback) _app_window_on_update_common_actions_data_collection_contents_altered, self, 0);
		_data_collection_unref0 (_tmp10_);
		_tmp11_ = page_get_view (new_page);
		_tmp12_ = _tmp11_;
		g_signal_connect_object (_tmp12_, "selection-group-altered", (GCallback) _app_window_on_update_common_actions_view_collection_selection_group_altered, self, 0);
		_data_collection_unref0 (_tmp12_);
		_tmp13_ = page_get_view (new_page);
		_tmp14_ = _tmp13_;
		g_signal_connect_object (_tmp14_, "items-state-changed", (GCallback) _app_window_on_update_common_actions_view_collection_items_state_changed, self, 0);
		_data_collection_unref0 (_tmp14_);
		_tmp15_ = page_get_view (new_page);
		_tmp16_ = _tmp15_;
		_tmp17_ = page_get_view (new_page);
		_tmp18_ = _tmp17_;
		app_window_update_common_actions (self, new_page, view_collection_get_selected_count (_tmp16_), data_collection_get_count ((DataCollection*) _tmp18_));
		_data_collection_unref0 (_tmp18_);
		_data_collection_unref0 (_tmp16_);
	}
	PAGE_WINDOW_CLASS (app_window_parent_class)->switched_pages (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow), old_page, new_page);
}

static void
app_window_real_update_common_action_availability (AppWindow* self,
                                                   Page* old_page,
                                                   Page* new_page)
{
	gboolean is_checkerboard = FALSE;
	GAction* _tmp0_;
	GAction* _tmp1_;
	is_checkerboard = IS_CHECKERBOARD_PAGE (new_page);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, APP_WINDOW_ACTION_SELECT_ALL);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), is_checkerboard);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) self, APP_WINDOW_ACTION_SELECT_NONE);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), is_checkerboard);
}

void
app_window_update_common_action_availability (AppWindow* self,
                                              Page* old_page,
                                              Page* new_page)
{
	AppWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = APP_WINDOW_GET_CLASS (self);
	if (_klass_->update_common_action_availability) {
		_klass_->update_common_action_availability (self, old_page, new_page);
	}
}

static void
app_window_real_update_common_actions (AppWindow* self,
                                       Page* page,
                                       gint selected_count,
                                       gint count)
{
	GAction* _tmp1_;
	g_return_if_fail (page != NULL);
	if (IS_CHECKERBOARD_PAGE (page)) {
		GAction* _tmp0_;
		_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, APP_WINDOW_ACTION_SELECT_ALL);
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), count > 0);
	}
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) self, APP_WINDOW_ACTION_JUMP_TO_FILE);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), selected_count == 1);
	app_window_on_command_manager_altered (self);
}

void
app_window_update_common_actions (AppWindow* self,
                                  Page* page,
                                  gint selected_count,
                                  gint count)
{
	AppWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = APP_WINDOW_GET_CLASS (self);
	if (_klass_->update_common_actions) {
		_klass_->update_common_actions (self, page, selected_count, count);
	}
}

static void
app_window_on_update_common_actions (AppWindow* self)
{
	Page* page = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	page = _tmp0_;
	_tmp1_ = page;
	if (_tmp1_ != NULL) {
		Page* _tmp2_;
		Page* _tmp3_;
		ViewCollection* _tmp4_;
		ViewCollection* _tmp5_;
		Page* _tmp6_;
		ViewCollection* _tmp7_;
		ViewCollection* _tmp8_;
		_tmp2_ = page;
		_tmp3_ = page;
		_tmp4_ = page_get_view (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = page;
		_tmp7_ = page_get_view (_tmp6_);
		_tmp8_ = _tmp7_;
		app_window_update_common_actions (self, _tmp2_, view_collection_get_selected_count (_tmp5_), data_collection_get_count ((DataCollection*) _tmp8_));
		_data_collection_unref0 (_tmp8_);
		_data_collection_unref0 (_tmp5_);
	}
	_g_object_unref0 (page);
}

static gpointer
_command_manager_ref0 (gpointer self)
{
	return self ? command_manager_ref (self) : NULL;
}

CommandManager*
app_window_get_command_manager (void)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	CommandManager* result;
	_tmp0_ = app_window_command_manager;
	_tmp1_ = _command_manager_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
app_window_on_command_manager_altered (AppWindow* self)
{
	GtkButton* _tmp0_;
	CommandManager* _tmp1_;
	CommandManager* _tmp2_;
	Command* _tmp3_;
	Command* _tmp4_;
	GtkButton* _tmp5_;
	CommandManager* _tmp6_;
	CommandManager* _tmp7_;
	Command* _tmp8_;
	Command* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->undo_btn;
	_tmp1_ = app_window_get_command_manager ();
	_tmp2_ = _tmp1_;
	_tmp3_ = command_manager_get_undo_command (_tmp2_);
	_tmp4_ = _tmp3_;
	app_window_decorate_command_manager_action (self, APP_WINDOW_ACTION_UNDO, _tmp0_, _ ("Undo"), _tmp4_);
	_g_object_unref0 (_tmp4_);
	_command_manager_unref0 (_tmp2_);
	_tmp5_ = self->redo_btn;
	_tmp6_ = app_window_get_command_manager ();
	_tmp7_ = _tmp6_;
	_tmp8_ = command_manager_get_redo_command (_tmp7_);
	_tmp9_ = _tmp8_;
	app_window_decorate_command_manager_action (self, APP_WINDOW_ACTION_REDO, _tmp5_, _ ("Redo"), _tmp9_);
	_g_object_unref0 (_tmp9_);
	_command_manager_unref0 (_tmp7_);
}

static void
app_window_decorate_command_manager_action (AppWindow* self,
                                            const gchar* name,
                                            GtkButton* button,
                                            const gchar* default_explanation,
                                            Command* command)
{
	GSimpleAction* action = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (button != NULL);
	g_return_if_fail (default_explanation != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, name);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	action = _tmp1_;
	_tmp2_ = action;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (action);
		return;
	}
	if (command != NULL) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GSimpleAction* _tmp7_;
		_tmp3_ = command_get_name (command);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%s %s", default_explanation, _tmp4_);
		_tmp6_ = _tmp5_;
		gtk_widget_set_tooltip_text ((GtkWidget*) button, _tmp6_);
		_g_free0 (_tmp6_);
		_tmp7_ = action;
		g_simple_action_set_enabled (_tmp7_, TRUE);
	} else {
		GSimpleAction* _tmp8_;
		gtk_widget_set_tooltip_text ((GtkWidget*) button, default_explanation);
		_tmp8_ = action;
		g_simple_action_set_enabled (_tmp8_, FALSE);
	}
	_g_object_unref0 (action);
}

static void
app_window_action_set_wallpaper (AppWindow* self,
                                 GSimpleAction* action,
                                 GVariant* param)
{
	XdpParent* parent = NULL;
	XdpParent* _tmp0_;
	XdpPortal* portal = NULL;
	XdpPortal* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = xdp_parent_new_gtk ((GtkWindow*) self);
	parent = _tmp0_;
	_tmp1_ = xdp_portal_new ();
	portal = _tmp1_;
	_tmp2_ = g_variant_get_string (param, NULL);
	xdp_portal_set_wallpaper (portal, parent, _tmp2_, XDP_WALLPAPER_FLAG_NONE, NULL, NULL, NULL);
	_g_object_unref0 (portal);
	__vala_XdpParent_free0 (parent);
}

static void
app_window_on_undo (AppWindow* self)
{
	CommandManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_window_command_manager;
	command_manager_undo (_tmp0_);
}

static void
app_window_on_redo (AppWindow* self)
{
	CommandManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_window_command_manager;
	command_manager_redo (_tmp0_);
}

static void
app_window_on_select_all (AppWindow* self)
{
	Page* page = NULL;
	Page* _tmp0_;
	CheckerboardPage* _tmp1_;
	Page* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	_tmp1_ = IS_CHECKERBOARD_PAGE (_tmp0_) ? ((CheckerboardPage*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	page = (Page*) _tmp1_;
	_tmp2_ = page;
	if (_tmp2_ != NULL) {
		Page* _tmp3_;
		ViewCollection* _tmp4_;
		ViewCollection* _tmp5_;
		_tmp3_ = page;
		_tmp4_ = page_get_view (_tmp3_);
		_tmp5_ = _tmp4_;
		view_collection_select_all (_tmp5_);
		_data_collection_unref0 (_tmp5_);
	}
	_g_object_unref0 (page);
}

static void
app_window_on_select_none (AppWindow* self)
{
	Page* page = NULL;
	Page* _tmp0_;
	CheckerboardPage* _tmp1_;
	Page* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	_tmp1_ = IS_CHECKERBOARD_PAGE (_tmp0_) ? ((CheckerboardPage*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	page = (Page*) _tmp1_;
	_tmp2_ = page;
	if (_tmp2_ != NULL) {
		Page* _tmp3_;
		ViewCollection* _tmp4_;
		ViewCollection* _tmp5_;
		_tmp3_ = page;
		_tmp4_ = page_get_view (_tmp3_);
		_tmp5_ = _tmp4_;
		view_collection_unselect_all (_tmp5_);
		_data_collection_unref0 (_tmp5_);
	}
	_g_object_unref0 (page);
}

static gboolean
app_window_real_configure_event (GtkWidget* base,
                                 GdkEventConfigure* event)
{
	AppWindow * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	self = (AppWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	g_object_get ((GtkWindow*) self, "is-maximized", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
		self->dimensions.width = _tmp2_;
		self->dimensions.height = _tmp3_;
	}
	result = GTK_WIDGET_CLASS (app_window_parent_class)->configure_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow), event);
	return result;
}

static void
_app_window_on_command_manager_altered_command_manager_altered (CommandManager* _sender,
                                                                gboolean can_undo,
                                                                gboolean can_redo,
                                                                gpointer self)
{
	app_window_on_command_manager_altered ((AppWindow*) self);
}

static GObject *
app_window_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AppWindow * self;
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	CommandManager* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	HdyHeaderBar* _tmp7_;
	HdyHeaderBar* _tmp8_;
	PhotosApplication* application_instance = NULL;
	GApplication* _tmp9_;
	PhotosApplication* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	PhotosApplication* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	PhotosApplication* _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	PhotosApplication* _tmp22_;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	PhotosApplication* _tmp26_;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	PhotosApplication* _tmp30_;
	gchar* _tmp31_;
	gchar** _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	PhotosApplication* _tmp34_;
	gchar* _tmp35_;
	gchar** _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp38_;
	GtkCssProvider* _tmp39_;
	GdkScreen* _tmp40_;
	GtkCssProvider* _tmp41_;
	GSettings* _tmp42_;
	gint _tmp43_ = 0;
	GtkActionGroup** _tmp44_;
	GtkActionGroup** _tmp45_;
	gint _tmp45__length1;
	GtkUIManager* _tmp55_;
	GtkUIManager* _tmp56_;
	GtkAccelGroup* _tmp57_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (app_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APP_WINDOW, AppWindow);
	_tmp0_ = app_window_command_manager;
	_vala_assert (_tmp0_ == NULL, "command_manager == null");
	_tmp1_ = command_manager_new (COMMAND_MANAGER_DEFAULT_DEPTH);
	_command_manager_unref0 (app_window_command_manager);
	app_window_command_manager = _tmp1_;
	_tmp2_ = app_window_command_manager;
	g_signal_connect_object (_tmp2_, "altered", (GCallback) _app_window_on_command_manager_altered_command_manager_altered, self, 0);
	_tmp3_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-redo", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->redo_btn);
	self->redo_btn = _tmp3_;
	_tmp4_ = self->redo_btn;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp4_, APP_WINDOW_ACTION_PREFIX APP_WINDOW_ACTION_REDO);
	_tmp5_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->undo_btn);
	self->undo_btn = _tmp5_;
	_tmp6_ = self->undo_btn;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp6_, APP_WINDOW_ACTION_PREFIX APP_WINDOW_ACTION_UNDO);
	_tmp7_ = (HdyHeaderBar*) hdy_header_bar_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->header);
	self->header = _tmp7_;
	_tmp8_ = self->header;
	hdy_header_bar_set_show_close_button (_tmp8_, TRUE);
	gtk_window_set_icon_name ((GtkWindow*) self, "io.elementary.photos");
	gtk_window_set_title ((GtkWindow*) self, _ (RESOURCES_APP_TITLE));
	g_action_map_add_action_entries ((GActionMap*) self, APP_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (APP_WINDOW_ACTION_ENTRIES), self);
	_tmp9_ = g_application_get_default ();
	application_instance = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, PHOTOS_TYPE_APPLICATION, PhotosApplication);
	_tmp10_ = application_instance;
	_tmp11_ = g_strdup ("F11");
	_tmp12_ = g_new0 (gchar*, 1 + 1);
	_tmp12_[0] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) _tmp10_, APP_WINDOW_ACTION_PREFIX APP_WINDOW_ACTION_FULLSCREEN, _tmp13_);
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = application_instance;
	_tmp15_ = g_strdup ("<Ctrl><Shift>M");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) _tmp14_, APP_WINDOW_ACTION_PREFIX APP_WINDOW_ACTION_JUMP_TO_FILE, _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = application_instance;
	_tmp19_ = g_strdup ("<Ctrl>Q");
	_tmp20_ = g_new0 (gchar*, 1 + 1);
	_tmp20_[0] = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp21__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) _tmp18_, APP_WINDOW_ACTION_PREFIX APP_WINDOW_ACTION_QUIT, _tmp21_);
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
	_tmp22_ = application_instance;
	_tmp23_ = g_strdup ("<Ctrl><Shift>Z");
	_tmp24_ = g_new0 (gchar*, 1 + 1);
	_tmp24_[0] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) _tmp22_, APP_WINDOW_ACTION_PREFIX APP_WINDOW_ACTION_REDO, _tmp25_);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	_tmp26_ = application_instance;
	_tmp27_ = g_strdup ("<Ctrl>A");
	_tmp28_ = g_new0 (gchar*, 1 + 1);
	_tmp28_[0] = _tmp27_;
	_tmp29_ = _tmp28_;
	_tmp29__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) _tmp26_, APP_WINDOW_ACTION_PREFIX APP_WINDOW_ACTION_SELECT_ALL, _tmp29_);
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
	_tmp30_ = application_instance;
	_tmp31_ = g_strdup ("<Ctrl><Shift>A");
	_tmp32_ = g_new0 (gchar*, 1 + 1);
	_tmp32_[0] = _tmp31_;
	_tmp33_ = _tmp32_;
	_tmp33__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) _tmp30_, APP_WINDOW_ACTION_PREFIX APP_WINDOW_ACTION_SELECT_NONE, _tmp33_);
	_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
	_tmp34_ = application_instance;
	_tmp35_ = g_strdup ("<Ctrl>Z");
	_tmp36_ = g_new0 (gchar*, 1 + 1);
	_tmp36_[0] = _tmp35_;
	_tmp37_ = _tmp36_;
	_tmp37__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) _tmp34_, APP_WINDOW_ACTION_PREFIX APP_WINDOW_ACTION_UNDO, _tmp37_);
	_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
	_tmp38_ = gtk_css_provider_new ();
	css_provider = _tmp38_;
	_tmp39_ = css_provider;
	gtk_css_provider_load_from_resource (_tmp39_, "io/elementary/photos/application.css");
	_tmp40_ = gdk_screen_get_default ();
	_tmp41_ = css_provider;
	gtk_style_context_add_provider_for_screen (_tmp40_, (GtkStyleProvider*) _tmp41_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp42_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_WINDOW_PREFS_SCHEMA_NAME);
	_g_object_unref0 (self->window_settings);
	self->window_settings = _tmp42_;
	_tmp44_ = app_window_create_common_action_groups (self, &_tmp43_);
	self->common_action_groups = (_vala_array_free (self->common_action_groups, self->common_action_groups_length1, (GDestroyNotify) g_object_unref), NULL);
	self->common_action_groups = _tmp44_;
	self->common_action_groups_length1 = _tmp43_;
	_tmp45_ = self->common_action_groups;
	_tmp45__length1 = self->common_action_groups_length1;
	{
		GtkActionGroup** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp45_;
		group_collection_length1 = _tmp45__length1;
		for (group_it = 0; group_it < group_collection_length1; group_it = group_it + 1) {
			GtkActionGroup* _tmp46_;
			GtkActionGroup* group = NULL;
			_tmp46_ = _g_object_ref0 (group_collection[group_it]);
			group = _tmp46_;
			{
				GtkUIManager* _tmp47_;
				GtkActionGroup* _tmp48_;
				_tmp47_ = ((PageWindow*) self)->ui;
				_tmp48_ = group;
				gtk_ui_manager_insert_action_group (_tmp47_, _tmp48_, 0);
				_g_object_unref0 (group);
			}
		}
	}
	{
		GtkUIManager* _tmp49_;
		GtkActionGroup** _tmp50_;
		gint _tmp50__length1;
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp49_ = ((PageWindow*) self)->ui;
		_tmp50_ = self->common_action_groups;
		_tmp50__length1 = self->common_action_groups_length1;
		_tmp51_ = build_dummy_ui_string (_tmp50_, (gint) _tmp50__length1);
		_tmp52_ = _tmp51_;
		gtk_ui_manager_add_ui_from_string (_tmp49_, _tmp52_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp52_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp53_;
		const gchar* _tmp54_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp53_ = err;
		_tmp54_ = _tmp53_->message;
		g_error ("AppWindow.vala:119: Unable to add AppWindow UI: %s", _tmp54_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp55_ = ((PageWindow*) self)->ui;
	gtk_ui_manager_ensure_update (_tmp55_);
	_tmp56_ = ((PageWindow*) self)->ui;
	_tmp57_ = gtk_ui_manager_get_accel_group (_tmp56_);
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp57_);
	_g_object_unref0 (css_provider);
	return obj;
}

static void
app_window_class_init (AppWindowClass * klass,
                       gpointer klass_data)
{
	app_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AppWindow_private_offset);
	((AppWindowClass *) klass)->on_fullscreen = (void (*) (AppWindow*)) app_window_real_on_fullscreen;
	((AppWindowClass *) klass)->get_app_role = (gchar* (*) (AppWindow*)) app_window_real_get_app_role;
	((AppWindowClass *) klass)->on_quit = (void (*) (AppWindow*)) app_window_real_on_quit;
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) app_window_real_destroy;
	((AppWindowClass *) klass)->create_common_action_groups = (GtkActionGroup** (*) (AppWindow*, gint*)) app_window_real_create_common_action_groups;
	((PageWindowClass *) klass)->switched_pages = (void (*) (PageWindow*, Page*, Page*)) app_window_real_switched_pages;
	((AppWindowClass *) klass)->update_common_action_availability = (void (*) (AppWindow*, Page*, Page*)) app_window_real_update_common_action_availability;
	((AppWindowClass *) klass)->update_common_actions = (void (*) (AppWindow*, Page*, gint, gint)) app_window_real_update_common_actions;
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) app_window_real_configure_event;
	G_OBJECT_CLASS (klass)->constructor = app_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = app_window_finalize;
}

static void
app_window_instance_init (AppWindow * self,
                          gpointer klass)
{
	self->priv = app_window_get_instance_private (self);
	self->priv->pos_x = 0;
	self->priv->pos_y = 0;
}

static void
app_window_finalize (GObject * obj)
{
	AppWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APP_WINDOW, AppWindow);
	self->common_action_groups = (_vala_array_free (self->common_action_groups, self->common_action_groups_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->header);
	_g_object_unref0 (self->redo_btn);
	_g_object_unref0 (self->undo_btn);
	_g_object_unref0 (self->window_settings);
	G_OBJECT_CLASS (app_window_parent_class)->finalize (obj);
}

static GType
app_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AppWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppWindow), 0, (GInstanceInitFunc) app_window_instance_init, NULL };
	GType app_window_type_id;
	app_window_type_id = g_type_register_static (TYPE_PAGE_WINDOW, "AppWindow", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	AppWindow_private_offset = g_type_add_instance_private (app_window_type_id, sizeof (AppWindowPrivate));
	return app_window_type_id;
}

GType
app_window_get_type (void)
{
	static volatile gsize app_window_type_id__once = 0;
	if (g_once_init_enter (&app_window_type_id__once)) {
		GType app_window_type_id;
		app_window_type_id = app_window_get_type_once ();
		g_once_init_leave (&app_window_type_id__once, app_window_type_id);
	}
	return app_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

