/* EventTable.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from EventTable.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <string.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecEventRow ParamSpecEventRow;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))
#define _event_row_unref0(var) ((var == NULL) ? NULL : (var = (event_row_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ParamSpecEventRow {
	GParamSpec parent_instance;
};

static gpointer event_row_parent_class = NULL;
static gpointer event_table_parent_class = NULL;
static EventTable* event_table_instance;
static EventTable* event_table_instance = NULL;

static void event_row_finalize (EventRow * obj);
static GType event_row_get_type_once (void);
static EventTable* event_table_new (void);
static EventTable* event_table_construct (GType object_type);
static gchar* event_table_source_id_upgrade (EventTable* self,
                                      gint64 primary_photo_id,
                                      const gchar* primary_source_id);
static void event_table_finalize (DatabaseTable * obj);
static GType event_table_get_type_once (void);

void
event_id_init (EventID *self,
               gint64 id)
{
	memset (self, 0, sizeof (EventID));
	(*self).id = id;
}

gboolean
event_id_is_invalid (EventID *self)
{
	gboolean result;
	result = (*self).id == EVENT_ID_INVALID;
	return result;
}

gboolean
event_id_is_valid (EventID *self)
{
	gboolean result;
	result = (*self).id != EVENT_ID_INVALID;
	return result;
}

EventID*
event_id_dup (const EventID* self)
{
	EventID* dup;
	dup = g_new0 (EventID, 1);
	memcpy (dup, self, sizeof (EventID));
	return dup;
}

void
event_id_free (EventID* self)
{
	g_free (self);
}

static GType
event_id_get_type_once (void)
{
	GType event_id_type_id;
	event_id_type_id = g_boxed_type_register_static ("EventID", (GBoxedCopyFunc) event_id_dup, (GBoxedFreeFunc) event_id_free);
	return event_id_type_id;
}

GType
event_id_get_type (void)
{
	static volatile gsize event_id_type_id__once = 0;
	if (g_once_init_enter (&event_id_type_id__once)) {
		GType event_id_type_id;
		event_id_type_id = event_id_get_type_once ();
		g_once_init_leave (&event_id_type_id__once, event_id_type_id);
	}
	return event_id_type_id__once;
}

EventRow*
event_row_construct (GType object_type)
{
	EventRow* self = NULL;
	self = (EventRow*) g_type_create_instance (object_type);
	return self;
}

EventRow*
event_row_new (void)
{
	return event_row_construct (TYPE_EVENT_ROW);
}

static void
value_event_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_event_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		event_row_unref (value->data[0].v_pointer);
	}
}

static void
value_event_row_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = event_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_event_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_event_row_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		EventRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = event_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_event_row_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	EventRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = event_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_event_row (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecEventRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EVENT_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_event_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT_ROW), NULL);
	return value->data[0].v_pointer;
}

void
value_set_event_row (GValue* value,
                     gpointer v_object)
{
	EventRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		event_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		event_row_unref (old);
	}
}

void
value_take_event_row (GValue* value,
                      gpointer v_object)
{
	EventRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		event_row_unref (old);
	}
}

static void
event_row_class_init (EventRowClass * klass,
                      gpointer klass_data)
{
	event_row_parent_class = g_type_class_peek_parent (klass);
	((EventRowClass *) klass)->finalize = event_row_finalize;
}

static void
event_row_instance_init (EventRow * self,
                         gpointer klass)
{
	self->ref_count = 1;
}

static void
event_row_finalize (EventRow * obj)
{
	EventRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT_ROW, EventRow);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_free0 (self->primary_source_id);
	_g_free0 (self->comment);
}

static GType
event_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_event_row_init, value_event_row_free_value, value_event_row_copy_value, value_event_row_peek_pointer, "p", value_event_row_collect_value, "p", value_event_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EventRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventRow), 0, (GInstanceInitFunc) event_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType event_row_type_id;
	event_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EventRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return event_row_type_id;
}

GType
event_row_get_type (void)
{
	static volatile gsize event_row_type_id__once = 0;
	if (g_once_init_enter (&event_row_type_id__once)) {
		GType event_row_type_id;
		event_row_type_id = event_row_get_type_once ();
		g_once_init_leave (&event_row_type_id__once, event_row_type_id);
	}
	return event_row_type_id__once;
}

gpointer
event_row_ref (gpointer instance)
{
	EventRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
event_row_unref (gpointer instance)
{
	EventRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EVENT_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static EventTable*
event_table_construct (GType object_type)
{
	EventTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	self = (EventTable*) database_table_construct (object_type);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE TABLE IF NOT EXISTS EventTable (" "id INTEGER PRIMARY KEY, " "name TEXT, " "primary_photo_id INTEGER, " "time_created INTEGER," "primary_source_id TEXT," "comment TEXT" ")");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_step (_tmp1_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create photo table", res);
	}
	database_table_set_table_name ((DatabaseTable*) self, "EventTable");
	_sqlite3_finalize0 (stmt);
	return self;
}

static EventTable*
event_table_new (void)
{
	return event_table_construct (TYPE_EVENT_TABLE);
}

static gpointer
_database_table_ref0 (gpointer self)
{
	return self ? database_table_ref (self) : NULL;
}

EventTable*
event_table_get_instance (void)
{
	EventTable* _tmp0_;
	EventTable* _tmp2_;
	EventTable* _tmp3_;
	EventTable* result;
	_tmp0_ = event_table_instance;
	if (_tmp0_ == NULL) {
		EventTable* _tmp1_;
		_tmp1_ = event_table_new ();
		_database_table_unref0 (event_table_instance);
		event_table_instance = _tmp1_;
	}
	_tmp2_ = event_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gchar*
event_table_source_id_upgrade (EventTable* self,
                               gint64 primary_photo_id,
                               const gchar* primary_source_id)
{
	MediaCollectionRegistry* _tmp0_;
	MediaCollectionRegistry* _tmp1_;
	gboolean _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = media_collection_registry_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = media_collection_registry_is_valid_source_id (_tmp1_, primary_source_id);
	_media_collection_registry_unref0 (_tmp1_);
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (primary_source_id);
		result = _tmp3_;
		return result;
	}
	if (primary_photo_id != PHOTO_ID_INVALID) {
		PhotoID _tmp4_ = {0};
		gchar* _tmp5_;
		photo_id_init (&_tmp4_, primary_photo_id);
		_tmp5_ = photo_id_upgrade_photo_id_to_source_id (&_tmp4_);
		result = _tmp5_;
		return result;
	}
	result = NULL;
	return result;
}

EventRow*
event_table_create (EventTable* self,
                    const gchar* primary_source_id,
                    const gchar* comment,
                    GError** error)
{
	gboolean _tmp0_ = FALSE;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp1_;
	gint64 time_created = 0LL;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint res = 0;
	sqlite3_stmt* _tmp5_;
	EventRow* row = NULL;
	EventRow* _tmp6_;
	EventRow* _tmp7_;
	sqlite3* _tmp8_;
	EventRow* _tmp9_;
	EventRow* _tmp10_;
	gchar* _tmp11_;
	EventRow* _tmp12_;
	EventRow* _tmp13_;
	gchar* _tmp14_;
	GError* _inner_error0_ = NULL;
	EventRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (primary_source_id != NULL) {
		_tmp0_ = g_strcmp0 (primary_source_id, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "primary_source_id != null && primary_source_id != \"\"");
	_tmp1_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO EventTable (primary_source_id, time_created, comment) VALU" \
"ES (?, ?, ?)");
	stmt = _tmp1_;
	time_created = now_sec ();
	_tmp2_ = stmt;
	database_table_bind_text (_tmp2_, 1, primary_source_id);
	_tmp3_ = stmt;
	database_table_bind_int64 (_tmp3_, 2, time_created);
	_tmp4_ = stmt;
	database_table_bind_text (_tmp4_, 3, comment);
	_tmp5_ = stmt;
	res = sqlite3_step (_tmp5_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("EventTable.create", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return NULL;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp6_ = event_row_new ();
	row = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = database_table_db;
	event_id_init (&_tmp7_->event_id, sqlite3_last_insert_rowid (_tmp8_));
	_tmp9_ = row;
	_g_free0 (_tmp9_->name);
	_tmp9_->name = NULL;
	_tmp10_ = row;
	_tmp11_ = g_strdup (primary_source_id);
	_g_free0 (_tmp10_->primary_source_id);
	_tmp10_->primary_source_id = _tmp11_;
	_tmp12_ = row;
	_tmp12_->time_created = time_created;
	_tmp13_ = row;
	_tmp14_ = g_strdup (comment);
	_g_free0 (_tmp13_->comment);
	_tmp13_->comment = _tmp14_;
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
event_table_create_from_row (EventTable* self,
                             EventRow* row,
                             EventID* result)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	const gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_;
	sqlite3_stmt* _tmp6_;
	sqlite3_stmt* _tmp7_;
	const gchar* _tmp8_;
	gint res = 0;
	sqlite3_stmt* _tmp9_;
	sqlite3* _tmp11_;
	EventID _tmp12_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO EventTable (name, primary_photo_id, primary_source_id, tim" \
"e_created, comment) VALUES (?, ?, ?, ?, ?)");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = row->name;
	database_table_bind_text (_tmp1_, 1, _tmp2_);
	_tmp3_ = stmt;
	database_table_bind_int64 (_tmp3_, 2, PHOTO_ID_INVALID);
	_tmp4_ = stmt;
	_tmp5_ = row->primary_source_id;
	database_table_bind_text (_tmp4_, 3, _tmp5_);
	_tmp6_ = stmt;
	database_table_bind_int64 (_tmp6_, 4, row->time_created);
	_tmp7_ = stmt;
	_tmp8_ = row->comment;
	database_table_bind_text (_tmp7_, 5, _tmp8_);
	_tmp9_ = stmt;
	res = sqlite3_step (_tmp9_);
	if (res != SQLITE_DONE) {
		EventID _tmp10_ = {0};
		database_table_fatal ("Event create_from_row", res);
		event_id_init (&_tmp10_, EVENT_ID_INVALID);
		*result = _tmp10_;
		_sqlite3_finalize0 (stmt);
		return;
	}
	_tmp11_ = database_table_db;
	event_id_init (&_tmp12_, sqlite3_last_insert_rowid (_tmp11_));
	*result = _tmp12_;
	_sqlite3_finalize0 (stmt);
	return;
}

EventRow*
event_table_get_row (EventTable* self,
                     EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	EventID _tmp2_;
	sqlite3_stmt* _tmp3_;
	EventRow* row = NULL;
	EventRow* _tmp4_;
	EventRow* _tmp5_;
	EventID _tmp6_;
	EventRow* _tmp7_;
	sqlite3_stmt* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	EventRow* _tmp12_;
	const gchar* _tmp13_;
	EventRow* _tmp19_;
	sqlite3_stmt* _tmp20_;
	sqlite3_stmt* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	EventRow* _tmp24_;
	sqlite3_stmt* _tmp25_;
	EventRow* _tmp26_;
	sqlite3_stmt* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	EventRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT name, primary_photo_id, primary_source_id, time_created, commen" \
"t FROM EventTable WHERE id=?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = *event_id;
	database_table_bind_int64 (_tmp1_, 1, _tmp2_.id);
	_tmp3_ = stmt;
	if (sqlite3_step (_tmp3_) != SQLITE_ROW) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp4_ = event_row_new ();
	row = _tmp4_;
	_tmp5_ = row;
	_tmp6_ = *event_id;
	_tmp5_->event_id = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = stmt;
	_tmp9_ = (const gchar*) sqlite3_column_text (_tmp8_, 0);
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (_tmp7_->name);
	_tmp7_->name = _tmp10_;
	_tmp12_ = row;
	_tmp13_ = _tmp12_->name;
	if (_tmp13_ != NULL) {
		EventRow* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp14_ = row;
		_tmp15_ = _tmp14_->name;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp11_ = _tmp17_ == 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		EventRow* _tmp18_;
		_tmp18_ = row;
		_g_free0 (_tmp18_->name);
		_tmp18_->name = NULL;
	}
	_tmp19_ = row;
	_tmp20_ = stmt;
	_tmp21_ = stmt;
	_tmp22_ = (const gchar*) sqlite3_column_text (_tmp21_, 2);
	_tmp23_ = event_table_source_id_upgrade (self, sqlite3_column_int64 (_tmp20_, 1), _tmp22_);
	_g_free0 (_tmp19_->primary_source_id);
	_tmp19_->primary_source_id = _tmp23_;
	_tmp24_ = row;
	_tmp25_ = stmt;
	_tmp24_->time_created = sqlite3_column_int64 (_tmp25_, 3);
	_tmp26_ = row;
	_tmp27_ = stmt;
	_tmp28_ = (const gchar*) sqlite3_column_text (_tmp27_, 4);
	_tmp29_ = g_strdup (_tmp28_);
	_g_free0 (_tmp26_->comment);
	_tmp26_->comment = _tmp29_;
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
event_table_remove (EventTable* self,
                    EventID* event_id,
                    GError** error)
{
	EventID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event_id != NULL);
	_tmp0_ = *event_id;
	database_table_delete_by_id ((DatabaseTable*) self, _tmp0_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

GeeArrayList*
event_table_get_events (EventTable* self)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	GeeArrayList* event_rows = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT id, name, primary_photo_id, primary_source_id, time_created, co" \
"mment FROM EventTable");
	stmt = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_EVENT_ROW, (GBoxedCopyFunc) event_row_ref, (GDestroyNotify) event_row_unref, NULL, NULL, NULL);
	event_rows = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			gint res = 0;
			sqlite3_stmt* _tmp3_;
			EventRow* row = NULL;
			EventRow* _tmp4_;
			EventRow* _tmp5_;
			sqlite3_stmt* _tmp6_;
			EventRow* _tmp7_;
			sqlite3_stmt* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			EventRow* _tmp11_;
			sqlite3_stmt* _tmp12_;
			sqlite3_stmt* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			EventRow* _tmp16_;
			sqlite3_stmt* _tmp17_;
			EventRow* _tmp18_;
			sqlite3_stmt* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			GeeArrayList* _tmp22_;
			EventRow* _tmp23_;
			if (!_tmp2_) {
			}
			_tmp2_ = FALSE;
			_tmp3_ = stmt;
			res = sqlite3_step (_tmp3_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_fatal ("get_events", res);
					break;
				}
			}
			_tmp4_ = event_row_new ();
			row = _tmp4_;
			_tmp5_ = row;
			_tmp6_ = stmt;
			event_id_init (&_tmp5_->event_id, sqlite3_column_int64 (_tmp6_, 0));
			_tmp7_ = row;
			_tmp8_ = stmt;
			_tmp9_ = (const gchar*) sqlite3_column_text (_tmp8_, 1);
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (_tmp7_->name);
			_tmp7_->name = _tmp10_;
			_tmp11_ = row;
			_tmp12_ = stmt;
			_tmp13_ = stmt;
			_tmp14_ = (const gchar*) sqlite3_column_text (_tmp13_, 3);
			_tmp15_ = event_table_source_id_upgrade (self, sqlite3_column_int64 (_tmp12_, 2), _tmp14_);
			_g_free0 (_tmp11_->primary_source_id);
			_tmp11_->primary_source_id = _tmp15_;
			_tmp16_ = row;
			_tmp17_ = stmt;
			_tmp16_->time_created = sqlite3_column_int64 (_tmp17_, 4);
			_tmp18_ = row;
			_tmp19_ = stmt;
			_tmp20_ = (const gchar*) sqlite3_column_text (_tmp19_, 5);
			_tmp21_ = g_strdup (_tmp20_);
			_g_free0 (_tmp18_->comment);
			_tmp18_->comment = _tmp21_;
			_tmp22_ = event_rows;
			_tmp23_ = row;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
			_event_row_unref0 (row);
		}
	}
	result = event_rows;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
event_table_rename (EventTable* self,
                    EventID* event_id,
                    const gchar* name)
{
	const gchar* _tmp0_ = NULL;
	EventID _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	if (name != NULL) {
		_tmp0_ = name;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *event_id;
	result = database_table_update_text_by_id ((DatabaseTable*) self, _tmp1_.id, "name", _tmp0_);
	return result;
}

gchar*
event_table_get_name (EventTable* self,
                      EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	EventID _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gboolean _tmp2_;
	gchar* name = NULL;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = *event_id;
	_tmp2_ = database_table_select_by_id ((DatabaseTable*) self, _tmp0_.id, "name", &_tmp1_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	if (!_tmp2_) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp3_ = stmt;
	_tmp4_ = (const gchar*) sqlite3_column_text (_tmp3_, 0);
	_tmp5_ = g_strdup (_tmp4_);
	name = _tmp5_;
	_tmp8_ = name;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp9_ = name;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp7_ = _tmp11_ > 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		const gchar* _tmp12_;
		_tmp12_ = name;
		_tmp6_ = _tmp12_;
	} else {
		_tmp6_ = NULL;
	}
	_tmp13_ = g_strdup (_tmp6_);
	result = _tmp13_;
	_g_free0 (name);
	_sqlite3_finalize0 (stmt);
	return result;
}

gchar*
event_table_get_primary_source_id (EventTable* self,
                                   EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	EventID _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gboolean _tmp2_;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = *event_id;
	_tmp2_ = database_table_select_by_id ((DatabaseTable*) self, _tmp0_.id, "primary_source_id", &_tmp1_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	if (!_tmp2_) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp3_ = stmt;
	_tmp4_ = (const gchar*) sqlite3_column_text (_tmp3_, 0);
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
event_table_set_primary_source_id (EventTable* self,
                                   EventID* event_id,
                                   const gchar* primary_source_id)
{
	EventID _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	g_return_val_if_fail (primary_source_id != NULL, FALSE);
	_tmp0_ = *event_id;
	result = database_table_update_text_by_id ((DatabaseTable*) self, _tmp0_.id, "primary_source_id", primary_source_id);
	return result;
}

gint64
event_table_get_time_created (EventTable* self,
                              EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	EventID _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gboolean _tmp2_;
	sqlite3_stmt* _tmp3_;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (event_id != NULL, 0LL);
	_tmp0_ = *event_id;
	_tmp2_ = database_table_select_by_id ((DatabaseTable*) self, _tmp0_.id, "time_created", &_tmp1_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	if (!_tmp2_) {
		result = (gint64) 0;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp3_ = stmt;
	result = sqlite3_column_int64 (_tmp3_, 0);
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
event_table_set_comment (EventTable* self,
                         EventID* event_id,
                         const gchar* new_comment)
{
	const gchar* _tmp0_ = NULL;
	EventID _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	g_return_val_if_fail (new_comment != NULL, FALSE);
	if (new_comment != NULL) {
		_tmp0_ = new_comment;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *event_id;
	result = database_table_update_text_by_id ((DatabaseTable*) self, _tmp1_.id, "comment", _tmp0_);
	return result;
}

static void
event_table_class_init (EventTableClass * klass,
                        gpointer klass_data)
{
	event_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = event_table_finalize;
}

static void
event_table_instance_init (EventTable * self,
                           gpointer klass)
{
}

static void
event_table_finalize (DatabaseTable * obj)
{
	EventTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT_TABLE, EventTable);
	DATABASE_TABLE_CLASS (event_table_parent_class)->finalize (obj);
}

static GType
event_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventTable), 0, (GInstanceInitFunc) event_table_instance_init, NULL };
	GType event_table_type_id;
	event_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "EventTable", &g_define_type_info, 0);
	return event_table_type_id;
}

GType
event_table_get_type (void)
{
	static volatile gsize event_table_type_id__once = 0;
	if (g_once_init_enter (&event_table_type_id__once)) {
		GType event_table_type_id;
		event_table_type_id = event_table_get_type_once ();
		g_once_init_leave (&event_table_type_id__once, event_table_type_id);
	}
	return event_table_type_id__once;
}

