/* SpitInterfaces.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SpitInterfaces.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static void spit_module_real_reserved0 (SpitModule* self);
static void spit_module_real_reserved1 (SpitModule* self);
static void spit_module_real_reserved2 (SpitModule* self);
static void spit_module_real_reserved3 (SpitModule* self);
static void spit_module_real_reserved4 (SpitModule* self);
static void spit_module_real_reserved5 (SpitModule* self);
static void spit_module_real_reserved6 (SpitModule* self);
static void spit_module_real_reserved7 (SpitModule* self);
static GType spit_module_get_type_once (void);
static void spit_pluggable_real_reserved0 (SpitPluggable* self);
static void spit_pluggable_real_reserved1 (SpitPluggable* self);
static void spit_pluggable_real_reserved2 (SpitPluggable* self);
static void spit_pluggable_real_reserved3 (SpitPluggable* self);
static void spit_pluggable_real_reserved4 (SpitPluggable* self);
static void spit_pluggable_real_reserved5 (SpitPluggable* self);
static void spit_pluggable_real_reserved6 (SpitPluggable* self);
static void spit_pluggable_real_reserved7 (SpitPluggable* self);
static GType spit_pluggable_get_type_once (void);
static void spit_host_interface_real_reserved0 (SpitHostInterface* self);
static void spit_host_interface_real_reserved1 (SpitHostInterface* self);
static void spit_host_interface_real_reserved2 (SpitHostInterface* self);
static void spit_host_interface_real_reserved3 (SpitHostInterface* self);
static void spit_host_interface_real_reserved4 (SpitHostInterface* self);
static void spit_host_interface_real_reserved5 (SpitHostInterface* self);
static void spit_host_interface_real_reserved6 (SpitHostInterface* self);
static void spit_host_interface_real_reserved7 (SpitHostInterface* self);
static GType spit_host_interface_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
 * A utility function for checking host interfaces against one's own and returning the right value.
 *
 * Note that this only works if the caller operates on only one interface version (and cannot mutate
 * between multiple ones).
 *
 * @param min_host_interface The minimum supported host interface version.
 * @param max_host_interface The maximum supported host interface version.
 * @param plugin_interface The interface version supported by the Pluggable.
 *
 * @return The plugin's interface version if supported, {@link UNSUPPORTED_INTERFACE} otherwise.
 */
gint
spit_negotiate_interfaces (gint min_host_interface,
                           gint max_host_interface,
                           gint plugin_interface)
{
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint result;
	if (min_host_interface > plugin_interface) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = max_host_interface < plugin_interface;
	}
	if (_tmp1_) {
		_tmp0_ = SPIT_UNSUPPORTED_INTERFACE;
	} else {
		_tmp0_ = plugin_interface;
	}
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
spit_entry_point_params_copy (const SpitEntryPointParams* self,
                              SpitEntryPointParams* dest)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	(*dest).host_min_spit_interface = (*self).host_min_spit_interface;
	(*dest).host_max_spit_interface = (*self).host_max_spit_interface;
	(*dest).module_spit_interface = (*self).module_spit_interface;
	_tmp0_ = (*self).module_file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).module_file);
	(*dest).module_file = _tmp1_;
}

void
spit_entry_point_params_destroy (SpitEntryPointParams* self)
{
	_g_object_unref0 ((*self).module_file);
}

SpitEntryPointParams*
spit_entry_point_params_dup (const SpitEntryPointParams* self)
{
	SpitEntryPointParams* dup;
	dup = g_new0 (SpitEntryPointParams, 1);
	spit_entry_point_params_copy (self, dup);
	return dup;
}

void
spit_entry_point_params_free (SpitEntryPointParams* self)
{
	spit_entry_point_params_destroy (self);
	g_free (self);
}

static GType
spit_entry_point_params_get_type_once (void)
{
	GType spit_entry_point_params_type_id;
	spit_entry_point_params_type_id = g_boxed_type_register_static ("SpitEntryPointParams", (GBoxedCopyFunc) spit_entry_point_params_dup, (GBoxedFreeFunc) spit_entry_point_params_free);
	return spit_entry_point_params_type_id;
}

GType
spit_entry_point_params_get_type (void)
{
	static volatile gsize spit_entry_point_params_type_id__once = 0;
	if (g_once_init_enter (&spit_entry_point_params_type_id__once)) {
		GType spit_entry_point_params_type_id;
		spit_entry_point_params_type_id = spit_entry_point_params_get_type_once ();
		g_once_init_leave (&spit_entry_point_params_type_id__once, spit_entry_point_params_type_id);
	}
	return spit_entry_point_params_type_id__once;
}

/**
     * Returns a user-visible string describing the module.
     */
const gchar*
spit_module_get_module_name (SpitModule* self)
{
	SpitModuleIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SPIT_MODULE_GET_INTERFACE (self);
	if (_iface_->get_module_name) {
		return _iface_->get_module_name (self);
	}
	return NULL;
}

/**
     * Returns a user-visible string describing the module version.
     *
     * Note that this may be programmatically interpreted at some point, so use a widespread
     * versioning scheme.
     */
const gchar*
spit_module_get_version (SpitModule* self)
{
	SpitModuleIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SPIT_MODULE_GET_INTERFACE (self);
	if (_iface_->get_version) {
		return _iface_->get_version (self);
	}
	return NULL;
}

/**
     * Returns a unique identifier for this module.
     *
     * This is used to differentiate between multiple
     * installed versions and to determine which one should be used (i.e. if a module is available
     * in a system directory and a user directory). This name is case-sensitive.
     *
     * Best practice: use a reverse-DNS-order scheme, a la Java's packages
     * (i.e. "org.yorba.shotwell.frotz").
     */
const gchar*
spit_module_get_id (SpitModule* self)
{
	SpitModuleIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SPIT_MODULE_GET_INTERFACE (self);
	if (_iface_->get_id) {
		return _iface_->get_id (self);
	}
	return NULL;
}

/**
     * Returns an array of {@link Pluggable} that represent each plugin available in the module.
     *
     * May return NULL or an empty array.
     */
SpitPluggable**
spit_module_get_pluggables (SpitModule* self,
                            gint* result_length1)
{
	SpitModuleIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SPIT_MODULE_GET_INTERFACE (self);
	if (_iface_->get_pluggables) {
		return _iface_->get_pluggables (self, result_length1);
	}
	return NULL;
}

static void
spit_module_real_reserved0 (SpitModule* self)
{
}

void
spit_module_reserved0 (SpitModule* self)
{
	SpitModuleIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_MODULE_GET_INTERFACE (self);
	if (_iface_->reserved0) {
		_iface_->reserved0 (self);
	}
}

static void
spit_module_real_reserved1 (SpitModule* self)
{
}

void
spit_module_reserved1 (SpitModule* self)
{
	SpitModuleIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_MODULE_GET_INTERFACE (self);
	if (_iface_->reserved1) {
		_iface_->reserved1 (self);
	}
}

static void
spit_module_real_reserved2 (SpitModule* self)
{
}

void
spit_module_reserved2 (SpitModule* self)
{
	SpitModuleIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_MODULE_GET_INTERFACE (self);
	if (_iface_->reserved2) {
		_iface_->reserved2 (self);
	}
}

static void
spit_module_real_reserved3 (SpitModule* self)
{
}

void
spit_module_reserved3 (SpitModule* self)
{
	SpitModuleIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_MODULE_GET_INTERFACE (self);
	if (_iface_->reserved3) {
		_iface_->reserved3 (self);
	}
}

static void
spit_module_real_reserved4 (SpitModule* self)
{
}

void
spit_module_reserved4 (SpitModule* self)
{
	SpitModuleIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_MODULE_GET_INTERFACE (self);
	if (_iface_->reserved4) {
		_iface_->reserved4 (self);
	}
}

static void
spit_module_real_reserved5 (SpitModule* self)
{
}

void
spit_module_reserved5 (SpitModule* self)
{
	SpitModuleIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_MODULE_GET_INTERFACE (self);
	if (_iface_->reserved5) {
		_iface_->reserved5 (self);
	}
}

static void
spit_module_real_reserved6 (SpitModule* self)
{
}

void
spit_module_reserved6 (SpitModule* self)
{
	SpitModuleIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_MODULE_GET_INTERFACE (self);
	if (_iface_->reserved6) {
		_iface_->reserved6 (self);
	}
}

static void
spit_module_real_reserved7 (SpitModule* self)
{
}

void
spit_module_reserved7 (SpitModule* self)
{
	SpitModuleIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_MODULE_GET_INTERFACE (self);
	if (_iface_->reserved7) {
		_iface_->reserved7 (self);
	}
}

static void
spit_module_default_init (SpitModuleIface * iface,
                          gpointer iface_data)
{
	iface->reserved0 = spit_module_real_reserved0;
	iface->reserved1 = spit_module_real_reserved1;
	iface->reserved2 = spit_module_real_reserved2;
	iface->reserved3 = spit_module_real_reserved3;
	iface->reserved4 = spit_module_real_reserved4;
	iface->reserved5 = spit_module_real_reserved5;
	iface->reserved6 = spit_module_real_reserved6;
	iface->reserved7 = spit_module_real_reserved7;
}

/**
 * A Module represents the resources of an entire dynamically-linked module (i.e. a .so/.la).
 *
 * A module holds zero or more Photos plugins ({@link Pluggable}). Once the module has been
 * loaded into process space this object is retrieved by Photos. All calls to the module and
 * its plugins are resolved through this interface.
 *
 * Note: The module is responsible for holding the reference to the Module object, of which there
 * should be only one in the library file. The module should implement a g_module_unload method
 * and drop the reference there.
 */
static GType
spit_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitModuleIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_module_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_module_type_id;
	spit_module_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitModule", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_module_type_id, G_TYPE_OBJECT);
	return spit_module_type_id;
}

GType
spit_module_get_type (void)
{
	static volatile gsize spit_module_type_id__once = 0;
	if (g_once_init_enter (&spit_module_type_id__once)) {
		GType spit_module_type_id;
		spit_module_type_id = spit_module_get_type_once ();
		g_once_init_leave (&spit_module_type_id__once, spit_module_type_id);
	}
	return spit_module_type_id__once;
}

void
spit_pluggable_info_copy (const SpitPluggableInfo* self,
                          SpitPluggableInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GIcon* _tmp16_;
	GIcon* _tmp17_;
	_tmp0_ = (*self).version;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).version);
	(*dest).version = _tmp1_;
	_tmp2_ = (*self).brief_description;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).brief_description);
	(*dest).brief_description = _tmp3_;
	_tmp4_ = (*self).authors;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).authors);
	(*dest).authors = _tmp5_;
	_tmp6_ = (*self).copyright;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).copyright);
	(*dest).copyright = _tmp7_;
	_tmp8_ = (*self).license;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 ((*dest).license);
	(*dest).license = _tmp9_;
	(*dest).is_license_wordwrapped = (*self).is_license_wordwrapped;
	_tmp10_ = (*self).website_url;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 ((*dest).website_url);
	(*dest).website_url = _tmp11_;
	_tmp12_ = (*self).website_name;
	_tmp13_ = g_strdup (_tmp12_);
	_g_free0 ((*dest).website_name);
	(*dest).website_name = _tmp13_;
	_tmp14_ = (*self).translators;
	_tmp15_ = g_strdup (_tmp14_);
	_g_free0 ((*dest).translators);
	(*dest).translators = _tmp15_;
	_tmp16_ = (*self).icon;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 ((*dest).icon);
	(*dest).icon = _tmp17_;
}

void
spit_pluggable_info_destroy (SpitPluggableInfo* self)
{
	_g_free0 ((*self).version);
	_g_free0 ((*self).brief_description);
	_g_free0 ((*self).authors);
	_g_free0 ((*self).copyright);
	_g_free0 ((*self).license);
	_g_free0 ((*self).website_url);
	_g_free0 ((*self).website_name);
	_g_free0 ((*self).translators);
	_g_object_unref0 ((*self).icon);
}

SpitPluggableInfo*
spit_pluggable_info_dup (const SpitPluggableInfo* self)
{
	SpitPluggableInfo* dup;
	dup = g_new0 (SpitPluggableInfo, 1);
	spit_pluggable_info_copy (self, dup);
	return dup;
}

void
spit_pluggable_info_free (SpitPluggableInfo* self)
{
	spit_pluggable_info_destroy (self);
	g_free (self);
}

static GType
spit_pluggable_info_get_type_once (void)
{
	GType spit_pluggable_info_type_id;
	spit_pluggable_info_type_id = g_boxed_type_register_static ("SpitPluggableInfo", (GBoxedCopyFunc) spit_pluggable_info_dup, (GBoxedFreeFunc) spit_pluggable_info_free);
	return spit_pluggable_info_type_id;
}

GType
spit_pluggable_info_get_type (void)
{
	static volatile gsize spit_pluggable_info_type_id__once = 0;
	if (g_once_init_enter (&spit_pluggable_info_type_id__once)) {
		GType spit_pluggable_info_type_id;
		spit_pluggable_info_type_id = spit_pluggable_info_get_type_once ();
		g_once_init_leave (&spit_pluggable_info_type_id__once, spit_pluggable_info_type_id);
	}
	return spit_pluggable_info_type_id__once;
}

/**
     * Pluggable interface version negotiation.
     *
     * Like the {@link EntryPoint}, this mechanism allows for the host to negotiate with the Pluggable
     * for its interface version. If the pluggable does not support an interface between the
     * two ranges (inclusive), it should return {@link UNSUPPORTED_INTERFACE}.
     *
     * Note that this is ''not'' a negotiation of the SPIT interface versions (which is the
     * responsibility of {@link EntryPoint}. Rather, each extension point is expected to version
     * its own cluster of interfaces. It is that interface version that is being negotiated here.
     *
     * {@link negotiate_interfaces} can be used to implement this method.
     *
     * @param min_host_interface The host's minimum supported interface version number
     *        //for this Pluggable's intended extension point//.
     * @param max_host_interface The host's maximum supported interface version number
     *        //for this Pluggable's intended extension point//.
     *
     * @return The version number supported by the host and the Pluggable or
     *         {@link UNSUPPORTED_INTERFACE}.
     */
gint
spit_pluggable_get_pluggable_interface (SpitPluggable* self,
                                        gint min_host_interface,
                                        gint max_host_interface)
{
	SpitPluggableIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = SPIT_PLUGGABLE_GET_INTERFACE (self);
	if (_iface_->get_pluggable_interface) {
		return _iface_->get_pluggable_interface (self, min_host_interface, max_host_interface);
	}
	return -1;
}

/**
     * Returns a unique identifier for this Pluggable.
     *
     * Like {@link Module.get_id}, best practice is to use a reverse-DNS-order scheme to avoid
     * conflicts.
     */
const gchar*
spit_pluggable_get_id (SpitPluggable* self)
{
	SpitPluggableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SPIT_PLUGGABLE_GET_INTERFACE (self);
	if (_iface_->get_id) {
		return _iface_->get_id (self);
	}
	return NULL;
}

/**
     * Returns a user-visible name for the Pluggable.
     */
const gchar*
spit_pluggable_get_pluggable_name (SpitPluggable* self)
{
	SpitPluggableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SPIT_PLUGGABLE_GET_INTERFACE (self);
	if (_iface_->get_pluggable_name) {
		return _iface_->get_pluggable_name (self);
	}
	return NULL;
}

/**
     * Returns extra information about the Pluggable that is used to identify it to the user.
     */
void
spit_pluggable_get_info (SpitPluggable* self,
                         SpitPluggableInfo* info)
{
	SpitPluggableIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_PLUGGABLE_GET_INTERFACE (self);
	if (_iface_->get_info) {
		_iface_->get_info (self, info);
	}
}

/**
     * Called when the Pluggable is enabled (activated) or disabled (deactivated).
     *
     * activation will be called at the start of the program if the user previously
     * enabled/disabled it as well as during program execution if the user changes its state. Note
     * that disabling a Pluggable does not require destroying existing resources or objects
     * the Pluggable has previously handed off to the host.
     *
     * This is purely informational. The Pluggable should acquire any long-term resources
     * it may be holding onto here, or wait until an extension-specific call is made to it.
     *
     * @param enabled ``true`` if the Pluggable has been enabled, ``false`` otherwise.
     */
void
spit_pluggable_activation (SpitPluggable* self,
                           gboolean enabled)
{
	SpitPluggableIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_PLUGGABLE_GET_INTERFACE (self);
	if (_iface_->activation) {
		_iface_->activation (self, enabled);
	}
}

static void
spit_pluggable_real_reserved0 (SpitPluggable* self)
{
}

void
spit_pluggable_reserved0 (SpitPluggable* self)
{
	SpitPluggableIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_PLUGGABLE_GET_INTERFACE (self);
	if (_iface_->reserved0) {
		_iface_->reserved0 (self);
	}
}

static void
spit_pluggable_real_reserved1 (SpitPluggable* self)
{
}

void
spit_pluggable_reserved1 (SpitPluggable* self)
{
	SpitPluggableIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_PLUGGABLE_GET_INTERFACE (self);
	if (_iface_->reserved1) {
		_iface_->reserved1 (self);
	}
}

static void
spit_pluggable_real_reserved2 (SpitPluggable* self)
{
}

void
spit_pluggable_reserved2 (SpitPluggable* self)
{
	SpitPluggableIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_PLUGGABLE_GET_INTERFACE (self);
	if (_iface_->reserved2) {
		_iface_->reserved2 (self);
	}
}

static void
spit_pluggable_real_reserved3 (SpitPluggable* self)
{
}

void
spit_pluggable_reserved3 (SpitPluggable* self)
{
	SpitPluggableIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_PLUGGABLE_GET_INTERFACE (self);
	if (_iface_->reserved3) {
		_iface_->reserved3 (self);
	}
}

static void
spit_pluggable_real_reserved4 (SpitPluggable* self)
{
}

void
spit_pluggable_reserved4 (SpitPluggable* self)
{
	SpitPluggableIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_PLUGGABLE_GET_INTERFACE (self);
	if (_iface_->reserved4) {
		_iface_->reserved4 (self);
	}
}

static void
spit_pluggable_real_reserved5 (SpitPluggable* self)
{
}

void
spit_pluggable_reserved5 (SpitPluggable* self)
{
	SpitPluggableIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_PLUGGABLE_GET_INTERFACE (self);
	if (_iface_->reserved5) {
		_iface_->reserved5 (self);
	}
}

static void
spit_pluggable_real_reserved6 (SpitPluggable* self)
{
}

void
spit_pluggable_reserved6 (SpitPluggable* self)
{
	SpitPluggableIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_PLUGGABLE_GET_INTERFACE (self);
	if (_iface_->reserved6) {
		_iface_->reserved6 (self);
	}
}

static void
spit_pluggable_real_reserved7 (SpitPluggable* self)
{
}

void
spit_pluggable_reserved7 (SpitPluggable* self)
{
	SpitPluggableIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_PLUGGABLE_GET_INTERFACE (self);
	if (_iface_->reserved7) {
		_iface_->reserved7 (self);
	}
}

static void
spit_pluggable_default_init (SpitPluggableIface * iface,
                             gpointer iface_data)
{
	iface->reserved0 = spit_pluggable_real_reserved0;
	iface->reserved1 = spit_pluggable_real_reserved1;
	iface->reserved2 = spit_pluggable_real_reserved2;
	iface->reserved3 = spit_pluggable_real_reserved3;
	iface->reserved4 = spit_pluggable_real_reserved4;
	iface->reserved5 = spit_pluggable_real_reserved5;
	iface->reserved6 = spit_pluggable_real_reserved6;
	iface->reserved7 = spit_pluggable_real_reserved7;
}

/**
 * A generic interface to all Photos plugins.
 *
 * Each plugin in a module needs to implement this interface at a minimum. Extension
 * points may have (and probably will have) specific interface requirements as well.
 */
static GType
spit_pluggable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitPluggableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_pluggable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_pluggable_type_id;
	spit_pluggable_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPluggable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_pluggable_type_id, G_TYPE_OBJECT);
	return spit_pluggable_type_id;
}

GType
spit_pluggable_get_type (void)
{
	static volatile gsize spit_pluggable_type_id__once = 0;
	if (g_once_init_enter (&spit_pluggable_type_id__once)) {
		GType spit_pluggable_type_id;
		spit_pluggable_type_id = spit_pluggable_get_type_once ();
		g_once_init_leave (&spit_pluggable_type_id__once, spit_pluggable_type_id);
	}
	return spit_pluggable_type_id__once;
}

/**
     * Returns a File object representing the library file (.so/la.) that the plugin was loaded
     * from.
     */
GFile*
spit_host_interface_get_module_file (SpitHostInterface* self)
{
	SpitHostInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_module_file) {
		return _iface_->get_module_file (self);
	}
	return NULL;
}

/**
     * Get a boolean from a persistent configuration store.
     *
     * @param key The name of the value to be retrieved.
     * @param def The default value (returned if the key has not been previously set).
     *
     * @return The value associated with key, def if not set.
     */
gboolean
spit_host_interface_get_config_bool (SpitHostInterface* self,
                                     const gchar* key,
                                     gboolean def)
{
	SpitHostInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_config_bool) {
		return _iface_->get_config_bool (self, key, def);
	}
	return FALSE;
}

/**
     * Store a boolean in a persistent configuration store.
     *
     * @param key The name of the value to be stored.
     * @param val The value to be stored.
     */
void
spit_host_interface_set_config_bool (SpitHostInterface* self,
                                     const gchar* key,
                                     gboolean val)
{
	SpitHostInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->set_config_bool) {
		_iface_->set_config_bool (self, key, val);
	}
}

/**
     * Get an integer from a persistent configuration store.
     *
     * @param key The name of the value to be retrieved.
     * @param def The default value (returned if the key has not been previously set).
     *
     * @return The value associated with key, def if not set.
     */
gint
spit_host_interface_get_config_int (SpitHostInterface* self,
                                    const gchar* key,
                                    gint def)
{
	SpitHostInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_config_int) {
		return _iface_->get_config_int (self, key, def);
	}
	return -1;
}

/**
     * Store an integer in a persistent configuration store.
     *
     * @param key The name of the value to be stored.
     * @param val The value to be stored.
     */
void
spit_host_interface_set_config_int (SpitHostInterface* self,
                                    const gchar* key,
                                    gint val)
{
	SpitHostInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->set_config_int) {
		_iface_->set_config_int (self, key, val);
	}
}

/**
     * Get a string from a persistent configuration store.
     *
     * @param key The name of the value to be retrieved.
     * @param def The default value (returned if the key has not been previously set).
     *
     * @return The value associated with key, def if not set.
     */
gchar*
spit_host_interface_get_config_string (SpitHostInterface* self,
                                       const gchar* key,
                                       const gchar* def)
{
	SpitHostInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_config_string) {
		return _iface_->get_config_string (self, key, def);
	}
	return NULL;
}

/**
     * Store a string in a persistent configuration store.
     *
     * @param key The name of the value to be stored.
     * @param val The value to be stored.
     */
void
spit_host_interface_set_config_string (SpitHostInterface* self,
                                       const gchar* key,
                                       const gchar* val)
{
	SpitHostInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->set_config_string) {
		_iface_->set_config_string (self, key, val);
	}
}

/**
     * Get a double from a persistent configuration store.
     *
     * @param key The name of the value to be retrieved.
     * @param def The default value (returned if the key has not been previously set).
     *
     * @return The value associated with key, def if not set.
     */
gdouble
spit_host_interface_get_config_double (SpitHostInterface* self,
                                       const gchar* key,
                                       gdouble def)
{
	SpitHostInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0.0);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_config_double) {
		return _iface_->get_config_double (self, key, def);
	}
	return -1.0;
}

/**
     * Store a double in a persistent configuration store.
     *
     * @param key The name of the value to be stored.
     * @param val The value to be stored.
     */
void
spit_host_interface_set_config_double (SpitHostInterface* self,
                                       const gchar* key,
                                       gdouble val)
{
	SpitHostInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->set_config_double) {
		_iface_->set_config_double (self, key, val);
	}
}

/**
     * Delete the value from the persistent configuration store.
     */
void
spit_host_interface_unset_config_key (SpitHostInterface* self,
                                      const gchar* key)
{
	SpitHostInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->unset_config_key) {
		_iface_->unset_config_key (self, key);
	}
}

static void
spit_host_interface_real_reserved0 (SpitHostInterface* self)
{
}

void
spit_host_interface_reserved0 (SpitHostInterface* self)
{
	SpitHostInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->reserved0) {
		_iface_->reserved0 (self);
	}
}

static void
spit_host_interface_real_reserved1 (SpitHostInterface* self)
{
}

void
spit_host_interface_reserved1 (SpitHostInterface* self)
{
	SpitHostInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->reserved1) {
		_iface_->reserved1 (self);
	}
}

static void
spit_host_interface_real_reserved2 (SpitHostInterface* self)
{
}

void
spit_host_interface_reserved2 (SpitHostInterface* self)
{
	SpitHostInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->reserved2) {
		_iface_->reserved2 (self);
	}
}

static void
spit_host_interface_real_reserved3 (SpitHostInterface* self)
{
}

void
spit_host_interface_reserved3 (SpitHostInterface* self)
{
	SpitHostInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->reserved3) {
		_iface_->reserved3 (self);
	}
}

static void
spit_host_interface_real_reserved4 (SpitHostInterface* self)
{
}

void
spit_host_interface_reserved4 (SpitHostInterface* self)
{
	SpitHostInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->reserved4) {
		_iface_->reserved4 (self);
	}
}

static void
spit_host_interface_real_reserved5 (SpitHostInterface* self)
{
}

void
spit_host_interface_reserved5 (SpitHostInterface* self)
{
	SpitHostInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->reserved5) {
		_iface_->reserved5 (self);
	}
}

static void
spit_host_interface_real_reserved6 (SpitHostInterface* self)
{
}

void
spit_host_interface_reserved6 (SpitHostInterface* self)
{
	SpitHostInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->reserved6) {
		_iface_->reserved6 (self);
	}
}

static void
spit_host_interface_real_reserved7 (SpitHostInterface* self)
{
}

void
spit_host_interface_reserved7 (SpitHostInterface* self)
{
	SpitHostInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SPIT_HOST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->reserved7) {
		_iface_->reserved7 (self);
	}
}

static void
spit_host_interface_default_init (SpitHostInterfaceIface * iface,
                                  gpointer iface_data)
{
	iface->reserved0 = spit_host_interface_real_reserved0;
	iface->reserved1 = spit_host_interface_real_reserved1;
	iface->reserved2 = spit_host_interface_real_reserved2;
	iface->reserved3 = spit_host_interface_real_reserved3;
	iface->reserved4 = spit_host_interface_real_reserved4;
	iface->reserved5 = spit_host_interface_real_reserved5;
	iface->reserved6 = spit_host_interface_real_reserved6;
	iface->reserved7 = spit_host_interface_real_reserved7;
}

/**
 * An interface to common services supplied by the host (Shotwell).
 *
 * Each {@link Pluggable} is offered a HostInterface for needs common to most plugins.
 *
 * Note that
 * a HostInterface is not explicitly handed to the Pluggable through the SPIT interface, but is expected
 * to be offered to the Pluggable through an interface applicable to the extension point. This
 * also allows the extension point to extend HostInterface to offer other services applicable to the
 * type of plugin.
 */
static GType
spit_host_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitHostInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_host_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_host_interface_type_id;
	spit_host_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitHostInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_host_interface_type_id, G_TYPE_OBJECT);
	return spit_host_interface_type_id;
}

GType
spit_host_interface_get_type (void)
{
	static volatile gsize spit_host_interface_type_id__once = 0;
	if (g_once_init_enter (&spit_host_interface_type_id__once)) {
		GType spit_host_interface_type_id;
		spit_host_interface_type_id = spit_host_interface_get_type_once ();
		g_once_init_leave (&spit_host_interface_type_id__once, spit_host_interface_type_id);
	}
	return spit_host_interface_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

