// python wrapper for vtkPVGeneralSettings
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVGeneralSettings.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVGeneralSettings(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVGeneralSettings_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVGeneralSettings_RealNumberNotation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingSettings.vtkPVGeneralSettings.RealNumberNotation", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkPVGeneralSettings_RealNumberNotation_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkPVGeneralSettings_RealNumberNotation_Type, static_cast<int>(val));
}


static PyObject *
PyvtkPVGeneralSettings_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVGeneralSettings::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVGeneralSettings::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVGeneralSettings *tempr = vtkPVGeneralSettings::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVGeneralSettings *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVGeneralSettings::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVGeneralSettings::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVGeneralSettings::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetInstance(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetInstance");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkPVGeneralSettings *tempr = vtkPVGeneralSettings::GetInstance();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetAutoConvertProperties(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAutoConvertProperties");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAutoConvertProperties(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetAutoConvertProperties(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetAutoConvertProperties(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAutoConvertProperties");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAutoConvertProperties() :
      op->vtkPVGeneralSettings::GetAutoConvertProperties());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_AutoConvertPropertiesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AutoConvertPropertiesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AutoConvertPropertiesOn();
    }
    else
    {
      op->vtkPVGeneralSettings::AutoConvertPropertiesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_AutoConvertPropertiesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AutoConvertPropertiesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AutoConvertPropertiesOff();
    }
    else
    {
      op->vtkPVGeneralSettings::AutoConvertPropertiesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetBlockColorsDistinctValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockColorsDistinctValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBlockColorsDistinctValues() :
      op->vtkPVGeneralSettings::GetBlockColorsDistinctValues());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetBlockColorsDistinctValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockColorsDistinctValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBlockColorsDistinctValues(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetBlockColorsDistinctValues(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetAutoApply(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAutoApply");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAutoApply() :
      op->vtkPVGeneralSettings::GetAutoApply());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetAutoApply(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAutoApply");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAutoApply(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetAutoApply(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetAutoApplyDelay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAutoApplyDelay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAutoApplyDelay() :
      op->vtkPVGeneralSettings::GetAutoApplyDelay());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetAutoApplyDelay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAutoApplyDelay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAutoApplyDelay(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetAutoApplyDelay(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetAutoApplyActiveOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAutoApplyActiveOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAutoApplyActiveOnly() :
      op->vtkPVGeneralSettings::GetAutoApplyActiveOnly());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetAutoApplyActiveOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAutoApplyActiveOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAutoApplyActiveOnly(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetAutoApplyActiveOnly(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetPreservePropertyValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPreservePropertyValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPreservePropertyValues() :
      op->vtkPVGeneralSettings::GetPreservePropertyValues());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetPreservePropertyValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPreservePropertyValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPreservePropertyValues(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetPreservePropertyValues(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetDefaultViewType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDefaultViewType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetDefaultViewType() :
      op->vtkPVGeneralSettings::GetDefaultViewType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetDefaultViewType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDefaultViewType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDefaultViewType(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetDefaultViewType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetInterfaceLanguage(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInterfaceLanguage");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetInterfaceLanguage() :
      op->vtkPVGeneralSettings::GetInterfaceLanguage());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetInterfaceLanguage(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterfaceLanguage");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInterfaceLanguage(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetInterfaceLanguage(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetScalarBarMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScalarBarMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScalarBarMode(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetScalarBarMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetScalarBarMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetScalarBarMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetScalarBarMode() :
      op->vtkPVGeneralSettings::GetScalarBarMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetCacheGeometryForAnimation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCacheGeometryForAnimation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCacheGeometryForAnimation(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetCacheGeometryForAnimation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetCacheGeometryForAnimation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCacheGeometryForAnimation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetCacheGeometryForAnimation() :
      op->vtkPVGeneralSettings::GetCacheGeometryForAnimation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_CacheGeometryForAnimationOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CacheGeometryForAnimationOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CacheGeometryForAnimationOn();
    }
    else
    {
      op->vtkPVGeneralSettings::CacheGeometryForAnimationOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_CacheGeometryForAnimationOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CacheGeometryForAnimationOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CacheGeometryForAnimationOff();
    }
    else
    {
      op->vtkPVGeneralSettings::CacheGeometryForAnimationOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetAnimationGeometryCacheLimit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnimationGeometryCacheLimit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  unsigned long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAnimationGeometryCacheLimit(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetAnimationGeometryCacheLimit(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetAnimationGeometryCacheLimit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnimationGeometryCacheLimit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetAnimationGeometryCacheLimit() :
      op->vtkPVGeneralSettings::GetAnimationGeometryCacheLimit());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetAnimationTimeNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnimationTimeNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAnimationTimeNotation(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetAnimationTimeNotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetAnimationTimeNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnimationTimeNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAnimationTimeNotation() :
      op->vtkPVGeneralSettings::GetAnimationTimeNotation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetAnimationTimeShortestAccuratePrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnimationTimeShortestAccuratePrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAnimationTimeShortestAccuratePrecision(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetAnimationTimeShortestAccuratePrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetAnimationTimeShortestAccuratePrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnimationTimeShortestAccuratePrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAnimationTimeShortestAccuratePrecision() :
      op->vtkPVGeneralSettings::GetAnimationTimeShortestAccuratePrecision());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetAnimationTimePrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnimationTimePrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAnimationTimePrecision(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetAnimationTimePrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetAnimationTimePrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnimationTimePrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAnimationTimePrecision() :
      op->vtkPVGeneralSettings::GetAnimationTimePrecision());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetShowAnimationShortcuts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShowAnimationShortcuts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShowAnimationShortcuts(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetShowAnimationShortcuts(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetShowAnimationShortcuts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetShowAnimationShortcuts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetShowAnimationShortcuts() :
      op->vtkPVGeneralSettings::GetShowAnimationShortcuts());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_ShowAnimationShortcutsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowAnimationShortcutsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ShowAnimationShortcutsOn();
    }
    else
    {
      op->vtkPVGeneralSettings::ShowAnimationShortcutsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_ShowAnimationShortcutsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowAnimationShortcutsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ShowAnimationShortcutsOff();
    }
    else
    {
      op->vtkPVGeneralSettings::ShowAnimationShortcutsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetResetDisplayEmptyViews(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetResetDisplayEmptyViews");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetResetDisplayEmptyViews(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetResetDisplayEmptyViews(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetResetDisplayEmptyViews(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetResetDisplayEmptyViews");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetResetDisplayEmptyViews() :
      op->vtkPVGeneralSettings::GetResetDisplayEmptyViews());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_ResetDisplayEmptyViewsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetDisplayEmptyViewsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetDisplayEmptyViewsOn();
    }
    else
    {
      op->vtkPVGeneralSettings::ResetDisplayEmptyViewsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_ResetDisplayEmptyViewsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetDisplayEmptyViewsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetDisplayEmptyViewsOff();
    }
    else
    {
      op->vtkPVGeneralSettings::ResetDisplayEmptyViewsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetRealNumberDisplayedNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRealNumberDisplayedNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRealNumberDisplayedNotation(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetRealNumberDisplayedNotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetRealNumberDisplayedNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRealNumberDisplayedNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRealNumberDisplayedNotation() :
      op->vtkPVGeneralSettings::GetRealNumberDisplayedNotation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetRealNumberDisplayedShortestAccuratePrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRealNumberDisplayedShortestAccuratePrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRealNumberDisplayedShortestAccuratePrecision(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetRealNumberDisplayedShortestAccuratePrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetRealNumberDisplayedShortestAccuratePrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRealNumberDisplayedShortestAccuratePrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRealNumberDisplayedShortestAccuratePrecision() :
      op->vtkPVGeneralSettings::GetRealNumberDisplayedShortestAccuratePrecision());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetRealNumberDisplayedPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRealNumberDisplayedPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRealNumberDisplayedPrecision(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetRealNumberDisplayedPrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetRealNumberDisplayedPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRealNumberDisplayedPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRealNumberDisplayedPrecision() :
      op->vtkPVGeneralSettings::GetRealNumberDisplayedPrecision());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetFullNotationLowExponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFullNotationLowExponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFullNotationLowExponent(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetFullNotationLowExponent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetFullNotationLowExponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFullNotationLowExponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFullNotationLowExponent() :
      op->vtkPVGeneralSettings::GetFullNotationLowExponent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetFullNotationHighExponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFullNotationHighExponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFullNotationHighExponent(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetFullNotationHighExponent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetFullNotationHighExponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFullNotationHighExponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFullNotationHighExponent() :
      op->vtkPVGeneralSettings::GetFullNotationHighExponent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetInheritRepresentationProperties(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInheritRepresentationProperties");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInheritRepresentationProperties(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetInheritRepresentationProperties(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetInheritRepresentationProperties(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInheritRepresentationProperties");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetInheritRepresentationProperties() :
      op->vtkPVGeneralSettings::GetInheritRepresentationProperties());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_InheritRepresentationPropertiesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InheritRepresentationPropertiesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InheritRepresentationPropertiesOn();
    }
    else
    {
      op->vtkPVGeneralSettings::InheritRepresentationPropertiesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_InheritRepresentationPropertiesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InheritRepresentationPropertiesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InheritRepresentationPropertiesOff();
    }
    else
    {
      op->vtkPVGeneralSettings::InheritRepresentationPropertiesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetIgnoreNegativeLogAxisWarning(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIgnoreNegativeLogAxisWarning");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIgnoreNegativeLogAxisWarning(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetIgnoreNegativeLogAxisWarning(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetIgnoreNegativeLogAxisWarning(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIgnoreNegativeLogAxisWarning");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIgnoreNegativeLogAxisWarning() :
      op->vtkPVGeneralSettings::GetIgnoreNegativeLogAxisWarning());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_IgnoreNegativeLogAxisWarningOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IgnoreNegativeLogAxisWarningOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->IgnoreNegativeLogAxisWarningOn();
    }
    else
    {
      op->vtkPVGeneralSettings::IgnoreNegativeLogAxisWarningOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_IgnoreNegativeLogAxisWarningOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IgnoreNegativeLogAxisWarningOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->IgnoreNegativeLogAxisWarningOff();
    }
    else
    {
      op->vtkPVGeneralSettings::IgnoreNegativeLogAxisWarningOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetPropertiesPanelMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPropertiesPanelMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPropertiesPanelMode(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetPropertiesPanelMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetPropertiesPanelMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPropertiesPanelMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPropertiesPanelMode() :
      op->vtkPVGeneralSettings::GetPropertiesPanelMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetLockPanels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLockPanels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLockPanels(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetLockPanels(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetLockPanels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLockPanels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetLockPanels() :
      op->vtkPVGeneralSettings::GetLockPanels());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetLoadAllVariables(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLoadAllVariables");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLoadAllVariables(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetLoadAllVariables(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetLoadAllVariables(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLoadAllVariables");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetLoadAllVariables() :
      op->vtkPVGeneralSettings::GetLoadAllVariables());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_LoadAllVariablesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadAllVariablesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LoadAllVariablesOn();
    }
    else
    {
      op->vtkPVGeneralSettings::LoadAllVariablesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_LoadAllVariablesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadAllVariablesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LoadAllVariablesOff();
    }
    else
    {
      op->vtkPVGeneralSettings::LoadAllVariablesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetLoadNoChartVariables(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLoadNoChartVariables");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLoadNoChartVariables(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetLoadNoChartVariables(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetLoadNoChartVariables(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLoadNoChartVariables");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetLoadNoChartVariables() :
      op->vtkPVGeneralSettings::GetLoadNoChartVariables());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_LoadNoChartVariablesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadNoChartVariablesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LoadNoChartVariablesOn();
    }
    else
    {
      op->vtkPVGeneralSettings::LoadNoChartVariablesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_LoadNoChartVariablesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadNoChartVariablesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LoadNoChartVariablesOff();
    }
    else
    {
      op->vtkPVGeneralSettings::LoadNoChartVariablesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetGUIFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGUIFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGUIFontSize(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetGUIFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetGUIFontSizeMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGUIFontSizeMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGUIFontSizeMinValue() :
      op->vtkPVGeneralSettings::GetGUIFontSizeMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetGUIFontSizeMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGUIFontSizeMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGUIFontSizeMaxValue() :
      op->vtkPVGeneralSettings::GetGUIFontSizeMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetGUIFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGUIFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGUIFontSize() :
      op->vtkPVGeneralSettings::GetGUIFontSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetGUIOverrideFont(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGUIOverrideFont");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGUIOverrideFont(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetGUIOverrideFont(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetGUIOverrideFont(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGUIOverrideFont");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGUIOverrideFont() :
      op->vtkPVGeneralSettings::GetGUIOverrideFont());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetColorByBlockColorsOnApply(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColorByBlockColorsOnApply");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetColorByBlockColorsOnApply(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetColorByBlockColorsOnApply(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetColorByBlockColorsOnApply(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColorByBlockColorsOnApply");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetColorByBlockColorsOnApply() :
      op->vtkPVGeneralSettings::GetColorByBlockColorsOnApply());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetEnableStreaming(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableStreaming");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableStreaming(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetEnableStreaming(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetEnableStreaming(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableStreaming");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableStreaming() :
      op->vtkPVGeneralSettings::GetEnableStreaming());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_EnableStreamingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableStreamingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableStreamingOn();
    }
    else
    {
      op->vtkPVGeneralSettings::EnableStreamingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_EnableStreamingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableStreamingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableStreamingOff();
    }
    else
    {
      op->vtkPVGeneralSettings::EnableStreamingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetUseAcceleratedFilters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseAcceleratedFilters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseAcceleratedFilters(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetUseAcceleratedFilters(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetUseAcceleratedFilters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseAcceleratedFilters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseAcceleratedFilters() :
      op->vtkPVGeneralSettings::GetUseAcceleratedFilters());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_UseAcceleratedFiltersOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseAcceleratedFiltersOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseAcceleratedFiltersOn();
    }
    else
    {
      op->vtkPVGeneralSettings::UseAcceleratedFiltersOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_UseAcceleratedFiltersOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseAcceleratedFiltersOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseAcceleratedFiltersOff();
    }
    else
    {
      op->vtkPVGeneralSettings::UseAcceleratedFiltersOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetSelectOnClickMultiBlockInspector(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectOnClickMultiBlockInspector");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSelectOnClickMultiBlockInspector() :
      op->vtkPVGeneralSettings::GetSelectOnClickMultiBlockInspector());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetSelectOnClickMultiBlockInspector(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectOnClickMultiBlockInspector");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGeneralSettings *op = static_cast<vtkPVGeneralSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSelectOnClickMultiBlockInspector(temp0);
    }
    else
    {
      op->vtkPVGeneralSettings::SetSelectOnClickMultiBlockInspector(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetNumberOfCallbackThreads(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfCallbackThreads");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    int tempr = vtkPVGeneralSettings::GetNumberOfCallbackThreads();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetNumberOfCallbackThreads(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetNumberOfCallbackThreads");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPVGeneralSettings::SetNumberOfCallbackThreads(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_GetNumberOfSMPThreads(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfSMPThreads");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    int tempr = vtkPVGeneralSettings::GetNumberOfSMPThreads();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGeneralSettings_SetNumberOfSMPThreads(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetNumberOfSMPThreads");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPVGeneralSettings::SetNumberOfSMPThreads(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVGeneralSettings_Methods[] = {
  {"IsTypeOf", PyvtkPVGeneralSettings_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVGeneralSettings_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVGeneralSettings_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVGeneralSettings\nC++: static vtkPVGeneralSettings *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVGeneralSettings_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVGeneralSettings\nC++: vtkPVGeneralSettings *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVGeneralSettings_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVGeneralSettings_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetInstance", PyvtkPVGeneralSettings_GetInstance, METH_VARARGS,
   "GetInstance() -> vtkPVGeneralSettings\nC++: static vtkPVGeneralSettings *GetInstance()\n\nAccess the singleton.\n"},
  {"SetAutoConvertProperties", PyvtkPVGeneralSettings_SetAutoConvertProperties, METH_VARARGS,
   "SetAutoConvertProperties(self, _arg:bool) -> None\nC++: virtual void SetAutoConvertProperties(bool _arg)\n\nAutomatically convert data arrays as needed by filters including\nconverting cell arrays to point arrays, or vice versa, and\nextracting single components from multi-component arrays.\n"},
  {"GetAutoConvertProperties", PyvtkPVGeneralSettings_GetAutoConvertProperties, METH_VARARGS,
   "GetAutoConvertProperties(self) -> bool\nC++: virtual bool GetAutoConvertProperties()\n\n"},
  {"AutoConvertPropertiesOn", PyvtkPVGeneralSettings_AutoConvertPropertiesOn, METH_VARARGS,
   "AutoConvertPropertiesOn(self) -> None\nC++: virtual void AutoConvertPropertiesOn()\n\n"},
  {"AutoConvertPropertiesOff", PyvtkPVGeneralSettings_AutoConvertPropertiesOff, METH_VARARGS,
   "AutoConvertPropertiesOff(self) -> None\nC++: virtual void AutoConvertPropertiesOff()\n\n"},
  {"GetBlockColorsDistinctValues", PyvtkPVGeneralSettings_GetBlockColorsDistinctValues, METH_VARARGS,
   "GetBlockColorsDistinctValues(self) -> int\nC++: virtual int GetBlockColorsDistinctValues()\n\nDetermines the number of distinct values in vtkBlockColors. This\narray is added to each block if the dataset is a composite\ndataset. The array has one value set to (blockIndex %\nBlockColorsDistinctValues)\n"},
  {"SetBlockColorsDistinctValues", PyvtkPVGeneralSettings_SetBlockColorsDistinctValues, METH_VARARGS,
   "SetBlockColorsDistinctValues(self, _arg:int) -> None\nC++: virtual void SetBlockColorsDistinctValues(int _arg)\n\n"},
  {"GetAutoApply", PyvtkPVGeneralSettings_GetAutoApply, METH_VARARGS,
   "GetAutoApply(self) -> bool\nC++: virtual bool GetAutoApply()\n\nAutomatically apply changes in the 'Properties' panel. Default is\nfalse.\n"},
  {"SetAutoApply", PyvtkPVGeneralSettings_SetAutoApply, METH_VARARGS,
   "SetAutoApply(self, _arg:bool) -> None\nC++: virtual void SetAutoApply(bool _arg)\n\n"},
  {"GetAutoApplyDelay", PyvtkPVGeneralSettings_GetAutoApplyDelay, METH_VARARGS,
   "GetAutoApplyDelay(self) -> int\nC++: virtual int GetAutoApplyDelay()\n\nGet/Set delay for auto apply. Not exposed in the UI. Default is\n0.\n"},
  {"SetAutoApplyDelay", PyvtkPVGeneralSettings_SetAutoApplyDelay, METH_VARARGS,
   "SetAutoApplyDelay(self, _arg:int) -> None\nC++: virtual void SetAutoApplyDelay(int _arg)\n\n"},
  {"GetAutoApplyActiveOnly", PyvtkPVGeneralSettings_GetAutoApplyActiveOnly, METH_VARARGS,
   "GetAutoApplyActiveOnly(self) -> bool\nC++: virtual bool GetAutoApplyActiveOnly()\n\nAutomatically apply changes in the 'Properties' panel. Default is\nfalse.\n"},
  {"SetAutoApplyActiveOnly", PyvtkPVGeneralSettings_SetAutoApplyActiveOnly, METH_VARARGS,
   "SetAutoApplyActiveOnly(self, _arg:bool) -> None\nC++: virtual void SetAutoApplyActiveOnly(bool _arg)\n\n"},
  {"GetPreservePropertyValues", PyvtkPVGeneralSettings_GetPreservePropertyValues, METH_VARARGS,
   "GetPreservePropertyValues(self) -> bool\nC++: virtual bool GetPreservePropertyValues()\n\nPreserve applied properties values for next use. This is intended\nto be used for pipeline sources, and acts as \"save current values as\ndefault\" on each Apply. Default is false.\n"},
  {"SetPreservePropertyValues", PyvtkPVGeneralSettings_SetPreservePropertyValues, METH_VARARGS,
   "SetPreservePropertyValues(self, _arg:bool) -> None\nC++: virtual void SetPreservePropertyValues(bool _arg)\n\n"},
  {"GetDefaultViewType", PyvtkPVGeneralSettings_GetDefaultViewType, METH_VARARGS,
   "GetDefaultViewType(self) -> str\nC++: virtual std::string GetDefaultViewType()\n\nGet/Set the default view type.\n"},
  {"SetDefaultViewType", PyvtkPVGeneralSettings_SetDefaultViewType, METH_VARARGS,
   "SetDefaultViewType(self, _arg:str) -> None\nC++: virtual void SetDefaultViewType(std::string _arg)\n\n"},
  {"GetInterfaceLanguage", PyvtkPVGeneralSettings_GetInterfaceLanguage, METH_VARARGS,
   "GetInterfaceLanguage(self) -> str\nC++: virtual std::string GetInterfaceLanguage()\n\nGet/Set the default interface language. Default is en\n"},
  {"SetInterfaceLanguage", PyvtkPVGeneralSettings_SetInterfaceLanguage, METH_VARARGS,
   "SetInterfaceLanguage(self, _arg:str) -> None\nC++: virtual void SetInterfaceLanguage(std::string _arg)\n\n"},
  {"SetScalarBarMode", PyvtkPVGeneralSettings_SetScalarBarMode, METH_VARARGS,
   "SetScalarBarMode(self, _arg:int) -> None\nC++: virtual void SetScalarBarMode(int _arg)\n\n"},
  {"GetScalarBarMode", PyvtkPVGeneralSettings_GetScalarBarMode, METH_VARARGS,
   "GetScalarBarMode(self) -> int\nC++: virtual int GetScalarBarMode()\n\n"},
  {"SetCacheGeometryForAnimation", PyvtkPVGeneralSettings_SetCacheGeometryForAnimation, METH_VARARGS,
   "SetCacheGeometryForAnimation(self, _arg:bool) -> None\nC++: virtual void SetCacheGeometryForAnimation(bool _arg)\n\nSet when animation geometry caching is enabled.\n"},
  {"GetCacheGeometryForAnimation", PyvtkPVGeneralSettings_GetCacheGeometryForAnimation, METH_VARARGS,
   "GetCacheGeometryForAnimation(self) -> bool\nC++: virtual bool GetCacheGeometryForAnimation()\n\n"},
  {"CacheGeometryForAnimationOn", PyvtkPVGeneralSettings_CacheGeometryForAnimationOn, METH_VARARGS,
   "CacheGeometryForAnimationOn(self) -> None\nC++: virtual void CacheGeometryForAnimationOn()\n\n"},
  {"CacheGeometryForAnimationOff", PyvtkPVGeneralSettings_CacheGeometryForAnimationOff, METH_VARARGS,
   "CacheGeometryForAnimationOff(self) -> None\nC++: virtual void CacheGeometryForAnimationOff()\n\n"},
  {"SetAnimationGeometryCacheLimit", PyvtkPVGeneralSettings_SetAnimationGeometryCacheLimit, METH_VARARGS,
   "SetAnimationGeometryCacheLimit(self, _arg:int) -> None\nC++: virtual void SetAnimationGeometryCacheLimit(\n    unsigned long _arg)\n\nSet the animation cache limit in KBs.\n"},
  {"GetAnimationGeometryCacheLimit", PyvtkPVGeneralSettings_GetAnimationGeometryCacheLimit, METH_VARARGS,
   "GetAnimationGeometryCacheLimit(self) -> int\nC++: virtual unsigned long GetAnimationGeometryCacheLimit()\n\n"},
  {"SetAnimationTimeNotation", PyvtkPVGeneralSettings_SetAnimationTimeNotation, METH_VARARGS,
   "SetAnimationTimeNotation(self, _arg:int) -> None\nC++: virtual void SetAnimationTimeNotation(int _arg)\n\nSet the notation for the animation time toolbar. Accepted values\nare MIXED, SCIENTIFIC, and FIXED.\n"},
  {"GetAnimationTimeNotation", PyvtkPVGeneralSettings_GetAnimationTimeNotation, METH_VARARGS,
   "GetAnimationTimeNotation(self) -> int\nC++: virtual int GetAnimationTimeNotation()\n\n"},
  {"SetAnimationTimeShortestAccuratePrecision", PyvtkPVGeneralSettings_SetAnimationTimeShortestAccuratePrecision, METH_VARARGS,
   "SetAnimationTimeShortestAccuratePrecision(self, _arg:bool) -> None\nC++: virtual void SetAnimationTimeShortestAccuratePrecision(\n    bool _arg)\n\nGet/Set the usage of shortest accurate precision instead of\nactual precision for animation time\n"},
  {"GetAnimationTimeShortestAccuratePrecision", PyvtkPVGeneralSettings_GetAnimationTimeShortestAccuratePrecision, METH_VARARGS,
   "GetAnimationTimeShortestAccuratePrecision(self) -> bool\nC++: virtual bool GetAnimationTimeShortestAccuratePrecision()\n\n"},
  {"SetAnimationTimePrecision", PyvtkPVGeneralSettings_SetAnimationTimePrecision, METH_VARARGS,
   "SetAnimationTimePrecision(self, _arg:int) -> None\nC++: virtual void SetAnimationTimePrecision(int _arg)\n\nSet the precision of the animation time toolbar.\n"},
  {"GetAnimationTimePrecision", PyvtkPVGeneralSettings_GetAnimationTimePrecision, METH_VARARGS,
   "GetAnimationTimePrecision(self) -> int\nC++: virtual int GetAnimationTimePrecision()\n\n"},
  {"SetShowAnimationShortcuts", PyvtkPVGeneralSettings_SetShowAnimationShortcuts, METH_VARARGS,
   "SetShowAnimationShortcuts(self, _arg:bool) -> None\nC++: virtual void SetShowAnimationShortcuts(bool _arg)\n\nSet when animation shortcuts are shown.\n"},
  {"GetShowAnimationShortcuts", PyvtkPVGeneralSettings_GetShowAnimationShortcuts, METH_VARARGS,
   "GetShowAnimationShortcuts(self) -> bool\nC++: virtual bool GetShowAnimationShortcuts()\n\n"},
  {"ShowAnimationShortcutsOn", PyvtkPVGeneralSettings_ShowAnimationShortcutsOn, METH_VARARGS,
   "ShowAnimationShortcutsOn(self) -> None\nC++: virtual void ShowAnimationShortcutsOn()\n\n"},
  {"ShowAnimationShortcutsOff", PyvtkPVGeneralSettings_ShowAnimationShortcutsOff, METH_VARARGS,
   "ShowAnimationShortcutsOff(self) -> None\nC++: virtual void ShowAnimationShortcutsOff()\n\n"},
  {"SetResetDisplayEmptyViews", PyvtkPVGeneralSettings_SetResetDisplayEmptyViews, METH_VARARGS,
   "SetResetDisplayEmptyViews(self, _arg:bool) -> None\nC++: virtual void SetResetDisplayEmptyViews(bool _arg)\n\nSet whether to reset display when showing a representation in an\nempty view.\n"},
  {"GetResetDisplayEmptyViews", PyvtkPVGeneralSettings_GetResetDisplayEmptyViews, METH_VARARGS,
   "GetResetDisplayEmptyViews(self) -> bool\nC++: virtual bool GetResetDisplayEmptyViews()\n\n"},
  {"ResetDisplayEmptyViewsOn", PyvtkPVGeneralSettings_ResetDisplayEmptyViewsOn, METH_VARARGS,
   "ResetDisplayEmptyViewsOn(self) -> None\nC++: virtual void ResetDisplayEmptyViewsOn()\n\n"},
  {"ResetDisplayEmptyViewsOff", PyvtkPVGeneralSettings_ResetDisplayEmptyViewsOff, METH_VARARGS,
   "ResetDisplayEmptyViewsOff(self) -> None\nC++: virtual void ResetDisplayEmptyViewsOff()\n\n"},
  {"SetRealNumberDisplayedNotation", PyvtkPVGeneralSettings_SetRealNumberDisplayedNotation, METH_VARARGS,
   "SetRealNumberDisplayedNotation(self, _arg:int) -> None\nC++: virtual void SetRealNumberDisplayedNotation(int _arg)\n\nGet/Set the notation of real number displayed in widgets or\nviews.\n"},
  {"GetRealNumberDisplayedNotation", PyvtkPVGeneralSettings_GetRealNumberDisplayedNotation, METH_VARARGS,
   "GetRealNumberDisplayedNotation(self) -> int\nC++: virtual int GetRealNumberDisplayedNotation()\n\n"},
  {"SetRealNumberDisplayedShortestAccuratePrecision", PyvtkPVGeneralSettings_SetRealNumberDisplayedShortestAccuratePrecision, METH_VARARGS,
   "SetRealNumberDisplayedShortestAccuratePrecision(self, _arg:bool)\n    -> None\nC++: virtual void SetRealNumberDisplayedShortestAccuratePrecision(\n    bool _arg)\n\nGet/Set the usage of shortest accurate precision instead of\nactual precision for real numbers\n"},
  {"GetRealNumberDisplayedShortestAccuratePrecision", PyvtkPVGeneralSettings_GetRealNumberDisplayedShortestAccuratePrecision, METH_VARARGS,
   "GetRealNumberDisplayedShortestAccuratePrecision(self) -> bool\nC++: virtual bool GetRealNumberDisplayedShortestAccuratePrecision(\n    )\n\n"},
  {"SetRealNumberDisplayedPrecision", PyvtkPVGeneralSettings_SetRealNumberDisplayedPrecision, METH_VARARGS,
   "SetRealNumberDisplayedPrecision(self, _arg:int) -> None\nC++: virtual void SetRealNumberDisplayedPrecision(int _arg)\n\nGet/Set the precision of real number displayed in widgets or\nviews.\n"},
  {"GetRealNumberDisplayedPrecision", PyvtkPVGeneralSettings_GetRealNumberDisplayedPrecision, METH_VARARGS,
   "GetRealNumberDisplayedPrecision(self) -> int\nC++: virtual int GetRealNumberDisplayedPrecision()\n\n"},
  {"SetFullNotationLowExponent", PyvtkPVGeneralSettings_SetFullNotationLowExponent, METH_VARARGS,
   "SetFullNotationLowExponent(self, _arg:int) -> None\nC++: virtual void SetFullNotationLowExponent(int _arg)\n\nGet/Set the low exponent used with full notation\n"},
  {"GetFullNotationLowExponent", PyvtkPVGeneralSettings_GetFullNotationLowExponent, METH_VARARGS,
   "GetFullNotationLowExponent(self) -> int\nC++: virtual int GetFullNotationLowExponent()\n\n"},
  {"SetFullNotationHighExponent", PyvtkPVGeneralSettings_SetFullNotationHighExponent, METH_VARARGS,
   "SetFullNotationHighExponent(self, _arg:int) -> None\nC++: virtual void SetFullNotationHighExponent(int _arg)\n\nGet/Set the high exponent used with full notation\n"},
  {"GetFullNotationHighExponent", PyvtkPVGeneralSettings_GetFullNotationHighExponent, METH_VARARGS,
   "GetFullNotationHighExponent(self) -> int\nC++: virtual int GetFullNotationHighExponent()\n\n"},
  {"SetInheritRepresentationProperties", PyvtkPVGeneralSettings_SetInheritRepresentationProperties, METH_VARARGS,
   "SetInheritRepresentationProperties(self, _arg:bool) -> None\nC++: virtual void SetInheritRepresentationProperties(bool _arg)\n\nForwarded for vtkSMParaViewPipelineControllerWithRendering.\n"},
  {"GetInheritRepresentationProperties", PyvtkPVGeneralSettings_GetInheritRepresentationProperties, METH_VARARGS,
   "GetInheritRepresentationProperties(self) -> bool\nC++: virtual bool GetInheritRepresentationProperties()\n\n"},
  {"InheritRepresentationPropertiesOn", PyvtkPVGeneralSettings_InheritRepresentationPropertiesOn, METH_VARARGS,
   "InheritRepresentationPropertiesOn(self) -> None\nC++: virtual void InheritRepresentationPropertiesOn()\n\n"},
  {"InheritRepresentationPropertiesOff", PyvtkPVGeneralSettings_InheritRepresentationPropertiesOff, METH_VARARGS,
   "InheritRepresentationPropertiesOff(self) -> None\nC++: virtual void InheritRepresentationPropertiesOff()\n\n"},
  {"SetIgnoreNegativeLogAxisWarning", PyvtkPVGeneralSettings_SetIgnoreNegativeLogAxisWarning, METH_VARARGS,
   "SetIgnoreNegativeLogAxisWarning(self, _arg:bool) -> None\nC++: virtual void SetIgnoreNegativeLogAxisWarning(bool _arg)\n\nDescription: When plotting data with nonpositive values, ignore\nthe standard warning and draw only the data with positive values.\n"},
  {"GetIgnoreNegativeLogAxisWarning", PyvtkPVGeneralSettings_GetIgnoreNegativeLogAxisWarning, METH_VARARGS,
   "GetIgnoreNegativeLogAxisWarning(self) -> bool\nC++: virtual bool GetIgnoreNegativeLogAxisWarning()\n\n"},
  {"IgnoreNegativeLogAxisWarningOn", PyvtkPVGeneralSettings_IgnoreNegativeLogAxisWarningOn, METH_VARARGS,
   "IgnoreNegativeLogAxisWarningOn(self) -> None\nC++: virtual void IgnoreNegativeLogAxisWarningOn()\n\n"},
  {"IgnoreNegativeLogAxisWarningOff", PyvtkPVGeneralSettings_IgnoreNegativeLogAxisWarningOff, METH_VARARGS,
   "IgnoreNegativeLogAxisWarningOff(self) -> None\nC++: virtual void IgnoreNegativeLogAxisWarningOff()\n\n"},
  {"SetPropertiesPanelMode", PyvtkPVGeneralSettings_SetPropertiesPanelMode, METH_VARARGS,
   "SetPropertiesPanelMode(self, _arg:int) -> None\nC++: virtual void SetPropertiesPanelMode(int _arg)\n\nProperties panel configuration.\n"},
  {"GetPropertiesPanelMode", PyvtkPVGeneralSettings_GetPropertiesPanelMode, METH_VARARGS,
   "GetPropertiesPanelMode(self) -> int\nC++: virtual int GetPropertiesPanelMode()\n\n"},
  {"SetLockPanels", PyvtkPVGeneralSettings_SetLockPanels, METH_VARARGS,
   "SetLockPanels(self, _arg:bool) -> None\nC++: virtual void SetLockPanels(bool _arg)\n\nSet whether to dock widgets into place.\n"},
  {"GetLockPanels", PyvtkPVGeneralSettings_GetLockPanels, METH_VARARGS,
   "GetLockPanels(self) -> bool\nC++: virtual bool GetLockPanels()\n\n"},
  {"SetLoadAllVariables", PyvtkPVGeneralSettings_SetLoadAllVariables, METH_VARARGS,
   "SetLoadAllVariables(self, _arg:bool) -> None\nC++: virtual void SetLoadAllVariables(bool _arg)\n\nLoad all variables when loading a data set.\n"},
  {"GetLoadAllVariables", PyvtkPVGeneralSettings_GetLoadAllVariables, METH_VARARGS,
   "GetLoadAllVariables(self) -> bool\nC++: virtual bool GetLoadAllVariables()\n\n"},
  {"LoadAllVariablesOn", PyvtkPVGeneralSettings_LoadAllVariablesOn, METH_VARARGS,
   "LoadAllVariablesOn(self) -> None\nC++: virtual void LoadAllVariablesOn()\n\n"},
  {"LoadAllVariablesOff", PyvtkPVGeneralSettings_LoadAllVariablesOff, METH_VARARGS,
   "LoadAllVariablesOff(self) -> None\nC++: virtual void LoadAllVariablesOff()\n\n"},
  {"SetLoadNoChartVariables", PyvtkPVGeneralSettings_SetLoadNoChartVariables, METH_VARARGS,
   "SetLoadNoChartVariables(self, _arg:bool) -> None\nC++: virtual void SetLoadNoChartVariables(bool _arg)\n\nLoad no variables when showing a 2D chart.\n"},
  {"GetLoadNoChartVariables", PyvtkPVGeneralSettings_GetLoadNoChartVariables, METH_VARARGS,
   "GetLoadNoChartVariables(self) -> bool\nC++: virtual bool GetLoadNoChartVariables()\n\n"},
  {"LoadNoChartVariablesOn", PyvtkPVGeneralSettings_LoadNoChartVariablesOn, METH_VARARGS,
   "LoadNoChartVariablesOn(self) -> None\nC++: virtual void LoadNoChartVariablesOn()\n\n"},
  {"LoadNoChartVariablesOff", PyvtkPVGeneralSettings_LoadNoChartVariablesOff, METH_VARARGS,
   "LoadNoChartVariablesOff(self) -> None\nC++: virtual void LoadNoChartVariablesOff()\n\n"},
  {"SetGUIFontSize", PyvtkPVGeneralSettings_SetGUIFontSize, METH_VARARGS,
   "SetGUIFontSize(self, _arg:int) -> None\nC++: virtual void SetGUIFontSize(int _arg)\n\nGet/Set the GUI font size. This is used only if GUIOverrideFont\nis true.\n"},
  {"GetGUIFontSizeMinValue", PyvtkPVGeneralSettings_GetGUIFontSizeMinValue, METH_VARARGS,
   "GetGUIFontSizeMinValue(self) -> int\nC++: virtual int GetGUIFontSizeMinValue()\n\n"},
  {"GetGUIFontSizeMaxValue", PyvtkPVGeneralSettings_GetGUIFontSizeMaxValue, METH_VARARGS,
   "GetGUIFontSizeMaxValue(self) -> int\nC++: virtual int GetGUIFontSizeMaxValue()\n\n"},
  {"GetGUIFontSize", PyvtkPVGeneralSettings_GetGUIFontSize, METH_VARARGS,
   "GetGUIFontSize(self) -> int\nC++: virtual int GetGUIFontSize()\n\n"},
  {"SetGUIOverrideFont", PyvtkPVGeneralSettings_SetGUIOverrideFont, METH_VARARGS,
   "SetGUIOverrideFont(self, _arg:bool) -> None\nC++: virtual void SetGUIOverrideFont(bool _arg)\n\nGet/Set whether the GUIFontSize should be used.\n"},
  {"GetGUIOverrideFont", PyvtkPVGeneralSettings_GetGUIOverrideFont, METH_VARARGS,
   "GetGUIOverrideFont(self) -> bool\nC++: virtual bool GetGUIOverrideFont()\n\n"},
  {"SetColorByBlockColorsOnApply", PyvtkPVGeneralSettings_SetColorByBlockColorsOnApply, METH_VARARGS,
   "SetColorByBlockColorsOnApply(self, _arg:bool) -> None\nC++: virtual void SetColorByBlockColorsOnApply(bool _arg)\n\nAutomatically color by **vtkBlockColors** if array is present on\n`Apply`.\n"},
  {"GetColorByBlockColorsOnApply", PyvtkPVGeneralSettings_GetColorByBlockColorsOnApply, METH_VARARGS,
   "GetColorByBlockColorsOnApply(self) -> bool\nC++: virtual bool GetColorByBlockColorsOnApply()\n\n"},
  {"SetEnableStreaming", PyvtkPVGeneralSettings_SetEnableStreaming, METH_VARARGS,
   "SetEnableStreaming(self, _arg:bool) -> None\nC++: virtual void SetEnableStreaming(bool _arg)\n\nTurn on streamed rendering.\n"},
  {"GetEnableStreaming", PyvtkPVGeneralSettings_GetEnableStreaming, METH_VARARGS,
   "GetEnableStreaming(self) -> bool\nC++: virtual bool GetEnableStreaming()\n\n"},
  {"EnableStreamingOn", PyvtkPVGeneralSettings_EnableStreamingOn, METH_VARARGS,
   "EnableStreamingOn(self) -> None\nC++: virtual void EnableStreamingOn()\n\n"},
  {"EnableStreamingOff", PyvtkPVGeneralSettings_EnableStreamingOff, METH_VARARGS,
   "EnableStreamingOff(self) -> None\nC++: virtual void EnableStreamingOff()\n\n"},
  {"SetUseAcceleratedFilters", PyvtkPVGeneralSettings_SetUseAcceleratedFilters, METH_VARARGS,
   "SetUseAcceleratedFilters(self, __a:bool) -> None\nC++: void SetUseAcceleratedFilters(bool)\n\nEnable use of accelerated filters where available.\n"},
  {"GetUseAcceleratedFilters", PyvtkPVGeneralSettings_GetUseAcceleratedFilters, METH_VARARGS,
   "GetUseAcceleratedFilters(self) -> bool\nC++: bool GetUseAcceleratedFilters()\n\n"},
  {"UseAcceleratedFiltersOn", PyvtkPVGeneralSettings_UseAcceleratedFiltersOn, METH_VARARGS,
   "UseAcceleratedFiltersOn(self) -> None\nC++: virtual void UseAcceleratedFiltersOn()\n\n"},
  {"UseAcceleratedFiltersOff", PyvtkPVGeneralSettings_UseAcceleratedFiltersOff, METH_VARARGS,
   "UseAcceleratedFiltersOff(self) -> None\nC++: virtual void UseAcceleratedFiltersOff()\n\n"},
  {"GetSelectOnClickMultiBlockInspector", PyvtkPVGeneralSettings_GetSelectOnClickMultiBlockInspector, METH_VARARGS,
   "GetSelectOnClickMultiBlockInspector(self) -> bool\nC++: virtual bool GetSelectOnClickMultiBlockInspector()\n\nActiveSelection is hooked up in the MultiBlock Inspector such\nthat a click on a/multiple block(s) selects it/them. Default is\ntrue.\n"},
  {"SetSelectOnClickMultiBlockInspector", PyvtkPVGeneralSettings_SetSelectOnClickMultiBlockInspector, METH_VARARGS,
   "SetSelectOnClickMultiBlockInspector(self, _arg:bool) -> None\nC++: virtual void SetSelectOnClickMultiBlockInspector(bool _arg)\n\n"},
  {"GetNumberOfCallbackThreads", PyvtkPVGeneralSettings_GetNumberOfCallbackThreads, METH_VARARGS,
   "GetNumberOfCallbackThreads() -> int\nC++: static int GetNumberOfCallbackThreads()\n\nSets the number of threads that are used for\n`vtkPVSession::ThreadedCallbackQueue`.\n"},
  {"SetNumberOfCallbackThreads", PyvtkPVGeneralSettings_SetNumberOfCallbackThreads, METH_VARARGS,
   "SetNumberOfCallbackThreads(__a:int) -> None\nC++: static void SetNumberOfCallbackThreads(int)\n\n"},
  {"GetNumberOfSMPThreads", PyvtkPVGeneralSettings_GetNumberOfSMPThreads, METH_VARARGS,
   "GetNumberOfSMPThreads() -> int\nC++: static int GetNumberOfSMPThreads()\n\nSets the number of threads that are used by `vtkSMPTools`.\n"},
  {"SetNumberOfSMPThreads", PyvtkPVGeneralSettings_SetNumberOfSMPThreads, METH_VARARGS,
   "SetNumberOfSMPThreads(__a:int) -> None\nC++: static void SetNumberOfSMPThreads(int)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVGeneralSettings_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("auto_convert_properties"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetAutoConvertProperties(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetAutoConvertProperties(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetAutoConvertProperties(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAutoConvertProperties/SetAutoConvertProperties\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("block_colors_distinct_values"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetBlockColorsDistinctValues(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetBlockColorsDistinctValues(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetBlockColorsDistinctValues(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBlockColorsDistinctValues/SetBlockColorsDistinctValues\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("auto_apply"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetAutoApply(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetAutoApply(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetAutoApply(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAutoApply/SetAutoApply\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("auto_apply_delay"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetAutoApplyDelay(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetAutoApplyDelay(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetAutoApplyDelay(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAutoApplyDelay/SetAutoApplyDelay\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("auto_apply_active_only"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetAutoApplyActiveOnly(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetAutoApplyActiveOnly(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetAutoApplyActiveOnly(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAutoApplyActiveOnly/SetAutoApplyActiveOnly\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("preserve_property_values"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetPreservePropertyValues(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetPreservePropertyValues(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetPreservePropertyValues(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPreservePropertyValues/SetPreservePropertyValues\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("default_view_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetDefaultViewType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetDefaultViewType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetDefaultViewType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDefaultViewType/SetDefaultViewType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interface_language"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetInterfaceLanguage(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetInterfaceLanguage(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetInterfaceLanguage(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInterfaceLanguage/SetInterfaceLanguage\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scalar_bar_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetScalarBarMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetScalarBarMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetScalarBarMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetScalarBarMode/SetScalarBarMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cache_geometry_for_animation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetCacheGeometryForAnimation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetCacheGeometryForAnimation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetCacheGeometryForAnimation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCacheGeometryForAnimation/SetCacheGeometryForAnimation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("animation_geometry_cache_limit"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetAnimationGeometryCacheLimit(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetAnimationGeometryCacheLimit(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetAnimationGeometryCacheLimit(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAnimationGeometryCacheLimit/SetAnimationGeometryCacheLimit\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("animation_time_notation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetAnimationTimeNotation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetAnimationTimeNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetAnimationTimeNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAnimationTimeNotation/SetAnimationTimeNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("animation_time_shortest_accurate_precision"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetAnimationTimeShortestAccuratePrecision(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetAnimationTimeShortestAccuratePrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetAnimationTimeShortestAccuratePrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAnimationTimeShortestAccuratePrecision/SetAnimationTimeShortestAccuratePrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("animation_time_precision"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetAnimationTimePrecision(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetAnimationTimePrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetAnimationTimePrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAnimationTimePrecision/SetAnimationTimePrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("show_animation_shortcuts"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetShowAnimationShortcuts(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetShowAnimationShortcuts(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetShowAnimationShortcuts(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetShowAnimationShortcuts/SetShowAnimationShortcuts\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("reset_display_empty_views"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetResetDisplayEmptyViews(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetResetDisplayEmptyViews(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetResetDisplayEmptyViews(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetResetDisplayEmptyViews/SetResetDisplayEmptyViews\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("real_number_displayed_notation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetRealNumberDisplayedNotation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetRealNumberDisplayedNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetRealNumberDisplayedNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRealNumberDisplayedNotation/SetRealNumberDisplayedNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("real_number_displayed_shortest_accurate_precision"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetRealNumberDisplayedShortestAccuratePrecision(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetRealNumberDisplayedShortestAccuratePrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetRealNumberDisplayedShortestAccuratePrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRealNumberDisplayedShortestAccuratePrecision/SetRealNumberDisplayedShortestAccuratePrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("real_number_displayed_precision"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetRealNumberDisplayedPrecision(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetRealNumberDisplayedPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetRealNumberDisplayedPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRealNumberDisplayedPrecision/SetRealNumberDisplayedPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("full_notation_low_exponent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetFullNotationLowExponent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetFullNotationLowExponent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetFullNotationLowExponent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFullNotationLowExponent/SetFullNotationLowExponent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("full_notation_high_exponent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetFullNotationHighExponent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetFullNotationHighExponent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetFullNotationHighExponent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFullNotationHighExponent/SetFullNotationHighExponent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("inherit_representation_properties"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetInheritRepresentationProperties(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetInheritRepresentationProperties(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetInheritRepresentationProperties(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInheritRepresentationProperties/SetInheritRepresentationProperties\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ignore_negative_log_axis_warning"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetIgnoreNegativeLogAxisWarning(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetIgnoreNegativeLogAxisWarning(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetIgnoreNegativeLogAxisWarning(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIgnoreNegativeLogAxisWarning/SetIgnoreNegativeLogAxisWarning\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("properties_panel_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetPropertiesPanelMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetPropertiesPanelMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetPropertiesPanelMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPropertiesPanelMode/SetPropertiesPanelMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("lock_panels"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetLockPanels(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetLockPanels(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetLockPanels(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLockPanels/SetLockPanels\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("load_all_variables"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetLoadAllVariables(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetLoadAllVariables(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetLoadAllVariables(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLoadAllVariables/SetLoadAllVariables\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("load_no_chart_variables"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetLoadNoChartVariables(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetLoadNoChartVariables(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetLoadNoChartVariables(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLoadNoChartVariables/SetLoadNoChartVariables\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("gui_font_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetGUIFontSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetGUIFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetGUIFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGUIFontSize/SetGUIFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("gui_override_font"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetGUIOverrideFont(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetGUIOverrideFont(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetGUIOverrideFont(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGUIOverrideFont/SetGUIOverrideFont\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("color_by_block_colors_on_apply"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetColorByBlockColorsOnApply(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetColorByBlockColorsOnApply(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetColorByBlockColorsOnApply(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetColorByBlockColorsOnApply/SetColorByBlockColorsOnApply\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_streaming"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetEnableStreaming(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetEnableStreaming(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetEnableStreaming(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableStreaming/SetEnableStreaming\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_accelerated_filters"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetUseAcceleratedFilters(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetUseAcceleratedFilters(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetUseAcceleratedFilters(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseAcceleratedFilters/SetUseAcceleratedFilters\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("select_on_click_multi_block_inspector"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetSelectOnClickMultiBlockInspector(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetSelectOnClickMultiBlockInspector(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetSelectOnClickMultiBlockInspector(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSelectOnClickMultiBlockInspector/SetSelectOnClickMultiBlockInspector\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("instance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetInstance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInstance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_callback_threads"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetNumberOfCallbackThreads(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetNumberOfCallbackThreads(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetNumberOfCallbackThreads(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfCallbackThreads/SetNumberOfCallbackThreads\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_smp_threads"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGeneralSettings_GetNumberOfSMPThreads(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGeneralSettings_SetNumberOfSMPThreads(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGeneralSettings_SetNumberOfSMPThreads(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfSMPThreads/SetNumberOfSMPThreads\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVGeneralSettings_Doc =
  "vtkPVGeneralSettings - object for general options.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkPVGeneralSettings keeps track of general options in a ParaView\n"
  "application. This is a singleton. All calls to\n"
  "vtkPVGeneralSettings::New() return a pointer to the same global\n"
  "instance (with reference count incremented as expected).\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVGeneralSettings_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingSettings.vtkPVGeneralSettings", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVGeneralSettings_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVGeneralSettings_StaticNew()
{
  return vtkPVGeneralSettings::New();
}

PyObject *PyvtkPVGeneralSettings_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVGeneralSettings_Type, PyvtkPVGeneralSettings_Methods,
    "vtkPVGeneralSettings",
 &PyvtkPVGeneralSettings_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkPVGeneralSettings_RealNumberNotation_Type);
  PyVTKEnum_Add(&PyvtkPVGeneralSettings_RealNumberNotation_Type, "vtkPVGeneralSettings.RealNumberNotation");

  o = (PyObject *)&PyvtkPVGeneralSettings_RealNumberNotation_Type;
  if (PyDict_SetItemString(d, "RealNumberNotation", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 6; c++)
  {
    static const struct { const char *name; int value; }
      constants[6] = {
        { "DEFAULT_TIME_STEP_UNCHANGED", vtkPVGeneralSettings::DEFAULT_TIME_STEP_UNCHANGED },
        { "DEFAULT_TIME_STEP_FIRST", vtkPVGeneralSettings::DEFAULT_TIME_STEP_FIRST },
        { "DEFAULT_TIME_STEP_LAST", vtkPVGeneralSettings::DEFAULT_TIME_STEP_LAST },
        { "AUTOMATICALLY_SHOW_AND_HIDE_SCALAR_BARS", vtkPVGeneralSettings::AUTOMATICALLY_SHOW_AND_HIDE_SCALAR_BARS },
        { "AUTOMATICALLY_HIDE_SCALAR_BARS", vtkPVGeneralSettings::AUTOMATICALLY_HIDE_SCALAR_BARS },
        { "MANUAL_SCALAR_BARS", vtkPVGeneralSettings::MANUAL_SCALAR_BARS },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  for (int c = 0; c < 4; c++)
  {
    typedef vtkPVGeneralSettings::RealNumberNotation cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[4] = {
        { "MIXED", vtkPVGeneralSettings::MIXED },
        { "SCIENTIFIC", vtkPVGeneralSettings::SCIENTIFIC },
        { "FIXED", vtkPVGeneralSettings::FIXED },
        { "FULL", vtkPVGeneralSettings::FULL },
      };

    o = PyvtkPVGeneralSettings_RealNumberNotation_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  for (int c = 0; c < 4; c++)
  {
    static const struct { const char *name; int value; }
      constants[4] = {
        { "ALL_IN_ONE", vtkPVGeneralSettings::ALL_IN_ONE },
        { "SEPARATE_DISPLAY_PROPERTIES", vtkPVGeneralSettings::SEPARATE_DISPLAY_PROPERTIES },
        { "SEPARATE_VIEW_PROPERTIES", vtkPVGeneralSettings::SEPARATE_VIEW_PROPERTIES },
        { "ALL_SEPARATE", vtkPVGeneralSettings::ALL_SEPARATE },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVGeneralSettings_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVGeneralSettings(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVGeneralSettings_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVGeneralSettings", o) != 0)
  {
    Py_DECREF(o);
  }

}

