// python wrapper for vtkQuartileChartRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkQuartileChartRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkQuartileChartRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkQuartileChartRepresentation_ClassNew(); }

#ifndef DECLARED_PyvtkXYChartRepresentation_ClassNew
extern "C" { PyObject *PyvtkXYChartRepresentation_ClassNew(); }
#define DECLARED_PyvtkXYChartRepresentation_ClassNew
#endif

static PyObject *
PyvtkQuartileChartRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkQuartileChartRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkQuartileChartRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkQuartileChartRepresentation *tempr = vtkQuartileChartRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkQuartileChartRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkQuartileChartRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkQuartileChartRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkQuartileChartRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_GetDefaultSeriesLabel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDefaultSeriesLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  std::string temp0;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetDefaultSeriesLabel(temp0, temp1) :
      op->vtkQuartileChartRepresentation::GetDefaultSeriesLabel(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_SetQuartileVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetQuartileVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetQuartileVisibility(temp0);
    }
    else
    {
      op->vtkQuartileChartRepresentation::SetQuartileVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_GetQuartileVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetQuartileVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetQuartileVisibility() :
      op->vtkQuartileChartRepresentation::GetQuartileVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_SetRangeVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRangeVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRangeVisibility(temp0);
    }
    else
    {
      op->vtkQuartileChartRepresentation::SetRangeVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_GetRangeVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRangeVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRangeVisibility() :
      op->vtkQuartileChartRepresentation::GetRangeVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_SetAverageVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAverageVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAverageVisibility(temp0);
    }
    else
    {
      op->vtkQuartileChartRepresentation::SetAverageVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_GetAverageVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAverageVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAverageVisibility() :
      op->vtkQuartileChartRepresentation::GetAverageVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_SetMedianVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMedianVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMedianVisibility(temp0);
    }
    else
    {
      op->vtkQuartileChartRepresentation::SetMedianVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_GetMedianVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMedianVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetMedianVisibility() :
      op->vtkQuartileChartRepresentation::GetMedianVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_SetMinVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMinVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMinVisibility(temp0);
    }
    else
    {
      op->vtkQuartileChartRepresentation::SetMinVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_GetMinVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMinVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetMinVisibility() :
      op->vtkQuartileChartRepresentation::GetMinVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_SetMaxVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaxVisibility(temp0);
    }
    else
    {
      op->vtkQuartileChartRepresentation::SetMaxVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_GetMaxVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetMaxVisibility() :
      op->vtkQuartileChartRepresentation::GetMaxVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_SetSumVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSumVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSumVisibility(temp0);
    }
    else
    {
      op->vtkQuartileChartRepresentation::SetSumVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkQuartileChartRepresentation_GetSumVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSumVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkQuartileChartRepresentation *op = static_cast<vtkQuartileChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSumVisibility() :
      op->vtkQuartileChartRepresentation::GetSumVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkQuartileChartRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkQuartileChartRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkQuartileChartRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkQuartileChartRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkQuartileChartRepresentation\nC++: static vtkQuartileChartRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkQuartileChartRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkQuartileChartRepresentation\nC++: vtkQuartileChartRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkQuartileChartRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkQuartileChartRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetDefaultSeriesLabel", PyvtkQuartileChartRepresentation_GetDefaultSeriesLabel, METH_VARARGS,
   "GetDefaultSeriesLabel(self, tableName:str, columnName:str) -> str\nC++: std::string GetDefaultSeriesLabel(\n    const std::string &tableName, const std::string &columnName)\n    override;\n\nOverridden to format the series name to remove the operation\napplied e.g. a columnName of \"min(EQPS)\" and \"max(EQPS)\" both\nwill return \"EQPS\".\n"},
  {"SetQuartileVisibility", PyvtkQuartileChartRepresentation_SetQuartileVisibility, METH_VARARGS,
   "SetQuartileVisibility(self, _arg:bool) -> None\nC++: virtual void SetQuartileVisibility(bool _arg)\n\nWhen set to true, q1/q3 region is rendered.\n"},
  {"GetQuartileVisibility", PyvtkQuartileChartRepresentation_GetQuartileVisibility, METH_VARARGS,
   "GetQuartileVisibility(self) -> bool\nC++: virtual bool GetQuartileVisibility()\n\n"},
  {"SetRangeVisibility", PyvtkQuartileChartRepresentation_SetRangeVisibility, METH_VARARGS,
   "SetRangeVisibility(self, _arg:bool) -> None\nC++: virtual void SetRangeVisibility(bool _arg)\n\nWhen set to true, min/max region is rendered.\n"},
  {"GetRangeVisibility", PyvtkQuartileChartRepresentation_GetRangeVisibility, METH_VARARGS,
   "GetRangeVisibility(self) -> bool\nC++: virtual bool GetRangeVisibility()\n\n"},
  {"SetAverageVisibility", PyvtkQuartileChartRepresentation_SetAverageVisibility, METH_VARARGS,
   "SetAverageVisibility(self, _arg:bool) -> None\nC++: virtual void SetAverageVisibility(bool _arg)\n\nWhen set to true, the avg curve is rendered.\n"},
  {"GetAverageVisibility", PyvtkQuartileChartRepresentation_GetAverageVisibility, METH_VARARGS,
   "GetAverageVisibility(self) -> bool\nC++: virtual bool GetAverageVisibility()\n\n"},
  {"SetMedianVisibility", PyvtkQuartileChartRepresentation_SetMedianVisibility, METH_VARARGS,
   "SetMedianVisibility(self, _arg:bool) -> None\nC++: virtual void SetMedianVisibility(bool _arg)\n\nWhen set to true, the med curve is rendered.\n"},
  {"GetMedianVisibility", PyvtkQuartileChartRepresentation_GetMedianVisibility, METH_VARARGS,
   "GetMedianVisibility(self) -> bool\nC++: virtual bool GetMedianVisibility()\n\n"},
  {"SetMinVisibility", PyvtkQuartileChartRepresentation_SetMinVisibility, METH_VARARGS,
   "SetMinVisibility(self, _arg:bool) -> None\nC++: virtual void SetMinVisibility(bool _arg)\n\nWhen set to true, the min curve is rendered.\n"},
  {"GetMinVisibility", PyvtkQuartileChartRepresentation_GetMinVisibility, METH_VARARGS,
   "GetMinVisibility(self) -> bool\nC++: virtual bool GetMinVisibility()\n\n"},
  {"SetMaxVisibility", PyvtkQuartileChartRepresentation_SetMaxVisibility, METH_VARARGS,
   "SetMaxVisibility(self, _arg:bool) -> None\nC++: virtual void SetMaxVisibility(bool _arg)\n\nWhen set to true, the max curve is rendered.\n"},
  {"GetMaxVisibility", PyvtkQuartileChartRepresentation_GetMaxVisibility, METH_VARARGS,
   "GetMaxVisibility(self) -> bool\nC++: virtual bool GetMaxVisibility()\n\n"},
  {"SetSumVisibility", PyvtkQuartileChartRepresentation_SetSumVisibility, METH_VARARGS,
   "SetSumVisibility(self, _arg:bool) -> None\nC++: virtual void SetSumVisibility(bool _arg)\n\nWhen set to true, the max curve is rendered.\n"},
  {"GetSumVisibility", PyvtkQuartileChartRepresentation_GetSumVisibility, METH_VARARGS,
   "GetSumVisibility(self) -> bool\nC++: virtual bool GetSumVisibility()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkQuartileChartRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("quartile_visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkQuartileChartRepresentation_GetQuartileVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkQuartileChartRepresentation_SetQuartileVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkQuartileChartRepresentation_SetQuartileVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetQuartileVisibility/SetQuartileVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("range_visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkQuartileChartRepresentation_GetRangeVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkQuartileChartRepresentation_SetRangeVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkQuartileChartRepresentation_SetRangeVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRangeVisibility/SetRangeVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("average_visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkQuartileChartRepresentation_GetAverageVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkQuartileChartRepresentation_SetAverageVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkQuartileChartRepresentation_SetAverageVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAverageVisibility/SetAverageVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("median_visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkQuartileChartRepresentation_GetMedianVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkQuartileChartRepresentation_SetMedianVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkQuartileChartRepresentation_SetMedianVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMedianVisibility/SetMedianVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("min_visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkQuartileChartRepresentation_GetMinVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkQuartileChartRepresentation_SetMinVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkQuartileChartRepresentation_SetMinVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMinVisibility/SetMinVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("max_visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkQuartileChartRepresentation_GetMaxVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkQuartileChartRepresentation_SetMaxVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkQuartileChartRepresentation_SetMaxVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaxVisibility/SetMaxVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sum_visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkQuartileChartRepresentation_GetSumVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkQuartileChartRepresentation_SetSumVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkQuartileChartRepresentation_SetSumVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSumVisibility/SetSumVisibility\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkQuartileChartRepresentation_Doc =
  "vtkQuartileChartRepresentation - vtkQuartileChartRepresentation\nextends to vtkXYChartRepresentation to add support for combining\nquartile plots.\n\n"
  "Superclass: vtkXYChartRepresentation\n\n"
  "A quartile plot is created by treating multiple input arrays are\n"
  "ranges for area plots. All properties, like color, label etc. are\n"
  "specified collectively.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkQuartileChartRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkQuartileChartRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkQuartileChartRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkQuartileChartRepresentation_StaticNew()
{
  return vtkQuartileChartRepresentation::New();
}

PyObject *PyvtkQuartileChartRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkQuartileChartRepresentation_Type, PyvtkQuartileChartRepresentation_Methods,
    "vtkQuartileChartRepresentation",
 &PyvtkQuartileChartRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkXYChartRepresentation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkQuartileChartRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkQuartileChartRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkQuartileChartRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkQuartileChartRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

