// python wrapper for vtkPVPythonPluginInterface
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkPVPythonPluginInterface.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVPythonPluginInterface(PyObject *dict); }

static PyObject *
PyvtkPVPythonPluginInterface_GetPythonSourceList(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPythonSourceList");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPythonPluginInterface *op = static_cast<vtkPVPythonPluginInterface *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  std::vector<std::string> temp1(ap.GetArgSize(1));
  std::vector<int> temp2(ap.GetArgSize(2));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetArray(temp0.data(), temp0.size()) &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetArray(temp2.data(), temp2.size()))
  {
    op->GetPythonSourceList(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      PyObject *vec = (temp0.empty() ?
        PyTuple_New(0) :
        vtkPythonArgs::BuildTuple(temp0.data(), temp0.size()));
      ap.SetContents(0, vec);
      Py_DECREF(vec);
    }

    if (!ap.ErrorOccurred())
    {
      PyObject *vec = (temp1.empty() ?
        PyTuple_New(0) :
        vtkPythonArgs::BuildTuple(temp1.data(), temp1.size()));
      ap.SetContents(1, vec);
      Py_DECREF(vec);
    }

    if (!ap.ErrorOccurred())
    {
      PyObject *vec = (temp2.empty() ?
        PyTuple_New(0) :
        vtkPythonArgs::BuildTuple(temp2.data(), temp2.size()));
      ap.SetContents(2, vec);
      Py_DECREF(vec);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVPythonPluginInterface_Methods[] = {
  {"GetPythonSourceList", PyvtkPVPythonPluginInterface_GetPythonSourceList, METH_VARARGS,
   "GetPythonSourceList(self, modules:[str, ...], sources:[str, ...],\n    package_flags:[int, ...]) -> None\nC++: virtual void GetPythonSourceList(\n    std::vector<std::string> &modules,\n    std::vector<std::string> &sources,\n    std::vector<int> &package_flags)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVPythonPluginInterface_GetSets[] = {
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static const char *PyvtkPVPythonPluginInterface_Doc =
  "vtkPVPythonPluginInterface - vtkPVPythonPluginInterface defines the\ninterface required by ParaView plugins that add python modules to\nParaView.\n\n"
;

static PyObject *
PyvtkPVPythonPluginInterface_New(PyTypeObject * /*unused*/, PyObject * /*unused*/, PyObject * /*unused*/)
{
  PyErr_SetString(PyExc_TypeError,
                  "this class cannot be instantiated");

  return nullptr;
}

static void PyvtkPVPythonPluginInterface_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkPVPythonPluginInterface *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkPVPythonPluginInterface_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVPythonPluginInterface_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVPythonPluginInterface", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkPVPythonPluginInterface_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkPVPythonPluginInterface_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkPVPythonPluginInterface_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkPVPythonPluginInterface_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

#ifndef DECLARED_PyvtkPVPythonPluginInterface_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVPythonPluginInterface_TypeNew(); }
#define DECLARED_PyvtkPVPythonPluginInterface_TypeNew
#endif

PyObject *PyvtkPVPythonPluginInterface_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkPVPythonPluginInterface_Type,
    PyvtkPVPythonPluginInterface_Methods,
    PyvtkPVPythonPluginInterface_GetSets,
    nullptr,
    nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVPythonPluginInterface(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVPythonPluginInterface_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkPVPythonPluginInterface", o) != 0)
  {
    Py_DECREF(o);
  }

}

