// python wrapper for vtkSIDataArraySelectionProperty
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSIDataArraySelectionProperty.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSIDataArraySelectionProperty(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSIDataArraySelectionProperty_ClassNew(); }

#ifndef DECLARED_PyvtkSIProperty_ClassNew
extern "C" { PyObject *PyvtkSIProperty_ClassNew(); }
#define DECLARED_PyvtkSIProperty_ClassNew
#endif

static PyObject *
PyvtkSIDataArraySelectionProperty_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSIDataArraySelectionProperty::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSIDataArraySelectionProperty_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSIDataArraySelectionProperty *op = static_cast<vtkSIDataArraySelectionProperty *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSIDataArraySelectionProperty::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSIDataArraySelectionProperty_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSIDataArraySelectionProperty *tempr = vtkSIDataArraySelectionProperty::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSIDataArraySelectionProperty_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSIDataArraySelectionProperty *op = static_cast<vtkSIDataArraySelectionProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSIDataArraySelectionProperty *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSIDataArraySelectionProperty::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSIDataArraySelectionProperty_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSIDataArraySelectionProperty::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSIDataArraySelectionProperty_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSIDataArraySelectionProperty *op = static_cast<vtkSIDataArraySelectionProperty *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSIDataArraySelectionProperty::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSIDataArraySelectionProperty_Methods[] = {
  {"IsTypeOf", PyvtkSIDataArraySelectionProperty_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSIDataArraySelectionProperty_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSIDataArraySelectionProperty_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSIDataArraySelectionProperty\nC++: static vtkSIDataArraySelectionProperty *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSIDataArraySelectionProperty_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSIDataArraySelectionProperty\nC++: vtkSIDataArraySelectionProperty *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSIDataArraySelectionProperty_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSIDataArraySelectionProperty_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSIDataArraySelectionProperty_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSIDataArraySelectionProperty_Doc =
  "vtkSIDataArraySelectionProperty - supports API using\nvtkDataArraySelection.\n\n"
  "Superclass: vtkSIProperty\n\n"
  "vtkSIDataArraySelectionProperty can be used to get/set array\n"
  "selection status parameters on a VTK object using\n"
  "vtkDataArraySelection. Readers typically offer API to get information\n"
  "about data array available as well as enable/disable arrays to read\n"
  "using a vtkDataArraySelection instance e.g.\n"
  "`vtkXMLReader::GetPointDataArraySelection`. This si-property can be\n"
  "used on vtkSMStringVectorProperty instances that use such an API on\n"
  "the reader to both get array selection status as well as set them.\n\n"
  "This offers a convenient replacement for vtkSIArraySelectionProperty\n"
  "which requires a quirky API on the VTK class to get/set similar\n"
  "information and is recommended over vtkSIArraySelectionProperty in\n"
  "new code.\n\n"
  "To use vtkSIDataArraySelectionProperty, simply add this as the\n"
  "`si_class` on the properties for getting and setting array selection\n"
  "with `command` set to the method name that returns a mutable\n"
  "vtkDataArraySelection instance.\n\n"
  "e.g.{xml}\n"
  "  <SourceProxy name=\"AMReXParticlesReader\"\n"
  "class=\"vtkAMReXParticlesReader\">\n"
  "    ...\n"
  "    <!-- this is the property to get the status -->\n"
  "    <StringVectorProperty name=\"PointArrayInfo\"\n"
  "      command=\"GetPointDataArraySelection\"\n"
  "      number_of_elements_per_command=\"2\"\n"
  "      information_only=\"1\"\n"
  "      si_class=\"vtkSIDataArraySelectionProperty\" />\n\n\n"
  "    <!-- this is the property to set he status -->\n"
  "    <StringVectorProperty name=\"PointArrayStatus\"\n"
  "      command=\"GetPointDataArraySelection\"\n"
  "      information_property=\"PointArrayInfo\"\n"
  "      number_of_elements_per_command=\"2\"\n"
  "      element_types=\"2 0\"\n"
  "      repeat_command=\"1\"\n"
  "      si_class=\"vtkSIDataArraySelectionProperty\">\n"
  "      <ArraySelectionDomain name=\"array_list\">\n"
  "        \n"
  "          <Property function=\"ArrayList\" name=\"PointArrayInfo\" />\n"
  "        \n"
  "      \n"
  "      Select the point arrays to read load.\n"
  "    \n"
  "    ...\n"
  " \n\n"
  "vtkSIDataArraySelectionProperty can also be used for filters that use\n"
  "vtkDataArraySelection.\n\n"
  "{xml}\n"
  "  <SourceProxy class=\"vtkPassSelectedArrays\" name=\"PassArrays\">\n"
  "     ...\n"
  "     <InputProperty name=\"Input\" >\n"
  "       <InputArrayDomain name=\"point_arrays\" attribute_type=\"point\"\n"
  "optional=\"1\" />\n"
  "     \n"
  "     <StringVectorProperty\n"
  "         name=\"PointDataArraySelection\"\n"
  "         command=\"GetPointDataArraySelection\"\n"
  "         number_of_elements_per_command=\"1\"\n"
  "         repeat_command=\"1\"\n"
  "         si_class=\"vtkSIDataArraySelectionProperty\">\n"
  "         <ArrayListDomain name=\"array_list\"\n"
  "input_domain_name=\"point_arrays\">\n"
  "           \n"
  "             <Property name=\"Input\" function=\"Input\" />\n"
  "           \n"
  "         \n"
  "     \n"
  "     ...\n"
  "  \n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSIDataArraySelectionProperty_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSIDataArraySelectionProperty", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSIDataArraySelectionProperty_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSIDataArraySelectionProperty_StaticNew()
{
  return vtkSIDataArraySelectionProperty::New();
}

PyObject *PyvtkSIDataArraySelectionProperty_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSIDataArraySelectionProperty_Type, PyvtkSIDataArraySelectionProperty_Methods,
    "vtkSIDataArraySelectionProperty",
 &PyvtkSIDataArraySelectionProperty_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSIProperty_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSIDataArraySelectionProperty_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSIDataArraySelectionProperty(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSIDataArraySelectionProperty_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSIDataArraySelectionProperty", o) != 0)
  {
    Py_DECREF(o);
  }

}

