// python wrapper for vtk3DWidgetRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtk3DWidgetRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtk3DWidgetRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *Pyvtk3DWidgetRepresentation_ClassNew(); }


static PyObject *
Pyvtk3DWidgetRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtk3DWidgetRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtk3DWidgetRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtk3DWidgetRepresentation *tempr = vtk3DWidgetRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtk3DWidgetRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtk3DWidgetRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtk3DWidgetRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtk3DWidgetRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_SetWidget(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWidget");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  vtkAbstractWidget *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAbstractWidget"))
  {
    if (ap.IsBound())
    {
      op->SetWidget(temp0);
    }
    else
    {
      op->vtk3DWidgetRepresentation::SetWidget(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_GetWidget(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWidget");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAbstractWidget *tempr = (ap.IsBound() ?
      op->GetWidget() :
      op->vtk3DWidgetRepresentation::GetWidget());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_SetRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  vtkWidgetRepresentation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkWidgetRepresentation"))
  {
    if (ap.IsBound())
    {
      op->SetRepresentation(temp0);
    }
    else
    {
      op->vtk3DWidgetRepresentation::SetRepresentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_GetRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkWidgetRepresentation *tempr = (ap.IsBound() ?
      op->GetRepresentation() :
      op->vtk3DWidgetRepresentation::GetRepresentation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_SetUseNonCompositedRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseNonCompositedRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseNonCompositedRenderer(temp0);
    }
    else
    {
      op->vtk3DWidgetRepresentation::SetUseNonCompositedRenderer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_GetUseNonCompositedRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseNonCompositedRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseNonCompositedRenderer() :
      op->vtk3DWidgetRepresentation::GetUseNonCompositedRenderer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_UseNonCompositedRendererOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseNonCompositedRendererOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseNonCompositedRendererOn();
    }
    else
    {
      op->vtk3DWidgetRepresentation::UseNonCompositedRendererOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_UseNonCompositedRendererOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseNonCompositedRendererOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseNonCompositedRendererOff();
    }
    else
    {
      op->vtk3DWidgetRepresentation::UseNonCompositedRendererOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_SetEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnabled(temp0);
    }
    else
    {
      op->vtk3DWidgetRepresentation::SetEnabled(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_GetEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnabled() :
      op->vtk3DWidgetRepresentation::GetEnabled());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_EnabledOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnabledOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnabledOn();
    }
    else
    {
      op->vtk3DWidgetRepresentation::EnabledOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_EnabledOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnabledOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnabledOff();
    }
    else
    {
      op->vtk3DWidgetRepresentation::EnabledOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_SetReferenceBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReferenceBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetReferenceBounds(temp0);
    }
    else
    {
      op->vtk3DWidgetRepresentation::SetReferenceBounds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_PlaceWidget(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PlaceWidget");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->PlaceWidget(temp0);
    }
    else
    {
      op->vtk3DWidgetRepresentation::PlaceWidget(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
Pyvtk3DWidgetRepresentation_SetUseReferenceBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseReferenceBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtk3DWidgetRepresentation *op = static_cast<vtk3DWidgetRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseReferenceBounds(temp0);
    }
    else
    {
      op->vtk3DWidgetRepresentation::SetUseReferenceBounds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef Pyvtk3DWidgetRepresentation_Methods[] = {
  {"IsTypeOf", Pyvtk3DWidgetRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", Pyvtk3DWidgetRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", Pyvtk3DWidgetRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtk3DWidgetRepresentation\nC++: static vtk3DWidgetRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", Pyvtk3DWidgetRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtk3DWidgetRepresentation\nC++: vtk3DWidgetRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", Pyvtk3DWidgetRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", Pyvtk3DWidgetRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetWidget", Pyvtk3DWidgetRepresentation_SetWidget, METH_VARARGS,
   "SetWidget(self, __a:vtkAbstractWidget) -> None\nC++: void SetWidget(vtkAbstractWidget *)\n\nGet/Set the widget.\n"},
  {"GetWidget", Pyvtk3DWidgetRepresentation_GetWidget, METH_VARARGS,
   "GetWidget(self) -> vtkAbstractWidget\nC++: virtual vtkAbstractWidget *GetWidget()\n\n"},
  {"SetRepresentation", Pyvtk3DWidgetRepresentation_SetRepresentation, METH_VARARGS,
   "SetRepresentation(self, __a:vtkWidgetRepresentation) -> None\nC++: void SetRepresentation(vtkWidgetRepresentation *)\n\nGet/Set the representation.\n"},
  {"GetRepresentation", Pyvtk3DWidgetRepresentation_GetRepresentation, METH_VARARGS,
   "GetRepresentation(self) -> vtkWidgetRepresentation\nC++: virtual vtkWidgetRepresentation *GetRepresentation()\n\n"},
  {"SetUseNonCompositedRenderer", Pyvtk3DWidgetRepresentation_SetUseNonCompositedRenderer, METH_VARARGS,
   "SetUseNonCompositedRenderer(self, _arg:bool) -> None\nC++: virtual void SetUseNonCompositedRenderer(bool _arg)\n\nSet to true to add the vtkWidgetRepresentation to the\nnon-composited renderer. false by default.\n"},
  {"GetUseNonCompositedRenderer", Pyvtk3DWidgetRepresentation_GetUseNonCompositedRenderer, METH_VARARGS,
   "GetUseNonCompositedRenderer(self) -> bool\nC++: virtual bool GetUseNonCompositedRenderer()\n\n"},
  {"UseNonCompositedRendererOn", Pyvtk3DWidgetRepresentation_UseNonCompositedRendererOn, METH_VARARGS,
   "UseNonCompositedRendererOn(self) -> None\nC++: virtual void UseNonCompositedRendererOn()\n\n"},
  {"UseNonCompositedRendererOff", Pyvtk3DWidgetRepresentation_UseNonCompositedRendererOff, METH_VARARGS,
   "UseNonCompositedRendererOff(self) -> None\nC++: virtual void UseNonCompositedRendererOff()\n\n"},
  {"SetEnabled", Pyvtk3DWidgetRepresentation_SetEnabled, METH_VARARGS,
   "SetEnabled(self, __a:bool) -> None\nC++: void SetEnabled(bool)\n\nGet/Set whether the widget is enabled.\n"},
  {"GetEnabled", Pyvtk3DWidgetRepresentation_GetEnabled, METH_VARARGS,
   "GetEnabled(self) -> bool\nC++: virtual bool GetEnabled()\n\n"},
  {"EnabledOn", Pyvtk3DWidgetRepresentation_EnabledOn, METH_VARARGS,
   "EnabledOn(self) -> None\nC++: virtual void EnabledOn()\n\n"},
  {"EnabledOff", Pyvtk3DWidgetRepresentation_EnabledOff, METH_VARARGS,
   "EnabledOff(self) -> None\nC++: virtual void EnabledOff()\n\n"},
  {"SetReferenceBounds", Pyvtk3DWidgetRepresentation_SetReferenceBounds, METH_VARARGS,
   "SetReferenceBounds(self, bds:(float, float, float, float, float,\n    float)) -> None\nC++: void SetReferenceBounds(const double bds[6])\n\nThese are needed to support BoxWidget use-case where we want to\nsupport specification of the box using global transform or\nrelative to some reference bounds. Since this may be applicable\nto other 3D widgets that have similar requirements, we add this\nability to vtk3DWidgetRepresentation itself. All this does it\nbased on the state of UseReferenceBounds,\n`vtkWidgetRepresentation::PlaceWidget` is called using either the\n`ReferenceBounds` or the bounds passed to `PlaceWidget`.\n"},
  {"PlaceWidget", Pyvtk3DWidgetRepresentation_PlaceWidget, METH_VARARGS,
   "PlaceWidget(self, bds:(float, float, float, float, float, float))\n    -> None\nC++: void PlaceWidget(const double bds[6])\n\n"},
  {"SetUseReferenceBounds", Pyvtk3DWidgetRepresentation_SetUseReferenceBounds, METH_VARARGS,
   "SetUseReferenceBounds(self, __a:bool) -> None\nC++: void SetUseReferenceBounds(bool)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef Pyvtk3DWidgetRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("widget"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = Pyvtk3DWidgetRepresentation_GetWidget(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = Pyvtk3DWidgetRepresentation_SetWidget(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = Pyvtk3DWidgetRepresentation_SetWidget(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWidget/SetWidget\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("representation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = Pyvtk3DWidgetRepresentation_GetRepresentation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = Pyvtk3DWidgetRepresentation_SetRepresentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = Pyvtk3DWidgetRepresentation_SetRepresentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRepresentation/SetRepresentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_non_composited_renderer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = Pyvtk3DWidgetRepresentation_GetUseNonCompositedRenderer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = Pyvtk3DWidgetRepresentation_SetUseNonCompositedRenderer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = Pyvtk3DWidgetRepresentation_SetUseNonCompositedRenderer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseNonCompositedRenderer/SetUseNonCompositedRenderer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enabled"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = Pyvtk3DWidgetRepresentation_GetEnabled(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = Pyvtk3DWidgetRepresentation_SetEnabled(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = Pyvtk3DWidgetRepresentation_SetEnabled(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnabled/SetEnabled\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("reference_bounds"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = Pyvtk3DWidgetRepresentation_SetReferenceBounds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = Pyvtk3DWidgetRepresentation_SetReferenceBounds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetReferenceBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_reference_bounds"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = Pyvtk3DWidgetRepresentation_SetUseReferenceBounds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = Pyvtk3DWidgetRepresentation_SetUseReferenceBounds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseReferenceBounds\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *Pyvtk3DWidgetRepresentation_Doc =
  "vtk3DWidgetRepresentation - vtk3DWidgetRepresentation is a\nvtkDataRepresentation subclass for 3D widgets and their\nrepresentations.\n\n"
  "Superclass: vtkDataRepresentation\n\n"
  "It makes it possible to add 3D widgets to vtkPVRenderView.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject Pyvtk3DWidgetRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtk3DWidgetRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  Pyvtk3DWidgetRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *Pyvtk3DWidgetRepresentation_StaticNew()
{
  return vtk3DWidgetRepresentation::New();
}

PyObject *Pyvtk3DWidgetRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &Pyvtk3DWidgetRepresentation_Type, Pyvtk3DWidgetRepresentation_Methods,
    "vtk3DWidgetRepresentation",
 &Pyvtk3DWidgetRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataRepresentation");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, Pyvtk3DWidgetRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtk3DWidgetRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = Pyvtk3DWidgetRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtk3DWidgetRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

